from pyomo.opt import SolverFactory, SolverStatus
from pyomo.core import Var
from pyomo.core import Param
from operator import itemgetter
import pandas as pd
from datetime import datetime
import os

scenarios = ["PowCurrent", "PowMAX20",   "PowMAXLMB",  "PowMIN20",   "PowMINLMB",   
             "PowOP15",    "PowOP19",    "PowOP20",    "PowOP26",    "PowOP65",    "PowOP81",    "PowOP84",   
             "PowOP89",    "PowOP92",    "PowOP97",    "PowOP98",    "PowOP100",   "PowOP101",   "PowOP102",  
             "PowOP103",   "PowOP104",   "PowOP105",   "PowOP106",   "PowOP113",   "PowOP115",   "PowOP117",  
             "PowOP118",   "PowOP119",   "PowOP120",   "PowOP121",   "PowOP124",   "PowOP125",   "PowOP126"]

from PowNet_Laos_v1_3_model import model

for scenario in scenarios:
    
    #os.mkdir('./output/' + scenario)
    yr0 = 1996
    yr1 = 2016
    run_no = 1
    
    for yr in range(yr0, yr1+1):
        instance = model.create_instance('./input/DAT/'+scenario+'/pownet_v1_3_data_laos_'+str(yr)+'.dat')
        
        opt = SolverFactory("gurobi")
        opt.options["threads"] = 1
        #opt.options["TimeLimit"] = 5 ##in seconds #v1.3
        H = instance.HorizonHours
        K=range(1,H+1)
        start = 1 ##1 to 364
        end  = 366 #366 ##2 to 366
        
        #Space to store results
        mwh=[]
        on=[]
        switch=[]
        srsv=[]
        nrsv=[]
        hydro=[]
        hydro_import=[]
        vlt_angle=[]
        Generator=[]
        
        opt_status=[]
        opt_obj = []
        
        for day in range(start,end):
            for z in instance.d_nodes:
             #load Demand and Reserve time series data
                for i in K:
                    instance.HorizonDemand[z,i] = instance.SimDemand[z,(day-1)*24+i]
                    instance.HorizonReserves[i] = instance.SimReserves[(day-1)*24+i] 
                    
            for z in instance.h_nodes:
             #load Hydropower time series data
                for i in K:
                    instance.HorizonHydro[z,i] = instance.SimHydro[z,(day-1)*24+i]
                    
            for z in instance.h_imports:
             #load Hydropower_import time series data
                for i in K:
                    instance.HorizonHydroImport[z,i] = instance.SimHydroImport[z,(day-1)*24+i]
                    
            for z in instance.Generators:
             #load Deratef time series data ##v1.3
                for i in K:
                    instance.HorizonDeratef[z,i] = instance.SimDeratef[z,(day-1)*24+i]
                
            laos_result = opt.solve(instance, tee = False) ##,tee=True to check number of variables
            
            if laos_result.solver.status == SolverStatus.aborted: #max time limit reached #v1.3
                laos_result.solver.status = SolverStatus.warning #change status so that results can be loaded
                opt_status.append(0)
            else:
                opt_status.append(1)
            
            opt_obj.append(getattr(instance, 'SystemCost')()) #gives obj value
                
            instance.solutions.load_from(laos_result)   
         
        ###The following section is for storing and sorting results
            for v in instance.component_objects(Var, active=True):
                varobject = getattr(instance, str(v))
                a=str(v)
                if a=='mwh':
                    ini_mwh_ = {} #v1.3
                    for index in varobject:
                        if int(index[1]>0 and index[1]<25):
                            
                            if index[0] in instance.Biomass:
                                mwh.append((index[0],index[1]+((day-1)*24),varobject[index].value,'Biomass'))
                            elif index[0] in instance.Coal:
                                mwh.append((index[0],index[1]+((day-1)*24),varobject[index].value,'Coal'))                                                   
                            elif index[0] in instance.Imp_EGAT:
                                mwh.append((index[0],index[1]+((day-1)*24),varobject[index].value,'Imp_EGAT'))                          
                            elif index[0] in instance.Imp_China:
                                mwh.append((index[0],index[1]+((day-1)*24),varobject[index].value,'Imp_China'))
                            elif index[0] in instance.Slack:
                                mwh.append((index[0],index[1]+((day-1)*24),varobject[index].value,'Slack'))
                        if int(index[1])==24:
                            ini_mwh_[index[0]] = varobject[index].value   
        
                if a=='hydro':
              
                     for index in varobject:
                         if int(index[1]>0 and index[1]<25):
                            if index[0] in instance.h_nodes:
                                hydro.append((index[0],index[1]+((day-1)*24),varobject[index].value))   
                                    
        
                if a=='hydro_import':
              
                     for index in varobject:
                         if int(index[1]>0 and index[1]<25):
                            if index[0] in instance.h_imports:
                                hydro_import.append((index[0],index[1]+((day-1)*24),varobject[index].value))   
        
                if a=='vlt_angle':
              
                     for index in varobject:
                         if int(index[1]>0 and index[1]<25):
                            if index[0] in instance.nodes:
                                vlt_angle.append((index[0],index[1]+((day-1)*24),varobject[index].value))        
            
                if a=='on':        
                    ini_on_ = {} #v1.2
                    for index in varobject:
                        if int(index[1]>0 and index[1]<25):
                            on.append((index[0],index[1]+((day-1)*24),varobject[index].value))
                        if int(index[1])==24: #v1.2
                            ini_on_[index[0]] = varobject[index].value #v1.2
                    
        
                if a=='switch':  
                    for index in varobject:
                        if int(index[1]>0 and index[1]<25):
                            switch.append((index[0],index[1]+((day-1)*24),varobject[index].value))
        
        
                if a=='srsv':    
                    for index in varobject:
                        if int(index[1]>0 and index[1]<25):
                            srsv.append((index[0],index[1]+((day-1)*24),varobject[index].value))
        
                                
                if a=='nrsv':    
                    for index in varobject:
                        if int(index[1]>0 and index[1]<25):
                            nrsv.append((index[0],index[1]+((day-1)*24),varobject[index].value))
                            
            # Update initialization values for "on" #v1.2
            for z in instance.Generators:
                instance.ini_on[z] = round(ini_on_[z])
                instance.ini_mwh[z] = max(round(ini_mwh_[z],2),0) #v1.3   
        
            print(day)
            print(str(datetime.now()))
        
        mwh_pd=pd.DataFrame(mwh,columns=('Generator','Time','Value','Type'))
        hydro_pd=pd.DataFrame(hydro,columns=('Node','Time','Value'))
        hydro_import_pd=pd.DataFrame(hydro_import,columns=('Node','Time','Value'))
        vlt_angle_pd=pd.DataFrame(vlt_angle,columns=('Node','Time','Value'))
        on_pd=pd.DataFrame(on,columns=('Generator','Time','Value'))
        switch_pd=pd.DataFrame(switch,columns=('Generator','Time','Value'))
        srsv_pd=pd.DataFrame(srsv,columns=('Generator','Time','Value'))
        nrsv_pd=pd.DataFrame(nrsv,columns=('Generator','Time','Value'))
        opt_pd=pd.DataFrame({"Obj" :opt_obj, "Status":opt_status})
            
        mwh_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_mwh.csv')
        hydro_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_hydro.csv')
        hydro_import_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_hydro_import.csv')
        vlt_angle_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_vlt_angle.csv')
        on_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_on.csv')
        switch_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_switch.csv')
        srsv_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_srsv.csv')
        nrsv_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_nrsv.csv')
        opt_pd.to_csv('./output/'+scenario+'/out_laos_'+str(yr)+'_R'+str(run_no)+'_opt.csv') 
