import csv
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import os
import shutil

scenarios = ["PowCurrent", "PowMAX20",   "PowMAXLMB",  "PowMIN20",   "PowMINLMB",   
             "PowOP15",    "PowOP19",    "PowOP20",    "PowOP26",    "PowOP65",    "PowOP81",    "PowOP84",   
             "PowOP89",    "PowOP92",    "PowOP97",    "PowOP98",    "PowOP100",   "PowOP101",   "PowOP102",  
             "PowOP103",   "PowOP104",   "PowOP105",   "PowOP106",   "PowOP113",   "PowOP115",   "PowOP117",  
             "PowOP118",   "PowOP119",   "PowOP120",   "PowOP121",   "PowOP124",   "PowOP125",   "PowOP126"]
#skip PowMAXAll and PowMINAll because they are same as PowMAXLMB and PowMINLMB respectively
scenarios_sub = ["PowOP89",    "PowOP92",    "PowOP97",    "PowOP98",    "PowOP100",   "PowOP101",   "PowOP102",  
             "PowOP103",   "PowOP104",   "PowOP105",   "PowOP106",   "PowOP113",   "PowOP115",   "PowOP117",  
             "PowOP118",   "PowOP120",   "PowOP121",   "PowOP124",   "PowOP125",   "PowOP126"]
yr0 = 1996 ##simulation year (varies for climate-dependent inputs)
yr1 = 2016

for scenario in scenarios_sub:

    os.mkdir('./input/DAT/' + scenario)
    print ('Scenario:', scenario)
 
    SimDays = 365
    SimHours = SimDays * 24
    HorizonHours = 24  ##planning horizon (e.g., 24, 48, 72 hours etc.)
    TransLoss = 0.07   ##transmission loss as a percent of generation
    n1criterion = 0.75 ##maximum line-usage as a percent of line-capacity
    res_margin = 0.1   ##minimum reserve as a percent of system demand
    spin_margin = 0.50 ##minimum spinning reserve as a percent of total reserve
    
    data_name = './input/DAT/'+scenario+'/pownet_v1_3_data_laos_template'+''
    
    #read thermo plant parameters into DataFrame
    df_gen = pd.read_csv('./input/common/data_laos_thermo_2016.csv',header=0)
    df_gen['ini_on']=0 #v1.2
    df_gen['ini_mwh']=0 #v1.3
    
    ##hourly ts of load and exports
    df_load = pd.read_csv('./input/common/data_laos_load_export_2016_nexport.csv',header=0)   
    
    ##hourly ts of reserve for national demand
    df_reserves = pd.DataFrame((df_load.iloc[:,5:64].sum(axis=1)*res_margin).values,columns=['Reserve'])
    
    #capacity and susceptence of each transmission line (one direction)
    df_trans1 = pd.read_csv('./input/common/data_laos_transparam_2016.csv',header=0)
    #capacity and susceptence of each transmission line (both directions)
    df_trans2 = pd.DataFrame([df_trans1['sink'],df_trans1['source'],df_trans1['linemva'],df_trans1['linesus']]).transpose()
    df_trans2.columns = ['source','sink','linemva','linesus']
    df_paths = pd.concat([df_trans1,df_trans2], axis=0)
    df_paths.index = np.arange(len(df_paths))
    
    
    ###list nodes
    all_nodes = ['BanDon','BangYo','BanHat','BanNa','BanNathone','BMet','Bountari','BPompik',
                 'Donkoi','Hinheup','HouycaiMining','Jiangsai','Kasi','KCLCement','Khoksaad',
                 'Khonsong','LuangNamtha1','Luangprabang1','Luangprabang2','Mahaxai','MahaxaiCement',
                 'MPhin','Nahor','NakadokMinning','NaMo2','Nongbong','Nongdeun','NonHai','Oudomsay',
                 'Pakbo','Paklay','Pakmong2','Paksan','Paksong','Paktang','PhoneSoung','Phonsavan',
                 'Phontong','PhubiaMinning','Sapaothong','SeinSouk','SeponMinning','Taothan',
                 'Thabok','Thakhek','Thalath','Thanaleng','ThaNgon','Thasala','Thavieng','Tongkhoun1',
                 'Tongkhoun2','Veingkam','Viengkeo','Viengvieng','Xamneual','Xayabury','XiengNgum',
                 'Nasaithong','BanVean','NabongWest','Nabong','NaMoSwitch','HouayHo','HouayLamphan',
                 'NamKhan2','NamKhan3','NamLeuk','NamLik1n2','NamMang1','NamMang3','NamNgiep2',
                 'NamNgiep2C','NamNgiep3A','NamNgum1','NamNgum2','NamNgum5','NamOu2','NamOu5','NamOu6',
                 'NamSan3A','NamSan3B','NamSana','NamTheun2','Salabam','TheunHinboun','Xekaman1','Xekaman3',
                 'Xenamnoy1','Xenamnoy6','Xeset1','Xeset2','Xeset3','HongsaLignite','HougAnh','Mitlao',
                 'ChinMengLa','EGATBungkan','EGATMukdahan','EGATMaeMoh','EGATNongKhai','EGATUdon3',
                 'EGATNakhouPhanom','EGATSakonNakhou','EGATRoiEt2','EGATUbon2','EGATSirindhorn',
                 'VietThanhMy','VietPleiKu','CambKhampongsalao'] 
    
    h_nodes = ['HouayHo','HouayLamphan','NamKhan2','NamKhan3','NamLeuk','NamLik1n2',
               'NamMang1','NamMang3','NamNgiep2','NamNgiep2C','NamNgiep3A',
               'NamNgum1','NamNgum2','NamNgum5','NamOu2','NamOu5','NamOu6',
               'NamSan3A','NamSan3B','NamSana','NamTheun2','Salabam','TheunHinboun',
               'Xekaman1','Xekaman3','Xenamnoy1','Xenamnoy6','Xeset1','Xeset2','Xeset3']
    
    h_imports = ['EGATSirindhorn']
    
    
    d_nodes = ['BanDon','BangYo','BanHat','BanNa','BanNathone','BMet','Bountari','BPompik',
               'Donkoi','Hinheup','HouycaiMining','Jiangsai','Kasi','KCLCement','Khoksaad',
               'Khonsong','LuangNamtha1','Luangprabang1','Luangprabang2','Mahaxai','MahaxaiCement',
               'MPhin','Nahor','NakadokMinning','NaMo2','Nongbong','Nongdeun','NonHai','Oudomsay',
               'Pakbo','Paklay','Pakmong2','Paksan','Paksong','Paktang','PhoneSoung','Phonsavan',
               'Phontong','PhubiaMinning','Sapaothong','SeinSouk','SeponMinning','Taothan',
               'Thabok','Thakhek','Thalath','Thanaleng','ThaNgon','Thasala','Thavieng','Tongkhoun1',
               'Tongkhoun2','Veingkam','Viengkeo','Viengvieng','Xamneual','Xayabury','XiengNgum',
               'Nasaithong','EGATMaeMoh','EGATNongKhai','EGATUdon3','EGATNakhouPhanom','EGATSakonNakhou',
               'EGATRoiEt2','EGATUbon2','VietThanhMy','VietPleiKu','CambKhampongsalao']
    
    
    gn_nodes = ['HongsaLignite','Mitlao','HougAnh','EGATBungkan','EGATMukdahan','ChinMengLa'] ##Gen_nodes without demand
    
    gd_nodes = ['Nasaithong','EGATRoiEt2','EGATUbon2','EGATUdon3',
                'EGATNongKhai','EGATMaeMoh','EGATNakhouPhanom','EGATSakonNakhou',
                'VietPleiKu','VietThanhMy','CambKhampongsalao'] ##Gen_nodes with demand
    
    g_nodes = gn_nodes + gd_nodes ##All Thermoplant nodes 
    
    
    
    td_nodes = ['BanDon','BangYo','BanHat','BanNa','BanNathone','BMet','Bountari','BPompik',
                'Donkoi','Hinheup','HouycaiMining','Jiangsai','Kasi','KCLCement','Khoksaad',
                'Khonsong','LuangNamtha1','Luangprabang1','Luangprabang2','Mahaxai','MahaxaiCement',
                'MPhin','Nahor','NakadokMinning','NaMo2','Nongbong','Nongdeun','NonHai','Oudomsay',
                'Pakbo','Paklay','Pakmong2','Paksan','Paksong','Paktang','PhoneSoung','Phonsavan',
                'Phontong','PhubiaMinning','Sapaothong','SeinSouk','SeponMinning','Taothan',
                'Thabok','Thakhek','Thalath','Thanaleng','ThaNgon','Thasala','Thavieng','Tongkhoun1',
                'Tongkhoun2','Veingkam','Viengkeo','Viengvieng','Xamneual','Xayabury','XiengNgum'] ##Transformers with demand
    
    tn_nodes = ['BanVean','NabongWest','Nabong','NaMoSwitch'] ##Transformers without demand
    
    
    
    #list plant types
    types = ['biomass','coal','slack','imp_china','imp_egat']
    
    
    ######====== write data.dat file ======########
    with open(str(data_name)+'.dat', 'w') as f:
    
    ###### generator sets by generator nodes
        for z in g_nodes:
            # node string
            z_int = g_nodes.index(z)
            f.write('set Node%dGenerators :=\n' % (z_int+1))
            # pull relevant generators
            for gen in range(0,len(df_gen)):
                if df_gen.loc[gen,'node'] == z:
                    unit_name = df_gen.loc[gen,'name']
                    unit_name = unit_name.replace(' ','_')
                    f.write(unit_name + ' ')
            f.write(';\n\n')    
        
        
    ####### generator sets by type
        # Biomass
        f.write('set Biomass :=\n')
        # pull relevant generators
        for gen in range(0,len(df_gen)):
            if df_gen.loc[gen,'typ'] == 'biomass':
                unit_name = df_gen.loc[gen,'name']
                unit_name = unit_name.replace(' ','_')
                f.write(unit_name + ' ')
        f.write(';\n\n')    
       
        # Coal
        f.write('set Coal :=\n')
        # pull relevant generators
        for gen in range(0,len(df_gen)):
            if df_gen.loc[gen,'typ'] == 'coal':
                unit_name = df_gen.loc[gen,'name']
                unit_name = unit_name.replace(' ','_')
                f.write(unit_name + ' ')
        f.write(';\n\n')        
    
        # Import from China
        f.write('set Imp_China :=\n')
        # pull relevant generators
        for gen in range(0,len(df_gen)):
            if df_gen.loc[gen,'typ'] == 'imp_china':
                unit_name = df_gen.loc[gen,'name']
                unit_name = unit_name.replace(' ','_')
                f.write(unit_name + ' ')
        f.write(';\n\n')  
    
        # Import from Thai_EGAT
        f.write('set Imp_EGAT :=\n')
        # pull relevant generators
        for gen in range(0,len(df_gen)):
            if df_gen.loc[gen,'typ'] == 'imp_egat':
                unit_name = df_gen.loc[gen,'name']
                unit_name = unit_name.replace(' ','_')
                f.write(unit_name + ' ')
        f.write(';\n\n')  
    
    
        # Slack
        f.write('set Slack :=\n')
        # pull relevant generators
        for gen in range(0,len(df_gen)):
            if df_gen.loc[gen,'typ'] == 'slack':
                unit_name = df_gen.loc[gen,'name']
                unit_name = unit_name.replace(' ','_')
                f.write(unit_name + ' ')
        f.write(';\n\n')  
    
    ######Set nodes, sources and sinks
        # nodes
        f.write('set nodes :=\n')
        for z in all_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
        
        # sources
        f.write('set sources :=\n')
        for z in all_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
        
        # sinks
        f.write('set sinks :=\n')
        for z in all_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # hydro_nodes
        f.write('set h_nodes :=\n')
        for z in h_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # hydro_imports nodes
        f.write('set h_imports :=\n')
        for z in h_imports:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # all demand nodes
        f.write('set d_nodes :=\n')
        for z in d_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # generator with demand nodes
        f.write('set gd_nodes :=\n')
        for z in gd_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # generator without demand nodes
        f.write('set gn_nodes :=\n')
        for z in gn_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # transformer with demand nodes
        f.write('set td_nodes :=\n')
        for z in td_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        # transformer without demand nodes
        f.write('set tn_nodes :=\n')
        for z in tn_nodes:
            f.write(z + ' ')
        f.write(';\n\n')
    
        
    ################
    #  parameters  #
    ################
        
    ####### simulation period and horizon
        f.write('param SimHours := %d;' % SimHours)
        f.write('\n')
        f.write('param SimDays:= %d;' % SimDays)
        f.write('\n\n')   
        f.write('param HorizonHours := %d;' % HorizonHours)
        f.write('\n\n')
        f.write('param TransLoss := %0.3f;' % TransLoss)
        f.write('\n\n')
        f.write('param n1criterion := %0.3f;' % n1criterion)
        f.write('\n\n')
        f.write('param spin_margin := %0.3f;' % spin_margin)
        f.write('\n\n')
    
        
    ####### create parameter matrix for generators
        f.write('param:' + '\t')
        for c in df_gen.columns:
            if c != 'name':
                f.write(c + '\t')
        f.write(':=\n\n')
        for i in range(0,len(df_gen)):    
            for c in df_gen.columns:
                if c == 'name':
                    unit_name = df_gen.loc[i,'name']
                    unit_name = unit_name.replace(' ','_')
                    f.write(unit_name + '\t')  
                else:
                    f.write(str((df_gen.loc[i,c])) + '\t')               
            f.write('\n')
        f.write(';\n\n')     
    
    ####### create parameter matrix for transmission paths (source and sink connections)
        f.write('param:' + '\t' + 'linemva' + '\t' +'linesus :=' + '\n')
        for z in all_nodes:
            for x in all_nodes:           
                f.write(z + '\t' + x + '\t')
                match = 0
                for p in range(0,len(df_paths)):
                    source = df_paths.loc[p,'source']
                    sink = df_paths.loc[p,'sink']
                    if source == z and sink == x:
                        match = 1
                        p_match = p
                if match > 0:
                    f.write(str(df_paths.loc[p_match,'linemva']) + '\t' + str(df_paths.loc[p_match,'linesus']) + '\n')
                else:
                    f.write('0' + '\t' + '0' + '\n')
        f.write(';\n\n')
    
        
    ###### System wide hourly reserve
        f.write('param' + '\t' + 'SimReserves:=' + '\n')
        for h in range(0,len(df_load)):
                f.write(str(h+1) + '\t' + str(df_reserves.loc[h,'Reserve']) + '\n')
        f.write(';\n\n')
        
    for curr_year in range(yr0, yr1+1):
        
        ##name of pownet datafile
        data_name_yr = './input/DAT/'+scenario+ '/pownet_v1_3_data_laos_'+str(curr_year)+''
    
        shutil.copy(''+str(data_name)+'.dat', ''+str(data_name_yr)+'.dat')
        
        ###### Variables that are different based on year
        df_gen_deratef = pd.read_csv('./input/common/derate/data_laos_thermo_deratef_'+str(curr_year)+'.csv',header=0) ##v1.3
        #df_gen['deratef'] = df_gen_deratef['deratef_'+str(curr_year)+''] ##v1.3 (comment out)
        gen_units = list(df_gen_deratef.columns[4:]) ##v1.3
        
        ##hourly ts of hydropower
        df_hydro = pd.read_csv('./input/'+scenario+'/data_laos_hydro_'+str(curr_year)+'.csv',header=0)   
        
        ##hourly ts of hydropower import
        df_hydro_import = pd.read_csv('./input/common/hydro_import/data_laos_hydro_import_'+str(curr_year)+'.csv',header=0)
        
        #########======Prepare Load Data with Hydropower Exports =============#########
        hyd_dir = ['NamNgum2','TheunHinboun','NamTheun2','Xekaman1','Xekaman3']
        
        exp_dir = ['EGATUdon3','EGATSakonNakhou','EGATRoiEt2', 'VietPleiKu', 'VietThanhMy']
        
        #exp_dir_2016 = [2155.2,2530.9,5990.5,371.2,381.8,868.2]
        ####Create export data for direct exports
        # for i in range(len(hyd_dir)):
        #     df_load[exp_dir[i]] = df_hydro[hyd_dir[i]] * (exp_dir_2016[i]*1000/sum(df_hydro[hyd_dir[i]]))
        # ####Add Export from Xeset system to Ubon2 Export data
        # df_load['EGATUbon2'] = df_load['EGATUbon2'] + df_load_EGATXeset['EGATXeset_Ubon2']
        
        exp_ratio = [1.0,1.0,0.93,1.0,0.90] ###source: Lao Energy report 2015
        
        for i in range(len(hyd_dir)):
            df_load[exp_dir[i]] = df_hydro[hyd_dir[i]] * exp_ratio[i] * (1-TransLoss)
        
        ####Export to Ubon2 includes 99% of HouayHo and 47% of Xeset_1 and Xeset_2
        df_load['EGATUbon2'] = (df_hydro['HouayHo']*0.99 + (df_hydro['Xeset1']+df_hydro['Xeset2'])*0.47) * (1-TransLoss)
        
        ####Export to NongKhai includes 100% of NamNgum1, NamLeuk, and NamMang3
        df_load['EGATNongKhai'] = (df_hydro['NamNgum1']+df_hydro['NamLeuk']+df_hydro['NamMang3'])*1.0 * (1-TransLoss)
        
        ##checks
        exp_by_nodes = df_load.iloc[:,64:].sum()/1000
        total_exp = sum(exp_by_nodes)
        
        ##exp_by_nodes,total_exp
        
        ########====== write data.dat file ======########
        with open(''+str(data_name_yr)+'.dat', 'a') as f:
            ####### Hourly load and hydro
            # load (hourly)
            f.write('param:' + '\t' + 'SimDemand:=' + '\n')      
            for z in d_nodes:
                for h in range(0,len(df_load)): 
                    f.write(z + '\t' + str(h+1) + '\t' + str(df_load.loc[h,z]) + '\n')
            f.write(';\n\n')
        
            # hydro (hourly)
            f.write('param:' + '\t' + 'SimHydro:=' + '\n')      
            for z in h_nodes:
                for h in range(0,len(df_hydro)): 
                    f.write(z + '\t' + str(h+1) + '\t' + str(df_hydro.loc[h,z]) + '\n')
            f.write(';\n\n')
        
            # hydro (hourly)
            f.write('param:' + '\t' + 'SimHydroImport:=' + '\n')      
            for z in h_imports:
                for h in range(0,len(df_hydro_import)): 
                    f.write(z + '\t' + str(h+1) + '\t' + str(df_hydro_import.loc[h,z]) + '\n')
            f.write(';\n\n')
            
            # Deratef (hourly) ##v1.3
            f.write('param:' + '\t' + 'SimDeratef:=' + '\n')      
            for z in gen_units:
                for h in range(0,len(df_gen_deratef)): 
                    f.write(z + '\t' + str(h+1) + '\t' + str(df_gen_deratef.loc[h,z]) + '\n')
            f.write(';\n\n')
        
        print ('Hongsa derate:', round(df_gen_deratef.sum(axis=0)[4]/(SimDays*24),2), 
               'NamNgiep2C mwh:', round(df_hydro.sum(axis=0)[5]), #different across scenarios
               'EGATSiri import mwh', round(df_hydro_import.sum(axis=0)[4])) #check different every year
        
        print ('OK',curr_year)
