* #### CODE MERGED WITH FUNCTION gms::singleGAMSfile ####

*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

$title magpie

*' @title MAgPIE - Modelling Framework
*'
*' @description The *Model of Agricultural Production and its Impact on the
*' Environment* (MAgPIE) is developed and used to assess the competition for
*' land and water and the associated consequences for sustainable development
*' under future scenarios of rising food, energy and material demand as well
*' as production, climate change impacts and greenhouse gas mitigation and
*' different land related policies (@dietrich_magpie4).
*'
*' MAgPIE is a global partial equilibrium model of the land-use sector that operates
*' in a recursive dynamic mode and incorporates spatially explicit information on
*' biophysical constraints into an economic decision making process (@lotze-campen_global_2008).
*' It takes regional economic conditions such as elastic demand for agricultural commodities,
*' technological development and production costs as well as spatially explicit data on biophysical
*' constraints into account. Geographically explicit data on biophysical conditions are provided
*' by the Lund-Potsdam-Jena managed land model (LPJmL) (@bondeau_lpjml_2007, @mueller_projecting_2014)
*' on a 0.5 degree resolution and include e.g. carbon densities of different vegetation types,
*' agricultural productivity such as crop yields and water availability for irrigation. Based on
*' the strong interaction with LPJmL, MAgPIE can also help to assess the consequences of climate
*' change and increased CO2 in the atmosphere on the land-use sector (@stevanovic_impact_2016)
*'
*' Available land types in MAgPIE are cropland, pasture area, forest, other land
*' (including non-forest natural vegetation, abandoned agricultural land and deserts)
*' and settlements. Cropland (rainfed and irrigated), pasture, forest and other land
*' are endogenously determined, while settlement areas are assumed to be constant over time.
*' The cropland covers cultivation of different crop types (e.g. temperate and tropical
*' cereals, maize, rice, oilseeds, roots), both rainfed and irrigated systems, and two
*' 2nd generation bioenergy crop types (grassy and woody).
*'
*' Taking into account international trade based on historical trade patterns and economic
*' competitiveness ([21_trade]), global production has to meet demand for food,
*' feed, seed, processing, bioenergy and material demand ([16_demand]). Food demand is
*' derived based on population growth ([09_drivers]) and dietary transitions, accounting
*' for changes in intake and food waste, the shift in the share of animal calories,
*' processed products, fruits and vegetables as well as staples ([15_food]).
*' Primary products can be processed to secondary products such as sugar, oil
*' or ethanol ([20_processing]). The quantity of livestock production in
*' combination with dynamic regional and livestock-specific feed baskets determines the
*' demand for feed ([70_livestock]). The supply of animal-based food commodities is divided into five livestock production
*' activities (ruminant meat, pig meat, poultry meat, eggs and milk) (@weindl_livestock_2017-1).
*' The spatial distribution of crops ([30_crop]), livestock ([71_disagg_lvst])
*' and pasture ([31_past]) in MAgPIE is guided by geographically explicit
*' information on vegetation growth and the balance between crop water
*' demand and water availability, by initial land cover distribution maps
*' as well as by economic conditions like trade barriers ([21_trade]), management intensity ([13_tc])
*' and transport costs ([40_transport]). It therefore integrates information about market access into
*' the model's optimization process that determines where cropping activities and livestock production
*' are allocated to. Parts of forests and other natural land area can be excluded from conversion into
*' agricultural land if designated for wood production or located in protected areas ([32_forestry],
*' [35_natveg]) (@kreidenweis_pasture_2018).
*'
*' Due to computational constraints, all model inputs in 0.5 degree resolution are aggregated
*' to simulation units for the optimization process ([80_optimization]) based on a clustering
*' algorithm (@dietrich_reducing_2013).
*'
*' MAgPIE estimates flows of different land-based greenhouse gases (GHGs). CO2 emissions are computed
*' from land-use change dynamics, i.e. from conversion of different biomes into agricultural land
*' and consequent loss of terrestrial carbon stocks (@popp_land-use_2014), also including the
*' depletion of organic matter in soils ([59_som]). The land also serves as a sink for atmospheric
*' carbon when agricultural land is set aside from production and the associated regrowth of natural
*' vegetation generates negative emissions from land-use change.
*' Nitrogen emissions ([51_nitrogen]) are estimated based on nitrogen budgets for croplands,
*' pastures ([50_nr_budgets]) and the livestock sector ([55_awms]) (@bodirsky_reactive_2014).
*' CH4 emissions are based on
*' livestock feed and rice cultivation areas (@popp_food_2010). In the case of mitigation
*' policies for the land sector, the model can reduce CO2 emissions by restraining land-use
*' conversion and consequent carbon release as well as CH4 and N emissions by applying improved
*' agricultural management (such as anaerobic digesters for CH4 capture from animal waste, or use
*' of fertilizer spreaders) (@popp_land-use_2014, @stevanovic_mitigation_2017). In addition,
*' the model covers land-based carbon removal technologies such as bioenergy with carbon capture
*' and sequestration (CCS) and afforestation (@humpenoder_investigating_2014,
*' @humpenoeder_bioenergy_2018, @kreidenweis_afforestation_2016).
*'
*' In response to all involved demand for agricultural commodities, costs of production,
*' biophysical constraints and land-related policies, MAgPIE simulates major dynamics of
*' the land-use sector like investments in research and development (R&D) ([13_tc]) (@dietrich_forecasting_2014)
*' and associated increases in both crop yields  ([14_yields]) and biomass removal through grazing on
*' pastures ([31_past]), land use change ([39_landconversion]), interregional trade flows ([21_trade]),
*' and irrigation ([41_area_equipped_for_irrigation]).
*'
*' The MAgPIE GAMS code folllows the coding etiquette as described below.
*'
*' Use the following prefixes:
*'
*'  *  q_ eQuations
*'  *  v_ Variables
*'  *  s_ Scalars
*'  *  f_ File parameters - these parameters contain data as it was read from file
*'  *  i_ Input parameters - influencing the optimzation but are not influenced by it
*'  *  p_ Processing parameters - influencing optimization and are being influenced by it
*'  *  o_ Output parameters - only being influenced by optimization but without effect on the optimization
*'  *  x_ eXtremely important output parameters - output parameters, that are necessary for the model to run properly (required by external postprocessing). They must not be removed.
*'  *  c_ switches from the Config.gms - parameters, that are switches to choose different scenarios
*'  *  m_ Macros
*'
*' The prefixes have to be extended in some cases by a second letter
*'
*'  * ?m_ module-relevant object - This object is used by at least one module and the core code. Changes related to this object have to be performed carefully.
*'  * ?00_ (a 2-digit number) module-only object This 2-digit number defines the module the object belongs to. The number is used here to make sure that different modules cannot have the same object
*'
*' Sets
*'
*' Sets are treated slightly different: Instead of adding a prefix sets should get a 2-digit number suffix giving the number
*' of the module in which the set is exclusively used. If the set is used in more than one module no suffix should be given.
*'
*' The prefixes have to be extended by a second letter in some more cases
*'
*'  * ?c_ value for the Current timestep - necessary for constraints. Each *c_-object must have a time-depending counterpart
*'  * ?q_ parameter containing the values of an equation
*'  * ?v_ parameter containing the values of a variable
*'
*' Besides prefixes also suffixes should be used. Suffixes should indicate the level of aggregation of an object:
*'
*'  * (no suffix) highest disaggregation available
*'  * _(setname) aggregation over set
*'  * _reg regional aggregation (exception)
*'  * _glo global aggregation (exception)
*'
*' Units
*'
*'  * Document units at the location of the variable declaration
*'  * Use units that lead to variable values in the range of 0.01 to 100. Keep the option of scaling in mind.
*'  * Use only MAgPIE standard units in GAMS code 10^6, 10^6 ha, 10^6 tDM, 10^6 PJ, 10^6 USD, 10^6 m3
*'  * Make sure that your inputs already have the right unit
*'
*' Input files
*'
*'  * Input file names must be unique, because input files will be downloaded from a data repository and extracted to the same folder so that different files with the same file name would overwrite each other.
*'  * Do not add input files to the git repository. Input files should be copied instead to one of the existing data repositories from which the data is downloaded by the model.
*'
*' Postprocessing
*'
*'  * Processing of model outputs is managed in the corresponding magpie R package (e.g. package "magpie4" for MAgPIE version 4.x).
*'  * If you change something in the GAMS code make sure that all function in the corresponding magpie R package still work and adapt them if necessary to the new model structure.
*'  * When performing modifications in a magpie R package make sure that these changes are downwards compatible.
*'  * Always try to access model outputs through the corresponding magpie package instead of accessing them directly with readGDX. It cannot be guaranteed that your script will work in the future if you do otherwise (as only the corresponding magpie package will be continuously adapted to changes in the GAMS code).

*##################### R SECTION START (VERSION INFO) ##########################
* 
* Used data set: isimip_rcp-IPSL_CM5A_LR-rcp2p6-co2_rev52_c200_690d3718e151be1b450b394c1064b1c5.tgz
* md5sum: b115c870fd204b86d32b5ed664c2d00f
* Repository: /p/projects/rd3mod/mirror/rse.pik-potsdam.de/data/magpie/public
* 
* Used data set: rev4.58_h12_magpie.tgz
* md5sum: b724f1cb10bedf71ac07f41e0735bf63
* Repository: /p/projects/rd3mod/mirror/rse.pik-potsdam.de/data/magpie/public
* 
* Used data set: rev4.58_h12_validation.tgz
* md5sum: 7b4729bea4aca11ba372918d6422d590
* Repository: /p/projects/rd3mod/mirror/rse.pik-potsdam.de/data/magpie/public
* 
* Used data set: calibration_H12_c200_23Feb21.tgz
* md5sum: 8c013375008a959aaa0023030f53c2c2
* Repository: /p/projects/rd3mod/mirror/rse.pik-potsdam.de/data/magpie/public
* 
* Used data set: additional_data_rev4.00.tgz
* md5sum: 0d25d76eb2e080c8d42f92265b05bbfc
* Repository: /p/projects/rd3mod/mirror/rse.pik-potsdam.de/data/magpie/public
* 
* Low resolution: c200
* High resolution: 0.5
* 
* Total number of cells: 200
* 
* Number of cells per region:
*   CAZ  CHA  EUR  IND  JPN  LAM  MEA  NEU  OAS  REF  SSA  USA
*    28   24   10    7    3   53   17    8   22    7   11   10
* 
* Regionscode: 690d3718e151be1b450b394c1064b1c5
* 
* Regions data revision: 4.58
* 
* lpj2magpie settings:
* * LPJmL data folder: /p/projects/landuse/data/input/lpj_input/isimip_rcp/IPSL_CM5A_LR/rcp2p6/co2
* * Additional input folder: /p/projects/landuse/data/input/other/rev52
* * Revision: 52
* * Call: lpj2magpie(input_folder = path(cfg$lpj_input_folder, gsub("-",     "/", cfg$input)), input2_folder = path(cfg$additional_input_folder,     paste("rev", floor(cfg$revision), sep = "")), output_file = lpj2magpie_file,     rev = cfg$revision)
* 
* aggregation settings:
* * Input resolution: 0.5
* * Output resolution: c200
* * Input file: /p/projects/landuse/data/input/archive/isimip_rcp-IPSL_CM5A_LR-rcp2p6-co2_rev52_0.5.tgz
* * Output file: /p/projects/landuse/data/input/archive/isimip_rcp-IPSL_CM5A_LR-rcp2p6-co2_rev52_c200_690d3718e151be1b450b394c1064b1c5.tgz
* * Regionscode: 690d3718e151be1b450b394c1064b1c5
* * (clustering) n-repeat: 5
* * (clustering) n-redistribute: 0
* * Call: aggregation(input_file = lpj2magpie_file, regionmapping = paste0("../",     cfg$regionmapping), output_file = aggregation_file, rev = cfg$revision,     res_high = cfg$high_res, res_low = cfg$low_res, hcells = cfg$highres_cells,     weight = cfg$cluster_weight, nrepeat = cfg$nrepeat, nredistribute = cfg$nredistribute,     sum_spam_file = cfg$spamfile, debug = FALSE, seed = cfg$seed)
* 
* 
* 
* Last modification (input data): Sun Oct  3 11:49:03 2021
* 
*###################### R SECTION END (VERSION INFO) ###########################

$offupper
$offsymxref
$offsymlist
$offlisting

********************************************************************************
*** WARNING **** WARNING **** WARNING **** WARNING **** WARNING **** WARNING ***
********************************************************************************

* PLEASE DO NOT PERFORM ANY CHANGES HERE! ALL SETTINGS WILL BE AUTOMATICALLY
* SET BY MAGPIE_START.R BASED ON THE SETTINGS OF THE CORRESPONDING CFG FILE
* PLEASE DO ALL SETTINGS IN THE CORRESPONDING CFG FILE (e.g. config/default.cfg)

********************************************************************************
*** WARNING **** WARNING **** WARNING **** WARNING **** WARNING **** WARNING ***
********************************************************************************

**************************MODEL SPECIFIC SCALARS********************************
*                    Key parameters during model runs

$setglobal c_timesteps  coup2100
$setglobal c_past  till_2010
$setglobal c_title  SCP44_SSP2-Ref-MP80

scalars
s_use_gdx   use of gdx files                                       / 2 /
;
********************************************************************************

*******************************MODULE SETUP*************************************

$setglobal drivers  aug17
$setglobal land  landmatrix_dec18
$setglobal costs  default
$setglobal interest_rate  select_apr20
$setglobal tc  endo_jun18
$setglobal yields  dynamic_aug18

$setglobal food  anthropometrics_jan18
$setglobal demand  sector_may15
$setglobal production  flexreg_apr16

$setglobal residues  flexreg_apr16
$setglobal processing  substitution_dec18

$setglobal trade  selfsuff_reduced

$setglobal ageclass  feb21

$setglobal crop  endo_jun13
$setglobal past  endo_jun13

$setglobal forestry  dynamic_feb21

$setglobal urban  static
$setglobal natveg  dynamic_feb21

$setglobal factor_costs  mixed_feb17
$setglobal landconversion  global_static_aug18

$setglobal transport  gtap_nov12
$setglobal area_equipped_for_irrigation  endo_apr13
$setglobal water_demand  agr_sector_aug13
$setglobal water_availability  total_water_aug13
$setglobal biodiversity  bv_btc_mar21
$setglobal climate  static

$setglobal nr_soil_budget  exoeff_aug16
$setglobal nitrogen  ipcc2006_sep16
$setglobal carbon  normal_dec17
$setglobal methane  ipcc2006_flexreg_apr16
$setglobal phosphorus  off
$setglobal awms  ipcc2006_aug16
$setglobal ghg_policy  price_jan20
$setglobal maccs  on_sep16
$setglobal peatland  off
$setglobal som  static_jan19

$setglobal bioenergy  1stgen_priced_dec18
$setglobal material  exo_flexreg_apr16
$setglobal livestock  fbask_jan16

$setglobal disagg_lvst  foragebased_aug18

$setglobal timber  default

$setglobal optimization  nlp_apr17

****************************END MODULE SETUP************************************

***************************PREDEFINED MACROS************************************
*$include "./core/macros.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*****************************Technical macros***********************************

* Macro for fixing a variable in the case that lower and upper bound are too
* close to each other (closer than argument "sens")
* EXAMPLE: ma_boundfix(vm_land,(j,"ifft"),up,10e-5);
$macro m_boundfix(x,arg,sufx,sens) x.fx arg$(x.up arg-x.lo arg<sens) = x.sufx arg;

$macro m_weightedmean(x,w,s) (sum(s,x*w)/sum(s,w))$(sum(s,w)>0) + 0$(sum(s,w)<=0);

$macro m_growth_vegc(S,A,k,m,ac) S + (A-S)*(1-exp(-k*(ac*5)))**m;

$macro m_growth_litc_soilc(start,end,ac) (start + (end - start) * 1/20 * ac*5)$(ac <= 20/5) + end$(ac > 20/5);

* annuity factor (annuity) for converting the present value (P) of an investment to a repeating annual payment (A): A = P/annuity
* ordinary annuity: cash flow at the end of the period (currently only used for carbon emissions costs as they can become negative (~reward) in case of afforestation)
* https://en.wikipedia.org/wiki/Time_value_of_money (row 4; find A given P)
$macro m_annuity_ord(interest_rate,time_horizon) ((1+interest_rate)**(time_horizon)-1)/(interest_rate*(1+interest_rate)**(time_horizon));

* annuity due: cash flow at the beginning of the period (used for TC, land conversion and irrigation infrastructure costs)
* [Jordan et al (2000,p164-165)] Jordan, Bradford D.; Ross, Stephen David; Westerfield, Randolph (2000). Fundamentals of corporate finance. Boston: Irwin/McGraw-Hill.
* m_annuity_due = m_annuity_ord * (1 + interest_rate)
* http://www.frickcpa.com/tvom/tvom_annuity_due.asp
$macro m_annuity_due(interest_rate,time_horizon) (1-(1+interest_rate)**(-time_horizon))/((interest_rate)/(1+interest_rate));

* returns the year for subsets of time_annual.
* ATTENTION: first year of time_annual needs to be hardcoded here (no possibility
*            to extract it from set). If this changes you have to change
*            it here as well!
$macro m_year(t) (sum(time_annual,ord(time_annual)$sameas(t,time_annual)) + 1964)

* calculates the difference in years to the previous time step and
* sets the difference for the first time step to one.
$macro m_yeardiff(t) (1$(ord(t)=1) + (m_year(t)-m_year(t-1))$(ord(t)>1))

* calculates the difference in years to the previous time step and
* sets the difference for the first time step to five.
$macro m_yeardiff_forestry(t) (5$(ord(t)=1) + (m_year(t)-m_year(t-1))$(ord(t)>1))

* same as m_yeardiff but only for the current time step and written in a way
* that it can be used within equations (no t dependency)
* ATTENTION: t2 needs to exist as alias of t to get this macro working!
* ATTENTION: ct needs to exist as set containing only the current time step
$macro m_timestep_length sum((ct,t2),(1$(ord(t2)=1) + (m_year(t2)-m_year(t2-1))$(ord(t2)>1))$sameas(ct,t2))

* same as m_yeardiff but only for the current time step and written in a way
* that it can be used within equations (no t dependency)
* ATTENTION: t2 needs to exist as alias of t to get this macro working!
* ATTENTION: ct needs to exist as set containing only the current time step
$macro m_timestep_length_forestry sum((ct,t2),(5$(ord(t2)=1) + (m_year(t2)-m_year(t2-1))$(ord(t2)>1))$sameas(ct,t2))

* update total costs by distribute annuity costs over all years within the given time horizon
$macro m_annuity_costs_update(past_costs, cost_annuity, invest_horizon) past_costs = past_costs \
            + cost_annuity$(m_year(t2) > m_year(t) AND m_year(t2) <= m_year(t) + invest_horizon) \
            + (m_year(t) + invest_horizon - m_year(t2-1))/m_yeardiff(t2)*cost_annuity$(m_year(t2) > m_year(t) AND m_year(t2-1) < m_year(t) + invest_horizon AND m_year(t2) > m_year(t) + invest_horizon);


* fill empty years with values from previous time step
* input = name of input parameter
* sets = all sets except of t_all written in quotes (e.g. "kve,w")
$macro m_fillmissingyears(input,sets) loop(t_all, \
          ct_all(t_all) = yes;     \
          if(sum((ct_all,&&sets),input(ct_all,&&sets))=0,    \
            input(t_all,&&sets) = input(t_all-1,&&sets);    \
            display "Data gap in input filled with data from previous time step for the following year: ",ct_all;    \
          ); \
          ct_all(t_all) = no;    \
       );
********************************************************************************

***************************BASIC SETS INDICES***********************************
*$include "./core/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*************************BASIC SETS (INDICES)***********************************

*###############################################################################
*######################## R SECTION START (SETS) ###############################
*THIS CODE IS CREATED AUTOMATICALLY, DO NOT MODIFY THESE LINES DIRECTLY
*ANY DIRECT MODIFICATION WILL BE LOST AFTER NEXT INPUT DOWNLOAD
*CHANGES CAN BE DONE USING THE INPUT DOWNLOADER UNDER SCRIPTS/DOWNLOAD
*THERE YOU CAN ALSO FIND ADDITIONAL INFORMATION

sets

   i all economic regions /
       CAZ,CHA,EUR,IND,JPN,LAM,MEA,NEU,OAS,REF,SSA,USA /

   iso list of iso countries /
       ABW,AFG,AGO,AIA,ALA,ALB,AND,ARE,ARG,ARM,
       ASM,ATA,ATF,ATG,AUS,AUT,AZE,BDI,BEL,BEN,
       BES,BFA,BGD,BGR,BHR,BHS,BIH,BLM,BLR,BLZ,
       BMU,BOL,BRA,BRB,BRN,BTN,BVT,BWA,CAF,CAN,
       CCK,CHN,CHE,CHL,CIV,CMR,COD,COG,COK,COL,
       COM,CPV,CRI,CUB,CUW,CXR,CYM,CYP,CZE,DEU,
       DJI,DMA,DNK,DOM,DZA,ECU,EGY,ERI,ESH,ESP,
       EST,ETH,FIN,FJI,FLK,FRA,FRO,FSM,GAB,GBR,
       GEO,GGY,GHA,GIB,GIN,GLP,GMB,GNB,GNQ,GRC,
       GRD,GRL,GTM,GUF,GUM,GUY,HKG,HMD,HND,HRV,
       HTI,HUN,IDN,IMN,IND,IOT,IRL,IRN,IRQ,ISL,
       ISR,ITA,JAM,JEY,JOR,JPN,KAZ,KEN,KGZ,KHM,
       KIR,KNA,KOR,KWT,LAO,LBN,LBR,LBY,LCA,LIE,
       LKA,LSO,LTU,LUX,LVA,MAC,MAF,MAR,MCO,MDA,
       MDG,MDV,MEX,MHL,MKD,MLI,MLT,MMR,MNE,MNG,
       MNP,MOZ,MRT,MSR,MTQ,MUS,MWI,MYS,MYT,NAM,
       NCL,NER,NFK,NGA,NIC,NIU,NLD,NOR,NPL,NRU,
       NZL,OMN,PAK,PAN,PCN,PER,PHL,PLW,PNG,POL,
       PRI,PRK,PRT,PRY,PSE,PYF,QAT,REU,ROU,RUS,
       RWA,SAU,SDN,SEN,SGP,SGS,SHN,SJM,SLB,SLE,
       SLV,SMR,SOM,SPM,SRB,SSD,STP,SUR,SVK,SVN,
       SWE,SWZ,SXM,SYC,SYR,TCA,TCD,TGO,THA,TJK,
       TKL,TKM,TLS,TON,TTO,TUN,TUR,TUV,TWN,TZA,
       UGA,UKR,UMI,URY,USA,UZB,VAT,VCT,VEN,VGB,
       VIR,VNM,VUT,WLF,WSM,YEM,ZAF,ZMB,ZWE /

   j number of LPJ cells /
       CAZ_1*CAZ_28,
       CHA_29*CHA_52,
       EUR_53*EUR_62,
       IND_63*IND_69,
       JPN_70*JPN_72,
       LAM_73*LAM_125,
       MEA_126*MEA_142,
       NEU_143*NEU_150,
       OAS_151*OAS_172,
       REF_173*REF_179,
       SSA_180*SSA_190,
       USA_191*USA_200 /

   cell(i,j) number of LPJ cells per region i /
       CAZ . CAZ_1*CAZ_28
       CHA . CHA_29*CHA_52
       EUR . EUR_53*EUR_62
       IND . IND_63*IND_69
       JPN . JPN_70*JPN_72
       LAM . LAM_73*LAM_125
       MEA . MEA_126*MEA_142
       NEU . NEU_143*NEU_150
       OAS . OAS_151*OAS_172
       REF . REF_173*REF_179
       SSA . SSA_180*SSA_190
       USA . USA_191*USA_200 /

   i_to_iso(i,iso) mapping regions to iso countries /
       CAZ . (AUS,CAN,HMD,NZL,SPM)
       CHA . (CHN,HKG,MAC,TWN)
       EUR . (ALA,AUT,BEL,BGR,CYP,CZE,DEU,DNK,ESP,EST)
       EUR . (FIN,FRA,FRO,GBR,GGY,GIB,GRC,HRV,HUN,IMN)
       EUR . (IRL,ITA,JEY,LTU,LUX,LVA,MLT,NLD,POL,PRT)
       EUR . (ROU,SVK,SVN,SWE)
       IND . (IND)
       JPN . (JPN)
       LAM . (ABW,AIA,ARG,ATA,ATG,BES,BHS,BLM,BLZ,BMU)
       LAM . (BOL,BRA,BRB,BVT,CHL,COL,CRI,CUB,CUW,CYM)
       LAM . (DMA,DOM,ECU,FLK,GLP,GRD,GTM,GUF,GUY,HND)
       LAM . (HTI,JAM,KNA,LCA,MAF,MEX,MSR,MTQ,NIC,PAN)
       LAM . (PER,PRI,PRY,SGS,SLV,SUR,SXM,TCA,TTO,URY)
       LAM . (VCT,VEN,VGB,VIR)
       MEA . (ARE,BHR,DZA,EGY,ESH,IRN,IRQ,ISR,JOR,KWT)
       MEA . (LBN,LBY,MAR,OMN,PSE,QAT,SAU,SDN,SYR,TUN)
       MEA . (YEM)
       NEU . (ALB,AND,BIH,CHE,GRL,ISL,LIE,MCO,MKD,MNE)
       NEU . (NOR,SJM,SMR,SRB,TUR,VAT)
       OAS . (AFG,ASM,ATF,BGD,BRN,BTN,CCK,COK,CXR,FJI)
       OAS . (FSM,GUM,IDN,IOT,KHM,KIR,KOR,LAO,LKA,MDV)
       OAS . (MHL,MMR,MNG,MNP,MYS,NCL,NFK,NIU,NPL,NRU)
       OAS . (PAK,PCN,PHL,PLW,PNG,PRK,PYF,SGP,SLB,THA)
       OAS . (TKL,TLS,TON,TUV,UMI,VNM,VUT,WLF,WSM)
       REF . (ARM,AZE,BLR,GEO,KAZ,KGZ,MDA,RUS,TJK,TKM)
       REF . (UKR,UZB)
       SSA . (AGO,BDI,BEN,BFA,BWA,CAF,CIV,CMR,COD,COG)
       SSA . (COM,CPV,DJI,ERI,ETH,GAB,GHA,GIN,GMB,GNB)
       SSA . (GNQ,KEN,LBR,LSO,MDG,MLI,MOZ,MRT,MUS,MWI)
       SSA . (MYT,NAM,NER,NGA,REU,RWA,SEN,SHN,SLE,SOM)
       SSA . (SSD,STP,SWZ,SYC,TCD,TGO,TZA,UGA,ZAF,ZMB)
       SSA . (ZWE)
       USA . (USA) /

;
*######################### R SECTION END (SETS) ################################
*###############################################################################

sets
        i2(i) World regions (dynamic set)
        j2(j) Spatial Clusters (dynamic set)
;
i2(i) = yes;
j2(j) = yes;

sets
        c_title defined to include c_title in GDX
        / %c_title% /
;

***TIME STEPS***
* ATTENTION: check macros m_year and m_yeardiff if you change something
*            here as they need to make some assumption about these settings,
*            especially having 1965 as start year, having t2 as alias of t and
*            having ct as current time step
sets time_annual Annual extended time steps
    / y1965*y2150 /

    t_ext 5-year time periods
    /
    y1965, y1970, y1975, y1980, y1985, y1990,
    y1995, y2000, y2005, y2010, y2015, y2020, y2025, y2030, y2035, y2040,
    y2045, y2050, y2055, y2060, y2065, y2070, y2075, y2080, y2085, y2090,
    y2095, y2100, y2105, y2110, y2115, y2120, y2125, y2130, y2135, y2140,
    y2145, y2150, y2155, y2160, y2165, y2170, y2175, y2180, y2185, y2190,
    y2195, y2200, y2205, y2210, y2215, y2220, y2225, y2230, y2235, y2240,
    y2245, y2250
    /

    t_all(t_ext) 5-year time periods
    / y1965, y1970, y1975, y1980, y1985, y1990,
      y1995, y2000, y2005, y2010, y2015, y2020, y2025, y2030, y2035, y2040,
      y2045, y2050, y2055, y2060, y2065, y2070, y2075, y2080, y2085, y2090,
      y2095, y2100, y2105, y2110, y2115, y2120, y2125, y2130, y2135, y2140,
      y2145, y2150 /

    t_historical(t_all) Historical period
    /   y1965, y1970, y1975, y1980, y1985, y1990 /

    t_future(t_all) 5-year time periods
    / y2105, y2110, y2115, y2120, y2125, y2130, y2135, y2140,
      y2145, y2150 /

    t_past_forestry(t_all) Forestry Timesteps with observed data
    / y1965, y1970, y1975,
     y1980, y1985, y1990,
     y1995, y2000, y2005, y2010, y2015
    /
;

set t_past(t_all) Timesteps with observed data
$If "%c_past%"== "till_2010" /y1965, y1970, y1975, y1980, y1985, y1990,y1995, y2000, y2005, y2010/;
$If "%c_past%"== "till_1965" /y1965/;
$If "%c_past%"== "till_1975" /y1965, y1970, y1975/;
$If "%c_past%"== "till_1995" /y1965, y1970, y1975, y1980, y1985, y1990, y1995/;


set t(t_all) Simulated time periods
$If "%c_timesteps%"== "less_TS" /y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050,y2055,y2060,y2070,y2080,y2090,y2100,y2110,y2130,y2150/;
$If "%c_timesteps%"== "coup2100" /y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050,y2055,y2060,y2070,y2080,y2090,y2100/;
$If "%c_timesteps%"== "test_TS" /y1995,y2000,y2005,y2010,y2020,y2030,y2040,y2050,y2070,y2090,y2110,y2130,y2150/;
$If "%c_timesteps%"== "TS_benni" /y1995,y2000,y2005,y2010,y2020,y2030,y2040,y2050/;
$If "%c_timesteps%"== "TS_WB" /y1995,y2000,y2005,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080/;
$If "%c_timesteps%"== "5year" /y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050,y2055,y2060,y2065,y2070,y2075,y2080,y2085,y2090,y2095,y2100/;
$If "%c_timesteps%"== "5year2050" /y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050/;
$If "%c_timesteps%"== "5year2070" /y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050,y2055,y2060,y2065,y2070/;
$If "%c_timesteps%"== "quicktest" /y1995,y2010,y2025/;
$If "%c_timesteps%"== "quicktest2" /y1995,y2020,y2050,y2100/;
$If "%c_timesteps%"== "1" /y1995/;
$If "%c_timesteps%"== "2" /y1995,y2000/;
$If "%c_timesteps%"== "3" /y1995,y2000,y2010/;
$If "%c_timesteps%"== "4" /y1995,y2000,y2010,y2020/;
$If "%c_timesteps%"== "5" /y1995,y2000,y2010,y2020,y2030/;
$If "%c_timesteps%"== "6" /y1995,y2000,y2010,y2020,y2030,y2040/;
$If "%c_timesteps%"== "7" /y1995,y2000,y2010,y2020,y2030,y2040,y2050/;
$If "%c_timesteps%"== "8" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060/;
$If "%c_timesteps%"== "9" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070/;
$If "%c_timesteps%"=="10" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080/;
$If "%c_timesteps%"=="11" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090/;
$If "%c_timesteps%"=="12" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100/;
$If "%c_timesteps%"=="13" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100,y2110/;
$If "%c_timesteps%"=="14" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100,y2110,y2120/;
$If "%c_timesteps%"=="15" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100,y2110,y2120,y2130/;
$If "%c_timesteps%"=="16" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100,y2110,y2120,y2130,y2140/;
$If "%c_timesteps%"=="17" /y1995,y2000,y2010,y2020,y2030,y2040,y2050,y2060,y2070,y2080,y2090,y2100,y2110,y2120,y2130,y2140,y2150/;
$If "%c_timesteps%"=="past" /y1965,y1970,y1975,y1980,y1985,y1990,y1995,y2000,y2005,y2010/;
$If "%c_timesteps%"=="pastandfuture" /y1965,y1970,y1975,y1980,y1985,y1990,y1995,y2000,y2005,y2010,y2015,y2020,y2025,y2030,y2035,y2040,y2045,y2050,y2055,y2060,y2065,y2070,y2075,y2080,y2085,y2090,y2095,y2100/;
set ct(t) Current time period;
set ct_all(t_all) Current time period for loops over t_all;

alias(t,t2);

sets

***Products***

   kall All products in the sectoral version
   /
   tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,oilpalm,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,others,cottn_pro,foddr, pasture, begr, betr,
   oils,oilcakes,sugar,molasses,alcohol,ethanol,distillers_grain,brans,scp,fibres,
   livst_rum, livst_pig,livst_chick, livst_egg, livst_milk, fish,
   res_cereals, res_fibrous, res_nonfibrous, wood, woodfuel
   /

  dev Economic development status
       / lic, mic, hic /

***TYPE OF WATER SUPPLY***
   w Water supply type / rainfed, irrigated /

***WATER SOURCES***
   wat_src Type of water source / surface, ground, technical, ren_ground /

***WATER DEMAND sectors***
   wat_dem Water demand sectors / agriculture, industry, electricity, domestic, ecosystem /

***LAND POOLS***
   land Land pools
        / crop, past, forestry, primforest, secdforest, urban, other /

  land_ag(land) Agricultural land pools
                  / crop, past /

  forest_land(land) land from which timber can be taken away
  / forestry, primforest, secdforest,other /

  land_natveg(forest_land) Natural vegetation land pools
        / primforest, secdforest, other /

  forest_type forest type
         / plantations, natveg /

   si Suitability classes
        / si0, nsi0 /

***Forestry**
  ac Age classes  / ac0,ac5,ac10,ac15,ac20,ac25,ac30,ac35,ac40,ac45,ac50,
                    ac55,ac60,ac65,ac70,ac75,ac80,ac85,ac90,ac95,ac100,
                    ac105,ac110,ac115,ac120,ac125,ac130,ac135,ac140,ac145,
                    ac150,ac155,acx /

  ac_young(ac) age classes young
                  / ac5,ac10,ac15,ac20,ac25,ac30 /

  ac_mature(ac) age classes mature
                     / ac35,ac40,ac45,ac50,ac55,ac60,ac65,ac70,ac75,ac80,ac85,ac90,
                       ac95,ac100,ac105,ac110,ac115,ac120,ac125,ac130,ac135,ac140,
                       ac145,ac150,ac155,acx /

  ac_est(ac) Dynamic subset of age classes for establishment

  ac_sub(ac) Dynamic subset of age classes excluding establishment

   chap_par Chapman-richards parameters / k,m /

*** Nutrients
   attributes Product attributes characterizing a product (such as weight or energy content)
   /dm,ge,nr,p,k,wm,c/
* dry matter, gross energy, reactive nitrogen, phosphorus, potash, wet matters

   nutrients(attributes) Nutrient related product attributes
   /dm,ge,nr,p,k/

  dm_ge_nr(nutrients) Attribtues relevant for nutrition
       / dm,ge,nr /

  npk(nutrients) Plant nutrients
   /nr,p,k/

  cgf Residue production functions
   /slope, intercept, bg_to_ag/

***Emissions ***

   emis_source Emission sources
   / inorg_fert, man_crop, awms, resid, man_past, som,
     rice, ent_ferm,
     resid_burn,
     crop_vegc, crop_litc, crop_soilc,
     past_vegc, past_litc, past_soilc,
     forestry_vegc, forestry_litc, forestry_soilc,
     primforest_vegc, primforest_litc, primforest_soilc,
secdforest_vegc, secdforest_litc, secdforest_soilc,     urban_vegc, urban_litc, urban_soilc,
     other_vegc, other_litc, other_soilc,
     beccs/

   emis_source_reg(emis_source) Regional emission sources
   / inorg_fert, man_crop, awms, resid, man_past, som,
     rice, ent_ferm, beccs /

   emis_source_cell(emis_source) Cellular emission sources
   / crop_vegc, crop_litc, crop_soilc,
     past_vegc, past_litc, past_soilc,
     forestry_vegc, forestry_litc, forestry_soilc,
     primforest_vegc, primforest_litc, primforest_soilc,
secdforest_vegc, secdforest_litc, secdforest_soilc,     urban_vegc, urban_litc, urban_soilc,
     other_vegc, other_litc, other_soilc /

   emis_co2(emis_source_cell) Land pool CO2 emission sources
   / crop_vegc, crop_litc, crop_soilc,
     past_vegc, past_litc, past_soilc,
     forestry_vegc, forestry_litc, forestry_soilc,
     primforest_vegc, primforest_litc, primforest_soilc,
secdforest_vegc, secdforest_litc, secdforest_soilc,     urban_vegc, urban_litc, urban_soilc,
     other_vegc, other_litc, other_soilc /

   co2_forestry(emis_source_cell) Sources of forestry land CO2 emissions
   /forestry_vegc, forestry_litc, forestry_soilc/

   c_pools Carbon pools
   /vegc,litc,soilc/

***TECHNICAL STUFF***
   type GAMS variable attribute used for the output / level, marginal, upper, lower /

***RELATIONSHIPS BETWEEN DIFFERENT SETS***

  emis_land(emis_co2,land,c_pools) Mapping between land and carbon pools
  /crop_vegc        . (crop) . (vegc)
   crop_litc        . (crop) . (litc)
   crop_soilc       . (crop) . (soilc)
   past_vegc        . (past) . (vegc)
   past_litc        . (past) . (litc)
   past_soilc       . (past) . (soilc)
   forestry_vegc    . (forestry) . (vegc)
   forestry_litc    . (forestry) . (litc)
   forestry_soilc   . (forestry) . (soilc)
   primforest_vegc  . (primforest) . (vegc)
   primforest_litc  . (primforest) . (litc)
   primforest_soilc . (primforest) . (soilc)
   secdforest_vegc  . (secdforest) . (vegc)
   secdforest_litc  . (secdforest) . (litc)
   secdforest_soilc . (secdforest) . (soilc)
   urban_vegc       . (urban) . (vegc)
   urban_litc       . (urban) . (litc)
   urban_soilc      . (urban) . (soilc)
   other_vegc       . (other) . (vegc)
   other_litc       . (other) . (litc)
   other_soilc      . (other) . (soilc)
   /

   emis_co2_to_forestry(co2_forestry,c_pools) Mapping between forestry land and carbon pools
  /forestry_vegc    . (vegc)
   forestry_litc    . (litc)
   forestry_soilc   . (soilc)
   /

;

alias(ac,ac2);
alias(ac_sub,ac_sub2);
alias(ac_est,ac_est2);

*** EOF sets.gms ***
*$batinclude "./modules/include.gms" sets DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


$setglobal phase %1
$onrecurse
*######################## R SECTION START (MODULES) ############################
*$include "./modules/09_drivers/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Drivers
*'
*' @description The Drivers module provides data on drivers
*' that are used by several other modules. It mainly aggregates inputs related 
*' to population and GDP. If an input is required in one module or realization only, 
*' the input driver is provided directly by the module that demands it, 
*' rather than by the [09_drivers] module. 
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%drivers%" == "aug17" $include "./modules/09_drivers/aug17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the aug17 realization, inputs are taken into the module and are directly 
*' delivered to the modules that require the data.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/09_drivers/aug17/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de
sets

   pop_scen09  Population scenario
       / SSP1, SSP2, SSP3, SSP4, SSP5, SDP,
         a1, a2, b1, b2 /

   gdp_scen09  GDP scenario
       / SSP1, SSP2, SSP3, SSP4, SSP5, SDP,
       a1,a2,b1,b2 /

   age Population age groups
       / 0--4, 5--9,   10--14, 15--19,
       20--24, 25--29, 30--34, 35--39,
       40--44, 45--49, 50--54, 55--59,
       60--64, 65--69, 70--74, 75--79
       80--84,85--89,90--94,95--99,100+ /

   sex Sex groups
       /M,F/

;
*$Ifi "%phase%" == "declarations" $include "./modules/09_drivers/aug17/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/09_drivers/aug17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/09_drivers/aug17/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/10_land/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Land

*' @description The land module coordinates and analyzes all land related activities
*' by summing up all land types and calculating the gross changes in land use
*' between two time steps of optimization given the recursive dynamic structure of
*' MAgPIE model.

*' @authors Jan Philipp Dietrich, Florian Humpenoeder, Kristine Karstens

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%land%" == "feb15" $include "./modules/10_land/feb15/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%land%" == "landmatrix_dec18" $include "./modules/10_land/landmatrix_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The landmatrix_dec18 realization tracks land use transitions by
*' directly counting sources and targets of conversions.

*' @limitations There are currently no known limitations of this realization.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/10_land/landmatrix_dec18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  t_ini10  Time periods with land initialization data
       / y1995, y2000, y2005, y2010, y2015 /

   land_from10(land) Land pools
        / crop, past, forestry, primforest, secdforest, urban, other /

   land_to10(land) Land pools
        / crop, past, forestry, primforest, secdforest, urban, other /

   luh2_side_layers10 side layers from LUH2
	/ manpast, rangeland, primveg, secdveg, forested, nonforested /

    potnatveg(luh2_side_layers10) potentially forested biomes
	/ forested, nonforested /
;
*$Ifi "%phase%" == "declarations" $include "./modules/10_land/landmatrix_dec18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/10_land/landmatrix_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/10_land/landmatrix_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/10_land/landmatrix_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "start" $include "./modules/10_land/landmatrix_dec18/start.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/10_land/landmatrix_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/10_land/landmatrix_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/10_land/landmatrix_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/11_costs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Costs
*'
*' @description The cost module determines the sum total of global production
*' costs in each time step. MAgPIE's objective is to minimize the global cost of
*' production in a recursive dynamic way. The interface variable `vm_cost_glo`
*' is used for this purpose. The model optimizes the production activities
*' accordingly to ensure that all the demand and supply constraints are met
*' while minimizing the global production costs.

*' @authors Benjamin Leon Bodirsky, Florian Humpenöder, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%costs%" == "default" $include "./modules/11_costs/default/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @description The default realization of the costs module calculates global production
*' costs with a constraint of production always fulfilling the demand.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/11_costs/default/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/11_costs/default/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/11_costs/default/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/11_costs/default/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/12_interest_rate/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Interest rate

*' @description Interest rates are used in MAgPIE as a risk-accounting 
*' factor associated with investment activities [@wang_taking_2016].
*' Interest rates are required for inter-temporal calculations in the model
*' such as shifting investment from one time step to another or distribution of
*' one-time investments over several time steps (e.g. in the modules 
*' [13_tc], [39_landconversion] and [41_area_equipped_for_irrigation]).
*'
*' @authors Xiaoxi Wang

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%interest_rate%" == "select_apr20" $include "./modules/12_interest_rate/select_apr20/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The select_apr20 realization allows to flexibly choose regional
*' or global interest rates. In the default setting, the interest rate depends
*' on the development state `im_development_state`, which is calculated based
*' on GDP per capita. Thus, interest rates are regionally specific and dynamic
*' over time.
*' Alternative interest rates can be selected via the interest rate coefficients
*' (`s12_interest_lic`, `s12_interest_hic`, `s12_hist_interest_lic`, `s12_hist_interest_hic`).
*' The future interest rate policy fades in starting from 2025 until it is fully
*' in effect by 2050.
*' It is also possible to choose a global interest rate.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/12_interest_rate/select_apr20/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/12_interest_rate/select_apr20/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/12_interest_rate/select_apr20/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/13_tc/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Technological change
*'
*' @description The technological change (TC) module describes the relation
*' between agricultural land use intensity represented by the $\tau$ factor and
*' the costs which have to be paid for further intensification (technological
*' change costs). Besides cropland expansion ([39_landconversion]) and trade
*' ([21_trade]), it describes the third major option of the model to increase
*' regional supply. In order to calculate this relation, the module needs to
*' receive information about the assumed interest rate and assumed investment
*' horizon currently provided by module [12_interest_rate].
*'
*' Calculated $\tau$ factors are then used for yields calculation by [14_yields]
*' and by [38_factor_costs] for the calculation of factor costs.
*'
*' @authors Jan Philipp Dietrich, Christoph Schmitz, Benjamin Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%tc%" == "endo_jun18" $include "./modules/13_tc/endo_jun18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The endo realization stands for endogenous implementation of
*' technological change and land use intensification. The intensification rates
*' are calculated endogenously based on an interplay between land use intensity
*' $\tau$ and technological change costs (as shown schematically in the figure
*' below). This module realization contains the implementation as described
*' in @dietrich_forecasting_2014 with two minor modifications:
*'
*'   * rates of previous investment decisions which still have to be paid are
*'     added to the technological change costs
*'   * the planning horizon for investments is unified over all investments in
*'     the model.
*'
*' ![Implementation of technological change in MAgPIE
*' [@dietrich_forecasting_2014]](tc_schematic.png){ width=60% }
*'
*' Initial land use intensity $\tau$ values for the year 2000 come from
*' @dietrich_measuring_2012 and are shown below.
*'
*' ![$\tau$-factors in world regions & global (GLO) for the year 2000.
*' [@dietrich_measuring_2012]](tau_regional.png){ width=60% }
*'
*' Investments into technological change (TC) trigger land use intensification
*' ($\tau$) which triggers in turn yields increases. How much intensification
*' can be triggered by an investment, depends on the investment-yield ratio,
*' which in turn depends on the current agricultural land use intensity. The
*' higher the current intensity level, the more expensive the additional
*' intensification will become. The interaction between land use intensity and
*' production costs per area as shown in the schematic is not covered by this
*' module and can be found instead in [38_factor_costs].

*' @limitations This module significantly reduces the overall computational
*' performance of the model since these endogenous calculations are highly
*' computational intensive.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/13_tc/endo_jun18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  t_to_i_to_dev(t_all,i,dev) Mapping between time region and economic development status

	scen13 tc cost scenario
  	  /low, medium, high/

	scen13_to_dev(scen13,dev) mapping between tc cost scenarios and development stages
      /	high	. (lic)
       	medium	. (mic)
       	low		. (hic) /
;

*** EOF sets.gms ***
*$Ifi "%phase%" == "declarations" $include "./modules/13_tc/endo_jun18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/13_tc/endo_jun18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/13_tc/endo_jun18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/13_tc/endo_jun18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/13_tc/endo_jun18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/13_tc/endo_jun18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/13_tc/endo_jun18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/13_tc/endo_jun18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/13_tc/endo_jun18/nl_release.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_relax" $include "./modules/13_tc/endo_jun18/nl_relax.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%tc%" == "exo" $include "./modules/13_tc/exo/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/14_yields/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Yields
*'
*' @description The yields module simulates the temporal development of crop
*' yields and pasture productivity. Spatially explicit information on pasture
*' productivity and crop yields under both rainfed and irrigated conditions is
*' provided by the global gridded crop model LPJmL (Lund-Potsdam-Jena with
*' managed Land) [@bondeau_lpjml_2007]. In the initial year of the simulation
*' period, crop yields and pasture productivity are calibrated at the regional
*' level to meet the observed cropland and pasture area as reported by FAO
*' [@FAOSTAT]. For the simulation of the temporal development of agricultural
*' yields, the module receives information about the agricultural land use
*' intensity represented by the $\tau$ factor coming from the module [13_tc].
*'
*' The module returns yields for all crops and for pasture, which is then used
*' by the modules [30_crop] and [31_past].
*'
*' @authors Jan Philipp Dietrich, Isabelle Weindl, Florian Humpenöder, Anne Biewald



*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%yields%" == "biocorrect" $include "./modules/14_yields/biocorrect/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%yields%" == "dynamic_aug18" $include "./modules/14_yields/dynamic_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the dynamic_aug18 realization, the crop yield calculations
*' are identical as in the above described realization (biocorrect).
*' Additionally, this realization also calculates the growing stocks in commercial
*' plantations and natural vegetation using LPJmL Carbon stocks.
*'
*' @limitations The exogenous implementation of pasture intensification cannot
*' capture feedbacks between land scarcity and efforts to improve pasture
*' management.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/14_yields/dynamic_aug18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  ltype14 calibration land types
       / crop, past /
;
*$Ifi "%phase%" == "declarations" $include "./modules/14_yields/dynamic_aug18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/14_yields/dynamic_aug18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/14_yields/dynamic_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/14_yields/dynamic_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/14_yields/dynamic_aug18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/14_yields/dynamic_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/14_yields/dynamic_aug18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/14_yields/dynamic_aug18/nl_release.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/15_food/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Food demand
*'
*' @description The main function of the food demand module is to forecast
*' the food demand from agricultural products, which is used in the module [16_demand].
*' @authors Benjamin Leon Bodirsky, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%food%" == "anthropometrics_jan18" $include "./modules/15_food/anthropometrics_jan18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/15_food/anthropometrics_jan18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

   iter15 iterations between food demand model and magpie
   /iter1*iter10/   
   curr_iter15(iter15)  currently active iteration
   prev_iter15(iter15)     last active iteration

   underaged15(age) Group of underaged age classes
   /0--4,5--9,10--14/

   adult15(age) Age groups for adult population
       /  15--19,
       20--24, 25--29, 30--34, 35--39,
       40--44, 45--49, 50--54, 55--59,
       60--64, 65--69, 70--74, 75--79
       80--84,85--89,90--94,95--99,100+ /

   working15(adult15) Group of working age population
   / 15--19,
     20--24, 25--29, 30--34, 35--39,
     40--44, 45--49, 50--54, 55--59/

   retired15(adult15) Age group of retired population
   /60--64, 65--69, 70--74, 75--79
       80--84,85--89,90--94,95--99,100+ /

   agegroup15 All age groups
   /underaged,working,retired /

   age2_adults15(agegroup15) Adult age group
   /working,retired /

   agegroup2age(agegroup15,age) Mapping between age cohort and age
   /
   underaged        . (0--4,5--9,10--14)
   working          . (15--19,
     20--24, 25--29, 30--34, 35--39,
     40--44, 45--49, 50--54, 55--59)
   retired          . (60--64, 65--69, 70--74, 75--79
       80--84,85--89,90--94,95--99,100+ )
   /

   bmi_tree15 Body mass index
   /low,lowsplit,mediumsplit,high,highsplit/

   bmi_group15 Body mass index gradient
   /verylow,low,medium,mediumhigh,high,veryhigh/

   bmi_group_est15(bmi_group15) Body mass index extremes
   /verylow,low,mediumhigh,high,veryhigh/

   age_new_estimated15(age) Estimated ages
   /0--4,5--9,10--14,15--19/

   reproductive(age) Age group of people in the reproductive age
   /20--24, 25--29, 30--34, 35--39/

   estimates15 Preliminary or final result for body height distribution
   /preliminary,final/

   paras_s15 Schofield equation parameters
   /slope, intercept/

   paras_b15 Intake equation parameters
   /saturation,halfsaturation,intercept/

   paras_h15 Bodyheight equation parameters
   /slope, exponent/

   kfo(kall) All products in the sectoral version
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,
   oils,sugar,molasses,alcohol,brans,scp,
   livst_rum,livst_pig,livst_chick, livst_egg, livst_milk, fish,
   others /

   growth_food15(kfo) Food items that are important for body growth regression
   / soybean,groundnut,puls_pro,oils,
   livst_rum,livst_pig,livst_chick, livst_egg, livst_milk, fish /

   kst(kfo) Plant-based staple products in the sectoral version
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,
   oils,sugar,molasses,alcohol,brans,scp /

   kfo_pp(kfo) Plant-based food products
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,
   oils,sugar,molasses,alcohol,brans,scp,
   others /

   kfo_ap(kfo) Animal food products
   / livst_rum,livst_pig,livst_chick, livst_egg, livst_milk, fish /

   kfo_lp(kfo) Livestock food products
   / livst_rum,livst_pig,livst_chick, livst_egg, livst_milk /

   kfo_rd(kfo) Ruminant meat and dairy food products
   / livst_rum,livst_milk /

   kfo_st(kfo) Staple products
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,molasses,brans,scp /

   kfo_pf(kfo) Processed foods including oils sugar alcohol
   / oils,alcohol,sugar /

   knf(kall) Non-food products in the sectoral version
   / oilpalm,cottn_pro,foddr, pasture, begr, betr,
   oilcakes,ethanol,distillers_grain,fibres,
   res_cereals, res_fibrous, res_nonfibrous,
   wood, woodfuel /

   nutrition Nutrition attributes
   /kcal, protein/

   par15 Parameters for food module
   / intercept,saturation,halfsaturation,non_saturation /
* intercept + saturation give the max value if non-saturation is 1
* halfsaturation is the gdp until which half of saturation is reached

 regr15  Demand regression types
      / overconsumption,livestockshare,processedshare,vegfruitshare /

*** Scenarios
   food_scen15  Food scenarios
       / SSP1, SSP2, SSP3, SSP4, SSP5,
         SSP1_boundary, SSP2_boundary, SSP3_boundary,
         SSP4_boundary, SSP5_boundary,
         SSP2_lowcal, SSP2_lowls, SSP2_waste,
         ssp2_high_yvonne,ssp2_low_yvonne,ssp2_lowest_yvonne,
         history /

   pop_scen15  Population scenarios
       / SSP1, SSP2, SSP3, SSP4, SSP5 /


  calibscen15  Calibration scenarios for balance flow
       / constant, fadeout2050 /

  livst_fadeoutscen15 Scenarios for changed composition of livestock products
       / halving2050, constant /

  fadeoutscen15  Food substitution scenarios including functional forms with targets and transition periods
       / constant,
         lin_zero_10_50, lin_zero_20_50, lin_zero_20_30, lin_zero_20_70, lin_50pc_20_50, lin_50pc_20_50_extend65, lin_50pc_20_50_extend80,
         lin_50pc_10_50_extend90, lin_75pc_10_50_extend90, lin_80pc_20_50, lin_80pc_20_50_extend95, lin_90pc_20_50_extend95,
	 lin_99-98-90pc_20_50-60-100, sigmoid_20pc_20_50, sigmoid_50pc_20_50, sigmoid_80pc_20_50 /

  t_scen15(t_all) Target years for transition to exogenous scenario diets
       / y2010, y2030, y2050 /

  kcal_scen15  Scenario of daily per capita calorie intake
       / 2100kcal, 2500kcal /

  EAT_scen15  Scenario of daily per capita calorie intake
       / BMK, FLX, PSC, VEG, VGN, FLX_hmilk, FLX_hredmeat /

   EAT_staples(kfo) All staple food products according to EAT Lancet definition
       / tece,maiz,trce,rice_pro,potato,cassav_sp /

   EAT_nonstaples(kfo) All non-staple food products according to EAT Lancet definition
       / soybean,rapeseed,groundnut,sunflower,puls_pro,
         sugr_cane,sugr_beet,
         oils,sugar,molasses,alcohol,brans,scp,
         livst_rum,livst_pig,livst_chick, livst_egg, livst_milk, fish,
         others /

;

alias(kst,kst2);
alias(bmi_group15,bmi_group15_2);
alias(kfo,kfo2);
alias(kfo_ap,kfo_ap2);
alias(kfo_st,kfo_st2);
alias(kfo_pf,kfo_pf2);
alias(iso,iso2);
alias(reproductive,reproductive2);
alias(EAT_staples,EAT_staples2);
*$Ifi "%phase%" == "declarations" $include "./modules/15_food/anthropometrics_jan18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/15_food/anthropometrics_jan18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/15_food/anthropometrics_jan18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/15_food/anthropometrics_jan18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/15_food/anthropometrics_jan18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/15_food/anthropometrics_jan18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "intersolve" $include "./modules/15_food/anthropometrics_jan18/intersolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/15_food/anthropometrics_jan18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################

*' @description
*' The realization anthropometrics_jan18
*' uses per capita income and the demography of the
*' world population (including sex and age classes at the country level,
*' which are provided from module [09_drivers]) as drivers.
*' The module estimates food demand on iso-country level taking
*' anthropometric food requirements as well as economic dynamics into account.
*' If flexible demand is activated, the module also uses the shadow prices
*' for agircultural products from the optimization, which are the Lagrange
*' multipliers of the constraint `q15_food_demand`.
*' The module consists of a standalone food demand model, which is executed
*' before MAgPIE starts. In the case of endogenous demand, the module is
*' iterated with MAgPIE.
*' Besides providing the fooduse of agricultural products, the model also
*' provides a number of output indicators, including the BMI distribution,
*' body weight and height of the population by age and sex, food intake by
*' age group and sex, food waste, dietary composition between livestock products,
*' empty calories (sugar, oil and alcohol), fruits vegetables and nuts, as well
*' as staple calories.
*' The food demand model can be run in standalone mode by running the
*' the file `standalone/demand_model.gms`.
*' The model is described in [@bodirsky_starved_nodate]
*'
*' @authors Benjamin Leon Bodirsky, Jan Philipp Dietrich

*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/16_demand/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Demand
*'
*' @description The demand module calculates the demand for all commodities that
*' has to be fulfilled by the model. In addition, it returns some other basic
*' information needed for demand calculations but also needed by other modules.
*' A description of food demand scenarios that enter the model can be found
*' in @bodirsky_global_2015-1, @bodirsky_n2o_2012 and @valin_fooddemand_2013.
*'
*' @authors Isabelle Weindl, Benjamin Bodirsky, Jan Philipp Dietrich.

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%demand%" == "sector_may15" $include "./modules/16_demand/sector_may15/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the sector_may15 realization, demand is calculated as the sum of
*' demand for all products coming from the modules [62_material],
*' [60_bioenergy], [70_livestock], [15_food] and [17_production].
*' It also delivers data to the modules [60_bioenergy], [21_trade], [20_processing],
*' [18_residues], [55_awms], [50_nr_soil_budget], [32_forestry], and [53_methane].


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/16_demand/sector_may15/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

   ksd(kall) Secondary products
   /oils,oilcakes,sugar,molasses,alcohol,ethanol,distillers_grain,brans,scp,fibres/

   kres(kall) Residues
   / res_cereals, res_fibrous, res_nonfibrous /

   k(kall) Primary products
       / tece, maiz, trce, rice_pro, soybean, rapeseed, groundnut, sunflower,
         oilpalm, puls_pro, potato, cassav_sp, sugr_cane, sugr_beet, others,
         foddr, pasture, cottn_pro, begr, betr, livst_rum, livst_pig,
         livst_chick, livst_egg, livst_milk, fish, wood, woodfuel /

   kap(k) Animal products
   /
   livst_rum,livst_pig,livst_chick, livst_egg, livst_milk, fish
   /

   kli(kap) Livestock products
   / livst_rum, livst_pig, livst_chick, livst_egg, livst_milk  /

   kforestry(k) forestry products
        / wood, woodfuel /

   kve(k) Land-use activities
       / tece, maiz, trce, rice_pro, soybean, rapeseed, groundnut, sunflower,
         oilpalm, puls_pro, potato, cassav_sp, sugr_cane, sugr_beet, others,
         foddr, pasture, cottn_pro, begr, betr /

   kcr(kve) Cropping activities
       / tece, maiz, trce, rice_pro, soybean, rapeseed, groundnut, sunflower,
         oilpalm, puls_pro, potato, cassav_sp, sugr_cane, sugr_beet, others,
         foddr, cottn_pro, begr, betr /
 ;

alias(kap,kap4);
*$Ifi "%phase%" == "declarations" $include "./modules/16_demand/sector_may15/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/16_demand/sector_may15/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/16_demand/sector_may15/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/16_demand/sector_may15/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/17_production/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Production

*' @description The production module calculates regional production of
*' MAgPIE commodities from cluster level production data.

*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%production%" == "flexreg_apr16" $include "./modules/17_production/flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  This realization aggregates agricultural production from
*' cluster level `j` to regional level `i`. Currently, cluster level production
*' is available only for plant commodities, i.e for crops and pastures.
*' Cluster level production of different crops and pasture is calculated in
*' module [30_crop] and [31_past] respectively.

*' @limitations For the time being, this approach is not applied to livestock
*' products.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/17_production/flexreg_apr16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/17_production/flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/17_production/flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/18_residues/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Residues
*'
*' @description The residues module calculates the production of crop residues
*' (straw, etc.) and its subsequent use. Residues can be burned, used for feed,
*' recycled to soils or used for other purposes (construction, fuel, etc.).
*'
*' The module also calculates the costs of crop residue harvest when it is used
*' for feed or material purposes.
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%residues%" == "flexreg_apr16" $include "./modules/18_residues/flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description As official global statistics exist only for crop production and not for crop
*' residue production, the biomass of residues is obtained in MAgPIE by using
*' crop-type specific plant growth functions based on crop production and area harvested.
*' Plant biomass is divided into three components: the harvested organ as listed
*' in FAO, the aboveground (AG) and the belowground (BG) residues.
*'
*' @ipcc_2006_2006 offers one of the few consistent datasets to estimate
*' both AG and BG residues. Also, by providing crop-growth functions (CGF, `f18_cgf`)
*' instead of fixed harvest indices, it can be used to depict current
*' international differences of harvest indices and their development in the future.
*' The methodology is thus well eligible for global long-term modelling.
*' @ipcc_2006_2006 provides linear CGFs with positive slope and intercept
*' for cereals, leguminous crops, potatoes and grasses. As no values are
*' available for the oilcrops rapeseed, sunflower, oilpalms as well as
*' sugar crops, tropical roots, cotton and others, we use fixed harvest-indices
*' (positive slope without intercept) for these crops based
*' on @wirsenius_human_2000, @lal_world_2005 and @feller_dungung_2007. If different CGFs are available
*' for crops within a crop group, we build a weighted average based on the
*' production in 1995.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/18_residues/flexreg_apr16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


sets

dm_nr(attributes) dry matter and nr
/dm, nr, c/

pk18(npk) subset of npk containing P and K nutrients
/p, k/

dev18 country develoment indicator
/high_income,low_income/

burn_scen18 scenario for burning residues on field
/constant,phaseout/

nonused18(kcr) crops that are not used as residues
/sunflower, oilpalm, foddr, begr, betr/

***Feeding groups***

   kres_kcr(kres,kcr) mapping of crops to different residue types
   /     res_cereals                   .(tece,maiz,trce,rice_pro)
         res_fibrous                   .(soybean,rapeseed,groundnut,
                                         puls_pro,sugr_beet,sugr_cane,
                                         cottn_pro)
         res_nonfibrous                .(potato,cassav_sp,others)
   /



;

*** EOF sets.gms ***
*$Ifi "%phase%" == "declarations" $include "./modules/18_residues/flexreg_apr16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/18_residues/flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/18_residues/flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/18_residues/flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/18_residues/flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/18_residues/flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%residues%" == "off" $include "./modules/18_residues/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################

*** EOF residues.gms ***
*$include "./modules/20_processing/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Processing

*' @description The processing module calculates the quantity of secondary products that
*' are generated through conversion of raw products (especially of primary plant agricultural commodities)
*' in order to meet the demand for those secondary products.

*' @authors Benjamin Leon Bodirsky, Amsalu Woldie Yalew


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%processing%" == "off" $include "./modules/20_processing/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%processing%" == "substitution_dec18" $include "./modules/20_processing/substitution_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/20_processing/substitution_dec18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

kpr(kall) Products that can be processed
   /tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,oilpalm,
   potato,cassav_sp,sugr_cane,sugr_beet,others,cottn_pro,brans,begr,betr,foddr,
   sugar,molasses,oils,oilcakes/

knpr(kall) Products that cannot be processed
   /alcohol,distillers_grain,ethanol,fibres,fish,livst_chick,livst_egg,livst_milk,
   livst_pig,livst_rum,oilcakes,pasture,puls_pro,res_cereals,res_fibrous,
   res_nonfibrous,scp,wood,woodfuel/

processing_subst20 Processing activities
/ milling, refining, extracting, distilling, fermentation, breeding, ginning, substitutes /

processing20(processing_subst20) Processing activities except substitution
/ milling, refining, extracting, distilling, fermentation, breeding, ginning /

kcereals20(kpr) Cereals used for processing
/tece,maiz,trce,rice_pro/

no_milling_ginning20(processing_subst20) Processing activities without milling and ginning
/refining, extracting, distilling, fermentation, breeding, substitutes /

oilcake_substitutes20(kpr) products that can be substituted for oilcakes
  /soybean,rapeseed,groundnut,sunflower,oilpalm,cottn_pro,oilcakes/

     scptype different types of scp
       /scp_methane,scp_sugar,scp_cellulose,scp_hydrogen/

     scen20 scenario of type of scp
      / mixed, methane, sugar, cellulose,hydrogen /

;
*$Ifi "%phase%" == "declarations" $include "./modules/20_processing/substitution_dec18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/20_processing/substitution_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/20_processing/substitution_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/20_processing/substitution_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/20_processing/substitution_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/20_processing/substitution_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/20_processing/substitution_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/21_trade/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Agricultural trade
*'
*' @description This module represents agricutlural trade among world regions.
*' It ensures that the regional demand is met by domestic production and imports from other regions.
*' The global trade balance dictates that global production must be larger than or equal to global demand.
*' For non-traded goods, the regional production must be larger than or equal to regional demand.
*'
*'
*' @authors  Xiaoxi Wang, Anne Biewald, Christoph Schmitz, Markus Bonsch
*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%trade%" == "exo" $include "./modules/21_trade/exo/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "free_apr16" $include "./modules/21_trade/free_apr16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "off" $include "./modules/21_trade/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "selfsuff_reduced" $include "./modules/21_trade/selfsuff_reduced/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description Within this realization, there are two ways for a region to fulfill
*' its demand for agricultural products: a self-sufficiency pool based on
*' historical region specific trade patterns, and a comparative advantage pool
*' based on most cost-efficient production.

*' In the self-sufficiency pool, regional self-sufficiency ratios `f21_self_suff_seedred_1995(i,k)` defines
*' how much of the demand of each region `i` for each traded goods `k_trade` has to be met by domestic production.
*' Self sufficiency ratios smaller than one indicate that the region imports from the world market,
*' while self-sufficiencies greater than one indicate that the region produces for export. Trade costs,
*' inlucding trade margins and tariffs, are considered.
*'
*' ![Implementation of trade.](trade_pools.png){ width=100% }

*' @limitations This realization depends on predetermined self-sufficiency rates and export shares,
*' which leads to a relative fixed trade pattern.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/21_trade/selfsuff_reduced/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  tstart21(t_all) Historic time steps
    / y1995, y2000, y2005, y2010 /

*sets need to be adopted to new categories
   k_notrade(kall) Production activities of non-tradable commodites
       / oilpalm, foddr, pasture, res_cereals, res_fibrous, res_nonfibrous,begr,betr /
* oilpalm not traded, only its oil and oilcake due to FAOSTAT complications, and as trade is little
* foddr is not traded as too bulky
* pasture it not traded as too bulky
* begr and betr are not traded because biomass is traded in REMIND
   k_trade(kall) Production activities of tradable commodities
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,others,cottn_pro,
   oils,oilcakes,sugar,molasses,alcohol,ethanol,distillers_grain,brans,scp,fibres,
   livst_rum, livst_pig,livst_chick, livst_egg, livst_milk, fish, wood, woodfuel /
   
* We limit trade of secondary products as this allows for extreme specialisation
* in the implementation. Exception is sugar, where we allow the secondary product
* trade but not the primary as primaries are hardly traded in reality
   k_hardtrade21(k_trade) Products where trade should be limited
   / sugr_cane,sugr_beet,
   oils,oilcakes,alcohol,ethanol,distillers_grain,brans,scp,fibres,
   livst_rum, livst_pig,livst_chick, livst_egg, livst_milk, fish /

   trade_regime21 Trade scenarios
   /
   free2000,
   regionalized,
   globalized,
   fragmented,
   a909090,
   a908080,
   a909595,
   a808080,
   a807070,
   a809090,
   l909090r808080,
   l908080r807070,
   l909595r809090
   /

   trade_groups21 Trade groups
   / easytrade,hardtrade /

;
*$Ifi "%phase%" == "declarations" $include "./modules/21_trade/selfsuff_reduced/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/21_trade/selfsuff_reduced/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/21_trade/selfsuff_reduced/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/21_trade/selfsuff_reduced/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/21_trade/selfsuff_reduced/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/21_trade/selfsuff_reduced/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/29_ageclass/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Age class

*' @description The age-class module calculates the distribution of secondary
*' forests and timber plantations based on Poulter dataset. This is used in
*' [32_forestry] and [35_natveg] for initialization of forest areas.

*' @authors Abhijeet Mishra, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%ageclass%" == "feb21" $include "./modules/29_ageclass/feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  This realization calculates use the results from @poulter2018global
*' for secondary forests (and timber plantations) based on MODIS satellite data.
*' This is used in [32_forestry] and [35_natveg] for initialization of forest areas
*' based on specification of endogenous (or exogenous) forest harvests. These numbers
*' are the most consistent dataset available on spatial scale and are preferred over
*' extarcting such numbers from LUH data due to ease of generating these numbers.

*' @limitations Forest fires change how the age structures of secondary or
*' human-intervention forests over time. This being a satellite observation data
*' probably includes such disturbances. These disturbances are not modeled extensively
*' in MAgPIE and hence using these numbers directly in the model might generate biases.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/29_ageclass/feb21/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
ac_poulter Forest age classes in Poulter data set
/ class1, class2, class3, class4, class5,
class6, class7, class8, class9, class10,
class11, class12, class13, class14, class15 /

ac_planted(ac) Young age classes which probably belong to managed forest
/ ac0, ac5, ac10, ac15, ac20, ac25, ac30 /

ac_plantations(ac) Possible age classes which probably belong to plantations
/ ac0, ac5, ac10, ac15, ac20, ac25, ac30,
  ac35, ac40, ac45, ac50, ac55, ac60 /

ac_poulter_to_ac(ac_poulter,ac) mapping between ac and ac_poulter
/
class1   .  (ac5,ac10)
class2   .  (ac15,ac20)
class3   .  (ac25,ac30)
class4   .  (ac35,ac40)
class5   .  (ac45,ac50)
class6   .  (ac55,ac60)
class7   .  (ac65,ac70)
class8   .  (ac75,ac80)
class9   .  (ac85,ac90)
class10  .  (ac95,ac100)
class11  .  (ac105,ac110)
class12  .  (ac115,ac120)
class13  .  (ac125,ac130)
class14  .  (ac135,ac140)
class15  .  (ac145,ac150)
/

;

alias(ac_poulter,ac_poulter2);
alias(ac,ac2);
*$Ifi "%phase%" == "declarations" $include "./modules/29_ageclass/feb21/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/29_ageclass/feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/29_ageclass/feb21/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/30_crop/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @title Cropland

*' @description The cropland module simulates the dynamics of cropland area and
*' agricultural crop production and calculates corresponding carbon contents and
*' the biodiversity value of the existing cropland.

*' @authors Jan Philipp Dietrich, Florian Humpenöder, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%crop%" == "endo_jun13" $include "./modules/30_crop/endo_jun13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The endo_jun13 realization calculates the crop specific
*' agricultural land use endogenously based on yield data coming from the
*' module [14_yields] and the rotational as well as suitability constrains
*' stated in the input data of the module.
*'
*' Cropland areas are linked to the crop specific production and the carbon
*' content of the different land carbon pools. The crop specific land use areas
*' are also used in [18_residues], [38_factor_costs],
*' [41_area_equipped_for_irrigation], [42_water_demand], [50_nr_soil_budget],
*' [53_methane] and [59_som].

*' @limitations There are currently no known limitations of this realization.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/30_crop/endo_jun13/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  crp30  Crop rotation types
       / cereals_r, rice_r, cer_rice_r, fieldoil_r, soybean_r, rapeseed_r,
         sunflower_r, groundnut_r, oilpalm_r, puls_r, potato_r, cassava_r,
         roots_r, sugr_cane_r, sugr_beet_r, others_r, foddr_r, fiber_r,
         begr_r, betr_r /

  crpmax30(crp30) Maximum crop rotation
  crpmin30(crp30) Minimum crop rotation

  crp_kcr30(crp30,kcr) Mapping of crop types into crop rotation types
       / cereals_r   . (tece, maiz, trce)
         rice_r      . (rice_pro)
         cer_rice_r  . (tece, maiz, trce, rice_pro)
         fieldoil_r  . (soybean, rapeseed, groundnut, sunflower)
         soybean_r   . (soybean)
         rapeseed_r  . (rapeseed, sugr_beet)
         sunflower_r . (sunflower)
         groundnut_r . (groundnut)
         oilpalm_r   . (oilpalm)
         puls_r      . (puls_pro)
         potato_r    . (potato)
         cassava_r   . (cassav_sp)
         sugr_cane_r . (sugr_cane)
         sugr_beet_r . (sugr_beet)
         others_r    . (others)
         foddr_r     . (foddr)
         fiber_r     . (cottn_pro)
         begr_r      . (begr)
         betr_r      . (betr)  /

   kbe30(kcr) bio energy activities
        / betr, begr /

   bioen_type_30(kbe30) dynamic set bioen type
   bioen_water_30(w) dynamic set bioen water

   crop_ann30(kcr) annual crops
    / tece, maiz, trce, rice_pro, rapeseed, sunflower, potato, cassav_sp, sugr_beet, others, cottn_pro, foddr, soybean, groundnut, puls_pro /

   crop_per30(kcr) perennial crops
    / oilpalm, begr, sugr_cane, betr /

;
*$Ifi "%phase%" == "declarations" $include "./modules/30_crop/endo_jun13/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/30_crop/endo_jun13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/30_crop/endo_jun13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/30_crop/endo_jun13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/30_crop/endo_jun13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/30_crop/endo_jun13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/31_past/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Pasture
*'
*' @description The pasture module determines land used as pasture for livestock
*' rearing. At the same time, it calculates geographically explicit production
*' of pasture biomass and the carbon content of pasture land. Therefore, the
*' module requires cellular information about the carbon density related to the
*' different pasture carbon pools. Furthermore, it delivers regional production
*' costs associated with pastures and biodiversity values for pasture and rangeland.
*'
*' @authors Isabelle Weindl, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%past%" == "endo_jun13" $include "./modules/31_past/endo_jun13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the endo_jun13 realization, pasture area and related carbon
*' stocks are modelled endogenously. The initial spatially explicit patterns of
*' pasture are defined in the module [10_land] by the land use input data set.
*' For future time steps, pasture area depends on the demand for biomass from
*' pastures to feed livestock as calculated in the module [70_livestock] and
*' from the intensity of pasture utilization ("pasture yield") as determined in
*' the module [14_yields].

*' @limitations No consideration of generic differences between extensive and
*' intensive grazing systems, of explicit pasture management options and of
*' related degradation of pastures.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/31_past/endo_jun13/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/31_past/endo_jun13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/31_past/endo_jun13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/31_past/endo_jun13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%past%" == "static" $include "./modules/31_past/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/32_forestry/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Forestry
*'
*' @description The forestry module describes the constraints under which managed
*' forest (age-class forest) exists. At the same time it calculates the corresponding
*' carbon stocks and biodiversity value. The module provides carbon dioxide removal (CDR) from afforestation
*' to the GHG policy module ([56_ghg_policy]) as well as afforestation related costs
*' to the costs module ([11_costs]).
*'
*' @authors Florian Humpenöder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%forestry%" == "dynamic_feb21" $include "./modules/32_forestry/dynamic_feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The main feature of the this realization is afforestation for CDR
*' and timber production. Afforestation can be modelled exogenously (prescribed
*' by NPI/NDC policies) and/or endogenously (incentivized by a reward for CDR).
*' National policies implemented (NPI) and nationally determined contributions to
*' the Paris agreement (NDC) for afforestation are based on country reports. The
*' interface `vm_cdr_aff` includes the expected CDR and local bph effects from
*' afforestation depending on the planning horizon `s32_planing_horizon`. The
*' reward for CDR and local bph effects from afforestation is calculated in the
*' [56_ghg_policy] module. In this realization, afforestation is modeled by default
*' as regrowth of natural vegetation (see @humpenoder_investigating_2014 for details on the implemenation).
*' The regrowth of natural vegetation follows S-shaped growth curves, which are
*' parametrized based on @braakhekke_modelling_2019. Additionally this module
*' handles the production of two timber products i.e., wood and woodfuel from
*' plantation forests while still accounting for afforestation policies. New plantations
*' are also established in the simulation step to account for future timber demand.
*' This module also calculates the rotation lengths before the solve loop by equating
*' Instantaneous Growth Rates (IGR) and interest rate `pm_interest` based on
*' @amacher2009economics. We have to make assumptions regarding the rotation lengths
*' to be used for establishment and harvesting decisions. For establishment we just
*' use the calculated rotations either based on a Single Rotation-Period Model or
*' based on Faustamnn rotations according to the switch `s32_faustmann_rotation`.
*' For harvesting we assume that land owners stick to their establishment decision,
*' e.g. if a plantation has been established with a rotation length of 30 years
*' it will be harvested after 30 years, even so the rotation length in the prevailing
*' time step, used for establishment, is shorter or longer.
*'   
*' ![Calculation of rotation lengths using interest rate and vegetation Carbon growth functions based on single rotation model](rotation_length.png){ width=100% }

*' @limitations Rotation lengths for timber plantations are not endogenous.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/32_forestry/dynamic_feb21/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de
sets
***FORESTRY COST TYPES***

 fcostsALL forestry factor cost types
 / recur, mon, harv /

 fcosts32(fcostsALL) forestry factor cost per annum
 / recur, mon /

 type32 plantation type
 / aff, ndc, plant /

 pol32 afforestation policy type
 / none, npi, ndc /

 ini32(j,ac) subset for initialization of timber plantations

 rotation_type Rotation type
 / min, low, def, high, bio /

 bgp32 biogeophysical effect (degree C) of afforestation on local surface temperature
/ nobgp, ann_bph /

tcre32 transient surface temperature response to CO2 emission (degree C per tC)
/ ann_TCREmean, ann_TCREhigh, ann_TCRElow /

aff_effect biochemical and local biophysical effect of afforestation on climate
/ bgc, bph /

ac_bph(ac) fade-in of bph effect over age-classes

inter32 Interpolation of scenario from FAO study on proportion of roundwood production coming from plantations
/abare, brown/

scen32 Scenario for development of roundwood production share from plantations
/ constant,h5s5l5,h5s2l2,h5s2l1,h5s1l1,h5s1l05,h2s1l05 /

;

*** EOF sets.gms ***
*$Ifi "%phase%" == "declarations" $include "./modules/32_forestry/dynamic_feb21/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/32_forestry/dynamic_feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/32_forestry/dynamic_feb21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/32_forestry/dynamic_feb21/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/32_forestry/dynamic_feb21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/32_forestry/dynamic_feb21/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/32_forestry/dynamic_feb21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%forestry%" == "static_sep16" $include "./modules/32_forestry/static_sep16/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/34_urban/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Urban Land
*'
*' @description The urban land module is one of the land modules in MAgPIE 
*' (see also the other land modules: [30_crop], [31_past], [32_forestry], [35_natveg]). 
*' It describes urban settlement areas and estimates their corresponding carbon content.
*'
*' @authors Jan Philipp Dietrich, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%urban%" == "static" $include "./modules/34_urban/static/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the static realization, urban land remains static over time
*' with the spatial distribution of 1995 from the LUH2 data
*' set [@hurtt2018luh2]. Carbon stocks are fixed to zero because
*' information on urban land carbon density is missing.

*' @limitations Urban land is static over time and
*' corresponding carbon stocks are assumed zero

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "presolve" $include "./modules/34_urban/static/presolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/35_natveg/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Natural Vegetation
*'
*' @description The natural vegetation (natveg) land module is one of the land modules in MAgPIE
*' (see also the other land modules: [30_crop], [31_past], [32_forestry], [34_urban]).
*' It calculates land and carbon stocks, as well as the biodiversity value, of natural vegetation,
*' which consists of primary forest, secondary forest and other natural land.
*' The module determines the availability of natural vegetation for land conversion.
*'
*' @authors Florian Humpenöder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%natveg%" == "dynamic_feb21" $include "./modules/35_natveg/dynamic_feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the dynamic_may18 realization, land and carbon stock dynamics
*' of natural vegetation are modeled endogenously.
*' The initial spatial distribution of the sub-land-types primary forest,
*' secondary forest and other natural land is based on the
*' LUH2 data set [@hurtt2018luh2].
*' The realization includes 2 different kinds of land protection.
*' a) Land protection based on the World Database on Protected Areas (WDPA)
*' maintained by the International Union for Conservation of Nature (IUCN) and
*' b) land protection based on national policies implemented (NPI) and nationally
*' determined contributions to the Paris agreement (NDC) taken from individual country reports.
*' Land protection based on WDPA is static over time, while the NPI/NDC polices
*' ramp up until 2030 and are assumed constant thereafter. For WDPA the level of
*' land protection is based on IUCN catI+II, which reflect areas currently under
*' protection (e.g. strict nature reserves and national parks), and distributed
*' equally across all sub-land-types (primary forest, secondary forest and other natural land).
*' On top of the IUCN catI+II land protection, there are options to protect different
*' conservation priority areas such as biodiversity hotspots (BH), centers of plant
*' diversity (CBD), frontier forests (FF) and last of the wild (LW).
*' NPI/NDC land protection polices are be applied on forest and other land, depending
*' on individual country reports. Additionally, this module provides the ability to
*' harvest natural vegetation for timber. Both wood and woodfuel can be produceed
*' from primary and secondary forest but other land is only allowed to be harvested
*' for woodfuel.
*' @stop

*'
*' @limitations Initialization of both primary and secondary forest in highest
*' age class or equal distrivution of such areas in all age classes. Data exists
*' on a more emperically obtained distribution in different age classes based
*' on satellite data but this results is highly negative land-use change emissions.
*' Inclusion of this data in MAgPIE remains work in progess and is not available for release yet.
*' Additionally, in this module realizatuion, harvested secondary forest stays
*' secondary forest and harvested primary forest is reclassified as secondary forest.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/35_natveg/dynamic_feb21/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
  pol35 Land protection policy
  / none, npi, ndc /

  prot_type Conservation priority areas
  / BH, CPD, FF, LW, WDPA, HalfEarth /

  pol_stock35 Land types for land protection policies
  / forest, other /

  driver_source Source of deforestation drivers
  / overall, deforestation, shifting_agriculture,
  forestry, wildfire, urbanization /

  combined_loss(driver_source) Combined loss from fire plus agriculture
  / shifting_agriculture,wildfire /

;
*$Ifi "%phase%" == "declarations" $include "./modules/35_natveg/dynamic_feb21/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/35_natveg/dynamic_feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/35_natveg/dynamic_feb21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/35_natveg/dynamic_feb21/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/35_natveg/dynamic_feb21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/35_natveg/dynamic_feb21/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/35_natveg/dynamic_feb21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%natveg%" == "static" $include "./modules/35_natveg/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/38_factor_costs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @title Factor Costs

*' @description This module is used to calculate factor costs of production in
*' crop activities. The costs of factors of production included in this module
*' are specifically of labor, capital, and energy and related costs. The costs
*' are crop-specific, and pass to the the cost function in [11_costs].
*' Thus, factor costs will contribute to and influence the choice of production
*' pattern in the model.

*' @authors Jan Philipp Dietrich, Benjamin Bodirsky, Kristine Karstens, Edna J. Molina Bacca


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%factor_costs%" == "fixed_per_ton_mar18" $include "./modules/38_factor_costs/fixed_per_ton_mar18/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%factor_costs%" == "mixed_feb17" $include "./modules/38_factor_costs/mixed_feb17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This 'mixed' realization specifies factors costs to depend on
*' area harvested and agricultural land use intensity and corresponding average
*' production volumes.
*' Consequently, factor costs in this realization react on both: area under
*' production and average productivity of a region as captured by the $\tau$
*' factor. A detailed description of the approach can be found
*' in @dietrich_forecasting_2014 with background information about the used
*' intensity measure in @dietrich_measuring_2012.
*'
*' @limitations This realization assumes that factor costs only depend on area
*' and average productivity of a region. Productivity differences within a
*' region are ignored. Therefore, cases in which the cellular productivity
*' levels affect factors costs are only partially accounted for.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/38_factor_costs/mixed_feb17/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/38_factor_costs/mixed_feb17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/38_factor_costs/mixed_feb17/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/38_factor_costs/mixed_feb17/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/38_factor_costs/mixed_feb17/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/38_factor_costs/mixed_feb17/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%factor_costs%" == "sticky_feb18" $include "./modules/38_factor_costs/sticky_feb18/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/39_landconversion/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Land Conversion Costs

*' @description The land conversion cost module calculates costs for the conversion
*' from one land type to another (e.g. conversion from forest to cropland).
*' Land conversion plays an important role for the overall model dynamics,
*' in particular in terms of CO2 emissions from land-use change.
*' Expansion of agricultural land is one of the major options in the model to increase 
*' agricultural production, besides yield increases ([13_tc], [14_yields]) and trade ([21_trade]).
*' 
*'
*' @authors Florian Humpenöder, Jan Philipp Dietrich, Ulrich Kreidenweis

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%landconversion%" == "global_static_aug18" $include "./modules/39_landconversion/global_static_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In the global_static_aug18 realization, per hectare land conversion costs are separated into 
*' costs for expansion of cropland, pasture and forestry (establishment costs) and 
*' costs for clearing of primary forest, secondary forest and other natural land (clearing costs).
*' We assume a global cost factor of 8000 USD/ha (static over time) for establishment of managed land. 
*' For clearing of natural vegetation we assume a global static cost factor of 5 USD/tC (based on @kreidenweis_pasture_2018). 
*'
*' @limitations Data availability for land conversion costs is very limited.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/39_landconversion/global_static_aug18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
   land_establish39(land) Managed land pools
        / crop, past, forestry /

   land_clearing39(land) Natural vegetation land pools
        / primforest, secdforest, other /
;
*$Ifi "%phase%" == "declarations" $include "./modules/39_landconversion/global_static_aug18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/39_landconversion/global_static_aug18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/39_landconversion/global_static_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/39_landconversion/global_static_aug18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/39_landconversion/global_static_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/39_landconversion/global_static_aug18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/39_landconversion/global_static_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/40_transport/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Transport
*'
*' @description The [40_transport] module simulates the intraregional 
*' transportation of agricultural products between producer site 
*' and the next city centre (market). It covers the transport of 
*' inputs such as fertilizers to the production site as well as 
*' the transport of products to the market. Calculations are based 
*' on cellular and global parameters and returns the corresponding 
*' cellular transport costs which are then used by the [11_costs] module. 
*'
*' @authors Jan Philipp Dietrich, Florian Humpenöder, Benjamin Bodirsky, Isabelle Weindl, Michael Krause.

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%transport%" == "gtap_nov12" $include "./modules/40_transport/gtap_nov12/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization transportation costs
*' are calculated based on the assumption that transport
*' costs are proportional to the mass which has to be
*' transported and the time which is required for the transport.
*'
*' @limitations The information in distances between
*' production sites and markets is static over time,
*' meaning that infrastructure is assumed to be static
*' over time.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/40_transport/gtap_nov12/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/40_transport/gtap_nov12/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/40_transport/gtap_nov12/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/40_transport/gtap_nov12/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%transport%" == "off" $include "./modules/40_transport/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/41_area_equipped_for_irrigation/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Area equipped for irrigation
*'
*' @description The area equipped for irrigation module constrains irrigated crop
*' production to those areas that are equipped with irrigation infrastructure and simulates
*' the evolution of areas equipped for irrigation. The module receives information about
*' the area actually irrigated from the [30_crop] module.
*'
*' @authors Anne Biewald, Markus Bonsch, Christoph Schmitz

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%area_equipped_for_irrigation%" == "endo_apr13" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @description This realization allows the model to endogenously decide on investments to deploy additional
*' irrigation infrastructure, i.e. to increase the area equipped for irrigation (AEI). Initial values for AEI
*' in 1995 are taken from @siebert_FAO_2007. Contraction of AEI is not possible.
*' Irrigated crop production can only take place where irrigation infrastructure is present.
*'
*' Unit costs per hectare for AEI expansion are derived from a World Bank study (@worldbank_irrigation_1995)
*' and adjusted for the regions used in MAgPIE. The region mapping is as follows:
*'
*' ![Mapping between MAgPIE regions and the regions in 
*' [@worldbank_irrigation_1995]](regions.png){ width=60% }
*'
*' The regional unit costs converge linearly towards the European level until 2050.
*'
*' ![Unit costs for AEI expansion in MAgPIE
*' ](unitcosts.png){ width=60% }
*'
*' @limitations This realization increases model complexity.



*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%area_equipped_for_irrigation%" == "static" $include "./modules/41_area_equipped_for_irrigation/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/42_water_demand/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Water demand
*'
*' @description The water demand module determines the water demand in the following
*' sectors: agriculture, industry, electricity, domestic and ecosystem. 
*' Different scenarios for different water demand and environmental flow protection are
*' possible. The module receives information from the [17_production], [30_crop], [09_drivers]
*' and [43_water_availability] modules. It passes information to the module [43_water_availability]
*' and [11_costs].
*'
*' 
*' 
*' @authors Anne Biewald, Markus Bonsch

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%water_demand%" == "agr_sector_aug13" $include "./modules/42_water_demand/agr_sector_aug13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  
*'
*' This realization models agricultural sector water demand endogenously, while other sectors are kept exogenous;
*' Various settings for environmental water demand described below.
*'
*' *Agricultural water demand*:
*'
*' Water demand for agriculture is endogenously calculated based
*' on irrigated cropland `vm_area(j,kcr,"irrigated")` and livestock production
*' `vm_prod(j2,kli)`.
*'
*' Irrigation water demand per area for each crop category and cluster
*' is provided by the LPJmL model. This parameter refers to the water that
*' has to be applied to the field, i.e. it includes losses due to evaporation on
*' the field, but does not include losses during the water transport from source
*' to field. Livestock water demand `ic42_wat_req_k(j,kli)` is derived from FAO
*' data.
*'
*'
*' *Irrigation efficiency*:
*'
*' Switches for different scenarios for irrigation efficiency can be chosen:
*'
*' * A global static value of irrigation efficiency that is defined as the
*'   global weighted average of water losses from source to field ("conveyance
*'   efficiency times management factor") from @PIK_report104_2007.
*'   Here, irrigated area from @siebert_FAO_2007 has been used as aggregation
*'   weight.
*'
*' * A regression of country values of the "conveyance efficiency times
*'   management factor" from @PIK_report104_2007 on GDP.
*'
*' ![Irrigation efficiency evolution with GDP for the SSP2 scenario.
*'  ](irrigation_efficiency.png){ width=80% }
*'
*' *Non agricultural human water demand*:
*'
*' Water demand from all other sectors is treated exogenously. The scalar
*' `s42_reserved_fraction` determines how much water is reserved for non
*' agricultural purposes. Technically, it is assigned to industrial use, while
*' demand for other non-agricultural sectors is set to 0. The default value is
*' 0.5.
*'
*' *Environmental water demand*
*'
*' Environmental water requirements can be specified separately using the switch
*' `s42_env_flow_scenario`. The following settings are available:
*'
*' * No additional environmental flows are considered.
*' * A certain fraction of available water `s42_env_flow_fraction` is reserved
*'   for environmental purposes and consequently not available for agricultural
*'   activities (in addition to `s42_reserved_fraction`).
*' * Environmental flow requirements (EFR) are calculated from LPJmL inputs
*'   according to an algorithm by  @smakhtin_water_2004 on cluster level. Due to
*'   the fact that MAgPIE only considers available blue water during the growing
*'   period of the plants ([43_water_availability]), EFR are also only
*'   calculated during this growing period. They are reserved in addition to
*'   `s42_protected_fraction`. In the case of the absence of an environmental
*'   flow protection (EFP) policy, a base protection can be specified:
*'   `s42_env_flow_base_fraction`. Its default value is 5 % of available water.
*'
*' Whether a potential EFP policy takes effect is determined by the parameter
*' `f42_env_flow_policy`.
*'
*' @limitations The module uses the "conveyance efficiency times management
*' factor" for irrigation efficiency. Therefore, the management factor is
*' accounted twice, since it is already considered in LPJmL water quantity used
*' for irrigation (`airrig`: annual irrigation). Furthermore, the module
*' realization does not consider annual water balances but only water balances
*' during the growing period of crops. This period differs between cells.
*'

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/42_water_demand/agr_sector_aug13/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
   watdem_exo(wat_dem) Exogenous water demands 
   / industry, electricity, domestic, ecosystem /

   scen42 Environmental Flow Policy (EFP)
   / off, on /

   scen42_to_dev(scen42,dev) Mapping between EFP and economic development status
   /  off . (lic, mic)
	  on  . (hic) /
;
*$Ifi "%phase%" == "declarations" $include "./modules/42_water_demand/agr_sector_aug13/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/42_water_demand/agr_sector_aug13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/42_water_demand/agr_sector_aug13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/42_water_demand/agr_sector_aug13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/42_water_demand/agr_sector_aug13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/42_water_demand/agr_sector_aug13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/42_water_demand/agr_sector_aug13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%water_demand%" == "all_sectors_aug13" $include "./modules/42_water_demand/all_sectors_aug13/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/43_water_availability/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Water availability 
*'
*' @description The water availability module determines the water that is available 
*' in MAgPIE. The following water sources are currently implemented: surface water, 
*' groundwater, technical (like desalination etc.). Additionally, 
*' this module includes the main water constraint that requires water withdrawals 
*' to be smaller or equal to available water. Information is passed to and received 
*' from the [42_water_demand] module.
*'
*' @authors Anne Biewald, Markus Bonsch

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%water_availability%" == "total_water_aug13" $include "./modules/43_water_availability/total_water_aug13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' The calculation of available water as described below happens
*' in the MAgPIE preprocessing.
*' This realization only considers renewable water resources, i.e.
*' runoff generated from precipitation. All runoff is assumed to
*' enter rivers, neglecting groundwater recharge. Other water resources
*' such as fossil groundwater, discharge from melting glaciers or
*' desalination are also not considered. The calculation of available
*' water per grid cell is based on LPJmL (@bondeau_lpjml_2007) simulations. For
*' each river basin, total annual runoff in the basin constitutes the
*' amount of water available in one year. In order to account for the fact that
*' water can only be supplied to the plants during the growing period, the mean 
*' growing period over all crops based on LPJmL sowing and harvesting dates (@bondeau_lpjml_2007)
*' is calculated in MAgPIE. Some data has been excluded from the calculation:
*'
*' * Winter crops in the northern hemisphere (sowing date later than June 
*' 29th and harvest date later than December 31st) because we assume
*' that irrigation does not take place during winter time.
*'
*' * Data points with crop yields below 10% of the world average yield.
*' Such a low yield indicates that the site is not appropriate for this
*' specific crop and the LPJmL (@bondeau_lpjml_2007) growing period simulation
*' is likely to be distorted.
*'
*' Therefore, water available for irrigation in each basin only consists of the
*' total runoff occurring in the mean growing period in all basin cells
*' except for cells where water storage in terms of dams is present (taken
*' from @biemans_water_2011). In this case, total annual runoff is available.
*'
*' The distribution of basin runoff in the growing period to the individual
*' grid cells is done using LPJmL (@bondeau_lpjml_2007) discharge as a weight.
*'
*' There is an interface to the [42_water_demand] module. If exogenous
*' non-agricultural water demand exceeds available water the missing amount is available
*' from groundwater to avoid infeasibility.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/43_water_availability/total_water_aug13/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/43_water_availability/total_water_aug13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/43_water_availability/total_water_aug13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/43_water_availability/total_water_aug13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/43_water_availability/total_water_aug13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/43_water_availability/total_water_aug13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/43_water_availability/total_water_aug13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/44_biodiversity/module.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

*' @title Biodiversity
*'
*' @description The biodiversity module estimates how the changes in land pools
*' affect terrestrial biodiversity. It requires information about the land
*' area of the different land pools provided by all land modules ([30_crop], [31_past], [32_forestry],
*' [34_urban] and [35_natveg]), as well as module [10_land] about the potential natural vegetation.
*'
*'
*' @authors Patrick v. Jeetze, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%biodiversity%" == "bv_btc_mar21" $include "./modules/44_biodiversity/bv_btc_mar21/realization.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

*' @description In this realisation biodiversity values are computed for each
*' land cover type. The calculations are based on the Biodiversity Intactness Index (BII).
*' BII values for each land cover type are multiplied by the respective land area and
*' are weighted by cluster-specific range-rarity. This realisation also allows to introduce costs
*' on the loss of the total biodiversity value.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/44_biodiversity/bv_btc_mar21/sets.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

sets

	landcover44 land cover classes used in bii calculation
		/ crop_ann, crop_per, manpast, rangeland, urban, aff_ndc, aff_co2p, primforest, secdforest, other, plant /

	bii_class44 bii land cover classes
		/ crop_ann, crop_per, manpast, rangeland, urban, primary, secd_mature, secd_young, timber /

	price_biodiv44	price paths biodiv loss
		/ p0,p1,p1_p10,p10,p10_p100,p1_p1000,p10_p10000 /

;
*$Ifi "%phase%" == "declarations" $include "./modules/44_biodiversity/bv_btc_mar21/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/44_biodiversity/bv_btc_mar21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/44_biodiversity/bv_btc_mar21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/44_biodiversity/bv_btc_mar21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/44_biodiversity/bv_btc_mar21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/45_climate/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Climate
*'
*' @description The climate module provides information about the present
*' climate classes in the different cells (as shares of the total cell).
*' This information is used by other modules to choose climate class dependent
*' factors such as growth parameters correctly (e.g. used in [35_natveg]).
*'
*' @authors Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%climate%" == "static" $include "./modules/45_climate/static/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization climate classification information remains
*' static over the whole simulation based on data for 1976-2000 taken from
*' <http://koeppen-geiger.vu-wien.ac.at/shifts.htm> (@rubel_observed_2010).
*'
*' @limitations Temporal variations in climate classification are not considered.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/45_climate/static/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

* mappings to simplified climate regions exist in 58_peatland and 59_som
*' @code

sets
   clcl climate classification types
           /
           Af "Tropical rainforest climate"
           Am "Tropical monsoon climate"
           As "Tropical dry savanna climate"
           Aw "Tropical savanna, wet"
           BSh "Hot semi-arid (steppe) climate"
           BSk "Cold semi-arid (steppe) climate"
           BWh "Hot deserts climate"
           BWk "Cold desert climate"
           Cfa "Humid subtropical climate"
           Cfb "Temperate oceanic climate"
           Cfc "Subpolar oceanic climate"
           Csa "Hot-summer Mediterranean climate"
           Csb "Warm-summer Mediterranean climate"
           Csc "Cool-summer Mediterranean climate"
           Cwa "Monsoon-influenced humid subtropical climate"
           Cwb "Dry-winter subtropical highland climate"
           Cwc "Dry-winter subpolar oceanic climate"
           Dfa "Hot-summer humid continental climate"
           Dfb "Warm-summer humid continental climate"
           Dfc "Subarctic climate"
           Dfd "Extremely cold subarctic climate"
           Dsa "Hot, dry-summer continental climate"
           Dsb "Warm, dry-summer continental climate"
           Dsc "Dry-summer subarctic climate"
           Dsd "snow summer dry extremely continental"
           Dwa "Monsoon-influenced hot-summer humid continental climate"
           Dwb "Monsoon-influenced warm-summer humid continental climate"
           Dwc "Monsoon-influenced subarctic climate"
           Dwd "Monsoon-influenced extremely cold subarctic climate"
           EF "Ice cap climate"
           ET "Tundra"
           / 
;

*' @stop

*** EOF sets.gms ***
*$Ifi "%phase%" == "input" $include "./modules/45_climate/static/input.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/50_nr_soil_budget/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Nitrogen soil budget

*' @description The module 50_nr_soil_budget balances the nitrogen flows for crop land soils and pasture soils 
*' and calculates the resulting demand for inorganic fertilizer and associated costs.
 
*' @authors Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%nr_soil_budget%" == "exoeff_aug16" $include "./modules/50_nr_soil_budget/exoeff_aug16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization calculates the nitrogen balance for crop land and pasture land 
*' using exogenous uptake efficiencies. Several scenarios are available for the efficiency.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/50_nr_soil_budget/exoeff_aug16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

deposition_source51 Source of atmospheric deposition
/ agricultural_magpie, other_exogenous /

scen_neff50 Scenario for uptake efficiency
/ constant,neff_ZhangBy2030_start2010,neff_ZhangBy2050_start2010,
neff55_55_starty1990,neff60_60_starty1990,neff65_70_starty1990,
neff65_70_starty2010,neff60_60_starty2010,neff55_60_starty2010,
neff70_75_starty2010,neff75_80_starty2010,neff80_85_starty2010,
neff75_85_starty2010,neff85_85_starty2010 /

dep_scen50 Scenario for atmospheric deposition
/history/

;
*$Ifi "%phase%" == "declarations" $include "./modules/50_nr_soil_budget/exoeff_aug16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/50_nr_soil_budget/exoeff_aug16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/50_nr_soil_budget/exoeff_aug16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/50_nr_soil_budget/exoeff_aug16/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/50_nr_soil_budget/exoeff_aug16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/50_nr_soil_budget/exoeff_aug16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%nr_soil_budget%" == "off" $include "./modules/50_nr_soil_budget/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/51_nitrogen/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Nitrogen
*' @description
*' The nitrogen module calculates nitrogeneous emissions before technical
*' mitigation, including N2O, NOx, NH3, NO3- and N2. Sources of these emissions include
*' manure, inorganic fertilizers, crop residues, soil organic matter, and indirect emissions.
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%nitrogen%" == "ipcc2006_sep16" $include "./modules/51_nitrogen/ipcc2006_sep16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' The nitrogen module calculates nitrogeneous emissions before technical
*' mitigation, including N2O, NOx, NH3, NO3- and N2.
*' The model receives information on nitrogen flows from [50_nr_soil_budget],
*' [55_awms], [18_residues], [59_som], and it provides the emissions to the
*' module [56_ghg_policy].
*' Emissions factors estimates are largely based on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.),
*' as described in (@bodirsky_current_2012.).
*'
*' @authors Benjamin Leon Bodirsky

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/51_nitrogen/ipcc2006_sep16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
   emis_uncertainty51 Different estimates for emission parameters
   /best,low, high/

   ipcc_ef51 ipcc Emission factors
   /frac_gasf,frac_gasm,frac_leach,frac_leach_h,ef_1,ef_1fr,ef_2,ef_4,ef_5/

   emis_source_n51(emis_source) Emission sources from agriculture
   / inorg_fert, man_crop, awms, resid, man_past, som, rice /

   emis_source_nonitrogen51(emis_source) Emission sources
   / rice, ent_ferm,
     crop_vegc, crop_litc, crop_soilc,
     past_vegc, past_litc, past_soilc,
     forestry_vegc, forestry_litc, forestry_soilc,
     primforest_vegc, primforest_litc, primforest_soilc,
secdforest_vegc, secdforest_litc, secdforest_soilc,     urban_vegc, urban_litc, urban_soilc,
     other_vegc, other_litc, other_soilc,
     beccs/
;
*$Ifi "%phase%" == "declarations" $include "./modules/51_nitrogen/ipcc2006_sep16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/51_nitrogen/ipcc2006_sep16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/51_nitrogen/ipcc2006_sep16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/51_nitrogen/ipcc2006_sep16/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/51_nitrogen/ipcc2006_sep16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/51_nitrogen/ipcc2006_sep16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/51_nitrogen/ipcc2006_sep16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%nitrogen%" == "off" $include "./modules/51_nitrogen/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%nitrogen%" == "rescaled_jan21" $include "./modules/51_nitrogen/rescaled_jan21/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/52_carbon/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Carbon
*'
*' @description The carbon module provides annual land-related CO2 emissions for the
*' [56_ghg_policy] module. The carbon module provides carbon density information
*' on cellular level to all land modules ([30_crop], [31_past], [32_forestry],
*' [34_urban] and [35_natveg]), and in return it gets the current carbon stock
*' levels from respective land pools. The module also accounts for changes in
*' terrestrial carbon stocks cause by climate change effects on biosphere [45_climate].
*'
*'
*' @authors Benjamin Leon Bodirsky, Florian Humpenoeder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%carbon%" == "normal_dec17" $include "./modules/52_carbon/normal_dec17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization
*' calculates annual land-related CO2 emissions as
*' difference of carbon stocks between the current and the previous time step.
*' Land-related CO2 emissions include CO2 emissions from land-use change as well as
*' changes in carbon stocks in the terrestrial biosphere due to climate change
*' (the later is only included if `c52_carbon_scenario = "cc"`).
*' The realization provides carbon density information on cellular level to all
*' land modules ([30_crop], [31_past], [32_forestry], [34_urban] and [35_natveg]),
*' which return land type specific carbon stocks to the carbon module. The realization
*' also provides carbon density for different age-classes, based on a
*' chapman-richards volume growth model, to the land modules [32_forestry] and [35_natveg]
*' [@humpenoder_investigating_2014 and @braakhekke_modelling_2019].

*' @limitations CO2 emissions in the 1st time step (1995) are not meaningful because
*' carbon stock information prior to 1995 is not available

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/52_carbon/normal_dec17/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

ag_pools(c_pools) Above ground carbon pools
         /vegc,litc/
         
;
*$Ifi "%phase%" == "declarations" $include "./modules/52_carbon/normal_dec17/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/52_carbon/normal_dec17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/52_carbon/normal_dec17/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/52_carbon/normal_dec17/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "start" $include "./modules/52_carbon/normal_dec17/start.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/52_carbon/normal_dec17/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/52_carbon/normal_dec17/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%carbon%" == "off" $include "./modules/52_carbon/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/53_methane/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Methane

*' @description This module calculates methane emissions according
*' to 2006 IPCC Guidelines of National Greenhouse Gas Inventories.
*' See also @ipcc_2006_2006.

*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%methane%" == "ipcc2006_flexreg_apr16" $include "./modules/53_methane/ipcc2006_flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This module realization calculates methane from different
*' agricultural sources based on the @ipcc_2006_2006.
*' Methane emission sources considered in the module are enteric fermentation,
*' animal waste management, and rice.

*' @limitations CH4 emissions from animal waste management may be
*' inconsistent with CH4 emissions from enteric fermentation.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/53_methane/ipcc2006_flexreg_apr16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

k_conc53(kall) feedstuff with high energy content
   / tece,maiz,trce,rice_pro,soybean,rapeseed,groundnut,sunflower,puls_pro,
   potato,cassav_sp,sugr_cane,sugr_beet,others,cottn_pro,
   oils,oilcakes,sugar,molasses,distillers_grain,brans,scp,
   livst_rum, livst_pig,livst_chick, livst_egg, fish /

k_noconc53(kall) non-concentrates
   / pasture, foddr, res_cereals, res_fibrous, res_nonfibrous /

k_ruminants53(kli) ruminant subset
   / livst_rum, livst_milk /

emis_source_nomethane53(emis_source) emission sources
   / inorg_fert, man_crop, resid, man_past, som,
     resid_burn,
     crop_vegc, crop_litc, crop_soilc,
     past_vegc, past_litc, past_soilc,
     forestry_vegc, forestry_litc, forestry_soilc,
     primforest_vegc, primforest_litc, primforest_soilc,
	 secdforest_vegc, secdforest_litc, secdforest_soilc, 
	 urban_vegc, urban_litc, urban_soilc,
     other_vegc, other_litc, other_soilc,
     beccs /

;
*$Ifi "%phase%" == "declarations" $include "./modules/53_methane/ipcc2006_flexreg_apr16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/53_methane/ipcc2006_flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/53_methane/ipcc2006_flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/53_methane/ipcc2006_flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/53_methane/ipcc2006_flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/53_methane/ipcc2006_flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%methane%" == "off" $include "./modules/53_methane/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/54_phosphorus/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Phosphorus
*'
*' @description The phosphorus module is introduced to estimate the major
*' P-flows in the agricultural sector and to determine the dynamics of P-Pools in the soil.
*' Different P-flows can be accounted in MAgPIE, among others:
*'
*'     * P withdrawals by harvest: estimated as P content of crop harvest
*'     * P withdrawals by harvest of above ground residues: estimated as P content of residues
*'     * P inputs by decaying recycled residues: estimated as P content of recycled residues
*'     * P inputs by burned residues: estimated as P content of burned residues but no combustion losses assumed
*'     * P inputs by manure recycled to croplands
*'     * P inputs by fertilizers
*'     * P inputs by release of plant-available P from the permanent P-Pool.
*'     * P inputs by seed
*'     * P inputs by weathering
*'     * P losses by erosion
*'     * P losses by leaching
*'
*' However, for the time being, this module is not activated in MAgPIE.
*' It is a topic we seek to include in future developments of the model as enriches
*' the biophysical aspects of the model as well as adds to the fertilizer costs (and hence total costs of production).
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%phosphorus%" == "off" $include "./modules/54_phosphorus/off/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This is the current default implementation of the module.
*' It deactivates calculations related to the phosphorus module.

*' @limitations The realization is still under development.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/54_phosphorus/off/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/54_phosphorus/off/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/54_phosphorus/off/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/55_awms/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Animal waste management systems
*' @description
*' This module calculates the nutrient (NPK) flows within animal waste management.
*' It receives information on feed from the module [70_livestock], and provides
*' information on recycled manure to [50_nr_soil_budget] and information on
*' greenhouse gas emissions to modules [51_nitrogen] and [53_methane].
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%awms%" == "ipcc2006_aug16" $include "./modules/55_awms/ipcc2006_aug16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' Manure excretion is estimated using a mass balance approach and
*' based on NPK in feed and N in slaughtered animals (@bodirsky_current_2012.).
*' Animal waste management is largely based on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.).

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/55_awms/ipcc2006_aug16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

   awms animal waste management systems
   / grazing, stubble_grazing, fuel, confinement  /

   awms_prp(awms) animal waste management systems pasture range and paddock
   / grazing, stubble_grazing  /

   awms_conf animal waste management systems in confinements
   / lagoon, liquid_slurry, solid_storage, drylot, daily_spread, digester, other, pit_short, pit_long /

   scen_conf55 awms scenarios
   / constant,ssp1,ssp2,ssp3,ssp4,ssp5,sdp,a1,a2,b1,b2,GoodPractice/

;
*$Ifi "%phase%" == "declarations" $include "./modules/55_awms/ipcc2006_aug16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/55_awms/ipcc2006_aug16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/55_awms/ipcc2006_aug16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/55_awms/ipcc2006_aug16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/55_awms/ipcc2006_aug16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/55_awms/ipcc2006_aug16/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/55_awms/ipcc2006_aug16/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/55_awms/ipcc2006_aug16/nl_release.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_relax" $include "./modules/55_awms/ipcc2006_aug16/nl_relax.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%awms%" == "off" $include "./modules/55_awms/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/56_ghg_policy/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Greenhouse gas policy
*'
*' @description The module 56_ghg_policy connects emissions to costs which then enter 
*' the objective function of MAgPIE. Connecting emissions with costs in a cost 
*' minimization model like MAgPIE creates an incentive to reduce emissions. 
*' This can be interpreted as an internalization of the external costs by pollution, 
*' e.g. by policies that deincentivize polluting activity. 
*' Technically, every ton of emission is multiplied with an emission price to 
*' determine emission costs. Emission sources can be excluded from pricing by switches 
*' defined in config/default.cfg.
*'
*' Please note that emissions that occur only once (e.g. CO2 emissions from deforestation) 
*' are handled differently than emissions that occur in every timestep 
*' (e.g. CH4 and N2O emissions from agricultural production).
*'
*' @authors Benjamin Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%ghg_policy%" == "price_jan20" $include "./modules/56_ghg_policy/price_jan20/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization applies pollutant prices to different
*' emission types depending on the emission pricing policy defined in `f56_emis_policy`.
*' In addition, the average annual reward for carbon dioxide removal (CDR)
*' and the reward or penalty of local biophysical effects
*' from afforestation [32_forestry] is calculated as the present value (PV) of all
*' future cash flows multiplied with an annuity factor. The PV is obtained by
*' multiplication of `vm_cdr_aff` with the corresponding carbon price and subsequent
*' discouting based on the given discount rate `pm_interest`.
*' Technically, the reward for CDR and bph effects from afforestation is a negative cash flow
*' lowering the costs in the objective function of the model.
*' If pollutant prices are zero, which is the default for reference scenarios without
*' mitigation, total emission costs entering the objective function are zero.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/56_ghg_policy/price_jan20/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*###############################################################################
*######################## R SECTION START (SETS) ###############################
*THIS CODE IS CREATED AUTOMATICALLY, DO NOT MODIFY THESE LINES DIRECTLY
*ANY DIRECT MODIFICATION WILL BE LOST AFTER NEXT INPUT DOWNLOAD
*CHANGES CAN BE DONE USING THE INPUT DOWNLOADER UNDER SCRIPTS/DOWNLOAD
*THERE YOU CAN ALSO FIND ADDITIONAL INFORMATION

sets

   ghgscen56 ghg price scenarios /
       R2M41-SSP2-Budg1300,
       R2M41-SSP2-Budg600,
       R2M41-SSP2-Budg950,
       R2M41-SSP2-NDC,
       R2M41-SSP2-NPi,
       SSPDB-SSP1-19-IMAGE,
       SSPDB-SSP1-19-REMIND-MAGPIE,
       SSPDB-SSP1-26-IMAGE,
       SSPDB-SSP1-26-REMIND-MAGPIE,
       SSPDB-SSP1-34-IMAGE,
       SSPDB-SSP1-34-REMIND-MAGPIE,
       SSPDB-SSP1-45-IMAGE,
       SSPDB-SSP1-45-REMIND-MAGPIE,
       SSPDB-SSP1-Ref-IMAGE,
       SSPDB-SSP1-Ref-REMIND-MAGPIE,
       SSPDB-SSP2-19-MESSAGE-GLOBIOM,
       SSPDB-SSP2-19-REMIND-MAGPIE,
       SSPDB-SSP2-26-MESSAGE-GLOBIOM,
       SSPDB-SSP2-26-REMIND-MAGPIE,
       SSPDB-SSP2-34-MESSAGE-GLOBIOM,
       SSPDB-SSP2-34-REMIND-MAGPIE,
       SSPDB-SSP2-45-MESSAGE-GLOBIOM,
       SSPDB-SSP2-45-REMIND-MAGPIE,
       SSPDB-SSP2-60-MESSAGE-GLOBIOM,
       SSPDB-SSP2-60-REMIND-MAGPIE,
       SSPDB-SSP2-Ref-MESSAGE-GLOBIOM,
       SSPDB-SSP2-Ref-REMIND-MAGPIE,
       SSPDB-SSP3-34-AIM-CGE,
       SSPDB-SSP3-45-AIM-CGE,
       SSPDB-SSP3-60-AIM-CGE,
       SSPDB-SSP4-26-GCAM4,
       SSPDB-SSP4-34-GCAM4,
       SSPDB-SSP4-45-GCAM4,
       SSPDB-SSP4-60-GCAM4,
       SSPDB-SSP4-Ref-GCAM4,
       SSPDB-SSP5-19-REMIND-MAGPIE,
       SSPDB-SSP5-26-REMIND-MAGPIE,
       SSPDB-SSP5-34-REMIND-MAGPIE,
       SSPDB-SSP5-45-REMIND-MAGPIE,
       SSPDB-SSP5-60-REMIND-MAGPIE,
       SSPDB-SSP5-Ref-REMIND-MAGPIE /

   scen56 emission policy scenarios /
       none,
       all,
       all_nosoil,
       redd_nosoil,
       redd+_nosoil,
       redd+natveg_nosoil,
       maccs_excl_cropland_n2o /

;
*######################### R SECTION END (SETS) ################################
*###############################################################################

sets

   pollutants_all all pollutants
   / co2_c,
   ch4,
   n2o_n_direct, nh3_n, no2_n,
   no3_n,
   n2o_n_indirect,
   co,
   nmhc,
   h2,
   pm2_5,
   tpm,
   tc,
   oc,
   bc,
   so2 /

   pollutants(pollutants_all) subset of pollutants_all that can be taxed
   / co2_c,
   ch4,
   n2o_n_direct, n2o_n_indirect,
   nh3_n, no2_n,
   no3_n /

   n_pollutants(pollutants) subset of n pollutants
   / n2o_n_direct,n2o_n_indirect,
   nh3_n, no2_n,
   no3_n /

   n_pollutants_direct(n_pollutants) subset of n pollutants
   / n2o_n_direct,
   nh3_n, no2_n,
   no3_n /

   pollutant_nh3no2_51(n_pollutants_direct) nitrogen emissions relevant for deposition
   / nh3_n, no2_n /

   emis_source_n_cropsoils51(emis_source) activities that lead to emissions
   / inorg_fert, man_crop, resid, som, rice /

   emis_cell_one56(emis_source_cell) cellular oneoff emission sources
   /crop_vegc, crop_litc, crop_soilc, past_vegc, past_litc, past_soilc, forestry_vegc,
   forestry_litc, forestry_soilc, primforest_vegc, primforest_litc, primforest_soilc,
   secdforest_vegc, secdforest_litc, secdforest_soilc,
   urban_vegc, urban_litc, urban_soilc, other_vegc, other_litc, other_soilc/

   emis_reg_yr56(emis_source_reg) regional yearly emission sources
   /inorg_fert, man_crop, awms, resid, man_past, som,
   rice, ent_ferm,  beccs/

   ac_exp(ac) age-class corresponding to planning horizon
;

$onempty
sets
   emis_cell_yr56(emis_source_cell) cellular yearly emission sources
   / /

   emis_reg_one56(emis_source_reg) regional oneoff emission sources
   / /
 ;
$offempty
*$Ifi "%phase%" == "declarations" $include "./modules/56_ghg_policy/price_jan20/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/56_ghg_policy/price_jan20/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/56_ghg_policy/price_jan20/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/56_ghg_policy/price_jan20/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/56_ghg_policy/price_jan20/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/56_ghg_policy/price_jan20/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/57_maccs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Marginal Abatement Cost Curves
*'
*' @description This module describes technical mitigation of GHG emissions.
*' It allows to reduce GHG emissions by undertaking mitigation
*' measures in exchange for additional mitigation costs.
*' The technical mitigation measures include, for example, better spreader maintenance,
*' feed additives or investments in animal waste management facilities.
*' Please note that technical mitigation is possible only in the "on" module realization below.
*' For simplicity, we considered only the effects of mitigation measure costs and emissions.
*' Their direct consequences on biophysical values like yields or water requirements is ignored at the moment.
*'
*' Mitigation costs are estimated using marginal abatement cost curves (MACCs).
*' The curves are applied on the original emissions before technical mitigation (btm),
*' and reduce them by a certain percentage in exchange for additional costs.
*' The MACCs used in this module are based on the data from @LUCAS200785.  
*'
*' @authors Benjamin Leon Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%maccs%" == "off_jul16" $include "./modules/57_maccs/off_jul16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%maccs%" == "on_sep16" $include "./modules/57_maccs/on_sep16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description Unlike the previous realization, this implementation allows for the possibility
*' that non-CO2 emissions can be reduced by technical mitigation at additional costs.
*' The following MACC data sets are available in this module:
*' @LUCAS200785 (PBL_2007) and @Harmsen2019 (PBL_2019).
*'
*' @limitations The data set PBL_2007 is outdated and only kept for backward compatibility

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/57_maccs/on_sep16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

  emis_source_inorg_fert_n2o(emis_source) subset inorg_fert_n2o emissions 
  /inorg_fert,resid,som,rice/

  emis_source_awms_manure_n2o(emis_source) subset awms_manure_n2o
  /man_crop,man_past,awms/

  emis_source_rice_ch4(emis_source) subset rice emissions
  /rice/
  
  emis_source_ent_ferm_ch4(emis_source) subset ent_ferm emissions
  /ent_ferm/
  
  emis_source_awms_ch4(emis_source) subset awms emissions
  /awms/

  maccs_ch4 ch4 mitigation categories with MACCS
   / rice_ch4, ent_ferm_ch4, awms_ch4 /
 
  maccs_n2o n2o mitigation categories with MACCS
   / inorg_fert_n2o, awms_manure_n2o /

  maccs_steps maccs tax level steps
   / 1*201 /

;
*$Ifi "%phase%" == "declarations" $include "./modules/57_maccs/on_sep16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/57_maccs/on_sep16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/57_maccs/on_sep16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/57_maccs/on_sep16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/57_maccs/on_sep16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/58_peatland/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Peatland
*'
*' @description The peatland module calculates GHG emissions from degrading/drained peatlands.
*'
*' @authors Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%peatland%" == "off" $include "./modules/58_peatland/off/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization GHG emissions from degrading peatlands are assumed zero.

*' @limitations GHG emissions from degrading peatlands are assumed zero

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/58_peatland/off/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/58_peatland/off/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/58_peatland/off/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%peatland%" == "on" $include "./modules/58_peatland/on/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/59_som/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Soil organic matter

*' @description
*' The soil organic matter module calculates the soil organic carbon loss due to landuse activities.
*' It also estimates the nitrogen release due to the soil organic carbon turnover.  

*' @authors Benjamin Leon Bodirsky, Kristine Karstens




*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%som%" == "cellpool_aug16" $include "./modules/59_som/cellpool_aug16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%som%" == "static_jan19" $include "./modules/59_som/static_jan19/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The static_jan19 realization is built on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.). It calculates the loss of
*' soil carbon due to cropping activities based on stock change factors, compared to
*' potential natural vegetation.
*' This approach does not account for the temporal dimension of soil organic carbon change,
*' since it assumes a complete loss of carbon directly after land conversion to cropland.
*' Therefore, no release of nitrogen due to soil organic matter loss is calculated.
*' Moreover only one stock change factor for all crop types is used, neglecting
*' e.g. differences for annual and perennial crops.

*' @limitations The soil carbon dynamics are instantaneous and do not account
*' for any time dependent release of soil carbon.
*' The soil carbon pools on cropland are not crop type specific.
*' The release of nitrogen due to soil organic matter loss is not calculated.
*' It is assumed that pastures and rangelands as well as managed forests
*' do not change in soil carbon compared to the natural reference state.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/59_som/static_jan19/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
noncropland59(land) Soil carbon conserving landuse types
/past, forestry, primforest, secdforest, other/

;
*$Ifi "%phase%" == "declarations" $include "./modules/59_som/static_jan19/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/59_som/static_jan19/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/59_som/static_jan19/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/59_som/static_jan19/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/59_som/static_jan19/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/59_som/static_jan19/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/60_bioenergy/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Bioenergy
*'
*' @description The bioenergy module provides a regional and crop-specific
*' bioenergy demand $vm\_dem\_bioen$ to the model (to the [16_demand] module).
*' For this calculation it requires
*' information on gross energy content (provided by [16_demand] module).
*' 
*' In addition to calculation of bioenergy quantities, the costs associated with 
*' the production are provided to the objective function in the [11_costs] module.
*'
*' @authors Jan Philipp Dietrich


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%bioenergy%" == "1stgen_priced_dec18" $include "./modules/60_bioenergy/1stgen_priced_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/60_bioenergy/1stgen_priced_dec18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*###############################################################################
*######################## R SECTION START (SETS) ###############################
*THIS CODE IS CREATED AUTOMATICALLY, DO NOT MODIFY THESE LINES DIRECTLY
*ANY DIRECT MODIFICATION WILL BE LOST AFTER NEXT INPUT DOWNLOAD
*CHANGES CAN BE DONE USING THE INPUT DOWNLOADER UNDER SCRIPTS/DOWNLOAD
*THERE YOU CAN ALSO FIND ADDITIONAL INFORMATION

sets

   scen2nd60 second generation bioenergy scenarios /
       R2M41-SSP2-Budg1300,
       R2M41-SSP2-Budg600,
       R2M41-SSP2-Budg950,
       R2M41-SSP2-NDC,
       R2M41-SSP2-NPi,
       SSPDB-SSP1-19-IMAGE,
       SSPDB-SSP1-19-REMIND-MAGPIE,
       SSPDB-SSP1-26-IMAGE,
       SSPDB-SSP1-26-REMIND-MAGPIE,
       SSPDB-SSP1-34-IMAGE,
       SSPDB-SSP1-34-REMIND-MAGPIE,
       SSPDB-SSP1-45-IMAGE,
       SSPDB-SSP1-45-REMIND-MAGPIE,
       SSPDB-SSP1-Ref-IMAGE,
       SSPDB-SSP1-Ref-REMIND-MAGPIE,
       SSPDB-SSP2-19-REMIND-MAGPIE,
       SSPDB-SSP2-26-REMIND-MAGPIE,
       SSPDB-SSP2-34-REMIND-MAGPIE,
       SSPDB-SSP2-45-REMIND-MAGPIE,
       SSPDB-SSP2-60-REMIND-MAGPIE,
       SSPDB-SSP2-Ref-REMIND-MAGPIE,
       SSPDB-SSP5-19-REMIND-MAGPIE,
       SSPDB-SSP5-26-REMIND-MAGPIE,
       SSPDB-SSP5-34-REMIND-MAGPIE,
       SSPDB-SSP5-45-REMIND-MAGPIE,
       SSPDB-SSP5-60-REMIND-MAGPIE,
       SSPDB-SSP5-Ref-REMIND-MAGPIE /

;
*######################### R SECTION END (SETS) ################################
*###############################################################################

sets

   kbe60(kall) bio energy activities
        / betr, begr /

   k1st60(kall) 1st generation bioenergy carriers
        / oils, ethanol /

   scen1st60 first generation bioenergy scenarios
       / const2020, const2030, phaseout2020 /

   scen2ndres60 residues for second generation bioenergy scenarios
       / ssp1, ssp2, ssp3, ssp4, ssp5, sdp, off /

;
*$Ifi "%phase%" == "declarations" $include "./modules/60_bioenergy/1stgen_priced_dec18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/60_bioenergy/1stgen_priced_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/60_bioenergy/1stgen_priced_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/60_bioenergy/1stgen_priced_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/60_bioenergy/1stgen_priced_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/60_bioenergy/1stgen_priced_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/60_bioenergy/1stgen_priced_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/62_material/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Material
*'
*' @description
*' The material module describes the demand for material usage
*' based on historical data. Material uage is derived from FAO's "other utils"
*' category, and includes for example the use of agricultural products
*' for cosmetics, chemical usage or textiles. In contrast to FAO's other util
*' category, the use for bioenergy (oils and ethanol) has been excluded
*' and is accounted for in the demand for bioenergy. Material demand in this
*' context can be considered as a subset of "other utils" category of FAO.

*' @authors Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%material%" == "exo_flexreg_apr16" $include "./modules/62_material/exo_flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In the exo_flexreg_apr16 realisation, demand for material usage
*' is estimated to grow proportional to food demand calculated by `vm_dem_food` interface
*' in food module([15_food]). Observed material demand is fed as an input to the
*' material module based on historical data. The assumption that material demand
*' grows proportional to food demand is a simplification that can be justified
*' by the minor importance of non-bioenergy material usage of agricultural products.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/62_material/exo_flexreg_apr16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


sets
   material_scen62  scenarios
       / SSP1,SSP2,SSP3,SSP4,SSP5,
         SSP1_boundary,SSP2_boundary,SSP3_boundary,SSP4_boundary,SSP5_boundary,
         a1,a2,b1,b2,
         history,
         SSP2_lowls,SSP2_lowcal /
;
*$Ifi "%phase%" == "declarations" $include "./modules/62_material/exo_flexreg_apr16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/62_material/exo_flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/62_material/exo_flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/62_material/exo_flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/62_material/exo_flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/62_material/exo_flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################

*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/70_livestock/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Livestock
*'
*' @description The livestock module calculates how much and what kind of
*' biomass is required as feed to produce livestock food commodities.
*'
*' For this purpose, the livestock module provides for every time-step regional
*' and product-specific feed baskets that determine type and magnitude of feed
*' needed to produce one unit of livestock commodities. Estimated pasture
*' feed demand is also relevant for the module [31_past] in order to derive
*' required pasture areas. The information flow between the livestock and the
*' pasture module is organized via interfaces `vm_dem_feed`, `vm_supply` and
*' `vm_prod_reg` via modules [16_demand] and [21_trade]. Feed demand estimates
*' are also required for the modules [53_methane] and [55_awms]. Additionally,
*' the livestock module provides production costs for livestock commodities.
*'
*' @authors Isabelle Weindl, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%livestock%" == "fbask_jan16" $include "./modules/70_livestock/fbask_jan16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The fbask_jan16 realization of the livestock module is based on
*' the methodology as described in @weindl_livestock_2017 and
*' @weindl_livestock_2017-1. An important part of the feed demand calculations
*' is conducted outside of the core MAgPIE-GAMS code. Livestock products
*' (ruminant meat, whole-milk, pork, poultry meat and eggs) are supplied by five
*' animal food systems (beef cattle, dairy cattle, pigs, broilers and laying
*' hens). The parameterization of the livestock sector in the initial year is
*' consistent with FAO statistics regarding livestock production, livestock
*' productivity and concentrate feed use.

*' The fbask_jan16 realization requires regional and product-specific feed
*' baskets that are calculated by a set of preprocessing routines outside of the
*' MAgPIE-GAMS code. Following the methodology of @wirsenius_human_2000, feed
*' conversion (total feed input per product output in dry matter) and feed
*' baskets (demand for different feed types per product output in dry matter)
*' are derived by compiling system-specific feed energy balances. For the
*' establishment of these balances, we apply feed energy requirements per output,
*' as estimated by wirsenius_human_2000 for each animal function and animal food
*' system. These estimates are based on standardized bio-energetic equations and
*' include the minimum energy requirements for maintenance, growth, lactation,
*' reproduction and other basic biological functions of the animals. Moreover,
*' they comprise a general allowance for basic activity and temperature effects.

*' By distributing the available feed at country level to animal food systems
*' according to their feed energy demand and dividing resulting dry matter feed
*' use by the production volume of the respective systems, we obtain both
*' estimates for feed conversion and feed baskets across different animal food
*' systems and countries.

*' To facilitate projections of feed conversion and feed baskets, we create
*' regression models with livestock productivity (annual production per animal
*' [ton fresh matter/animal/year]) as predictor, which permit the construction
*' of livestock feeding scenarios. Currently, feeding scenarios are derived
*' based on exogenous livestock productivity scenarios consistent with the
*' storylines of the Shared Socioeconomic Pathways (SSPs). For beef cattle, pigs
*' and broilers, livestock productivity is defined as meat production per
*' animals in stock (e.g. total cattle herd) and for dairy cattle and laying hen
*' as milk or egg production per producing animals (e.g. milk cows).

*' A power function is used to describe the functional relation between feed
*' conversion and livestock productivity:

*' ![Relationship between feed conversion and livestock productivity
*' [@weindl_livestock_2017].](feed_conv.jpg){ width=100% }

*' In the case of feed composition, we use an additional proxy parameter in our
*' analysis. What type of biomass is used to feed animals is to a certain extent
*' influenced by universal aspects (e.g. the need for more energy-rich feed at
*' higher productivity levels), whereas other aspects are strongly influenced by
*' geographical location (e.g. availability and costs of permanent pasture
*' compared to cropland feed, agro-ecological and climatic conditions that
*' favour selected feed items; socio-cultural determinants etc.). For cattle
*' systems the proxy (climate-zone specific factor) was determined by
*' calculating the share of the national population living in arid and cold
*' climate zones.

*' ![Relationship between the share of crop residues, occasional feed and grazed
*' biomass in feed baskets and livestock productivity for beef cattle systems
*' [@weindl_livestock_2017].](feed_comp_beef.jpg){ width=60% }

*' ![Relationship between the share of crop residues, occasional feed and grazed
*' biomass in feed baskets and livestock productivity for diary cattle systems
*' [@weindl_livestock_2017].](feed_comp_dairy.jpg){ width=60% }

*' These relationships between feed baskets and livestock productivity are used 
*' to construct feeding scenarios that reflect the narratives of the SSPs. The 
*' resulting feed baskets enter the MAgPIE model as scenario-dependent input data
*' and are crucial for the feed demand calculations in the livestock module.

*' @limitations Intensification of livestock production and related changes in
*' livestock feeding are modelled exogenously. Therefore, the livestock sector
*' does not endogenously respond to demand and climate shocks and policies, e.g.
*' targeting climate protection.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/70_livestock/fbask_jan16/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
   cost_regr Cost regression parameters
    /cost_regr_a,cost_regr_b/

   feed_scen70  scenarios
       / ssp1,ssp2,ssp3,ssp4,ssp5,constant /

   sys Livestock production systems
     /sys_pig, sys_beef, sys_chicken, sys_hen, sys_dairy/

   sys_meat(sys) Livestock meat production systems
     /sys_pig, sys_beef, sys_chicken/

   sys_nonmeat(sys) Livestock non-meat production systems
     /sys_hen, sys_dairy/


  sys_to_kli(sys,kli) Mapping between livestock producton systems and livestock products
  /sys_pig    . livst_pig
   sys_beef    . livst_rum
   sys_chicken  . livst_chick
   sys_hen . livst_egg
   sys_dairy .livst_milk
   /

   kcer70(kall) Cereals
   / tece, maiz, trce, rice_pro /

  fadeoutscen70  Feed substitution scenarios including functional forms with targets and transition periods
       / constant,
         lin_zero_10_50, lin_zero_20_50, lin_zero_20_30, lin_zero_20_70, lin_50pc_20_50, lin_50pc_20_50_extend65, lin_50pc_20_50_extend80,
         lin_50pc_10_50_extend90, lin_75pc_10_50_extend90, lin_80pc_20_50, lin_80pc_20_50_extend95, lin_90pc_20_50_extend95,
	 lin_99-98-90pc_20_50-60-100, sigmoid_20pc_20_50, sigmoid_50pc_20_50, sigmoid_80pc_20_50 /

;
*$Ifi "%phase%" == "declarations" $include "./modules/70_livestock/fbask_jan16/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/70_livestock/fbask_jan16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/70_livestock/fbask_jan16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/70_livestock/fbask_jan16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/70_livestock/fbask_jan16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/70_livestock/fbask_jan16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/71_disagg_lvst/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Disaggregation of livestock distribution
*'
*' @description The module 71_disagg_lvst calculates the livestock distribution within a region onto
*' cellular level. Without constrains in this module cellular livestock production is determined by
*' the modules 40_transport accounting for transport costs and module 42_water_demand connecting
*' livestock production to water demand and thus to water availability.
*'
*' @authors Kristine Karstens, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%disagg_lvst%" == "foragebased_aug18" $include "./modules/71_disagg_lvst/foragebased_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The foragebased_aug18 realization constrains the cellular ruminant livestock production by 
*' the feed availability for grazed pasture and fodder crops. This accounts for the fact that pasture and fodder 
*' (summarized with forage) feed stuff is usually not transported over long distances and at the same time 
*' is very essential in livestock diets. The monogastric livestock is distributed following the idea 
*' that these animals are held close to densely populated areas. For more detailed information on cellular livestock 
*' distribution see @robinson_mapping_2014, which inspired this realization.

*' @limitations Distribution of monogastrics do not account for feed availability within a cell. Crop residue feed stuff
*' for ruminant production is also not considered to restrict livestock production.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/71_disagg_lvst/foragebased_aug18/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets
   kli_rum(kli) Ruminant livestock
   /
   livst_rum, livst_milk
   /

   kli_mon(kli) Monogastric livestock
   /
   livst_pig, livst_chick, livst_egg
   /
   
   kforage(k) Forage feed categories
   /
	pasture, foddr
   / 
; 

alias(j,j3);
alias(cell,cell2);
alias(kforage,kforage2);
*$Ifi "%phase%" == "declarations" $include "./modules/71_disagg_lvst/foragebased_aug18/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/71_disagg_lvst/foragebased_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/71_disagg_lvst/foragebased_aug18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/71_disagg_lvst/foragebased_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/71_disagg_lvst/foragebased_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/71_disagg_lvst/foragebased_aug18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/71_disagg_lvst/foragebased_aug18/nl_release.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%disagg_lvst%" == "off" $include "./modules/71_disagg_lvst/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/73_timber/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Timber
*'
*' @description This module handles the production of timber using plantations [32_forestry]
*' and natural vegetation [35_natveg]. Timber can be produced from both commercial plantations
*' and natural forests. The module feeds `vm_prod` at cluster level to [17_production] and
*' [21_trade] modules. This module also calculates the "real" harvested area in natural
*' forests i.e. `v35_hvarea_primforest`,`v35_hvarea_secdforest` and `v73_hvarea_other`.
*'
*' @authors Abhijeet Mishra, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%timber%" == "default" $include "./modules/73_timber/default/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description biomass_mar20 realization acts as a common tunnel for land related
*' decisions in forestry [32_forestry] and natveg [35_natveg] modules and corresponding
*' production of woody biomass realized. This realization harvests timber from
*' available plantations to meet a portion of overall timber demand. Rest of the timber
*' production comes by harvesting natural vegetation. Aggregated timber demand for
*' wood and woodfuel is calculated based on demand equation from @lauri_timber_demand
*' and income elasticities from @morland2018supply. The timber demand calculated is further
*' adjusted between the solve steps where if the model sees no way of producing timber
*' from existing resources, the demand is lowered down to an extent that an adjusted level
*' of demand can be met with resources at hand.

*' @limitations Timber demand cannot be determined endogenously

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/73_timber/default/sets.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

sets

total_wood_products   End use wood product category from FAO
/
roundwood,
industrial_roundwood,wood_fuel,other_industrial_roundwood,
pulpwood,sawlogs_and_veneer_logs,fibreboard,particle_board_and_osb,
wood_pulp,sawnwood, plywood, veneer_sheets,
wood_based_panels,other_sawnwood
/

wood_products(total_wood_products)  Major 2nd level products from wood processing
/
fibreboard,particle_board_and_osb,plywood,veneer_sheets,
wood_pulp,
sawnwood,
other_industrial_roundwood
/

construction_wood(total_wood_products)        Wood products used for building construction
/
fibreboard,particle_board_and_osb,plywood,veneer_sheets,sawnwood
/

wood_panels(wood_products)        Wood products used for panels construction
/
fibreboard,particle_board_and_osb,plywood,veneer_sheets
/

kforestry_to_woodprod(kforestry,total_wood_products) Mapping between intermediate and end use wood products
/
wood . (fibreboard,particle_board_and_osb,plywood,veneer_sheets,wood_pulp,sawnwood,other_sawnwood,other_industrial_roundwood)
woodfuel . (wood_fuel)
/

scen_73 Forestry future scenario
/
nopaper, construction
/

;
*** EOF sets.gms ***
*$Ifi "%phase%" == "declarations" $include "./modules/73_timber/default/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/73_timber/default/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/73_timber/default/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/73_timber/default/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/73_timber/default/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/73_timber/default/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/73_timber/default/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/80_optimization/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Optimization
*'
*' @description This module takes care of the model optimization of
*' the main model, allowing for switching between optimization procedures.
*' It has been introduced to play with different ways to affect the runtime
*' performance of the model via more optimized model solution strategies.
*' The interfaces to the rest of the model are quite limited as it only requires
*' the variables to be optimized `vm_cost_glo` (total costs) and `vm_landdiff`
*' (gross land use changes compared to last time step) as direct input.
*' The latter was introduced to select out of a range of cost optimal patterns
*' that one which is closest to the pattern of the previous time step. While
*' CONOPT returns this solution by default, CPLEX does not.
*'
*' @authors Jan Philipp Dietrich, Todd Munson

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%optimization%" == "lp_nlp_apr17" $include "./modules/80_optimization/lp_nlp_apr17/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%optimization%" == "nlp_apr17" $include "./modules/80_optimization/nlp_apr17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In this realization the model is solved directly using nonlinear optimization.
*' If the optimization returns an infeasible solution the solve is repeated,
*' either until a feasible solution is found or the maximum number of iterations
*' as defined in `s80_maxiter` is reached.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/80_optimization/nlp_apr17/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/80_optimization/nlp_apr17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "solve" $include "./modules/80_optimization/nlp_apr17/solve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%optimization%" == "nlp_par" $include "./modules/80_optimization/nlp_par/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*######################## R SECTION END (MODULES) ##############################
$offrecurse
*** EOF include.gms ***
********************************************************************************

**********INTRODUCE CALCULATION PARAMETERS, VARIABLES AND EQUATIONS*************
*$include "./core/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

scalars
 sm_intersolve              if 0 finish loop or if 1 iterate optimization (1) /0/
 sm_fix_SSP2				year until which all parameters are fixed to SSP2 values (year) / 2020 /
;

*** EOF declarations.gms ***
*$batinclude "./modules/include.gms" declarations DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


$setglobal phase %1
$onrecurse
*######################## R SECTION START (MODULES) ############################
*$include "./modules/09_drivers/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Drivers
*'
*' @description The Drivers module provides data on drivers
*' that are used by several other modules. It mainly aggregates inputs related 
*' to population and GDP. If an input is required in one module or realization only, 
*' the input driver is provided directly by the module that demands it, 
*' rather than by the [09_drivers] module. 
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%drivers%" == "aug17" $include "./modules/09_drivers/aug17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the aug17 realization, inputs are taken into the module and are directly 
*' delivered to the modules that require the data.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/09_drivers/aug17/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/09_drivers/aug17/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de
parameters

* Population
  im_pop_iso(t_all,iso)                              Population (mio. per yr)
  im_pop(t_all,i)                                    Population (mio. per yr)

* GDP in MER
  i09_gdp_mer_iso(t_all,iso)                  Income in market exchange rates (mio. USD05MER per yr)
  i09_gdp_mer(t_all,i)                        Income in market exchange rates (mio. USD05MER per yr)

  im_gdp_pc_mer(t_all,i)                Per capita income in market exchange rates (USD05MER per cap per yr)
  i09_gdp_pc_mer_iso(t_all,iso)         Per capita income in market exchange rates (USD05MER per cap per yr)

* GDP in PPP
  i09_gdp_ppp_iso(t_all,iso)                      Income in purchasing power parity (mio. USD05PPP per yr)
  i09_gdp_ppp(t_all,i)                            Income in purchasing power parity (mio. USD05PPP per yr)

  i09_gdp_pc_ppp(t_all,i)                Per capita income in purchasing power parity (USD05PPP per cap per yr)
  im_gdp_pc_ppp_iso(t_all,iso)          Per capita income in purchasing power parity (USD05PPP per cap per yr)

* Development State
  im_development_state(t_all,i)                  Development state according to the World Bank definition where 0=low income country 1=high income country in high income level  (1)
  im_physical_inactivity(t_all,iso,sex,age)          Share of population which is physically inactive (1)
  im_demography(t_all,iso,sex,age)                   Population by groups (mio. per yr)
;
*$Ifi "%phase%" == "input" $include "./modules/09_drivers/aug17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/09_drivers/aug17/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/10_land/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Land

*' @description The land module coordinates and analyzes all land related activities
*' by summing up all land types and calculating the gross changes in land use
*' between two time steps of optimization given the recursive dynamic structure of
*' MAgPIE model.

*' @authors Jan Philipp Dietrich, Florian Humpenoeder, Kristine Karstens

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%land%" == "feb15" $include "./modules/10_land/feb15/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%land%" == "landmatrix_dec18" $include "./modules/10_land/landmatrix_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The landmatrix_dec18 realization tracks land use transitions by
*' directly counting sources and targets of conversions.

*' @limitations There are currently no known limitations of this realization.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/10_land/landmatrix_dec18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/10_land/landmatrix_dec18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 pm_land_start(j,land)         Land initialization area (mio. ha)
 pcm_land(j,land)              Land area in previous time step (mio. ha)
;

variables
 vm_landdiff                   Aggregated difference in land between current and previous time step (mio. ha)
;

positive variables
 vm_land(j,land)                             Land area of the different land types (mio. ha)
 vm_landexpansion(j,land)                    Land expansion (mio. ha)
 v10_landreduction(j,land)                   Land reduction (mio. ha)
 vm_croplandexpansion(j,land)                Sources of cropland expansion (mio. ha)
 vm_croplandreduction(j,land)                Targets of cropland reduction (mio. ha)
 vm_cost_land_transition(j)		               Costs for lu transitions (mio. USD05MER per yr)
 v10_lu_transitions(j,land_from10,land_to10) Land transitions between time steps (mio. ha)
;

equations
 q10_transition_matrix(j)			        Land transition constraint cell area (mio. ha)
 q10_transition_to(j,land_to10)		    Land transition constraint to (mio. ha)
 q10_transition_from(j,land_from10)	  Land transition constraint from (mio. ha)
 q10_landexpansion(j,land_to10)       Land expansion constraint (mio. ha)
 q10_landreduction(j,land_from10)     Land reduction constraint (mio. ha)
 q10_croplandreduction(j,land_to10)   Cropland reduction constraint (mio. ha)
 q10_croplandexpansion(j,land_from10) Cropland expansion constraint (mio. ha)
 q10_cost(j)                    	    Costs for lu transitions (mio. USD05MER per yr)
 q10_landdiff                        	Land difference constraint (mio. ha)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_landdiff(t,type)                                 Aggregated difference in land between current and previous time step (mio. ha)
 ov_land(t,j,land,type)                              Land area of the different land types (mio. ha)
 ov_landexpansion(t,j,land,type)                     Land expansion (mio. ha)
 ov10_landreduction(t,j,land,type)                   Land reduction (mio. ha)
 ov_croplandexpansion(t,j,land,type)                 Sources of cropland expansion (mio. ha)
 ov_croplandreduction(t,j,land,type)                 Targets of cropland reduction (mio. ha)
 ov_cost_land_transition(t,j,type)                   Costs for lu transitions (mio. USD05MER per yr)
 ov10_lu_transitions(t,j,land_from10,land_to10,type) Land transitions between time steps (mio. ha)
 oq10_transition_matrix(t,j,type)                    Land transition constraint cell area (mio. ha)
 oq10_transition_to(t,j,land_to10,type)              Land transition constraint to (mio. ha)
 oq10_transition_from(t,j,land_from10,type)          Land transition constraint from (mio. ha)
 oq10_landexpansion(t,j,land_to10,type)              Land expansion constraint (mio. ha)
 oq10_landreduction(t,j,land_from10,type)            Land reduction constraint (mio. ha)
 oq10_croplandreduction(t,j,land_to10,type)          Cropland reduction constraint (mio. ha)
 oq10_croplandexpansion(t,j,land_from10,type)        Cropland expansion constraint (mio. ha)
 oq10_cost(t,j,type)                                 Costs for lu transitions (mio. USD05MER per yr)
 oq10_landdiff(t,type)                               Land difference constraint (mio. ha)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/10_land/landmatrix_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/10_land/landmatrix_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/10_land/landmatrix_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "start" $include "./modules/10_land/landmatrix_dec18/start.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/10_land/landmatrix_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/10_land/landmatrix_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/10_land/landmatrix_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/11_costs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Costs
*'
*' @description The cost module determines the sum total of global production
*' costs in each time step. MAgPIE's objective is to minimize the global cost of
*' production in a recursive dynamic way. The interface variable `vm_cost_glo`
*' is used for this purpose. The model optimizes the production activities
*' accordingly to ensure that all the demand and supply constraints are met
*' while minimizing the global production costs.

*' @authors Benjamin Leon Bodirsky, Florian Humpenöder, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%costs%" == "default" $include "./modules/11_costs/default/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @description The default realization of the costs module calculates global production
*' costs with a constraint of production always fulfilling the demand.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/11_costs/default/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

variables
 vm_cost_glo                     Total costs of production (mio. USD05MER per yr)
 v11_cost_reg(i)                 Regional costs            (mio. USD05MER per yr)
;

equations
 q11_cost_glo                    Objective function        (mio. USD05MER per yr)
 q11_cost_reg(i)                 Regional cost constraint  (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_glo(t,type)     Total costs of production (mio. USD05MER per yr)
 ov11_cost_reg(t,i,type) Regional costs            (mio. USD05MER per yr)
 oq11_cost_glo(t,type)   Objective function        (mio. USD05MER per yr)
 oq11_cost_reg(t,i,type) Regional cost constraint  (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "equations" $include "./modules/11_costs/default/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/11_costs/default/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/11_costs/default/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/12_interest_rate/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Interest rate

*' @description Interest rates are used in MAgPIE as a risk-accounting 
*' factor associated with investment activities [@wang_taking_2016].
*' Interest rates are required for inter-temporal calculations in the model
*' such as shifting investment from one time step to another or distribution of
*' one-time investments over several time steps (e.g. in the modules 
*' [13_tc], [39_landconversion] and [41_area_equipped_for_irrigation]).
*'
*' @authors Xiaoxi Wang

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%interest_rate%" == "select_apr20" $include "./modules/12_interest_rate/select_apr20/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The select_apr20 realization allows to flexibly choose regional
*' or global interest rates. In the default setting, the interest rate depends
*' on the development state `im_development_state`, which is calculated based
*' on GDP per capita. Thus, interest rates are regionally specific and dynamic
*' over time.
*' Alternative interest rates can be selected via the interest rate coefficients
*' (`s12_interest_lic`, `s12_interest_hic`, `s12_hist_interest_lic`, `s12_hist_interest_hic`).
*' The future interest rate policy fades in starting from 2025 until it is fully
*' in effect by 2050.
*' It is also possible to choose a global interest rate.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/12_interest_rate/select_apr20/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 pm_interest(t_all,i)               Interest rate in each region and timestep (% per yr)
* country-specific region scenario switch
 p12_country_dummy(iso)              Dummy parameter indicating whether country is affected by interest rate scenario (1)
 p12_reg_shr(t_all,i)                Weighted share of region with regards to interest rate scenario of countries (1)
;
*$Ifi "%phase%" == "input" $include "./modules/12_interest_rate/select_apr20/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/12_interest_rate/select_apr20/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/13_tc/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Technological change
*'
*' @description The technological change (TC) module describes the relation
*' between agricultural land use intensity represented by the $\tau$ factor and
*' the costs which have to be paid for further intensification (technological
*' change costs). Besides cropland expansion ([39_landconversion]) and trade
*' ([21_trade]), it describes the third major option of the model to increase
*' regional supply. In order to calculate this relation, the module needs to
*' receive information about the assumed interest rate and assumed investment
*' horizon currently provided by module [12_interest_rate].
*'
*' Calculated $\tau$ factors are then used for yields calculation by [14_yields]
*' and by [38_factor_costs] for the calculation of factor costs.
*'
*' @authors Jan Philipp Dietrich, Christoph Schmitz, Benjamin Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%tc%" == "endo_jun18" $include "./modules/13_tc/endo_jun18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The endo realization stands for endogenous implementation of
*' technological change and land use intensification. The intensification rates
*' are calculated endogenously based on an interplay between land use intensity
*' $\tau$ and technological change costs (as shown schematically in the figure
*' below). This module realization contains the implementation as described
*' in @dietrich_forecasting_2014 with two minor modifications:
*'
*'   * rates of previous investment decisions which still have to be paid are
*'     added to the technological change costs
*'   * the planning horizon for investments is unified over all investments in
*'     the model.
*'
*' ![Implementation of technological change in MAgPIE
*' [@dietrich_forecasting_2014]](tc_schematic.png){ width=60% }
*'
*' Initial land use intensity $\tau$ values for the year 2000 come from
*' @dietrich_measuring_2012 and are shown below.
*'
*' ![$\tau$-factors in world regions & global (GLO) for the year 2000.
*' [@dietrich_measuring_2012]](tau_regional.png){ width=60% }
*'
*' Investments into technological change (TC) trigger land use intensification
*' ($\tau$) which triggers in turn yields increases. How much intensification
*' can be triggered by an investment, depends on the investment-yield ratio,
*' which in turn depends on the current agricultural land use intensity. The
*' higher the current intensity level, the more expensive the additional
*' intensification will become. The interaction between land use intensity and
*' production costs per area as shown in the schematic is not covered by this
*' module and can be found instead in [38_factor_costs].

*' @limitations This module significantly reduces the overall computational
*' performance of the model since these endogenous calculations are highly
*' computational intensive.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/13_tc/endo_jun18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/13_tc/endo_jun18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

positive variable
 vm_tau(i)                   Agricultural land use intensity tau (1)
 vm_tech_cost(i)             Annuitized costs of TC (mio. USD05PPP per yr)
 v13_cost_tc(i)              Technical change costs per region (mio. USD05PPP)
;

equations
 q13_tech_cost(i)            Total annuitized costs for TC (mio. USD05PPP)
 q13_cost_tc(i)              Costs for TC (mio. USD05PPP per yr)
;

parameters
 pc13_land(i)                Crop land area per region (mio ha)
 pc13_tau(i)                 Tau factor of the previous time step (1)
 pc13_tcguess(i)             Guess for annual tc rates in the next time step (1)
 i13_tc_factor(t,i)          Regression factor (USD05PPP per ha)
 i13_tc_exponent(t,i)        Regression exponent (1)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_tau(t,i,type)         Agricultural land use intensity tau (1)
 ov_tech_cost(t,i,type)   Annuitized costs of TC (mio. USD05PPP per yr)
 ov13_cost_tc(t,i,type)   Technical change costs per region (mio. USD05PPP)
 oq13_tech_cost(t,i,type) Total annuitized costs for TC (mio. USD05PPP)
 oq13_cost_tc(t,i,type)   Costs for TC (mio. USD05PPP per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/13_tc/endo_jun18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/13_tc/endo_jun18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/13_tc/endo_jun18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/13_tc/endo_jun18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/13_tc/endo_jun18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/13_tc/endo_jun18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/13_tc/endo_jun18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/13_tc/endo_jun18/nl_release.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_relax" $include "./modules/13_tc/endo_jun18/nl_relax.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%tc%" == "exo" $include "./modules/13_tc/exo/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/14_yields/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Yields
*'
*' @description The yields module simulates the temporal development of crop
*' yields and pasture productivity. Spatially explicit information on pasture
*' productivity and crop yields under both rainfed and irrigated conditions is
*' provided by the global gridded crop model LPJmL (Lund-Potsdam-Jena with
*' managed Land) [@bondeau_lpjml_2007]. In the initial year of the simulation
*' period, crop yields and pasture productivity are calibrated at the regional
*' level to meet the observed cropland and pasture area as reported by FAO
*' [@FAOSTAT]. For the simulation of the temporal development of agricultural
*' yields, the module receives information about the agricultural land use
*' intensity represented by the $\tau$ factor coming from the module [13_tc].
*'
*' The module returns yields for all crops and for pasture, which is then used
*' by the modules [30_crop] and [31_past].
*'
*' @authors Jan Philipp Dietrich, Isabelle Weindl, Florian Humpenöder, Anne Biewald



*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%yields%" == "biocorrect" $include "./modules/14_yields/biocorrect/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%yields%" == "dynamic_aug18" $include "./modules/14_yields/dynamic_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the dynamic_aug18 realization, the crop yield calculations
*' are identical as in the above described realization (biocorrect).
*' Additionally, this realization also calculates the growing stocks in commercial
*' plantations and natural vegetation using LPJmL Carbon stocks.
*'
*' @limitations The exogenous implementation of pasture intensification cannot
*' capture feedbacks between land scarcity and efforts to improve pasture
*' management.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/14_yields/dynamic_aug18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/14_yields/dynamic_aug18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 i14_yields(t,j,kve,w)                                          Biophysical input yields (excluding technological change) (tDM per ha per yr)
 p14_pyield_LPJ_reg(t_all,i)                                    Regional average input yields aggregated from clusters with initial pasture area as weights (tDM per ha per yr)
 p14_pyield_corr(t,i)                                           Regional pasture management correction for historical time steps (1)
 p14_growing_stock(t,j,ac,forest_land,forest_type)               Forest growing stock (tDM per ha per yr)
 pm_timber_yield(t,j,ac,forest_land)               Forest growing stock (tDM per ha per yr)
 p14_growing_stock_initial(j,ac,forest_land,forest_type)      Initial Forest growing stock (tDM per ha per yr)
 pm_timber_yield_initial(j,ac,forest_land)                      Initial Forest yield (tDM per ha per yr)
 ;

positive variables
 vm_yld(j,kve,w)                     Yields (variable because of technical change) (tDM per ha per yr)
;

equations
 q14_yield_crop(j,kcr,w)             Crop yields (tDM per ha per yr)
 q14_yield_past(j,w)                 Pasture yields (tDM per ha per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_yld(t,j,kve,w,type)          Yields (variable because of technical change) (tDM per ha per yr)
 oq14_yield_crop(t,j,kcr,w,type) Crop yields (tDM per ha per yr)
 oq14_yield_past(t,j,w,type)     Pasture yields (tDM per ha per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/14_yields/dynamic_aug18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/14_yields/dynamic_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/14_yields/dynamic_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/14_yields/dynamic_aug18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/14_yields/dynamic_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/14_yields/dynamic_aug18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/14_yields/dynamic_aug18/nl_release.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/15_food/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Food demand
*'
*' @description The main function of the food demand module is to forecast
*' the food demand from agricultural products, which is used in the module [16_demand].
*' @authors Benjamin Leon Bodirsky, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%food%" == "anthropometrics_jan18" $include "./modules/15_food/anthropometrics_jan18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/15_food/anthropometrics_jan18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/15_food/anthropometrics_jan18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


equations
  q15_food_demand(i,kfo) Food demand (mio. kcal)
;

positive variables
  vm_dem_food(i,kall)       Food demand (mio. tDM per yr)
;


*** #### Food Demand Model



equations
  q15_aim                Objective function of food demand model (mio. USD05PPP)
  q15_budget(iso)        Household budget constraint (USD05PPP per cap per day)

  q15_regr_bmi_shr(iso,sex,agegroup15,bmi_tree15)   Estimates regression parameters for BMI regression shares (1)
  q15_bmi_shr_verylow(iso,sex,agegroup15)           Estimates BMI share for population groups with low BMI (1)
  q15_bmi_shr_low(iso,sex,agegroup15)               Estimates BMI share for population groups with very low BMI (1)
  q15_bmi_shr_medium(iso,sex,agegroup15)            Estimates BMI share for population groups with medium BMI(1)
  q15_bmi_shr_medium_high(iso,sex,agegroup15)       Estimates BMI share for population groups with medium to high BMI (1)
  q15_bmi_shr_high(iso,sex,agegroup15)              Estimates BMI share for population groups with high BMI (1)
  q15_bmi_shr_veryhigh(iso,sex,agegroup15)          Estimates BMI share for population groups with very high BMI (1)
  q15_bmi_shr_agg(iso,sex,age,bmi_group15)          Disaggregates age groups from overarching groups (1)

  q15_intake(iso)                                   Estimates average intake for the entire country (kcal per cap per day)
  q15_regr_kcal(iso)                                Per capita total demand (kcal per cap per day)
  q15_regr(iso, regr15)                             Estimates parameters for food demand and dietary composition (1)
  q15_foodtree_kcal_animals(iso,kfo_ap)             Demand for animal products  (kcal per cap per day)
  q15_foodtree_kcal_processed(iso,kfo_pf)           Demand for processed products  (kcal per cap per day)
  q15_foodtree_kcal_staples(iso,kfo_st)             Demand for staple products  (kcal per cap per day)
  q15_foodtree_kcal_vegetables(iso)                 Demand for vegetable and fruit products  (kcal per cap per day)

;


positive variables
  v15_kcal_regr(iso,kfo)             Uncalibrated regression estimates of calorie demand (kcal per cap per day)
  v15_kcal_regr_total(iso)           Uncalibrated regression estimates of  total per cap calories (kcal per cap per day)
  v15_demand_regr(iso, regr15)       Uncalibrated regression estimates of kcal shares (1)
  v15_income_pc_real_ppp_iso(iso)    Real income per cap (USD05PPP per cap)
  v15_income_balance(iso)            Balance variable to balance cases in which reduction in income is larger than the per capita GDP (USD05PPP per cap per yr)
  v15_kcal_intake_total_regr(iso)    Food intake (kcal per cap per day)
  v15_regr_overgroups(iso,sex,agegroup15,bmi_tree15)   Hierarchical tree parameter regressions (1)
  v15_bmi_shr_regr(iso,sex,age,bmi_group15) Uncalibrated share of population groups belonging to a certain BMI group (1)
  v15_bmi_shr_overgroups(iso,sex,agegroup15,bmi_group15) Uncalibrated  share of population groups belonging to a certain BMI group (1)
;

variables
  v15_objective                      Objective term (USD05PPP)
;

scalars
  s15_yeardiff                       Number of 5-year time intervalls between time steps (1)
  s15_count                          Loop counter for interpolating body height estimates between longer timesteps (1)
;

parameters
* technical
 p15_modelstat(t)                       Model solver status (1)
 p15_iteration_counter(t)               Number of iterations required for reaching an equilibrium between food demand model and magpie (1)
 p15_convergence_measure(t,iter15)      Convergence measure to decide for continuation or stop of food_demand - magpie iteration (1)
 i15_dem_intercept(iso,regr15)          Food regression parameters intercept in kcal or as share (X)
 i15_dem_saturation(iso,regr15)             Food regression parameters saturation in kcal or as share (X)
 i15_dem_halfsat(iso,regr15)                Food regression parameters halfsaturation (USD05PPP per cap)
 i15_dem_nonsat(iso,regr15)                 Food regression parameters nonsaturation (1)

*prices
 p15_prices_kcal(t,iso,kfo,iter15)                 Prices from MAgPIE after optimization (USD05PPP per kcal)
 i15_prices_initial_kcal(iso,kfo)                  Initial prices that capture the approximate level of prices in 1961-2010 (USD05PPP per kcal)

* anthropometrics
  o15_bmi_shr(t,iso,sex,age,bmi_group15)           Calibrated estimates BMI share for population groups  (1)
  p15_bodyheight(t,iso,sex,age,estimates15)        Body height (cm per cap)
  p15_bodyweight(t,iso,sex,age,bmi_group15)        Body weight (kg per cap)
  p15_bodyheight_calib(t,iso,sex,age_new_estimated15)         Calibration factor for regional height differences (cm)
  p15_kcal_growth_food(t_all,iso,underaged15)      Average per capita demand for body size growth relevant food items in the last three 5-year steps (kcal per capita per day)
  p15_physical_activity_level(t,iso,sex,age)       Physical activity levels in PAL relative to basic metabolic rate BMR (kcal per kcal)

  i15_bmi_intercept(sex,agegroup15,bmi_tree15)     BMI share regression intercept (1)
  i15_bmi_saturation(sex,agegroup15,bmi_tree15)    BMI share regression saturation (1)
  i15_bmi_halfsat(sex,agegroup15,bmi_tree15)       BMI share regression halfsaturation (1)

  p15_bmi_shr_regr(t,iso,sex,age,bmi_group15)      Uncalibrated regression estimates of BMI shares (1)
  i15_bmi_shr_calib(t,iso,sex,age,bmi_group15)     Calibration parameters to meet historical BMI shares (1)
  i15_bmi_shr_calib_lastcalibyear(iso,sex,age,bmi_group15) Calibration parameters of the last year with historical observations (1)

* diet structure
  o15_kcal_intake_total(t,iso)                     Total food intake in a country (kcal per capita per day)
  p15_intake(t,iso,sex,age,bmi_group15)            Mean food intake by population group (kcal per capita per day)
  i15_kcal_pregnancy(t,iso)                        Additional calorie requirements  for pregnancy and lactation (kcal)
  p15_kcal_regr(t, iso, kfo)                       Uncalibrated regression estimates of calorie demand (kcal per cap per day)

  i15_milk_share_fadeout_india(t_all)              Temporal fader of milk share in india (applied before food demand model) (1)
  i15_rum_share_fadeout(t_all,iso)                 Temporal fader of ruminant meat share (applied before food demand model) (1)
  i15_ruminant_fadeout(t,i)                        Ruminant fadeout share (1)
  i15_fish_fadeout(t,i)                            Fish fadeout share (1)
  i15_alcohol_fadeout(t,i)                         Alcohol fadeout share (1)
  i15_livestock_fadeout(t,i)                       Livestock fadeout share (1)
  i15_rumdairy_fadeout(t,i)                        Ruminant meat and dairy fadeout share (1)
  i15_rumdairy_scp_fadeout(t,i)                    Ruminant meat and dairy fadeout share to be replaced by SCP (1)
  i15_livestock_fadeout_threshold(t,i)             Livestock fadeout share for threshold (1)

  i15_protein_to_kcal_ratio(t,kfo)			 	   protein-to-kcal ratio (g protein per kcal)

 i15_staples_kcal_structure_iso(t,iso,kfo_st)        Share of single staple products within total staples (1)
 i15_livestock_kcal_structure_iso_raw(t,iso,kfo_ap)  Share of single livestock products within total livestock products (uncorrected for future changes in shares) (1)
 i15_livestock_kcal_structure_iso(t,iso,kfo_ap)      Share of single livestock products within total livestock products (corrected for future changes in shares) (1)
 i15_processed_kcal_structure_iso                    Share of single processed products within total processed food (1)

* diet calibration
  p15_kcal_calib(t,iso,kfo)                   Balance flow to diverge from mean calories of regressions (kcal per cap per day)
  p15_kcal_calib_lastcalibyear(iso,kfo)       Calibration factor for the last year with observations (kcal per cap per day)
  p15_balanceflow_kcal(t,i,kfo)               Balance flow for mismatch between FAOSTAT and demand estimates (kcal per capita per day)
  p15_balanceflow_kcal_iso(t,iso,kfo)         Balance flow for mismatch between FAOSTAT and demand estimates (kcal per capita per day)
  p15_balanceflow_kcal_lastcalibyear(iso,kfo) Balance flow of last historic time step for mismatch between FAOSTAT and demand estimates (kcal per capita per day)

* before shock
 o15_kcal_regr_initial(t,iso,kfo)             Uncalibrated per capita demand before price shock (kcal per capita per day)
 p15_kcal_pc_initial(t,i,kfo)                 Per capita consumption in food demand model before price shock on regional level (kcal per capita per day)
 pm_kcal_pc_initial(t,i,kfo)                  Per capita consumption in food demand model before price shock (kcal per capita per day)
 p15_kcal_pc_initial_iso(t,iso,kfo)           Per capita consumption in food demand model before price shock on country level (kcal per capita per day)

* after price shock
 p15_kcal_pc_iso(t,iso,kfo)                      Per capita consumption in food demand model after price shock on country level (kcal per capita per day)
 p15_kcal_pc(t,i,kfo)                            Per capita consumption in food demand model after price shock on regional level (kcal per capita per day)
 p15_kcal_pc_calibrated(t,i,kfo)                 Calibrated per capita consumption in food demand model after price shock (kcal per capita per day)
 p15_kcal_pc_calibrated_orig(t,i,kfo)            Auxiliary parameter for per capita food consumption - basis for convergence into waste and diet scenarios (kcal per capita per day)
 p15_kcal_pc_calibrated_livestock_orig(t,i)      Auxiliary parameter for per capita livestock consumption - basis for scenarios of livestock food substitution (kcal per capita per day)
 p15_kcal_pc_calibrated_rumdairy_orig(t,i)	 Auxiliary parameter for per capita ruminant and dairy consumption - basis for scenarios of ruminant-based food substitution (kcal per capita per day)
 p15_kcal_pc_calibrated_plant_orig(t,i)          Auxiliary parameter for per capita plant-based food consumption - basis for scenarios of livestock food substitution (kcal per capita per day)
 p15_livestock_kcal_structure_orig(t,i,kfo_lp)   Auxiliary parameter for livestock kcal structure - basis for scenarios of livestock food substitution (1)
 p15_rumdairy_kcal_structure_orig(t,i,kfo_rd)    Auxiliary parameter for ruminant and dairy kcal structure - basis for scenarios of ruminant-based food substitution (1)
 p15_plant_kcal_structure_orig(t,i,kfo_pp)       Auxiliary parameter for plant-based food kcal structure - basis for scenarios of livestock food substitution (1)
 p15_kcal_pc_livestock_supply_target(i)		 	 Target of per capita livestock consumption (kcal per capita per day)

 p15_bmi_shr_calibrated(t,iso,sex,age,bmi_group15)     Calibrated estimates of BMI share for population groups  (1)
 p15_intake_total_iso_calibrated(t,iso)                Total food intake in a country (kcal per capita per day)
 p15_intake_total_calibrated(t,i)                      Total regional food intake (kcal per capita per day)

*food waste
 p15_demand2intake_ratio(t,i)                 Ratio between food calorie demand and intake (1)
 p15_demand2intake_ratio_scen(t,i)            Ratio between food calorie demand and intake according to exogenous food waste scenario (1)

* transition to exogenous scenario diets
 i15_intake_scen_target(t,i)                  Target for total per capita calorie intake according to an exogenous diet scenario (kcal per capita per day)
 i15_intake_EATLancet(i,kfo)                  Food-specific per capita calorie intake according to EAT Lancet diet scenario (kcal per capita per day)
 i15_intake_detailed_scen_target(t,i,kfo)     Target for food-specific per capita calorie intake according to an exogenous diet scenario (kcal per capita per day)
 p15_intake_detailed_regr(t,i,kfo)                     Food-specific per capita calorie intake according to regression-based projections (kcal per capita per day)

 p15_demand2intake_ratio_ref(i)               Ratio between food calorie demand and intake for the historical time step of EAT Lancet diets (1)
 p15_foodwaste_growth(t,i)                    Increase in food waste over time relative to the historical time step of EAT Lancet diets (1)
 i15_kcal_pc_scen_target(t,i,kfo)             Target for per capita food consumption according to an exogenous diet scenario (kcal per capita per day)
 i15_exo_foodscen_fader(t,i)                  Fader that converges per capita food consumption to an exogenous diet scenario (1)

* country-specific scenario switch
 p15_country_dummy(iso)                       Dummy parameter indicating whether country is affected by diet scenarios (1)
 p15_foodscen_region_shr(t_all,i)             Weighted share of region with regards to diet scenario of countries (1)

* calculate diet iteration breakpoint
 p15_income_pc_real_ppp(t,i)                  Regional per capita income after price shock on regional level (USD05PPP per capita)
 p15_delta_income(t,i,iter15)                 Regional change in per capita income due to price shock on regional level (1)
;

scalars
 s15_year                    Current year as integer value (yr)  /2000/
;

*' @code
*' The food demand model consists of the following equations, which are not
*' part of MAgPIE.

model m15_food_demand /
      q15_aim,
      q15_budget,

      q15_regr_bmi_shr,

      q15_bmi_shr_verylow,
      q15_bmi_shr_low,
      q15_bmi_shr_medium,
      q15_bmi_shr_medium_high,
      q15_bmi_shr_high,
      q15_bmi_shr_veryhigh,

      q15_bmi_shr_agg,

      q15_intake,
      q15_regr_kcal,
      q15_regr,

      q15_foodtree_kcal_animals,
      q15_foodtree_kcal_processed,
      q15_foodtree_kcal_staples,
      q15_foodtree_kcal_vegetables
  /;



*' In contrast, the equation `q15_food_demand` is part of MAgPIE, but
*' not of the food demand model.
*' @stop

m15_food_demand.optfile   = 0 ;
m15_food_demand.scaleopt  = 1 ;
m15_food_demand.solprint  = 0 ;
m15_food_demand.holdfixed = 1 ;



*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_dem_food(t,i,kall,type)                                     Food demand (mio. tDM per yr)
 ov15_kcal_regr(t,iso,kfo,type)                                 Uncalibrated regression estimates of calorie demand (kcal per cap per day)
 ov15_kcal_regr_total(t,iso,type)                               Uncalibrated regression estimates of  total per cap calories (kcal per cap per day)
 ov15_demand_regr(t,iso,regr15,type)                            Uncalibrated regression estimates of kcal shares (1)
 ov15_income_pc_real_ppp_iso(t,iso,type)                        Real income per cap (USD05PPP per cap)
 ov15_income_balance(t,iso,type)                                Balance variable to balance cases in which reduction in income is larger than the per capita GDP (USD05PPP per cap per yr)
 ov15_kcal_intake_total_regr(t,iso,type)                        Food intake (kcal per cap per day)
 ov15_regr_overgroups(t,iso,sex,agegroup15,bmi_tree15,type)     Hierarchical tree parameter regressions (1)
 ov15_bmi_shr_regr(t,iso,sex,age,bmi_group15,type)              Uncalibrated share of population groups belonging to a certain BMI group (1)
 ov15_bmi_shr_overgroups(t,iso,sex,agegroup15,bmi_group15,type) Uncalibrated  share of population groups belonging to a certain BMI group (1)
 ov15_objective(t,type)                                         Objective term (USD05PPP)
 oq15_food_demand(t,i,kfo,type)                                 Food demand (mio. kcal)
 oq15_aim(t,type)                                               Objective function of food demand model (mio. USD05PPP)
 oq15_budget(t,iso,type)                                        Household budget constraint (USD05PPP per cap per day)
 oq15_regr_bmi_shr(t,iso,sex,agegroup15,bmi_tree15,type)        Estimates regression parameters for BMI regression shares (1)
 oq15_bmi_shr_verylow(t,iso,sex,agegroup15,type)                Estimates BMI share for population groups with low BMI (1)
 oq15_bmi_shr_low(t,iso,sex,agegroup15,type)                    Estimates BMI share for population groups with very low BMI (1)
 oq15_bmi_shr_medium(t,iso,sex,agegroup15,type)                 Estimates BMI share for population groups with medium BMI(1)
 oq15_bmi_shr_medium_high(t,iso,sex,agegroup15,type)            Estimates BMI share for population groups with medium to high BMI (1)
 oq15_bmi_shr_high(t,iso,sex,agegroup15,type)                   Estimates BMI share for population groups with high BMI (1)
 oq15_bmi_shr_veryhigh(t,iso,sex,agegroup15,type)               Estimates BMI share for population groups with very high BMI (1)
 oq15_bmi_shr_agg(t,iso,sex,age,bmi_group15,type)               Disaggregates age groups from overarching groups (1)
 oq15_intake(t,iso,type)                                        Estimates average intake for the entire country (kcal per cap per day)
 oq15_regr_kcal(t,iso,type)                                     Per capita total demand (kcal per cap per day)
 oq15_regr(t,iso,regr15,type)                                   Estimates parameters for food demand and dietary composition (1)
 oq15_foodtree_kcal_animals(t,iso,kfo_ap,type)                  Demand for animal products  (kcal per cap per day)
 oq15_foodtree_kcal_processed(t,iso,kfo_pf,type)                Demand for processed products  (kcal per cap per day)
 oq15_foodtree_kcal_staples(t,iso,kfo_st,type)                  Demand for staple products  (kcal per cap per day)
 oq15_foodtree_kcal_vegetables(t,iso,type)                      Demand for vegetable and fruit products  (kcal per cap per day)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/15_food/anthropometrics_jan18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/15_food/anthropometrics_jan18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/15_food/anthropometrics_jan18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/15_food/anthropometrics_jan18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/15_food/anthropometrics_jan18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "intersolve" $include "./modules/15_food/anthropometrics_jan18/intersolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/15_food/anthropometrics_jan18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################

*' @description
*' The realization anthropometrics_jan18
*' uses per capita income and the demography of the
*' world population (including sex and age classes at the country level,
*' which are provided from module [09_drivers]) as drivers.
*' The module estimates food demand on iso-country level taking
*' anthropometric food requirements as well as economic dynamics into account.
*' If flexible demand is activated, the module also uses the shadow prices
*' for agircultural products from the optimization, which are the Lagrange
*' multipliers of the constraint `q15_food_demand`.
*' The module consists of a standalone food demand model, which is executed
*' before MAgPIE starts. In the case of endogenous demand, the module is
*' iterated with MAgPIE.
*' Besides providing the fooduse of agricultural products, the model also
*' provides a number of output indicators, including the BMI distribution,
*' body weight and height of the population by age and sex, food intake by
*' age group and sex, food waste, dietary composition between livestock products,
*' empty calories (sugar, oil and alcohol), fruits vegetables and nuts, as well
*' as staple calories.
*' The food demand model can be run in standalone mode by running the
*' the file `standalone/demand_model.gms`.
*' The model is described in [@bodirsky_starved_nodate]
*'
*' @authors Benjamin Leon Bodirsky, Jan Philipp Dietrich

*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/16_demand/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Demand
*'
*' @description The demand module calculates the demand for all commodities that
*' has to be fulfilled by the model. In addition, it returns some other basic
*' information needed for demand calculations but also needed by other modules.
*' A description of food demand scenarios that enter the model can be found
*' in @bodirsky_global_2015-1, @bodirsky_n2o_2012 and @valin_fooddemand_2013.
*'
*' @authors Isabelle Weindl, Benjamin Bodirsky, Jan Philipp Dietrich.

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%demand%" == "sector_may15" $include "./modules/16_demand/sector_may15/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the sector_may15 realization, demand is calculated as the sum of
*' demand for all products coming from the modules [62_material],
*' [60_bioenergy], [70_livestock], [15_food] and [17_production].
*' It also delivers data to the modules [60_bioenergy], [21_trade], [20_processing],
*' [18_residues], [55_awms], [50_nr_soil_budget], [32_forestry], and [53_methane].


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/16_demand/sector_may15/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/16_demand/sector_may15/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de



positive variables
vm_supply(i,kall)                 Regional demand (mio. tDM per yr)
v16_dem_waste(i,kall)             Demand for waste (mio. tDM per yr)
vm_dem_seed(i,kall)               Demand for seed (mio. tDM per yr)
;

equations
q16_supply_crops(i,kcr)          Supply balance of crops (mio. tDM per yr)
q16_supply_livestock(i,kap)      Supply balance of livestock (mio. tDM per yr)
q16_supply_secondary(i,ksd)      Supply balance of secondary products (mio. tDM per yr)
q16_supply_residues(i,kres)      Supply balance of crop residues (mio. tDM per yr)
q16_supply_pasture(i)            Supply balance of pasture (mio. tDM per yr)
q16_waste_demand(i,kall)         Waste generation (mio. tDM per yr)
q16_seed_demand(i,kcr)           Seed demand (mio. tDM per yr)
q16_supply_forestry(i,kforestry)          Forestry demand (mio. tDM per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_supply(t,i,kall,type)                 Regional demand (mio. tDM per yr)
 ov16_dem_waste(t,i,kall,type)            Demand for waste (mio. tDM per yr)
 ov_dem_seed(t,i,kall,type)               Demand for seed (mio. tDM per yr)
 oq16_supply_crops(t,i,kcr,type)          Supply balance of crops (mio. tDM per yr)
 oq16_supply_livestock(t,i,kap,type)      Supply balance of livestock (mio. tDM per yr)
 oq16_supply_secondary(t,i,ksd,type)      Supply balance of secondary products (mio. tDM per yr)
 oq16_supply_residues(t,i,kres,type)      Supply balance of crop residues (mio. tDM per yr)
 oq16_supply_pasture(t,i,type)            Supply balance of pasture (mio. tDM per yr)
 oq16_waste_demand(t,i,kall,type)         Waste generation (mio. tDM per yr)
 oq16_seed_demand(t,i,kcr,type)           Seed demand (mio. tDM per yr)
 oq16_supply_forestry(t,i,kforestry,type) Forestry demand (mio. tDM per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/16_demand/sector_may15/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/16_demand/sector_may15/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/16_demand/sector_may15/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/17_production/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Production

*' @description The production module calculates regional production of
*' MAgPIE commodities from cluster level production data.

*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%production%" == "flexreg_apr16" $include "./modules/17_production/flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  This realization aggregates agricultural production from
*' cluster level `j` to regional level `i`. Currently, cluster level production
*' is available only for plant commodities, i.e for crops and pastures.
*' Cluster level production of different crops and pasture is calculated in
*' module [30_crop] and [31_past] respectively.

*' @limitations For the time being, this approach is not applied to livestock
*' products.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/17_production/flexreg_apr16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

positive variables
 vm_prod(j,k)                    Production in each cell (mio. tDM per yr)
 vm_prod_reg(i,kall)             Regional aggregated production (mio. tDM per yr)
;

equations
 q17_prod_reg(i,k)               Regional production (mio. tDM per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_prod(t,j,k,type)        Production in each cell (mio. tDM per yr)
 ov_prod_reg(t,i,kall,type) Regional aggregated production (mio. tDM per yr)
 oq17_prod_reg(t,i,k,type)  Regional production (mio. tDM per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*$Ifi "%phase%" == "equations" $include "./modules/17_production/flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/17_production/flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/18_residues/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Residues
*'
*' @description The residues module calculates the production of crop residues
*' (straw, etc.) and its subsequent use. Residues can be burned, used for feed,
*' recycled to soils or used for other purposes (construction, fuel, etc.).
*'
*' The module also calculates the costs of crop residue harvest when it is used
*' for feed or material purposes.
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%residues%" == "flexreg_apr16" $include "./modules/18_residues/flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description As official global statistics exist only for crop production and not for crop
*' residue production, the biomass of residues is obtained in MAgPIE by using
*' crop-type specific plant growth functions based on crop production and area harvested.
*' Plant biomass is divided into three components: the harvested organ as listed
*' in FAO, the aboveground (AG) and the belowground (BG) residues.
*'
*' @ipcc_2006_2006 offers one of the few consistent datasets to estimate
*' both AG and BG residues. Also, by providing crop-growth functions (CGF, `f18_cgf`)
*' instead of fixed harvest indices, it can be used to depict current
*' international differences of harvest indices and their development in the future.
*' The methodology is thus well eligible for global long-term modelling.
*' @ipcc_2006_2006 provides linear CGFs with positive slope and intercept
*' for cereals, leguminous crops, potatoes and grasses. As no values are
*' available for the oilcrops rapeseed, sunflower, oilpalms as well as
*' sugar crops, tropical roots, cotton and others, we use fixed harvest-indices
*' (positive slope without intercept) for these crops based
*' on @wirsenius_human_2000, @lal_world_2005 and @feller_dungung_2007. If different CGFs are available
*' for crops within a crop group, we build a weighted average based on the
*' production in 1995.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/18_residues/flexreg_apr16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/18_residues/flexreg_apr16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


positive variables
 vm_res_biomass_ag(i,kcr,attributes)        Production of aboveground residues in each region (mio. tDM)
 vm_res_biomass_bg(i,kcr,dm_nr)             Production of belowground residues in each region (mio. tDM)
 v18_res_ag_removal(i,kcr,attributes)       Removal of crop residues in respective attribute units DM GJ Nr P K WM C (mio. tX)
 v18_res_ag_recycling(i,kcr,attributes)     Recylcing of crop residues to soils in respective attribute units DM GJ Nr P K WM C (mio. tX)
 vm_res_ag_burn(i,kcr,attributes)           Residues burned on fields in respective attribute units DM GJ Nr P K WM C (mio. tX)
 vm_res_recycling(i,npk)                    Residues recycled to croplands in respective nutrients Nr P K units (mio. tX)
;

equations

 q18_prod_res_ag_reg(i,kcr,attributes)     Production constraint of aboveground residues (mio. tDM)
 q18_prod_res_bg_reg(i,kcr,dm_nr)          Production constraint of belowground residues (mio. tDM)

 q18_res_field_balance(i,kcr,attributes)   Calculation of the residues amount recycled to soils (mio. tDM)
 q18_res_field_burn(i,kcr,attributes)      Fixing of the residues amount burned in a region in respective attribute units DM GJ Nr P K WM C (mio. tX)
 q18_translate(i,kres,attributes)          Transformation of the multiple crop residues into supply balance crop redisues in respective attribute units DM GJ Nr P K WM C (mio. tX)

 q18_res_recycling_nr(i)                   Nutrient recycling of reaactive nitrogen (mio. tNr)
 q18_res_recycling_pk(i,pk18)              Nutrient recycling of phosphorus and potash (mio. tX)
 q18_cost_prod_res(i,kres)                 Production costs of harvesting crop residues (mio. USD05MER)

;

parameters
 i18_res_use_burn(t_all,dev18,kcr)         Share of residues burned on field (1)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_res_biomass_ag(t,i,kcr,attributes,type)      Production of aboveground residues in each region (mio. tDM)
 ov_res_biomass_bg(t,i,kcr,dm_nr,type)           Production of belowground residues in each region (mio. tDM)
 ov18_res_ag_removal(t,i,kcr,attributes,type)    Removal of crop residues in respective attribute units DM GJ Nr P K WM C (mio. tX)
 ov18_res_ag_recycling(t,i,kcr,attributes,type)  Recylcing of crop residues to soils in respective attribute units DM GJ Nr P K WM C (mio. tX)
 ov_res_ag_burn(t,i,kcr,attributes,type)         Residues burned on fields in respective attribute units DM GJ Nr P K WM C (mio. tX)
 ov_res_recycling(t,i,npk,type)                  Residues recycled to croplands in respective nutrients Nr P K units (mio. tX)
 oq18_prod_res_ag_reg(t,i,kcr,attributes,type)   Production constraint of aboveground residues (mio. tDM)
 oq18_prod_res_bg_reg(t,i,kcr,dm_nr,type)        Production constraint of belowground residues (mio. tDM)
 oq18_res_field_balance(t,i,kcr,attributes,type) Calculation of the residues amount recycled to soils (mio. tDM)
 oq18_res_field_burn(t,i,kcr,attributes,type)    Fixing of the residues amount burned in a region in respective attribute units DM GJ Nr P K WM C (mio. tX)
 oq18_translate(t,i,kres,attributes,type)        Transformation of the multiple crop residues into supply balance crop redisues in respective attribute units DM GJ Nr P K WM C (mio. tX)
 oq18_res_recycling_nr(t,i,type)                 Nutrient recycling of reaactive nitrogen (mio. tNr)
 oq18_res_recycling_pk(t,i,pk18,type)            Nutrient recycling of phosphorus and potash (mio. tX)
 oq18_cost_prod_res(t,i,kres,type)               Production costs of harvesting crop residues (mio. USD05MER)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*** EOF declarations.gms ***
*$Ifi "%phase%" == "input" $include "./modules/18_residues/flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/18_residues/flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/18_residues/flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/18_residues/flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/18_residues/flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%residues%" == "off" $include "./modules/18_residues/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################

*** EOF residues.gms ***
*$include "./modules/20_processing/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Processing

*' @description The processing module calculates the quantity of secondary products that
*' are generated through conversion of raw products (especially of primary plant agricultural commodities)
*' in order to meet the demand for those secondary products.

*' @authors Benjamin Leon Bodirsky, Amsalu Woldie Yalew


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%processing%" == "off" $include "./modules/20_processing/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%processing%" == "substitution_dec18" $include "./modules/20_processing/substitution_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/20_processing/substitution_dec18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/20_processing/substitution_dec18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 i20_processing_shares(t_all,i,ksd,kpr)			    Shares of secondary products coming from a primary product (1)
 i20_processing_conversion_factors(t_all,processing20,ksd,kpr) Conversion factors of primary products into secondary products (1)
 i20_processing_unitcosts(ksd,kpr)   				Costs of transforming x units kpr into 1 unit ksd (USD05MER per tDM)
 ;


positive variables
  vm_dem_processing(i,kall)                      Demand for processing use (mio. tDM per yr)
  v20_dem_processing(i,processing_subst20,kpr)   Demand for processing use by process (mio. tDM per yr)
  v20_secondary_substitutes(i,ksd,kpr)           Substitutes for inferior secondary products (mio. tDM per yr)
  vm_secondary_overproduction(i,kall,kpr)        Overproduction of secondary couple products (mio. tDM per yr)
  vm_cost_processing(i)                          Processing costs (mio. USD05MER per yr)
;

variables
  vm_processing_substitution_cost(i)             Costs or benefits of substituting one product by another (mio. USD05MER per yr)
;

equations
     q20_processing(i,kpr,ksd)                        	Processing equation (mio. tDM per yr)
     q20_processing_aggregation_nocereals(i,kpr)        Connecting processing activity to processing flows (mio. tDM per yr)
     q20_processing_aggregation_cereals(i,kcereals20)   Connecting processing activity to food use for milling (mio. tDM per yr)
     q20_processing_aggregation_cotton(i)               Connecting processing activity to production for cotton ginning (mio. tDM per yr)
     q20_processing_substitution_oils(i)                Substitution of oils by other oils (mio. tDM per yr)
     q20_processing_substitution_brans(i)               Substitution of brans by cereals (mio. tNr per yr)
     q20_processing_substitution_sugar(i)               Substitution of molasses by sugar (mio. tDM per yr)
     q20_processing_substitution_protein(i)             Substitution of protein products by other protein products (mio. tNr per yr)
     q20_processing_costs(i)                            Processing costs (mio. USD05MER per yr)
     q20_substitution_utility_loss(i)                  Utility loss when one product has to be substituted by another (mio. t Nr per year)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_dem_processing(t,i,kall,type)                         Demand for processing use (mio. tDM per yr)
 ov20_dem_processing(t,i,processing_subst20,kpr,type)     Demand for processing use by process (mio. tDM per yr)
 ov20_secondary_substitutes(t,i,ksd,kpr,type)             Substitutes for inferior secondary products (mio. tDM per yr)
 ov_secondary_overproduction(t,i,kall,kpr,type)           Overproduction of secondary couple products (mio. tDM per yr)
 ov_cost_processing(t,i,type)                             Processing costs (mio. USD05MER per yr)
 ov_processing_substitution_cost(t,i,type)                Costs or benefits of substituting one product by another (mio. USD05MER per yr)
 oq20_processing(t,i,kpr,ksd,type)                        Processing equation (mio. tDM per yr)
 oq20_processing_aggregation_nocereals(t,i,kpr,type)      Connecting processing activity to processing flows (mio. tDM per yr)
 oq20_processing_aggregation_cereals(t,i,kcereals20,type) Connecting processing activity to food use for milling (mio. tDM per yr)
 oq20_processing_aggregation_cotton(t,i,type)             Connecting processing activity to production for cotton ginning (mio. tDM per yr)
 oq20_processing_substitution_oils(t,i,type)              Substitution of oils by other oils (mio. tDM per yr)
 oq20_processing_substitution_brans(t,i,type)             Substitution of brans by cereals (mio. tNr per yr)
 oq20_processing_substitution_sugar(t,i,type)             Substitution of molasses by sugar (mio. tDM per yr)
 oq20_processing_substitution_protein(t,i,type)           Substitution of protein products by other protein products (mio. tNr per yr)
 oq20_processing_costs(t,i,type)                          Processing costs (mio. USD05MER per yr)
 oq20_substitution_utility_loss(t,i,type)                 Utility loss when one product has to be substituted by another (mio. t Nr per year)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/20_processing/substitution_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/20_processing/substitution_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/20_processing/substitution_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/20_processing/substitution_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/20_processing/substitution_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/20_processing/substitution_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/21_trade/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Agricultural trade
*'
*' @description This module represents agricutlural trade among world regions.
*' It ensures that the regional demand is met by domestic production and imports from other regions.
*' The global trade balance dictates that global production must be larger than or equal to global demand.
*' For non-traded goods, the regional production must be larger than or equal to regional demand.
*'
*'
*' @authors  Xiaoxi Wang, Anne Biewald, Christoph Schmitz, Markus Bonsch
*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%trade%" == "exo" $include "./modules/21_trade/exo/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "free_apr16" $include "./modules/21_trade/free_apr16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "off" $include "./modules/21_trade/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%trade%" == "selfsuff_reduced" $include "./modules/21_trade/selfsuff_reduced/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description Within this realization, there are two ways for a region to fulfill
*' its demand for agricultural products: a self-sufficiency pool based on
*' historical region specific trade patterns, and a comparative advantage pool
*' based on most cost-efficient production.

*' In the self-sufficiency pool, regional self-sufficiency ratios `f21_self_suff_seedred_1995(i,k)` defines
*' how much of the demand of each region `i` for each traded goods `k_trade` has to be met by domestic production.
*' Self sufficiency ratios smaller than one indicate that the region imports from the world market,
*' while self-sufficiencies greater than one indicate that the region produces for export. Trade costs,
*' inlucding trade margins and tariffs, are considered.
*'
*' ![Implementation of trade.](trade_pools.png){ width=100% }

*' @limitations This realization depends on predetermined self-sufficiency rates and export shares,
*' which leads to a relative fixed trade pattern.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/21_trade/selfsuff_reduced/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/21_trade/selfsuff_reduced/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 i21_trade_bal_reduction(t_all,k_trade)         Trade balance reduction (1)
 i21_trade_margin(i,k_trade)                    Trade margins (USD05MER per tDM)
 i21_trade_tariff(i,k_trade)                    Trade tariffs (USD05MER per tDM)
 pm_selfsuff_ext(t_ext,i,kforestry)            Self sufficiency for timber products in extended time frame (1)
;

positive variables
 v21_excess_dem(k_trade)                 Global excess demand (mio. tDM per yr)
 v21_excess_prod(i,k_trade)              Regional excess production (mio. tDM per yr)
 vm_cost_trade(i)                        Regional  trade costs (mio. USD05MER per yr)
 v21_cost_trade_reg(i,k_trade)           Regional trade costs for each tradable commodity (mio. USD05MER per yr)
;

equations
 q21_trade_glo(k_trade)                  Global production constraint (mio. tDM per yr)
 q21_notrade(i,k_notrade)                Regional production constraint of non-tradable commodities (mio. tDM per yr)
 q21_trade_reg(i,k_trade)                Regional trade balances i.e. minimum self-sufficiency ratio (1)
 q21_trade_reg_up(i,k_trade)             Regional trade balances i.e. maximum self-sufficiency ratio (1)
 q21_excess_dem(k_trade)                 Global excess demand (mio. tDM per yr)
 q21_excess_supply(i,k_trade)            Regional excess production (mio. tDM per yr)
 q21_cost_trade(i)                       Regional  trade costs (mio. USD05MER per yr)
 q21_cost_trade_reg(i,k_trade)           Regional trade costs for each tradable commodity (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov21_excess_dem(t,k_trade,type)       Global excess demand (mio. tDM per yr)
 ov21_excess_prod(t,i,k_trade,type)    Regional excess production (mio. tDM per yr)
 ov_cost_trade(t,i,type)               Regional  trade costs (mio. USD05MER per yr)
 ov21_cost_trade_reg(t,i,k_trade,type) Regional trade costs for each tradable commodity (mio. USD05MER per yr)
 oq21_trade_glo(t,k_trade,type)        Global production constraint (mio. tDM per yr)
 oq21_notrade(t,i,k_notrade,type)      Regional production constraint of non-tradable commodities (mio. tDM per yr)
 oq21_trade_reg(t,i,k_trade,type)      Regional trade balances i.e. minimum self-sufficiency ratio (1)
 oq21_trade_reg_up(t,i,k_trade,type)   Regional trade balances i.e. maximum self-sufficiency ratio (1)
 oq21_excess_dem(t,k_trade,type)       Global excess demand (mio. tDM per yr)
 oq21_excess_supply(t,i,k_trade,type)  Regional excess production (mio. tDM per yr)
 oq21_cost_trade(t,i,type)             Regional  trade costs (mio. USD05MER per yr)
 oq21_cost_trade_reg(t,i,k_trade,type) Regional trade costs for each tradable commodity (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/21_trade/selfsuff_reduced/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/21_trade/selfsuff_reduced/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/21_trade/selfsuff_reduced/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/21_trade/selfsuff_reduced/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/21_trade/selfsuff_reduced/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/29_ageclass/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Age class

*' @description The age-class module calculates the distribution of secondary
*' forests and timber plantations based on Poulter dataset. This is used in
*' [32_forestry] and [35_natveg] for initialization of forest areas.

*' @authors Abhijeet Mishra, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%ageclass%" == "feb21" $include "./modules/29_ageclass/feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  This realization calculates use the results from @poulter2018global
*' for secondary forests (and timber plantations) based on MODIS satellite data.
*' This is used in [32_forestry] and [35_natveg] for initialization of forest areas
*' based on specification of endogenous (or exogenous) forest harvests. These numbers
*' are the most consistent dataset available on spatial scale and are preferred over
*' extarcting such numbers from LUH data due to ease of generating these numbers.

*' @limitations Forest fires change how the age structures of secondary or
*' human-intervention forests over time. This being a satellite observation data
*' probably includes such disturbances. These disturbances are not modeled extensively
*' in MAgPIE and hence using these numbers directly in the model might generate biases.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/29_ageclass/feb21/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/29_ageclass/feb21/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameter
 im_plantedclass_ac(j,ac)                       Raw Distribution of ageclass in secondary forest as a proxy for planted forest (mio. ha)
;
*$Ifi "%phase%" == "input" $include "./modules/29_ageclass/feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/29_ageclass/feb21/preloop.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/30_crop/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @title Cropland

*' @description The cropland module simulates the dynamics of cropland area and
*' agricultural crop production and calculates corresponding carbon contents and
*' the biodiversity value of the existing cropland.

*' @authors Jan Philipp Dietrich, Florian Humpenöder, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%crop%" == "endo_jun13" $include "./modules/30_crop/endo_jun13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The endo_jun13 realization calculates the crop specific
*' agricultural land use endogenously based on yield data coming from the
*' module [14_yields] and the rotational as well as suitability constrains
*' stated in the input data of the module.
*'
*' Cropland areas are linked to the crop specific production and the carbon
*' content of the different land carbon pools. The crop specific land use areas
*' are also used in [18_residues], [38_factor_costs],
*' [41_area_equipped_for_irrigation], [42_water_demand], [50_nr_soil_budget],
*' [53_methane] and [59_som].

*' @limitations There are currently no known limitations of this realization.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/30_crop/endo_jun13/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/30_crop/endo_jun13/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 pm_croparea_start(j,kcr)        Agricultural land initialization area (mio. ha)
;

positive variables
 vm_area(j,kcr,w)                Agricultural production area (mio. ha)
;

equations
 q30_cropland(j)                 Total cropland calculation (mio. ha)
 q30_suitability(j)              Suitability constraint (mio. ha)
 q30_rotation_max(j,crp30,w)     Local maximum rotational constraints (mio. ha)
 q30_rotation_min(j,crp30,w)     Local minimum rotational constraints (mio. ha)
 q30_prod(j,kcr)                 Production of cropped products (mio. tDM)
 q30_carbon(j,ag_pools)          Cropland above ground carbon content calculation (mio. tC)
 q30_bv_ann(j,potnatveg)         Biodiversity value of annual cropland (Mha)
 q30_bv_per(j,potnatveg)         Biodiversity value of perennial cropland (Mha)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_area(t,j,kcr,w,type)             Agricultural production area (mio. ha)
 oq30_cropland(t,j,type)             Total cropland calculation (mio. ha)
 oq30_suitability(t,j,type)          Suitability constraint (mio. ha)
 oq30_rotation_max(t,j,crp30,w,type) Local maximum rotational constraints (mio. ha)
 oq30_rotation_min(t,j,crp30,w,type) Local minimum rotational constraints (mio. ha)
 oq30_prod(t,j,kcr,type)             Production of cropped products (mio. tDM)
 oq30_carbon(t,j,ag_pools,type)      Cropland above ground carbon content calculation (mio. tC)
 oq30_bv_ann(t,j,potnatveg,type)     Biodiversity value of annual cropland (Mha)
 oq30_bv_per(t,j,potnatveg,type)     Biodiversity value of perennial cropland (Mha)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*** EOF declarations.gms ***
*$Ifi "%phase%" == "input" $include "./modules/30_crop/endo_jun13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/30_crop/endo_jun13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/30_crop/endo_jun13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/30_crop/endo_jun13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/30_crop/endo_jun13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/31_past/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Pasture
*'
*' @description The pasture module determines land used as pasture for livestock
*' rearing. At the same time, it calculates geographically explicit production
*' of pasture biomass and the carbon content of pasture land. Therefore, the
*' module requires cellular information about the carbon density related to the
*' different pasture carbon pools. Furthermore, it delivers regional production
*' costs associated with pastures and biodiversity values for pasture and rangeland.
*'
*' @authors Isabelle Weindl, Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%past%" == "endo_jun13" $include "./modules/31_past/endo_jun13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the endo_jun13 realization, pasture area and related carbon
*' stocks are modelled endogenously. The initial spatially explicit patterns of
*' pasture are defined in the module [10_land] by the land use input data set.
*' For future time steps, pasture area depends on the demand for biomass from
*' pastures to feed livestock as calculated in the module [70_livestock] and
*' from the intensity of pasture utilization ("pasture yield") as determined in
*' the module [14_yields].

*' @limitations No consideration of generic differences between extensive and
*' intensive grazing systems, of explicit pasture management options and of
*' related degradation of pastures.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/31_past/endo_jun13/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


equations
 q31_prod(j)              Cellular pasture production constraint (mio. tDM per yr)
 q31_carbon(j,ag_pools)   Above ground carbon content calculation for pasture (mio tC)
 q31_cost_prod_past(i)    Costs for putting animals on pastures (mio. USD05MER per yr)
 q31_bv_manpast(j,potnatveg)    Biodiversity value for managed pastures (Mha)
 q31_bv_rangeland(j,potnatveg)    Biodiversity value for managed pastures (Mha)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 oq31_prod(t,j,type)                   Cellular pasture production constraint (mio. tDM per yr)
 oq31_carbon(t,j,ag_pools,type)        Above ground carbon content calculation for pasture (mio tC)
 oq31_cost_prod_past(t,i,type)         Costs for putting animals on pastures (mio. USD05MER per yr)
 oq31_bv_manpast(t,j,potnatveg,type)   Biodiversity value for managed pastures (Mha)
 oq31_bv_rangeland(t,j,potnatveg,type) Biodiversity value for managed pastures (Mha)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*** EOF declarations.gms ***
*$Ifi "%phase%" == "input" $include "./modules/31_past/endo_jun13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/31_past/endo_jun13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/31_past/endo_jun13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%past%" == "static" $include "./modules/31_past/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/32_forestry/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Forestry
*'
*' @description The forestry module describes the constraints under which managed
*' forest (age-class forest) exists. At the same time it calculates the corresponding
*' carbon stocks and biodiversity value. The module provides carbon dioxide removal (CDR) from afforestation
*' to the GHG policy module ([56_ghg_policy]) as well as afforestation related costs
*' to the costs module ([11_costs]).
*'
*' @authors Florian Humpenöder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%forestry%" == "dynamic_feb21" $include "./modules/32_forestry/dynamic_feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The main feature of the this realization is afforestation for CDR
*' and timber production. Afforestation can be modelled exogenously (prescribed
*' by NPI/NDC policies) and/or endogenously (incentivized by a reward for CDR).
*' National policies implemented (NPI) and nationally determined contributions to
*' the Paris agreement (NDC) for afforestation are based on country reports. The
*' interface `vm_cdr_aff` includes the expected CDR and local bph effects from
*' afforestation depending on the planning horizon `s32_planing_horizon`. The
*' reward for CDR and local bph effects from afforestation is calculated in the
*' [56_ghg_policy] module. In this realization, afforestation is modeled by default
*' as regrowth of natural vegetation (see @humpenoder_investigating_2014 for details on the implemenation).
*' The regrowth of natural vegetation follows S-shaped growth curves, which are
*' parametrized based on @braakhekke_modelling_2019. Additionally this module
*' handles the production of two timber products i.e., wood and woodfuel from
*' plantation forests while still accounting for afforestation policies. New plantations
*' are also established in the simulation step to account for future timber demand.
*' This module also calculates the rotation lengths before the solve loop by equating
*' Instantaneous Growth Rates (IGR) and interest rate `pm_interest` based on
*' @amacher2009economics. We have to make assumptions regarding the rotation lengths
*' to be used for establishment and harvesting decisions. For establishment we just
*' use the calculated rotations either based on a Single Rotation-Period Model or
*' based on Faustamnn rotations according to the switch `s32_faustmann_rotation`.
*' For harvesting we assume that land owners stick to their establishment decision,
*' e.g. if a plantation has been established with a rotation length of 30 years
*' it will be harvested after 30 years, even so the rotation length in the prevailing
*' time step, used for establishment, is shorter or longer.
*'   
*' ![Calculation of rotation lengths using interest rate and vegetation Carbon growth functions based on single rotation model](rotation_length.png){ width=100% }

*' @limitations Rotation lengths for timber plantations are not endogenous.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/32_forestry/dynamic_feb21/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/32_forestry/dynamic_feb21/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de
scalars
 s32_shift                                          Number of 5-year age-classes corresponding to current time step length (1)
 p32_max_aff_area                                   Maximum global afforestation area that is greater or equal the exogenous policy target (mio. ha)
 s32_establishment_dynamic                          If plantations should be dynamic (including establishment and harvest decsions)
 s32_establishment_static                           Static plantations with no establishmnet no harvest no regrowth
;

parameters
 p32_aff_pol(t,j)                                   NDC forest stock (mio. ha)
 p32_aff_pol_timestep(t,j)                          NDC afforestation per time step (mio. ha)
 p32_aff_pot(t,j)                                   Potential afforestation area (mio. ha)
 p32_aff_togo(t)                                    Remaining exogenous afforestation wrt to the maximum exogenous target over time (mio. ha)
 p32_carbon_density_ac(t,j,type32,ac,ag_pools)      Carbon density for ac and ag_pools (tC per ha)
 p32_carbon_density_ac_forestry(t_all,j,ac)         Above ground carbon density for age classes and carbon pools (tC per ha)
 p32_carbon_density_ac_marg(t_all,j,ac)             Marginal above ground carbon density for age classes and carbon pools (tC per ha)
 pc32_area_rotation(j)							Forestry area at rotation length end used as weight for regional aggregation (mio. ha)
 p32_land(t,j,type32,ac)                            Forestry land for each cell wood type and age class before and after optimization (mio. ha)
 pc32_land(j,type32,ac)                             Forestry land per forestry land type initialization of the optimization (mio. ha)
 pc32_yield_forestry_future(j)                      Cellular timber yield expected in the future (m3 per ha per year)
 pc32_yield_forestry_future_reg(i)                  Regional timber yield expected in the future (m3 per ha per year)
 p32_plant_ini_ac(j)                                Initialization of plantation area (mio. ha)
 p32_IGR(t_all,j,ac)                                Instantaneous growth rate or periodic annual increment of forest growth (1)
 p32_rot_flg(t_all,j,ac)                            Identifier flag when calculating rotation length (1)
 p32_rotation_regional(t_all,i)                     Regional average rotation length of plantations translated to age class equivalent for future (1)
 p32_rot_length_ac_eqivalent(t_all,j)               Cellular rotation length of plantations translated to age class equivalent for future (1)
 p32_rotation_cellular_estb(t_all,j)                Establishment rotation length translated to age classes on cellular level (1)
 p32_rotation_cellular_harvesting(t_all,j)          Harvesting rotation length of plantations translated to age class equivalent for future (1)
 p32_cdr_ac(t,j,ac)                                 Non-cumulative CDR from afforestation plantations for each age-class depending on planning horizon (tC per ha)
 p32_rotation_offset                                Offset calc in age class equivalents (1)
 p32_land_start_ac(j,type32,ac)                     Saving first value of starting land (mio. ha)
 p32_land_before(t,j,type32,ac)                     Saving time value of starting land (mio. ha)
 p32_time(ac)                                       Time as a function of age-classes (yr)
 p32_discount_factor(t_all,j,ac)                    Discount factor for each age class (1)
 p32_net_present_value(t_all,j,ac)                  Net present value for a representative 1ha land of plantations (mio. USD)
 p32_stand_value(t_all,j,ac)                        Stand value based on given prices (mio. USD)
 p32_investment_returns_lost(t_all,j,ac)            Present value of investment returns lost by not harvesting now and beginning a new series of rotations on the land (mio. USD)
 p32_land_rent_weighted(t_all,j,ac)                 Land rent weighted by the value of the trees at harvest age-class (mio. USD)
 p32_rot_flg_faustmann(t_all,j,ac)                  Identifier flag when calculating faustmann rotation length (1)
 p32_rot_length_faustmann(t_all,j)                  Cellular Faustmann rotation length of plantations translated to age class equivalent (1)
 p32_ncells(i)                                      Number of cells in each region (1)
 pm_representative_rotation(t_all,i)                Representative regional rotation (1)
 p32_aff_bgp(j,ac)                                  Biophysical impact of afforestation (tCeq per ha)
 p32_tcre_glo(j)                                    Global mean Transient Climate Response to cumulative Emissions (degree C per tC per ha)
 p32_observed_gs_reg(i)                             Observed growing stock (tDM per ha)
 p32_gs_scaling_reg(i)                              Calibration factor for scaling up the relative growing stock (1)
 p32_rotation_dist(j,ac)                            Poulter distribution within celular rotation lengths (1)
 p32_updated_gs_reg(t,i)                            Updated growing stock information after calibration (m3 per ha)
 p32_plantation_contribution(t_ext,i)               Share of roundwood production coming from timber plantations (percent)
 p32_ac_dist_flag(j,ac)                             Distribution flag with inverse weights according to age-classes (1)
 p32_ac_dist(j,ac)                                  Actual share of age-class distribution (1)
 ;

positive variables
 vm_cost_fore(i)                                    Forestry costs (Mio USD)
 v32_cost_hvarea(i)                                 Cost of harvesting timber from forests (mio. USD per yr)
 v32_land(j,type32,ac)                              Forestry land pools (mio. ha)
 v32_land_missing(j)                                Forestry land which can be used at extrmemly high costs in case not enough area is available for new establishment (mio. ha)
 vm_landdiff_forestry                               Aggregated difference in forestry land compared to previous timestep (mio. ha)
 v32_cost_recur(i)                                  Recurring forest management costs (USD per ha)
 v32_land_expansion(j,type32,ac)                    Forestry land expansion (mio. ha)
 v32_land_reduction(j,type32,ac)                    Forestry land reduction (mio. ha)
 v32_cost_establishment(i)                          Cost of establishment calculated at the current time step (mio. USD)
 v32_hvarea_forestry(j,ac)                          Harvested area from timber plantations (mio. ha)
 vm_prod_forestry(j,kforestry)                      Production of woody biomass from commercial plantations (mio. tDM per yr)
 ;

variables
 vm_cdr_aff(j,ac,aff_effect)                        Expected bgc (CDR) and local bph effects of afforestation depending on planning horizon (mio. tC)
 ;

equations
 q32_cost_total(i)                                  Total forestry costs constraint (mio. USD)
 q32_land(j)                                        Land constraint (mio. ha)
 q32_cdr_aff(j,ac)                                  Calculation of CDR from afforestation (mio. tC)
 q32_carbon(j,ag_pools)                             Forestry carbon stock calculation (mio. tC)
 q32_land_diff                                      Aggregated difference in forestry land compared to previous timestep (mio. ha)
 q32_max_aff                                        Maximum total global afforestation (mio. ha)
 q32_aff_pol(j)                                     Afforestation policy constraint (mio. ha)
 q32_aff_est(j)                                     Afforestation constraint for establishment age classes (mio. ha)
 q32_hvarea_forestry(j,ac)                          Plantations area harvest (mio. ha)
 q32_cost_recur(i)                                  Recurruing costs (mio. USD)
 q32_establishment_dynamic(i)                       Establishment in current time step for future demand (mio. ha)
 q32_establishment_dynamic_yield(i)					Regional timber yield (tDM per ha)
 q32_establishment_fixed(j)                       Establishment in current time step for future demand (mio. ha)
 q32_land_expansion(j,type32,ac)                    Land expansion (mio. ha)
 q32_land_reduction(j,type32,ac)                    Land contraction (mio. ha)
 q32_cost_establishment(i)                          Present value of cost of establishment (mio. USD)
 q32_bgp_aff(j,ac)                                  Biophysical afforestation calculation (mio. tCeq)
 q32_forestry_est(j,type32,ac)                      Distribution of forestry establishment over ac_est (mio. ha)
 q32_cost_hvarea(i)									Cost of harvesting timber from forests (mio. USD per yr)
 q32_prod_forestry(j)                               Production of woody biomass from commercial plantations (mio. tDM per yr)
 q32_bv_aff(j,potnatveg)                           Biodiversity value for aff forestry land (Mha)
 q32_bv_ndc(j,potnatveg)                           Biodiversity value for ndc forestry land (Mha)
 q32_bv_plant(j,potnatveg)                         Biodiversity value for plantations (Mha)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_fore(t,i,type)                     Forestry costs (Mio USD)
 ov32_cost_hvarea(t,i,type)                 Cost of harvesting timber from forests (mio. USD per yr)
 ov32_land(t,j,type32,ac,type)              Forestry land pools (mio. ha)
 ov32_land_missing(t,j,type)                Forestry land which can be used at extrmemly high costs in case not enough area is available for new establishment (mio. ha)
 ov_landdiff_forestry(t,type)               Aggregated difference in forestry land compared to previous timestep (mio. ha)
 ov32_cost_recur(t,i,type)                  Recurring forest management costs (USD per ha)
 ov32_land_expansion(t,j,type32,ac,type)    Forestry land expansion (mio. ha)
 ov32_land_reduction(t,j,type32,ac,type)    Forestry land reduction (mio. ha)
 ov32_cost_establishment(t,i,type)          Cost of establishment calculated at the current time step (mio. USD)
 ov32_hvarea_forestry(t,j,ac,type)          Harvested area from timber plantations (mio. ha)
 ov_prod_forestry(t,j,kforestry,type)       Production of woody biomass from commercial plantations (mio. tDM per yr)
 ov_cdr_aff(t,j,ac,aff_effect,type)         Expected bgc (CDR) and local bph effects of afforestation depending on planning horizon (mio. tC)
 oq32_cost_total(t,i,type)                  Total forestry costs constraint (mio. USD)
 oq32_land(t,j,type)                        Land constraint (mio. ha)
 oq32_cdr_aff(t,j,ac,type)                  Calculation of CDR from afforestation (mio. tC)
 oq32_carbon(t,j,ag_pools,type)             Forestry carbon stock calculation (mio. tC)
 oq32_land_diff(t,type)                     Aggregated difference in forestry land compared to previous timestep (mio. ha)
 oq32_max_aff(t,type)                       Maximum total global afforestation (mio. ha)
 oq32_aff_pol(t,j,type)                     Afforestation policy constraint (mio. ha)
 oq32_aff_est(t,j,type)                     Afforestation constraint for establishment age classes (mio. ha)
 oq32_hvarea_forestry(t,j,ac,type)          Plantations area harvest (mio. ha)
 oq32_cost_recur(t,i,type)                  Recurruing costs (mio. USD)
 oq32_establishment_dynamic(t,i,type)       Establishment in current time step for future demand (mio. ha)
 oq32_establishment_dynamic_yield(t,i,type) Regional timber yield (tDM per ha)
 oq32_establishment_fixed(t,j,type)         Establishment in current time step for future demand (mio. ha)
 oq32_land_expansion(t,j,type32,ac,type)    Land expansion (mio. ha)
 oq32_land_reduction(t,j,type32,ac,type)    Land contraction (mio. ha)
 oq32_cost_establishment(t,i,type)          Present value of cost of establishment (mio. USD)
 oq32_bgp_aff(t,j,ac,type)                  Biophysical afforestation calculation (mio. tCeq)
 oq32_forestry_est(t,j,type32,ac,type)      Distribution of forestry establishment over ac_est (mio. ha)
 oq32_cost_hvarea(t,i,type)                 Cost of harvesting timber from forests (mio. USD per yr)
 oq32_prod_forestry(t,j,type)               Production of woody biomass from commercial plantations (mio. tDM per yr)
 oq32_bv_aff(t,j,potnatveg,type)            Biodiversity value for aff forestry land (Mha)
 oq32_bv_ndc(t,j,potnatveg,type)            Biodiversity value for ndc forestry land (Mha)
 oq32_bv_plant(t,j,potnatveg,type)          Biodiversity value for plantations (Mha)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/32_forestry/dynamic_feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/32_forestry/dynamic_feb21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/32_forestry/dynamic_feb21/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/32_forestry/dynamic_feb21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/32_forestry/dynamic_feb21/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/32_forestry/dynamic_feb21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%forestry%" == "static_sep16" $include "./modules/32_forestry/static_sep16/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/34_urban/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Urban Land
*'
*' @description The urban land module is one of the land modules in MAgPIE 
*' (see also the other land modules: [30_crop], [31_past], [32_forestry], [35_natveg]). 
*' It describes urban settlement areas and estimates their corresponding carbon content.
*'
*' @authors Jan Philipp Dietrich, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%urban%" == "static" $include "./modules/34_urban/static/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the static realization, urban land remains static over time
*' with the spatial distribution of 1995 from the LUH2 data
*' set [@hurtt2018luh2]. Carbon stocks are fixed to zero because
*' information on urban land carbon density is missing.

*' @limitations Urban land is static over time and
*' corresponding carbon stocks are assumed zero

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "presolve" $include "./modules/34_urban/static/presolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/35_natveg/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Natural Vegetation
*'
*' @description The natural vegetation (natveg) land module is one of the land modules in MAgPIE
*' (see also the other land modules: [30_crop], [31_past], [32_forestry], [34_urban]).
*' It calculates land and carbon stocks, as well as the biodiversity value, of natural vegetation,
*' which consists of primary forest, secondary forest and other natural land.
*' The module determines the availability of natural vegetation for land conversion.
*'
*' @authors Florian Humpenöder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%natveg%" == "dynamic_feb21" $include "./modules/35_natveg/dynamic_feb21/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the dynamic_may18 realization, land and carbon stock dynamics
*' of natural vegetation are modeled endogenously.
*' The initial spatial distribution of the sub-land-types primary forest,
*' secondary forest and other natural land is based on the
*' LUH2 data set [@hurtt2018luh2].
*' The realization includes 2 different kinds of land protection.
*' a) Land protection based on the World Database on Protected Areas (WDPA)
*' maintained by the International Union for Conservation of Nature (IUCN) and
*' b) land protection based on national policies implemented (NPI) and nationally
*' determined contributions to the Paris agreement (NDC) taken from individual country reports.
*' Land protection based on WDPA is static over time, while the NPI/NDC polices
*' ramp up until 2030 and are assumed constant thereafter. For WDPA the level of
*' land protection is based on IUCN catI+II, which reflect areas currently under
*' protection (e.g. strict nature reserves and national parks), and distributed
*' equally across all sub-land-types (primary forest, secondary forest and other natural land).
*' On top of the IUCN catI+II land protection, there are options to protect different
*' conservation priority areas such as biodiversity hotspots (BH), centers of plant
*' diversity (CBD), frontier forests (FF) and last of the wild (LW).
*' NPI/NDC land protection polices are be applied on forest and other land, depending
*' on individual country reports. Additionally, this module provides the ability to
*' harvest natural vegetation for timber. Both wood and woodfuel can be produceed
*' from primary and secondary forest but other land is only allowed to be harvested
*' for woodfuel.
*' @stop

*'
*' @limitations Initialization of both primary and secondary forest in highest
*' age class or equal distrivution of such areas in all age classes. Data exists
*' on a more emperically obtained distribution in different age classes based
*' on satellite data but this results is highly negative land-use change emissions.
*' Inclusion of this data in MAgPIE remains work in progess and is not available for release yet.
*' Additionally, in this module realizatuion, harvested secondary forest stays
*' secondary forest and harvested primary forest is reclassified as secondary forest.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/35_natveg/dynamic_feb21/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/35_natveg/dynamic_feb21/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

scalars
 s35_shift number of 5-year age-classes corresponding to current time step length (1)
;

parameters
 i35_secdforest(j,ac)							              Inital secdforest (mio. ha)
 i35_other(j,ac)								                Inital other land (mio. ha)
 p35_secdforest(t,j,ac)  	                      Secdforest per age class (mio. ha)
 p35_other(t,j,ac)   	  	                      Other land per age class (mio. ha)
 pc35_secdforest(j,ac)    	                    Secdforest per age class in current time step (mio. ha)
 pc35_other(j,ac)   	  	                      Other land per age class in current time step (mio. ha)
 p35_protect_shr(t,j,prot_type)                 Protection share for primforest secdforest and other land (1)
 p35_save_primforest(t,j) 		                  Primforest protection (mio. ha)
 p35_save_secdforest(t,j)		                    Secdforest protection (mio. ha)
 p35_save_other(t,j)			                      Other land protection (mio. ha)
 p35_recovered_forest(t,j,ac) 	                Recovered forest (mio. ha)
 p35_min_forest(t,j) 			                      Minimum forest stock [land protection policies] (Mha)
 p35_min_other(t,j)      		                    Minimum other land stock [land protection policies] (Mha)
 p35_carbon_density_secdforest(t,j,ac,ag_pools) Carbon density secdforest (tC per ha)
 p35_carbon_density_other(t,j,ac,ag_pools) 	    Carbon density other land (tC per ha)
 p35_disturbance_loss_secdf(t,j,ac)                 Loss due to disturbances in secondary forest (mio. ha)
 p35_disturbance_loss_primf(t,j)                   Loss due to disturbances in primary forest (mio. ha)
 i35_plantedclass_ac(j,ac)                       Area of age-classes in secondary forest (1)
 p35_poulter_dist(j,ac)                          Share of age-classes in secondary forest (1)
 p35_save_dist(j,ac)                             Distribution of secondary forest saving (1)
 p35_land(t,j,land_natveg,ac)                    Natural vegetation area (mio. ha)
 p35_updated_gs_natfor(t,i)                      Updated growing stock in natural forests after calibration (m3 per ha)
 p35_land_start_ac(j,ac,land_natveg)             Initial Natural vegetation area (mio. ha)
 p35_observed_gs_reg(i)                          Observed growing stock in natural forests before calibration (m3 per ha)
 p35_gs_scaling_reg(i)                           Regional calibration factors for natural vegetation yields (1)
;

equations
 q35_land_secdforest(j)       		              Secdforest land pool calculation (mio. ha)
 q35_land_other(j)       		                    Other land pool calculation (mio. ha)
 q35_carbon_primforest(j,ag_pools)              Primforest carbon stock calculation (mio tC)
 q35_carbon_secdforest(j,ag_pools)              Secdforest carbon stock calculation (mio tC)
 q35_carbon_other(j,ag_pools)      	            Other land carbon stock calculation (mio tC)
 q35_landdiff              			                Difference in natveg land (mio. ha)
 q35_other_expansion(j,ac)		                  Other land expansion (mio. ha)
 q35_other_reduction(j,ac)		                  Other land reduction (mio. ha)
 q35_secdforest_expansion(j,ac)                 Secdforest reduction (mio. ha)
 q35_secdforest_reduction(j,ac)                 Secdforest reduction (mio. ha)
 q35_primforest_reduction(j)   	                Primforest reduction (mio. ha)
 q35_min_forest(j)					                    Minimum forest land constraint (mio. ha)
 q35_min_other(j)                               Minimum other land constraint (mio. ha)
 q35_secdforest_conversion(j)                   Secondary forest remains secondary forest (mio. ha)
 q35_other_conversion(j)                        Other land remains secondary forest (mio. ha)
 q35_other_est(j,ac)                        	  Distribution of other land additions over ac_est (mio. ha)
 q35_secdforest_est(j,ac)                    	  Distribution of secdforest additions over ac_est (mio. ha)
 q35_hvarea_other(j,ac)							            Harvested area other land (mio. ha)
 q35_hvarea_secdforest(j,ac)					          Harvested area secdforest (mio. ha)
 q35_hvarea_primforest(j)						            Harvested area primforest (mio. ha)
 q35_prod_secdforest(j)                         Production of woody biomass from secondary forests (mio. tDM per yr)
 q35_prod_primforest(j)                         Production of woody biomass from primary forests (mio. tDM per yr)
 q35_prod_other(j)                              Production of woody biomass from other land (mio. tDM per yr)
 q35_cost_hvarea(i)                             Cost of harvesting natural vegetation (mio. USD)
 q35_bv_primforest(j,potnatveg)                 Biodiversity value of primary forest (Mha)
 q35_bv_secdforest(j,potnatveg)                 Biodiversity value of secondary forest (Mha)
 q35_bv_other(j,potnatveg)                     Biodiversity value of other land (Mha)

;

positive variables
  v35_secdforest(j,ac)                          Detailed stock of secdforest (mio. ha)
  v35_other(j,ac)                               Detailed stock of other land (mio. ha)
  vm_landdiff_natveg                            Aggregated difference in natveg land compared to previous timestep (mio. ha)
  v35_other_expansion(j,ac)                     Other land expansion compared to previous timestep (mio. ha)
  v35_other_reduction(j,ac)                     Other land reduction compared to previous timestep (mio. ha)
  v35_secdforest_expansion(j,ac)                Secdforest reduction compared to previous timestep (mio. ha)
  v35_secdforest_reduction(j,ac)                Secdforest reduction compared to previous timestep (mio. ha)
  v35_primforest_reduction(j)                   Primforest reduction compared to previous timestep (mio. ha)
  v35_hvarea_secdforest(j,ac)                    Harvested area from secondary forest (mio. ha)
  v35_hvarea_other(j,ac)                         Harvested area from other land (mio. ha)
  v35_hvarea_primforest(j)                       Harvested area from primary forest (mio. ha)
  vm_prod_natveg(j,land_natveg,kforestry)       Production of woody biomass from natural vegetation (mio. tDM per yr)
 vm_cost_hvarea_natveg(i)                       Cost of harvesting natural vegetation (mio. USD)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov35_secdforest(t,j,ac,type)                   Detailed stock of secdforest (mio. ha)
 ov35_other(t,j,ac,type)                        Detailed stock of other land (mio. ha)
 ov_landdiff_natveg(t,type)                     Aggregated difference in natveg land compared to previous timestep (mio. ha)
 ov35_other_expansion(t,j,ac,type)              Other land expansion compared to previous timestep (mio. ha)
 ov35_other_reduction(t,j,ac,type)              Other land reduction compared to previous timestep (mio. ha)
 ov35_secdforest_expansion(t,j,ac,type)         Secdforest reduction compared to previous timestep (mio. ha)
 ov35_secdforest_reduction(t,j,ac,type)         Secdforest reduction compared to previous timestep (mio. ha)
 ov35_primforest_reduction(t,j,type)            Primforest reduction compared to previous timestep (mio. ha)
 ov35_hvarea_secdforest(t,j,ac,type)            Harvested area from secondary forest (mio. ha)
 ov35_hvarea_other(t,j,ac,type)                 Harvested area from other land (mio. ha)
 ov35_hvarea_primforest(t,j,type)               Harvested area from primary forest (mio. ha)
 ov_prod_natveg(t,j,land_natveg,kforestry,type) Production of woody biomass from natural vegetation (mio. tDM per yr)
 ov_cost_hvarea_natveg(t,i,type)                Cost of harvesting natural vegetation (mio. USD)
 oq35_land_secdforest(t,j,type)                 Secdforest land pool calculation (mio. ha)
 oq35_land_other(t,j,type)                      Other land pool calculation (mio. ha)
 oq35_carbon_primforest(t,j,ag_pools,type)      Primforest carbon stock calculation (mio tC)
 oq35_carbon_secdforest(t,j,ag_pools,type)      Secdforest carbon stock calculation (mio tC)
 oq35_carbon_other(t,j,ag_pools,type)           Other land carbon stock calculation (mio tC)
 oq35_landdiff(t,type)                          Difference in natveg land (mio. ha)
 oq35_other_expansion(t,j,ac,type)              Other land expansion (mio. ha)
 oq35_other_reduction(t,j,ac,type)              Other land reduction (mio. ha)
 oq35_secdforest_expansion(t,j,ac,type)         Secdforest reduction (mio. ha)
 oq35_secdforest_reduction(t,j,ac,type)         Secdforest reduction (mio. ha)
 oq35_primforest_reduction(t,j,type)            Primforest reduction (mio. ha)
 oq35_min_forest(t,j,type)                      Minimum forest land constraint (mio. ha)
 oq35_min_other(t,j,type)                       Minimum other land constraint (mio. ha)
 oq35_secdforest_conversion(t,j,type)           Secondary forest remains secondary forest (mio. ha)
 oq35_other_conversion(t,j,type)                Other land remains secondary forest (mio. ha)
 oq35_other_est(t,j,ac,type)                    Distribution of other land additions over ac_est (mio. ha)
 oq35_secdforest_est(t,j,ac,type)               Distribution of secdforest additions over ac_est (mio. ha)
 oq35_hvarea_other(t,j,ac,type)                 Harvested area other land (mio. ha)
 oq35_hvarea_secdforest(t,j,ac,type)            Harvested area secdforest (mio. ha)
 oq35_hvarea_primforest(t,j,type)               Harvested area primforest (mio. ha)
 oq35_prod_secdforest(t,j,type)                 Production of woody biomass from secondary forests (mio. tDM per yr)
 oq35_prod_primforest(t,j,type)                 Production of woody biomass from primary forests (mio. tDM per yr)
 oq35_prod_other(t,j,type)                      Production of woody biomass from other land (mio. tDM per yr)
 oq35_cost_hvarea(t,i,type)                     Cost of harvesting natural vegetation (mio. USD)
 oq35_bv_primforest(t,j,potnatveg,type)         Biodiversity value of primary forest (Mha)
 oq35_bv_secdforest(t,j,potnatveg,type)         Biodiversity value of secondary forest (Mha)
 oq35_bv_other(t,j,potnatveg,type)              Biodiversity value of other land (Mha)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/35_natveg/dynamic_feb21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/35_natveg/dynamic_feb21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/35_natveg/dynamic_feb21/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/35_natveg/dynamic_feb21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/35_natveg/dynamic_feb21/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/35_natveg/dynamic_feb21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%natveg%" == "static" $include "./modules/35_natveg/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/38_factor_costs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @title Factor Costs

*' @description This module is used to calculate factor costs of production in
*' crop activities. The costs of factors of production included in this module
*' are specifically of labor, capital, and energy and related costs. The costs
*' are crop-specific, and pass to the the cost function in [11_costs].
*' Thus, factor costs will contribute to and influence the choice of production
*' pattern in the model.

*' @authors Jan Philipp Dietrich, Benjamin Bodirsky, Kristine Karstens, Edna J. Molina Bacca


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%factor_costs%" == "fixed_per_ton_mar18" $include "./modules/38_factor_costs/fixed_per_ton_mar18/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%factor_costs%" == "mixed_feb17" $include "./modules/38_factor_costs/mixed_feb17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This 'mixed' realization specifies factors costs to depend on
*' area harvested and agricultural land use intensity and corresponding average
*' production volumes.
*' Consequently, factor costs in this realization react on both: area under
*' production and average productivity of a region as captured by the $\tau$
*' factor. A detailed description of the approach can be found
*' in @dietrich_forecasting_2014 with background information about the used
*' intensity measure in @dietrich_measuring_2012.
*'
*' @limitations This realization assumes that factor costs only depend on area
*' and average productivity of a region. Productivity differences within a
*' region are ignored. Therefore, cases in which the cellular productivity
*' levels affect factors costs are only partially accounted for.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/38_factor_costs/mixed_feb17/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

equations
 q38_cost_prod_crop(i,kcr)      Regional factor input costs for plant production (mio. USD05MER per yr)
;

positive variables
vm_cost_prod(i,kall)             Factor costs (mio. USD05MER per yr)
vm_cost_inv(i)                  Capital investment costs (mio USD05MER  per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_prod(t,i,kall,type)       Factor costs (mio. USD05MER per yr)
 ov_cost_inv(t,i,type)             Capital investment costs (mio USD05MER  per yr)
 oq38_cost_prod_crop(t,i,kcr,type) Regional factor input costs for plant production (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/38_factor_costs/mixed_feb17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/38_factor_costs/mixed_feb17/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/38_factor_costs/mixed_feb17/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/38_factor_costs/mixed_feb17/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/38_factor_costs/mixed_feb17/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%factor_costs%" == "sticky_feb18" $include "./modules/38_factor_costs/sticky_feb18/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/39_landconversion/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Land Conversion Costs

*' @description The land conversion cost module calculates costs for the conversion
*' from one land type to another (e.g. conversion from forest to cropland).
*' Land conversion plays an important role for the overall model dynamics,
*' in particular in terms of CO2 emissions from land-use change.
*' Expansion of agricultural land is one of the major options in the model to increase 
*' agricultural production, besides yield increases ([13_tc], [14_yields]) and trade ([21_trade]).
*' 
*'
*' @authors Florian Humpenöder, Jan Philipp Dietrich, Ulrich Kreidenweis

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%landconversion%" == "global_static_aug18" $include "./modules/39_landconversion/global_static_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In the global_static_aug18 realization, per hectare land conversion costs are separated into 
*' costs for expansion of cropland, pasture and forestry (establishment costs) and 
*' costs for clearing of primary forest, secondary forest and other natural land (clearing costs).
*' We assume a global cost factor of 8000 USD/ha (static over time) for establishment of managed land. 
*' For clearing of natural vegetation we assume a global static cost factor of 5 USD/tC (based on @kreidenweis_pasture_2018). 
*'
*' @limitations Data availability for land conversion costs is very limited.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/39_landconversion/global_static_aug18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/39_landconversion/global_static_aug18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

equations
 q39_cost_landcon(j,land)        	Calculation of cellular landconversion costs (mio. USD05MER per yr)
;

variables
 vm_cost_landcon(j,land)          Land conversion costs (mio. USD05MER per yr)
;

parameters
 i39_cost_establish(land)		Global land establishment costs (USD05MER per hectare)
 i39_cost_clearing(land)        Global land clearing costs (USD05MER per ton C)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_landcon(t,j,land,type)   Land conversion costs (mio. USD05MER per yr)
 oq39_cost_landcon(t,j,land,type) Calculation of cellular landconversion costs (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/39_landconversion/global_static_aug18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/39_landconversion/global_static_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/39_landconversion/global_static_aug18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/39_landconversion/global_static_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/39_landconversion/global_static_aug18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/39_landconversion/global_static_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/40_transport/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Transport
*'
*' @description The [40_transport] module simulates the intraregional 
*' transportation of agricultural products between producer site 
*' and the next city centre (market). It covers the transport of 
*' inputs such as fertilizers to the production site as well as 
*' the transport of products to the market. Calculations are based 
*' on cellular and global parameters and returns the corresponding 
*' cellular transport costs which are then used by the [11_costs] module. 
*'
*' @authors Jan Philipp Dietrich, Florian Humpenöder, Benjamin Bodirsky, Isabelle Weindl, Michael Krause.

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%transport%" == "gtap_nov12" $include "./modules/40_transport/gtap_nov12/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization transportation costs
*' are calculated based on the assumption that transport
*' costs are proportional to the mass which has to be
*' transported and the time which is required for the transport.
*'
*' @limitations The information in distances between
*' production sites and markets is static over time,
*' meaning that infrastructure is assumed to be static
*' over time.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/40_transport/gtap_nov12/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

equation
q40_cost_transport(j,k)   Cellular transport costs for k (mio. USD05MER per yr)
;

variables
 vm_cost_transp(j,k)      Transportation costs (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_transp(t,j,k,type)      Transportation costs (mio. USD05MER per yr)
 oq40_cost_transport(t,j,k,type) Cellular transport costs for k (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/40_transport/gtap_nov12/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/40_transport/gtap_nov12/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/40_transport/gtap_nov12/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%transport%" == "off" $include "./modules/40_transport/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/41_area_equipped_for_irrigation/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Area equipped for irrigation
*'
*' @description The area equipped for irrigation module constrains irrigated crop
*' production to those areas that are equipped with irrigation infrastructure and simulates
*' the evolution of areas equipped for irrigation. The module receives information about
*' the area actually irrigated from the [30_crop] module.
*'
*' @authors Anne Biewald, Markus Bonsch, Christoph Schmitz

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%area_equipped_for_irrigation%" == "endo_apr13" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' @description This realization allows the model to endogenously decide on investments to deploy additional
*' irrigation infrastructure, i.e. to increase the area equipped for irrigation (AEI). Initial values for AEI
*' in 1995 are taken from @siebert_FAO_2007. Contraction of AEI is not possible.
*' Irrigated crop production can only take place where irrigation infrastructure is present.
*'
*' Unit costs per hectare for AEI expansion are derived from a World Bank study (@worldbank_irrigation_1995)
*' and adjusted for the regions used in MAgPIE. The region mapping is as follows:
*'
*' ![Mapping between MAgPIE regions and the regions in 
*' [@worldbank_irrigation_1995]](regions.png){ width=60% }
*'
*' The regional unit costs converge linearly towards the European level until 2050.
*'
*' ![Unit costs for AEI expansion in MAgPIE
*' ](unitcosts.png){ width=60% }
*'
*' @limitations This realization increases model complexity.



*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 p41_AEI_start(t,j)              Area equipped for irrigation at the beginning of each time step (mio. ha)
 pc41_AEI_start(j)               Area equipped for irrigation at the beginning of current time step (mio. ha)
 pc41_unitcost_AEI(i)            Unit cost of AEI expansion (USD04MER per ha)
;

variables
 vm_cost_AEI(i)                  Annuitized irrigation expansion costs (mio. USD04MER per yr)
;

positive variables
 v41_AEI(j)                      Area equipped for irrigation in each grid cell (mio. ha)
;

equations
 q41_area_irrig(j)               Irrigation area constraint (mio. ha)
 q41_cost_AEI(i)                 Calculation of costs of irrigation area expansion (mio. USD04MER)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_AEI(t,i,type)     Annuitized irrigation expansion costs (mio. USD04MER per yr)
 ov41_AEI(t,j,type)        Area equipped for irrigation in each grid cell (mio. ha)
 oq41_area_irrig(t,j,type) Irrigation area constraint (mio. ha)
 oq41_cost_AEI(t,i,type)   Calculation of costs of irrigation area expansion (mio. USD04MER)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/41_area_equipped_for_irrigation/endo_apr13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%area_equipped_for_irrigation%" == "static" $include "./modules/41_area_equipped_for_irrigation/static/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/42_water_demand/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Water demand
*'
*' @description The water demand module determines the water demand in the following
*' sectors: agriculture, industry, electricity, domestic and ecosystem. 
*' Different scenarios for different water demand and environmental flow protection are
*' possible. The module receives information from the [17_production], [30_crop], [09_drivers]
*' and [43_water_availability] modules. It passes information to the module [43_water_availability]
*' and [11_costs].
*'
*' 
*' 
*' @authors Anne Biewald, Markus Bonsch

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%water_demand%" == "agr_sector_aug13" $include "./modules/42_water_demand/agr_sector_aug13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description  
*'
*' This realization models agricultural sector water demand endogenously, while other sectors are kept exogenous;
*' Various settings for environmental water demand described below.
*'
*' *Agricultural water demand*:
*'
*' Water demand for agriculture is endogenously calculated based
*' on irrigated cropland `vm_area(j,kcr,"irrigated")` and livestock production
*' `vm_prod(j2,kli)`.
*'
*' Irrigation water demand per area for each crop category and cluster
*' is provided by the LPJmL model. This parameter refers to the water that
*' has to be applied to the field, i.e. it includes losses due to evaporation on
*' the field, but does not include losses during the water transport from source
*' to field. Livestock water demand `ic42_wat_req_k(j,kli)` is derived from FAO
*' data.
*'
*'
*' *Irrigation efficiency*:
*'
*' Switches for different scenarios for irrigation efficiency can be chosen:
*'
*' * A global static value of irrigation efficiency that is defined as the
*'   global weighted average of water losses from source to field ("conveyance
*'   efficiency times management factor") from @PIK_report104_2007.
*'   Here, irrigated area from @siebert_FAO_2007 has been used as aggregation
*'   weight.
*'
*' * A regression of country values of the "conveyance efficiency times
*'   management factor" from @PIK_report104_2007 on GDP.
*'
*' ![Irrigation efficiency evolution with GDP for the SSP2 scenario.
*'  ](irrigation_efficiency.png){ width=80% }
*'
*' *Non agricultural human water demand*:
*'
*' Water demand from all other sectors is treated exogenously. The scalar
*' `s42_reserved_fraction` determines how much water is reserved for non
*' agricultural purposes. Technically, it is assigned to industrial use, while
*' demand for other non-agricultural sectors is set to 0. The default value is
*' 0.5.
*'
*' *Environmental water demand*
*'
*' Environmental water requirements can be specified separately using the switch
*' `s42_env_flow_scenario`. The following settings are available:
*'
*' * No additional environmental flows are considered.
*' * A certain fraction of available water `s42_env_flow_fraction` is reserved
*'   for environmental purposes and consequently not available for agricultural
*'   activities (in addition to `s42_reserved_fraction`).
*' * Environmental flow requirements (EFR) are calculated from LPJmL inputs
*'   according to an algorithm by  @smakhtin_water_2004 on cluster level. Due to
*'   the fact that MAgPIE only considers available blue water during the growing
*'   period of the plants ([43_water_availability]), EFR are also only
*'   calculated during this growing period. They are reserved in addition to
*'   `s42_protected_fraction`. In the case of the absence of an environmental
*'   flow protection (EFP) policy, a base protection can be specified:
*'   `s42_env_flow_base_fraction`. Its default value is 5 % of available water.
*'
*' Whether a potential EFP policy takes effect is determined by the parameter
*' `f42_env_flow_policy`.
*'
*' @limitations The module uses the "conveyance efficiency times management
*' factor" for irrigation efficiency. Therefore, the management factor is
*' accounted twice, since it is already considered in LPJmL water quantity used
*' for irrigation (`airrig`: annual irrigation). Furthermore, the module
*' realization does not consider annual water balances but only water balances
*' during the growing period of crops. This period differs between cells.
*'

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/42_water_demand/agr_sector_aug13/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/42_water_demand/agr_sector_aug13/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 i42_wat_req_k(t,j,k)       	      LPJmL annual water demand for irrigation per ha per year (m^3) + Livestock demand per ton (m^3)
 ic42_wat_req_k(j,k)        	      LPJmL annual water demand for irrigation per ha per year (m^3) + Livestock demand per ton (m^3)
 i42_env_flows(t,j)                 Environmental flow requirements if a protection policy is in place (mio. m^3)
 i42_env_flows_base(t,j)    	      Environmental flow requirements if no protection policy is in place  (mio. m^3)
 ic42_env_flow_policy(i)            Determines whether environmental flow protection is enforced in the current time step (1)
 i42_env_flow_policy(t,i)           Determines whether environmental flow protection is enforced (1)
* country-specific scenario switch
 p42_country_dummy(iso)             Dummy parameter indicating whether country is affected by EFP (1)
 p42_EFP_region_shr(t_all,i)        Weighted share of region with regards to EFP (1)
;

equations
 q42_water_demand(wat_dem,j)         Water consumption in different sectors (mio. m^3 per yr)
;

positive variables
  vm_watdem(wat_dem,j)               Water demand from different sectors (mio. m^3 per yr)
  v42_irrig_eff(j)                   Irrigation efficiency (1)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_watdem(t,wat_dem,j,type)         Water demand from different sectors (mio. m^3 per yr)
 ov42_irrig_eff(t,j,type)            Irrigation efficiency (1)
 oq42_water_demand(t,wat_dem,j,type) Water consumption in different sectors (mio. m^3 per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/42_water_demand/agr_sector_aug13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/42_water_demand/agr_sector_aug13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/42_water_demand/agr_sector_aug13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/42_water_demand/agr_sector_aug13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/42_water_demand/agr_sector_aug13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/42_water_demand/agr_sector_aug13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%water_demand%" == "all_sectors_aug13" $include "./modules/42_water_demand/all_sectors_aug13/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/43_water_availability/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Water availability 
*'
*' @description The water availability module determines the water that is available 
*' in MAgPIE. The following water sources are currently implemented: surface water, 
*' groundwater, technical (like desalination etc.). Additionally, 
*' this module includes the main water constraint that requires water withdrawals 
*' to be smaller or equal to available water. Information is passed to and received 
*' from the [42_water_demand] module.
*'
*' @authors Anne Biewald, Markus Bonsch

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%water_availability%" == "total_water_aug13" $include "./modules/43_water_availability/total_water_aug13/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


*' The calculation of available water as described below happens
*' in the MAgPIE preprocessing.
*' This realization only considers renewable water resources, i.e.
*' runoff generated from precipitation. All runoff is assumed to
*' enter rivers, neglecting groundwater recharge. Other water resources
*' such as fossil groundwater, discharge from melting glaciers or
*' desalination are also not considered. The calculation of available
*' water per grid cell is based on LPJmL (@bondeau_lpjml_2007) simulations. For
*' each river basin, total annual runoff in the basin constitutes the
*' amount of water available in one year. In order to account for the fact that
*' water can only be supplied to the plants during the growing period, the mean 
*' growing period over all crops based on LPJmL sowing and harvesting dates (@bondeau_lpjml_2007)
*' is calculated in MAgPIE. Some data has been excluded from the calculation:
*'
*' * Winter crops in the northern hemisphere (sowing date later than June 
*' 29th and harvest date later than December 31st) because we assume
*' that irrigation does not take place during winter time.
*'
*' * Data points with crop yields below 10% of the world average yield.
*' Such a low yield indicates that the site is not appropriate for this
*' specific crop and the LPJmL (@bondeau_lpjml_2007) growing period simulation
*' is likely to be distorted.
*'
*' Therefore, water available for irrigation in each basin only consists of the
*' total runoff occurring in the mean growing period in all basin cells
*' except for cells where water storage in terms of dams is present (taken
*' from @biemans_water_2011). In this case, total annual runoff is available.
*'
*' The distribution of basin runoff in the growing period to the individual
*' grid cells is done using LPJmL (@bondeau_lpjml_2007) discharge as a weight.
*'
*' There is an interface to the [42_water_demand] module. If exogenous
*' non-agricultural water demand exceeds available water the missing amount is available
*' from groundwater to avoid infeasibility.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/43_water_availability/total_water_aug13/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 im_wat_avail(t,wat_src,j)        Water availability (mio. m^3 per yr)
;

variables 
  v43_watavail(wat_src,j)         Water available from different sources (mio. m^3 per yr)
;

equations
  q43_water(j)                    Local seasonal water constraints (mio. m^3 per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov43_watavail(t,wat_src,j,type) Water available from different sources (mio. m^3 per yr)
 oq43_water(t,j,type)            Local seasonal water constraints (mio. m^3 per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*$Ifi "%phase%" == "input" $include "./modules/43_water_availability/total_water_aug13/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/43_water_availability/total_water_aug13/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/43_water_availability/total_water_aug13/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/43_water_availability/total_water_aug13/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/43_water_availability/total_water_aug13/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/43_water_availability/total_water_aug13/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/44_biodiversity/module.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

*' @title Biodiversity
*'
*' @description The biodiversity module estimates how the changes in land pools
*' affect terrestrial biodiversity. It requires information about the land
*' area of the different land pools provided by all land modules ([30_crop], [31_past], [32_forestry],
*' [34_urban] and [35_natveg]), as well as module [10_land] about the potential natural vegetation.
*'
*'
*' @authors Patrick v. Jeetze, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%biodiversity%" == "bv_btc_mar21" $include "./modules/44_biodiversity/bv_btc_mar21/realization.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

*' @description In this realisation biodiversity values are computed for each
*' land cover type. The calculations are based on the Biodiversity Intactness Index (BII).
*' BII values for each land cover type are multiplied by the respective land area and
*' are weighted by cluster-specific range-rarity. This realisation also allows to introduce costs
*' on the loss of the total biodiversity value.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/44_biodiversity/bv_btc_mar21/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/44_biodiversity/bv_btc_mar21/declarations.gms" DONE!
*** (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK),
*** authors, and contributors see AUTHORS file
*** This file is part of MAgPIE and licensed under GNU AGPL Version 3
*** or later. See LICENSE file or go to http://www.gnu.org/licenses/
*** Contact: magpie@pik-potsdam.de

parameters
 pc44_bv_weighted(j,landcover44)		        Current range rarity weighted bii (Mha)
 p44_price_bv_loss(t)			                biodiversity value loss price factor (USD per ha of bv loss)
 pc44_price_bv_loss			                    biodiversity value loss price factor (USD per ha of bv loss)
;

variables
 v44_bv_loss(j)                                 total biodiversity value loss (Mha per time step)
 v44_diff_bv_landcover(j,landcover44)	 		difference of biodiversity value per land class (Mha per time step)
 vm_cost_bv_loss(j)					            biodiversity value loss cost (mio USD)
;

positive variables
 vm_bv(j,landcover44,potnatveg)		            biodiversity value for all land cover classes (unweighted) (Mha)
 v44_bv_weighted(j,landcover44) 			    range rarity weighted biodiversity value (Mha)
;

equations
 q44_bv_loss(j)                                 total biodiversity value loss constraint (Mha)
 q44_diff_bv_landcover(j,landcover44)			biodiversity value loss constraint per land class (Mha)
 q44_bv_weighted(j,landcover44)		            biodiversity value stock constraint (Mha)
 q44_cost_bv_loss(j)			                biodiversity value loss cost constraint (mio USD)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov44_bv_loss(t,j,type)                       total biodiversity value loss (Mha per time step)
 ov44_diff_bv_landcover(t,j,landcover44,type) difference of biodiversity value per land class (Mha per time step)
 ov_cost_bv_loss(t,j,type)                    biodiversity value loss cost (mio USD)
 ov_bv(t,j,landcover44,potnatveg,type)        biodiversity value for all land cover classes (unweighted) (Mha)
 ov44_bv_weighted(t,j,landcover44,type)       range rarity weighted biodiversity value (Mha)
 oq44_bv_loss(t,j,type)                       total biodiversity value loss constraint (Mha)
 oq44_diff_bv_landcover(t,j,landcover44,type) biodiversity value loss constraint per land class (Mha)
 oq44_bv_weighted(t,j,landcover44,type)       biodiversity value stock constraint (Mha)
 oq44_cost_bv_loss(t,j,type)                  biodiversity value loss cost constraint (mio USD)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*$Ifi "%phase%" == "input" $include "./modules/44_biodiversity/bv_btc_mar21/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/44_biodiversity/bv_btc_mar21/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/44_biodiversity/bv_btc_mar21/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/44_biodiversity/bv_btc_mar21/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/45_climate/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Climate
*'
*' @description The climate module provides information about the present
*' climate classes in the different cells (as shares of the total cell).
*' This information is used by other modules to choose climate class dependent
*' factors such as growth parameters correctly (e.g. used in [35_natveg]).
*'
*' @authors Jan Philipp Dietrich

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%climate%" == "static" $include "./modules/45_climate/static/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization climate classification information remains
*' static over the whole simulation based on data for 1976-2000 taken from
*' <http://koeppen-geiger.vu-wien.ac.at/shifts.htm> (@rubel_observed_2010).
*'
*' @limitations Temporal variations in climate classification are not considered.


*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/45_climate/static/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/45_climate/static/input.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/50_nr_soil_budget/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Nitrogen soil budget

*' @description The module 50_nr_soil_budget balances the nitrogen flows for crop land soils and pasture soils 
*' and calculates the resulting demand for inorganic fertilizer and associated costs.
 
*' @authors Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%nr_soil_budget%" == "exoeff_aug16" $include "./modules/50_nr_soil_budget/exoeff_aug16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization calculates the nitrogen balance for crop land and pasture land 
*' using exogenous uptake efficiencies. Several scenarios are available for the efficiency.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/50_nr_soil_budget/exoeff_aug16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/50_nr_soil_budget/exoeff_aug16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


positive variables
 vm_nr_inorg_fert_reg(i,land_ag)  Inorganic fertilizer application (Tg N per yr)
 vm_nr_inorg_fert_costs(i)        Cost of inorganic fertilizers (mio. USD05MER per yr)
 vm_nr_eff(i)                    Cropland nutrient uptake efficiency (Tg N per yr)
 vm_nr_eff_pasture(i)            Pasture nutrient uptake efficiency (Tg N per yr)
 v50_nr_inputs(i)                Total inputs to croplands (Tg N per yr)
 v50_nr_withdrawals(i,kcr)        Withdrawals of Nr from cropland soils (Tg N per yr)
 v50_nr_surplus_cropland(i)      Total Nr surplus on cropland soils (Tg N per yr)
 v50_nr_inputs_pasture(i)        Total inputs to croplands (Tg N per yr)
 v50_nr_withdrawals_pasture(i)   Withdrawals of Nr from pasture soils (Tg N per yr)
 v50_nr_surplus_pasture(i)       Total Nr surplus on pasture soils (Tg N per yr)
 v50_nr_deposition(i,land)        Atmospheric deposition (Tg N per yr)
;

equations
 q50_nr_cost_fert(i)           Fertilizer costs (mio. USD05MER per yr)
 q50_nr_bal_crp(i)             Cropland nutrient inputs have to equal withdrawals and losses (Tg N per yr)
 q50_nr_withdrawals(i,kcr)     Calculating nr withdrawals (Tg N per yr)
 q50_nr_inputs(i)              Calculating nr withdrawals (Tg N per yr)
 q50_nr_surplus(i)             Calculating nr surplus (Tg N per yr)
 q50_nr_bal_pasture(i)         Nitrogen balance pasture lands (Tg N per yr)
 q50_nr_inputs_pasture(i)      Nitrogen inputs to pastures (Tg N per yr)
 q50_nr_withdrawals_pasture(i) Nitrogen withdrawals from pastures (Tg N per yr)
 q50_nr_surplus_pasture(i)     Nitrogen surplus on pastures (Tg N per yr)
 q50_nr_deposition(i,land)     Atmospheric deposition (Tg N per yr)
;

parameters
 i50_atmospheric_deposition_rates(t,j,land)   Atmospheric deposition rate (t N per ha)
* country-specific scenario switch
 p50_country_dummy_cropneff(iso)              Dummy parameter indicating whether country is affected by crop neff scenario (1)
 p50_country_dummy_pastneff(iso)              Dummy parameter indicating whether country is affected by pasture neff scenario (1)
 p50_cropneff_region_shr(t,i)             Weighted share of region with regards to crop neff scenario of countries (1)
 p50_pastneff_region_shr(t,i)             Weighted share of region with regards to pasture neff scenario of countries (1)
 ;
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_nr_inorg_fert_reg(t,i,land_ag,type) Inorganic fertilizer application (Tg N per yr)
 ov_nr_inorg_fert_costs(t,i,type)       Cost of inorganic fertilizers (mio. USD05MER per yr)
 ov_nr_eff(t,i,type)                    Cropland nutrient uptake efficiency (Tg N per yr)
 ov_nr_eff_pasture(t,i,type)            Pasture nutrient uptake efficiency (Tg N per yr)
 ov50_nr_inputs(t,i,type)               Total inputs to croplands (Tg N per yr)
 ov50_nr_withdrawals(t,i,kcr,type)      Withdrawals of Nr from cropland soils (Tg N per yr)
 ov50_nr_surplus_cropland(t,i,type)     Total Nr surplus on cropland soils (Tg N per yr)
 ov50_nr_inputs_pasture(t,i,type)       Total inputs to croplands (Tg N per yr)
 ov50_nr_withdrawals_pasture(t,i,type)  Withdrawals of Nr from pasture soils (Tg N per yr)
 ov50_nr_surplus_pasture(t,i,type)      Total Nr surplus on pasture soils (Tg N per yr)
 ov50_nr_deposition(t,i,land,type)      Atmospheric deposition (Tg N per yr)
 oq50_nr_cost_fert(t,i,type)            Fertilizer costs (mio. USD05MER per yr)
 oq50_nr_bal_crp(t,i,type)              Cropland nutrient inputs have to equal withdrawals and losses (Tg N per yr)
 oq50_nr_withdrawals(t,i,kcr,type)      Calculating nr withdrawals (Tg N per yr)
 oq50_nr_inputs(t,i,type)               Calculating nr withdrawals (Tg N per yr)
 oq50_nr_surplus(t,i,type)              Calculating nr surplus (Tg N per yr)
 oq50_nr_bal_pasture(t,i,type)          Nitrogen balance pasture lands (Tg N per yr)
 oq50_nr_inputs_pasture(t,i,type)       Nitrogen inputs to pastures (Tg N per yr)
 oq50_nr_withdrawals_pasture(t,i,type)  Nitrogen withdrawals from pastures (Tg N per yr)
 oq50_nr_surplus_pasture(t,i,type)      Nitrogen surplus on pastures (Tg N per yr)
 oq50_nr_deposition(t,i,land,type)      Atmospheric deposition (Tg N per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/50_nr_soil_budget/exoeff_aug16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/50_nr_soil_budget/exoeff_aug16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/50_nr_soil_budget/exoeff_aug16/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/50_nr_soil_budget/exoeff_aug16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/50_nr_soil_budget/exoeff_aug16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%nr_soil_budget%" == "off" $include "./modules/50_nr_soil_budget/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/51_nitrogen/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Nitrogen
*' @description
*' The nitrogen module calculates nitrogeneous emissions before technical
*' mitigation, including N2O, NOx, NH3, NO3- and N2. Sources of these emissions include
*' manure, inorganic fertilizers, crop residues, soil organic matter, and indirect emissions.
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%nitrogen%" == "ipcc2006_sep16" $include "./modules/51_nitrogen/ipcc2006_sep16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' The nitrogen module calculates nitrogeneous emissions before technical
*' mitigation, including N2O, NOx, NH3, NO3- and N2.
*' The model receives information on nitrogen flows from [50_nr_soil_budget],
*' [55_awms], [18_residues], [59_som], and it provides the emissions to the
*' module [56_ghg_policy].
*' Emissions factors estimates are largely based on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.),
*' as described in (@bodirsky_current_2012.).
*'
*' @authors Benjamin Leon Bodirsky

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/51_nitrogen/ipcc2006_sep16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/51_nitrogen/ipcc2006_sep16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

equations
 q51_emissions_inorg_fert(i,n_pollutants_direct)   estimates various emission types X from inorganic fertilizer before technical mitigation (Mt X-N)
 q51_emissions_man_crop(i,n_pollutants_direct)     estimates various emission types X from manure on cropland before technical mitigation   (Mt X-N)
 q51_emissions_resid(i,n_pollutants_direct)        estimates various emission types X from residues before technical mitigation            (Mt X-N)
 q51_emissions_resid_burn(i,n_pollutants_direct)   estimates various emission types X from residues burning (Mt X-N)
 q51_emissions_som(i,n_pollutants_direct)          estimates various emission types X from soil organic matter loss before technical mitigation (Mt X-N)
 q51_emissionbal_man_past(i,n_pollutants_direct)   estimates various emission types X from manure on pasture land before technical mitigation (Mt X-N)
 q51_emissionbal_awms(i,n_pollutants_direct)       estimates various emission types X from animal waste management systems before technical mitigation  (Mt X-N)
 q51_emissions_indirect_n2o(i,emis_source_n51)     estimates various emission types X from volatilisation and leaching  (Mt X-N)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 oq51_emissions_inorg_fert(t,i,n_pollutants_direct,type) estimates various emission types X from inorganic fertilizer before technical mitigation (Mt X-N)
 oq51_emissions_man_crop(t,i,n_pollutants_direct,type)   estimates various emission types X from manure on cropland before technical mitigation   (Mt X-N)
 oq51_emissions_resid(t,i,n_pollutants_direct,type)      estimates various emission types X from residues before technical mitigation            (Mt X-N)
 oq51_emissions_resid_burn(t,i,n_pollutants_direct,type) estimates various emission types X from residues burning (Mt X-N)
 oq51_emissions_som(t,i,n_pollutants_direct,type)        estimates various emission types X from soil organic matter loss before technical mitigation (Mt X-N)
 oq51_emissionbal_man_past(t,i,n_pollutants_direct,type) estimates various emission types X from manure on pasture land before technical mitigation (Mt X-N)
 oq51_emissionbal_awms(t,i,n_pollutants_direct,type)     estimates various emission types X from animal waste management systems before technical mitigation  (Mt X-N)
 oq51_emissions_indirect_n2o(t,i,emis_source_n51,type)   estimates various emission types X from volatilisation and leaching  (Mt X-N)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/51_nitrogen/ipcc2006_sep16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/51_nitrogen/ipcc2006_sep16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/51_nitrogen/ipcc2006_sep16/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/51_nitrogen/ipcc2006_sep16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/51_nitrogen/ipcc2006_sep16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/51_nitrogen/ipcc2006_sep16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%nitrogen%" == "off" $include "./modules/51_nitrogen/off/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%nitrogen%" == "rescaled_jan21" $include "./modules/51_nitrogen/rescaled_jan21/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/52_carbon/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Carbon
*'
*' @description The carbon module provides annual land-related CO2 emissions for the
*' [56_ghg_policy] module. The carbon module provides carbon density information
*' on cellular level to all land modules ([30_crop], [31_past], [32_forestry],
*' [34_urban] and [35_natveg]), and in return it gets the current carbon stock
*' levels from respective land pools. The module also accounts for changes in
*' terrestrial carbon stocks cause by climate change effects on biosphere [45_climate].
*'
*'
*' @authors Benjamin Leon Bodirsky, Florian Humpenoeder, Abhijeet Mishra

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%carbon%" == "normal_dec17" $include "./modules/52_carbon/normal_dec17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization
*' calculates annual land-related CO2 emissions as
*' difference of carbon stocks between the current and the previous time step.
*' Land-related CO2 emissions include CO2 emissions from land-use change as well as
*' changes in carbon stocks in the terrestrial biosphere due to climate change
*' (the later is only included if `c52_carbon_scenario = "cc"`).
*' The realization provides carbon density information on cellular level to all
*' land modules ([30_crop], [31_past], [32_forestry], [34_urban] and [35_natveg]),
*' which return land type specific carbon stocks to the carbon module. The realization
*' also provides carbon density for different age-classes, based on a
*' chapman-richards volume growth model, to the land modules [32_forestry] and [35_natveg]
*' [@humpenoder_investigating_2014 and @braakhekke_modelling_2019].

*' @limitations CO2 emissions in the 1st time step (1995) are not meaningful because
*' carbon stock information prior to 1995 is not available

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/52_carbon/normal_dec17/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/52_carbon/normal_dec17/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

variables
 vm_carbon_stock_change(j,land,c_pools)	Change in carbon stocks compared to previous time step (mio. tC per time step)
;

positive variables
 vm_carbon_stock(j,land,c_pools)        	Carbon stock in vegetation soil and litter for different land types (mio. tC)
;

parameters
 pm_carbon_density_ac(t_all,j,ac,ag_pools)    		Above ground natveg carbon density for age classes and carbon pools (tC per ha)
 pm_carbon_density_ac_forestry(t_all,j,ac,ag_pools)    Above ground plantation carbon density for age classes and carbon pools (tC per ha)
 pc52_carbon_density_start(t_all,j,ag_pools)  Above ground carbon density for new land in other land pool (tC per ha)
 pcm_carbon_stock(j,land,c_pools)         Current carbon in vegetation soil and litter for different land types (mio. tC)
;

equations
 q52_carbon_stock_change(j,land,c_pools) Calculation carbon stock reduction (mio. tC per time step)
 q52_co2c_emis(j,emis_co2)             		 Calculation of annual CO2 emissions (mio. tC per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_carbon_stock_change(t,j,land,c_pools,type)   Change in carbon stocks compared to previous time step (mio. tC per time step)
 ov_carbon_stock(t,j,land,c_pools,type)          Carbon stock in vegetation soil and litter for different land types (mio. tC)
 oq52_carbon_stock_change(t,j,land,c_pools,type) Calculation carbon stock reduction (mio. tC per time step)
 oq52_co2c_emis(t,j,emis_co2,type)               Calculation of annual CO2 emissions (mio. tC per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/52_carbon/normal_dec17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/52_carbon/normal_dec17/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/52_carbon/normal_dec17/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "start" $include "./modules/52_carbon/normal_dec17/start.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/52_carbon/normal_dec17/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/52_carbon/normal_dec17/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%carbon%" == "off" $include "./modules/52_carbon/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/53_methane/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Methane

*' @description This module calculates methane emissions according
*' to 2006 IPCC Guidelines of National Greenhouse Gas Inventories.
*' See also @ipcc_2006_2006.

*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%methane%" == "ipcc2006_flexreg_apr16" $include "./modules/53_methane/ipcc2006_flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This module realization calculates methane from different
*' agricultural sources based on the @ipcc_2006_2006.
*' Methane emission sources considered in the module are enteric fermentation,
*' animal waste management, and rice.

*' @limitations CH4 emissions from animal waste management may be
*' inconsistent with CH4 emissions from enteric fermentation.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/53_methane/ipcc2006_flexreg_apr16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/53_methane/ipcc2006_flexreg_apr16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


equations
 q53_emissionbal_ch4_ent_ferm(i)                   Detailed ch4 constraint for enteric fermentation before technical mitigation (tCH4)
 q53_emissionbal_ch4_awms(i)                       Detailed ch4 constraint for animal waste management systems before technical mitigation (tCH4)
 q53_emissionbal_ch4_rice(i)                       Detailed ch4 constraint for rice before technical mitigation (tCH4)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 oq53_emissionbal_ch4_ent_ferm(t,i,type) Detailed ch4 constraint for enteric fermentation before technical mitigation (tCH4)
 oq53_emissionbal_ch4_awms(t,i,type)     Detailed ch4 constraint for animal waste management systems before technical mitigation (tCH4)
 oq53_emissionbal_ch4_rice(t,i,type)     Detailed ch4 constraint for rice before technical mitigation (tCH4)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/53_methane/ipcc2006_flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/53_methane/ipcc2006_flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/53_methane/ipcc2006_flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/53_methane/ipcc2006_flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/53_methane/ipcc2006_flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%methane%" == "off" $include "./modules/53_methane/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/54_phosphorus/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Phosphorus
*'
*' @description The phosphorus module is introduced to estimate the major
*' P-flows in the agricultural sector and to determine the dynamics of P-Pools in the soil.
*' Different P-flows can be accounted in MAgPIE, among others:
*'
*'     * P withdrawals by harvest: estimated as P content of crop harvest
*'     * P withdrawals by harvest of above ground residues: estimated as P content of residues
*'     * P inputs by decaying recycled residues: estimated as P content of recycled residues
*'     * P inputs by burned residues: estimated as P content of burned residues but no combustion losses assumed
*'     * P inputs by manure recycled to croplands
*'     * P inputs by fertilizers
*'     * P inputs by release of plant-available P from the permanent P-Pool.
*'     * P inputs by seed
*'     * P inputs by weathering
*'     * P losses by erosion
*'     * P losses by leaching
*'
*' However, for the time being, this module is not activated in MAgPIE.
*' It is a topic we seek to include in future developments of the model as enriches
*' the biophysical aspects of the model as well as adds to the fertilizer costs (and hence total costs of production).
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%phosphorus%" == "off" $include "./modules/54_phosphorus/off/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This is the current default implementation of the module.
*' It deactivates calculations related to the phosphorus module.

*' @limitations The realization is still under development.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/54_phosphorus/off/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


variables
 vm_p_fert_costs(i)              costs for mineral fertilizers (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_p_fert_costs(t,i,type) costs for mineral fertilizers (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "preloop" $include "./modules/54_phosphorus/off/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/54_phosphorus/off/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/55_awms/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Animal waste management systems
*' @description
*' This module calculates the nutrient (NPK) flows within animal waste management.
*' It receives information on feed from the module [70_livestock], and provides
*' information on recycled manure to [50_nr_soil_budget] and information on
*' greenhouse gas emissions to modules [51_nitrogen] and [53_methane].
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%awms%" == "ipcc2006_aug16" $include "./modules/55_awms/ipcc2006_aug16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' Manure excretion is estimated using a mass balance approach and
*' based on NPK in feed and N in slaughtered animals (@bodirsky_current_2012.).
*' Animal waste management is largely based on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.).

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/55_awms/ipcc2006_aug16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/55_awms/ipcc2006_aug16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


parameters
 i55_manure_recycling_share(i,kli,awms_conf,npk)  Share of manure recycled (tNr per tNr)
 ic55_manure_fuel_shr(i,kli)                      Share of manure excreted on pastures used for fuel (tNr per tNr)
 ic55_awms_shr(i,kli,awms_conf)                   Share of manure Nr managed in each animal waste management systems (tNr per tNr)
 p55_region_shr(t_all,i)	                        AWM scenario share of the region (1)
 p55_country_dummy(iso)		                        Dummy parameter indicating whether country is affected by selected awm scenario (1)
;


positive variables
 vm_manure(i, kli, awms, npk)                 Calculation of manure excreted in confinements (mio t X)
 v55_feed_intake(i, kli, awms, npk)           Calculation of manure excreted in confinements (mio t X)
 vm_manure_recycling(i, npk)                  Manure being recycled to croplands (mio t X)
 vm_manure_confinement(i,kli,awms_conf,npk)   Manure excreted in confinements managed in different awms (mio t X)
;


equations
 q55_bal_intake_grazing_pasture(i,kli, npk)   Nutrient balance for intake of grazing animals on pastures (mio t X)
 q55_bal_intake_confinement(i,kli, npk)       Nutrient balance for intake in confinement  (mio t X)
 q55_bal_intake_grazing_cropland(i,kli, npk)  Nutrient balance for intake of grazing animals on cropland  (mio t X)
 q55_bal_intake_fuel(i,kli, npk)              Nutrient balance for intake of grazing animals on pasture whose excreate are collected for household fuel (mio t X)
 q55_bal_manure(i,kli,awms,npk)               Calculation of manure (mio t X)
 q55_manure_confinement(i,kli,awms_conf,npk)  Manure from animals in confinement managed in different awms (mio t X)
 q55_manure_recycling(i, npk)                 Manure from animals in confinement recycling to cropland (mio t X)
;



*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_manure(t,i,kli,awms,npk,type)                    Calculation of manure excreted in confinements (mio t X)
 ov55_feed_intake(t,i,kli,awms,npk,type)             Calculation of manure excreted in confinements (mio t X)
 ov_manure_recycling(t,i,npk,type)                   Manure being recycled to croplands (mio t X)
 ov_manure_confinement(t,i,kli,awms_conf,npk,type)   Manure excreted in confinements managed in different awms (mio t X)
 oq55_bal_intake_grazing_pasture(t,i,kli,npk,type)   Nutrient balance for intake of grazing animals on pastures (mio t X)
 oq55_bal_intake_confinement(t,i,kli,npk,type)       Nutrient balance for intake in confinement  (mio t X)
 oq55_bal_intake_grazing_cropland(t,i,kli,npk,type)  Nutrient balance for intake of grazing animals on cropland  (mio t X)
 oq55_bal_intake_fuel(t,i,kli,npk,type)              Nutrient balance for intake of grazing animals on pasture whose excreate are collected for household fuel (mio t X)
 oq55_bal_manure(t,i,kli,awms,npk,type)              Calculation of manure (mio t X)
 oq55_manure_confinement(t,i,kli,awms_conf,npk,type) Manure from animals in confinement managed in different awms (mio t X)
 oq55_manure_recycling(t,i,npk,type)                 Manure from animals in confinement recycling to cropland (mio t X)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/55_awms/ipcc2006_aug16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/55_awms/ipcc2006_aug16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/55_awms/ipcc2006_aug16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/55_awms/ipcc2006_aug16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/55_awms/ipcc2006_aug16/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/55_awms/ipcc2006_aug16/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/55_awms/ipcc2006_aug16/nl_release.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_relax" $include "./modules/55_awms/ipcc2006_aug16/nl_relax.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%awms%" == "off" $include "./modules/55_awms/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/56_ghg_policy/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Greenhouse gas policy
*'
*' @description The module 56_ghg_policy connects emissions to costs which then enter 
*' the objective function of MAgPIE. Connecting emissions with costs in a cost 
*' minimization model like MAgPIE creates an incentive to reduce emissions. 
*' This can be interpreted as an internalization of the external costs by pollution, 
*' e.g. by policies that deincentivize polluting activity. 
*' Technically, every ton of emission is multiplied with an emission price to 
*' determine emission costs. Emission sources can be excluded from pricing by switches 
*' defined in config/default.cfg.
*'
*' Please note that emissions that occur only once (e.g. CO2 emissions from deforestation) 
*' are handled differently than emissions that occur in every timestep 
*' (e.g. CH4 and N2O emissions from agricultural production).
*'
*' @authors Benjamin Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%ghg_policy%" == "price_jan20" $include "./modules/56_ghg_policy/price_jan20/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description This realization applies pollutant prices to different
*' emission types depending on the emission pricing policy defined in `f56_emis_policy`.
*' In addition, the average annual reward for carbon dioxide removal (CDR)
*' and the reward or penalty of local biophysical effects
*' from afforestation [32_forestry] is calculated as the present value (PV) of all
*' future cash flows multiplied with an annuity factor. The PV is obtained by
*' multiplication of `vm_cdr_aff` with the corresponding carbon price and subsequent
*' discouting based on the given discount rate `pm_interest`.
*' Technically, the reward for CDR and bph effects from afforestation is a negative cash flow
*' lowering the costs in the objective function of the model.
*' If pollutant prices are zero, which is the default for reference scenarios without
*' mitigation, total emission costs entering the objective function are zero.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/56_ghg_policy/price_jan20/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/56_ghg_policy/price_jan20/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
 im_pollutant_prices(t_all,i,pollutants)      	  Certificate prices for N2O-N CH4 CO2-C used in the model (USD05MER per Mg)
 p56_pollutant_prices_input(t_all,i,pollutants)   Certificate prices for N2O-N CH4 CO2-C from input files (USD05MER per Mg)
 p56_emis_policy(t,i,pollutants,emis_source)      GHG emission policy scenarios (binary)
 p56_c_price_aff(t_all,i,ac)				              C price used for afforestation decision-making (USD05MER per tC)
 pc56_c_price_induced_aff					                Helper for fixing C price driven afforestation to zero for historic time steps (binary)
 p56_region_price_shr(t_all,i)	                  GHG price share of the region (1)
 p56_country_dummy(iso)		                        Dummy parameter indicating whether country is affected by selected GHG policy (1)
;

equations
 q56_technical_mitigation_reg(i,pollutants,emis_source)   Application of maccs on emissions (Tg per yr)
 q56_technical_mitigation_cell(j,pollutants,emis_source)  Application of maccs on emissions (Tg per yr)
 q56_cell_to_reg(i,pollutants,emis_source)                Aggregation to regional emissions (Tg per yr)
 q56_emission_costs(i)                                    Calculation of total emission costs (mio. USD05MER per yr)
 q56_emission_costs_reg_yearly(i,emis_reg_yr56)       	  Calculation of regional costs for annual emissions (mio. USD05MER per yr)
 q56_emission_costs_reg_oneoff(i,emis_reg_one56)       	  Calculation of regional costs for emissions occuring only once in time (mio. USD05MER per yr)
 q56_emission_costs_cell_yearly(j,emis_cell_yr56)     	  Calculation of cellular costs for annual emissions (mio. USD05MER per yr)
 q56_emission_costs_cell_oneoff(j,emis_cell_one56)     	  Calculation of cellular costs for emissions occuring only once in time (mio. USD05MER per yr)
 q56_reward_cdr_aff_reg(i)                                Regional revenues for carbon captured by afforestation (mio. USD05MER per yr)
 q56_reward_cdr_aff(j)			                       	      Cellular revenues for carbon captured by afforestation (mio. USD05MER per yr)
 q56_peatland_emis_cost_reg(i)                            Regional peatland GHG emissions costs (mio. USD05MER per yr)
 q56_peatland_emis_cost(j)                            	  Cellular peatland GHG emissions costs (mio. USD05MER per yr)
;


positive variables
 vm_peatland_emis_cost(i)            Regional peatland GHG emissions costs (mio. USD05MER per yr)
 v56_peatland_emis_cost(j)           Cellular peatland GHG emissions costs (mio. USD05MER per yr)
;


variables
 vm_btm_reg(i,emis_source,pollutants)                    Regional emissions before technical mitigation (Tg per yr)
 vm_btm_cell(j,emis_source,pollutants)                   Cellular emissions before technical mitigation (Tg per yr)
 vm_emission_costs(i)                                    Costs for emission rights for pollutants and greenhouse gases (mio. USD05MER per yr)
 vm_emissions_reg(i,emis_source,pollutants)              Regional emissions by source and gas after technical mitigation N CH4 C (Tg per yr)
 v56_emis_cell(j,emis_source,pollutants)                 Cellular emissions by source and gas after technical mitigation N CH4 C (Tg per yr)
 v56_emission_costs_reg_yearly(i,emis_reg_yr56)          Costs for emissions occuring yearly (mio. USD05MER per yr)
 v56_emission_costs_reg_oneoff(i,emis_reg_one56)         Costs for emissions occuring only once in time (mio. USD05MER per yr)
 v56_emission_costs_cell_yearly(j,emis_cell_yr56)        Costs for emissions occuring yearly (mio. USD05MER per yr)
 v56_emission_costs_cell_oneoff(j,emis_cell_one56)       Costs for emissions occuring only once in time (mio. USD05MER per yr)
 vm_reward_cdr_aff(i)                                    Regional average annual expected revenue from afforestation (mio. USD05MER per yr)
 v56_reward_cdr_aff(j)				                           Cellular average annual expected revenue from afforestation (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_peatland_emis_cost(t,i,type)                                 Regional peatland GHG emissions costs (mio. USD05MER per yr)
 ov56_peatland_emis_cost(t,j,type)                               Cellular peatland GHG emissions costs (mio. USD05MER per yr)
 ov_btm_reg(t,i,emis_source,pollutants,type)                     Regional emissions before technical mitigation (Tg per yr)
 ov_btm_cell(t,j,emis_source,pollutants,type)                    Cellular emissions before technical mitigation (Tg per yr)
 ov_emission_costs(t,i,type)                                     Costs for emission rights for pollutants and greenhouse gases (mio. USD05MER per yr)
 ov_emissions_reg(t,i,emis_source,pollutants,type)               Regional emissions by source and gas after technical mitigation N CH4 C (Tg per yr)
 ov56_emis_cell(t,j,emis_source,pollutants,type)                 Cellular emissions by source and gas after technical mitigation N CH4 C (Tg per yr)
 ov56_emission_costs_reg_yearly(t,i,emis_reg_yr56,type)          Costs for emissions occuring yearly (mio. USD05MER per yr)
 ov56_emission_costs_reg_oneoff(t,i,emis_reg_one56,type)         Costs for emissions occuring only once in time (mio. USD05MER per yr)
 ov56_emission_costs_cell_yearly(t,j,emis_cell_yr56,type)        Costs for emissions occuring yearly (mio. USD05MER per yr)
 ov56_emission_costs_cell_oneoff(t,j,emis_cell_one56,type)       Costs for emissions occuring only once in time (mio. USD05MER per yr)
 ov_reward_cdr_aff(t,i,type)                                     Regional average annual expected revenue from afforestation (mio. USD05MER per yr)
 ov56_reward_cdr_aff(t,j,type)                                   Cellular average annual expected revenue from afforestation (mio. USD05MER per yr)
 oq56_technical_mitigation_reg(t,i,pollutants,emis_source,type)  Application of maccs on emissions (Tg per yr)
 oq56_technical_mitigation_cell(t,j,pollutants,emis_source,type) Application of maccs on emissions (Tg per yr)
 oq56_cell_to_reg(t,i,pollutants,emis_source,type)               Aggregation to regional emissions (Tg per yr)
 oq56_emission_costs(t,i,type)                                   Calculation of total emission costs (mio. USD05MER per yr)
 oq56_emission_costs_reg_yearly(t,i,emis_reg_yr56,type)          Calculation of regional costs for annual emissions (mio. USD05MER per yr)
 oq56_emission_costs_reg_oneoff(t,i,emis_reg_one56,type)         Calculation of regional costs for emissions occuring only once in time (mio. USD05MER per yr)
 oq56_emission_costs_cell_yearly(t,j,emis_cell_yr56,type)        Calculation of cellular costs for annual emissions (mio. USD05MER per yr)
 oq56_emission_costs_cell_oneoff(t,j,emis_cell_one56,type)       Calculation of cellular costs for emissions occuring only once in time (mio. USD05MER per yr)
 oq56_reward_cdr_aff_reg(t,i,type)                               Regional revenues for carbon captured by afforestation (mio. USD05MER per yr)
 oq56_reward_cdr_aff(t,j,type)                                   Cellular revenues for carbon captured by afforestation (mio. USD05MER per yr)
 oq56_peatland_emis_cost_reg(t,i,type)                           Regional peatland GHG emissions costs (mio. USD05MER per yr)
 oq56_peatland_emis_cost(t,j,type)                               Cellular peatland GHG emissions costs (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/56_ghg_policy/price_jan20/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/56_ghg_policy/price_jan20/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/56_ghg_policy/price_jan20/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/56_ghg_policy/price_jan20/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/56_ghg_policy/price_jan20/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/57_maccs/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Marginal Abatement Cost Curves
*'
*' @description This module describes technical mitigation of GHG emissions.
*' It allows to reduce GHG emissions by undertaking mitigation
*' measures in exchange for additional mitigation costs.
*' The technical mitigation measures include, for example, better spreader maintenance,
*' feed additives or investments in animal waste management facilities.
*' Please note that technical mitigation is possible only in the "on" module realization below.
*' For simplicity, we considered only the effects of mitigation measure costs and emissions.
*' Their direct consequences on biophysical values like yields or water requirements is ignored at the moment.
*'
*' Mitigation costs are estimated using marginal abatement cost curves (MACCs).
*' The curves are applied on the original emissions before technical mitigation (btm),
*' and reduce them by a certain percentage in exchange for additional costs.
*' The MACCs used in this module are based on the data from @LUCAS200785.  
*'
*' @authors Benjamin Leon Bodirsky, Florian Humpenoeder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%maccs%" == "off_jul16" $include "./modules/57_maccs/off_jul16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%maccs%" == "on_sep16" $include "./modules/57_maccs/on_sep16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description Unlike the previous realization, this implementation allows for the possibility
*' that non-CO2 emissions can be reduced by technical mitigation at additional costs.
*' The following MACC data sets are available in this module:
*' @LUCAS200785 (PBL_2007) and @Harmsen2019 (PBL_2019).
*'
*' @limitations The data set PBL_2007 is outdated and only kept for backward compatibility

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/57_maccs/on_sep16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/57_maccs/on_sep16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

scalars
 s57_step_length										Step length in MACC data (yr)
;

parameters
 im_maccs_mitigation(t,i,emis_source,pollutants)        Technical mitigation of GHG emissions (percent)
 i57_mac_step_n2o(t,i)                                  Helper to map N2O prices and maccs_steps (1)
 i57_mac_step_ch4(t,i)                                  Helper to map CH4 prices and maccs_steps (1)
 p57_maccs_costs_integral(t,i,emis_source,pollutants)   Costs of technical mitigation (USD95MER per Tg N CH4 C)
;

equations
 q57_total_costs(i)  Calculation of total costs of technical mitigation (mio. USD95MER per yr)
;

positive variables
 vm_maccs_costs(i)   Costs of technical mitigation of GHG emissions (mio. USD95MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_maccs_costs(t,i,type)   Costs of technical mitigation of GHG emissions (mio. USD95MER per yr)
 oq57_total_costs(t,i,type) Calculation of total costs of technical mitigation (mio. USD95MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/57_maccs/on_sep16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/57_maccs/on_sep16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/57_maccs/on_sep16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/57_maccs/on_sep16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/58_peatland/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Peatland
*'
*' @description The peatland module calculates GHG emissions from degrading/drained peatlands.
*'
*' @authors Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%peatland%" == "off" $include "./modules/58_peatland/off/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In this realization GHG emissions from degrading peatlands are assumed zero.

*' @limitations GHG emissions from degrading peatlands are assumed zero

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/58_peatland/off/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

positive variables
 vm_peatland_emis(j) 							GHG emissions from managed peatland (t CO2eq per year)
 vm_peatland_cost(j)							One-time and recurring cost of managed peatland (mio. USD05MER per yr)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_peatland_emis(t,j,type) GHG emissions from managed peatland (t CO2eq per year)
 ov_peatland_cost(t,j,type) One-time and recurring cost of managed peatland (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################

*$Ifi "%phase%" == "preloop" $include "./modules/58_peatland/off/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/58_peatland/off/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%peatland%" == "on" $include "./modules/58_peatland/on/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/59_som/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Soil organic matter

*' @description
*' The soil organic matter module calculates the soil organic carbon loss due to landuse activities.
*' It also estimates the nitrogen release due to the soil organic carbon turnover.  

*' @authors Benjamin Leon Bodirsky, Kristine Karstens




*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%som%" == "cellpool_aug16" $include "./modules/59_som/cellpool_aug16/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%som%" == "static_jan19" $include "./modules/59_som/static_jan19/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The static_jan19 realization is built on the IPCC 2006 Guidelines for
*' National Greenhouse Gas Inventories (@ipcc_2006_2006.). It calculates the loss of
*' soil carbon due to cropping activities based on stock change factors, compared to
*' potential natural vegetation.
*' This approach does not account for the temporal dimension of soil organic carbon change,
*' since it assumes a complete loss of carbon directly after land conversion to cropland.
*' Therefore, no release of nitrogen due to soil organic matter loss is calculated.
*' Moreover only one stock change factor for all crop types is used, neglecting
*' e.g. differences for annual and perennial crops.

*' @limitations The soil carbon dynamics are instantaneous and do not account
*' for any time dependent release of soil carbon.
*' The soil carbon pools on cropland are not crop type specific.
*' The release of nitrogen due to soil organic matter loss is not calculated.
*' It is assumed that pastures and rangelands as well as managed forests
*' do not change in soil carbon compared to the natural reference state.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/59_som/static_jan19/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/59_som/static_jan19/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
        i59_topsoilc_density(t_all,j)      Topsoil carbon density of a hectare of cropland (tC per ha)
        i59_subsoilc_density(t_all,j)      Subsoil carbon density of a hectare of land (tC per ha)
;

variables
        vm_nr_som(j)                        Release of soil organic matter (Mt N per yr)
        vm_nr_som_fertilizer(j)             Uptake of soil organic matter from plants (Mt N per yr)
;

equations
         q59_soilcarbon_cropland(j)                        Cropland soil carbon content calculation (mio. tC)
         q59_soilcarbon_noncropland(j,noncropland59)       Non-cropland soil carbon content calculation (mio. tC)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_nr_som(t,j,type)                                 Release of soil organic matter (Mt N per yr)
 ov_nr_som_fertilizer(t,j,type)                      Uptake of soil organic matter from plants (Mt N per yr)
 oq59_soilcarbon_cropland(t,j,type)                  Cropland soil carbon content calculation (mio. tC)
 oq59_soilcarbon_noncropland(t,j,noncropland59,type) Non-cropland soil carbon content calculation (mio. tC)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/59_som/static_jan19/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/59_som/static_jan19/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/59_som/static_jan19/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/59_som/static_jan19/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/59_som/static_jan19/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/60_bioenergy/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Bioenergy
*'
*' @description The bioenergy module provides a regional and crop-specific
*' bioenergy demand $vm\_dem\_bioen$ to the model (to the [16_demand] module).
*' For this calculation it requires
*' information on gross energy content (provided by [16_demand] module).
*' 
*' In addition to calculation of bioenergy quantities, the costs associated with 
*' the production are provided to the objective function in the [11_costs] module.
*'
*' @authors Jan Philipp Dietrich


*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%bioenergy%" == "1stgen_priced_dec18" $include "./modules/60_bioenergy/1stgen_priced_dec18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/60_bioenergy/1stgen_priced_dec18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/60_bioenergy/1stgen_priced_dec18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


parameters
 i60_bioenergy_dem(t,i)                           Regional bioenergy demand per year (mio. GJ per yr)
 i60_res_2ndgenBE_dem(t,i)                        Regional residue demand for 2nd generation bioenergy per year (mio. GJ per yr)
 i60_1stgen_bioenergy_dem(t,i,kall)               Regional 1st generation bioenergy demand (mio. GJ per yr)
 p60_region_BE_shr(t_all,i)	                      Bioenergy demand share of the region (1)
 p60_country_dummy(iso)		                        Dummy parameter indicating whether country is selected for selected bioenergy demand scenario (1)
;

positive variables
 vm_dem_bioen(i,kall)                       Regional bioenergy demand  (mio. tDM per yr)
 v60_2ndgen_bioenergy_dem_dedicated(i,kall) Bioenergy demand which can come from different regions (mio. GJ per yr)
 v60_2ndgen_bioenergy_dem_residues(i,kall)  Bioenergy demand which can come from different product types (mio. GJ per yr)
;

variables
  vm_bioenergy_utility(i)                   Utility as negative costs for producing bioenergy (USD05MER per yr)
;

equations
 q60_bioenergy(i,kall)                     Global total bioenergy demand (mio. GJ per yr)
 q60_bioenergy_glo                         Global 2nd generation dedicated bioenergy demand (mio. GJ per yr)
 q60_bioenergy_reg(i)                      Regional 2nd generation dedicated bioenergy demand (mio. GJ per yr)
 q60_res_2ndgenBE(i)                       Regional residue demand for 2nd generation bioenergy (mio. GJ per yr)
 q60_bioenergy_incentive(i)                Incentive to produce bioenergy (mio. USD05MER per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_dem_bioen(t,i,kall,type)                        Regional bioenergy demand  (mio. tDM per yr)
 ov60_2ndgen_bioenergy_dem_dedicated(t,i,kall,type) Bioenergy demand which can come from different regions (mio. GJ per yr)
 ov60_2ndgen_bioenergy_dem_residues(t,i,kall,type)  Bioenergy demand which can come from different product types (mio. GJ per yr)
 ov_bioenergy_utility(t,i,type)                     Utility as negative costs for producing bioenergy (USD05MER per yr)
 oq60_bioenergy(t,i,kall,type)                      Global total bioenergy demand (mio. GJ per yr)
 oq60_bioenergy_glo(t,type)                         Global 2nd generation dedicated bioenergy demand (mio. GJ per yr)
 oq60_bioenergy_reg(t,i,type)                       Regional 2nd generation dedicated bioenergy demand (mio. GJ per yr)
 oq60_res_2ndgenBE(t,i,type)                        Regional residue demand for 2nd generation bioenergy (mio. GJ per yr)
 oq60_bioenergy_incentive(t,i,type)                 Incentive to produce bioenergy (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/60_bioenergy/1stgen_priced_dec18/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/60_bioenergy/1stgen_priced_dec18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/60_bioenergy/1stgen_priced_dec18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/60_bioenergy/1stgen_priced_dec18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/60_bioenergy/1stgen_priced_dec18/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/60_bioenergy/1stgen_priced_dec18/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/62_material/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Material
*'
*' @description
*' The material module describes the demand for material usage
*' based on historical data. Material uage is derived from FAO's "other utils"
*' category, and includes for example the use of agricultural products
*' for cosmetics, chemical usage or textiles. In contrast to FAO's other util
*' category, the use for bioenergy (oils and ethanol) has been excluded
*' and is accounted for in the demand for bioenergy. Material demand in this
*' context can be considered as a subset of "other utils" category of FAO.

*' @authors Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%material%" == "exo_flexreg_apr16" $include "./modules/62_material/exo_flexreg_apr16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In the exo_flexreg_apr16 realisation, demand for material usage
*' is estimated to grow proportional to food demand calculated by `vm_dem_food` interface
*' in food module([15_food]). Observed material demand is fed as an input to the
*' material module based on historical data. The assumption that material demand
*' grows proportional to food demand is a simplification that can be justified
*' by the minor importance of non-bioenergy material usage of agricultural products.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/62_material/exo_flexreg_apr16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/62_material/exo_flexreg_apr16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


scalar
  s62_historical                 Switch for turning off historical material demand (1) / 1 /
;

parameters
  p62_dem_material_lh(i,kall)    Material demand in last historical timestep (mio. tDM per yr)
  p62_dem_food_lh(i)             Food demand in last historical timestep (mio. tDM per yr)
;

positive variables
  vm_dem_material(i,kall)        Demand for material usage (mio. tDM per yr)
;

equations
  q62_dem_material(i,kall)       Estimating material demand (mio. tDM per yr)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_dem_material(t,i,kall,type)   Demand for material usage (mio. tDM per yr)
 oq62_dem_material(t,i,kall,type) Estimating material demand (mio. tDM per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/62_material/exo_flexreg_apr16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/62_material/exo_flexreg_apr16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/62_material/exo_flexreg_apr16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/62_material/exo_flexreg_apr16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/62_material/exo_flexreg_apr16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################

*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/70_livestock/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Livestock
*'
*' @description The livestock module calculates how much and what kind of
*' biomass is required as feed to produce livestock food commodities.
*'
*' For this purpose, the livestock module provides for every time-step regional
*' and product-specific feed baskets that determine type and magnitude of feed
*' needed to produce one unit of livestock commodities. Estimated pasture
*' feed demand is also relevant for the module [31_past] in order to derive
*' required pasture areas. The information flow between the livestock and the
*' pasture module is organized via interfaces `vm_dem_feed`, `vm_supply` and
*' `vm_prod_reg` via modules [16_demand] and [21_trade]. Feed demand estimates
*' are also required for the modules [53_methane] and [55_awms]. Additionally,
*' the livestock module provides production costs for livestock commodities.
*'
*' @authors Isabelle Weindl, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%livestock%" == "fbask_jan16" $include "./modules/70_livestock/fbask_jan16/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The fbask_jan16 realization of the livestock module is based on
*' the methodology as described in @weindl_livestock_2017 and
*' @weindl_livestock_2017-1. An important part of the feed demand calculations
*' is conducted outside of the core MAgPIE-GAMS code. Livestock products
*' (ruminant meat, whole-milk, pork, poultry meat and eggs) are supplied by five
*' animal food systems (beef cattle, dairy cattle, pigs, broilers and laying
*' hens). The parameterization of the livestock sector in the initial year is
*' consistent with FAO statistics regarding livestock production, livestock
*' productivity and concentrate feed use.

*' The fbask_jan16 realization requires regional and product-specific feed
*' baskets that are calculated by a set of preprocessing routines outside of the
*' MAgPIE-GAMS code. Following the methodology of @wirsenius_human_2000, feed
*' conversion (total feed input per product output in dry matter) and feed
*' baskets (demand for different feed types per product output in dry matter)
*' are derived by compiling system-specific feed energy balances. For the
*' establishment of these balances, we apply feed energy requirements per output,
*' as estimated by wirsenius_human_2000 for each animal function and animal food
*' system. These estimates are based on standardized bio-energetic equations and
*' include the minimum energy requirements for maintenance, growth, lactation,
*' reproduction and other basic biological functions of the animals. Moreover,
*' they comprise a general allowance for basic activity and temperature effects.

*' By distributing the available feed at country level to animal food systems
*' according to their feed energy demand and dividing resulting dry matter feed
*' use by the production volume of the respective systems, we obtain both
*' estimates for feed conversion and feed baskets across different animal food
*' systems and countries.

*' To facilitate projections of feed conversion and feed baskets, we create
*' regression models with livestock productivity (annual production per animal
*' [ton fresh matter/animal/year]) as predictor, which permit the construction
*' of livestock feeding scenarios. Currently, feeding scenarios are derived
*' based on exogenous livestock productivity scenarios consistent with the
*' storylines of the Shared Socioeconomic Pathways (SSPs). For beef cattle, pigs
*' and broilers, livestock productivity is defined as meat production per
*' animals in stock (e.g. total cattle herd) and for dairy cattle and laying hen
*' as milk or egg production per producing animals (e.g. milk cows).

*' A power function is used to describe the functional relation between feed
*' conversion and livestock productivity:

*' ![Relationship between feed conversion and livestock productivity
*' [@weindl_livestock_2017].](feed_conv.jpg){ width=100% }

*' In the case of feed composition, we use an additional proxy parameter in our
*' analysis. What type of biomass is used to feed animals is to a certain extent
*' influenced by universal aspects (e.g. the need for more energy-rich feed at
*' higher productivity levels), whereas other aspects are strongly influenced by
*' geographical location (e.g. availability and costs of permanent pasture
*' compared to cropland feed, agro-ecological and climatic conditions that
*' favour selected feed items; socio-cultural determinants etc.). For cattle
*' systems the proxy (climate-zone specific factor) was determined by
*' calculating the share of the national population living in arid and cold
*' climate zones.

*' ![Relationship between the share of crop residues, occasional feed and grazed
*' biomass in feed baskets and livestock productivity for beef cattle systems
*' [@weindl_livestock_2017].](feed_comp_beef.jpg){ width=60% }

*' ![Relationship between the share of crop residues, occasional feed and grazed
*' biomass in feed baskets and livestock productivity for diary cattle systems
*' [@weindl_livestock_2017].](feed_comp_dairy.jpg){ width=60% }

*' These relationships between feed baskets and livestock productivity are used 
*' to construct feeding scenarios that reflect the narratives of the SSPs. The 
*' resulting feed baskets enter the MAgPIE model as scenario-dependent input data
*' and are crucial for the feed demand calculations in the livestock module.

*' @limitations Intensification of livestock production and related changes in
*' livestock feeding are modelled exogenously. Therefore, the livestock sector
*' does not endogenously respond to demand and climate shocks and policies, e.g.
*' targeting climate protection.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/70_livestock/fbask_jan16/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/70_livestock/fbask_jan16/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


positive variables
 vm_dem_feed(i,kap,kall)          Regional feed demand including byproducts (mio. tDM per yr)
;

equations
 q70_feed(i,kap,kall)             Regional feed demand
 q70_cost_prod_liv(i,kall)        Regional factor input costs for livestock production
 q70_cost_prod_fish(i)            Regional factor input costs for fish production
;

parameters
 im_slaughter_feed_share(t_all,i,kap,attributes)  Share of feed that is incorporated in animal biomass (1)
 i70_livestock_productivity(t_all,i,sys)          Productivity indicator for livestock production (t FM per animal per yr)
 im_feed_baskets(t_all,i,kap,kall)                Feed baskets in tDM per tDM livestock product (1)
 p70_cattle_stock_proxy(t,i)                      Proxy for cattle stocks needed to fullfil domestic food demand (mio. animals per yr)
 p70_incr_cattle(t,i)                             Change in estimated cattle stocks attributed to food demand projections (1)
 pm_past_mngmnt_factor(t,i)                       Regional pasture management intensification factor (1)
 i70_cereal_scp_fadeout(t_all,i)                  Cereal feed fadeout (share 0-1) to be replaced by SCP (1)
 i70_foddr_scp_fadeout(t_all,i)                	  Fooder fadeout (share 0-1) to be replaced by SCP (1)
 p70_country_dummy(iso)                           Dummy parameter indicating whether country is affected by feed scenarios (1)
 p70_feedscen_region_shr(t_all,i)                 Weighted share of region with regards to feed scenario of countries (1)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_dem_feed(t,i,kap,kall,type)    Regional feed demand including byproducts (mio. tDM per yr)
 oq70_feed(t,i,kap,kall,type)      Regional feed demand
 oq70_cost_prod_liv(t,i,kall,type) Regional factor input costs for livestock production
 oq70_cost_prod_fish(t,i,type)     Regional factor input costs for fish production
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/70_livestock/fbask_jan16/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/70_livestock/fbask_jan16/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/70_livestock/fbask_jan16/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/70_livestock/fbask_jan16/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/70_livestock/fbask_jan16/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/71_disagg_lvst/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Disaggregation of livestock distribution
*'
*' @description The module 71_disagg_lvst calculates the livestock distribution within a region onto
*' cellular level. Without constrains in this module cellular livestock production is determined by
*' the modules 40_transport accounting for transport costs and module 42_water_demand connecting
*' livestock production to water demand and thus to water availability.
*'
*' @authors Kristine Karstens, Benjamin Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%disagg_lvst%" == "foragebased_aug18" $include "./modules/71_disagg_lvst/foragebased_aug18/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description The foragebased_aug18 realization constrains the cellular ruminant livestock production by 
*' the feed availability for grazed pasture and fodder crops. This accounts for the fact that pasture and fodder 
*' (summarized with forage) feed stuff is usually not transported over long distances and at the same time 
*' is very essential in livestock diets. The monogastric livestock is distributed following the idea 
*' that these animals are held close to densely populated areas. For more detailed information on cellular livestock 
*' distribution see @robinson_mapping_2014, which inspired this realization.

*' @limitations Distribution of monogastrics do not account for feed availability within a cell. Crop residue feed stuff
*' for ruminant production is also not considered to restrict livestock production.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/71_disagg_lvst/foragebased_aug18/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/71_disagg_lvst/foragebased_aug18/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

positive variables
 v71_prod_rum(j,kli_rum,kforage)                   Production of forage fed ruminants within a cell (mio. tDM per yr)
 v71_additional_mon(j, kli_mon)                   Additional punished production of monogastric livestock (mio. tDM per yr)
 vm_costs_additional_mon(i)                       Punishment cost for additionally transported monogastric livst_egg (mio. USD05MER per yr)
;

variables
 v71_feed_balanceflow(j,kli_rum,kforage)           Cellular feed balanceflow for forage feed for ruminant livestock (mio. tDM per yr)
;

equations
 q71_feed_rum_liv(j,kforage)                       Production constraint for ruminant livestock products (mio. tDM per yr)
 q71_balanceflow_constraint_nlp(j,kli_rum,kforage) Nonlinear balanceflow constraint for cellular forage feed products (mio. tDM per yr)
 q71_balanceflow_constraint_lp(i,kli_rum,kforage)  Linear balanceflow constraint for cellular forage feed product (mio. tDM per yr)
 q71_sum_rum_liv(j,kli_rum)                        Total production of forage fed ruminants (mio. tDM per yr)
 q71_prod_mon_liv(j,kli_mon)                       Production constraint for monogastric livestock products (mio. tDM per yr)
 q71_punishment_mon(i)                            Punishment for additional monogastrics (mio. USD05MER per yr)
;

parameters
 i71_urban_area_share(j)                           Share of urban area within a region (1)
;

scalars
 s71_lp_fix                                        Switch to fix equations to linear relation (Logical)
 s71_scale_mon                                     Scalar for flexible distribution of monogastrics (1)
 s71_punish_additional_mon                         Scaling factor for transport punishment (USD05MER per tDM)
;

*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov71_prod_rum(t,j,kli_rum,kforage,type)                   Production of forage fed ruminants within a cell (mio. tDM per yr)
 ov71_additional_mon(t,j,kli_mon,type)                     Additional punished production of monogastric livestock (mio. tDM per yr)
 ov_costs_additional_mon(t,i,type)                         Punishment cost for additionally transported monogastric livst_egg (mio. USD05MER per yr)
 ov71_feed_balanceflow(t,j,kli_rum,kforage,type)           Cellular feed balanceflow for forage feed for ruminant livestock (mio. tDM per yr)
 oq71_feed_rum_liv(t,j,kforage,type)                       Production constraint for ruminant livestock products (mio. tDM per yr)
 oq71_balanceflow_constraint_nlp(t,j,kli_rum,kforage,type) Nonlinear balanceflow constraint for cellular forage feed products (mio. tDM per yr)
 oq71_balanceflow_constraint_lp(t,i,kli_rum,kforage,type)  Linear balanceflow constraint for cellular forage feed product (mio. tDM per yr)
 oq71_sum_rum_liv(t,j,kli_rum,type)                        Total production of forage fed ruminants (mio. tDM per yr)
 oq71_prod_mon_liv(t,j,kli_mon,type)                       Production constraint for monogastric livestock products (mio. tDM per yr)
 oq71_punishment_mon(t,i,type)                             Punishment for additional monogastrics (mio. USD05MER per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "equations" $include "./modules/71_disagg_lvst/foragebased_aug18/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/71_disagg_lvst/foragebased_aug18/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/71_disagg_lvst/foragebased_aug18/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/71_disagg_lvst/foragebased_aug18/postsolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_fix" $include "./modules/71_disagg_lvst/foragebased_aug18/nl_fix.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "nl_release" $include "./modules/71_disagg_lvst/foragebased_aug18/nl_release.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%disagg_lvst%" == "off" $include "./modules/71_disagg_lvst/off/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/73_timber/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Timber
*'
*' @description This module handles the production of timber using plantations [32_forestry]
*' and natural vegetation [35_natveg]. Timber can be produced from both commercial plantations
*' and natural forests. The module feeds `vm_prod` at cluster level to [17_production] and
*' [21_trade] modules. This module also calculates the "real" harvested area in natural
*' forests i.e. `v35_hvarea_primforest`,`v35_hvarea_secdforest` and `v73_hvarea_other`.
*'
*' @authors Abhijeet Mishra, Florian Humpenöder

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%timber%" == "default" $include "./modules/73_timber/default/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description biomass_mar20 realization acts as a common tunnel for land related
*' decisions in forestry [32_forestry] and natveg [35_natveg] modules and corresponding
*' production of woody biomass realized. This realization harvests timber from
*' available plantations to meet a portion of overall timber demand. Rest of the timber
*' production comes by harvesting natural vegetation. Aggregated timber demand for
*' wood and woodfuel is calculated based on demand equation from @lauri_timber_demand
*' and income elasticities from @morland2018supply. The timber demand calculated is further
*' adjusted between the solve steps where if the model sees no way of producing timber
*' from existing resources, the demand is lowered down to an extent that an adjusted level
*' of demand can be met with resources at hand.

*' @limitations Timber demand cannot be determined endogenously

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/73_timber/default/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/73_timber/default/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
p73_timber_demand_gdp_pop(t_all,i,kforestry)                                Timber demand based on lauri et al 2019 (mio. m3 per yr)
p73_forestry_demand_prod_specific(t_all,iso,total_wood_products)            End product specific timber demand (mio. m3 per yr)
pm_demand_forestry_future(i,kforestry)                                      Future forestry demand in current time step (tDM per yr)
pm_demand_ext(t_ext,i,kforestry)                                            Extended demand for timber beyound simulation (mio. tDM per yr)
p73_demand_calib(t_all,i,kforestry)                                         Additive calibration factor for timber demand
;

positive variables
vm_cost_timber(i)				                                                    Actual cost of harvesting timber from forests (mio. USD per yr)
v73_prod_heaven_timber(j,kforestry)                                         Production of woody biomass from heaven (mio. tDM per yr)
v73_prod_residues(j)                                                        Production of residues from industrial roundwood harvest(mio. tDM per yr)
;

equations
q73_cost_timber(i)												                                  Actual cost of harvesting timber from forests (mio. USD per yr)
q73_prod_wood(j)                                                            Production of industrial roundwood (mio. tDM per yr)
q73_prod_woodfuel(j)                                                        Production of wood fuel (mio. tDM per yr)
q73_prod_residues(j)                                                        Production of residues from industrial roundwood harvest(mio. tDM per yr)
;


*#################### R SECTION START (OUTPUT DECLARATIONS) ####################
parameters
 ov_cost_timber(t,i,type)                    Actual cost of harvesting timber from forests (mio. USD per yr)
 ov73_prod_heaven_timber(t,j,kforestry,type) Production of woody biomass from heaven (mio. tDM per yr)
 ov73_prod_residues(t,j,type)                Production of residues from industrial roundwood harvest(mio. tDM per yr)
 oq73_cost_timber(t,i,type)                  Actual cost of harvesting timber from forests (mio. USD per yr)
 oq73_prod_wood(t,j,type)                    Production of industrial roundwood (mio. tDM per yr)
 oq73_prod_woodfuel(t,j,type)                Production of wood fuel (mio. tDM per yr)
 oq73_prod_residues(t,j,type)                Production of residues from industrial roundwood harvest(mio. tDM per yr)
;
*##################### R SECTION END (OUTPUT DECLARATIONS) #####################
*$Ifi "%phase%" == "input" $include "./modules/73_timber/default/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "equations" $include "./modules/73_timber/default/equations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "scaling" $include "./modules/73_timber/default/scaling.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "preloop" $include "./modules/73_timber/default/preloop.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "presolve" $include "./modules/73_timber/default/presolve.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "postsolve" $include "./modules/73_timber/default/postsolve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*###################### R SECTION END (MODULETYPES) ############################
*$include "./modules/80_optimization/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Optimization
*'
*' @description This module takes care of the model optimization of
*' the main model, allowing for switching between optimization procedures.
*' It has been introduced to play with different ways to affect the runtime
*' performance of the model via more optimized model solution strategies.
*' The interfaces to the rest of the model are quite limited as it only requires
*' the variables to be optimized `vm_cost_glo` (total costs) and `vm_landdiff`
*' (gross land use changes compared to last time step) as direct input.
*' The latter was introduced to select out of a range of cost optimal patterns
*' that one which is closest to the pattern of the previous time step. While
*' CONOPT returns this solution by default, CPLEX does not.
*'
*' @authors Jan Philipp Dietrich, Todd Munson

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%optimization%" == "lp_nlp_apr17" $include "./modules/80_optimization/lp_nlp_apr17/realization.gms" CONDITION WAS NEGATIVE!
*$Ifi "%optimization%" == "nlp_apr17" $include "./modules/80_optimization/nlp_apr17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description
*' In this realization the model is solved directly using nonlinear optimization.
*' If the optimization returns an infeasible solution the solve is repeated,
*' either until a feasible solution is found or the maximum number of iterations
*' as defined in `s80_maxiter` is reached.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "declarations" $include "./modules/80_optimization/nlp_apr17/declarations.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

parameters
	p80_modelstat(t)	modelstat indicator (1)
	p80_num_nonopt(t)		numNOpt indicator (1)
;

scalars
  s80_counter       counter (1)
;
*$Ifi "%phase%" == "input" $include "./modules/80_optimization/nlp_apr17/input.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "solve" $include "./modules/80_optimization/nlp_apr17/solve.gms" CONDITION WAS NEGATIVE!
*######################## R SECTION END (PHASES) ###############################
*$Ifi "%optimization%" == "nlp_par" $include "./modules/80_optimization/nlp_par/realization.gms" CONDITION WAS NEGATIVE!
*###################### R SECTION END (MODULETYPES) ############################
*######################## R SECTION END (MODULES) ##############################
$offrecurse
*** EOF include.gms ***
********************************************************************************

*****************************IMPORT DATA FILES**********************************
*$batinclude "./modules/include.gms" input DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de


$setglobal phase %1
$onrecurse
*######################## R SECTION START (MODULES) ############################
*$include "./modules/09_drivers/module.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @title Drivers
*'
*' @description The Drivers module provides data on drivers
*' that are used by several other modules. It mainly aggregates inputs related 
*' to population and GDP. If an input is required in one module or realization only, 
*' the input driver is provided directly by the module that demands it, 
*' rather than by the [09_drivers] module. 
*'
*' @authors Benjamin Leon Bodirsky

*###################### R SECTION START (MODULETYPES) ##########################
*$Ifi "%drivers%" == "aug17" $include "./modules/09_drivers/aug17/realization.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

*' @description In the aug17 realization, inputs are taken into the module and are directly 
*' delivered to the modules that require the data.

*####################### R SECTION START (PHASES) ##############################
*$Ifi "%phase%" == "sets" $include "./modules/09_drivers/aug17/sets.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "declarations" $include "./modules/09_drivers/aug17/declarations.gms" CONDITION WAS NEGATIVE!
*$Ifi "%phase%" == "input" $include "./modules/09_drivers/aug17/input.gms" DONE!
*** |  (C) 2008-2021 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of MAgPIE and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  MAgPIE License Exception, version 1.0 (see LICENSE file).
*** |  Contact: magpie@pik-potsdam.de

$setglobal c09_pop_scenario  SSP2
*   options:   SSP: "SSP1", "SSP2", "SP3", "SSP4", "SSP5"
*              SDP: "SDP"
*             SRES: "a1", "a2", "b1", "b2"

$setglobal c09_gdp_scenario  SSP2
*   options:   SSP: "SSP1", "SSP2", "SSP3", "SSP4", "SSP5"
*              SDP: "SDP"
*             SRES: "a1", "a2", "b1", "b2"


table f09_gdp_ppp_iso(t_all,iso,gdp_scen09) Income in purchasing power parity (mio. USD05PPP per yr)
$ondelim
*$include "./modules/09_drivers/input/f09_gdp_ppp_iso.csv" DONE!
* description: collects all data necessary to create demand projections and brings them into a joint format
* unit: Mio USD 05
* comment:  description: collects all data necessary to create demand projections and brings them into a joint format
*           unit: population: Mio people, gdp: Million USD, urban population: Mio people
*           origin: calcOutput(type = "CollectProjectionDrivers", aggregate = FALSE) (madrat 1.91.1 | mrcommons 0.22.0)
*           creation date: Tue Feb 16 12:00:35 2021
* origin: calcOutput(type = "CollectProjectionDrivers", aggregate = FALSE, file = "f09_gdp_ppp_iso.csv", years = mag_years, round = 3, driver = "gdp") (madrat 1.93.6 | mrcommons 0.22.0)
* creation date: Wed Mar  3 20:40:25 2021
dummy,dummy,SSP1,SSP2,SSP3,SSP4,SSP5,SDP,a1,a2,b1,b2
y1965,ABW,283.648,283.648,283.648,283.648,283.648,283.648,283.648,283.648,283.648,283.648
y1965,AFG,6894.418,6894.418,6894.418,6894.418,6894.418,6894.418,6894.418,6894.418,6894.418,6894.418
y1965,AGO,19619.329,19619.329,19619.329,19619.329,19619.329,19619.329,19619.329,19619.329,19619.329,19619.329
y1965,AIA,74.591,74.591,74.591,74.591,74.591,74.591,74.591,74.591,74.591,74.591
y1965,ALA,1171.348,1171.348,1171.348,1171.348,1171.348,1171.348,1171.348,1171.348,1171.348,1171.348
y1965,ALB,4788.845,4788.845,4788.845,4788.845,4788.845,4788.845,4788.845,4788.845,4788.845,4788.845
y1965,AND,814.527,814.527,814.527,814.527,814.527,814.527,814.527,814.527,814.527,814.527
y1965,ARE,11878.92,11878.92,11878.92,11878.92,11878.92,11878.92,11878.92,11878.92,11878.92,11878.92
y1965,ARG,161264.827,161264.827,161264.827,161264.827,161264.827,161264.827,161264.827,161264.827,161264.827,161264.827
y1965,ARM,3397.848,3397.848,3397.848,3397.848,3397.848,3397.848,3397.848,3397.848,3397.848,3397.848
y1965,ASM,305.734,305.734,305.734,305.734,305.734,305.734,305.734,305.734,305.734,305.734
y1965,ATA,10,10,10,10,10,10,10,10,10,10
y1965,ATF,1.427,1.427,1.427,1.427,1.427,1.427,1.427,1.427,1.427,1.427
y1965,ATG,224.298,224.298,224.298,224.298,224.298,224.298,224.298,224.298,224.298,224.298
y1965,AUS,170510.474,170510.474,170510.474,170510.474,170510.474,170510.474,170510.474,170510.474,170510.474,170510.474
y1965,AUT,92723.103,92723.103,92723.103,92723.103,92723.103,92723.103,92723.103,92723.103,92723.103,92723.103
y1965,AZE,10196.338,10196.338,10196.338,10196.338,10196.338,10196.338,10196.338,10196.338,10196.338,10196.338
y1965,BDI,902.282,902.282,902.282,902.282,902.282,902.282,902.282,902.282,902.282,902.282
y1965,BEL,120807.4,120807.4,120807.4,120807.4,120807.4,120807.4,120807.4,120807.4,120807.4,120807.4
y1965,BEN,2503.579,2503.579,2503.579,2503.579,2503.579,2503.579,2503.579,2503.579,2503.579,2503.579
y1965,BES,173.47,173.47,173.47,173.47,173.47,173.47,173.47,173.47,173.47,173.47
y1965,BFA,2762.503,2762.503,2762.503,2762.503,2762.503,2762.503,2762.503,2762.503,2762.503,2762.503
y1965,BGD,38882.361,38882.361,38882.361,38882.361,38882.361,38882.361,38882.361,38882.361,38882.361,38882.361
y1965,BGR,26367.868,26367.868,26367.868,26367.868,26367.868,26367.868,26367.868,26367.868,26367.868,26367.868
y1965,BHR,2916.061,2916.061,2916.061,2916.061,2916.061,2916.061,2916.061,2916.061,2916.061,2916.061
y1965,BHS,2631.951,2631.951,2631.951,2631.951,2631.951,2631.951,2631.951,2631.951,2631.951,2631.951
y1965,BIH,1357.449,1357.449,1357.449,1357.449,1357.449,1357.449,1357.449,1357.449,1357.449,1357.449
y1965,BLM,110.994,110.994,110.994,110.994,110.994,110.994,110.994,110.994,110.994,110.994
y1965,BLR,33147.82,33147.82,33147.82,33147.82,33147.82,33147.82,33147.82,33147.82,33147.82,33147.82
y1965,BLZ,273.245,273.245,273.245,273.245,273.245,273.245,273.245,273.245,273.245,273.245
y1965,BMU,1502.459,1502.459,1502.459,1502.459,1502.459,1502.459,1502.459,1502.459,1502.459,1502.459
y1965,BOL,11900.679,11900.679,11900.679,11900.679,11900.679,11900.679,11900.679,11900.679,11900.679,11900.679
y1965,BRA,300571.664,300571.664,300571.664,300571.664,300571.664,300571.664,300571.664,300571.664,300571.664,300571.664
y1965,BRB,2220.406,2220.406,2220.406,2220.406,2220.406,2220.406,2220.406,2220.406,2220.406,2220.406
y1965,BRN,5179.46,5179.46,5179.46,5179.46,5179.46,5179.46,5179.46,5179.46,5179.46,5179.46
y1965,BTN,161.431,161.431,161.431,161.431,161.431,161.431,161.431,161.431,161.431,161.431
y1965,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1965,BWA,544.323,544.323,544.323,544.323,544.323,544.323,544.323,544.323,544.323,544.323
y1965,CAF,1624.395,1624.395,1624.395,1624.395,1624.395,1624.395,1624.395,1624.395,1624.395,1624.395
y1965,CAN,307388.464,307388.464,307388.464,307388.464,307388.464,307388.464,307388.464,307388.464,307388.464,307388.464
y1965,CCK,54.94,54.94,54.94,54.94,54.94,54.94,54.94,54.94,54.94,54.94
y1965,CHE,128650.702,128650.702,128650.702,128650.702,128650.702,128650.702,128650.702,128650.702,128650.702,128650.702
y1965,CHL,36644.697,36644.697,36644.697,36644.697,36644.697,36644.697,36644.697,36644.697,36644.697,36644.697
y1965,CHN,236851.678,236851.678,236851.678,236851.678,236851.678,236851.678,236851.678,236851.678,236851.678,236851.678
y1965,CIV,7220.109,7220.109,7220.109,7220.109,7220.109,7220.109,7220.109,7220.109,7220.109,7220.109
y1965,CMR,8269.525,8269.525,8269.525,8269.525,8269.525,8269.525,8269.525,8269.525,8269.525,8269.525
y1965,COD,15037.101,15037.101,15037.101,15037.101,15037.101,15037.101,15037.101,15037.101,15037.101,15037.101
y1965,COG,1880.886,1880.886,1880.886,1880.886,1880.886,1880.886,1880.886,1880.886,1880.886,1880.886
y1965,COK,172.618,172.618,172.618,172.618,172.618,172.618,172.618,172.618,172.618,172.618
y1965,COL,60015.033,60015.033,60015.033,60015.033,60015.033,60015.033,60015.033,60015.033,60015.033,60015.033
y1965,COM,217.832,217.832,217.832,217.832,217.832,217.832,217.832,217.832,217.832,217.832
y1965,CPV,193.951,193.951,193.951,193.951,193.951,193.951,193.951,193.951,193.951,193.951
y1965,CRI,7356.399,7356.399,7356.399,7356.399,7356.399,7356.399,7356.399,7356.399,7356.399,7356.399
y1965,CUB,34264.569,34264.569,34264.569,34264.569,34264.569,34264.569,34264.569,34264.569,34264.569,34264.569
y1965,CUW,2008.14,2008.14,2008.14,2008.14,2008.14,2008.14,2008.14,2008.14,2008.14,2008.14
y1965,CXR,168.712,168.712,168.712,168.712,168.712,168.712,168.712,168.712,168.712,168.712
y1965,CYM,145.887,145.887,145.887,145.887,145.887,145.887,145.887,145.887,145.887,145.887
y1965,CYP,3087.178,3087.178,3087.178,3087.178,3087.178,3087.178,3087.178,3087.178,3087.178,3087.178
y1965,CZE,97478.577,97478.577,97478.577,97478.577,97478.577,97478.577,97478.577,97478.577,97478.577,97478.577
y1965,DEU,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224,1035843.224
y1965,DJI,460.642,460.642,460.642,460.642,460.642,460.642,460.642,460.642,460.642,460.642
y1965,DMA,129.762,129.762,129.762,129.762,129.762,129.762,129.762,129.762,129.762,129.762
y1965,DNK,72077.997,72077.997,72077.997,72077.997,72077.997,72077.997,72077.997,72077.997,72077.997,72077.997
y1965,DOM,8392.193,8392.193,8392.193,8392.193,8392.193,8392.193,8392.193,8392.193,8392.193,8392.193
y1965,DZA,46966.264,46966.264,46966.264,46966.264,46966.264,46966.264,46966.264,46966.264,46966.264,46966.264
y1965,ECU,16949.463,16949.463,16949.463,16949.463,16949.463,16949.463,16949.463,16949.463,16949.463,16949.463
y1965,EGY,47343.135,47343.135,47343.135,47343.135,47343.135,47343.135,47343.135,47343.135,47343.135,47343.135
y1965,ERI,647.045,647.045,647.045,647.045,647.045,647.045,647.045,647.045,647.045,647.045
y1965,ESH,127.423,127.423,127.423,127.423,127.423,127.423,127.423,127.423,127.423,127.423
y1965,ESP,297248.666,297248.666,297248.666,297248.666,297248.666,297248.666,297248.666,297248.666,297248.666,297248.666
y1965,EST,8080.823,8080.823,8080.823,8080.823,8080.823,8080.823,8080.823,8080.823,8080.823,8080.823
y1965,ETH,12617.811,12617.811,12617.811,12617.811,12617.811,12617.811,12617.811,12617.811,12617.811,12617.811
y1965,FIN,50540.274,50540.274,50540.274,50540.274,50540.274,50540.274,50540.274,50540.274,50540.274,50540.274
y1965,FJI,912.286,912.286,912.286,912.286,912.286,912.286,912.286,912.286,912.286,912.286
y1965,FLK,199.104,199.104,199.104,199.104,199.104,199.104,199.104,199.104,199.104,199.104
y1965,FRA,638389.897,638389.897,638389.897,638389.897,638389.897,638389.897,638389.897,638389.897,638389.897,638389.897
y1965,FRO,1454.52,1454.52,1454.52,1454.52,1454.52,1454.52,1454.52,1454.52,1454.52,1454.52
y1965,FSM,98.759,98.759,98.759,98.759,98.759,98.759,98.759,98.759,98.759,98.759
y1965,GAB,4611.299,4611.299,4611.299,4611.299,4611.299,4611.299,4611.299,4611.299,4611.299,4611.299
y1965,GBR,758456.929,758456.929,758456.929,758456.929,758456.929,758456.929,758456.929,758456.929,758456.929,758456.929
y1965,GEO,12297.749,12297.749,12297.749,12297.749,12297.749,12297.749,12297.749,12297.749,12297.749,12297.749
y1965,GGY,2887.028,2887.028,2887.028,2887.028,2887.028,2887.028,2887.028,2887.028,2887.028,2887.028
y1965,GHA,6343.41,6343.41,6343.41,6343.41,6343.41,6343.41,6343.41,6343.41,6343.41,6343.41
y1965,GIB,1434.895,1434.895,1434.895,1434.895,1434.895,1434.895,1434.895,1434.895,1434.895,1434.895
y1965,GIN,3072.381,3072.381,3072.381,3072.381,3072.381,3072.381,3072.381,3072.381,3072.381,3072.381
y1965,GLP,8181.734,8181.734,8181.734,8181.734,8181.734,8181.734,8181.734,8181.734,8181.734,8181.734
y1965,GMB,453.736,453.736,453.736,453.736,453.736,453.736,453.736,453.736,453.736,453.736
y1965,GNB,554.28,554.28,554.28,554.28,554.28,554.28,554.28,554.28,554.28,554.28
y1965,GNQ,284.55,284.55,284.55,284.55,284.55,284.55,284.55,284.55,284.55,284.55
y1965,GRC,79569.202,79569.202,79569.202,79569.202,79569.202,79569.202,79569.202,79569.202,79569.202,79569.202
y1965,GRD,187.286,187.286,187.286,187.286,187.286,187.286,187.286,187.286,187.286,187.286
y1965,GRL,814.759,814.759,814.759,814.759,814.759,814.759,814.759,814.759,814.759,814.759
y1965,GTM,13316.175,13316.175,13316.175,13316.175,13316.175,13316.175,13316.175,13316.175,13316.175,13316.175
y1965,GUF,827.845,827.845,827.845,827.845,827.845,827.845,827.845,827.845,827.845,827.845
y1965,GUM,2282.224,2282.224,2282.224,2282.224,2282.224,2282.224,2282.224,2282.224,2282.224,2282.224
y1965,GUY,1561.529,1561.529,1561.529,1561.529,1561.529,1561.529,1561.529,1561.529,1561.529,1561.529
y1965,HKG,23135.285,23135.285,23135.285,23135.285,23135.285,23135.285,23135.285,23135.285,23135.285,23135.285
y1965,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1965,HND,5275.583,5275.583,5275.583,5275.583,5275.583,5275.583,5275.583,5275.583,5275.583,5275.583
y1965,HRV,39035.72,39035.72,39035.72,39035.72,39035.72,39035.72,39035.72,39035.72,39035.72,39035.72
y1965,HTI,6152.614,6152.614,6152.614,6152.614,6152.614,6152.614,6152.614,6152.614,6152.614,6152.614
y1965,HUN,62050.431,62050.431,62050.431,62050.431,62050.431,62050.431,62050.431,62050.431,62050.431,62050.431
y1965,IDN,72641.444,72641.444,72641.444,72641.444,72641.444,72641.444,72641.444,72641.444,72641.444,72641.444
y1965,IMN,4290.32,4290.32,4290.32,4290.32,4290.32,4290.32,4290.32,4290.32,4290.32,4290.32
y1965,IND,364958.823,364958.823,364958.823,364958.823,364958.823,364958.823,364958.823,364958.823,364958.823,364958.823
y1965,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1965,IRL,23887.129,23887.129,23887.129,23887.129,23887.129,23887.129,23887.129,23887.129,23887.129,23887.129
y1965,IRN,130378.023,130378.023,130378.023,130378.023,130378.023,130378.023,130378.023,130378.023,130378.023,130378.023
y1965,IRQ,38355.512,38355.512,38355.512,38355.512,38355.512,38355.512,38355.512,38355.512,38355.512,38355.512
y1965,ISL,2596.432,2596.432,2596.432,2596.432,2596.432,2596.432,2596.432,2596.432,2596.432,2596.432
y1965,ISR,25013.734,25013.734,25013.734,25013.734,25013.734,25013.734,25013.734,25013.734,25013.734,25013.734
y1965,ITA,578982.8,578982.8,578982.8,578982.8,578982.8,578982.8,578982.8,578982.8,578982.8,578982.8
y1965,JAM,10387.333,10387.333,10387.333,10387.333,10387.333,10387.333,10387.333,10387.333,10387.333,10387.333
y1965,JEY,4105.382,4105.382,4105.382,4105.382,4105.382,4105.382,4105.382,4105.382,4105.382,4105.382
y1965,JOR,3776.128,3776.128,3776.128,3776.128,3776.128,3776.128,3776.128,3776.128,3776.128,3776.128
y1965,JPN,882443.461,882443.461,882443.461,882443.461,882443.461,882443.461,882443.461,882443.461,882443.461,882443.461
y1965,KAZ,47931.763,47931.763,47931.763,47931.763,47931.763,47931.763,47931.763,47931.763,47931.763,47931.763
y1965,KEN,9649.916,9649.916,9649.916,9649.916,9649.916,9649.916,9649.916,9649.916,9649.916,9649.916
y1965,KGZ,4360.14,4360.14,4360.14,4360.14,4360.14,4360.14,4360.14,4360.14,4360.14,4360.14
y1965,KHM,5663.623,5663.623,5663.623,5663.623,5663.623,5663.623,5663.623,5663.623,5663.623,5663.623
y1965,KIR,212.771,212.771,212.771,212.771,212.771,212.771,212.771,212.771,212.771,212.771
y1965,KNA,98.572,98.572,98.572,98.572,98.572,98.572,98.572,98.572,98.572,98.572
y1965,KOR,61244.264,61244.264,61244.264,61244.264,61244.264,61244.264,61244.264,61244.264,61244.264,61244.264
y1965,KWT,40158.606,40158.606,40158.606,40158.606,40158.606,40158.606,40158.606,40158.606,40158.606,40158.606
y1965,LAO,1391.081,1391.081,1391.081,1391.081,1391.081,1391.081,1391.081,1391.081,1391.081,1391.081
y1965,LBN,24332.647,24332.647,24332.647,24332.647,24332.647,24332.647,24332.647,24332.647,24332.647,24332.647
y1965,LBR,1692.031,1692.031,1692.031,1692.031,1692.031,1692.031,1692.031,1692.031,1692.031,1692.031
y1965,LBY,32356.264,32356.264,32356.264,32356.264,32356.264,32356.264,32356.264,32356.264,32356.264,32356.264
y1965,LCA,298.308,298.308,298.308,298.308,298.308,298.308,298.308,298.308,298.308,298.308
y1965,LIE,1218.591,1218.591,1218.591,1218.591,1218.591,1218.591,1218.591,1218.591,1218.591,1218.591
y1965,LKA,11071.387,11071.387,11071.387,11071.387,11071.387,11071.387,11071.387,11071.387,11071.387,11071.387
y1965,LSO,457.115,457.115,457.115,457.115,457.115,457.115,457.115,457.115,457.115,457.115
y1965,LTU,22934.376,22934.376,22934.376,22934.376,22934.376,22934.376,22934.376,22934.376,22934.376,22934.376
y1965,LUX,6658.943,6658.943,6658.943,6658.943,6658.943,6658.943,6658.943,6658.943,6658.943,6658.943
y1965,LVA,13087.746,13087.746,13087.746,13087.746,13087.746,13087.746,13087.746,13087.746,13087.746,13087.746
y1965,MAC,1163.566,1163.566,1163.566,1163.566,1163.566,1163.566,1163.566,1163.566,1163.566,1163.566
y1965,MAF,77.345,77.345,77.345,77.345,77.345,77.345,77.345,77.345,77.345,77.345
y1965,MAR,20252.668,20252.668,20252.668,20252.668,20252.668,20252.668,20252.668,20252.668,20252.668,20252.668
y1965,MCO,2481.458,2481.458,2481.458,2481.458,2481.458,2481.458,2481.458,2481.458,2481.458,2481.458
y1965,MDA,7276.692,7276.692,7276.692,7276.692,7276.692,7276.692,7276.692,7276.692,7276.692,7276.692
y1965,MDG,7176.59,7176.59,7176.59,7176.59,7176.59,7176.59,7176.59,7176.59,7176.59,7176.59
y1965,MDV,73.097,73.097,73.097,73.097,73.097,73.097,73.097,73.097,73.097,73.097
y1965,MEX,271299.623,271299.623,271299.623,271299.623,271299.623,271299.623,271299.623,271299.623,271299.623,271299.623
y1965,MHL,67.306,67.306,67.306,67.306,67.306,67.306,67.306,67.306,67.306,67.306
y1965,MKD,9650.405,9650.405,9650.405,9650.405,9650.405,9650.405,9650.405,9650.405,9650.405,9650.405
y1965,MLI,2976.148,2976.148,2976.148,2976.148,2976.148,2976.148,2976.148,2976.148,2976.148,2976.148
y1965,MLT,1136.756,1136.756,1136.756,1136.756,1136.756,1136.756,1136.756,1136.756,1136.756,1136.756
y1965,MMR,5590.86,5590.86,5590.86,5590.86,5590.86,5590.86,5590.86,5590.86,5590.86,5590.86
y1965,MNE,4839.672,4839.672,4839.672,4839.672,4839.672,4839.672,4839.672,4839.672,4839.672,4839.672
y1965,MNG,1369.662,1369.662,1369.662,1369.662,1369.662,1369.662,1369.662,1369.662,1369.662,1369.662
y1965,MNP,148.388,148.388,148.388,148.388,148.388,148.388,148.388,148.388,148.388,148.388
y1965,MOZ,2986.493,2986.493,2986.493,2986.493,2986.493,2986.493,2986.493,2986.493,2986.493,2986.493
y1965,MRT,1279.279,1279.279,1279.279,1279.279,1279.279,1279.279,1279.279,1279.279,1279.279,1279.279
y1965,MSR,100.657,100.657,100.657,100.657,100.657,100.657,100.657,100.657,100.657,100.657
y1965,MTQ,9148.126,9148.126,9148.126,9148.126,9148.126,9148.126,9148.126,9148.126,9148.126,9148.126
y1965,MUS,2048.916,2048.916,2048.916,2048.916,2048.916,2048.916,2048.916,2048.916,2048.916,2048.916
y1965,MWI,1736.863,1736.863,1736.863,1736.863,1736.863,1736.863,1736.863,1736.863,1736.863,1736.863
y1965,MYS,21414.085,21414.085,21414.085,21414.085,21414.085,21414.085,21414.085,21414.085,21414.085,21414.085
y1965,MYT,320.513,320.513,320.513,320.513,320.513,320.513,320.513,320.513,320.513,320.513
y1965,NAM,2833.179,2833.179,2833.179,2833.179,2833.179,2833.179,2833.179,2833.179,2833.179,2833.179
y1965,NCL,3739.647,3739.647,3739.647,3739.647,3739.647,3739.647,3739.647,3739.647,3739.647,3739.647
y1965,NER,4102.558,4102.558,4102.558,4102.558,4102.558,4102.558,4102.558,4102.558,4102.558,4102.558
y1965,NFK,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384
y1965,NGA,63965.984,63965.984,63965.984,63965.984,63965.984,63965.984,63965.984,63965.984,63965.984,63965.984
y1965,NIC,6824.873,6824.873,6824.873,6824.873,6824.873,6824.873,6824.873,6824.873,6824.873,6824.873
y1965,NIU,29.551,29.551,29.551,29.551,29.551,29.551,29.551,29.551,29.551,29.551
y1965,NLD,187643.06,187643.06,187643.06,187643.06,187643.06,187643.06,187643.06,187643.06,187643.06,187643.06
y1965,NOR,57820.762,57820.762,57820.762,57820.762,57820.762,57820.762,57820.762,57820.762,57820.762,57820.762
y1965,NPL,6227.738,6227.738,6227.738,6227.738,6227.738,6227.738,6227.738,6227.738,6227.738,6227.738
y1965,NRU,302.319,302.319,302.319,302.319,302.319,302.319,302.319,302.319,302.319,302.319
y1965,NZL,40404.238,40404.238,40404.238,40404.238,40404.238,40404.238,40404.238,40404.238,40404.238,40404.238
y1965,OMN,1443.853,1443.853,1443.853,1443.853,1443.853,1443.853,1443.853,1443.853,1443.853,1443.853
y1965,PAK,44884.509,44884.509,44884.509,44884.509,44884.509,44884.509,44884.509,44884.509,44884.509,44884.509
y1965,PAN,4644.05,4644.05,4644.05,4644.05,4644.05,4644.05,4644.05,4644.05,4644.05,4644.05
y1965,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1965,PER,55371.389,55371.389,55371.389,55371.389,55371.389,55371.389,55371.389,55371.389,55371.389,55371.389
y1965,PHL,52911.669,52911.669,52911.669,52911.669,52911.669,52911.669,52911.669,52911.669,52911.669,52911.669
y1965,PLW,151.139,151.139,151.139,151.139,151.139,151.139,151.139,151.139,151.139,151.139
y1965,PNG,3608.952,3608.952,3608.952,3608.952,3608.952,3608.952,3608.952,3608.952,3608.952,3608.952
y1965,POL,167316.378,167316.378,167316.378,167316.378,167316.378,167316.378,167316.378,167316.378,167316.378,167316.378
y1965,PRI,20870.556,20870.556,20870.556,20870.556,20870.556,20870.556,20870.556,20870.556,20870.556,20870.556
y1965,PRK,12821.325,12821.325,12821.325,12821.325,12821.325,12821.325,12821.325,12821.325,12821.325,12821.325
y1965,PRT,52872.865,52872.865,52872.865,52872.865,52872.865,52872.865,52872.865,52872.865,52872.865,52872.865
y1965,PRY,4650.488,4650.488,4650.488,4650.488,4650.488,4650.488,4650.488,4650.488,4650.488,4650.488
y1965,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1965,PYF,1201.79,1201.79,1201.79,1201.79,1201.79,1201.79,1201.79,1201.79,1201.79,1201.79
y1965,QAT,6451.846,6451.846,6451.846,6451.846,6451.846,6451.846,6451.846,6451.846,6451.846,6451.846
y1965,REU,10392.528,10392.528,10392.528,10392.528,10392.528,10392.528,10392.528,10392.528,10392.528,10392.528
y1965,ROU,59661.802,59661.802,59661.802,59661.802,59661.802,59661.802,59661.802,59661.802,59661.802,59661.802
y1965,RUS,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158,1044559.158
y1965,RWA,1995.5,1995.5,1995.5,1995.5,1995.5,1995.5,1995.5,1995.5,1995.5,1995.5
y1965,SAU,60356.972,60356.972,60356.972,60356.972,60356.972,60356.972,60356.972,60356.972,60356.972,60356.972
y1965,SDN,11089.332,11089.332,11089.332,11089.332,11089.332,11089.332,11089.332,11089.332,11089.332,11089.332
y1965,SEN,5568.096,5568.096,5568.096,5568.096,5568.096,5568.096,5568.096,5568.096,5568.096,5568.096
y1965,SGP,9655.647,9655.647,9655.647,9655.647,9655.647,9655.647,9655.647,9655.647,9655.647,9655.647
y1965,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1965,SHN,36.091,36.091,36.091,36.091,36.091,36.091,36.091,36.091,36.091,36.091
y1965,SJM,138.235,138.235,138.235,138.235,138.235,138.235,138.235,138.235,138.235,138.235
y1965,SLB,228.385,228.385,228.385,228.385,228.385,228.385,228.385,228.385,228.385,228.385
y1965,SLE,2005.774,2005.774,2005.774,2005.774,2005.774,2005.774,2005.774,2005.774,2005.774,2005.774
y1965,SLV,12354.522,12354.522,12354.522,12354.522,12354.522,12354.522,12354.522,12354.522,12354.522,12354.522
y1965,SMR,358.427,358.427,358.427,358.427,358.427,358.427,358.427,358.427,358.427,358.427
y1965,SOM,3020.407,3020.407,3020.407,3020.407,3020.407,3020.407,3020.407,3020.407,3020.407,3020.407
y1965,SPM,213.99,213.99,213.99,213.99,213.99,213.99,213.99,213.99,213.99,213.99
y1965,SRB,10343.418,10343.418,10343.418,10343.418,10343.418,10343.418,10343.418,10343.418,10343.418,10343.418
y1965,SSD,4895.651,4895.651,4895.651,4895.651,4895.651,4895.651,4895.651,4895.651,4895.651,4895.651
y1965,STP,62.973,62.973,62.973,62.973,62.973,62.973,62.973,62.973,62.973,62.973
y1965,SUR,1723.738,1723.738,1723.738,1723.738,1723.738,1723.738,1723.738,1723.738,1723.738,1723.738
y1965,SVK,27688.564,27688.564,27688.564,27688.564,27688.564,27688.564,27688.564,27688.564,27688.564,27688.564
y1965,SVN,14927.928,14927.928,14927.928,14927.928,14927.928,14927.928,14927.928,14927.928,14927.928,14927.928
y1965,SWE,119932.648,119932.648,119932.648,119932.648,119932.648,119932.648,119932.648,119932.648,119932.648,119932.648
y1965,SWZ,466.826,466.826,466.826,466.826,466.826,466.826,466.826,466.826,466.826,466.826
y1965,SXM,294.624,294.624,294.624,294.624,294.624,294.624,294.624,294.624,294.624,294.624
y1965,SYC,236.876,236.876,236.876,236.876,236.876,236.876,236.876,236.876,236.876,236.876
y1965,SYR,10928.09,10928.09,10928.09,10928.09,10928.09,10928.09,10928.09,10928.09,10928.09,10928.09
y1965,TCA,27.21,27.21,27.21,27.21,27.21,27.21,27.21,27.21,27.21,27.21
y1965,TCD,3141.826,3141.826,3141.826,3141.826,3141.826,3141.826,3141.826,3141.826,3141.826,3141.826
y1965,TGO,1733.238,1733.238,1733.238,1733.238,1733.238,1733.238,1733.238,1733.238,1733.238,1733.238
y1965,THA,38037.215,38037.215,38037.215,38037.215,38037.215,38037.215,38037.215,38037.215,38037.215,38037.215
y1965,TJK,4266.426,4266.426,4266.426,4266.426,4266.426,4266.426,4266.426,4266.426,4266.426,4266.426
y1965,TKL,1.924,1.924,1.924,1.924,1.924,1.924,1.924,1.924,1.924,1.924
y1965,TKM,5393.334,5393.334,5393.334,5393.334,5393.334,5393.334,5393.334,5393.334,5393.334,5393.334
y1965,TLS,463.185,463.185,463.185,463.185,463.185,463.185,463.185,463.185,463.185,463.185
y1965,TON,128.286,128.286,128.286,128.286,128.286,128.286,128.286,128.286,128.286,128.286
y1965,TTO,7786.467,7786.467,7786.467,7786.467,7786.467,7786.467,7786.467,7786.467,7786.467,7786.467
y1965,TUN,9840.727,9840.727,9840.727,9840.727,9840.727,9840.727,9840.727,9840.727,9840.727,9840.727
y1965,TUR,129291.965,129291.965,129291.965,129291.965,129291.965,129291.965,129291.965,129291.965,129291.965,129291.965
y1965,TUV,12.706,12.706,12.706,12.706,12.706,12.706,12.706,12.706,12.706,12.706
y1965,TWN,24845.678,24845.678,24845.678,24845.678,24845.678,24845.678,24845.678,24845.678,24845.678,24845.678
y1965,TZA,7572.578,7572.578,7572.578,7572.578,7572.578,7572.578,7572.578,7572.578,7572.578,7572.578
y1965,UGA,5386.292,5386.292,5386.292,5386.292,5386.292,5386.292,5386.292,5386.292,5386.292,5386.292
y1965,UKR,218194.98,218194.98,218194.98,218194.98,218194.98,218194.98,218194.98,218194.98,218194.98,218194.98
y1965,UMI,4.301,4.301,4.301,4.301,4.301,4.301,4.301,4.301,4.301,4.301
y1965,URY,13446.974,13446.974,13446.974,13446.974,13446.974,13446.974,13446.974,13446.974,13446.974,13446.974
y1965,USA,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31,3599216.31
y1965,UZB,13939.284,13939.284,13939.284,13939.284,13939.284,13939.284,13939.284,13939.284,13939.284,13939.284
y1965,VAT,32.49,32.49,32.49,32.49,32.49,32.49,32.49,32.49,32.49,32.49
y1965,VCT,179.891,179.891,179.891,179.891,179.891,179.891,179.891,179.891,179.891,179.891
y1965,VEN,94602.942,94602.942,94602.942,94602.942,94602.942,94602.942,94602.942,94602.942,94602.942,94602.942
y1965,VGB,35.381,35.381,35.381,35.381,35.381,35.381,35.381,35.381,35.381,35.381
y1965,VIR,1790.921,1790.921,1790.921,1790.921,1790.921,1790.921,1790.921,1790.921,1790.921,1790.921
y1965,VNM,22027.057,22027.057,22027.057,22027.057,22027.057,22027.057,22027.057,22027.057,22027.057,22027.057
y1965,VUT,181.036,181.036,181.036,181.036,181.036,181.036,181.036,181.036,181.036,181.036
y1965,WLF,120.84,120.84,120.84,120.84,120.84,120.84,120.84,120.84,120.84,120.84
y1965,WSM,331.086,331.086,331.086,331.086,331.086,331.086,331.086,331.086,331.086,331.086
y1965,YEM,3826.89,3826.89,3826.89,3826.89,3826.89,3826.89,3826.89,3826.89,3826.89,3826.89
y1965,ZAF,119838.264,119838.264,119838.264,119838.264,119838.264,119838.264,119838.264,119838.264,119838.264,119838.264
y1965,ZMB,7136.496,7136.496,7136.496,7136.496,7136.496,7136.496,7136.496,7136.496,7136.496,7136.496
y1965,ZWE,2005.148,2005.148,2005.148,2005.148,2005.148,2005.148,2005.148,2005.148,2005.148,2005.148
y1970,ABW,381.888,381.888,381.888,381.888,381.888,381.888,381.888,381.888,381.888,381.888
y1970,AFG,7777.947,7777.947,7777.947,7777.947,7777.947,7777.947,7777.947,7777.947,7777.947,7777.947
y1970,AGO,23861.975,23861.975,23861.975,23861.975,23861.975,23861.975,23861.975,23861.975,23861.975,23861.975
y1970,AIA,78.08,78.08,78.08,78.08,78.08,78.08,78.08,78.08,78.08,78.08
y1970,ALA,1153.762,1153.762,1153.762,1153.762,1153.762,1153.762,1153.762,1153.762,1153.762,1153.762
y1970,ALB,6520.79,6520.79,6520.79,6520.79,6520.79,6520.79,6520.79,6520.79,6520.79,6520.79
y1970,AND,1182.771,1182.771,1182.771,1182.771,1182.771,1182.771,1182.771,1182.771,1182.771,1182.771
y1970,ARE,17950.593,17950.593,17950.593,17950.593,17950.593,17950.593,17950.593,17950.593,17950.593,17950.593
y1970,ARG,196464.46,196464.46,196464.46,196464.46,196464.46,196464.46,196464.46,196464.46,196464.46,196464.46
y1970,ARM,5120.294,5120.294,5120.294,5120.294,5120.294,5120.294,5120.294,5120.294,5120.294,5120.294
y1970,ASM,354.796,354.796,354.796,354.796,354.796,354.796,354.796,354.796,354.796,354.796
y1970,ATA,10,10,10,10,10,10,10,10,10,10
y1970,ATF,1.668,1.668,1.668,1.668,1.668,1.668,1.668,1.668,1.668,1.668
y1970,ATG,307.832,307.832,307.832,307.832,307.832,307.832,307.832,307.832,307.832,307.832
y1970,AUS,220813.461,220813.461,220813.461,220813.461,220813.461,220813.461,220813.461,220813.461,220813.461,220813.461
y1970,AUT,117606.455,117606.455,117606.455,117606.455,117606.455,117606.455,117606.455,117606.455,117606.455,117606.455
y1970,AZE,16402.471,16402.471,16402.471,16402.471,16402.471,16402.471,16402.471,16402.471,16402.471,16402.471
y1970,BDI,1294.833,1294.833,1294.833,1294.833,1294.833,1294.833,1294.833,1294.833,1294.833,1294.833
y1970,BEL,150422.543,150422.543,150422.543,150422.543,150422.543,150422.543,150422.543,150422.543,150422.543,150422.543
y1970,BEN,2957.411,2957.411,2957.411,2957.411,2957.411,2957.411,2957.411,2957.411,2957.411,2957.411
y1970,BES,196.821,196.821,196.821,196.821,196.821,196.821,196.821,196.821,196.821,196.821
y1970,BFA,3272.368,3272.368,3272.368,3272.368,3272.368,3272.368,3272.368,3272.368,3272.368,3272.368
y1970,BGD,46850.305,46850.305,46850.305,46850.305,46850.305,46850.305,46850.305,46850.305,46850.305,46850.305
y1970,BGR,33439.023,33439.023,33439.023,33439.023,33439.023,33439.023,33439.023,33439.023,33439.023,33439.023
y1970,BHR,3927.503,3927.503,3927.503,3927.503,3927.503,3927.503,3927.503,3927.503,3927.503,3927.503
y1970,BHS,3508.593,3508.593,3508.593,3508.593,3508.593,3508.593,3508.593,3508.593,3508.593,3508.593
y1970,BIH,2078.817,2078.817,2078.817,2078.817,2078.817,2078.817,2078.817,2078.817,2078.817,2078.817
y1970,BLM,131.222,131.222,131.222,131.222,131.222,131.222,131.222,131.222,131.222,131.222
y1970,BLR,42828.663,42828.663,42828.663,42828.663,42828.663,42828.663,42828.663,42828.663,42828.663,42828.663
y1970,BLZ,366.241,366.241,366.241,366.241,366.241,366.241,366.241,366.241,366.241,366.241
y1970,BMU,2143.558,2143.558,2143.558,2143.558,2143.558,2143.558,2143.558,2143.558,2143.558,2143.558
y1970,BOL,12929.848,12929.848,12929.848,12929.848,12929.848,12929.848,12929.848,12929.848,12929.848,12929.848
y1970,BRA,424862.365,424862.365,424862.365,424862.365,424862.365,424862.365,424862.365,424862.365,424862.365,424862.365
y1970,BRB,3185.552,3185.552,3185.552,3185.552,3185.552,3185.552,3185.552,3185.552,3185.552,3185.552
y1970,BRN,6900.897,6900.897,6900.897,6900.897,6900.897,6900.897,6900.897,6900.897,6900.897,6900.897
y1970,BTN,251.059,251.059,251.059,251.059,251.059,251.059,251.059,251.059,251.059,251.059
y1970,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1970,BWA,965.865,965.865,965.865,965.865,965.865,965.865,965.865,965.865,965.865,965.865
y1970,CAF,1885.937,1885.937,1885.937,1885.937,1885.937,1885.937,1885.937,1885.937,1885.937,1885.937
y1970,CAN,381764.212,381764.212,381764.212,381764.212,381764.212,381764.212,381764.212,381764.212,381764.212,381764.212
y1970,CCK,49.451,49.451,49.451,49.451,49.451,49.451,49.451,49.451,49.451,49.451
y1970,CHE,157304.927,157304.927,157304.927,157304.927,157304.927,157304.927,157304.927,157304.927,157304.927,157304.927
y1970,CHL,46289.46,46289.46,46289.46,46289.46,46289.46,46289.46,46289.46,46289.46,46289.46,46289.46
y1970,CHN,303664.504,303664.504,303664.504,303664.504,303664.504,303664.504,303664.504,303664.504,303664.504,303664.504
y1970,CIV,10524.952,10524.952,10524.952,10524.952,10524.952,10524.952,10524.952,10524.952,10524.952,10524.952
y1970,CMR,9487.898,9487.898,9487.898,9487.898,9487.898,9487.898,9487.898,9487.898,9487.898,9487.898
y1970,COD,18204.206,18204.206,18204.206,18204.206,18204.206,18204.206,18204.206,18204.206,18204.206,18204.206
y1970,COG,2616.708,2616.708,2616.708,2616.708,2616.708,2616.708,2616.708,2616.708,2616.708,2616.708
y1970,COK,194.795,194.795,194.795,194.795,194.795,194.795,194.795,194.795,194.795,194.795
y1970,COL,79567.169,79567.169,79567.169,79567.169,79567.169,79567.169,79567.169,79567.169,79567.169,79567.169
y1970,COM,277.886,277.886,277.886,277.886,277.886,277.886,277.886,277.886,277.886,277.886
y1970,CPV,308.74,308.74,308.74,308.74,308.74,308.74,308.74,308.74,308.74,308.74
y1970,CRI,9999.534,9999.534,9999.534,9999.534,9999.534,9999.534,9999.534,9999.534,9999.534,9999.534
y1970,CUB,37089.298,37089.298,37089.298,37089.298,37089.298,37089.298,37089.298,37089.298,37089.298,37089.298
y1970,CUW,2154.525,2154.525,2154.525,2154.525,2154.525,2154.525,2154.525,2154.525,2154.525,2154.525
y1970,CXR,151.896,151.896,151.896,151.896,151.896,151.896,151.896,151.896,151.896,151.896
y1970,CYM,203.183,203.183,203.183,203.183,203.183,203.183,203.183,203.183,203.183,203.183
y1970,CYP,4155.123,4155.123,4155.123,4155.123,4155.123,4155.123,4155.123,4155.123,4155.123,4155.123
y1970,CZE,115342.388,115342.388,115342.388,115342.388,115342.388,115342.388,115342.388,115342.388,115342.388,115342.388
y1970,DEU,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048,1253056.048
y1970,DJI,751.699,751.699,751.699,751.699,751.699,751.699,751.699,751.699,751.699,751.699
y1970,DMA,175.803,175.803,175.803,175.803,175.803,175.803,175.803,175.803,175.803,175.803
y1970,DNK,86377.797,86377.797,86377.797,86377.797,86377.797,86377.797,86377.797,86377.797,86377.797,86377.797
y1970,DOM,11928.019,11928.019,11928.019,11928.019,11928.019,11928.019,11928.019,11928.019,11928.019,11928.019
y1970,DZA,63829.952,63829.952,63829.952,63829.952,63829.952,63829.952,63829.952,63829.952,63829.952,63829.952
y1970,ECU,21332.739,21332.739,21332.739,21332.739,21332.739,21332.739,21332.739,21332.739,21332.739,21332.739
y1970,EGY,56992.109,56992.109,56992.109,56992.109,56992.109,56992.109,56992.109,56992.109,56992.109,56992.109
y1970,ERI,813.826,813.826,813.826,813.826,813.826,813.826,813.826,813.826,813.826,813.826
y1970,ESH,192.188,192.188,192.188,192.188,192.188,192.188,192.188,192.188,192.188,192.188
y1970,ESP,398456.569,398456.569,398456.569,398456.569,398456.569,398456.569,398456.569,398456.569,398456.569,398456.569
y1970,EST,10184.951,10184.951,10184.951,10184.951,10184.951,10184.951,10184.951,10184.951,10184.951,10184.951
y1970,ETH,15392.126,15392.126,15392.126,15392.126,15392.126,15392.126,15392.126,15392.126,15392.126,15392.126
y1970,FIN,62133.508,62133.508,62133.508,62133.508,62133.508,62133.508,62133.508,62133.508,62133.508,62133.508
y1970,FJI,1268.218,1268.218,1268.218,1268.218,1268.218,1268.218,1268.218,1268.218,1268.218,1268.218
y1970,FLK,191.136,191.136,191.136,191.136,191.136,191.136,191.136,191.136,191.136,191.136
y1970,FRA,814460.072,814460.072,814460.072,814460.072,814460.072,814460.072,814460.072,814460.072,814460.072,814460.072
y1970,FRO,1543.48,1543.48,1543.48,1543.48,1543.48,1543.48,1543.48,1543.48,1543.48,1543.48
y1970,FSM,132.377,132.377,132.377,132.377,132.377,132.377,132.377,132.377,132.377,132.377
y1970,GAB,6347.829,6347.829,6347.829,6347.829,6347.829,6347.829,6347.829,6347.829,6347.829,6347.829
y1970,GBR,857412.768,857412.768,857412.768,857412.768,857412.768,857412.768,857412.768,857412.768,857412.768,857412.768
y1970,GEO,16711.946,16711.946,16711.946,16711.946,16711.946,16711.946,16711.946,16711.946,16711.946,16711.946
y1970,GGY,2957.903,2957.903,2957.903,2957.903,2957.903,2957.903,2957.903,2957.903,2957.903,2957.903
y1970,GHA,8978.027,8978.027,8978.027,8978.027,8978.027,8978.027,8978.027,8978.027,8978.027,8978.027
y1970,GIB,1521.584,1521.584,1521.584,1521.584,1521.584,1521.584,1521.584,1521.584,1521.584,1521.584
y1970,GIN,3076.587,3076.587,3076.587,3076.587,3076.587,3076.587,3076.587,3076.587,3076.587,3076.587
y1970,GLP,8703.95,8703.95,8703.95,8703.95,8703.95,8703.95,8703.95,8703.95,8703.95,8703.95
y1970,GMB,513.036,513.036,513.036,513.036,513.036,513.036,513.036,513.036,513.036,513.036
y1970,GNB,606.737,606.737,606.737,606.737,606.737,606.737,606.737,606.737,606.737,606.737
y1970,GNQ,335.077,335.077,335.077,335.077,335.077,335.077,335.077,335.077,335.077,335.077
y1970,GRC,109327.903,109327.903,109327.903,109327.903,109327.903,109327.903,109327.903,109327.903,109327.903,109327.903
y1970,GRD,236.601,236.601,236.601,236.601,236.601,236.601,236.601,236.601,236.601,236.601
y1970,GRL,1151.448,1151.448,1151.448,1151.448,1151.448,1151.448,1151.448,1151.448,1151.448,1151.448
y1970,GTM,18394.284,18394.284,18394.284,18394.284,18394.284,18394.284,18394.284,18394.284,18394.284,18394.284
y1970,GUF,1020.073,1020.073,1020.073,1020.073,1020.073,1020.073,1020.073,1020.073,1020.073,1020.073
y1970,GUM,2558.34,2558.34,2558.34,2558.34,2558.34,2558.34,2558.34,2558.34,2558.34,2558.34
y1970,GUY,1895.804,1895.804,1895.804,1895.804,1895.804,1895.804,1895.804,1895.804,1895.804,1895.804
y1970,HKG,30271.63,30271.63,30271.63,30271.63,30271.63,30271.63,30271.63,30271.63,30271.63,30271.63
y1970,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1970,HND,6398.876,6398.876,6398.876,6398.876,6398.876,6398.876,6398.876,6398.876,6398.876,6398.876
y1970,HRV,45696.416,45696.416,45696.416,45696.416,45696.416,45696.416,45696.416,45696.416,45696.416,45696.416
y1970,HTI,6600.706,6600.706,6600.706,6600.706,6600.706,6600.706,6600.706,6600.706,6600.706,6600.706
y1970,HUN,77451.942,77451.942,77451.942,77451.942,77451.942,77451.942,77451.942,77451.942,77451.942,77451.942
y1970,IDN,101437.89,101437.89,101437.89,101437.89,101437.89,101437.89,101437.89,101437.89,101437.89,101437.89
y1970,IMN,4797.835,4797.835,4797.835,4797.835,4797.835,4797.835,4797.835,4797.835,4797.835,4797.835
y1970,IND,457916.382,457916.382,457916.382,457916.382,457916.382,457916.382,457916.382,457916.382,457916.382,457916.382
y1970,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1970,IRL,29574.955,29574.955,29574.955,29574.955,29574.955,29574.955,29574.955,29574.955,29574.955,29574.955
y1970,IRN,218795.384,218795.384,218795.384,218795.384,218795.384,218795.384,218795.384,218795.384,218795.384,218795.384
y1970,IRQ,48560.617,48560.617,48560.617,48560.617,48560.617,48560.617,48560.617,48560.617,48560.617,48560.617
y1970,ISL,2890.968,2890.968,2890.968,2890.968,2890.968,2890.968,2890.968,2890.968,2890.968,2890.968
y1970,ISR,36784.306,36784.306,36784.306,36784.306,36784.306,36784.306,36784.306,36784.306,36784.306,36784.306
y1970,ITA,760541.492,760541.492,760541.492,760541.492,760541.492,760541.492,760541.492,760541.492,760541.492,760541.492
y1970,JAM,13066.286,13066.286,13066.286,13066.286,13066.286,13066.286,13066.286,13066.286,13066.286,13066.286
y1970,JEY,4206.163,4206.163,4206.163,4206.163,4206.163,4206.163,4206.163,4206.163,4206.163,4206.163
y1970,JOR,4482.466,4482.466,4482.466,4482.466,4482.466,4482.466,4482.466,4482.466,4482.466,4482.466
y1970,JPN,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709,1433061.709
y1970,KAZ,65656.705,65656.705,65656.705,65656.705,65656.705,65656.705,65656.705,65656.705,65656.705,65656.705
y1970,KEN,12104.396,12104.396,12104.396,12104.396,12104.396,12104.396,12104.396,12104.396,12104.396,12104.396
y1970,KGZ,5742.579,5742.579,5742.579,5742.579,5742.579,5742.579,5742.579,5742.579,5742.579,5742.579
y1970,KHM,5938.089,5938.089,5938.089,5938.089,5938.089,5938.089,5938.089,5938.089,5938.089,5938.089
y1970,KIR,242.741,242.741,242.741,242.741,242.741,242.741,242.741,242.741,242.741,242.741
y1970,KNA,113.882,113.882,113.882,113.882,113.882,113.882,113.882,113.882,113.882,113.882
y1970,KOR,97983.355,97983.355,97983.355,97983.355,97983.355,97983.355,97983.355,97983.355,97983.355,97983.355
y1970,KWT,66506.255,66506.255,66506.255,66506.255,66506.255,66506.255,66506.255,66506.255,66506.255,66506.255
y1970,LAO,1670.389,1670.389,1670.389,1670.389,1670.389,1670.389,1670.389,1670.389,1670.389,1670.389
y1970,LBN,29080.511,29080.511,29080.511,29080.511,29080.511,29080.511,29080.511,29080.511,29080.511,29080.511
y1970,LBR,2293.916,2293.916,2293.916,2293.916,2293.916,2293.916,2293.916,2293.916,2293.916,2293.916
y1970,LBY,63784.939,63784.939,63784.939,63784.939,63784.939,63784.939,63784.939,63784.939,63784.939,63784.939
y1970,LCA,391.947,391.947,391.947,391.947,391.947,391.947,391.947,391.947,391.947,391.947
y1970,LIE,1679.04,1679.04,1679.04,1679.04,1679.04,1679.04,1679.04,1679.04,1679.04,1679.04
y1970,LKA,14997.278,14997.278,14997.278,14997.278,14997.278,14997.278,14997.278,14997.278,14997.278,14997.278
y1970,LSO,532.059,532.059,532.059,532.059,532.059,532.059,532.059,532.059,532.059,532.059
y1970,LTU,29515.478,29515.478,29515.478,29515.478,29515.478,29515.478,29515.478,29515.478,29515.478,29515.478
y1970,LUX,7839.887,7839.887,7839.887,7839.887,7839.887,7839.887,7839.887,7839.887,7839.887,7839.887
y1970,LVA,17251.778,17251.778,17251.778,17251.778,17251.778,17251.778,17251.778,17251.778,17251.778,17251.778
y1970,MAC,1934.379,1934.379,1934.379,1934.379,1934.379,1934.379,1934.379,1934.379,1934.379,1934.379
y1970,MAF,92.814,92.814,92.814,92.814,92.814,92.814,92.814,92.814,92.814,92.814
y1970,MAR,26894.253,26894.253,26894.253,26894.253,26894.253,26894.253,26894.253,26894.253,26894.253,26894.253
y1970,MCO,2975.118,2975.118,2975.118,2975.118,2975.118,2975.118,2975.118,2975.118,2975.118,2975.118
y1970,MDA,9422.142,9422.142,9422.142,9422.142,9422.142,9422.142,9422.142,9422.142,9422.142,9422.142
y1970,MDG,9146.963,9146.963,9146.963,9146.963,9146.963,9146.963,9146.963,9146.963,9146.963,9146.963
y1970,MDV,107.35,107.35,107.35,107.35,107.35,107.35,107.35,107.35,107.35,107.35
y1970,MEX,363878.585,363878.585,363878.585,363878.585,363878.585,363878.585,363878.585,363878.585,363878.585,363878.585
y1970,MHL,89.029,89.029,89.029,89.029,89.029,89.029,89.029,89.029,89.029,89.029
y1970,MKD,11670.497,11670.497,11670.497,11670.497,11670.497,11670.497,11670.497,11670.497,11670.497,11670.497
y1970,MLI,3414.585,3414.585,3414.585,3414.585,3414.585,3414.585,3414.585,3414.585,3414.585,3414.585
y1970,MLT,1386.951,1386.951,1386.951,1386.951,1386.951,1386.951,1386.951,1386.951,1386.951,1386.951
y1970,MMR,6656.679,6656.679,6656.679,6656.679,6656.679,6656.679,6656.679,6656.679,6656.679,6656.679
y1970,MNE,5067.759,5067.759,5067.759,5067.759,5067.759,5067.759,5067.759,5067.759,5067.759,5067.759
y1970,MNG,1832.28,1832.28,1832.28,1832.28,1832.28,1832.28,1832.28,1832.28,1832.28,1832.28
y1970,MNP,175.6,175.6,175.6,175.6,175.6,175.6,175.6,175.6,175.6,175.6
y1970,MOZ,3792.818,3792.818,3792.818,3792.818,3792.818,3792.818,3792.818,3792.818,3792.818,3792.818
y1970,MRT,1752.304,1752.304,1752.304,1752.304,1752.304,1752.304,1752.304,1752.304,1752.304,1752.304
y1970,MSR,98.847,98.847,98.847,98.847,98.847,98.847,98.847,98.847,98.847,98.847
y1970,MTQ,9556.475,9556.475,9556.475,9556.475,9556.475,9556.475,9556.475,9556.475,9556.475,9556.475
y1970,MUS,2020.624,2020.624,2020.624,2020.624,2020.624,2020.624,2020.624,2020.624,2020.624,2020.624
y1970,MWI,2662.095,2662.095,2662.095,2662.095,2662.095,2662.095,2662.095,2662.095,2662.095,2662.095
y1970,MYS,28253.548,28253.548,28253.548,28253.548,28253.548,28253.548,28253.548,28253.548,28253.548,28253.548
y1970,MYT,388.133,388.133,388.133,388.133,388.133,388.133,388.133,388.133,388.133,388.133
y1970,NAM,3464.938,3464.938,3464.938,3464.938,3464.938,3464.938,3464.938,3464.938,3464.938,3464.938
y1970,NCL,5000.165,5000.165,5000.165,5000.165,5000.165,5000.165,5000.165,5000.165,5000.165,5000.165
y1970,NER,4287.972,4287.972,4287.972,4287.972,4287.972,4287.972,4287.972,4287.972,4287.972,4287.972
y1970,NFK,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384,11.384
y1970,NGA,75174.455,75174.455,75174.455,75174.455,75174.455,75174.455,75174.455,75174.455,75174.455,75174.455
y1970,NIC,8231.817,8231.817,8231.817,8231.817,8231.817,8231.817,8231.817,8231.817,8231.817,8231.817
y1970,NIU,29.754,29.754,29.754,29.754,29.754,29.754,29.754,29.754,29.754,29.754
y1970,NLD,239748.113,239748.113,239748.113,239748.113,239748.113,239748.113,239748.113,239748.113,239748.113,239748.113
y1970,NOR,69529.367,69529.367,69529.367,69529.367,69529.367,69529.367,69529.367,69529.367,69529.367,69529.367
y1970,NPL,7159.09,7159.09,7159.09,7159.09,7159.09,7159.09,7159.09,7159.09,7159.09,7159.09
y1970,NRU,287.659,287.659,287.659,287.659,287.659,287.659,287.659,287.659,287.659,287.659
y1970,NZL,44729.452,44729.452,44729.452,44729.452,44729.452,44729.452,44729.452,44729.452,44729.452,44729.452
y1970,OMN,5513.776,5513.776,5513.776,5513.776,5513.776,5513.776,5513.776,5513.776,5513.776,5513.776
y1970,PAK,60912.518,60912.518,60912.518,60912.518,60912.518,60912.518,60912.518,60912.518,60912.518,60912.518
y1970,PAN,6552.536,6552.536,6552.536,6552.536,6552.536,6552.536,6552.536,6552.536,6552.536,6552.536
y1970,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1970,PER,69779.981,69779.981,69779.981,69779.981,69779.981,69779.981,69779.981,69779.981,69779.981,69779.981
y1970,PHL,65866.809,65866.809,65866.809,65866.809,65866.809,65866.809,65866.809,65866.809,65866.809,65866.809
y1970,PLW,174.011,174.011,174.011,174.011,174.011,174.011,174.011,174.011,174.011,174.011
y1970,PNG,5006.996,5006.996,5006.996,5006.996,5006.996,5006.996,5006.996,5006.996,5006.996,5006.996
y1970,POL,202723.041,202723.041,202723.041,202723.041,202723.041,202723.041,202723.041,202723.041,202723.041,202723.041
y1970,PRI,28669.328,28669.328,28669.328,28669.328,28669.328,28669.328,28669.328,28669.328,28669.328,28669.328
y1970,PRK,21391.1,21391.1,21391.1,21391.1,21391.1,21391.1,21391.1,21391.1,21391.1,21391.1
y1970,PRT,68921.416,68921.416,68921.416,68921.416,68921.416,68921.416,68921.416,68921.416,68921.416,68921.416
y1970,PRY,5713.04,5713.04,5713.04,5713.04,5713.04,5713.04,5713.04,5713.04,5713.04,5713.04
y1970,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1970,PYF,1645.461,1645.461,1645.461,1645.461,1645.461,1645.461,1645.461,1645.461,1645.461,1645.461
y1970,QAT,11954.932,11954.932,11954.932,11954.932,11954.932,11954.932,11954.932,11954.932,11954.932,11954.932
y1970,REU,12287.555,12287.555,12287.555,12287.555,12287.555,12287.555,12287.555,12287.555,12287.555,12287.555
y1970,ROU,80517.04,80517.04,80517.04,80517.04,80517.04,80517.04,80517.04,80517.04,80517.04,80517.04
y1970,RUS,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236,1294936.236
y1970,RWA,2652.058,2652.058,2652.058,2652.058,2652.058,2652.058,2652.058,2652.058,2652.058,2652.058
y1970,SAU,98131.644,98131.644,98131.644,98131.644,98131.644,98131.644,98131.644,98131.644,98131.644,98131.644
y1970,SDN,12277.09,12277.09,12277.09,12277.09,12277.09,12277.09,12277.09,12277.09,12277.09,12277.09
y1970,SEN,6199.081,6199.081,6199.081,6199.081,6199.081,6199.081,6199.081,6199.081,6199.081,6199.081
y1970,SGP,15687.249,15687.249,15687.249,15687.249,15687.249,15687.249,15687.249,15687.249,15687.249,15687.249
y1970,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1970,SHN,38.103,38.103,38.103,38.103,38.103,38.103,38.103,38.103,38.103,38.103
y1970,SJM,143.883,143.883,143.883,143.883,143.883,143.883,143.883,143.883,143.883,143.883
y1970,SLB,302.677,302.677,302.677,302.677,302.677,302.677,302.677,302.677,302.677,302.677
y1970,SLE,2508.011,2508.011,2508.011,2508.011,2508.011,2508.011,2508.011,2508.011,2508.011,2508.011
y1970,SLV,15060.907,15060.907,15060.907,15060.907,15060.907,15060.907,15060.907,15060.907,15060.907,15060.907
y1970,SMR,488.391,488.391,488.391,488.391,488.391,488.391,488.391,488.391,488.391,488.391
y1970,SOM,3583.017,3583.017,3583.017,3583.017,3583.017,3583.017,3583.017,3583.017,3583.017,3583.017
y1970,SPM,229.194,229.194,229.194,229.194,229.194,229.194,229.194,229.194,229.194,229.194
y1970,SRB,12737.173,12737.173,12737.173,12737.173,12737.173,12737.173,12737.173,12737.173,12737.173,12737.173
y1970,SSD,5470.646,5470.646,5470.646,5470.646,5470.646,5470.646,5470.646,5470.646,5470.646,5470.646
y1970,STP,88.251,88.251,88.251,88.251,88.251,88.251,88.251,88.251,88.251,88.251
y1970,SUR,2215.717,2215.717,2215.717,2215.717,2215.717,2215.717,2215.717,2215.717,2215.717,2215.717
y1970,SVK,34980.8,34980.8,34980.8,34980.8,34980.8,34980.8,34980.8,34980.8,34980.8,34980.8
y1970,SVN,18608.624,18608.624,18608.624,18608.624,18608.624,18608.624,18608.624,18608.624,18608.624,18608.624
y1970,SWE,144950.818,144950.818,144950.818,144950.818,144950.818,144950.818,144950.818,144950.818,144950.818,144950.818
y1970,SWZ,674.503,674.503,674.503,674.503,674.503,674.503,674.503,674.503,674.503,674.503
y1970,SXM,452.892,452.892,452.892,452.892,452.892,452.892,452.892,452.892,452.892,452.892
y1970,SYC,325.539,325.539,325.539,325.539,325.539,325.539,325.539,325.539,325.539,325.539
y1970,SYR,12582.651,12582.651,12582.651,12582.651,12582.651,12582.651,12582.651,12582.651,12582.651,12582.651
y1970,TCA,37.473,37.473,37.473,37.473,37.473,37.473,37.473,37.473,37.473,37.473
y1970,TCD,3582.108,3582.108,3582.108,3582.108,3582.108,3582.108,3582.108,3582.108,3582.108,3582.108
y1970,TGO,2459.859,2459.859,2459.859,2459.859,2459.859,2459.859,2459.859,2459.859,2459.859,2459.859
y1970,THA,57236.754,57236.754,57236.754,57236.754,57236.754,57236.754,57236.754,57236.754,57236.754,57236.754
y1970,TJK,6298.296,6298.296,6298.296,6298.296,6298.296,6298.296,6298.296,6298.296,6298.296,6298.296
y1970,TKL,1.618,1.618,1.618,1.618,1.618,1.618,1.618,1.618,1.618,1.618
y1970,TKM,7633.29,7633.29,7633.29,7633.29,7633.29,7633.29,7633.29,7633.29,7633.29,7633.29
y1970,TLS,585.149,585.149,585.149,585.149,585.149,585.149,585.149,585.149,585.149,585.149
y1970,TON,176.201,176.201,176.201,176.201,176.201,176.201,176.201,176.201,176.201,176.201
y1970,TTO,9602.624,9602.624,9602.624,9602.624,9602.624,9602.624,9602.624,9602.624,9602.624,9602.624
y1970,TUN,12002.644,12002.644,12002.644,12002.644,12002.644,12002.644,12002.644,12002.644,12002.644,12002.644
y1970,TUR,173496.001,173496.001,173496.001,173496.001,173496.001,173496.001,173496.001,173496.001,173496.001,173496.001
y1970,TUV,16.098,16.098,16.098,16.098,16.098,16.098,16.098,16.098,16.098,16.098
y1970,TWN,40983.859,40983.859,40983.859,40983.859,40983.859,40983.859,40983.859,40983.859,40983.859,40983.859
y1970,TZA,9896.682,9896.682,9896.682,9896.682,9896.682,9896.682,9896.682,9896.682,9896.682,9896.682
y1970,UGA,7068.728,7068.728,7068.728,7068.728,7068.728,7068.728,7068.728,7068.728,7068.728,7068.728
y1970,UKR,279826.874,279826.874,279826.874,279826.874,279826.874,279826.874,279826.874,279826.874,279826.874,279826.874
y1970,UMI,4.819,4.819,4.819,4.819,4.819,4.819,4.819,4.819,4.819,4.819
y1970,URY,15081.848,15081.848,15081.848,15081.848,15081.848,15081.848,15081.848,15081.848,15081.848,15081.848
y1970,USA,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262,4233977.262
y1970,UZB,19025.932,19025.932,19025.932,19025.932,19025.932,19025.932,19025.932,19025.932,19025.932,19025.932
y1970,VAT,24.624,24.624,24.624,24.624,24.624,24.624,24.624,24.624,24.624,24.624
y1970,VCT,198.293,198.293,198.293,198.293,198.293,198.293,198.293,198.293,198.293,198.293
y1970,VEN,121301.841,121301.841,121301.841,121301.841,121301.841,121301.841,121301.841,121301.841,121301.841,121301.841
y1970,VGB,57.973,57.973,57.973,57.973,57.973,57.973,57.973,57.973,57.973,57.973
y1970,VIR,2312.927,2312.927,2312.927,2312.927,2312.927,2312.927,2312.927,2312.927,2312.927,2312.927
y1970,VNM,22142.318,22142.318,22142.318,22142.318,22142.318,22142.318,22142.318,22142.318,22142.318,22142.318
y1970,VUT,238.877,238.877,238.877,238.877,238.877,238.877,238.877,238.877,238.877,238.877
y1970,WLF,115.822,115.822,115.822,115.822,115.822,115.822,115.822,115.822,115.822,115.822
y1970,WSM,431.41,431.41,431.41,431.41,431.41,431.41,431.41,431.41,431.41,431.41
y1970,YEM,5131.106,5131.106,5131.106,5131.106,5131.106,5131.106,5131.106,5131.106,5131.106,5131.106
y1970,ZAF,156084.191,156084.191,156084.191,156084.191,156084.191,156084.191,156084.191,156084.191,156084.191,156084.191
y1970,ZMB,8706.526,8706.526,8706.526,8706.526,8706.526,8706.526,8706.526,8706.526,8706.526,8706.526
y1970,ZWE,2963.724,2963.724,2963.724,2963.724,2963.724,2963.724,2963.724,2963.724,2963.724,2963.724
y1975,ABW,575.741,575.741,575.741,575.741,575.741,575.741,575.741,575.741,575.741,575.741
y1975,AFG,8855.219,8855.219,8855.219,8855.219,8855.219,8855.219,8855.219,8855.219,8855.219,8855.219
y1975,AGO,25314.606,25314.606,25314.606,25314.606,25314.606,25314.606,25314.606,25314.606,25314.606,25314.606
y1975,AIA,80.886,80.886,80.886,80.886,80.886,80.886,80.886,80.886,80.886,80.886
y1975,ALA,1240.241,1240.241,1240.241,1240.241,1240.241,1240.241,1240.241,1240.241,1240.241,1240.241
y1975,ALB,8086.449,8086.449,8086.449,8086.449,8086.449,8086.449,8086.449,8086.449,8086.449,8086.449
y1975,AND,1523.72,1523.72,1523.72,1523.72,1523.72,1523.72,1523.72,1523.72,1523.72,1523.72
y1975,ARE,37616.31,37616.31,37616.31,37616.31,37616.31,37616.31,37616.31,37616.31,37616.31,37616.31
y1975,ARG,228128.755,228128.755,228128.755,228128.755,228128.755,228128.755,228128.755,228128.755,228128.755,228128.755
y1975,ARM,6685.037,6685.037,6685.037,6685.037,6685.037,6685.037,6685.037,6685.037,6685.037,6685.037
y1975,ASM,389.116,389.116,389.116,389.116,389.116,389.116,389.116,389.116,389.116,389.116
y1975,ATA,10,10,10,10,10,10,10,10,10,10
y1975,ATF,1.769,1.769,1.769,1.769,1.769,1.769,1.769,1.769,1.769,1.769
y1975,ATG,375.763,375.763,375.763,375.763,375.763,375.763,375.763,375.763,375.763,375.763
y1975,AUS,265153.045,265153.045,265153.045,265153.045,265153.045,265153.045,265153.045,265153.045,265153.045,265153.045
y1975,AUT,141203.83,141203.83,141203.83,141203.83,141203.83,141203.83,141203.83,141203.83,141203.83,141203.83
y1975,AZE,21766.841,21766.841,21766.841,21766.841,21766.841,21766.841,21766.841,21766.841,21766.841,21766.841
y1975,BDI,1367.028,1367.028,1367.028,1367.028,1367.028,1367.028,1367.028,1367.028,1367.028,1367.028
y1975,BEL,177468.625,177468.625,177468.625,177468.625,177468.625,177468.625,177468.625,177468.625,177468.625,177468.625
y1975,BEN,3373.343,3373.343,3373.343,3373.343,3373.343,3373.343,3373.343,3373.343,3373.343,3373.343
y1975,BES,209.513,209.513,209.513,209.513,209.513,209.513,209.513,209.513,209.513,209.513
y1975,BFA,3838.985,3838.985,3838.985,3838.985,3838.985,3838.985,3838.985,3838.985,3838.985,3838.985
y1975,BGD,43727.979,43727.979,43727.979,43727.979,43727.979,43727.979,43727.979,43727.979,43727.979,43727.979
y1975,BGR,45242.102,45242.102,45242.102,45242.102,45242.102,45242.102,45242.102,45242.102,45242.102,45242.102
y1975,BHR,5208.511,5208.511,5208.511,5208.511,5208.511,5208.511,5208.511,5208.511,5208.511,5208.511
y1975,BHS,2780.736,2780.736,2780.736,2780.736,2780.736,2780.736,2780.736,2780.736,2780.736,2780.736
y1975,BIH,3045.675,3045.675,3045.675,3045.675,3045.675,3045.675,3045.675,3045.675,3045.675,3045.675
y1975,BLM,137.67,137.67,137.67,137.67,137.67,137.67,137.67,137.67,137.67,137.67
y1975,BLR,49811.58,49811.58,49811.58,49811.58,49811.58,49811.58,49811.58,49811.58,49811.58,49811.58
y1975,BLZ,444.012,444.012,444.012,444.012,444.012,444.012,444.012,444.012,444.012,444.012
y1975,BMU,2233.697,2233.697,2233.697,2233.697,2233.697,2233.697,2233.697,2233.697,2233.697,2233.697
y1975,BOL,16711.492,16711.492,16711.492,16711.492,16711.492,16711.492,16711.492,16711.492,16711.492,16711.492
y1975,BRA,662729.548,662729.548,662729.548,662729.548,662729.548,662729.548,662729.548,662729.548,662729.548,662729.548
y1975,BRB,3501.691,3501.691,3501.691,3501.691,3501.691,3501.691,3501.691,3501.691,3501.691,3501.691
y1975,BRN,10211.287,10211.287,10211.287,10211.287,10211.287,10211.287,10211.287,10211.287,10211.287,10211.287
y1975,BTN,270.277,270.277,270.277,270.277,270.277,270.277,270.277,270.277,270.277,270.277
y1975,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1975,BWA,2028.293,2028.293,2028.293,2028.293,2028.293,2028.293,2028.293,2028.293,2028.293,2028.293
y1975,CAF,1987.124,1987.124,1987.124,1987.124,1987.124,1987.124,1987.124,1987.124,1987.124,1987.124
y1975,CAN,481798.648,481798.648,481798.648,481798.648,481798.648,481798.648,481798.648,481798.648,481798.648,481798.648
y1975,CCK,50.798,50.798,50.798,50.798,50.798,50.798,50.798,50.798,50.798,50.798
y1975,CHE,164848.802,164848.802,164848.802,164848.802,164848.802,164848.802,164848.802,164848.802,164848.802,164848.802
y1975,CHL,43370.319,43370.319,43370.319,43370.319,43370.319,43370.319,43370.319,43370.319,43370.319,43370.319
y1975,CHN,399860.802,399860.802,399860.802,399860.802,399860.802,399860.802,399860.802,399860.802,399860.802,399860.802
y1975,CIV,14100.928,14100.928,14100.928,14100.928,14100.928,14100.928,14100.928,14100.928,14100.928,14100.928
y1975,CMR,12809.272,12809.272,12809.272,12809.272,12809.272,12809.272,12809.272,12809.272,12809.272,12809.272
y1975,COD,19967.252,19967.252,19967.252,19967.252,19967.252,19967.252,19967.252,19967.252,19967.252,19967.252
y1975,COG,3672.658,3672.658,3672.658,3672.658,3672.658,3672.658,3672.658,3672.658,3672.658,3672.658
y1975,COK,185.23,185.23,185.23,185.23,185.23,185.23,185.23,185.23,185.23,185.23
y1975,COL,102936.969,102936.969,102936.969,102936.969,102936.969,102936.969,102936.969,102936.969,102936.969,102936.969
y1975,COM,320.303,320.303,320.303,320.303,320.303,320.303,320.303,320.303,320.303,320.303
y1975,CPV,304.782,304.782,304.782,304.782,304.782,304.782,304.782,304.782,304.782,304.782
y1975,CRI,13099.863,13099.863,13099.863,13099.863,13099.863,13099.863,13099.863,13099.863,13099.863,13099.863
y1975,CUB,48225.899,48225.899,48225.899,48225.899,48225.899,48225.899,48225.899,48225.899,48225.899,48225.899
y1975,CUW,2253.87,2253.87,2253.87,2253.87,2253.87,2253.87,2253.87,2253.87,2253.87,2253.87
y1975,CXR,155.987,155.987,155.987,155.987,155.987,155.987,155.987,155.987,155.987,155.987
y1975,CYM,318.409,318.409,318.409,318.409,318.409,318.409,318.409,318.409,318.409,318.409
y1975,CYP,3984.313,3984.313,3984.313,3984.313,3984.313,3984.313,3984.313,3984.313,3984.313,3984.313
y1975,CZE,132647.247,132647.247,132647.247,132647.247,132647.247,132647.247,132647.247,132647.247,132647.247,132647.247
y1975,DEU,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495,1400624.495
y1975,DJI,1010.139,1010.139,1010.139,1010.139,1010.139,1010.139,1010.139,1010.139,1010.139,1010.139
y1975,DMA,222.897,222.897,222.897,222.897,222.897,222.897,222.897,222.897,222.897,222.897
y1975,DNK,94626.149,94626.149,94626.149,94626.149,94626.149,94626.149,94626.149,94626.149,94626.149,94626.149
y1975,DOM,17484.38,17484.38,17484.38,17484.38,17484.38,17484.38,17484.38,17484.38,17484.38,17484.38
y1975,DZA,78296.398,78296.398,78296.398,78296.398,78296.398,78296.398,78296.398,78296.398,78296.398,78296.398
y1975,ECU,33446.621,33446.621,33446.621,33446.621,33446.621,33446.621,33446.621,33446.621,33446.621,33446.621
y1975,EGY,66811.779,66811.779,66811.779,66811.779,66811.779,66811.779,66811.779,66811.779,66811.779,66811.779
y1975,ERI,987.706,987.706,987.706,987.706,987.706,987.706,987.706,987.706,987.706,987.706
y1975,ESH,187.39,187.39,187.39,187.39,187.39,187.39,187.39,187.39,187.39,187.39
y1975,ESP,519372.77,519372.77,519372.77,519372.77,519372.77,519372.77,519372.77,519372.77,519372.77,519372.77
y1975,EST,11858.03,11858.03,11858.03,11858.03,11858.03,11858.03,11858.03,11858.03,11858.03,11858.03
y1975,ETH,17724.408,17724.408,17724.408,17724.408,17724.408,17724.408,17724.408,17724.408,17724.408,17724.408
y1975,FIN,75260.26,75260.26,75260.26,75260.26,75260.26,75260.26,75260.26,75260.26,75260.26,75260.26
y1975,FJI,1682.964,1682.964,1682.964,1682.964,1682.964,1682.964,1682.964,1682.964,1682.964,1682.964
y1975,FLK,184.032,184.032,184.032,184.032,184.032,184.032,184.032,184.032,184.032,184.032
y1975,FRA,978396.345,978396.345,978396.345,978396.345,978396.345,978396.345,978396.345,978396.345,978396.345,978396.345
y1975,FRO,1621.16,1621.16,1621.16,1621.16,1621.16,1621.16,1621.16,1621.16,1621.16,1621.16
y1975,FSM,187.937,187.937,187.937,187.937,187.937,187.937,187.937,187.937,187.937,187.937
y1975,GAB,11742.142,11742.142,11742.142,11742.142,11742.142,11742.142,11742.142,11742.142,11742.142,11742.142
y1975,GBR,957666.501,957666.501,957666.501,957666.501,957666.501,957666.501,957666.501,957666.501,957666.501,957666.501
y1975,GEO,20140.818,20140.818,20140.818,20140.818,20140.818,20140.818,20140.818,20140.818,20140.818,20140.818
y1975,GGY,2988.142,2988.142,2988.142,2988.142,2988.142,2988.142,2988.142,2988.142,2988.142,2988.142
y1975,GHA,9384.876,9384.876,9384.876,9384.876,9384.876,9384.876,9384.876,9384.876,9384.876,9384.876
y1975,GIB,1569.833,1569.833,1569.833,1569.833,1569.833,1569.833,1569.833,1569.833,1569.833,1569.833
y1975,GIN,3480.537,3480.537,3480.537,3480.537,3480.537,3480.537,3480.537,3480.537,3480.537,3480.537
y1975,GLP,8927.349,8927.349,8927.349,8927.349,8927.349,8927.349,8927.349,8927.349,8927.349,8927.349
y1975,GMB,653.405,653.405,653.405,653.405,653.405,653.405,653.405,653.405,653.405,653.405
y1975,GNB,777.122,777.122,777.122,777.122,777.122,777.122,777.122,777.122,777.122,777.122
y1975,GNQ,396.303,396.303,396.303,396.303,396.303,396.303,396.303,396.303,396.303,396.303
y1975,GRC,137595.175,137595.175,137595.175,137595.175,137595.175,137595.175,137595.175,137595.175,137595.175,137595.175
y1975,GRD,265.985,265.985,265.985,265.985,265.985,265.985,265.985,265.985,265.985,265.985
y1975,GRL,1561.631,1561.631,1561.631,1561.631,1561.631,1561.631,1561.631,1561.631,1561.631,1561.631
y1975,GTM,24591.291,24591.291,24591.291,24591.291,24591.291,24591.291,24591.291,24591.291,24591.291,24591.291
y1975,GUF,1196.552,1196.552,1196.552,1196.552,1196.552,1196.552,1196.552,1196.552,1196.552,1196.552
y1975,GUM,2847.297,2847.297,2847.297,2847.297,2847.297,2847.297,2847.297,2847.297,2847.297,2847.297
y1975,GUY,2395.941,2395.941,2395.941,2395.941,2395.941,2395.941,2395.941,2395.941,2395.941,2395.941
y1975,HKG,41885.153,41885.153,41885.153,41885.153,41885.153,41885.153,41885.153,41885.153,41885.153,41885.153
y1975,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1975,HND,8396.573,8396.573,8396.573,8396.573,8396.573,8396.573,8396.573,8396.573,8396.573,8396.573
y1975,HRV,51086.653,51086.653,51086.653,51086.653,51086.653,51086.653,51086.653,51086.653,51086.653,51086.653
y1975,HTI,7836.577,7836.577,7836.577,7836.577,7836.577,7836.577,7836.577,7836.577,7836.577,7836.577
y1975,HUN,98952.372,98952.372,98952.372,98952.372,98952.372,98952.372,98952.372,98952.372,98952.372,98952.372
y1975,IDN,153466.059,153466.059,153466.059,153466.059,153466.059,153466.059,153466.059,153466.059,153466.059,153466.059
y1975,IMN,5155.609,5155.609,5155.609,5155.609,5155.609,5155.609,5155.609,5155.609,5155.609,5155.609
y1975,IND,536223.955,536223.955,536223.955,536223.955,536223.955,536223.955,536223.955,536223.955,536223.955,536223.955
y1975,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1975,IRL,36868.742,36868.742,36868.742,36868.742,36868.742,36868.742,36868.742,36868.742,36868.742,36868.742
y1975,IRN,320990.605,320990.605,320990.605,320990.605,320990.605,320990.605,320990.605,320990.605,320990.605,320990.605
y1975,IRQ,72054.373,72054.373,72054.373,72054.373,72054.373,72054.373,72054.373,72054.373,72054.373,72054.373
y1975,ISL,3972.669,3972.669,3972.669,3972.669,3972.669,3972.669,3972.669,3972.669,3972.669,3972.669
y1975,ISR,52730.901,52730.901,52730.901,52730.901,52730.901,52730.901,52730.901,52730.901,52730.901,52730.901
y1975,ITA,875668.434,875668.434,875668.434,875668.434,875668.434,875668.434,875668.434,875668.434,875668.434,875668.434
y1975,JAM,14488.576,14488.576,14488.576,14488.576,14488.576,14488.576,14488.576,14488.576,14488.576,14488.576
y1975,JEY,4249.179,4249.179,4249.179,4249.179,4249.179,4249.179,4249.179,4249.179,4249.179,4249.179
y1975,JOR,5307.601,5307.601,5307.601,5307.601,5307.601,5307.601,5307.601,5307.601,5307.601,5307.601
y1975,JPN,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812,1777584.812
y1975,KAZ,79931.539,79931.539,79931.539,79931.539,79931.539,79931.539,79931.539,79931.539,79931.539,79931.539
y1975,KEN,15557.069,15557.069,15557.069,15557.069,15557.069,15557.069,15557.069,15557.069,15557.069,15557.069
y1975,KGZ,6908.407,6908.407,6908.407,6908.407,6908.407,6908.407,6908.407,6908.407,6908.407,6908.407
y1975,KHM,4773.861,4773.861,4773.861,4773.861,4773.861,4773.861,4773.861,4773.861,4773.861,4773.861
y1975,KIR,459.093,459.093,459.093,459.093,459.093,459.093,459.093,459.093,459.093,459.093
y1975,KNA,139.554,139.554,139.554,139.554,139.554,139.554,139.554,139.554,139.554,139.554
y1975,KOR,142583.134,142583.134,142583.134,142583.134,142583.134,142583.134,142583.134,142583.134,142583.134,142583.134
y1975,KWT,59470.668,59470.668,59470.668,59470.668,59470.668,59470.668,59470.668,59470.668,59470.668,59470.668
y1975,LAO,2151.313,2151.313,2151.313,2151.313,2151.313,2151.313,2151.313,2151.313,2151.313,2151.313
y1975,LBN,34151.898,34151.898,34151.898,34151.898,34151.898,34151.898,34151.898,34151.898,34151.898,34151.898
y1975,LBR,2484.746,2484.746,2484.746,2484.746,2484.746,2484.746,2484.746,2484.746,2484.746,2484.746
y1975,LBY,67031.949,67031.949,67031.949,67031.949,67031.949,67031.949,67031.949,67031.949,67031.949,67031.949
y1975,LCA,458.636,458.636,458.636,458.636,458.636,458.636,458.636,458.636,458.636,458.636
y1975,LIE,1843.437,1843.437,1843.437,1843.437,1843.437,1843.437,1843.437,1843.437,1843.437,1843.437
y1975,LKA,17493.69,17493.69,17493.69,17493.69,17493.69,17493.69,17493.69,17493.69,17493.69,17493.69
y1975,LSO,685.718,685.718,685.718,685.718,685.718,685.718,685.718,685.718,685.718,685.718
y1975,LTU,34656.451,34656.451,34656.451,34656.451,34656.451,34656.451,34656.451,34656.451,34656.451,34656.451
y1975,LUX,9029.85,9029.85,9029.85,9029.85,9029.85,9029.85,9029.85,9029.85,9029.85,9029.85
y1975,LVA,20462.694,20462.694,20462.694,20462.694,20462.694,20462.694,20462.694,20462.694,20462.694,20462.694
y1975,MAC,2580.314,2580.314,2580.314,2580.314,2580.314,2580.314,2580.314,2580.314,2580.314,2580.314
y1975,MAF,95.769,95.769,95.769,95.769,95.769,95.769,95.769,95.769,95.769,95.769
y1975,MAR,35068.3,35068.3,35068.3,35068.3,35068.3,35068.3,35068.3,35068.3,35068.3,35068.3
y1975,MCO,3637.436,3637.436,3637.436,3637.436,3637.436,3637.436,3637.436,3637.436,3637.436,3637.436
y1975,MDA,11157.026,11157.026,11157.026,11157.026,11157.026,11157.026,11157.026,11157.026,11157.026,11157.026
y1975,MDG,9727.348,9727.348,9727.348,9727.348,9727.348,9727.348,9727.348,9727.348,9727.348,9727.348
y1975,MDV,120.709,120.709,120.709,120.709,120.709,120.709,120.709,120.709,120.709,120.709
y1975,MEX,501894.391,501894.391,501894.391,501894.391,501894.391,501894.391,501894.391,501894.391,501894.391,501894.391
y1975,MHL,142.71,142.71,142.71,142.71,142.71,142.71,142.71,142.71,142.71,142.71
y1975,MKD,13140.012,13140.012,13140.012,13140.012,13140.012,13140.012,13140.012,13140.012,13140.012,13140.012
y1975,MLI,3912.803,3912.803,3912.803,3912.803,3912.803,3912.803,3912.803,3912.803,3912.803,3912.803
y1975,MLT,1878.148,1878.148,1878.148,1878.148,1878.148,1878.148,1878.148,1878.148,1878.148,1878.148
y1975,MMR,7690.862,7690.862,7690.862,7690.862,7690.862,7690.862,7690.862,7690.862,7690.862,7690.862
y1975,MNE,5581.949,5581.949,5581.949,5581.949,5581.949,5581.949,5581.949,5581.949,5581.949,5581.949
y1975,MNG,2410.241,2410.241,2410.241,2410.241,2410.241,2410.241,2410.241,2410.241,2410.241,2410.241
y1975,MNP,202.586,202.586,202.586,202.586,202.586,202.586,202.586,202.586,202.586,202.586
y1975,MOZ,4548.016,4548.016,4548.016,4548.016,4548.016,4548.016,4548.016,4548.016,4548.016,4548.016
y1975,MRT,2076.367,2076.367,2076.367,2076.367,2076.367,2076.367,2076.367,2076.367,2076.367,2076.367
y1975,MSR,100.13,100.13,100.13,100.13,100.13,100.13,100.13,100.13,100.13,100.13
y1975,MTQ,9639.509,9639.509,9639.509,9639.509,9639.509,9639.509,9639.509,9639.509,9639.509,9639.509
y1975,MUS,2837.175,2837.175,2837.175,2837.175,2837.175,2837.175,2837.175,2837.175,2837.175,2837.175
y1975,MWI,3780.349,3780.349,3780.349,3780.349,3780.349,3780.349,3780.349,3780.349,3780.349,3780.349
y1975,MYS,42742.481,42742.481,42742.481,42742.481,42742.481,42742.481,42742.481,42742.481,42742.481,42742.481
y1975,MYT,477.582,477.582,477.582,477.582,477.582,477.582,477.582,477.582,477.582,477.582
y1975,NAM,4152.709,4152.709,4152.709,4152.709,4152.709,4152.709,4152.709,4152.709,4152.709,4152.709
y1975,NCL,5705.17,5705.17,5705.17,5705.17,5705.17,5705.17,5705.17,5705.17,5705.17,5705.17
y1975,NER,3993.317,3993.317,3993.317,3993.317,3993.317,3993.317,3993.317,3993.317,3993.317,3993.317
y1975,NFK,12.758,12.758,12.758,12.758,12.758,12.758,12.758,12.758,12.758,12.758
y1975,NGA,103008.418,103008.418,103008.418,103008.418,103008.418,103008.418,103008.418,103008.418,103008.418,103008.418
y1975,NIC,10576.312,10576.312,10576.312,10576.312,10576.312,10576.312,10576.312,10576.312,10576.312,10576.312
y1975,NIU,23.038,23.038,23.038,23.038,23.038,23.038,23.038,23.038,23.038,23.038
y1975,NLD,283397.012,283397.012,283397.012,283397.012,283397.012,283397.012,283397.012,283397.012,283397.012,283397.012
y1975,NOR,87099.509,87099.509,87099.509,87099.509,87099.509,87099.509,87099.509,87099.509,87099.509,87099.509
y1975,NPL,8023.562,8023.562,8023.562,8023.562,8023.562,8023.562,8023.562,8023.562,8023.562,8023.562
y1975,NRU,283.745,283.745,283.745,283.745,283.745,283.745,283.745,283.745,283.745,283.745
y1975,NZL,54575.772,54575.772,54575.772,54575.772,54575.772,54575.772,54575.772,54575.772,54575.772,54575.772
y1975,OMN,8214.879,8214.879,8214.879,8214.879,8214.879,8214.879,8214.879,8214.879,8214.879,8214.879
y1975,PAK,73825.743,73825.743,73825.743,73825.743,73825.743,73825.743,73825.743,73825.743,73825.743,73825.743
y1975,PAN,8364.912,8364.912,8364.912,8364.912,8364.912,8364.912,8364.912,8364.912,8364.912,8364.912
y1975,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1975,PER,89362.095,89362.095,89362.095,89362.095,89362.095,89362.095,89362.095,89362.095,89362.095,89362.095
y1975,PHL,88049.174,88049.174,88049.174,88049.174,88049.174,88049.174,88049.174,88049.174,88049.174,88049.174
y1975,PLW,180.932,180.932,180.932,180.932,180.932,180.932,180.932,180.932,180.932,180.932
y1975,PNG,6008.752,6008.752,6008.752,6008.752,6008.752,6008.752,6008.752,6008.752,6008.752,6008.752
y1975,POL,264666.821,264666.821,264666.821,264666.821,264666.821,264666.821,264666.821,264666.821,264666.821,264666.821
y1975,PRI,33234.448,33234.448,33234.448,33234.448,33234.448,33234.448,33234.448,33234.448,33234.448,33234.448
y1975,PRK,34896.33,34896.33,34896.33,34896.33,34896.33,34896.33,34896.33,34896.33,34896.33,34896.33
y1975,PRT,84542.345,84542.345,84542.345,84542.345,84542.345,84542.345,84542.345,84542.345,84542.345,84542.345
y1975,PRY,7747.73,7747.73,7747.73,7747.73,7747.73,7747.73,7747.73,7747.73,7747.73,7747.73
y1975,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1975,PYF,2138.644,2138.644,2138.644,2138.644,2138.644,2138.644,2138.644,2138.644,2138.644,2138.644
y1975,QAT,18506.508,18506.508,18506.508,18506.508,18506.508,18506.508,18506.508,18506.508,18506.508,18506.508
y1975,REU,12892.617,12892.617,12892.617,12892.617,12892.617,12892.617,12892.617,12892.617,12892.617,12892.617
y1975,ROU,124645.565,124645.565,124645.565,124645.565,124645.565,124645.565,124645.565,124645.565,124645.565,124645.565
y1975,RUS,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3,1479756.3
y1975,RWA,2910.447,2910.447,2910.447,2910.447,2910.447,2910.447,2910.447,2910.447,2910.447,2910.447
y1975,SAU,216982.757,216982.757,216982.757,216982.757,216982.757,216982.757,216982.757,216982.757,216982.757,216982.757
y1975,SDN,15205.926,15205.926,15205.926,15205.926,15205.926,15205.926,15205.926,15205.926,15205.926,15205.926
y1975,SEN,7042.248,7042.248,7042.248,7042.248,7042.248,7042.248,7042.248,7042.248,7042.248,7042.248
y1975,SGP,24209.843,24209.843,24209.843,24209.843,24209.843,24209.843,24209.843,24209.843,24209.843,24209.843
y1975,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1975,SHN,40.388,40.388,40.388,40.388,40.388,40.388,40.388,40.388,40.388,40.388
y1975,SJM,148.754,148.754,148.754,148.754,148.754,148.754,148.754,148.754,148.754,148.754
y1975,SLB,379.492,379.492,379.492,379.492,379.492,379.492,379.492,379.492,379.492,379.492
y1975,SLE,2812.064,2812.064,2812.064,2812.064,2812.064,2812.064,2812.064,2812.064,2812.064,2812.064
y1975,SLV,19231.675,19231.675,19231.675,19231.675,19231.675,19231.675,19231.675,19231.675,19231.675,19231.675
y1975,SMR,506.112,506.112,506.112,506.112,506.112,506.112,506.112,506.112,506.112,506.112
y1975,SOM,4303.089,4303.089,4303.089,4303.089,4303.089,4303.089,4303.089,4303.089,4303.089,4303.089
y1975,SPM,247.086,247.086,247.086,247.086,247.086,247.086,247.086,247.086,247.086,247.086
y1975,SRB,14957.571,14957.571,14957.571,14957.571,14957.571,14957.571,14957.571,14957.571,14957.571,14957.571
y1975,SSD,6175.949,6175.949,6175.949,6175.949,6175.949,6175.949,6175.949,6175.949,6175.949,6175.949
y1975,STP,105.614,105.614,105.614,105.614,105.614,105.614,105.614,105.614,105.614,105.614
y1975,SUR,2411.353,2411.353,2411.353,2411.353,2411.353,2411.353,2411.353,2411.353,2411.353,2411.353
y1975,SVK,42680.294,42680.294,42680.294,42680.294,42680.294,42680.294,42680.294,42680.294,42680.294,42680.294
y1975,SVN,22143.91,22143.91,22143.91,22143.91,22143.91,22143.91,22143.91,22143.91,22143.91,22143.91
y1975,SWE,164239.437,164239.437,164239.437,164239.437,164239.437,164239.437,164239.437,164239.437,164239.437,164239.437
y1975,SWZ,1189.841,1189.841,1189.841,1189.841,1189.841,1189.841,1189.841,1189.841,1189.841,1189.841
y1975,SXM,630.498,630.498,630.498,630.498,630.498,630.498,630.498,630.498,630.498,630.498
y1975,SYC,449.038,449.038,449.038,449.038,449.038,449.038,449.038,449.038,449.038,449.038
y1975,SYR,22077.276,22077.276,22077.276,22077.276,22077.276,22077.276,22077.276,22077.276,22077.276,22077.276
y1975,TCA,61.476,61.476,61.476,61.476,61.476,61.476,61.476,61.476,61.476,61.476
y1975,TCD,4146.185,4146.185,4146.185,4146.185,4146.185,4146.185,4146.185,4146.185,4146.185,4146.185
y1975,TGO,2919.39,2919.39,2919.39,2919.39,2919.39,2919.39,2919.39,2919.39,2919.39,2919.39
y1975,THA,76374.204,76374.204,76374.204,76374.204,76374.204,76374.204,76374.204,76374.204,76374.204,76374.204
y1975,TJK,8258.782,8258.782,8258.782,8258.782,8258.782,8258.782,8258.782,8258.782,8258.782,8258.782
y1975,TKL,1.574,1.574,1.574,1.574,1.574,1.574,1.574,1.574,1.574,1.574
y1975,TKM,9811.227,9811.227,9811.227,9811.227,9811.227,9811.227,9811.227,9811.227,9811.227,9811.227
y1975,TLS,706.669,706.669,706.669,706.669,706.669,706.669,706.669,706.669,706.669,706.669
y1975,TON,197.075,197.075,197.075,197.075,197.075,197.075,197.075,197.075,197.075,197.075
y1975,TTO,11094.366,11094.366,11094.366,11094.366,11094.366,11094.366,11094.366,11094.366,11094.366,11094.366
y1975,TUN,17404.884,17404.884,17404.884,17404.884,17404.884,17404.884,17404.884,17404.884,17404.884,17404.884
y1975,TUR,227179.153,227179.153,227179.153,227179.153,227179.153,227179.153,227179.153,227179.153,227179.153,227179.153
y1975,TUV,14.788,14.788,14.788,14.788,14.788,14.788,14.788,14.788,14.788,14.788
y1975,TWN,63099.17,63099.17,63099.17,63099.17,63099.17,63099.17,63099.17,63099.17,63099.17,63099.17
y1975,TZA,12391.848,12391.848,12391.848,12391.848,12391.848,12391.848,12391.848,12391.848,12391.848,12391.848
y1975,UGA,7533.018,7533.018,7533.018,7533.018,7533.018,7533.018,7533.018,7533.018,7533.018,7533.018
y1975,UKR,325573.947,325573.947,325573.947,325573.947,325573.947,325573.947,325573.947,325573.947,325573.947,325573.947
y1975,UMI,5.368,5.368,5.368,5.368,5.368,5.368,5.368,5.368,5.368,5.368
y1975,URY,16249.481,16249.481,16249.481,16249.481,16249.481,16249.481,16249.481,16249.481,16249.481,16249.481
y1975,USA,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881,4855381.881
y1975,UZB,23588.838,23588.838,23588.838,23588.838,23588.838,23588.838,23588.838,23588.838,23588.838,23588.838
y1975,VAT,27.702,27.702,27.702,27.702,27.702,27.702,27.702,27.702,27.702,27.702
y1975,VCT,198.252,198.252,198.252,198.252,198.252,198.252,198.252,198.252,198.252,198.252
y1975,VEN,150800.517,150800.517,150800.517,150800.517,150800.517,150800.517,150800.517,150800.517,150800.517,150800.517
y1975,VGB,63.192,63.192,63.192,63.192,63.192,63.192,63.192,63.192,63.192,63.192
y1975,VIR,3097.019,3097.019,3097.019,3097.019,3097.019,3097.019,3097.019,3097.019,3097.019,3097.019
y1975,VNM,24597.252,24597.252,24597.252,24597.252,24597.252,24597.252,24597.252,24597.252,24597.252,24597.252
y1975,VUT,365.214,365.214,365.214,365.214,365.214,365.214,365.214,365.214,365.214,365.214
y1975,WLF,119.464,119.464,119.464,119.464,119.464,119.464,119.464,119.464,119.464,119.464
y1975,WSM,462.331,462.331,462.331,462.331,462.331,462.331,462.331,462.331,462.331,462.331
y1975,YEM,7934.238,7934.238,7934.238,7934.238,7934.238,7934.238,7934.238,7934.238,7934.238,7934.238
y1975,ZAF,190382.375,190382.375,190382.375,190382.375,190382.375,190382.375,190382.375,190382.375,190382.375,190382.375
y1975,ZMB,9919.087,9919.087,9919.087,9919.087,9919.087,9919.087,9919.087,9919.087,9919.087,9919.087
y1975,ZWE,3908.361,3908.361,3908.361,3908.361,3908.361,3908.361,3908.361,3908.361,3908.361,3908.361
y1980,ABW,845.402,845.402,845.402,845.402,845.402,845.402,845.402,845.402,845.402,845.402
y1980,AFG,9008.347,9008.347,9008.347,9008.347,9008.347,9008.347,9008.347,9008.347,9008.347,9008.347
y1980,AGO,25299.934,25299.934,25299.934,25299.934,25299.934,25299.934,25299.934,25299.934,25299.934,25299.934
y1980,AIA,81.716,81.716,81.716,81.716,81.716,81.716,81.716,81.716,81.716,81.716
y1980,ALA,1267.095,1267.095,1267.095,1267.095,1267.095,1267.095,1267.095,1267.095,1267.095,1267.095
y1980,ALB,9676.063,9676.063,9676.063,9676.063,9676.063,9676.063,9676.063,9676.063,9676.063,9676.063
y1980,AND,1641.118,1641.118,1641.118,1641.118,1641.118,1641.118,1641.118,1641.118,1641.118,1641.118
y1980,ARE,77146.683,77146.683,77146.683,77146.683,77146.683,77146.683,77146.683,77146.683,77146.683,77146.683
y1980,ARG,258602.416,258602.416,258602.416,258602.416,258602.416,258602.416,258602.416,258602.416,258602.416,258602.416
y1980,ARM,7944.693,7944.693,7944.693,7944.693,7944.693,7944.693,7944.693,7944.693,7944.693,7944.693
y1980,ASM,421.928,421.928,421.928,421.928,421.928,421.928,421.928,421.928,421.928,421.928
y1980,ATA,10,10,10,10,10,10,10,10,10,10
y1980,ATF,1.849,1.849,1.849,1.849,1.849,1.849,1.849,1.849,1.849,1.849
y1980,ATG,468.956,468.956,468.956,468.956,468.956,468.956,468.956,468.956,468.956,468.956
y1980,AUS,308916.783,308916.783,308916.783,308916.783,308916.783,308916.783,308916.783,308916.783,308916.783,308916.783
y1980,AUT,164227.723,164227.723,164227.723,164227.723,164227.723,164227.723,164227.723,164227.723,164227.723,164227.723
y1980,AZE,26131.939,26131.939,26131.939,26131.939,26131.939,26131.939,26131.939,26131.939,26131.939,26131.939
y1980,BDI,1676.475,1676.475,1676.475,1676.475,1676.475,1676.475,1676.475,1676.475,1676.475,1676.475
y1980,BEL,206836.052,206836.052,206836.052,206836.052,206836.052,206836.052,206836.052,206836.052,206836.052,206836.052
y1980,BEN,4120.269,4120.269,4120.269,4120.269,4120.269,4120.269,4120.269,4120.269,4120.269,4120.269
y1980,BES,212.857,212.857,212.857,212.857,212.857,212.857,212.857,212.857,212.857,212.857
y1980,BFA,4526.417,4526.417,4526.417,4526.417,4526.417,4526.417,4526.417,4526.417,4526.417,4526.417
y1980,BGD,52969.037,52969.037,52969.037,52969.037,52969.037,52969.037,52969.037,52969.037,52969.037,52969.037
y1980,BGR,56197.436,56197.436,56197.436,56197.436,56197.436,56197.436,56197.436,56197.436,56197.436,56197.436
y1980,BHR,8584.43,8584.43,8584.43,8584.43,8584.43,8584.43,8584.43,8584.43,8584.43,8584.43
y1980,BHS,4625.496,4625.496,4625.496,4625.496,4625.496,4625.496,4625.496,4625.496,4625.496,4625.496
y1980,BIH,4342.447,4342.447,4342.447,4342.447,4342.447,4342.447,4342.447,4342.447,4342.447,4342.447
y1980,BLM,144.638,144.638,144.638,144.638,144.638,144.638,144.638,144.638,144.638,144.638
y1980,BLR,54719.888,54719.888,54719.888,54719.888,54719.888,54719.888,54719.888,54719.888,54719.888,54719.888
y1980,BLZ,572.541,572.541,572.541,572.541,572.541,572.541,572.541,572.541,572.541,572.541
y1980,BMU,2775.579,2775.579,2775.579,2775.579,2775.579,2775.579,2775.579,2775.579,2775.579,2775.579
y1980,BOL,18954.126,18954.126,18954.126,18954.126,18954.126,18954.126,18954.126,18954.126,18954.126,18954.126
y1980,BRA,918472.044,918472.044,918472.044,918472.044,918472.044,918472.044,918472.044,918472.044,918472.044,918472.044
y1980,BRB,4446.193,4446.193,4446.193,4446.193,4446.193,4446.193,4446.193,4446.193,4446.193,4446.193
y1980,BRN,16352.682,16352.682,16352.682,16352.682,16352.682,16352.682,16352.682,16352.682,16352.682,16352.682
y1980,BTN,368.423,368.423,368.423,368.423,368.423,368.423,368.423,368.423,368.423,368.423
y1980,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1980,BWA,3427.334,3427.334,3427.334,3427.334,3427.334,3427.334,3427.334,3427.334,3427.334,3427.334
y1980,CAF,2114.086,2114.086,2114.086,2114.086,2114.086,2114.086,2114.086,2114.086,2114.086,2114.086
y1980,CAN,573630.495,573630.495,573630.495,573630.495,573630.495,573630.495,573630.495,573630.495,573630.495,573630.495
y1980,CCK,46.657,46.657,46.657,46.657,46.657,46.657,46.657,46.657,46.657,46.657
y1980,CHE,182903.005,182903.005,182903.005,182903.005,182903.005,182903.005,182903.005,182903.005,182903.005,182903.005
y1980,CHL,61293.835,61293.835,61293.835,61293.835,61293.835,61293.835,61293.835,61293.835,61293.835,61293.835
y1980,CHN,550531.513,550531.513,550531.513,550531.513,550531.513,550531.513,550531.513,550531.513,550531.513,550531.513
y1980,CIV,18106.196,18106.196,18106.196,18106.196,18106.196,18106.196,18106.196,18106.196,18106.196,18106.196
y1980,CMR,17498.525,17498.525,17498.525,17498.525,17498.525,17498.525,17498.525,17498.525,17498.525,17498.525
y1980,COD,18853.677,18853.677,18853.677,18853.677,18853.677,18853.677,18853.677,18853.677,18853.677,18853.677
y1980,COG,4720.76,4720.76,4720.76,4720.76,4720.76,4720.76,4720.76,4720.76,4720.76,4720.76
y1980,COK,160.369,160.369,160.369,160.369,160.369,160.369,160.369,160.369,160.369,160.369
y1980,COL,134598.936,134598.936,134598.936,134598.936,134598.936,134598.936,134598.936,134598.936,134598.936,134598.936
y1980,COM,383.282,383.282,383.282,383.282,383.282,383.282,383.282,383.282,383.282,383.282
y1980,CPV,320.402,320.402,320.402,320.402,320.402,320.402,320.402,320.402,320.402,320.402
y1980,CRI,16812.819,16812.819,16812.819,16812.819,16812.819,16812.819,16812.819,16812.819,16812.819,16812.819
y1980,CUB,56339.09,56339.09,56339.09,56339.09,56339.09,56339.09,56339.09,56339.09,56339.09,56339.09
y1980,CUW,2219.925,2219.925,2219.925,2219.925,2219.925,2219.925,2219.925,2219.925,2219.925,2219.925
y1980,CXR,143.263,143.263,143.263,143.263,143.263,143.263,143.263,143.263,143.263,143.263
y1980,CYM,507.335,507.335,507.335,507.335,507.335,507.335,507.335,507.335,507.335,507.335
y1980,CYP,7142.335,7142.335,7142.335,7142.335,7142.335,7142.335,7142.335,7142.335,7142.335,7142.335
y1980,CZE,150587.64,150587.64,150587.64,150587.64,150587.64,150587.64,150587.64,150587.64,150587.64,150587.64
y1980,DEU,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438,1635444.438
y1980,DJI,1258.204,1258.204,1258.204,1258.204,1258.204,1258.204,1258.204,1258.204,1258.204,1258.204
y1980,DMA,258.037,258.037,258.037,258.037,258.037,258.037,258.037,258.037,258.037,258.037
y1980,DNK,107740.127,107740.127,107740.127,107740.127,107740.127,107740.127,107740.127,107740.127,107740.127,107740.127
y1980,DOM,22421.507,22421.507,22421.507,22421.507,22421.507,22421.507,22421.507,22421.507,22421.507,22421.507
y1980,DZA,106783.094,106783.094,106783.094,106783.094,106783.094,106783.094,106783.094,106783.094,106783.094,106783.094
y1980,ECU,44829.168,44829.168,44829.168,44829.168,44829.168,44829.168,44829.168,44829.168,44829.168,44829.168
y1980,EGY,101478.564,101478.564,101478.564,101478.564,101478.564,101478.564,101478.564,101478.564,101478.564,101478.564
y1980,ERI,1182.094,1182.094,1182.094,1182.094,1182.094,1182.094,1182.094,1182.094,1182.094,1182.094
y1980,ESH,377.18,377.18,377.18,377.18,377.18,377.18,377.18,377.18,377.18,377.18
y1980,ESP,575399.029,575399.029,575399.029,575399.029,575399.029,575399.029,575399.029,575399.029,575399.029,575399.029
y1980,EST,12995.255,12995.255,12995.255,12995.255,12995.255,12995.255,12995.255,12995.255,12995.255,12995.255
y1980,ETH,19725.146,19725.146,19725.146,19725.146,19725.146,19725.146,19725.146,19725.146,19725.146,19725.146
y1980,FIN,86977.978,86977.978,86977.978,86977.978,86977.978,86977.978,86977.978,86977.978,86977.978,86977.978
y1980,FJI,2108.626,2108.626,2108.626,2108.626,2108.626,2108.626,2108.626,2108.626,2108.626,2108.626
y1980,FLK,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176
y1980,FRA,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899,1145742.899
y1980,FRO,1720.4,1720.4,1720.4,1720.4,1720.4,1720.4,1720.4,1720.4,1720.4,1720.4
y1980,FSM,196.901,196.901,196.901,196.901,196.901,196.901,196.901,196.901,196.901,196.901
y1980,GAB,11150.525,11150.525,11150.525,11150.525,11150.525,11150.525,11150.525,11150.525,11150.525,11150.525
y1980,GBR,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729,1042510.729
y1980,GEO,22551.328,22551.328,22551.328,22551.328,22551.328,22551.328,22551.328,22551.328,22551.328,22551.328
y1980,GGY,2990.347,2990.347,2990.347,2990.347,2990.347,2990.347,2990.347,2990.347,2990.347,2990.347
y1980,GHA,9850.379,9850.379,9850.379,9850.379,9850.379,9850.379,9850.379,9850.379,9850.379,9850.379
y1980,GIB,1639.246,1639.246,1639.246,1639.246,1639.246,1639.246,1639.246,1639.246,1639.246,1639.246
y1980,GIN,3719.344,3719.344,3719.344,3719.344,3719.344,3719.344,3719.344,3719.344,3719.344,3719.344
y1980,GLP,9014.681,9014.681,9014.681,9014.681,9014.681,9014.681,9014.681,9014.681,9014.681,9014.681
y1980,GMB,724.882,724.882,724.882,724.882,724.882,724.882,724.882,724.882,724.882,724.882
y1980,GNB,664.456,664.456,664.456,664.456,664.456,664.456,664.456,664.456,664.456,664.456
y1980,GNQ,353.32,353.32,353.32,353.32,353.32,353.32,353.32,353.32,353.32,353.32
y1980,GRC,167749.985,167749.985,167749.985,167749.985,167749.985,167749.985,167749.985,167749.985,167749.985,167749.985
y1980,GRD,354.788,354.788,354.788,354.788,354.788,354.788,354.788,354.788,354.788,354.788
y1980,GRL,2157.425,2157.425,2157.425,2157.425,2157.425,2157.425,2157.425,2157.425,2157.425,2157.425
y1980,GTM,32591.68,32591.68,32591.68,32591.68,32591.68,32591.68,32591.68,32591.68,32591.68,32591.68
y1980,GUF,1425.429,1425.429,1425.429,1425.429,1425.429,1425.429,1425.429,1425.429,1425.429,1425.429
y1980,GUM,3175.995,3175.995,3175.995,3175.995,3175.995,3175.995,3175.995,3175.995,3175.995,3175.995
y1980,GUY,2314.311,2314.311,2314.311,2314.311,2314.311,2314.311,2314.311,2314.311,2314.311,2314.311
y1980,HKG,70472.783,70472.783,70472.783,70472.783,70472.783,70472.783,70472.783,70472.783,70472.783,70472.783
y1980,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1980,HND,11356.822,11356.822,11356.822,11356.822,11356.822,11356.822,11356.822,11356.822,11356.822,11356.822
y1980,HRV,55772.875,55772.875,55772.875,55772.875,55772.875,55772.875,55772.875,55772.875,55772.875,55772.875
y1980,HTI,10944.706,10944.706,10944.706,10944.706,10944.706,10944.706,10944.706,10944.706,10944.706,10944.706
y1980,HUN,113913.532,113913.532,113913.532,113913.532,113913.532,113913.532,113913.532,113913.532,113913.532,113913.532
y1980,IDN,219571.856,219571.856,219571.856,219571.856,219571.856,219571.856,219571.856,219571.856,219571.856,219571.856
y1980,IMN,5508.137,5508.137,5508.137,5508.137,5508.137,5508.137,5508.137,5508.137,5508.137,5508.137
y1980,IND,645923.267,645923.267,645923.267,645923.267,645923.267,645923.267,645923.267,645923.267,645923.267,645923.267
y1980,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1980,IRL,46130.852,46130.852,46130.852,46130.852,46130.852,46130.852,46130.852,46130.852,46130.852,46130.852
y1980,IRN,244163.322,244163.322,244163.322,244163.322,244163.322,244163.322,244163.322,244163.322,244163.322,244163.322
y1980,IRQ,121211.778,121211.778,121211.778,121211.778,121211.778,121211.778,121211.778,121211.778,121211.778,121211.778
y1980,ISL,5160.641,5160.641,5160.641,5160.641,5160.641,5160.641,5160.641,5160.641,5160.641,5160.641
y1980,ISR,60483.305,60483.305,60483.305,60483.305,60483.305,60483.305,60483.305,60483.305,60483.305,60483.305
y1980,ITA,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738,1076988.738
y1980,JAM,12870.838,12870.838,12870.838,12870.838,12870.838,12870.838,12870.838,12870.838,12870.838,12870.838
y1980,JEY,4252.347,4252.347,4252.347,4252.347,4252.347,4252.347,4252.347,4252.347,4252.347,4252.347
y1980,JOR,10161.296,10161.296,10161.296,10161.296,10161.296,10161.296,10161.296,10161.296,10161.296,10161.296
y1980,JPN,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526,2165724.526
y1980,KAZ,90278.248,90278.248,90278.248,90278.248,90278.248,90278.248,90278.248,90278.248,90278.248,90278.248
y1980,KEN,20847.425,20847.425,20847.425,20847.425,20847.425,20847.425,20847.425,20847.425,20847.425,20847.425
y1980,KGZ,7955.668,7955.668,7955.668,7955.668,7955.668,7955.668,7955.668,7955.668,7955.668,7955.668
y1980,KHM,3794.484,3794.484,3794.484,3794.484,3794.484,3794.484,3794.484,3794.484,3794.484,3794.484
y1980,KIR,174.141,174.141,174.141,174.141,174.141,174.141,174.141,174.141,174.141,174.141
y1980,KNA,188.392,188.392,188.392,188.392,188.392,188.392,188.392,188.392,188.392,188.392
y1980,KOR,199932.704,199932.704,199932.704,199932.704,199932.704,199932.704,199932.704,199932.704,199932.704,199932.704
y1980,KWT,62162.053,62162.053,62162.053,62162.053,62162.053,62162.053,62162.053,62162.053,62162.053,62162.053
y1980,LAO,2452.922,2452.922,2452.922,2452.922,2452.922,2452.922,2452.922,2452.922,2452.922,2452.922
y1980,LBN,28864.25,28864.25,28864.25,28864.25,28864.25,28864.25,28864.25,28864.25,28864.25,28864.25
y1980,LBR,2843.572,2843.572,2843.572,2843.572,2843.572,2843.572,2843.572,2843.572,2843.572,2843.572
y1980,LBY,100691.536,100691.536,100691.536,100691.536,100691.536,100691.536,100691.536,100691.536,100691.536,100691.536
y1980,LCA,617.236,617.236,617.236,617.236,617.236,617.236,617.236,617.236,617.236,617.236
y1980,LIE,2362.078,2362.078,2362.078,2362.078,2362.078,2362.078,2362.078,2362.078,2362.078,2362.078
y1980,LKA,22798.748,22798.748,22798.748,22798.748,22798.748,22798.748,22798.748,22798.748,22798.748,22798.748
y1980,LSO,995.048,995.048,995.048,995.048,995.048,995.048,995.048,995.048,995.048,995.048
y1980,LTU,38137.447,38137.447,38137.447,38137.447,38137.447,38137.447,38137.447,38137.447,38137.447,38137.447
y1980,LUX,10079.865,10079.865,10079.865,10079.865,10079.865,10079.865,10079.865,10079.865,10079.865,10079.865
y1980,LVA,22497.128,22497.128,22497.128,22497.128,22497.128,22497.128,22497.128,22497.128,22497.128,22497.128
y1980,MAC,3389.098,3389.098,3389.098,3389.098,3389.098,3389.098,3389.098,3389.098,3389.098,3389.098
y1980,MAF,123.752,123.752,123.752,123.752,123.752,123.752,123.752,123.752,123.752,123.752
y1980,MAR,45479.667,45479.667,45479.667,45479.667,45479.667,45479.667,45479.667,45479.667,45479.667,45479.667
y1980,MCO,4392.313,4392.313,4392.313,4392.313,4392.313,4392.313,4392.313,4392.313,4392.313,4392.313
y1980,MDA,12362.54,12362.54,12362.54,12362.54,12362.54,12362.54,12362.54,12362.54,12362.54,12362.54
y1980,MDG,10663.779,10663.779,10663.779,10663.779,10663.779,10663.779,10663.779,10663.779,10663.779,10663.779
y1980,MDV,193.958,193.958,193.958,193.958,193.958,193.958,193.958,193.958,193.958,193.958
y1980,MEX,691057.825,691057.825,691057.825,691057.825,691057.825,691057.825,691057.825,691057.825,691057.825,691057.825
y1980,MHL,156.961,156.961,156.961,156.961,156.961,156.961,156.961,156.961,156.961,156.961
y1980,MKD,14816.257,14816.257,14816.257,14816.257,14816.257,14816.257,14816.257,14816.257,14816.257,14816.257
y1980,MLI,4953.989,4953.989,4953.989,4953.989,4953.989,4953.989,4953.989,4953.989,4953.989,4953.989
y1980,MLT,3024.759,3024.759,3024.759,3024.759,3024.759,3024.759,3024.759,3024.759,3024.759,3024.759
y1980,MMR,10401.109,10401.109,10401.109,10401.109,10401.109,10401.109,10401.109,10401.109,10401.109,10401.109
y1980,MNE,5939.107,5939.107,5939.107,5939.107,5939.107,5939.107,5939.107,5939.107,5939.107,5939.107
y1980,MNG,3236.211,3236.211,3236.211,3236.211,3236.211,3236.211,3236.211,3236.211,3236.211,3236.211
y1980,MNP,226.738,226.738,226.738,226.738,226.738,226.738,226.738,226.738,226.738,226.738
y1980,MOZ,5130.879,5130.879,5130.879,5130.879,5130.879,5130.879,5130.879,5130.879,5130.879,5130.879
y1980,MRT,2391.128,2391.128,2391.128,2391.128,2391.128,2391.128,2391.128,2391.128,2391.128,2391.128
y1980,MSR,101.312,101.312,101.312,101.312,101.312,101.312,101.312,101.312,101.312,101.312
y1980,MTQ,9569.471,9569.471,9569.471,9569.471,9569.471,9569.471,9569.471,9569.471,9569.471,9569.471
y1980,MUS,3413.111,3413.111,3413.111,3413.111,3413.111,3413.111,3413.111,3413.111,3413.111,3413.111
y1980,MWI,4727.855,4727.855,4727.855,4727.855,4727.855,4727.855,4727.855,4727.855,4727.855,4727.855
y1980,MYS,64423.156,64423.156,64423.156,64423.156,64423.156,64423.156,64423.156,64423.156,64423.156,64423.156
y1980,MYT,578.928,578.928,578.928,578.928,578.928,578.928,578.928,578.928,578.928,578.928
y1980,NAM,4808.368,4808.368,4808.368,4808.368,4808.368,4808.368,4808.368,4808.368,4808.368,4808.368
y1980,NCL,5385.305,5385.305,5385.305,5385.305,5385.305,5385.305,5385.305,5385.305,5385.305,5385.305
y1980,NER,5177.576,5177.576,5177.576,5177.576,5177.576,5177.576,5177.576,5177.576,5177.576,5177.576
y1980,NFK,14.196,14.196,14.196,14.196,14.196,14.196,14.196,14.196,14.196,14.196
y1980,NGA,110450.99,110450.99,110450.99,110450.99,110450.99,110450.99,110450.99,110450.99,110450.99,110450.99
y1980,NIC,9345.405,9345.405,9345.405,9345.405,9345.405,9345.405,9345.405,9345.405,9345.405,9345.405
y1980,NIU,19.732,19.732,19.732,19.732,19.732,19.732,19.732,19.732,19.732,19.732
y1980,NLD,325501.716,325501.716,325501.716,325501.716,325501.716,325501.716,325501.716,325501.716,325501.716,325501.716
y1980,NOR,106288.058,106288.058,106288.058,106288.058,106288.058,106288.058,106288.058,106288.058,106288.058,106288.058
y1980,NPL,9060.731,9060.731,9060.731,9060.731,9060.731,9060.731,9060.731,9060.731,9060.731,9060.731
y1980,NRU,232.096,232.096,232.096,232.096,232.096,232.096,232.096,232.096,232.096,232.096
y1980,NZL,53811.084,53811.084,53811.084,53811.084,53811.084,53811.084,53811.084,53811.084,53811.084,53811.084
y1980,OMN,11295.599,11295.599,11295.599,11295.599,11295.599,11295.599,11295.599,11295.599,11295.599,11295.599
y1980,PAK,100204.132,100204.132,100204.132,100204.132,100204.132,100204.132,100204.132,100204.132,100204.132,100204.132
y1980,PAN,11565.724,11565.724,11565.724,11565.724,11565.724,11565.724,11565.724,11565.724,11565.724,11565.724
y1980,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1980,PER,100247.668,100247.668,100247.668,100247.668,100247.668,100247.668,100247.668,100247.668,100247.668,100247.668
y1980,PHL,116680.576,116680.576,116680.576,116680.576,116680.576,116680.576,116680.576,116680.576,116680.576,116680.576
y1980,PLW,180.399,180.399,180.399,180.399,180.399,180.399,180.399,180.399,180.399,180.399
y1980,PNG,6293.385,6293.385,6293.385,6293.385,6293.385,6293.385,6293.385,6293.385,6293.385,6293.385
y1980,POL,304461.754,304461.754,304461.754,304461.754,304461.754,304461.754,304461.754,304461.754,304461.754,304461.754
y1980,PRI,41604.711,41604.711,41604.711,41604.711,41604.711,41604.711,41604.711,41604.711,41604.711,41604.711
y1980,PRK,39911.05,39911.05,39911.05,39911.05,39911.05,39911.05,39911.05,39911.05,39911.05,39911.05
y1980,PRT,110086.65,110086.65,110086.65,110086.65,110086.65,110086.65,110086.65,110086.65,110086.65,110086.65
y1980,PRY,12566.787,12566.787,12566.787,12566.787,12566.787,12566.787,12566.787,12566.787,12566.787,12566.787
y1980,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1980,PYF,2697.49,2697.49,2697.49,2697.49,2697.49,2697.49,2697.49,2697.49,2697.49,2697.49
y1980,QAT,21948.517,21948.517,21948.517,21948.517,21948.517,21948.517,21948.517,21948.517,21948.517,21948.517
y1980,REU,13543.743,13543.743,13543.743,13543.743,13543.743,13543.743,13543.743,13543.743,13543.743,13543.743
y1980,ROU,169190.898,169190.898,169190.898,169190.898,169190.898,169190.898,169190.898,169190.898,169190.898,169190.898
y1980,RUS,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812,1627285.812
y1980,RWA,4096.28,4096.28,4096.28,4096.28,4096.28,4096.28,4096.28,4096.28,4096.28,4096.28
y1980,SAU,306889.845,306889.845,306889.845,306889.845,306889.845,306889.845,306889.845,306889.845,306889.845,306889.845
y1980,SDN,18020.118,18020.118,18020.118,18020.118,18020.118,18020.118,18020.118,18020.118,18020.118,18020.118
y1980,SEN,7454.264,7454.264,7454.264,7454.264,7454.264,7454.264,7454.264,7454.264,7454.264,7454.264
y1980,SGP,35299.818,35299.818,35299.818,35299.818,35299.818,35299.818,35299.818,35299.818,35299.818,35299.818
y1980,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1980,SHN,41.566,41.566,41.566,41.566,41.566,41.566,41.566,41.566,41.566,41.566
y1980,SJM,151.578,151.578,151.578,151.578,151.578,151.578,151.578,151.578,151.578,151.578
y1980,SLB,568.706,568.706,568.706,568.706,568.706,568.706,568.706,568.706,568.706,568.706
y1980,SLE,3274.283,3274.283,3274.283,3274.283,3274.283,3274.283,3274.283,3274.283,3274.283,3274.283
y1980,SLV,20236.868,20236.868,20236.868,20236.868,20236.868,20236.868,20236.868,20236.868,20236.868,20236.868
y1980,SMR,631.186,631.186,631.186,631.186,631.186,631.186,631.186,631.186,631.186,631.186
y1980,SOM,5524.724,5524.724,5524.724,5524.724,5524.724,5524.724,5524.724,5524.724,5524.724,5524.724
y1980,SPM,251.958,251.958,251.958,251.958,251.958,251.958,251.958,251.958,251.958,251.958
y1980,SRB,17085.499,17085.499,17085.499,17085.499,17085.499,17085.499,17085.499,17085.499,17085.499,17085.499
y1980,SSD,7052.04,7052.04,7052.04,7052.04,7052.04,7052.04,7052.04,7052.04,7052.04,7052.04
y1980,STP,152.787,152.787,152.787,152.787,152.787,152.787,152.787,152.787,152.787,152.787
y1980,SUR,2641.487,2641.487,2641.487,2641.487,2641.487,2641.487,2641.487,2641.487,2641.487,2641.487
y1980,SVK,51520.967,51520.967,51520.967,51520.967,51520.967,51520.967,51520.967,51520.967,51520.967,51520.967
y1980,SVN,26413.163,26413.163,26413.163,26413.163,26413.163,26413.163,26413.163,26413.163,26413.163,26413.163
y1980,SWE,175578.167,175578.167,175578.167,175578.167,175578.167,175578.167,175578.167,175578.167,175578.167,175578.167
y1980,SWZ,1402.426,1402.426,1402.426,1402.426,1402.426,1402.426,1402.426,1402.426,1402.426,1402.426
y1980,SXM,864.468,864.468,864.468,864.468,864.468,864.468,864.468,864.468,864.468,864.468
y1980,SYC,659.417,659.417,659.417,659.417,659.417,659.417,659.417,659.417,659.417,659.417
y1980,SYR,29844.057,29844.057,29844.057,29844.057,29844.057,29844.057,29844.057,29844.057,29844.057,29844.057
y1980,TCA,100.713,100.713,100.713,100.713,100.713,100.713,100.713,100.713,100.713,100.713
y1980,TCD,3093.072,3093.072,3093.072,3093.072,3093.072,3093.072,3093.072,3093.072,3093.072,3093.072
y1980,TGO,3417.317,3417.317,3417.317,3417.317,3417.317,3417.317,3417.317,3417.317,3417.317,3417.317
y1980,THA,109625.708,109625.708,109625.708,109625.708,109625.708,109625.708,109625.708,109625.708,109625.708,109625.708
y1980,TJK,10195.311,10195.311,10195.311,10195.311,10195.311,10195.311,10195.311,10195.311,10195.311,10195.311
y1980,TKL,1.553,1.553,1.553,1.553,1.553,1.553,1.553,1.553,1.553,1.553
y1980,TKM,11896.542,11896.542,11896.542,11896.542,11896.542,11896.542,11896.542,11896.542,11896.542,11896.542
y1980,TLS,674.676,674.676,674.676,674.676,674.676,674.676,674.676,674.676,674.676,674.676
y1980,TON,251.251,251.251,251.251,251.251,251.251,251.251,251.251,251.251,251.251,251.251
y1980,TTO,15237.453,15237.453,15237.453,15237.453,15237.453,15237.453,15237.453,15237.453,15237.453,15237.453
y1980,TUN,22970.163,22970.163,22970.163,22970.163,22970.163,22970.163,22970.163,22970.163,22970.163,22970.163
y1980,TUR,265703.614,265703.614,265703.614,265703.614,265703.614,265703.614,265703.614,265703.614,265703.614,265703.614
y1980,TUV,13.782,13.782,13.782,13.782,13.782,13.782,13.782,13.782,13.782,13.782
y1980,TWN,105184.359,105184.359,105184.359,105184.359,105184.359,105184.359,105184.359,105184.359,105184.359,105184.359
y1980,TZA,14743.498,14743.498,14743.498,14743.498,14743.498,14743.498,14743.498,14743.498,14743.498,14743.498
y1980,UGA,6662.87,6662.87,6662.87,6662.87,6662.87,6662.87,6662.87,6662.87,6662.87,6662.87
y1980,UKR,356253.794,356253.794,356253.794,356253.794,356253.794,356253.794,356253.794,356253.794,356253.794,356253.794
y1980,UMI,5.978,5.978,5.978,5.978,5.978,5.978,5.978,5.978,5.978,5.978
y1980,URY,20455.684,20455.684,20455.684,20455.684,20455.684,20455.684,20455.684,20455.684,20455.684,20455.684
y1980,USA,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191,5777100.191
y1980,UZB,28359.291,28359.291,28359.291,28359.291,28359.291,28359.291,28359.291,28359.291,28359.291,28359.291
y1980,VAT,27.588,27.588,27.588,27.588,27.588,27.588,27.588,27.588,27.588,27.588
y1980,VCT,259.864,259.864,259.864,259.864,259.864,259.864,259.864,259.864,259.864,259.864
y1980,VEN,167817.483,167817.483,167817.483,167817.483,167817.483,167817.483,167817.483,167817.483,167817.483,167817.483
y1980,VGB,87.088,87.088,87.088,87.088,87.088,87.088,87.088,87.088,87.088,87.088
y1980,VIR,3553.07,3553.07,3553.07,3553.07,3553.07,3553.07,3553.07,3553.07,3553.07,3553.07
y1980,VNM,31563.337,31563.337,31563.337,31563.337,31563.337,31563.337,31563.337,31563.337,31563.337,31563.337
y1980,VUT,401.902,401.902,401.902,401.902,401.902,401.902,401.902,401.902,401.902,401.902
y1980,WLF,147.162,147.162,147.162,147.162,147.162,147.162,147.162,147.162,147.162,147.162
y1980,WSM,557.868,557.868,557.868,557.868,557.868,557.868,557.868,557.868,557.868,557.868
y1980,YEM,11920.207,11920.207,11920.207,11920.207,11920.207,11920.207,11920.207,11920.207,11920.207,11920.207
y1980,ZAF,229891.187,229891.187,229891.187,229891.187,229891.187,229891.187,229891.187,229891.187,229891.187,229891.187
y1980,ZMB,9976.638,9976.638,9976.638,9976.638,9976.638,9976.638,9976.638,9976.638,9976.638,9976.638
y1980,ZWE,4177.213,4177.213,4177.213,4177.213,4177.213,4177.213,4177.213,4177.213,4177.213,4177.213
y1985,ABW,1276.468,1276.468,1276.468,1276.468,1276.468,1276.468,1276.468,1276.468,1276.468,1276.468
y1985,AFG,9675.753,9675.753,9675.753,9675.753,9675.753,9675.753,9675.753,9675.753,9675.753,9675.753
y1985,AGO,28787.678,28787.678,28787.678,28787.678,28787.678,28787.678,28787.678,28787.678,28787.678,28787.678
y1985,AIA,81.276,81.276,81.276,81.276,81.276,81.276,81.276,81.276,81.276,81.276
y1985,ALA,1317.174,1317.174,1317.174,1317.174,1317.174,1317.174,1317.174,1317.174,1317.174,1317.174
y1985,ALB,10746.189,10746.189,10746.189,10746.189,10746.189,10746.189,10746.189,10746.189,10746.189,10746.189
y1985,AND,1721.421,1721.421,1721.421,1721.421,1721.421,1721.421,1721.421,1721.421,1721.421,1721.421
y1985,ARE,69296.243,69296.243,69296.243,69296.243,69296.243,69296.243,69296.243,69296.243,69296.243,69296.243
y1985,ARG,236389.542,236389.542,236389.542,236389.542,236389.542,236389.542,236389.542,236389.542,236389.542,236389.542
y1985,ARM,9237.037,9237.037,9237.037,9237.037,9237.037,9237.037,9237.037,9237.037,9237.037,9237.037
y1985,ASM,510.211,510.211,510.211,510.211,510.211,510.211,510.211,510.211,510.211,510.211
y1985,ATA,10,10,10,10,10,10,10,10,10,10
y1985,ATF,2.03,2.03,2.03,2.03,2.03,2.03,2.03,2.03,2.03,2.03
y1985,ATG,599.161,599.161,599.161,599.161,599.161,599.161,599.161,599.161,599.161,599.161
y1985,AUS,359261.915,359261.915,359261.915,359261.915,359261.915,359261.915,359261.915,359261.915,359261.915,359261.915
y1985,AUT,177465.092,177465.092,177465.092,177465.092,177465.092,177465.092,177465.092,177465.092,177465.092,177465.092
y1985,AZE,31153.751,31153.751,31153.751,31153.751,31153.751,31153.751,31153.751,31153.751,31153.751,31153.751
y1985,BDI,2121.726,2121.726,2121.726,2121.726,2121.726,2121.726,2121.726,2121.726,2121.726,2121.726
y1985,BEL,214835.304,214835.304,214835.304,214835.304,214835.304,214835.304,214835.304,214835.304,214835.304,214835.304
y1985,BEN,4937.437,4937.437,4937.437,4937.437,4937.437,4937.437,4937.437,4937.437,4937.437,4937.437
y1985,BES,228.513,228.513,228.513,228.513,228.513,228.513,228.513,228.513,228.513,228.513
y1985,BFA,5447.865,5447.865,5447.865,5447.865,5447.865,5447.865,5447.865,5447.865,5447.865,5447.865
y1985,BGD,63987.551,63987.551,63987.551,63987.551,63987.551,63987.551,63987.551,63987.551,63987.551,63987.551
y1985,BGR,64705.893,64705.893,64705.893,64705.893,64705.893,64705.893,64705.893,64705.893,64705.893,64705.893
y1985,BHR,7761.602,7761.602,7761.602,7761.602,7761.602,7761.602,7761.602,7761.602,7761.602,7761.602
y1985,BHS,5565.9,5565.9,5565.9,5565.9,5565.9,5565.9,5565.9,5565.9,5565.9,5565.9
y1985,BIH,5771.628,5771.628,5771.628,5771.628,5771.628,5771.628,5771.628,5771.628,5771.628,5771.628
y1985,BLM,158.678,158.678,158.678,158.678,158.678,158.678,158.678,158.678,158.678,158.678
y1985,BLR,60169.34,60169.34,60169.34,60169.34,60169.34,60169.34,60169.34,60169.34,60169.34,60169.34
y1985,BLZ,575.003,575.003,575.003,575.003,575.003,575.003,575.003,575.003,575.003,575.003
y1985,BMU,2843.747,2843.747,2843.747,2843.747,2843.747,2843.747,2843.747,2843.747,2843.747,2843.747
y1985,BOL,18300.692,18300.692,18300.692,18300.692,18300.692,18300.692,18300.692,18300.692,18300.692,18300.692
y1985,BRA,955529.786,955529.786,955529.786,955529.786,955529.786,955529.786,955529.786,955529.786,955529.786,955529.786
y1985,BRB,4392.467,4392.467,4392.467,4392.467,4392.467,4392.467,4392.467,4392.467,4392.467,4392.467
y1985,BRN,13597.408,13597.408,13597.408,13597.408,13597.408,13597.408,13597.408,13597.408,13597.408,13597.408
y1985,BTN,514.798,514.798,514.798,514.798,514.798,514.798,514.798,514.798,514.798,514.798
y1985,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1985,BWA,5421.149,5421.149,5421.149,5421.149,5421.149,5421.149,5421.149,5421.149,5421.149,5421.149
y1985,CAF,2380.493,2380.493,2380.493,2380.493,2380.493,2380.493,2380.493,2380.493,2380.493,2380.493
y1985,CAN,655134.598,655134.598,655134.598,655134.598,655134.598,655134.598,655134.598,655134.598,655134.598,655134.598
y1985,CCK,32.485,32.485,32.485,32.485,32.485,32.485,32.485,32.485,32.485,32.485
y1985,CHE,196869.137,196869.137,196869.137,196869.137,196869.137,196869.137,196869.137,196869.137,196869.137,196869.137
y1985,CHL,59807.52,59807.52,59807.52,59807.52,59807.52,59807.52,59807.52,59807.52,59807.52,59807.52
y1985,CHN,913299.737,913299.737,913299.737,913299.737,913299.737,913299.737,913299.737,913299.737,913299.737,913299.737
y1985,CIV,19771.48,19771.48,19771.48,19771.48,19771.48,19771.48,19771.48,19771.48,19771.48,19771.48
y1985,CMR,27106.952,27106.952,27106.952,27106.952,27106.952,27106.952,27106.952,27106.952,27106.952,27106.952
y1985,COD,20769.088,20769.088,20769.088,20769.088,20769.088,20769.088,20769.088,20769.088,20769.088,20769.088
y1985,COG,6705.18,6705.18,6705.18,6705.18,6705.18,6705.18,6705.18,6705.18,6705.18,6705.18
y1985,COK,161.27,161.27,161.27,161.27,161.27,161.27,161.27,161.27,161.27,161.27
y1985,COL,151747.353,151747.353,151747.353,151747.353,151747.353,151747.353,151747.353,151747.353,151747.353,151747.353
y1985,COM,474.393,474.393,474.393,474.393,474.393,474.393,474.393,474.393,474.393,474.393
y1985,CPV,456.973,456.973,456.973,456.973,456.973,456.973,456.973,456.973,456.973,456.973
y1985,CRI,16813.886,16813.886,16813.886,16813.886,16813.886,16813.886,16813.886,16813.886,16813.886,16813.886
y1985,CUB,79714.155,79714.155,79714.155,79714.155,79714.155,79714.155,79714.155,79714.155,79714.155,79714.155
y1985,CUW,2255.625,2255.625,2255.625,2255.625,2255.625,2255.625,2255.625,2255.625,2255.625,2255.625
y1985,CXR,99.8,99.8,99.8,99.8,99.8,99.8,99.8,99.8,99.8,99.8
y1985,CYM,768.458,768.458,768.458,768.458,768.458,768.458,768.458,768.458,768.458,768.458
y1985,CYP,9022.555,9022.555,9022.555,9022.555,9022.555,9022.555,9022.555,9022.555,9022.555,9022.555
y1985,CZE,155779.851,155779.851,155779.851,155779.851,155779.851,155779.851,155779.851,155779.851,155779.851,155779.851
y1985,DEU,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672,1732647.672
y1985,DJI,1530.611,1530.611,1530.611,1530.611,1530.611,1530.611,1530.611,1530.611,1530.611,1530.611
y1985,DMA,317.992,317.992,317.992,317.992,317.992,317.992,317.992,317.992,317.992,317.992
y1985,DNK,123376.233,123376.233,123376.233,123376.233,123376.233,123376.233,123376.233,123376.233,123376.233,123376.233
y1985,DOM,25336.582,25336.582,25336.582,25336.582,25336.582,25336.582,25336.582,25336.582,25336.582,25336.582
y1985,DZA,134250.729,134250.729,134250.729,134250.729,134250.729,134250.729,134250.729,134250.729,134250.729,134250.729
y1985,ECU,47882.619,47882.619,47882.619,47882.619,47882.619,47882.619,47882.619,47882.619,47882.619,47882.619
y1985,EGY,143944.871,143944.871,143944.871,143944.871,143944.871,143944.871,143944.871,143944.871,143944.871,143944.871
y1985,ERI,1322.129,1322.129,1322.129,1322.129,1322.129,1322.129,1322.129,1322.129,1322.129,1322.129
y1985,ESH,456.052,456.052,456.052,456.052,456.052,456.052,456.052,456.052,456.052,456.052
y1985,ESP,613195.173,613195.173,613195.173,613195.173,613195.173,613195.173,613195.173,613195.173,613195.173,613195.173
y1985,EST,14468.307,14468.307,14468.307,14468.307,14468.307,14468.307,14468.307,14468.307,14468.307,14468.307
y1985,ETH,19160.061,19160.061,19160.061,19160.061,19160.061,19160.061,19160.061,19160.061,19160.061,19160.061
y1985,FIN,99627.385,99627.385,99627.385,99627.385,99627.385,99627.385,99627.385,99627.385,99627.385,99627.385
y1985,FJI,2179.194,2179.194,2179.194,2179.194,2179.194,2179.194,2179.194,2179.194,2179.194,2179.194
y1985,FLK,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176,178.176
y1985,FRA,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904,1236494.904
y1985,FRO,1833.6,1833.6,1833.6,1833.6,1833.6,1833.6,1833.6,1833.6,1833.6,1833.6
y1985,FSM,242.01,242.01,242.01,242.01,242.01,242.01,242.01,242.01,242.01,242.01
y1985,GAB,12284.287,12284.287,12284.287,12284.287,12284.287,12284.287,12284.287,12284.287,12284.287,12284.287
y1985,GBR,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257,1155363.257
y1985,GEO,25306.813,25306.813,25306.813,25306.813,25306.813,25306.813,25306.813,25306.813,25306.813,25306.813
y1985,GGY,3000.637,3000.637,3000.637,3000.637,3000.637,3000.637,3000.637,3000.637,3000.637,3000.637
y1985,GHA,10453.921,10453.921,10453.921,10453.921,10453.921,10453.921,10453.921,10453.921,10453.921,10453.921
y1985,GIB,1641.899,1641.899,1641.899,1641.899,1641.899,1641.899,1641.899,1641.899,1641.899,1641.899
y1985,GIN,4039.61,4039.61,4039.61,4039.61,4039.61,4039.61,4039.61,4039.61,4039.61,4039.61
y1985,GLP,9775.26,9775.26,9775.26,9775.26,9775.26,9775.26,9775.26,9775.26,9775.26,9775.26
y1985,GMB,857.066,857.066,857.066,857.066,857.066,857.066,857.066,857.066,857.066,857.066
y1985,GNB,833.972,833.972,833.972,833.972,833.972,833.972,833.972,833.972,833.972,833.972
y1985,GNQ,458.28,458.28,458.28,458.28,458.28,458.28,458.28,458.28,458.28,458.28
y1985,GRC,169035.79,169035.79,169035.79,169035.79,169035.79,169035.79,169035.79,169035.79,169035.79,169035.79
y1985,GRD,469.66,469.66,469.66,469.66,469.66,469.66,469.66,469.66,469.66,469.66
y1985,GRL,2115.746,2115.746,2115.746,2115.746,2115.746,2115.746,2115.746,2115.746,2115.746,2115.746
y1985,GTM,31595.2,31595.2,31595.2,31595.2,31595.2,31595.2,31595.2,31595.2,31595.2,31595.2
y1985,GUF,1839.702,1839.702,1839.702,1839.702,1839.702,1839.702,1839.702,1839.702,1839.702,1839.702
y1985,GUM,3555.568,3555.568,3555.568,3555.568,3555.568,3555.568,3555.568,3555.568,3555.568,3555.568
y1985,GUY,1791.908,1791.908,1791.908,1791.908,1791.908,1791.908,1791.908,1791.908,1791.908,1791.908
y1985,HKG,91565.894,91565.894,91565.894,91565.894,91565.894,91565.894,91565.894,91565.894,91565.894,91565.894
y1985,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1985,HND,12550.023,12550.023,12550.023,12550.023,12550.023,12550.023,12550.023,12550.023,12550.023,12550.023
y1985,HRV,57116.868,57116.868,57116.868,57116.868,57116.868,57116.868,57116.868,57116.868,57116.868,57116.868
y1985,HTI,10888.264,10888.264,10888.264,10888.264,10888.264,10888.264,10888.264,10888.264,10888.264,10888.264
y1985,HUN,123815.035,123815.035,123815.035,123815.035,123815.035,123815.035,123815.035,123815.035,123815.035,123815.035
y1985,IDN,284236.808,284236.808,284236.808,284236.808,284236.808,284236.808,284236.808,284236.808,284236.808,284236.808
y1985,IMN,5452.132,5452.132,5452.132,5452.132,5452.132,5452.132,5452.132,5452.132,5452.132,5452.132
y1985,IND,836030.025,836030.025,836030.025,836030.025,836030.025,836030.025,836030.025,836030.025,836030.025,836030.025
y1985,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1985,IRL,50195.159,50195.159,50195.159,50195.159,50195.159,50195.159,50195.159,50195.159,50195.159,50195.159
y1985,IRN,326106.379,326106.379,326106.379,326106.379,326106.379,326106.379,326106.379,326106.379,326106.379,326106.379
y1985,IRQ,94758.516,94758.516,94758.516,94758.516,94758.516,94758.516,94758.516,94758.516,94758.516,94758.516
y1985,ISL,5784.397,5784.397,5784.397,5784.397,5784.397,5784.397,5784.397,5784.397,5784.397,5784.397
y1985,ISR,67881.15,67881.15,67881.15,67881.15,67881.15,67881.15,67881.15,67881.15,67881.15,67881.15
y1985,ITA,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107,1168936.107
y1985,JAM,13705.96,13705.96,13705.96,13705.96,13705.96,13705.96,13705.96,13705.96,13705.96,13705.96
y1985,JEY,4266.999,4266.999,4266.999,4266.999,4266.999,4266.999,4266.999,4266.999,4266.999,4266.999
y1985,JOR,12145.454,12145.454,12145.454,12145.454,12145.454,12145.454,12145.454,12145.454,12145.454,12145.454
y1985,JPN,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414,2612324.414
y1985,KAZ,102077.708,102077.708,102077.708,102077.708,102077.708,102077.708,102077.708,102077.708,102077.708,102077.708
y1985,KEN,23636.061,23636.061,23636.061,23636.061,23636.061,23636.061,23636.061,23636.061,23636.061,23636.061
y1985,KGZ,9176.285,9176.285,9176.285,9176.285,9176.285,9176.285,9176.285,9176.285,9176.285,9176.285
y1985,KHM,4549.13,4549.13,4549.13,4549.13,4549.13,4549.13,4549.13,4549.13,4549.13,4549.13
y1985,KIR,178.636,178.636,178.636,178.636,178.636,178.636,178.636,178.636,178.636,178.636
y1985,KNA,226.838,226.838,226.838,226.838,226.838,226.838,226.838,226.838,226.838,226.838
y1985,KOR,295926.234,295926.234,295926.234,295926.234,295926.234,295926.234,295926.234,295926.234,295926.234,295926.234
y1985,KWT,50700.596,50700.596,50700.596,50700.596,50700.596,50700.596,50700.596,50700.596,50700.596,50700.596
y1985,LAO,3471.878,3471.878,3471.878,3471.878,3471.878,3471.878,3471.878,3471.878,3471.878,3471.878
y1985,LBN,42598.086,42598.086,42598.086,42598.086,42598.086,42598.086,42598.086,42598.086,42598.086,42598.086
y1985,LBR,2687.261,2687.261,2687.261,2687.261,2687.261,2687.261,2687.261,2687.261,2687.261,2687.261
y1985,LBY,77206.392,77206.392,77206.392,77206.392,77206.392,77206.392,77206.392,77206.392,77206.392,77206.392
y1985,LCA,703.782,703.782,703.782,703.782,703.782,703.782,703.782,703.782,703.782,703.782
y1985,LIE,2670.592,2670.592,2670.592,2670.592,2670.592,2670.592,2670.592,2670.592,2670.592,2670.592
y1985,LKA,29372.608,29372.608,29372.608,29372.608,29372.608,29372.608,29372.608,29372.608,29372.608,29372.608
y1985,LSO,1146.964,1146.964,1146.964,1146.964,1146.964,1146.964,1146.964,1146.964,1146.964,1146.964
y1985,LTU,42005.493,42005.493,42005.493,42005.493,42005.493,42005.493,42005.493,42005.493,42005.493,42005.493
y1985,LUX,11517.784,11517.784,11517.784,11517.784,11517.784,11517.784,11517.784,11517.784,11517.784,11517.784
y1985,LVA,25283.544,25283.544,25283.544,25283.544,25283.544,25283.544,25283.544,25283.544,25283.544,25283.544
y1985,MAC,4511.158,4511.158,4511.158,4511.158,4511.158,4511.158,4511.158,4511.158,4511.158,4511.158
y1985,MAF,139.221,139.221,139.221,139.221,139.221,139.221,139.221,139.221,139.221,139.221
y1985,MAR,52755.963,52755.963,52755.963,52755.963,52755.963,52755.963,52755.963,52755.963,52755.963,52755.963
y1985,MCO,4788.825,4788.825,4788.825,4788.825,4788.825,4788.825,4788.825,4788.825,4788.825,4788.825
y1985,MDA,13738.956,13738.956,13738.956,13738.956,13738.956,13738.956,13738.956,13738.956,13738.956,13738.956
y1985,MDG,9884.041,9884.041,9884.041,9884.041,9884.041,9884.041,9884.041,9884.041,9884.041,9884.041
y1985,MDV,328.526,328.526,328.526,328.526,328.526,328.526,328.526,328.526,328.526,328.526
y1985,MEX,759404.727,759404.727,759404.727,759404.727,759404.727,759404.727,759404.727,759404.727,759404.727,759404.727
y1985,MHL,203.788,203.788,203.788,203.788,203.788,203.788,203.788,203.788,203.788,203.788
y1985,MKD,15000.399,15000.399,15000.399,15000.399,15000.399,15000.399,15000.399,15000.399,15000.399,15000.399
y1985,MLI,4834.257,4834.257,4834.257,4834.257,4834.257,4834.257,4834.257,4834.257,4834.257,4834.257
y1985,MLT,3604.955,3604.955,3604.955,3604.955,3604.955,3604.955,3604.955,3604.955,3604.955,3604.955
y1985,MMR,13284.068,13284.068,13284.068,13284.068,13284.068,13284.068,13284.068,13284.068,13284.068,13284.068
y1985,MNE,5933.127,5933.127,5933.127,5933.127,5933.127,5933.127,5933.127,5933.127,5933.127,5933.127
y1985,MNG,4406.692,4406.692,4406.692,4406.692,4406.692,4406.692,4406.692,4406.692,4406.692,4406.692
y1985,MNP,403.535,403.535,403.535,403.535,403.535,403.535,403.535,403.535,403.535,403.535
y1985,MOZ,4067.545,4067.545,4067.545,4067.545,4067.545,4067.545,4067.545,4067.545,4067.545,4067.545
y1985,MRT,2567.768,2567.768,2567.768,2567.768,2567.768,2567.768,2567.768,2567.768,2567.768,2567.768
y1985,MSR,96.262,96.262,96.262,96.262,96.262,96.262,96.262,96.262,96.262,96.262
y1985,MTQ,9993.668,9993.668,9993.668,9993.668,9993.668,9993.668,9993.668,9993.668,9993.668,9993.668
y1985,MUS,4108.607,4108.607,4108.607,4108.607,4108.607,4108.607,4108.607,4108.607,4108.607,4108.607
y1985,MWI,4851.049,4851.049,4851.049,4851.049,4851.049,4851.049,4851.049,4851.049,4851.049,4851.049
y1985,MYS,82282.516,82282.516,82282.516,82282.516,82282.516,82282.516,82282.516,82282.516,82282.516,82282.516
y1985,MYT,757.092,757.092,757.092,757.092,757.092,757.092,757.092,757.092,757.092,757.092
y1985,NAM,4653.234,4653.234,4653.234,4653.234,4653.234,4653.234,4653.234,4653.234,4653.234,4653.234
y1985,NCL,5432.946,5432.946,5432.946,5432.946,5432.946,5432.946,5432.946,5432.946,5432.946,5432.946
y1985,NER,4508.119,4508.119,4508.119,4508.119,4508.119,4508.119,4508.119,4508.119,4508.119,4508.119
y1985,NFK,15.843,15.843,15.843,15.843,15.843,15.843,15.843,15.843,15.843,15.843
y1985,NGA,112581.713,112581.713,112581.713,112581.713,112581.713,112581.713,112581.713,112581.713,112581.713,112581.713
y1985,NIC,10454.385,10454.385,10454.385,10454.385,10454.385,10454.385,10454.385,10454.385,10454.385,10454.385
y1985,NIU,15.747,15.747,15.747,15.747,15.747,15.747,15.747,15.747,15.747,15.747
y1985,NLD,342039.904,342039.904,342039.904,342039.904,342039.904,342039.904,342039.904,342039.904,342039.904,342039.904
y1985,NOR,125074.903,125074.903,125074.903,125074.903,125074.903,125074.903,125074.903,125074.903,125074.903,125074.903
y1985,NPL,11522.697,11522.697,11522.697,11522.697,11522.697,11522.697,11522.697,11522.697,11522.697,11522.697
y1985,NRU,214.013,214.013,214.013,214.013,214.013,214.013,214.013,214.013,214.013,214.013
y1985,NZL,61851.865,61851.865,61851.865,61851.865,61851.865,61851.865,61851.865,61851.865,61851.865,61851.865
y1985,OMN,22728.708,22728.708,22728.708,22728.708,22728.708,22728.708,22728.708,22728.708,22728.708,22728.708
y1985,PAK,140736.253,140736.253,140736.253,140736.253,140736.253,140736.253,140736.253,140736.253,140736.253,140736.253
y1985,PAN,13892.894,13892.894,13892.894,13892.894,13892.894,13892.894,13892.894,13892.894,13892.894,13892.894
y1985,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1985,PER,100550.179,100550.179,100550.179,100550.179,100550.179,100550.179,100550.179,100550.179,100550.179,100550.179
y1985,PHL,111352.179,111352.179,111352.179,111352.179,111352.179,111352.179,111352.179,111352.179,111352.179,111352.179
y1985,PLW,180.876,180.876,180.876,180.876,180.876,180.876,180.876,180.876,180.876,180.876
y1985,PNG,6926.404,6926.404,6926.404,6926.404,6926.404,6926.404,6926.404,6926.404,6926.404,6926.404
y1985,POL,301477.194,301477.194,301477.194,301477.194,301477.194,301477.194,301477.194,301477.194,301477.194,301477.194
y1985,PRI,47213.33,47213.33,47213.33,47213.33,47213.33,47213.33,47213.33,47213.33,47213.33,47213.33
y1985,PRK,45239.395,45239.395,45239.395,45239.395,45239.395,45239.395,45239.395,45239.395,45239.395,45239.395
y1985,PRT,115169.108,115169.108,115169.108,115169.108,115169.108,115169.108,115169.108,115169.108,115169.108,115169.108
y1985,PRY,13858.679,13858.679,13858.679,13858.679,13858.679,13858.679,13858.679,13858.679,13858.679,13858.679
y1985,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1985,PYF,3756.652,3756.652,3756.652,3756.652,3756.652,3756.652,3756.652,3756.652,3756.652,3756.652
y1985,QAT,21646.487,21646.487,21646.487,21646.487,21646.487,21646.487,21646.487,21646.487,21646.487,21646.487
y1985,REU,14858.627,14858.627,14858.627,14858.627,14858.627,14858.627,14858.627,14858.627,14858.627,14858.627
y1985,ROU,187064.538,187064.538,187064.538,187064.538,187064.538,187064.538,187064.538,187064.538,187064.538,187064.538
y1985,RUS,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698,1781754.698
y1985,RWA,4850.381,4850.381,4850.381,4850.381,4850.381,4850.381,4850.381,4850.381,4850.381,4850.381
y1985,SAU,257533.825,257533.825,257533.825,257533.825,257533.825,257533.825,257533.825,257533.825,257533.825,257533.825
y1985,SDN,17532.069,17532.069,17532.069,17532.069,17532.069,17532.069,17532.069,17532.069,17532.069,17532.069
y1985,SEN,8605.332,8605.332,8605.332,8605.332,8605.332,8605.332,8605.332,8605.332,8605.332,8605.332
y1985,SGP,48579.406,48579.406,48579.406,48579.406,48579.406,48579.406,48579.406,48579.406,48579.406,48579.406
y1985,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1985,SHN,43.571,43.571,43.571,43.571,43.571,43.571,43.571,43.571,43.571,43.571
y1985,SJM,153.979,153.979,153.979,153.979,153.979,153.979,153.979,153.979,153.979,153.979
y1985,SLB,604.915,604.915,604.915,604.915,604.915,604.915,604.915,604.915,604.915,604.915
y1985,SLE,3595.442,3595.442,3595.442,3595.442,3595.442,3595.442,3595.442,3595.442,3595.442,3595.442
y1985,SLV,18864.302,18864.302,18864.302,18864.302,18864.302,18864.302,18864.302,18864.302,18864.302,18864.302
y1985,SMR,800.942,800.942,800.942,800.942,800.942,800.942,800.942,800.942,800.942,800.942
y1985,SOM,5572.811,5572.811,5572.811,5572.811,5572.811,5572.811,5572.811,5572.811,5572.811,5572.811
y1985,SPM,256.494,256.494,256.494,256.494,256.494,256.494,256.494,256.494,256.494,256.494
y1985,SRB,18075.344,18075.344,18075.344,18075.344,18075.344,18075.344,18075.344,18075.344,18075.344,18075.344
y1985,SSD,8167.361,8167.361,8167.361,8167.361,8167.361,8167.361,8167.361,8167.361,8167.361,8167.361
y1985,STP,138.113,138.113,138.113,138.113,138.113,138.113,138.113,138.113,138.113,138.113
y1985,SUR,2735.707,2735.707,2735.707,2735.707,2735.707,2735.707,2735.707,2735.707,2735.707,2735.707
y1985,SVK,57709.186,57709.186,57709.186,57709.186,57709.186,57709.186,57709.186,57709.186,57709.186,57709.186
y1985,SVN,28241.596,28241.596,28241.596,28241.596,28241.596,28241.596,28241.596,28241.596,28241.596,28241.596
y1985,SWE,191461.408,191461.408,191461.408,191461.408,191461.408,191461.408,191461.408,191461.408,191461.408,191461.408
y1985,SWZ,1818.581,1818.581,1818.581,1818.581,1818.581,1818.581,1818.581,1818.581,1818.581,1818.581
y1985,SXM,1255.782,1255.782,1255.782,1255.782,1255.782,1255.782,1255.782,1255.782,1255.782,1255.782
y1985,SYC,692.35,692.35,692.35,692.35,692.35,692.35,692.35,692.35,692.35,692.35
y1985,SYR,34319.764,34319.764,34319.764,34319.764,34319.764,34319.764,34319.764,34319.764,34319.764,34319.764
y1985,TCA,165.87,165.87,165.87,165.87,165.87,165.87,165.87,165.87,165.87,165.87
y1985,TCD,4363.498,4363.498,4363.498,4363.498,4363.498,4363.498,4363.498,4363.498,4363.498,4363.498
y1985,TGO,3064.26,3064.26,3064.26,3064.26,3064.26,3064.26,3064.26,3064.26,3064.26,3064.26
y1985,THA,143950.45,143950.45,143950.45,143950.45,143950.45,143950.45,143950.45,143950.45,143950.45,143950.45
y1985,TJK,12643.737,12643.737,12643.737,12643.737,12643.737,12643.737,12643.737,12643.737,12643.737,12643.737
y1985,TKL,1.713,1.713,1.713,1.713,1.713,1.713,1.713,1.713,1.713,1.713
y1985,TKM,14226.544,14226.544,14226.544,14226.544,14226.544,14226.544,14226.544,14226.544,14226.544,14226.544
y1985,TLS,769.995,769.995,769.995,769.995,769.995,769.995,769.995,769.995,769.995,769.995
y1985,TON,410.289,410.289,410.289,410.289,410.289,410.289,410.289,410.289,410.289,410.289
y1985,TTO,13251.872,13251.872,13251.872,13251.872,13251.872,13251.872,13251.872,13251.872,13251.872,13251.872
y1985,TUN,28455.592,28455.592,28455.592,28455.592,28455.592,28455.592,28455.592,28455.592,28455.592,28455.592
y1985,TUR,312243.419,312243.419,312243.419,312243.419,312243.419,312243.419,312243.419,312243.419,312243.419,312243.419
y1985,TUV,13.69,13.69,13.69,13.69,13.69,13.69,13.69,13.69,13.69,13.69
y1985,TWN,141653.625,141653.625,141653.625,141653.625,141653.625,141653.625,141653.625,141653.625,141653.625,141653.625
y1985,TZA,15620.63,15620.63,15620.63,15620.63,15620.63,15620.63,15620.63,15620.63,15620.63,15620.63
y1985,UGA,7520.24,7520.24,7520.24,7520.24,7520.24,7520.24,7520.24,7520.24,7520.24,7520.24
y1985,UKR,386102.134,386102.134,386102.134,386102.134,386102.134,386102.134,386102.134,386102.134,386102.134,386102.134
y1985,UMI,6.68,6.68,6.68,6.68,6.68,6.68,6.68,6.68,6.68,6.68
y1985,URY,17787.5,17787.5,17787.5,17787.5,17787.5,17787.5,17787.5,17787.5,17787.5,17787.5
y1985,USA,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354,6798007.354
y1985,UZB,33679.446,33679.446,33679.446,33679.446,33679.446,33679.446,33679.446,33679.446,33679.446,33679.446
y1985,VAT,28.386,28.386,28.386,28.386,28.386,28.386,28.386,28.386,28.386,28.386
y1985,VCT,332.58,332.58,332.58,332.58,332.58,332.58,332.58,332.58,332.58,332.58
y1985,VEN,157994.913,157994.913,157994.913,157994.913,157994.913,157994.913,157994.913,157994.913,157994.913,157994.913
y1985,VGB,101.609,101.609,101.609,101.609,101.609,101.609,101.609,101.609,101.609,101.609
y1985,VIR,3778.515,3778.515,3778.515,3778.515,3778.515,3778.515,3778.515,3778.515,3778.515,3778.515
y1985,VNM,48578.268,48578.268,48578.268,48578.268,48578.268,48578.268,48578.268,48578.268,48578.268,48578.268
y1985,VUT,542.666,542.666,542.666,542.666,542.666,542.666,542.666,542.666,542.666,542.666
y1985,WLF,177.322,177.322,177.322,177.322,177.322,177.322,177.322,177.322,177.322,177.322
y1985,WSM,533.259,533.259,533.259,533.259,533.259,533.259,533.259,533.259,533.259,533.259
y1985,YEM,14975.621,14975.621,14975.621,14975.621,14975.621,14975.621,14975.621,14975.621,14975.621,14975.621
y1985,ZAF,243408.351,243408.351,243408.351,243408.351,243408.351,243408.351,243408.351,243408.351,243408.351,243408.351
y1985,ZMB,9818.749,9818.749,9818.749,9818.749,9818.749,9818.749,9818.749,9818.749,9818.749,9818.749
y1985,ZWE,4992.048,4992.048,4992.048,4992.048,4992.048,4992.048,4992.048,4992.048,4992.048,4992.048
y1990,ABW,2201.751,2201.751,2201.751,2201.751,2201.751,2201.751,2201.751,2201.751,2201.751,2201.751
y1990,AFG,7696,7696,7696,7696,7696,7696,7696,7696,7696,7696
y1990,AGO,35048.906,35048.906,35048.906,35048.906,35048.906,35048.906,35048.906,35048.906,35048.906,35048.906
y1990,AIA,101.675,101.675,101.675,101.675,101.675,101.675,101.675,101.675,101.675,101.675
y1990,ALA,1363.233,1363.233,1363.233,1363.233,1363.233,1363.233,1363.233,1363.233,1363.233,1363.233
y1990,ALB,11156.729,11156.729,11156.729,11156.729,11156.729,11156.729,11156.729,11156.729,11156.729,11156.729
y1990,AND,2346.947,2346.947,2346.947,2346.947,2346.947,2346.947,2346.947,2346.947,2346.947,2346.947
y1990,ARE,79320.163,79320.163,79320.163,79320.163,79320.163,79320.163,79320.163,79320.163,79320.163,79320.163
y1990,ARG,240392.078,240392.078,240392.078,240392.078,240392.078,240392.078,240392.078,240392.078,240392.078,240392.078
y1990,ARM,10355.487,10355.487,10355.487,10355.487,10355.487,10355.487,10355.487,10355.487,10355.487,10355.487
y1990,ASM,611.572,611.572,611.572,611.572,611.572,611.572,611.572,611.572,611.572,611.572
y1990,ATA,10,10,10,10,10,10,10,10,10,10
y1990,ATF,2.211,2.211,2.211,2.211,2.211,2.211,2.211,2.211,2.211,2.211
y1990,ATG,796.884,796.884,796.884,796.884,796.884,796.884,796.884,796.884,796.884,796.884
y1990,AUS,422292.453,422292.453,422292.453,422292.453,422292.453,422292.453,422292.453,422292.453,422292.453,422292.453
y1990,AUT,203776.896,203776.896,203776.896,203776.896,203776.896,203776.896,203776.896,203776.896,203776.896,203776.896
y1990,AZE,34844.206,34844.206,34844.206,34844.206,34844.206,34844.206,34844.206,34844.206,34844.206,34844.206
y1990,BDI,2565.898,2565.898,2565.898,2565.898,2565.898,2565.898,2565.898,2565.898,2565.898,2565.898
y1990,BEL,252261.604,252261.604,252261.604,252261.604,252261.604,252261.604,252261.604,252261.604,252261.604,252261.604
y1990,BEN,5346.422,5346.422,5346.422,5346.422,5346.422,5346.422,5346.422,5346.422,5346.422,5346.422
y1990,BES,247.266,247.266,247.266,247.266,247.266,247.266,247.266,247.266,247.266,247.266
y1990,BFA,6215.502,6215.502,6215.502,6215.502,6215.502,6215.502,6215.502,6215.502,6215.502,6215.502
y1990,BGD,77837.91,77837.91,77837.91,77837.91,77837.91,77837.91,77837.91,77837.91,77837.91,77837.91
y1990,BGR,67566.452,67566.452,67566.452,67566.452,67566.452,67566.452,67566.452,67566.452,67566.452,67566.452
y1990,BHR,9366.118,9366.118,9366.118,9366.118,9366.118,9366.118,9366.118,9366.118,9366.118,9366.118
y1990,BHS,6218.294,6218.294,6218.294,6218.294,6218.294,6218.294,6218.294,6218.294,6218.294,6218.294
y1990,BIH,7736.262,7736.262,7736.262,7736.262,7736.262,7736.262,7736.262,7736.262,7736.262,7736.262
y1990,BLM,173.42,173.42,173.42,173.42,173.42,173.42,173.42,173.42,173.42,173.42
y1990,BLR,64296.075,64296.075,64296.075,64296.075,64296.075,64296.075,64296.075,64296.075,64296.075,64296.075
y1990,BLZ,954.158,954.158,954.158,954.158,954.158,954.158,954.158,954.158,954.158,954.158
y1990,BMU,3079.596,3079.596,3079.596,3079.596,3079.596,3079.596,3079.596,3079.596,3079.596,3079.596
y1990,BOL,20283.937,20283.937,20283.937,20283.937,20283.937,20283.937,20283.937,20283.937,20283.937,20283.937
y1990,BRA,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545,1064027.545
y1990,BRB,4938.631,4938.631,4938.631,4938.631,4938.631,4938.631,4938.631,4938.631,4938.631,4938.631
y1990,BRN,13313.112,13313.112,13313.112,13313.112,13313.112,13313.112,13313.112,13313.112,13313.112,13313.112
y1990,BTN,921.788,921.788,921.788,921.788,921.788,921.788,921.788,921.788,921.788,921.788
y1990,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1990,BWA,9396.663,9396.663,9396.663,9396.663,9396.663,9396.663,9396.663,9396.663,9396.663,9396.663
y1990,CAF,2378.175,2378.175,2378.175,2378.175,2378.175,2378.175,2378.175,2378.175,2378.175,2378.175
y1990,CAN,756636.654,756636.654,756636.654,756636.654,756636.654,756636.654,756636.654,756636.654,756636.654,756636.654
y1990,CCK,31.686,31.686,31.686,31.686,31.686,31.686,31.686,31.686,31.686,31.686
y1990,CHE,227915.246,227915.246,227915.246,227915.246,227915.246,227915.246,227915.246,227915.246,227915.246,227915.246
y1990,CHL,83031.054,83031.054,83031.054,83031.054,83031.054,83031.054,83031.054,83031.054,83031.054,83031.054
y1990,CHN,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163,1306247.163
y1990,CIV,21932.291,21932.291,21932.291,21932.291,21932.291,21932.291,21932.291,21932.291,21932.291,21932.291
y1990,CMR,24085.047,24085.047,24085.047,24085.047,24085.047,24085.047,24085.047,24085.047,24085.047,24085.047
y1990,COD,21709.033,21709.033,21709.033,21709.033,21709.033,21709.033,21709.033,21709.033,21709.033,21709.033
y1990,COG,7904.091,7904.091,7904.091,7904.091,7904.091,7904.091,7904.091,7904.091,7904.091,7904.091
y1990,COK,160.278,160.278,160.278,160.278,160.278,160.278,160.278,160.278,160.278,160.278
y1990,COL,189753.122,189753.122,189753.122,189753.122,189753.122,189753.122,189753.122,189753.122,189753.122,189753.122
y1990,COM,502.55,502.55,502.55,502.55,502.55,502.55,502.55,502.55,502.55,502.55
y1990,CPV,531.077,531.077,531.077,531.077,531.077,531.077,531.077,531.077,531.077,531.077
y1990,CRI,20648.491,20648.491,20648.491,20648.491,20648.491,20648.491,20648.491,20648.491,20648.491,20648.491
y1990,CUB,80229.158,80229.158,80229.158,80229.158,80229.158,80229.158,80229.158,80229.158,80229.158,80229.158
y1990,CUW,2200.11,2200.11,2200.11,2200.11,2200.11,2200.11,2200.11,2200.11,2200.11,2200.11
y1990,CXR,97.255,97.255,97.255,97.255,97.255,97.255,97.255,97.255,97.255,97.255
y1990,CYM,1294.383,1294.383,1294.383,1294.383,1294.383,1294.383,1294.383,1294.383,1294.383,1294.383
y1990,CYP,12998.324,12998.324,12998.324,12998.324,12998.324,12998.324,12998.324,12998.324,12998.324,12998.324
y1990,CZE,167447.884,167447.884,167447.884,167447.884,167447.884,167447.884,167447.884,167447.884,167447.884,167447.884
y1990,DEU,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252,2037785.252
y1990,DJI,1829.744,1829.744,1829.744,1829.744,1829.744,1829.744,1829.744,1829.744,1829.744,1829.744
y1990,DMA,406.54,406.54,406.54,406.54,406.54,406.54,406.54,406.54,406.54,406.54
y1990,DNK,132694.267,132694.267,132694.267,132694.267,132694.267,132694.267,132694.267,132694.267,132694.267,132694.267
y1990,DOM,28992.969,28992.969,28992.969,28992.969,28992.969,28992.969,28992.969,28992.969,28992.969,28992.969
y1990,DZA,142586.453,142586.453,142586.453,142586.453,142586.453,142586.453,142586.453,142586.453,142586.453,142586.453
y1990,ECU,52739.307,52739.307,52739.307,52739.307,52739.307,52739.307,52739.307,52739.307,52739.307,52739.307
y1990,EGY,179230.486,179230.486,179230.486,179230.486,179230.486,179230.486,179230.486,179230.486,179230.486,179230.486
y1990,ERI,1510.897,1510.897,1510.897,1510.897,1510.897,1510.897,1510.897,1510.897,1510.897,1510.897
y1990,ESH,542.07,542.07,542.07,542.07,542.07,542.07,542.07,542.07,542.07,542.07
y1990,ESP,767769.143,767769.143,767769.143,767769.143,767769.143,767769.143,767769.143,767769.143,767769.143,767769.143
y1990,EST,15297.451,15297.451,15297.451,15297.451,15297.451,15297.451,15297.451,15297.451,15297.451,15297.451
y1990,ETH,24146.981,24146.981,24146.981,24146.981,24146.981,24146.981,24146.981,24146.981,24146.981,24146.981
y1990,FIN,117176.541,117176.541,117176.541,117176.541,117176.541,117176.541,117176.541,117176.541,117176.541,117176.541
y1990,FJI,2556.513,2556.513,2556.513,2556.513,2556.513,2556.513,2556.513,2556.513,2556.513,2556.513
y1990,FLK,191.328,191.328,191.328,191.328,191.328,191.328,191.328,191.328,191.328,191.328
y1990,FRA,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989,1457996.989
y1990,FRO,1921.24,1921.24,1921.24,1921.24,1921.24,1921.24,1921.24,1921.24,1921.24,1921.24
y1990,FSM,284.505,284.505,284.505,284.505,284.505,284.505,284.505,284.505,284.505,284.505
y1990,GAB,12955.197,12955.197,12955.197,12955.197,12955.197,12955.197,12955.197,12955.197,12955.197,12955.197
y1990,GBR,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21,1361996.21
y1990,GEO,27462.043,27462.043,27462.043,27462.043,27462.043,27462.043,27462.043,27462.043,27462.043,27462.043
y1990,GGY,3037.597,3037.597,3037.597,3037.597,3037.597,3037.597,3037.597,3037.597,3037.597,3037.597
y1990,GHA,13106.222,13106.222,13106.222,13106.222,13106.222,13106.222,13106.222,13106.222,13106.222,13106.222
y1990,GIB,1655.596,1655.596,1655.596,1655.596,1655.596,1655.596,1655.596,1655.596,1655.596,1655.596
y1990,GIN,5033.198,5033.198,5033.198,5033.198,5033.198,5033.198,5033.198,5033.198,5033.198,5033.198
y1990,GLP,10627.695,10627.695,10627.695,10627.695,10627.695,10627.695,10627.695,10627.695,10627.695,10627.695
y1990,GMB,1057.142,1057.142,1057.142,1057.142,1057.142,1057.142,1057.142,1057.142,1057.142,1057.142
y1990,GNB,969.873,969.873,969.873,969.873,969.873,969.873,969.873,969.873,969.873,969.873
y1990,GNQ,460.263,460.263,460.263,460.263,460.263,460.263,460.263,460.263,460.263,460.263
y1990,GRC,180489.438,180489.438,180489.438,180489.438,180489.438,180489.438,180489.438,180489.438,180489.438,180489.438
y1990,GRD,653.84,653.84,653.84,653.84,653.84,653.84,653.84,653.84,653.84,653.84
y1990,GRL,2373.443,2373.443,2373.443,2373.443,2373.443,2373.443,2373.443,2373.443,2373.443,2373.443
y1990,GTM,35556.515,35556.515,35556.515,35556.515,35556.515,35556.515,35556.515,35556.515,35556.515,35556.515
y1990,GUF,2464.188,2464.188,2464.188,2464.188,2464.188,2464.188,2464.188,2464.188,2464.188,2464.188
y1990,GUM,3979.701,3979.701,3979.701,3979.701,3979.701,3979.701,3979.701,3979.701,3979.701,3979.701
y1990,GUY,1521.93,1521.93,1521.93,1521.93,1521.93,1521.93,1521.93,1521.93,1521.93,1521.93
y1990,HKG,132754.839,132754.839,132754.839,132754.839,132754.839,132754.839,132754.839,132754.839,132754.839,132754.839
y1990,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1990,HND,14497.451,14497.451,14497.451,14497.451,14497.451,14497.451,14497.451,14497.451,14497.451,14497.451
y1990,HRV,60529.379,60529.379,60529.379,60529.379,60529.379,60529.379,60529.379,60529.379,60529.379,60529.379
y1990,HTI,10891.99,10891.99,10891.99,10891.99,10891.99,10891.99,10891.99,10891.99,10891.99,10891.99
y1990,HUN,126291.374,126291.374,126291.374,126291.374,126291.374,126291.374,126291.374,126291.374,126291.374,126291.374
y1990,IDN,395731.85,395731.85,395731.85,395731.85,395731.85,395731.85,395731.85,395731.85,395731.85,395731.85
y1990,IMN,5948.395,5948.395,5948.395,5948.395,5948.395,5948.395,5948.395,5948.395,5948.395,5948.395
y1990,IND,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607,1116854.607
y1990,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1990,IRL,61870.505,61870.505,61870.505,61870.505,61870.505,61870.505,61870.505,61870.505,61870.505,61870.505
y1990,IRN,346007.677,346007.677,346007.677,346007.677,346007.677,346007.677,346007.677,346007.677,346007.677,346007.677
y1990,IRQ,103546.828,103546.828,103546.828,103546.828,103546.828,103546.828,103546.828,103546.828,103546.828,103546.828
y1990,ISL,6768.12,6768.12,6768.12,6768.12,6768.12,6768.12,6768.12,6768.12,6768.12,6768.12
y1990,ISR,84339.756,84339.756,84339.756,84339.756,84339.756,84339.756,84339.756,84339.756,84339.756,84339.756
y1990,ITA,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742,1366600.742
y1990,JAM,17243.735,17243.735,17243.735,17243.735,17243.735,17243.735,17243.735,17243.735,17243.735,17243.735
y1990,JEY,4319.519,4319.519,4319.519,4319.519,4319.519,4319.519,4319.519,4319.519,4319.519,4319.519
y1990,JOR,12141.88,12141.88,12141.88,12141.88,12141.88,12141.88,12141.88,12141.88,12141.88,12141.88
y1990,JPN,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964,3326297.964
y1990,KAZ,113533.95,113533.95,113533.95,113533.95,113533.95,113533.95,113533.95,113533.95,113533.95,113533.95
y1990,KEN,31526.828,31526.828,31526.828,31526.828,31526.828,31526.828,31526.828,31526.828,31526.828,31526.828
y1990,KGZ,10965.516,10965.516,10965.516,10965.516,10965.516,10965.516,10965.516,10965.516,10965.516,10965.516
y1990,KHM,6509.502,6509.502,6509.502,6509.502,6509.502,6509.502,6509.502,6509.502,6509.502,6509.502
y1990,KIR,186.782,186.782,186.782,186.782,186.782,186.782,186.782,186.782,186.782,186.782
y1990,KNA,322.549,322.549,322.549,322.549,322.549,322.549,322.549,322.549,322.549,322.549
y1990,KOR,481984.922,481984.922,481984.922,481984.922,481984.922,481984.922,481984.922,481984.922,481984.922,481984.922
y1990,KWT,50242.947,50242.947,50242.947,50242.947,50242.947,50242.947,50242.947,50242.947,50242.947,50242.947
y1990,LAO,4233.39,4233.39,4233.39,4233.39,4233.39,4233.39,4233.39,4233.39,4233.39,4233.39
y1990,LBN,18054.093,18054.093,18054.093,18054.093,18054.093,18054.093,18054.093,18054.093,18054.093,18054.093
y1990,LBR,1012.694,1012.694,1012.694,1012.694,1012.694,1012.694,1012.694,1012.694,1012.694,1012.694
y1990,LBY,60969.261,60969.261,60969.261,60969.261,60969.261,60969.261,60969.261,60969.261,60969.261,60969.261
y1990,LCA,1152.441,1152.441,1152.441,1152.441,1152.441,1152.441,1152.441,1152.441,1152.441,1152.441
y1990,LIE,3364.894,3364.894,3364.894,3364.894,3364.894,3364.894,3364.894,3364.894,3364.894,3364.894
y1990,LKA,34887.641,34887.641,34887.641,34887.641,34887.641,34887.641,34887.641,34887.641,34887.641,34887.641
y1990,LSO,1404.273,1404.273,1404.273,1404.273,1404.273,1404.273,1404.273,1404.273,1404.273,1404.273
y1990,LTU,45781.86,45781.86,45781.86,45781.86,45781.86,45781.86,45781.86,45781.86,45781.86,45781.86
y1990,LUX,16557.241,16557.241,16557.241,16557.241,16557.241,16557.241,16557.241,16557.241,16557.241,16557.241
y1990,LVA,27665.052,27665.052,27665.052,27665.052,27665.052,27665.052,27665.052,27665.052,27665.052,27665.052
y1990,MAC,7136.655,7136.655,7136.655,7136.655,7136.655,7136.655,7136.655,7136.655,7136.655,7136.655
y1990,MAF,441.145,441.145,441.145,441.145,441.145,441.145,441.145,441.145,441.145,441.145
y1990,MAR,64899.316,64899.316,64899.316,64899.316,64899.316,64899.316,64899.316,64899.316,64899.316,64899.316
y1990,MCO,5453.168,5453.168,5453.168,5453.168,5453.168,5453.168,5453.168,5453.168,5453.168,5453.168
y1990,MDA,14828.308,14828.308,14828.308,14828.308,14828.308,14828.308,14828.308,14828.308,14828.308,14828.308
y1990,MDG,11311.285,11311.285,11311.285,11311.285,11311.285,11311.285,11311.285,11311.285,11311.285,11311.285
y1990,MDV,477.732,477.732,477.732,477.732,477.732,477.732,477.732,477.732,477.732,477.732
y1990,MEX,825346.367,825346.367,825346.367,825346.367,825346.367,825346.367,825346.367,825346.367,825346.367,825346.367
y1990,MHL,341.932,341.932,341.932,341.932,341.932,341.932,341.932,341.932,341.932,341.932
y1990,MKD,15492.216,15492.216,15492.216,15492.216,15492.216,15492.216,15492.216,15492.216,15492.216,15492.216
y1990,MLI,5929.199,5929.199,5929.199,5929.199,5929.199,5929.199,5929.199,5929.199,5929.199,5929.199
y1990,MLT,4847.829,4847.829,4847.829,4847.829,4847.829,4847.829,4847.829,4847.829,4847.829,4847.829
y1990,MMR,11869.605,11869.605,11869.605,11869.605,11869.605,11869.605,11869.605,11869.605,11869.605,11869.605
y1990,MNE,5855.318,5855.318,5855.318,5855.318,5855.318,5855.318,5855.318,5855.318,5855.318,5855.318
y1990,MNG,5232.969,5232.969,5232.969,5232.969,5232.969,5232.969,5232.969,5232.969,5232.969,5232.969
y1990,MNP,584.828,584.828,584.828,584.828,584.828,584.828,584.828,584.828,584.828,584.828
y1990,MOZ,5058.934,5058.934,5058.934,5058.934,5058.934,5058.934,5058.934,5058.934,5058.934,5058.934
y1990,MRT,2973.14,2973.14,2973.14,2973.14,2973.14,2973.14,2973.14,2973.14,2973.14,2973.14
y1990,MSR,91.239,91.239,91.239,91.239,91.239,91.239,91.239,91.239,91.239,91.239
y1990,MTQ,10539.741,10539.741,10539.741,10539.741,10539.741,10539.741,10539.741,10539.741,10539.741,10539.741
y1990,MUS,5933.591,5933.591,5933.591,5933.591,5933.591,5933.591,5933.591,5933.591,5933.591,5933.591
y1990,MWI,5421.285,5421.285,5421.285,5421.285,5421.285,5421.285,5421.285,5421.285,5421.285,5421.285
y1990,MYS,116432.383,116432.383,116432.383,116432.383,116432.383,116432.383,116432.383,116432.383,116432.383,116432.383
y1990,MYT,995.19,995.19,995.19,995.19,995.19,995.19,995.19,995.19,995.19,995.19
y1990,NAM,5727.631,5727.631,5727.631,5727.631,5727.631,5727.631,5727.631,5727.631,5727.631,5727.631
y1990,NCL,8735.154,8735.154,8735.154,8735.154,8735.154,8735.154,8735.154,8735.154,8735.154,8735.154
y1990,NER,5067.899,5067.899,5067.899,5067.899,5067.899,5067.899,5067.899,5067.899,5067.899,5067.899
y1990,NFK,17.736,17.736,17.736,17.736,17.736,17.736,17.736,17.736,17.736,17.736
y1990,NGA,124892,124892,124892,124892,124892,124892,124892,124892,124892,124892
y1990,NIC,8578.226,8578.226,8578.226,8578.226,8578.226,8578.226,8578.226,8578.226,8578.226,8578.226
y1990,NIU,13.526,13.526,13.526,13.526,13.526,13.526,13.526,13.526,13.526,13.526
y1990,NLD,403078.207,403078.207,403078.207,403078.207,403078.207,403078.207,403078.207,403078.207,403078.207,403078.207
y1990,NOR,136710.734,136710.734,136710.734,136710.734,136710.734,136710.734,136710.734,136710.734,136710.734,136710.734
y1990,NPL,14248.639,14248.639,14248.639,14248.639,14248.639,14248.639,14248.639,14248.639,14248.639,14248.639
y1990,NRU,208.943,208.943,208.943,208.943,208.943,208.943,208.943,208.943,208.943,208.943
y1990,NZL,63717.088,63717.088,63717.088,63717.088,63717.088,63717.088,63717.088,63717.088,63717.088,63717.088
y1990,OMN,27746.054,27746.054,27746.054,27746.054,27746.054,27746.054,27746.054,27746.054,27746.054,27746.054
y1990,PAK,189622.362,189622.362,189622.362,189622.362,189622.362,189622.362,189622.362,189622.362,189622.362,189622.362
y1990,PAN,14027.824,14027.824,14027.824,14027.824,14027.824,14027.824,14027.824,14027.824,14027.824,14027.824
y1990,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1990,PER,94072.525,94072.525,94072.525,94072.525,94072.525,94072.525,94072.525,94072.525,94072.525,94072.525
y1990,PHL,141915.675,141915.675,141915.675,141915.675,141915.675,141915.675,141915.675,141915.675,141915.675,141915.675
y1990,PLW,237.327,237.327,237.327,237.327,237.327,237.327,237.327,237.327,237.327,237.327
y1990,PNG,7302.889,7302.889,7302.889,7302.889,7302.889,7302.889,7302.889,7302.889,7302.889,7302.889
y1990,POL,303538.049,303538.049,303538.049,303538.049,303538.049,303538.049,303538.049,303538.049,303538.049,303538.049
y1990,PRI,62153.791,62153.791,62153.791,62153.791,62153.791,62153.791,62153.791,62153.791,62153.791,62153.791
y1990,PRK,44821.958,44821.958,44821.958,44821.958,44821.958,44821.958,44821.958,44821.958,44821.958,44821.958
y1990,PRT,155246.527,155246.527,155246.527,155246.527,155246.527,155246.527,155246.527,155246.527,155246.527,155246.527
y1990,PRY,16788.012,16788.012,16788.012,16788.012,16788.012,16788.012,16788.012,16788.012,16788.012,16788.012
y1990,PSE,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455,4761.455
y1990,PYF,4724.612,4724.612,4724.612,4724.612,4724.612,4724.612,4724.612,4724.612,4724.612,4724.612
y1990,QAT,23059.381,23059.381,23059.381,23059.381,23059.381,23059.381,23059.381,23059.381,23059.381,23059.381
y1990,REU,16238.428,16238.428,16238.428,16238.428,16238.428,16238.428,16238.428,16238.428,16238.428,16238.428
y1990,ROU,173593.484,173593.484,173593.484,173593.484,173593.484,173593.484,173593.484,173593.484,173593.484,173593.484
y1990,RUS,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579,1911249.579
y1990,RWA,5324.699,5324.699,5324.699,5324.699,5324.699,5324.699,5324.699,5324.699,5324.699,5324.699
y1990,SAU,309884.581,309884.581,309884.581,309884.581,309884.581,309884.581,309884.581,309884.581,309884.581,309884.581
y1990,SDN,21923.822,21923.822,21923.822,21923.822,21923.822,21923.822,21923.822,21923.822,21923.822,21923.822
y1990,SEN,9796.077,9796.077,9796.077,9796.077,9796.077,9796.077,9796.077,9796.077,9796.077,9796.077
y1990,SGP,72684.215,72684.215,72684.215,72684.215,72684.215,72684.215,72684.215,72684.215,72684.215,72684.215
y1990,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1990,SHN,43.142,43.142,43.142,43.142,43.142,43.142,43.142,43.142,43.142,43.142
y1990,SJM,157.438,157.438,157.438,157.438,157.438,157.438,157.438,157.438,157.438,157.438
y1990,SLB,673.474,673.474,673.474,673.474,673.474,673.474,673.474,673.474,673.474,673.474
y1990,SLE,4036.06,4036.06,4036.06,4036.06,4036.06,4036.06,4036.06,4036.06,4036.06,4036.06
y1990,SLV,20591.828,20591.828,20591.828,20591.828,20591.828,20591.828,20591.828,20591.828,20591.828,20591.828
y1990,SMR,1109.326,1109.326,1109.326,1109.326,1109.326,1109.326,1109.326,1109.326,1109.326,1109.326
y1990,SOM,6373.939,6373.939,6373.939,6373.939,6373.939,6373.939,6373.939,6373.939,6373.939,6373.939
y1990,SPM,263.718,263.718,263.718,263.718,263.718,263.718,263.718,263.718,263.718,263.718
y1990,SRB,101286.717,101286.717,101286.717,101286.717,101286.717,101286.717,101286.717,101286.717,101286.717,101286.717
y1990,SSD,8643.285,8643.285,8643.285,8643.285,8643.285,8643.285,8643.285,8643.285,8643.285,8643.285
y1990,STP,127.8,127.8,127.8,127.8,127.8,127.8,127.8,127.8,127.8,127.8
y1990,SUR,2746.075,2746.075,2746.075,2746.075,2746.075,2746.075,2746.075,2746.075,2746.075,2746.075
y1990,SVK,63078.925,63078.925,63078.925,63078.925,63078.925,63078.925,63078.925,63078.925,63078.925,63078.925
y1990,SVN,31731.816,31731.816,31731.816,31731.816,31731.816,31731.816,31731.816,31731.816,31731.816,31731.816
y1990,SWE,216964.413,216964.413,216964.413,216964.413,216964.413,216964.413,216964.413,216964.413,216964.413,216964.413
y1990,SWZ,3024.771,3024.771,3024.771,3024.771,3024.771,3024.771,3024.771,3024.771,3024.771,3024.771
y1990,SXM,1884.036,1884.036,1884.036,1884.036,1884.036,1884.036,1884.036,1884.036,1884.036,1884.036
y1990,SYC,933.109,933.109,933.109,933.109,933.109,933.109,933.109,933.109,933.109,933.109
y1990,SYR,36425.798,36425.798,36425.798,36425.798,36425.798,36425.798,36425.798,36425.798,36425.798,36425.798
y1990,TCA,272.586,272.586,272.586,272.586,272.586,272.586,272.586,272.586,272.586,272.586
y1990,TCD,5062.97,5062.97,5062.97,5062.97,5062.97,5062.97,5062.97,5062.97,5062.97,5062.97
y1990,TGO,3676.495,3676.495,3676.495,3676.495,3676.495,3676.495,3676.495,3676.495,3676.495,3676.495
y1990,THA,234084.941,234084.941,234084.941,234084.941,234084.941,234084.941,234084.941,234084.941,234084.941,234084.941
y1990,TJK,14779.797,14779.797,14779.797,14779.797,14779.797,14779.797,14779.797,14779.797,14779.797,14779.797
y1990,TKL,1.609,1.609,1.609,1.609,1.609,1.609,1.609,1.609,1.609,1.609
y1990,TKM,16831.926,16831.926,16831.926,16831.926,16831.926,16831.926,16831.926,16831.926,16831.926,16831.926
y1990,TLS,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172
y1990,TON,439.104,439.104,439.104,439.104,439.104,439.104,439.104,439.104,439.104,439.104
y1990,TTO,12345.406,12345.406,12345.406,12345.406,12345.406,12345.406,12345.406,12345.406,12345.406,12345.406
y1990,TUN,32572.065,32572.065,32572.065,32572.065,32572.065,32572.065,32572.065,32572.065,32572.065,32572.065
y1990,TUR,406688.13,406688.13,406688.13,406688.13,406688.13,406688.13,406688.13,406688.13,406688.13,406688.13
y1990,TUV,23.856,23.856,23.856,23.856,23.856,23.856,23.856,23.856,23.856,23.856
y1990,TWN,219480.568,219480.568,219480.568,219480.568,219480.568,219480.568,219480.568,219480.568,219480.568,219480.568
y1990,TZA,20104.833,20104.833,20104.833,20104.833,20104.833,20104.833,20104.833,20104.833,20104.833,20104.833
y1990,UGA,9646.283,9646.283,9646.283,9646.283,9646.283,9646.283,9646.283,9646.283,9646.283,9646.283
y1990,UKR,410048.456,410048.456,410048.456,410048.456,410048.456,410048.456,410048.456,410048.456,410048.456,410048.456
y1990,UMI,7.503,7.503,7.503,7.503,7.503,7.503,7.503,7.503,7.503,7.503
y1990,URY,21669.579,21669.579,21669.579,21669.579,21669.579,21669.579,21669.579,21669.579,21669.579,21669.579
y1990,USA,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109,7962372.109
y1990,UZB,40285.147,40285.147,40285.147,40285.147,40285.147,40285.147,40285.147,40285.147,40285.147,40285.147
y1990,VAT,29.26,29.26,29.26,29.26,29.26,29.26,29.26,29.26,29.26,29.26
y1990,VCT,470.787,470.787,470.787,470.787,470.787,470.787,470.787,470.787,470.787,470.787
y1990,VEN,179413.188,179413.188,179413.188,179413.188,179413.188,179413.188,179413.188,179413.188,179413.188,179413.188
y1990,VGB,197.269,197.269,197.269,197.269,197.269,197.269,197.269,197.269,197.269,197.269
y1990,VIR,3727.433,3727.433,3727.433,3727.433,3727.433,3727.433,3727.433,3727.433,3727.433,3727.433
y1990,VNM,62524.178,62524.178,62524.178,62524.178,62524.178,62524.178,62524.178,62524.178,62524.178,62524.178
y1990,VUT,585.121,585.121,585.121,585.121,585.121,585.121,585.121,585.121,585.121,585.121
y1990,WLF,181.856,181.856,181.856,181.856,181.856,181.856,181.856,181.856,181.856,181.856
y1990,WSM,574.181,574.181,574.181,574.181,574.181,574.181,574.181,574.181,574.181,574.181
y1990,YEM,20134.363,20134.363,20134.363,20134.363,20134.363,20134.363,20134.363,20134.363,20134.363,20134.363
y1990,ZAF,262719.196,262719.196,262719.196,262719.196,262719.196,262719.196,262719.196,262719.196,262719.196,262719.196
y1990,ZMB,10304.135,10304.135,10304.135,10304.135,10304.135,10304.135,10304.135,10304.135,10304.135,10304.135
y1990,ZWE,6325.092,6325.092,6325.092,6325.092,6325.092,6325.092,6325.092,6325.092,6325.092,6325.092
y1995,ABW,3040.812,3040.812,3040.812,3040.812,3040.812,3040.812,3040.812,3040.812,3040.812,3040.812
y1995,AFG,7701.801,7701.801,7701.801,7701.801,7701.801,7701.801,7701.801,7701.801,7701.801,7701.801
y1995,AGO,31121.061,31121.061,31121.061,31121.061,31121.061,31121.061,31121.061,31121.061,31121.061,31121.061
y1995,AIA,119.645,119.645,119.645,119.645,119.645,119.645,119.645,119.645,119.645,119.645
y1995,ALA,1405.774,1405.774,1405.774,1405.774,1405.774,1405.774,1405.774,1405.774,1405.774,1405.774
y1995,ALB,10126.487,10126.487,10126.487,10126.487,10126.487,10126.487,10126.487,10126.487,10126.487,10126.487
y1995,AND,2426.576,2426.576,2426.576,2426.576,2426.576,2426.576,2426.576,2426.576,2426.576,2426.576
y1995,ARE,94987.328,94987.328,94987.328,94987.328,94987.328,94987.328,94987.328,94987.328,94987.328,94987.328
y1995,ARG,324403.361,324403.361,324403.361,324403.361,324403.361,324403.361,324403.361,324403.361,324403.361,324403.361
y1995,ARM,5490.088,5490.088,5490.088,5490.088,5490.088,5490.088,5490.088,5490.088,5490.088,5490.088
y1995,ASM,687.362,687.362,687.362,687.362,687.362,687.362,687.362,687.362,687.362,687.362
y1995,ATA,10,10,10,10,10,10,10,10,10,10
y1995,ATF,2.452,2.452,2.452,2.452,2.452,2.452,2.452,2.452,2.452,2.452
y1995,ATG,906.886,906.886,906.886,906.886,906.886,906.886,906.886,906.886,906.886,906.886
y1995,AUS,486968.112,486968.112,486968.112,486968.112,486968.112,486968.112,486968.112,486968.112,486968.112,486968.112
y1995,AUT,225359.99,225359.99,225359.99,225359.99,225359.99,225359.99,225359.99,225359.99,225359.99,225359.99
y1995,AZE,15495.181,15495.181,15495.181,15495.181,15495.181,15495.181,15495.181,15495.181,15495.181,15495.181
y1995,BDI,2269.462,2269.462,2269.462,2269.462,2269.462,2269.462,2269.462,2269.462,2269.462,2269.462
y1995,BEL,274001.549,274001.549,274001.549,274001.549,274001.549,274001.549,274001.549,274001.549,274001.549,274001.549
y1995,BEN,6584.638,6584.638,6584.638,6584.638,6584.638,6584.638,6584.638,6584.638,6584.638,6584.638
y1995,BES,287.014,287.014,287.014,287.014,287.014,287.014,287.014,287.014,287.014,287.014
y1995,BFA,7416.754,7416.754,7416.754,7416.754,7416.754,7416.754,7416.754,7416.754,7416.754,7416.754
y1995,BGD,96321.212,96321.212,96321.212,96321.212,96321.212,96321.212,96321.212,96321.212,96321.212,96321.212
y1995,BGR,56541.88,56541.88,56541.88,56541.88,56541.88,56541.88,56541.88,56541.88,56541.88,56541.88
y1995,BHR,11621.991,11621.991,11621.991,11621.991,11621.991,11621.991,11621.991,11621.991,11621.991,11621.991
y1995,BHS,6211.312,6211.312,6211.312,6211.312,6211.312,6211.312,6211.312,6211.312,6211.312,6211.312
y1995,BIH,7657.093,7657.093,7657.093,7657.093,7657.093,7657.093,7657.093,7657.093,7657.093,7657.093
y1995,BLM,191.282,191.282,191.282,191.282,191.282,191.282,191.282,191.282,191.282,191.282
y1995,BLR,43127.185,43127.185,43127.185,43127.185,43127.185,43127.185,43127.185,43127.185,43127.185,43127.185
y1995,BLZ,1246.676,1246.676,1246.676,1246.676,1246.676,1246.676,1246.676,1246.676,1246.676,1246.676
y1995,BMU,3193.857,3193.857,3193.857,3193.857,3193.857,3193.857,3193.857,3193.857,3193.857,3193.857
y1995,BOL,24293.427,24293.427,24293.427,24293.427,24293.427,24293.427,24293.427,24293.427,24293.427,24293.427
y1995,BRA,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486,1256966.486
y1995,BRB,4702.59,4702.59,4702.59,4702.59,4702.59,4702.59,4702.59,4702.59,4702.59,4702.59
y1995,BRN,14991.547,14991.547,14991.547,14991.547,14991.547,14991.547,14991.547,14991.547,14991.547,14991.547
y1995,BTN,1157.503,1157.503,1157.503,1157.503,1157.503,1157.503,1157.503,1157.503,1157.503,1157.503
y1995,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1995,BWA,10938.467,10938.467,10938.467,10938.467,10938.467,10938.467,10938.467,10938.467,10938.467,10938.467
y1995,CAF,2445.428,2445.428,2445.428,2445.428,2445.428,2445.428,2445.428,2445.428,2445.428,2445.428
y1995,CAN,822762.385,822762.385,822762.385,822762.385,822762.385,822762.385,822762.385,822762.385,822762.385,822762.385
y1995,CCK,31.138,31.138,31.138,31.138,31.138,31.138,31.138,31.138,31.138,31.138
y1995,CHE,229117.755,229117.755,229117.755,229117.755,229117.755,229117.755,229117.755,229117.755,229117.755,229117.755
y1995,CHL,125912.444,125912.444,125912.444,125912.444,125912.444,125912.444,125912.444,125912.444,125912.444,125912.444
y1995,CHN,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909,2335137.909
y1995,CIV,23801.665,23801.665,23801.665,23801.665,23801.665,23801.665,23801.665,23801.665,23801.665,23801.665
y1995,CMR,22017.448,22017.448,22017.448,22017.448,22017.448,22017.448,22017.448,22017.448,22017.448,22017.448
y1995,COD,15132.041,15132.041,15132.041,15132.041,15132.041,15132.041,15132.041,15132.041,15132.041,15132.041
y1995,COG,8078.126,8078.126,8078.126,8078.126,8078.126,8078.126,8078.126,8078.126,8078.126,8078.126
y1995,COK,166.575,166.575,166.575,166.575,166.575,166.575,166.575,166.575,166.575,166.575
y1995,COL,234270.668,234270.668,234270.668,234270.668,234270.668,234270.668,234270.668,234270.668,234270.668,234270.668
y1995,COM,538.902,538.902,538.902,538.902,538.902,538.902,538.902,538.902,538.902,538.902
y1995,CPV,696.735,696.735,696.735,696.735,696.735,696.735,696.735,696.735,696.735,696.735
y1995,CRI,26354.717,26354.717,26354.717,26354.717,26354.717,26354.717,26354.717,26354.717,26354.717,26354.717
y1995,CUB,58042.55,58042.55,58042.55,58042.55,58042.55,58042.55,58042.55,58042.55,58042.55,58042.55
y1995,CUW,2158.29,2158.29,2158.29,2158.29,2158.29,2158.29,2158.29,2158.29,2158.29,2158.29
y1995,CXR,95.708,95.708,95.708,95.708,95.708,95.708,95.708,95.708,95.708,95.708
y1995,CYM,2585.707,2585.707,2585.707,2585.707,2585.707,2585.707,2585.707,2585.707,2585.707,2585.707
y1995,CYP,15987.546,15987.546,15987.546,15987.546,15987.546,15987.546,15987.546,15987.546,15987.546,15987.546
y1995,CZE,159991.972,159991.972,159991.972,159991.972,159991.972,159991.972,159991.972,159991.972,159991.972,159991.972
y1995,DEU,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707,2264832.707
y1995,DJI,1424.627,1424.627,1424.627,1424.627,1424.627,1424.627,1424.627,1424.627,1424.627,1424.627
y1995,DMA,439.533,439.533,439.533,439.533,439.533,439.533,439.533,439.533,439.533,439.533
y1995,DNK,149229.683,149229.683,149229.683,149229.683,149229.683,149229.683,149229.683,149229.683,149229.683,149229.683
y1995,DOM,37962.199,37962.199,37962.199,37962.199,37962.199,37962.199,37962.199,37962.199,37962.199,37962.199
y1995,DZA,144094.92,144094.92,144094.92,144094.92,144094.92,144094.92,144094.92,144094.92,144094.92,144094.92
y1995,ECU,62280.966,62280.966,62280.966,62280.966,62280.966,62280.966,62280.966,62280.966,62280.966,62280.966
y1995,EGY,222304.717,222304.717,222304.717,222304.717,222304.717,222304.717,222304.717,222304.717,222304.717,222304.717
y1995,ERI,2505.934,2505.934,2505.934,2505.934,2505.934,2505.934,2505.934,2505.934,2505.934,2505.934
y1995,ESH,633.255,633.255,633.255,633.255,633.255,633.255,633.255,633.255,633.255,633.255
y1995,ESP,836373.586,836373.586,836373.586,836373.586,836373.586,836373.586,836373.586,836373.586,836373.586,836373.586
y1995,EST,11051.896,11051.896,11051.896,11051.896,11051.896,11051.896,11051.896,11051.896,11051.896,11051.896
y1995,ETH,25930.388,25930.388,25930.388,25930.388,25930.388,25930.388,25930.388,25930.388,25930.388,25930.388
y1995,FIN,112687.348,112687.348,112687.348,112687.348,112687.348,112687.348,112687.348,112687.348,112687.348,112687.348
y1995,FJI,2932.723,2932.723,2932.723,2932.723,2932.723,2932.723,2932.723,2932.723,2932.723,2932.723
y1995,FLK,234.144,234.144,234.144,234.144,234.144,234.144,234.144,234.144,234.144,234.144
y1995,FRA,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737,1534472.737
y1995,FRO,1763.96,1763.96,1763.96,1763.96,1763.96,1763.96,1763.96,1763.96,1763.96,1763.96
y1995,FSM,373.559,373.559,373.559,373.559,373.559,373.559,373.559,373.559,373.559,373.559
y1995,GAB,14967.63,14967.63,14967.63,14967.63,14967.63,14967.63,14967.63,14967.63,14967.63,14967.63
y1995,GBR,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022,1476915.022
y1995,GEO,8610.218,8610.218,8610.218,8610.218,8610.218,8610.218,8610.218,8610.218,8610.218,8610.218
y1995,GGY,3079.86,3079.86,3079.86,3079.86,3079.86,3079.86,3079.86,3079.86,3079.86,3079.86
y1995,GHA,15757.02,15757.02,15757.02,15757.02,15757.02,15757.02,15757.02,15757.02,15757.02,15757.02
y1995,GIB,1683.485,1683.485,1683.485,1683.485,1683.485,1683.485,1683.485,1683.485,1683.485,1683.485
y1995,GIN,6438.217,6438.217,6438.217,6438.217,6438.217,6438.217,6438.217,6438.217,6438.217,6438.217
y1995,GLP,11124.999,11124.999,11124.999,11124.999,11124.999,11124.999,11124.999,11124.999,11124.999,11124.999
y1995,GMB,1133.334,1133.334,1133.334,1133.334,1133.334,1133.334,1133.334,1133.334,1133.334,1133.334
y1995,GNB,1187.645,1187.645,1187.645,1187.645,1187.645,1187.645,1187.645,1187.645,1187.645,1187.645
y1995,GNQ,668.211,668.211,668.211,668.211,668.211,668.211,668.211,668.211,668.211,668.211
y1995,GRC,190634.715,190634.715,190634.715,190634.715,190634.715,190634.715,190634.715,190634.715,190634.715,190634.715
y1995,GRD,671.101,671.101,671.101,671.101,671.101,671.101,671.101,671.101,671.101,671.101
y1995,GRL,2351.035,2351.035,2351.035,2351.035,2351.035,2351.035,2351.035,2351.035,2351.035,2351.035
y1995,GTM,43262.395,43262.395,43262.395,43262.395,43262.395,43262.395,43262.395,43262.395,43262.395,43262.395
y1995,GUF,2924.284,2924.284,2924.284,2924.284,2924.284,2924.284,2924.284,2924.284,2924.284,2924.284
y1995,GUM,4439.641,4439.641,4439.641,4439.641,4439.641,4439.641,4439.641,4439.641,4439.641,4439.641
y1995,GUY,2185.525,2185.525,2185.525,2185.525,2185.525,2185.525,2185.525,2185.525,2185.525,2185.525
y1995,HKG,170761.78,170761.78,170761.78,170761.78,170761.78,170761.78,170761.78,170761.78,170761.78,170761.78
y1995,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y1995,HND,16883.051,16883.051,16883.051,16883.051,16883.051,16883.051,16883.051,16883.051,16883.051,16883.051
y1995,HRV,46332.042,46332.042,46332.042,46332.042,46332.042,46332.042,46332.042,46332.042,46332.042,46332.042
y1995,HTI,9874.444,9874.444,9874.444,9874.444,9874.444,9874.444,9874.444,9874.444,9874.444,9874.444
y1995,HUN,113289.637,113289.637,113289.637,113289.637,113289.637,113289.637,113289.637,113289.637,113289.637,113289.637
y1995,IDN,572143.84,572143.84,572143.84,572143.84,572143.84,572143.84,572143.84,572143.84,572143.84,572143.84
y1995,IMN,6106.513,6106.513,6106.513,6106.513,6106.513,6106.513,6106.513,6106.513,6106.513,6106.513
y1995,IND,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967,1409399.967
y1995,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y1995,IRL,76460.623,76460.623,76460.623,76460.623,76460.623,76460.623,76460.623,76460.623,76460.623,76460.623
y1995,IRN,400441.17,400441.17,400441.17,400441.17,400441.17,400441.17,400441.17,400441.17,400441.17,400441.17
y1995,IRQ,62904.546,62904.546,62904.546,62904.546,62904.546,62904.546,62904.546,62904.546,62904.546,62904.546
y1995,ISL,6855.349,6855.349,6855.349,6855.349,6855.349,6855.349,6855.349,6855.349,6855.349,6855.349
y1995,ISR,116155.44,116155.44,116155.44,116155.44,116155.44,116155.44,116155.44,116155.44,116155.44,116155.44
y1995,ITA,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501,1455665.501
y1995,JAM,19586.799,19586.799,19586.799,19586.799,19586.799,19586.799,19586.799,19586.799,19586.799,19586.799
y1995,JEY,4379.562,4379.562,4379.562,4379.562,4379.562,4379.562,4379.562,4379.562,4379.562,4379.562
y1995,JOR,16665.61,16665.61,16665.61,16665.61,16665.61,16665.61,16665.61,16665.61,16665.61,16665.61
y1995,JPN,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427,3560632.427
y1995,KAZ,72740.144,72740.144,72740.144,72740.144,72740.144,72740.144,72740.144,72740.144,72740.144,72740.144
y1995,KEN,34468.54,34468.54,34468.54,34468.54,34468.54,34468.54,34468.54,34468.54,34468.54,34468.54
y1995,KGZ,5714.938,5714.938,5714.938,5714.938,5714.938,5714.938,5714.938,5714.938,5714.938,5714.938
y1995,KHM,8659.039,8659.039,8659.039,8659.039,8659.039,8659.039,8659.039,8659.039,8659.039,8659.039
y1995,KIR,205.226,205.226,205.226,205.226,205.226,205.226,205.226,205.226,205.226,205.226
y1995,KNA,422.285,422.285,422.285,422.285,422.285,422.285,422.285,422.285,422.285,422.285
y1995,KOR,702295.828,702295.828,702295.828,702295.828,702295.828,702295.828,702295.828,702295.828,702295.828,702295.828
y1995,KWT,69550.213,69550.213,69550.213,69550.213,69550.213,69550.213,69550.213,69550.213,69550.213,69550.213
y1995,LAO,5728.69,5728.69,5728.69,5728.69,5728.69,5728.69,5728.69,5728.69,5728.69,5728.69
y1995,LBN,28016.749,28016.749,28016.749,28016.749,28016.749,28016.749,28016.749,28016.749,28016.749,28016.749
y1995,LBR,363.714,363.714,363.714,363.714,363.714,363.714,363.714,363.714,363.714,363.714
y1995,LBY,62431.759,62431.759,62431.759,62431.759,62431.759,62431.759,62431.759,62431.759,62431.759,62431.759
y1995,LCA,1287.498,1287.498,1287.498,1287.498,1287.498,1287.498,1287.498,1287.498,1287.498,1287.498
y1995,LIE,4193.935,4193.935,4193.935,4193.935,4193.935,4193.935,4193.935,4193.935,4193.935,4193.935
y1995,LKA,44968.296,44968.296,44968.296,44968.296,44968.296,44968.296,44968.296,44968.296,44968.296,44968.296
y1995,LSO,1686.127,1686.127,1686.127,1686.127,1686.127,1686.127,1686.127,1686.127,1686.127,1686.127
y1995,LTU,26310.558,26310.558,26310.558,26310.558,26310.558,26310.558,26310.558,26310.558,26310.558,26310.558
y1995,LUX,20165.031,20165.031,20165.031,20165.031,20165.031,20165.031,20165.031,20165.031,20165.031,20165.031
y1995,LVA,15411.776,15411.776,15411.776,15411.776,15411.776,15411.776,15411.776,15411.776,15411.776,15411.776
y1995,MAC,9640.021,9640.021,9640.021,9640.021,9640.021,9640.021,9640.021,9640.021,9640.021,9640.021
y1995,MAF,448.601,448.601,448.601,448.601,448.601,448.601,448.601,448.601,448.601,448.601
y1995,MAR,67899.727,67899.727,67899.727,67899.727,67899.727,67899.727,67899.727,67899.727,67899.727,67899.727
y1995,MCO,5745.812,5745.812,5745.812,5745.812,5745.812,5745.812,5745.812,5745.812,5745.812,5745.812
y1995,MDA,6145.313,6145.313,6145.313,6145.313,6145.313,6145.313,6145.313,6145.313,6145.313,6145.313
y1995,MDG,11236.865,11236.865,11236.865,11236.865,11236.865,11236.865,11236.865,11236.865,11236.865,11236.865
y1995,MDV,637.35,637.35,637.35,637.35,637.35,637.35,637.35,637.35,637.35,637.35
y1995,MEX,894135.803,894135.803,894135.803,894135.803,894135.803,894135.803,894135.803,894135.803,894135.803,894135.803
y1995,MHL,364.114,364.114,364.114,364.114,364.114,364.114,364.114,364.114,364.114,364.114
y1995,MKD,12151.966,12151.966,12151.966,12151.966,12151.966,12151.966,12151.966,12151.966,12151.966,12151.966
y1995,MLI,6885.885,6885.885,6885.885,6885.885,6885.885,6885.885,6885.885,6885.885,6885.885,6885.885
y1995,MLT,6356.657,6356.657,6356.657,6356.657,6356.657,6356.657,6356.657,6356.657,6356.657,6356.657
y1995,MMR,15375.467,15375.467,15375.467,15375.467,15375.467,15375.467,15375.467,15375.467,15375.467,15375.467
y1995,MNE,3081.887,3081.887,3081.887,3081.887,3081.887,3081.887,3081.887,3081.887,3081.887,3081.887
y1995,MNG,4312.38,4312.38,4312.38,4312.38,4312.38,4312.38,4312.38,4312.38,4312.38,4312.38
y1995,MNP,764.989,764.989,764.989,764.989,764.989,764.989,764.989,764.989,764.989,764.989
y1995,MOZ,5890.935,5890.935,5890.935,5890.935,5890.935,5890.935,5890.935,5890.935,5890.935,5890.935
y1995,MRT,3497.459,3497.459,3497.459,3497.459,3497.459,3497.459,3497.459,3497.459,3497.459,3497.459
y1995,MSR,86.972,86.972,86.972,86.972,86.972,86.972,86.972,86.972,86.972,86.972
y1995,MTQ,10841.945,10841.945,10841.945,10841.945,10841.945,10841.945,10841.945,10841.945,10841.945,10841.945
y1995,MUS,7800.791,7800.791,7800.791,7800.791,7800.791,7800.791,7800.791,7800.791,7800.791,7800.791
y1995,MWI,5839.769,5839.769,5839.769,5839.769,5839.769,5839.769,5839.769,5839.769,5839.769,5839.769
y1995,MYS,184649.527,184649.527,184649.527,184649.527,184649.527,184649.527,184649.527,184649.527,184649.527,184649.527
y1995,MYT,1293.411,1293.411,1293.411,1293.411,1293.411,1293.411,1293.411,1293.411,1293.411,1293.411
y1995,NAM,6972.16,6972.16,6972.16,6972.16,6972.16,6972.16,6972.16,6972.16,6972.16,6972.16
y1995,NCL,10105.029,10105.029,10105.029,10105.029,10105.029,10105.029,10105.029,10105.029,10105.029,10105.029
y1995,NER,5195.252,5195.252,5195.252,5195.252,5195.252,5195.252,5195.252,5195.252,5195.252,5195.252
y1995,NFK,19.847,19.847,19.847,19.847,19.847,19.847,19.847,19.847,19.847,19.847
y1995,NGA,132926.902,132926.902,132926.902,132926.902,132926.902,132926.902,132926.902,132926.902,132926.902,132926.902
y1995,NIC,8850.81,8850.81,8850.81,8850.81,8850.81,8850.81,8850.81,8850.81,8850.81,8850.81
y1995,NIU,12.569,12.569,12.569,12.569,12.569,12.569,12.569,12.569,12.569,12.569
y1995,NLD,450824.808,450824.808,450824.808,450824.808,450824.808,450824.808,450824.808,450824.808,450824.808,450824.808
y1995,NOR,164595.77,164595.77,164595.77,164595.77,164595.77,164595.77,164595.77,164595.77,164595.77,164595.77
y1995,NPL,18317.192,18317.192,18317.192,18317.192,18317.192,18317.192,18317.192,18317.192,18317.192,18317.192
y1995,NRU,129.76,129.76,129.76,129.76,129.76,129.76,129.76,129.76,129.76,129.76
y1995,NZL,76178.896,76178.896,76178.896,76178.896,76178.896,76178.896,76178.896,76178.896,76178.896,76178.896
y1995,OMN,36811.945,36811.945,36811.945,36811.945,36811.945,36811.945,36811.945,36811.945,36811.945,36811.945
y1995,PAK,235756.424,235756.424,235756.424,235756.424,235756.424,235756.424,235756.424,235756.424,235756.424,235756.424
y1995,PAN,18147.536,18147.536,18147.536,18147.536,18147.536,18147.536,18147.536,18147.536,18147.536,18147.536
y1995,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y1995,PER,124483.925,124483.925,124483.925,124483.925,124483.925,124483.925,124483.925,124483.925,124483.925,124483.925
y1995,PHL,159846.549,159846.549,159846.549,159846.549,159846.549,159846.549,159846.549,159846.549,159846.549,159846.549
y1995,PLW,235.906,235.906,235.906,235.906,235.906,235.906,235.906,235.906,235.906,235.906
y1995,PNG,10596.719,10596.719,10596.719,10596.719,10596.719,10596.719,10596.719,10596.719,10596.719,10596.719
y1995,POL,343639.519,343639.519,343639.519,343639.519,343639.519,343639.519,343639.519,343639.519,343639.519,343639.519
y1995,PRI,72098.288,72098.288,72098.288,72098.288,72098.288,72098.288,72098.288,72098.288,72098.288,72098.288
y1995,PRK,30325.173,30325.173,30325.173,30325.173,30325.173,30325.173,30325.173,30325.173,30325.173,30325.173
y1995,PRT,168508.937,168508.937,168508.937,168508.937,168508.937,168508.937,168508.937,168508.937,168508.937,168508.937
y1995,PRY,19241.013,19241.013,19241.013,19241.013,19241.013,19241.013,19241.013,19241.013,19241.013,19241.013
y1995,PSE,7638.168,7638.168,7638.168,7638.168,7638.168,7638.168,7638.168,7638.168,7638.168,7638.168
y1995,PYF,4985.239,4985.239,4985.239,4985.239,4985.239,4985.239,4985.239,4985.239,4985.239,4985.239
y1995,QAT,23841.2,23841.2,23841.2,23841.2,23841.2,23841.2,23841.2,23841.2,23841.2,23841.2
y1995,REU,17912.85,17912.85,17912.85,17912.85,17912.85,17912.85,17912.85,17912.85,17912.85,17912.85
y1995,ROU,154378.412,154378.412,154378.412,154378.412,154378.412,154378.412,154378.412,154378.412,154378.412,154378.412
y1995,RUS,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148,1184764.148
y1995,RWA,3819.478,3819.478,3819.478,3819.478,3819.478,3819.478,3819.478,3819.478,3819.478,3819.478
y1995,SAU,347208.484,347208.484,347208.484,347208.484,347208.484,347208.484,347208.484,347208.484,347208.484,347208.484
y1995,SDN,29041.519,29041.519,29041.519,29041.519,29041.519,29041.519,29041.519,29041.519,29041.519,29041.519
y1995,SEN,11194.44,11194.44,11194.44,11194.44,11194.44,11194.44,11194.44,11194.44,11194.44,11194.44
y1995,SGP,111699.948,111699.948,111699.948,111699.948,111699.948,111699.948,111699.948,111699.948,111699.948,111699.948
y1995,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y1995,SHN,41.239,41.239,41.239,41.239,41.239,41.239,41.239,41.239,41.239,41.239
y1995,SJM,161.886,161.886,161.886,161.886,161.886,161.886,161.886,161.886,161.886,161.886
y1995,SLB,946.265,946.265,946.265,946.265,946.265,946.265,946.265,946.265,946.265,946.265
y1995,SLE,3059.107,3059.107,3059.107,3059.107,3059.107,3059.107,3059.107,3059.107,3059.107,3059.107
y1995,SLV,28027.374,28027.374,28027.374,28027.374,28027.374,28027.374,28027.374,28027.374,28027.374,28027.374
y1995,SMR,1589.021,1589.021,1589.021,1589.021,1589.021,1589.021,1589.021,1589.021,1589.021,1589.021
y1995,SOM,4953.378,4953.378,4953.378,4953.378,4953.378,4953.378,4953.378,4953.378,4953.378,4953.378
y1995,SPM,264.642,264.642,264.642,264.642,264.642,264.642,264.642,264.642,264.642,264.642
y1995,SRB,53422.008,53422.008,53422.008,53422.008,53422.008,53422.008,53422.008,53422.008,53422.008,53422.008
y1995,SSD,8179.157,8179.157,8179.157,8179.157,8179.157,8179.157,8179.157,8179.157,8179.157,8179.157
y1995,STP,138.592,138.592,138.592,138.592,138.592,138.592,138.592,138.592,138.592,138.592
y1995,SUR,2603.098,2603.098,2603.098,2603.098,2603.098,2603.098,2603.098,2603.098,2603.098,2603.098
y1995,SVK,56900.407,56900.407,56900.407,56900.407,56900.407,56900.407,56900.407,56900.407,56900.407,56900.407
y1995,SVN,31322.416,31322.416,31322.416,31322.416,31322.416,31322.416,31322.416,31322.416,31322.416,31322.416
y1995,SWE,223947.387,223947.387,223947.387,223947.387,223947.387,223947.387,223947.387,223947.387,223947.387,223947.387
y1995,SWZ,3438.236,3438.236,3438.236,3438.236,3438.236,3438.236,3438.236,3438.236,3438.236,3438.236
y1995,SXM,2021.646,2021.646,2021.646,2021.646,2021.646,2021.646,2021.646,2021.646,2021.646,2021.646
y1995,SYC,1095.132,1095.132,1095.132,1095.132,1095.132,1095.132,1095.132,1095.132,1095.132,1095.132
y1995,SYR,53469.178,53469.178,53469.178,53469.178,53469.178,53469.178,53469.178,53469.178,53469.178,53469.178
y1995,TCA,445.07,445.07,445.07,445.07,445.07,445.07,445.07,445.07,445.07,445.07
y1995,TCD,5955.294,5955.294,5955.294,5955.294,5955.294,5955.294,5955.294,5955.294,5955.294,5955.294
y1995,TGO,3585.825,3585.825,3585.825,3585.825,3585.825,3585.825,3585.825,3585.825,3585.825,3585.825
y1995,THA,347319.793,347319.793,347319.793,347319.793,347319.793,347319.793,347319.793,347319.793,347319.793,347319.793
y1995,TJK,5742.152,5742.152,5742.152,5742.152,5742.152,5742.152,5742.152,5742.152,5742.152,5742.152
y1995,TKL,1.52,1.52,1.52,1.52,1.52,1.52,1.52,1.52,1.52,1.52
y1995,TKM,10642.111,10642.111,10642.111,10642.111,10642.111,10642.111,10642.111,10642.111,10642.111,10642.111
y1995,TLS,1448.382,1448.382,1448.382,1448.382,1448.382,1448.382,1448.382,1448.382,1448.382,1448.382
y1995,TON,497.52,497.52,497.52,497.52,497.52,497.52,497.52,497.52,497.52,497.52
y1995,TTO,13415.647,13415.647,13415.647,13415.647,13415.647,13415.647,13415.647,13415.647,13415.647,13415.647
y1995,TUN,39886.109,39886.109,39886.109,39886.109,39886.109,39886.109,39886.109,39886.109,39886.109,39886.109
y1995,TUR,472454.623,472454.623,472454.623,472454.623,472454.623,472454.623,472454.623,472454.623,472454.623,472454.623
y1995,TUV,27.321,27.321,27.321,27.321,27.321,27.321,27.321,27.321,27.321,27.321
y1995,TWN,312046.895,312046.895,312046.895,312046.895,312046.895,312046.895,312046.895,312046.895,312046.895,312046.895
y1995,TZA,22316.035,22316.035,22316.035,22316.035,22316.035,22316.035,22316.035,22316.035,22316.035,22316.035
y1995,UGA,13526.419,13526.419,13526.419,13526.419,13526.419,13526.419,13526.419,13526.419,13526.419,13526.419
y1995,UKR,203512.576,203512.576,203512.576,203512.576,203512.576,203512.576,203512.576,203512.576,203512.576,203512.576
y1995,UMI,8.357,8.357,8.357,8.357,8.357,8.357,8.357,8.357,8.357,8.357
y1995,URY,27048.234,27048.234,27048.234,27048.234,27048.234,27048.234,27048.234,27048.234,27048.234,27048.234
y1995,USA,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054,9028523.054
y1995,UZB,32276.183,32276.183,32276.183,32276.183,32276.183,32276.183,32276.183,32276.183,32276.183,32276.183
y1995,VAT,29.678,29.678,29.678,29.678,29.678,29.678,29.678,29.678,29.678,29.678
y1995,VCT,521.81,521.81,521.81,521.81,521.81,521.81,521.81,521.81,521.81,521.81
y1995,VEN,214729.937,214729.937,214729.937,214729.937,214729.937,214729.937,214729.937,214729.937,214729.937,214729.937
y1995,VGB,872.52,872.52,872.52,872.52,872.52,872.52,872.52,872.52,872.52,872.52
y1995,VIR,3863.35,3863.35,3863.35,3863.35,3863.35,3863.35,3863.35,3863.35,3863.35,3863.35
y1995,VNM,93364.267,93364.267,93364.267,93364.267,93364.267,93364.267,93364.267,93364.267,93364.267,93364.267
y1995,VUT,727.655,727.655,727.655,727.655,727.655,727.655,727.655,727.655,727.655,727.655
y1995,WLF,185.302,185.302,185.302,185.302,185.302,185.302,185.302,185.302,185.302,185.302
y1995,WSM,628.936,628.936,628.936,628.936,628.936,628.936,628.936,628.936,628.936,628.936
y1995,YEM,27685.155,27685.155,27685.155,27685.155,27685.155,27685.155,27685.155,27685.155,27685.155,27685.155
y1995,ZAF,280840.562,280840.562,280840.562,280840.562,280840.562,280840.562,280840.562,280840.562,280840.562,280840.562
y1995,ZMB,8915.122,8915.122,8915.122,8915.122,8915.122,8915.122,8915.122,8915.122,8915.122,8915.122
y1995,ZWE,6829.909,6829.909,6829.909,6829.909,6829.909,6829.909,6829.909,6829.909,6829.909,6829.909
y2000,ABW,3742.121,3742.121,3742.121,3742.121,3742.121,3742.121,3742.121,3742.121,3742.121,3742.121
y2000,AFG,8162.367,8162.367,8162.367,8162.367,8162.367,8162.367,8162.367,8162.367,8162.367,8162.367
y2000,AGO,41940.32,41940.32,41940.32,41940.32,41940.32,41940.32,41940.32,41940.32,41940.32,41940.32
y2000,AIA,135.066,135.066,135.066,135.066,135.066,135.066,135.066,135.066,135.066,135.066
y2000,ALA,1437.094,1437.094,1437.094,1437.094,1437.094,1437.094,1437.094,1437.094,1437.094,1437.094
y2000,ALB,12818.656,12818.656,12818.656,12818.656,12818.656,12818.656,12818.656,12818.656,12818.656,12818.656
y2000,AND,2984.801,2984.801,2984.801,2984.801,2984.801,2984.801,2984.801,2984.801,2984.801,2984.801
y2000,ARE,122179.992,122179.992,122179.992,122179.992,122179.992,122179.992,122179.992,122179.992,122179.992,122179.992
y2000,ARG,367823.375,367823.375,367823.375,367823.375,367823.375,367823.375,367823.375,367823.375,367823.375,367823.375
y2000,ARM,7216.288,7216.288,7216.288,7216.288,7216.288,7216.288,7216.288,7216.288,7216.288,7216.288
y2000,ASM,747.786,747.786,747.786,747.786,747.786,747.786,747.786,747.786,747.786,747.786
y2000,ATA,10,10,10,10,10,10,10,10,10,10
y2000,ATF,2.673,2.673,2.673,2.673,2.673,2.673,2.673,2.673,2.673,2.673
y2000,ATG,1142.173,1142.173,1142.173,1142.173,1142.173,1142.173,1142.173,1142.173,1142.173,1142.173
y2000,AUS,597968.152,597968.152,597968.152,597968.152,597968.152,597968.152,597968.152,597968.152,597968.152,597968.152
y2000,AUT,260517.139,260517.139,260517.139,260517.139,260517.139,260517.139,260517.139,260517.139,260517.139,260517.139
y2000,AZE,21545.507,21545.507,21545.507,21545.507,21545.507,21545.507,21545.507,21545.507,21545.507,21545.507
y2000,BDI,2334.752,2334.752,2334.752,2334.752,2334.752,2334.752,2334.752,2334.752,2334.752,2334.752
y2000,BEL,315228.09,315228.09,315228.09,315228.09,315228.09,315228.09,315228.09,315228.09,315228.09,315228.09
y2000,BEN,8323.002,8323.002,8323.002,8323.002,8323.002,8323.002,8323.002,8323.002,8323.002,8323.002
y2000,BES,273.41,273.41,273.41,273.41,273.41,273.41,273.41,273.41,273.41,273.41
y2000,BFA,10226.742,10226.742,10226.742,10226.742,10226.742,10226.742,10226.742,10226.742,10226.742,10226.742
y2000,BGD,123725.909,123725.909,123725.909,123725.909,123725.909,123725.909,123725.909,123725.909,123725.909,123725.909
y2000,BGR,55776.049,55776.049,55776.049,55776.049,55776.049,55776.049,55776.049,55776.049,55776.049,55776.049
y2000,BHR,14810.724,14810.724,14810.724,14810.724,14810.724,14810.724,14810.724,14810.724,14810.724,14810.724
y2000,BHS,7846.938,7846.938,7846.938,7846.938,7846.938,7846.938,7846.938,7846.938,7846.938,7846.938
y2000,BIH,19966.89,19966.89,19966.89,19966.89,19966.89,19966.89,19966.89,19966.89,19966.89,19966.89
y2000,BLM,209.222,209.222,209.222,209.222,209.222,209.222,209.222,209.222,209.222,209.222
y2000,BLR,59774.072,59774.072,59774.072,59774.072,59774.072,59774.072,59774.072,59774.072,59774.072,59774.072
y2000,BLZ,1643.763,1643.763,1643.763,1643.763,1643.763,1643.763,1643.763,1643.763,1643.763,1643.763
y2000,BMU,3777.559,3777.559,3777.559,3777.559,3777.559,3777.559,3777.559,3777.559,3777.559,3777.559
y2000,BOL,28197.917,28197.917,28197.917,28197.917,28197.917,28197.917,28197.917,28197.917,28197.917,28197.917
y2000,BRA,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86,1389158.86
y2000,BRB,5428.331,5428.331,5428.331,5428.331,5428.331,5428.331,5428.331,5428.331,5428.331,5428.331
y2000,BRN,16200.831,16200.831,16200.831,16200.831,16200.831,16200.831,16200.831,16200.831,16200.831,16200.831
y2000,BTN,1591.623,1591.623,1591.623,1591.623,1591.623,1591.623,1591.623,1591.623,1591.623,1591.623
y2000,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2000,BWA,16440.957,16440.957,16440.957,16440.957,16440.957,16440.957,16440.957,16440.957,16440.957,16440.957
y2000,CAF,2687.645,2687.645,2687.645,2687.645,2687.645,2687.645,2687.645,2687.645,2687.645,2687.645
y2000,CAN,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173,1010066.173
y2000,CCK,30.988,30.988,30.988,30.988,30.988,30.988,30.988,30.988,30.988,30.988
y2000,CHE,253536.78,253536.78,253536.78,253536.78,253536.78,253536.78,253536.78,253536.78,253536.78,253536.78
y2000,CHL,155298.827,155298.827,155298.827,155298.827,155298.827,155298.827,155298.827,155298.827,155298.827,155298.827
y2000,CHN,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794,3454803.794
y2000,CIV,28023.194,28023.194,28023.194,28023.194,28023.194,28023.194,28023.194,28023.194,28023.194,28023.194
y2000,CMR,27573.964,27573.964,27573.964,27573.964,27573.964,27573.964,27573.964,27573.964,27573.964,27573.964
y2000,COD,9874.117,9874.117,9874.117,9874.117,9874.117,9874.117,9874.117,9874.117,9874.117,9874.117
y2000,COG,9550.32,9550.32,9550.32,9550.32,9550.32,9550.32,9550.32,9550.32,9550.32,9550.32
y2000,COK,162.217,162.217,162.217,162.217,162.217,162.217,162.217,162.217,162.217,162.217
y2000,COL,255367.681,255367.681,255367.681,255367.681,255367.681,255367.681,255367.681,255367.681,255367.681,255367.681
y2000,COM,567.841,567.841,567.841,567.841,567.841,567.841,567.841,567.841,567.841,567.841
y2000,CPV,1003.523,1003.523,1003.523,1003.523,1003.523,1003.523,1003.523,1003.523,1003.523,1003.523
y2000,CRI,32792.554,32792.554,32792.554,32792.554,32792.554,32792.554,32792.554,32792.554,32792.554,32792.554
y2000,CUB,69679.187,69679.187,69679.187,69679.187,69679.187,69679.187,69679.187,69679.187,69679.187,69679.187
y2000,CUW,1981.515,1981.515,1981.515,1981.515,1981.515,1981.515,1981.515,1981.515,1981.515,1981.515
y2000,CXR,95.109,95.109,95.109,95.109,95.109,95.109,95.109,95.109,95.109,95.109
y2000,CYM,4150.128,4150.128,4150.128,4150.128,4150.128,4150.128,4150.128,4150.128,4150.128,4150.128
y2000,CYP,19786.707,19786.707,19786.707,19786.707,19786.707,19786.707,19786.707,19786.707,19786.707,19786.707
y2000,CZE,173294.157,173294.157,173294.157,173294.157,173294.157,173294.157,173294.157,173294.157,173294.157,173294.157
y2000,DEU,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223,2499385.223
y2000,DJI,1351.788,1351.788,1351.788,1351.788,1351.788,1351.788,1351.788,1351.788,1351.788,1351.788
y2000,DMA,485.729,485.729,485.729,485.729,485.729,485.729,485.729,485.729,485.729,485.729
y2000,DNK,172232.304,172232.304,172232.304,172232.304,172232.304,172232.304,172232.304,172232.304,172232.304,172232.304
y2000,DOM,53187.009,53187.009,53187.009,53187.009,53187.009,53187.009,53187.009,53187.009,53187.009,53187.009
y2000,DZA,168157.356,168157.356,168157.356,168157.356,168157.356,168157.356,168157.356,168157.356,168157.356,168157.356
y2000,ECU,65839.754,65839.754,65839.754,65839.754,65839.754,65839.754,65839.754,65839.754,65839.754,65839.754
y2000,EGY,284606.991,284606.991,284606.991,284606.991,284606.991,284606.991,284606.991,284606.991,284606.991,284606.991
y2000,ERI,2656.977,2656.977,2656.977,2656.977,2656.977,2656.977,2656.977,2656.977,2656.977,2656.977
y2000,ESH,764.038,764.038,764.038,764.038,764.038,764.038,764.038,764.038,764.038,764.038
y2000,ESP,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196,1024912.196
y2000,EST,15140.998,15140.998,15140.998,15140.998,15140.998,15140.998,15140.998,15140.998,15140.998,15140.998
y2000,ETH,33788.881,33788.881,33788.881,33788.881,33788.881,33788.881,33788.881,33788.881,33788.881,33788.881
y2000,FIN,142698.61,142698.61,142698.61,142698.61,142698.61,142698.61,142698.61,142698.61,142698.61,142698.61
y2000,FJI,3242.278,3242.278,3242.278,3242.278,3242.278,3242.278,3242.278,3242.278,3242.278,3242.278
y2000,FLK,276.576,276.576,276.576,276.576,276.576,276.576,276.576,276.576,276.576,276.576
y2000,FRA,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177,1763784.177
y2000,FRO,1859.64,1859.64,1859.64,1859.64,1859.64,1859.64,1859.64,1859.64,1859.64,1859.64
y2000,FSM,358.485,358.485,358.485,358.485,358.485,358.485,358.485,358.485,358.485,358.485
y2000,GAB,15549.908,15549.908,15549.908,15549.908,15549.908,15549.908,15549.908,15549.908,15549.908,15549.908
y2000,GBR,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378,1743890.378
y2000,GEO,11638.505,11638.505,11638.505,11638.505,11638.505,11638.505,11638.505,11638.505,11638.505,11638.505
y2000,GGY,3131.048,3131.048,3131.048,3131.048,3131.048,3131.048,3131.048,3131.048,3131.048,3131.048
y2000,GHA,19203.09,19203.09,19203.09,19203.09,19203.09,19203.09,19203.09,19203.09,19203.09,19203.09
y2000,GIB,1687.557,1687.557,1687.557,1687.557,1687.557,1687.557,1687.557,1687.557,1687.557,1687.557
y2000,GIN,7950.618,7950.618,7950.618,7950.618,7950.618,7950.618,7950.618,7950.618,7950.618,7950.618
y2000,GLP,11752.046,11752.046,11752.046,11752.046,11752.046,11752.046,11752.046,11752.046,11752.046,11752.046
y2000,GMB,1402.358,1402.358,1402.358,1402.358,1402.358,1402.358,1402.358,1402.358,1402.358,1402.358
y2000,GNB,1066.943,1066.943,1066.943,1066.943,1066.943,1066.943,1066.943,1066.943,1066.943,1066.943
y2000,GNQ,3917.089,3917.089,3917.089,3917.089,3917.089,3917.089,3917.089,3917.089,3917.089,3917.089
y2000,GRC,226468.232,226468.232,226468.232,226468.232,226468.232,226468.232,226468.232,226468.232,226468.232,226468.232
y2000,GRD,947.607,947.607,947.607,947.607,947.607,947.607,947.607,947.607,947.607,947.607
y2000,GRL,2816.579,2816.579,2816.579,2816.579,2816.579,2816.579,2816.579,2816.579,2816.579,2816.579
y2000,GTM,52378.408,52378.408,52378.408,52378.408,52378.408,52378.408,52378.408,52378.408,52378.408,52378.408
y2000,GUF,3472.577,3472.577,3472.577,3472.577,3472.577,3472.577,3472.577,3472.577,3472.577,3472.577
y2000,GUM,4737.504,4737.504,4737.504,4737.504,4737.504,4737.504,4737.504,4737.504,4737.504,4737.504
y2000,GUY,2542.698,2542.698,2542.698,2542.698,2542.698,2542.698,2542.698,2542.698,2542.698,2542.698
y2000,HKG,195263.172,195263.172,195263.172,195263.172,195263.172,195263.172,195263.172,195263.172,195263.172,195263.172
y2000,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2000,HND,19927.868,19927.868,19927.868,19927.868,19927.868,19927.868,19927.868,19927.868,19927.868,19927.868
y2000,HRV,53339.364,53339.364,53339.364,53339.364,53339.364,53339.364,53339.364,53339.364,53339.364,53339.364
y2000,HTI,10963.981,10963.981,10963.981,10963.981,10963.981,10963.981,10963.981,10963.981,10963.981,10963.981
y2000,HUN,137700.56,137700.56,137700.56,137700.56,137700.56,137700.56,137700.56,137700.56,137700.56,137700.56
y2000,IDN,590581.743,590581.743,590581.743,590581.743,590581.743,590581.743,590581.743,590581.743,590581.743,590581.743
y2000,IMN,6497.788,6497.788,6497.788,6497.788,6497.788,6497.788,6497.788,6497.788,6497.788,6497.788
y2000,IND,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558,1871888.558
y2000,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2000,IRL,120739.275,120739.275,120739.275,120739.275,120739.275,120739.275,120739.275,120739.275,120739.275,120739.275
y2000,IRN,507480.108,507480.108,507480.108,507480.108,507480.108,507480.108,507480.108,507480.108,507480.108,507480.108
y2000,IRQ,97987.674,97987.674,97987.674,97987.674,97987.674,97987.674,97987.674,97987.674,97987.674,97987.674
y2000,ISL,8776.431,8776.431,8776.431,8776.431,8776.431,8776.431,8776.431,8776.431,8776.431,8776.431
y2000,ISR,147423.656,147423.656,147423.656,147423.656,147423.656,147423.656,147423.656,147423.656,147423.656,147423.656
y2000,ITA,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969,1594353.969
y2000,JAM,19583.808,19583.808,19583.808,19583.808,19583.808,19583.808,19583.808,19583.808,19583.808,19583.808
y2000,JEY,4452.426,4452.426,4452.426,4452.426,4452.426,4452.426,4452.426,4452.426,4452.426,4452.426
y2000,JOR,18424.463,18424.463,18424.463,18424.463,18424.463,18424.463,18424.463,18424.463,18424.463,18424.463
y2000,JPN,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144,3728664.144
y2000,KAZ,79030.298,79030.298,79030.298,79030.298,79030.298,79030.298,79030.298,79030.298,79030.298,79030.298
y2000,KEN,39199.976,39199.976,39199.976,39199.976,39199.976,39199.976,39199.976,39199.976,39199.976,39199.976
y2000,KGZ,7597.654,7597.654,7597.654,7597.654,7597.654,7597.654,7597.654,7597.654,7597.654,7597.654
y2000,KHM,12534.363,12534.363,12534.363,12534.363,12534.363,12534.363,12534.363,12534.363,12534.363,12534.363
y2000,KIR,287.894,287.894,287.894,287.894,287.894,287.894,287.894,287.894,287.894,287.894
y2000,KNA,522.061,522.061,522.061,522.061,522.061,522.061,522.061,522.061,522.061,522.061
y2000,KOR,883551.292,883551.292,883551.292,883551.292,883551.292,883551.292,883551.292,883551.292,883551.292,883551.292
y2000,KWT,72583.291,72583.291,72583.291,72583.291,72583.291,72583.291,72583.291,72583.291,72583.291,72583.291
y2000,LAO,7257.217,7257.217,7257.217,7257.217,7257.217,7257.217,7257.217,7257.217,7257.217,7257.217
y2000,LBN,28596.928,28596.928,28596.928,28596.928,28596.928,28596.928,28596.928,28596.928,28596.928,28596.928
y2000,LBR,1402.37,1402.37,1402.37,1402.37,1402.37,1402.37,1402.37,1402.37,1402.37,1402.37
y2000,LBY,71607.516,71607.516,71607.516,71607.516,71607.516,71607.516,71607.516,71607.516,71607.516,71607.516
y2000,LCA,1478.359,1478.359,1478.359,1478.359,1478.359,1478.359,1478.359,1478.359,1478.359,1478.359
y2000,LIE,5961.11,5961.11,5961.11,5961.11,5961.11,5961.11,5961.11,5961.11,5961.11,5961.11
y2000,LKA,56505.085,56505.085,56505.085,56505.085,56505.085,56505.085,56505.085,56505.085,56505.085,56505.085
y2000,LSO,2008.506,2008.506,2008.506,2008.506,2008.506,2008.506,2008.506,2008.506,2008.506,2008.506
y2000,LTU,32642.307,32642.307,32642.307,32642.307,32642.307,32642.307,32642.307,32642.307,32642.307,32642.307
y2000,LUX,27115.521,27115.521,27115.521,27115.521,27115.521,27115.521,27115.521,27115.521,27115.521,27115.521
y2000,LVA,20077.241,20077.241,20077.241,20077.241,20077.241,20077.241,20077.241,20077.241,20077.241,20077.241
y2000,MAC,9655.985,9655.985,9655.985,9655.985,9655.985,9655.985,9655.985,9655.985,9655.985,9655.985
y2000,MAF,449.808,449.808,449.808,449.808,449.808,449.808,449.808,449.808,449.808,449.808
y2000,MAR,81274.835,81274.835,81274.835,81274.835,81274.835,81274.835,81274.835,81274.835,81274.835,81274.835
y2000,MCO,6583.688,6583.688,6583.688,6583.688,6583.688,6583.688,6583.688,6583.688,6583.688,6583.688
y2000,MDA,5935.978,5935.978,5935.978,5935.978,5935.978,5935.978,5935.978,5935.978,5935.978,5935.978
y2000,MDG,13534.887,13534.887,13534.887,13534.887,13534.887,13534.887,13534.887,13534.887,13534.887,13534.887
y2000,MDV,943.837,943.837,943.837,943.837,943.837,943.837,943.837,943.837,943.837,943.837
y2000,MEX,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085,1177220.085
y2000,MHL,293.099,293.099,293.099,293.099,293.099,293.099,293.099,293.099,293.099,293.099
y2000,MKD,13927.347,13927.347,13927.347,13927.347,13927.347,13927.347,13927.347,13927.347,13927.347,13927.347
y2000,MLI,8616.72,8616.72,8616.72,8616.72,8616.72,8616.72,8616.72,8616.72,8616.72,8616.72
y2000,MLT,7938.754,7938.754,7938.754,7938.754,7938.754,7938.754,7938.754,7938.754,7938.754,7938.754
y2000,MMR,22381.619,22381.619,22381.619,22381.619,22381.619,22381.619,22381.619,22381.619,22381.619,22381.619
y2000,MNE,3716.258,3716.258,3716.258,3716.258,3716.258,3716.258,3716.258,3716.258,3716.258,3716.258
y2000,MNG,5015.172,5015.172,5015.172,5015.172,5015.172,5015.172,5015.172,5015.172,5015.172,5015.172
y2000,MNP,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172,910.172
y2000,MOZ,8739.609,8739.609,8739.609,8739.609,8739.609,8739.609,8739.609,8739.609,8739.609,8739.609
y2000,MRT,4007.009,4007.009,4007.009,4007.009,4007.009,4007.009,4007.009,4007.009,4007.009,4007.009
y2000,MSR,42.126,42.126,42.126,42.126,42.126,42.126,42.126,42.126,42.126,42.126
y2000,MTQ,11379.49,11379.49,11379.49,11379.49,11379.49,11379.49,11379.49,11379.49,11379.49,11379.49
y2000,MUS,10205.281,10205.281,10205.281,10205.281,10205.281,10205.281,10205.281,10205.281,10205.281,10205.281
y2000,MWI,7053.433,7053.433,7053.433,7053.433,7053.433,7053.433,7053.433,7053.433,7053.433,7053.433
y2000,MYS,233760.082,233760.082,233760.082,233760.082,233760.082,233760.082,233760.082,233760.082,233760.082,233760.082
y2000,MYT,1578.454,1578.454,1578.454,1578.454,1578.454,1578.454,1578.454,1578.454,1578.454,1578.454
y2000,NAM,8426.454,8426.454,8426.454,8426.454,8426.454,8426.454,8426.454,8426.454,8426.454,8426.454
y2000,NCL,10219.683,10219.683,10219.683,10219.683,10219.683,10219.683,10219.683,10219.683,10219.683,10219.683
y2000,NER,6137.981,6137.981,6137.981,6137.981,6137.981,6137.981,6137.981,6137.981,6137.981,6137.981
y2000,NFK,23.669,23.669,23.669,23.669,23.669,23.669,23.669,23.669,23.669,23.669
y2000,NGA,155461.441,155461.441,155461.441,155461.441,155461.441,155461.441,155461.441,155461.441,155461.441,155461.441
y2000,NIC,11024.87,11024.87,11024.87,11024.87,11024.87,11024.87,11024.87,11024.87,11024.87,11024.87
y2000,NIU,11.02,11.02,11.02,11.02,11.02,11.02,11.02,11.02,11.02,11.02
y2000,NLD,550246.859,550246.859,550246.859,550246.859,550246.859,550246.859,550246.859,550246.859,550246.859,550246.859
y2000,NOR,198039.025,198039.025,198039.025,198039.025,198039.025,198039.025,198039.025,198039.025,198039.025,198039.025
y2000,NPL,22745.208,22745.208,22745.208,22745.208,22745.208,22745.208,22745.208,22745.208,22745.208,22745.208
y2000,NRU,83.665,83.665,83.665,83.665,83.665,83.665,83.665,83.665,83.665,83.665
y2000,NZL,87656.473,87656.473,87656.473,87656.473,87656.473,87656.473,87656.473,87656.473,87656.473,87656.473
y2000,OMN,40537.89,40537.89,40537.89,40537.89,40537.89,40537.89,40537.89,40537.89,40537.89,40537.89
y2000,PAK,264632.113,264632.113,264632.113,264632.113,264632.113,264632.113,264632.113,264632.113,264632.113,264632.113
y2000,PAN,22751.345,22751.345,22751.345,22751.345,22751.345,22751.345,22751.345,22751.345,22751.345,22751.345
y2000,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2000,PER,140209.213,140209.213,140209.213,140209.213,140209.213,140209.213,140209.213,140209.213,140209.213,140209.213
y2000,PHL,197836.612,197836.612,197836.612,197836.612,197836.612,197836.612,197836.612,197836.612,197836.612,197836.612
y2000,PLW,246.085,246.085,246.085,246.085,246.085,246.085,246.085,246.085,246.085,246.085
y2000,PNG,10921.878,10921.878,10921.878,10921.878,10921.878,10921.878,10921.878,10921.878,10921.878,10921.878
y2000,POL,443948.922,443948.922,443948.922,443948.922,443948.922,443948.922,443948.922,443948.922,443948.922,443948.922
y2000,PRI,92706.189,92706.189,92706.189,92706.189,92706.189,92706.189,92706.189,92706.189,92706.189,92706.189
y2000,PRK,26835.181,26835.181,26835.181,26835.181,26835.181,26835.181,26835.181,26835.181,26835.181,26835.181
y2000,PRT,208636.017,208636.017,208636.017,208636.017,208636.017,208636.017,208636.017,208636.017,208636.017,208636.017
y2000,PRY,19461.301,19461.301,19461.301,19461.301,19461.301,19461.301,19461.301,19461.301,19461.301,19461.301
y2000,PSE,10093.54,10093.54,10093.54,10093.54,10093.54,10093.54,10093.54,10093.54,10093.54,10093.54
y2000,PYF,5887.968,5887.968,5887.968,5887.968,5887.968,5887.968,5887.968,5887.968,5887.968,5887.968
y2000,QAT,39273.983,39273.983,39273.983,39273.983,39273.983,39273.983,39273.983,39273.983,39273.983,39273.983
y2000,REU,19592.83,19592.83,19592.83,19592.83,19592.83,19592.83,19592.83,19592.83,19592.83,19592.83
y2000,ROU,148226.195,148226.195,148226.195,148226.195,148226.195,148226.195,148226.195,148226.195,148226.195,148226.195
y2000,RUS,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052,1272198.052
y2000,RWA,5317.476,5317.476,5317.476,5317.476,5317.476,5317.476,5317.476,5317.476,5317.476,5317.476
y2000,SAU,393715.234,393715.234,393715.234,393715.234,393715.234,393715.234,393715.234,393715.234,393715.234,393715.234
y2000,SDN,41657.321,41657.321,41657.321,41657.321,41657.321,41657.321,41657.321,41657.321,41657.321,41657.321
y2000,SEN,13813.121,13813.121,13813.121,13813.121,13813.121,13813.121,13813.121,13813.121,13813.121,13813.121
y2000,SGP,150502.28,150502.28,150502.28,150502.28,150502.28,150502.28,150502.28,150502.28,150502.28,150502.28
y2000,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2000,SHN,39.881,39.881,39.881,39.881,39.881,39.881,39.881,39.881,39.881,39.881
y2000,SJM,166.757,166.757,166.757,166.757,166.757,166.757,166.757,166.757,166.757,166.757
y2000,SLB,838.49,838.49,838.49,838.49,838.49,838.49,838.49,838.49,838.49,838.49
y2000,SLE,2058.361,2058.361,2058.361,2058.361,2058.361,2058.361,2058.361,2058.361,2058.361,2058.361
y2000,SLV,32352.993,32352.993,32352.993,32352.993,32352.993,32352.993,32352.993,32352.993,32352.993,32352.993
y2000,SMR,2042.353,2042.353,2042.353,2042.353,2042.353,2042.353,2042.353,2042.353,2042.353,2042.353
y2000,SOM,5488.028,5488.028,5488.028,5488.028,5488.028,5488.028,5488.028,5488.028,5488.028,5488.028
y2000,SPM,263.382,263.382,263.382,263.382,263.382,263.382,263.382,263.382,263.382,263.382
y2000,SRB,57365.33,57365.33,57365.33,57365.33,57365.33,57365.33,57365.33,57365.33,57365.33,57365.33
y2000,SSD,10039.498,10039.498,10039.498,10039.498,10039.498,10039.498,10039.498,10039.498,10039.498,10039.498
y2000,STP,151.218,151.218,151.218,151.218,151.218,151.218,151.218,151.218,151.218,151.218
y2000,SUR,2714.749,2714.749,2714.749,2714.749,2714.749,2714.749,2714.749,2714.749,2714.749,2714.749
y2000,SVK,68861.106,68861.106,68861.106,68861.106,68861.106,68861.106,68861.106,68861.106,68861.106,68861.106
y2000,SVN,38764.785,38764.785,38764.785,38764.785,38764.785,38764.785,38764.785,38764.785,38764.785,38764.785
y2000,SWE,264222.23,264222.23,264222.23,264222.23,264222.23,264222.23,264222.23,264222.23,264222.23,264222.23
y2000,SWZ,4107.04,4107.04,4107.04,4107.04,4107.04,4107.04,4107.04,4107.04,4107.04,4107.04
y2000,SXM,2100.12,2100.12,2100.12,2100.12,2100.12,2100.12,2100.12,2100.12,2100.12,2100.12
y2000,SYC,1458.721,1458.721,1458.721,1458.721,1458.721,1458.721,1458.721,1458.721,1458.721,1458.721
y2000,SYR,60613.073,60613.073,60613.073,60613.073,60613.073,60613.073,60613.073,60613.073,60613.073,60613.073
y2000,TCA,658.355,658.355,658.355,658.355,658.355,658.355,658.355,658.355,658.355,658.355
y2000,TCD,6838.037,6838.037,6838.037,6838.037,6838.037,6838.037,6838.037,6838.037,6838.037,6838.037
y2000,TGO,4053.237,4053.237,4053.237,4053.237,4053.237,4053.237,4053.237,4053.237,4053.237,4053.237
y2000,THA,354524.675,354524.675,354524.675,354524.675,354524.675,354524.675,354524.675,354524.675,354524.675,354524.675
y2000,TJK,6347.274,6347.274,6347.274,6347.274,6347.274,6347.274,6347.274,6347.274,6347.274,6347.274
y2000,TKL,1.552,1.552,1.552,1.552,1.552,1.552,1.552,1.552,1.552,1.552
y2000,TKM,13192.45,13192.45,13192.45,13192.45,13192.45,13192.45,13192.45,13192.45,13192.45,13192.45
y2000,TLS,1093.895,1093.895,1093.895,1093.895,1093.895,1093.895,1093.895,1093.895,1093.895,1093.895
y2000,TON,536.274,536.274,536.274,536.274,536.274,536.274,536.274,536.274,536.274,536.274
y2000,TTO,18220.068,18220.068,18220.068,18220.068,18220.068,18220.068,18220.068,18220.068,18220.068,18220.068
y2000,TUN,52197.15,52197.15,52197.15,52197.15,52197.15,52197.15,52197.15,52197.15,52197.15,52197.15
y2000,TUR,576249.168,576249.168,576249.168,576249.168,576249.168,576249.168,576249.168,576249.168,576249.168,576249.168
y2000,TUV,35.392,35.392,35.392,35.392,35.392,35.392,35.392,35.392,35.392,35.392
y2000,TWN,402449.589,402449.589,402449.589,402449.589,402449.589,402449.589,402449.589,402449.589,402449.589,402449.589
y2000,TZA,27794.842,27794.842,27794.842,27794.842,27794.842,27794.842,27794.842,27794.842,27794.842,27794.842
y2000,UGA,18841.913,18841.913,18841.913,18841.913,18841.913,18841.913,18841.913,18841.913,18841.913,18841.913
y2000,UKR,185982.713,185982.713,185982.713,185982.713,185982.713,185982.713,185982.713,185982.713,185982.713,185982.713
y2000,UMI,8.906,8.906,8.906,8.906,8.906,8.906,8.906,8.906,8.906,8.906
y2000,URY,30524.39,30524.39,30524.39,30524.39,30524.39,30524.39,30524.39,30524.39,30524.39,30524.39
y2000,USA,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279,11147091.279
y2000,UZB,38534.072,38534.072,38534.072,38534.072,38534.072,38534.072,38534.072,38534.072,38534.072,38534.072
y2000,VAT,29.906,29.906,29.906,29.906,29.906,29.906,29.906,29.906,29.906,29.906
y2000,VCT,624.806,624.806,624.806,624.806,624.806,624.806,624.806,624.806,624.806,624.806
y2000,VEN,224538.389,224538.389,224538.389,224538.389,224538.389,224538.389,224538.389,224538.389,224538.389,224538.389
y2000,VGB,1415.955,1415.955,1415.955,1415.955,1415.955,1415.955,1415.955,1415.955,1415.955,1415.955
y2000,VIR,3917.247,3917.247,3917.247,3917.247,3917.247,3917.247,3917.247,3917.247,3917.247,3917.247
y2000,VNM,130308.927,130308.927,130308.927,130308.927,130308.927,130308.927,130308.927,130308.927,130308.927,130308.927
y2000,VUT,830.154,830.154,830.154,830.154,830.154,830.154,830.154,830.154,830.154,830.154
y2000,WLF,189.94,189.94,189.94,189.94,189.94,189.94,189.94,189.94,189.94,189.94
y2000,WSM,730.871,730.871,730.871,730.871,730.871,730.871,730.871,730.871,730.871,730.871
y2000,YEM,37422.024,37422.024,37422.024,37422.024,37422.024,37422.024,37422.024,37422.024,37422.024,37422.024
y2000,ZAF,321404.754,321404.754,321404.754,321404.754,321404.754,321404.754,321404.754,321404.754,321404.754,321404.754
y2000,ZMB,10072.506,10072.506,10072.506,10072.506,10072.506,10072.506,10072.506,10072.506,10072.506,10072.506
y2000,ZWE,7510.959,7510.959,7510.959,7510.959,7510.959,7510.959,7510.959,7510.959,7510.959,7510.959
y2005,ABW,3931.503,3931.503,3931.503,3931.503,3931.503,3931.503,3931.503,3931.503,3931.503,3931.503
y2005,AFG,17660.344,17660.344,17660.344,17660.344,17660.344,17660.344,17660.344,17660.344,17660.344,17660.344
y2005,AGO,69174.489,69174.489,69174.489,69174.489,69174.489,69174.489,69174.489,69174.489,69174.489,69174.489
y2005,AIA,154.171,154.171,154.171,154.171,154.171,154.171,154.171,154.171,154.171,154.171
y2005,ALA,1487.731,1487.731,1487.731,1487.731,1487.731,1487.731,1487.731,1487.731,1487.731,1487.731
y2005,ALB,16607.902,16607.902,16607.902,16607.902,16607.902,16607.902,16607.902,16607.902,16607.902,16607.902
y2005,AND,4247.777,4247.777,4247.777,4247.777,4247.777,4247.777,4247.777,4247.777,4247.777,4247.777
y2005,ARE,199458.747,199458.747,199458.747,199458.747,199458.747,199458.747,199458.747,199458.747,199458.747,199458.747
y2005,ARG,413036.57,413036.57,413036.57,413036.57,413036.57,413036.57,413036.57,413036.57,413036.57,413036.57
y2005,ARM,12464.629,12464.629,12464.629,12464.629,12464.629,12464.629,12464.629,12464.629,12464.629,12464.629
y2005,ASM,768.521,768.521,768.521,768.521,768.521,768.521,768.521,768.521,768.521,768.521
y2005,ATA,10,10,10,10,10,10,10,10,10,10
y2005,ATF,2.874,2.874,2.874,2.874,2.874,2.874,2.874,2.874,2.874,2.874
y2005,ATG,1353.891,1353.891,1353.891,1353.891,1353.891,1353.891,1353.891,1353.891,1353.891,1353.891
y2005,AUS,713567.348,713567.348,713567.348,713567.348,713567.348,713567.348,713567.348,713567.348,713567.348,713567.348
y2005,AUT,282230.168,282230.168,282230.168,282230.168,282230.168,282230.168,282230.168,282230.168,282230.168,282230.168
y2005,AZE,38362.092,38362.092,38362.092,38362.092,38362.092,38362.092,38362.092,38362.092,38362.092,38362.092
y2005,BDI,2582.856,2582.856,2582.856,2582.856,2582.856,2582.856,2582.856,2582.856,2582.856,2582.856
y2005,BEL,342113.013,342113.013,342113.013,342113.013,342113.013,342113.013,342113.013,342113.013,342113.013,342113.013
y2005,BEN,9989.723,9989.723,9989.723,9989.723,9989.723,9989.723,9989.723,9989.723,9989.723,9989.723
y2005,BES,273.638,273.638,273.638,273.638,273.638,273.638,273.638,273.638,273.638,273.638
y2005,BFA,13456.196,13456.196,13456.196,13456.196,13456.196,13456.196,13456.196,13456.196,13456.196,13456.196
y2005,BGD,162324.276,162324.276,162324.276,162324.276,162324.276,162324.276,162324.276,162324.276,162324.276,162324.276
y2005,BGR,72374.245,72374.245,72374.245,72374.245,72374.245,72374.245,72374.245,72374.245,72374.245,72374.245
y2005,BHR,23137.716,23137.716,23137.716,23137.716,23137.716,23137.716,23137.716,23137.716,23137.716,23137.716
y2005,BHS,9129.472,9129.472,9129.472,9129.472,9129.472,9129.472,9129.472,9129.472,9129.472,9129.472
y2005,BIH,21714.585,21714.585,21714.585,21714.585,21714.585,21714.585,21714.585,21714.585,21714.585,21714.585
y2005,BLM,224.822,224.822,224.822,224.822,224.822,224.822,224.822,224.822,224.822,224.822
y2005,BLR,85396.934,85396.934,85396.934,85396.934,85396.934,85396.934,85396.934,85396.934,85396.934,85396.934
y2005,BLZ,2134.534,2134.534,2134.534,2134.534,2134.534,2134.534,2134.534,2134.534,2134.534,2134.534
y2005,BMU,4591.372,4591.372,4591.372,4591.372,4591.372,4591.372,4591.372,4591.372,4591.372,4591.372
y2005,BOL,33005.135,33005.135,33005.135,33005.135,33005.135,33005.135,33005.135,33005.135,33005.135,33005.135
y2005,BRA,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773,1586225.773
y2005,BRB,5734.351,5734.351,5734.351,5734.351,5734.351,5734.351,5734.351,5734.351,5734.351,5734.351
y2005,BRN,17642.021,17642.021,17642.021,17642.021,17642.021,17642.021,17642.021,17642.021,17642.021,17642.021
y2005,BTN,2299.09,2299.09,2299.09,2299.09,2299.09,2299.09,2299.09,2299.09,2299.09,2299.09
y2005,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2005,BWA,20780.142,20780.142,20780.142,20780.142,20780.142,20780.142,20780.142,20780.142,20780.142,20780.142
y2005,CAF,2564.254,2564.254,2564.254,2564.254,2564.254,2564.254,2564.254,2564.254,2564.254,2564.254
y2005,CAN,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16,1148505.16
y2005,CCK,30.439,30.439,30.439,30.439,30.439,30.439,30.439,30.439,30.439,30.439
y2005,CHE,270627.69,270627.69,270627.69,270627.69,270627.69,270627.69,270627.69,270627.69,270627.69,270627.69
y2005,CHL,191762.209,191762.209,191762.209,191762.209,191762.209,191762.209,191762.209,191762.209,191762.209,191762.209
y2005,CHN,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28,5628979.28
y2005,CIV,27313.885,27313.885,27313.885,27313.885,27313.885,27313.885,27313.885,27313.885,27313.885,27313.885
y2005,CMR,33114.475,33114.475,33114.475,33114.475,33114.475,33114.475,33114.475,33114.475,33114.475,33114.475
y2005,COD,13874.095,13874.095,13874.095,13874.095,13874.095,13874.095,13874.095,13874.095,13874.095,13874.095
y2005,COG,11465.723,11465.723,11465.723,11465.723,11465.723,11465.723,11465.723,11465.723,11465.723,11465.723
y2005,COK,176.531,176.531,176.531,176.531,176.531,176.531,176.531,176.531,176.531,176.531
y2005,COL,307451.106,307451.106,307451.106,307451.106,307451.106,307451.106,307451.106,307451.106,307451.106,307451.106
y2005,COM,650.909,650.909,650.909,650.909,650.909,650.909,650.909,650.909,650.909,650.909
y2005,CPV,1291.309,1291.309,1291.309,1291.309,1291.309,1291.309,1291.309,1291.309,1291.309,1291.309
y2005,CRI,39207.666,39207.666,39207.666,39207.666,39207.666,39207.666,39207.666,39207.666,39207.666,39207.666
y2005,CUB,81612.175,81612.175,81612.175,81612.175,81612.175,81612.175,81612.175,81612.175,81612.175,81612.175
y2005,CUW,1940.97,1940.97,1940.97,1940.97,1940.97,1940.97,1940.97,1940.97,1940.97,1940.97
y2005,CXR,93.562,93.562,93.562,93.562,93.562,93.562,93.562,93.562,93.562,93.562
y2005,CYM,4189.851,4189.851,4189.851,4189.851,4189.851,4189.851,4189.851,4189.851,4189.851,4189.851
y2005,CYP,23156.187,23156.187,23156.187,23156.187,23156.187,23156.187,23156.187,23156.187,23156.187,23156.187
y2005,CZE,208722.769,208722.769,208722.769,208722.769,208722.769,208722.769,208722.769,208722.769,208722.769,208722.769
y2005,DEU,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866,2569809.866
y2005,DJI,1589.426,1589.426,1589.426,1589.426,1589.426,1589.426,1589.426,1589.426,1589.426,1589.426
y2005,DMA,488.805,488.805,488.805,488.805,488.805,488.805,488.805,488.805,488.805,488.805
y2005,DNK,183252.999,183252.999,183252.999,183252.999,183252.999,183252.999,183252.999,183252.999,183252.999,183252.999
y2005,DOM,62669.819,62669.819,62669.819,62669.819,62669.819,62669.819,62669.819,62669.819,62669.819,62669.819
y2005,DZA,212307.293,212307.293,212307.293,212307.293,212307.293,212307.293,212307.293,212307.293,212307.293,212307.293
y2005,ECU,87564.335,87564.335,87564.335,87564.335,87564.335,87564.335,87564.335,87564.335,87564.335,87564.335
y2005,EGY,341966.651,341966.651,341966.651,341966.651,341966.651,341966.651,341966.651,341966.651,341966.651,341966.651
y2005,ERI,2813.429,2813.429,2813.429,2813.429,2813.429,2813.429,2813.429,2813.429,2813.429,2813.429
y2005,ESH,1069.455,1069.455,1069.455,1069.455,1069.455,1069.455,1069.455,1069.455,1069.455,1069.455
y2005,ESP,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775,1205836.775
y2005,EST,22267.326,22267.326,22267.326,22267.326,22267.326,22267.326,22267.326,22267.326,22267.326,22267.326
y2005,ETH,45405.768,45405.768,45405.768,45405.768,45405.768,45405.768,45405.768,45405.768,45405.768,45405.768
y2005,FIN,162414.306,162414.306,162414.306,162414.306,162414.306,162414.306,162414.306,162414.306,162414.306,162414.306
y2005,FJI,3552.939,3552.939,3552.939,3552.939,3552.939,3552.939,3552.939,3552.939,3552.939,3552.939
y2005,FLK,282.432,282.432,282.432,282.432,282.432,282.432,282.432,282.432,282.432,282.432
y2005,FRA,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242,1923358.242
y2005,FRO,1933.48,1933.48,1933.48,1933.48,1933.48,1933.48,1933.48,1933.48,1933.48,1933.48
y2005,FSM,359.378,359.378,359.378,359.378,359.378,359.378,359.378,359.378,359.378,359.378
y2005,GAB,17028.323,17028.323,17028.323,17028.323,17028.323,17028.323,17028.323,17028.323,17028.323,17028.323
y2005,GBR,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249,1993187.249
y2005,GEO,15467.423,15467.423,15467.423,15467.423,15467.423,15467.423,15467.423,15467.423,15467.423,15467.423
y2005,GGY,3202.5,3202.5,3202.5,3202.5,3202.5,3202.5,3202.5,3202.5,3202.5,3202.5
y2005,GHA,25055.877,25055.877,25055.877,25055.877,25055.877,25055.877,25055.877,25055.877,25055.877,25055.877
y2005,GIB,1794.236,1794.236,1794.236,1794.236,1794.236,1794.236,1794.236,1794.236,1794.236,1794.236
y2005,GIN,9307.623,9307.623,9307.623,9307.623,9307.623,9307.623,9307.623,9307.623,9307.623,9307.623
y2005,GLP,12286.392,12286.392,12286.392,12286.392,12286.392,12286.392,12286.392,12286.392,12286.392,12286.392
y2005,GMB,1862.766,1862.766,1862.766,1862.766,1862.766,1862.766,1862.766,1862.766,1862.766,1862.766
y2005,GNB,1261.34,1261.34,1261.34,1261.34,1261.34,1261.34,1261.34,1261.34,1261.34,1261.34
y2005,GNQ,13488.619,13488.619,13488.619,13488.619,13488.619,13488.619,13488.619,13488.619,13488.619,13488.619
y2005,GRC,276555.967,276555.967,276555.967,276555.967,276555.967,276555.967,276555.967,276555.967,276555.967,276555.967
y2005,GRD,1054.229,1054.229,1054.229,1054.229,1054.229,1054.229,1054.229,1054.229,1054.229,1054.229
y2005,GRL,2937.327,2937.327,2937.327,2937.327,2937.327,2937.327,2937.327,2937.327,2937.327,2937.327
y2005,GTM,60568.003,60568.003,60568.003,60568.003,60568.003,60568.003,60568.003,60568.003,60568.003,60568.003
y2005,GUF,4330.984,4330.984,4330.984,4330.984,4330.984,4330.984,4330.984,4330.984,4330.984,4330.984
y2005,GUM,4831.23,4831.23,4831.23,4831.23,4831.23,4831.23,4831.23,4831.23,4831.23,4831.23
y2005,GUY,2570.697,2570.697,2570.697,2570.697,2570.697,2570.697,2570.697,2570.697,2570.697,2570.697
y2005,HKG,236896.327,236896.327,236896.327,236896.327,236896.327,236896.327,236896.327,236896.327,236896.327,236896.327
y2005,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2005,HND,25306.917,25306.917,25306.917,25306.917,25306.917,25306.917,25306.917,25306.917,25306.917,25306.917
y2005,HRV,65982.534,65982.534,65982.534,65982.534,65982.534,65982.534,65982.534,65982.534,65982.534,65982.534
y2005,HTI,10645.458,10645.458,10645.458,10645.458,10645.458,10645.458,10645.458,10645.458,10645.458,10645.458
y2005,HUN,169948.384,169948.384,169948.384,169948.384,169948.384,169948.384,169948.384,169948.384,169948.384,169948.384
y2005,IDN,745945.187,745945.187,745945.187,745945.187,745945.187,745945.187,745945.187,745945.187,745945.187,745945.187
y2005,IMN,6797.187,6797.187,6797.187,6797.187,6797.187,6797.187,6797.187,6797.187,6797.187,6797.187
y2005,IND,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708,2673101.708
y2005,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2005,IRL,158077.938,158077.938,158077.938,158077.938,158077.938,158077.938,158077.938,158077.938,158077.938,158077.938
y2005,IRN,650712.533,650712.533,650712.533,650712.533,650712.533,650712.533,650712.533,650712.533,650712.533,650712.533
y2005,IRQ,86538.049,86538.049,86538.049,86538.049,86538.049,86538.049,86538.049,86538.049,86538.049,86538.049
y2005,ISL,10888.871,10888.871,10888.871,10888.871,10888.871,10888.871,10888.871,10888.871,10888.871,10888.871
y2005,ISR,164998.474,164998.474,164998.474,164998.474,164998.474,164998.474,164998.474,164998.474,164998.474,164998.474
y2005,ITA,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595,1655016.595
y2005,JAM,21502.962,21502.962,21502.962,21502.962,21502.962,21502.962,21502.962,21502.962,21502.962,21502.962
y2005,JEY,4554,4554,4554,4554,4554,4554,4554,4554,4554,4554
y2005,JOR,24794.419,24794.419,24794.419,24794.419,24794.419,24794.419,24794.419,24794.419,24794.419,24794.419
y2005,JPN,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773,3977436.773
y2005,KAZ,133122.785,133122.785,133122.785,133122.785,133122.785,133122.785,133122.785,133122.785,133122.785,133122.785
y2005,KEN,47399.173,47399.173,47399.173,47399.173,47399.173,47399.173,47399.173,47399.173,47399.173,47399.173
y2005,KGZ,9270.625,9270.625,9270.625,9270.625,9270.625,9270.625,9270.625,9270.625,9270.625,9270.625
y2005,KHM,19770.45,19770.45,19770.45,19770.45,19770.45,19770.45,19770.45,19770.45,19770.45,19770.45
y2005,KIR,312.852,312.852,312.852,312.852,312.852,312.852,312.852,312.852,312.852,312.852
y2005,KNA,620.351,620.351,620.351,620.351,620.351,620.351,620.351,620.351,620.351,620.351
y2005,KOR,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868,1098199.868
y2005,KWT,98443.888,98443.888,98443.888,98443.888,98443.888,98443.888,98443.888,98443.888,98443.888,98443.888
y2005,LAO,9862.257,9862.257,9862.257,9862.257,9862.257,9862.257,9862.257,9862.257,9862.257,9862.257
y2005,LBN,39729.439,39729.439,39729.439,39729.439,39729.439,39729.439,39729.439,39729.439,39729.439,39729.439
y2005,LBR,1070.742,1070.742,1070.742,1070.742,1070.742,1070.742,1070.742,1070.742,1070.742,1070.742
y2005,LBY,83738.345,83738.345,83738.345,83738.345,83738.345,83738.345,83738.345,83738.345,83738.345,83738.345
y2005,LCA,1634.499,1634.499,1634.499,1634.499,1634.499,1634.499,1634.499,1634.499,1634.499,1634.499
y2005,LIE,6153.591,6153.591,6153.591,6153.591,6153.591,6153.591,6153.591,6153.591,6153.591,6153.591
y2005,LKA,67836.691,67836.691,67836.691,67836.691,67836.691,67836.691,67836.691,67836.691,67836.691,67836.691
y2005,LSO,2209.875,2209.875,2209.875,2209.875,2209.875,2209.875,2209.875,2209.875,2209.875,2209.875
y2005,LTU,46131.075,46131.075,46131.075,46131.075,46131.075,46131.075,46131.075,46131.075,46131.075,46131.075
y2005,LUX,32568.344,32568.344,32568.344,32568.344,32568.344,32568.344,32568.344,32568.344,32568.344,32568.344
y2005,LVA,28858.903,28858.903,28858.903,28858.903,28858.903,28858.903,28858.903,28858.903,28858.903,28858.903
y2005,MAC,17589.763,17589.763,17589.763,17589.763,17589.763,17589.763,17589.763,17589.763,17589.763,17589.763
y2005,MAF,545.468,545.468,545.468,545.468,545.468,545.468,545.468,545.468,545.468,545.468
y2005,MAR,102910.974,102910.974,102910.974,102910.974,102910.974,102910.974,102910.974,102910.974,102910.974,102910.974
y2005,MCO,7425.157,7425.157,7425.157,7425.157,7425.157,7425.157,7425.157,7425.157,7425.157,7425.157
y2005,MDA,8337.954,8337.954,8337.954,8337.954,8337.954,8337.954,8337.954,8337.954,8337.954,8337.954
y2005,MDG,15018.982,15018.982,15018.982,15018.982,15018.982,15018.982,15018.982,15018.982,15018.982,15018.982
y2005,MDV,1353.033,1353.033,1353.033,1353.033,1353.033,1353.033,1353.033,1353.033,1353.033,1353.033
y2005,MEX,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578,1339485.578
y2005,MHL,316.711,316.711,316.711,316.711,316.711,316.711,316.711,316.711,316.711,316.711
y2005,MKD,14871.181,14871.181,14871.181,14871.181,14871.181,14871.181,14871.181,14871.181,14871.181,14871.181
y2005,MLI,12122.415,12122.415,12122.415,12122.415,12122.415,12122.415,12122.415,12122.415,12122.415,12122.415
y2005,MLT,8375.715,8375.715,8375.715,8375.715,8375.715,8375.715,8375.715,8375.715,8375.715,8375.715
y2005,MMR,39800.527,39800.527,39800.527,39800.527,39800.527,39800.527,39800.527,39800.527,39800.527,39800.527
y2005,MNE,4527.171,4527.171,4527.171,4527.171,4527.171,4527.171,4527.171,4527.171,4527.171,4527.171
y2005,MNG,6595.558,6595.558,6595.558,6595.558,6595.558,6595.558,6595.558,6595.558,6595.558,6595.558
y2005,MNP,856.148,856.148,856.148,856.148,856.148,856.148,856.148,856.148,856.148,856.148
y2005,MOZ,14038.591,14038.591,14038.591,14038.591,14038.591,14038.591,14038.591,14038.591,14038.591,14038.591
y2005,MRT,5022.764,5022.764,5022.764,5022.764,5022.764,5022.764,5022.764,5022.764,5022.764,5022.764
y2005,MSR,40.604,40.604,40.604,40.604,40.604,40.604,40.604,40.604,40.604,40.604
y2005,MTQ,11674.638,11674.638,11674.638,11674.638,11674.638,11674.638,11674.638,11674.638,11674.638,11674.638
y2005,MUS,11722.994,11722.994,11722.994,11722.994,11722.994,11722.994,11722.994,11722.994,11722.994,11722.994
y2005,MWI,7763.195,7763.195,7763.195,7763.195,7763.195,7763.195,7763.195,7763.195,7763.195,7763.195
y2005,MYS,291518.93,291518.93,291518.93,291518.93,291518.93,291518.93,291518.93,291518.93,291518.93,291518.93
y2005,MYT,1870.081,1870.081,1870.081,1870.081,1870.081,1870.081,1870.081,1870.081,1870.081,1870.081
y2005,NAM,10350.021,10350.021,10350.021,10350.021,10350.021,10350.021,10350.021,10350.021,10350.021,10350.021
y2005,NCL,10492.428,10492.428,10492.428,10492.428,10492.428,10492.428,10492.428,10492.428,10492.428,10492.428
y2005,NER,7960.276,7960.276,7960.276,7960.276,7960.276,7960.276,7960.276,7960.276,7960.276,7960.276
y2005,NFK,16.662,16.662,16.662,16.662,16.662,16.662,16.662,16.662,16.662,16.662
y2005,NGA,235084.207,235084.207,235084.207,235084.207,235084.207,235084.207,235084.207,235084.207,235084.207,235084.207
y2005,NIC,12430.901,12430.901,12430.901,12430.901,12430.901,12430.901,12430.901,12430.901,12430.901,12430.901
y2005,NIU,9.779,9.779,9.779,9.779,9.779,9.779,9.779,9.779,9.779,9.779
y2005,NLD,589743.889,589743.889,589743.889,589743.889,589743.889,589743.889,589743.889,589743.889,589743.889,589743.889
y2005,NOR,221187.95,221187.95,221187.95,221187.95,221187.95,221187.95,221187.95,221187.95,221187.95,221187.95
y2005,NPL,25391.043,25391.043,25391.043,25391.043,25391.043,25391.043,25391.043,25391.043,25391.043,25391.043
y2005,NRU,48.208,48.208,48.208,48.208,48.208,48.208,48.208,48.208,48.208,48.208
y2005,NZL,106978.098,106978.098,106978.098,106978.098,106978.098,106978.098,106978.098,106978.098,106978.098,106978.098
y2005,OMN,48111.268,48111.268,48111.268,48111.268,48111.268,48111.268,48111.268,48111.268,48111.268,48111.268
y2005,PAK,334897.277,334897.277,334897.277,334897.277,334897.277,334897.277,334897.277,334897.277,334897.277,334897.277
y2005,PAN,28152.624,28152.624,28152.624,28152.624,28152.624,28152.624,28152.624,28152.624,28152.624,28152.624
y2005,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2005,PER,171513.989,171513.989,171513.989,171513.989,171513.989,171513.989,171513.989,171513.989,171513.989,171513.989
y2005,PHL,239379.259,239379.259,239379.259,239379.259,239379.259,239379.259,239379.259,239379.259,239379.259,239379.259
y2005,PLW,266.315,266.315,266.315,266.315,266.315,266.315,266.315,266.315,266.315,266.315
y2005,PNG,12265.804,12265.804,12265.804,12265.804,12265.804,12265.804,12265.804,12265.804,12265.804,12265.804
y2005,POL,519520.632,519520.632,519520.632,519520.632,519520.632,519520.632,519520.632,519520.632,519520.632,519520.632
y2005,PRI,95759.854,95759.854,95759.854,95759.854,95759.854,95759.854,95759.854,95759.854,95759.854,95759.854
y2005,PRK,28624.069,28624.069,28624.069,28624.069,28624.069,28624.069,28624.069,28624.069,28624.069,28624.069
y2005,PRT,217174.624,217174.624,217174.624,217174.624,217174.624,217174.624,217174.624,217174.624,217174.624,217174.624
y2005,PRY,22068.372,22068.372,22068.372,22068.372,22068.372,22068.372,22068.372,22068.372,22068.372,22068.372
y2005,PSE,7977.002,7977.002,7977.002,7977.002,7977.002,7977.002,7977.002,7977.002,7977.002,7977.002
y2005,PYF,6426.018,6426.018,6426.018,6426.018,6426.018,6426.018,6426.018,6426.018,6426.018,6426.018
y2005,QAT,59276.525,59276.525,59276.525,59276.525,59276.525,59276.525,59276.525,59276.525,59276.525,59276.525
y2005,REU,21052.656,21052.656,21052.656,21052.656,21052.656,21052.656,21052.656,21052.656,21052.656,21052.656
y2005,ROU,192645.505,192645.505,192645.505,192645.505,192645.505,192645.505,192645.505,192645.505,192645.505,192645.505
y2005,RUS,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248,1723828.248
y2005,RWA,7657.152,7657.152,7657.152,7657.152,7657.152,7657.152,7657.152,7657.152,7657.152,7657.152
y2005,SAU,494968.957,494968.957,494968.957,494968.957,494968.957,494968.957,494968.957,494968.957,494968.957,494968.957
y2005,SDN,53905.587,53905.587,53905.587,53905.587,53905.587,53905.587,53905.587,53905.587,53905.587,53905.587
y2005,SEN,17417.826,17417.826,17417.826,17417.826,17417.826,17417.826,17417.826,17417.826,17417.826,17417.826
y2005,SGP,186577.178,186577.178,186577.178,186577.178,186577.178,186577.178,186577.178,186577.178,186577.178,186577.178
y2005,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2005,SHN,33.337,33.337,33.337,33.337,33.337,33.337,33.337,33.337,33.337,33.337
y2005,SJM,171.699,171.699,171.699,171.699,171.699,171.699,171.699,171.699,171.699,171.699
y2005,SLB,914.726,914.726,914.726,914.726,914.726,914.726,914.726,914.726,914.726,914.726
y2005,SLE,3842.056,3842.056,3842.056,3842.056,3842.056,3842.056,3842.056,3842.056,3842.056,3842.056
y2005,SLV,36368.544,36368.544,36368.544,36368.544,36368.544,36368.544,36368.544,36368.544,36368.544,36368.544
y2005,SMR,2290.206,2290.206,2290.206,2290.206,2290.206,2290.206,2290.206,2290.206,2290.206,2290.206
y2005,SOM,6428.943,6428.943,6428.943,6428.943,6428.943,6428.943,6428.943,6428.943,6428.943,6428.943
y2005,SPM,262.878,262.878,262.878,262.878,262.878,262.878,262.878,262.878,262.878,262.878
y2005,SRB,73548.827,73548.827,73548.827,73548.827,73548.827,73548.827,73548.827,73548.827,73548.827,73548.827
y2005,SSD,12149.862,12149.862,12149.862,12149.862,12149.862,12149.862,12149.862,12149.862,12149.862,12149.862
y2005,STP,220.367,220.367,220.367,220.367,220.367,220.367,220.367,220.367,220.367,220.367
y2005,SUR,3708.265,3708.265,3708.265,3708.265,3708.265,3708.265,3708.265,3708.265,3708.265,3708.265
y2005,SVK,86652.363,86652.363,86652.363,86652.363,86652.363,86652.363,86652.363,86652.363,86652.363,86652.363
y2005,SVN,46784.665,46784.665,46784.665,46784.665,46784.665,46784.665,46784.665,46784.665,46784.665,46784.665
y2005,SWE,303166.435,303166.435,303166.435,303166.435,303166.435,303166.435,303166.435,303166.435,303166.435,303166.435
y2005,SWZ,4597.83,4597.83,4597.83,4597.83,4597.83,4597.83,4597.83,4597.83,4597.83,4597.83
y2005,SXM,2146.848,2146.848,2146.848,2146.848,2146.848,2146.848,2146.848,2146.848,2146.848,2146.848
y2005,SYC,1581.549,1581.549,1581.549,1581.549,1581.549,1581.549,1581.549,1581.549,1581.549,1581.549
y2005,SYR,72849.708,72849.708,72849.708,72849.708,72849.708,72849.708,72849.708,72849.708,72849.708,72849.708
y2005,TCA,862.096,862.096,862.096,862.096,862.096,862.096,862.096,862.096,862.096,862.096
y2005,TCD,14374.853,14374.853,14374.853,14374.853,14374.853,14374.853,14374.853,14374.853,14374.853,14374.853
y2005,TGO,4291.363,4291.363,4291.363,4291.363,4291.363,4291.363,4291.363,4291.363,4291.363,4291.363
y2005,THA,451394.394,451394.394,451394.394,451394.394,451394.394,451394.394,451394.394,451394.394,451394.394,451394.394
y2005,TJK,10089.662,10089.662,10089.662,10089.662,10089.662,10089.662,10089.662,10089.662,10089.662,10089.662
y2005,TKL,1.21,1.21,1.21,1.21,1.21,1.21,1.21,1.21,1.21,1.21
y2005,TKM,21974.263,21974.263,21974.263,21974.263,21974.263,21974.263,21974.263,21974.263,21974.263,21974.263
y2005,TLS,1260.901,1260.901,1260.901,1260.901,1260.901,1260.901,1260.901,1260.901,1260.901,1260.901
y2005,TON,581.593,581.593,581.593,581.593,581.593,581.593,581.593,581.593,581.593,581.593
y2005,TTO,27348.784,27348.784,27348.784,27348.784,27348.784,27348.784,27348.784,27348.784,27348.784,27348.784
y2005,TUN,64004.719,64004.719,64004.719,64004.719,64004.719,64004.719,64004.719,64004.719,64004.719,64004.719
y2005,TUR,717620.849,717620.849,717620.849,717620.849,717620.849,717620.849,717620.849,717620.849,717620.849,717620.849
y2005,TUV,43.332,43.332,43.332,43.332,43.332,43.332,43.332,43.332,43.332,43.332
y2005,TWN,482098.002,482098.002,482098.002,482098.002,482098.002,482098.002,482098.002,482098.002,482098.002,482098.002
y2005,TZA,40481.369,40481.369,40481.369,40481.369,40481.369,40481.369,40481.369,40481.369,40481.369,40481.369
y2005,UGA,26665.061,26665.061,26665.061,26665.061,26665.061,26665.061,26665.061,26665.061,26665.061,26665.061
y2005,UKR,270675.613,270675.613,270675.613,270675.613,270675.613,270675.613,270675.613,270675.613,270675.613,270675.613
y2005,UMI,9.089,9.089,9.089,9.089,9.089,9.089,9.089,9.089,9.089,9.089
y2005,URY,31356.437,31356.437,31356.437,31356.437,31356.437,31356.437,31356.437,31356.437,31356.437,31356.437
y2005,USA,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945,12584074.945
y2005,UZB,50194.377,50194.377,50194.377,50194.377,50194.377,50194.377,50194.377,50194.377,50194.377,50194.377
y2005,VAT,30.324,30.324,30.324,30.324,30.324,30.324,30.324,30.324,30.324,30.324
y2005,VCT,738.659,738.659,738.659,738.659,738.659,738.659,738.659,738.659,738.659,738.659
y2005,VEN,254166.876,254166.876,254166.876,254166.876,254166.876,254166.876,254166.876,254166.876,254166.876,254166.876
y2005,VGB,1642.967,1642.967,1642.967,1642.967,1642.967,1642.967,1642.967,1642.967,1642.967,1642.967
y2005,VIR,3890.425,3890.425,3890.425,3890.425,3890.425,3890.425,3890.425,3890.425,3890.425,3890.425
y2005,VNM,185633.993,185633.993,185633.993,185633.993,185633.993,185633.993,185633.993,185633.993,185633.993,185633.993
y2005,VUT,885.539,885.539,885.539,885.539,885.539,885.539,885.539,885.539,885.539,885.539
y2005,WLF,186.651,186.651,186.651,186.651,186.651,186.651,186.651,186.651,186.651,186.651
y2005,WSM,938.689,938.689,938.689,938.689,938.689,938.689,938.689,938.689,938.689,938.689
y2005,YEM,45486.128,45486.128,45486.128,45486.128,45486.128,45486.128,45486.128,45486.128,45486.128,45486.128
y2005,ZAF,394004.245,394004.245,394004.245,394004.245,394004.245,394004.245,394004.245,394004.245,394004.245,394004.245
y2005,ZMB,13226.819,13226.819,13226.819,13226.819,13226.819,13226.819,13226.819,13226.819,13226.819,13226.819
y2005,ZWE,5294.497,5294.497,5294.497,5294.497,5294.497,5294.497,5294.497,5294.497,5294.497,5294.497
y2010,ABW,3186.183,3186.183,3186.183,3186.183,3186.183,3186.183,3186.183,3186.183,3186.183,3186.183
y2010,AFG,32652.969,32652.969,32652.969,32652.969,32652.969,32652.969,32652.969,32652.969,32652.969,32652.969
y2010,AGO,125408.525,125408.525,125408.525,125408.525,125408.525,125408.525,125408.525,125408.525,125408.525,125408.525
y2010,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2010,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2010,ALB,20454.243,20454.243,20454.243,20454.243,20454.243,20454.243,20454.243,20454.243,20454.243,20454.243
y2010,AND,4954.118,4954.118,4954.118,4954.118,4954.118,4954.118,4954.118,4954.118,4954.118,4954.118
y2010,ARE,382269.195,382269.195,382269.195,382269.195,382269.195,382269.195,382269.195,382269.195,382269.195,382269.195
y2010,ARG,559526.899,559526.899,559526.899,559526.899,559526.899,559526.899,559526.899,559526.899,559526.899,559526.899
y2010,ARM,14576.875,14576.875,14576.875,14576.875,14576.875,14576.875,14576.875,14576.875,14576.875,14576.875
y2010,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2010,ATA,10,10,10,10,10,10,10,10,10,10
y2010,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2010,ATG,1445.622,1445.622,1445.622,1445.622,1445.622,1445.622,1445.622,1445.622,1445.622,1445.622
y2010,AUS,828460.997,828460.997,828460.997,828460.997,828460.997,828460.997,828460.997,828460.997,828460.997,828460.997
y2010,AUT,303547.406,303547.406,303547.406,303547.406,303547.406,303547.406,303547.406,303547.406,303547.406,303547.406
y2010,AZE,84905.187,84905.187,84905.187,84905.187,84905.187,84905.187,84905.187,84905.187,84905.187,84905.187
y2010,BDI,3240.641,3240.641,3240.641,3240.641,3240.641,3240.641,3240.641,3240.641,3240.641,3240.641
y2010,BEL,365701.846,365701.846,365701.846,365701.846,365701.846,365701.846,365701.846,365701.846,365701.846,365701.846
y2010,BEN,12192.183,12192.183,12192.183,12192.183,12192.183,12192.183,12192.183,12192.183,12192.183,12192.183
y2010,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2010,BFA,16825.03,16825.03,16825.03,16825.03,16825.03,16825.03,16825.03,16825.03,16825.03,16825.03
y2010,BGD,213308.933,213308.933,213308.933,213308.933,213308.933,213308.933,213308.933,213308.933,213308.933,213308.933
y2010,BGR,82424.616,82424.616,82424.616,82424.616,82424.616,82424.616,82424.616,82424.616,82424.616,82424.616
y2010,BHR,31302.518,31302.518,31302.518,31302.518,31302.518,31302.518,31302.518,31302.518,31302.518,31302.518
y2010,BHS,9829.475,9829.475,9829.475,9829.475,9829.475,9829.475,9829.475,9829.475,9829.475,9829.475
y2010,BIH,26708.919,26708.919,26708.919,26708.919,26708.919,26708.919,26708.919,26708.919,26708.919,26708.919
y2010,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2010,BLR,120026.644,120026.644,120026.644,120026.644,120026.644,120026.644,120026.644,120026.644,120026.644,120026.644
y2010,BLZ,2319.608,2319.608,2319.608,2319.608,2319.608,2319.608,2319.608,2319.608,2319.608,2319.608
y2010,BMU,5207.569,5207.569,5207.569,5207.569,5207.569,5207.569,5207.569,5207.569,5207.569,5207.569
y2010,BOL,40047.451,40047.451,40047.451,40047.451,40047.451,40047.451,40047.451,40047.451,40047.451,40047.451
y2010,BRA,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979,1972551.979
y2010,BRB,5798.504,5798.504,5798.504,5798.504,5798.504,5798.504,5798.504,5798.504,5798.504,5798.504
y2010,BRN,17224.932,17224.932,17224.932,17224.932,17224.932,17224.932,17224.932,17224.932,17224.932,17224.932
y2010,BTN,3557.896,3557.896,3557.896,3557.896,3557.896,3557.896,3557.896,3557.896,3557.896,3557.896
y2010,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2010,BWA,24380.685,24380.685,24380.685,24380.685,24380.685,24380.685,24380.685,24380.685,24380.685,24380.685
y2010,CAF,3041.736,3041.736,3041.736,3041.736,3041.736,3041.736,3041.736,3041.736,3041.736,3041.736
y2010,CAN,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209,1218033.209
y2010,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2010,CHE,302841.037,302841.037,302841.037,302841.037,302841.037,302841.037,302841.037,302841.037,302841.037,302841.037
y2010,CHL,223692.695,223692.695,223692.695,223692.695,223692.695,223692.695,223692.695,223692.695,223692.695,223692.695
y2010,CHN,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65,9431146.65
y2010,CIV,30073.174,30073.174,30073.174,30073.174,30073.174,30073.174,30073.174,30073.174,30073.174,30073.174
y2010,CMR,38518.292,38518.292,38518.292,38518.292,38518.292,38518.292,38518.292,38518.292,38518.292,38518.292
y2010,COD,18090.09,18090.09,18090.09,18090.09,18090.09,18090.09,18090.09,18090.09,18090.09,18090.09
y2010,COG,15394.305,15394.305,15394.305,15394.305,15394.305,15394.305,15394.305,15394.305,15394.305,15394.305
y2010,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2010,COL,378269.839,378269.839,378269.839,378269.839,378269.839,378269.839,378269.839,378269.839,378269.839,378269.839
y2010,COM,703.763,703.763,703.763,703.763,703.763,703.763,703.763,703.763,703.763,703.763
y2010,CPV,1752.16,1752.16,1752.16,1752.16,1752.16,1752.16,1752.16,1752.16,1752.16,1752.16
y2010,CRI,47265.958,47265.958,47265.958,47265.958,47265.958,47265.958,47265.958,47265.958,47265.958,47265.958
y2010,CUB,104839.686,104839.686,104839.686,104839.686,104839.686,104839.686,104839.686,104839.686,104839.686,104839.686
y2010,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2010,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2010,CYM,4815.484,4815.484,4815.484,4815.484,4815.484,4815.484,4815.484,4815.484,4815.484,4815.484
y2010,CYP,25700.921,25700.921,25700.921,25700.921,25700.921,25700.921,25700.921,25700.921,25700.921,25700.921
y2010,CZE,239706.873,239706.873,239706.873,239706.873,239706.873,239706.873,239706.873,239706.873,239706.873,239706.873
y2010,DEU,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059,2708900.059
y2010,DJI,1860.614,1860.614,1860.614,1860.614,1860.614,1860.614,1860.614,1860.614,1860.614,1860.614
y2010,DMA,579.105,579.105,579.105,579.105,579.105,579.105,579.105,579.105,579.105,579.105
y2010,DNK,185962.606,185962.606,185962.606,185962.606,185962.606,185962.606,185962.606,185962.606,185962.606,185962.606
y2010,DOM,85741.354,85741.354,85741.354,85741.354,85741.354,85741.354,85741.354,85741.354,85741.354,85741.354
y2010,DZA,243463.971,243463.971,243463.971,243463.971,243463.971,243463.971,243463.971,243463.971,243463.971,243463.971
y2010,ECU,104964.825,104964.825,104964.825,104964.825,104964.825,104964.825,104964.825,104964.825,104964.825,104964.825
y2010,EGY,453342.015,453342.015,453342.015,453342.015,453342.015,453342.015,453342.015,453342.015,453342.015,453342.015
y2010,ERI,2521.755,2521.755,2521.755,2521.755,2521.755,2521.755,2521.755,2521.755,2521.755,2521.755
y2010,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2010,ESP,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405,1263152.405
y2010,EST,22100.94,22100.94,22100.94,22100.94,22100.94,22100.94,22100.94,22100.94,22100.94,22100.94
y2010,ETH,73812.663,73812.663,73812.663,73812.663,73812.663,73812.663,73812.663,73812.663,73812.663,73812.663
y2010,FIN,170351.537,170351.537,170351.537,170351.537,170351.537,170351.537,170351.537,170351.537,170351.537,170351.537
y2010,FJI,3590.005,3590.005,3590.005,3590.005,3590.005,3590.005,3590.005,3590.005,3590.005,3590.005
y2010,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2010,FRA,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462,1993382.462
y2010,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2010,FSM,339.278,339.278,339.278,339.278,339.278,339.278,339.278,339.278,339.278,339.278
y2010,GAB,20497.36,20497.36,20497.36,20497.36,20497.36,20497.36,20497.36,20497.36,20497.36,20497.36
y2010,GBR,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964,2050563.964
y2010,GEO,18541.14,18541.14,18541.14,18541.14,18541.14,18541.14,18541.14,18541.14,18541.14,18541.14
y2010,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2010,GHA,34040.547,34040.547,34040.547,34040.547,34040.547,34040.547,34040.547,34040.547,34040.547,34040.547
y2010,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2010,GIN,10503.516,10503.516,10503.516,10503.516,10503.516,10503.516,10503.516,10503.516,10503.516,10503.516
y2010,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2010,GMB,2592.985,2592.985,2592.985,2592.985,2592.985,2592.985,2592.985,2592.985,2592.985,2592.985
y2010,GNB,1443.295,1443.295,1443.295,1443.295,1443.295,1443.295,1443.295,1443.295,1443.295,1443.295
y2010,GNQ,21193.488,21193.488,21193.488,21193.488,21193.488,21193.488,21193.488,21193.488,21193.488,21193.488
y2010,GRC,289626.744,289626.744,289626.744,289626.744,289626.744,289626.744,289626.744,289626.744,289626.744,289626.744
y2010,GRD,1034.762,1034.762,1034.762,1034.762,1034.762,1034.762,1034.762,1034.762,1034.762,1034.762
y2010,GRL,3172.659,3172.659,3172.659,3172.659,3172.659,3172.659,3172.659,3172.659,3172.659,3172.659
y2010,GTM,73172.494,73172.494,73172.494,73172.494,73172.494,73172.494,73172.494,73172.494,73172.494,73172.494
y2010,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2010,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2010,GUY,3071.16,3071.16,3071.16,3071.16,3071.16,3071.16,3071.16,3071.16,3071.16,3071.16
y2010,HKG,281043.791,281043.791,281043.791,281043.791,281043.791,281043.791,281043.791,281043.791,281043.791,281043.791
y2010,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2010,HND,30397.333,30397.333,30397.333,30397.333,30397.333,30397.333,30397.333,30397.333,30397.333,30397.333
y2010,HRV,69301.819,69301.819,69301.819,69301.819,69301.819,69301.819,69301.819,69301.819,69301.819,69301.819
y2010,HTI,11153.583,11153.583,11153.583,11153.583,11153.583,11153.583,11153.583,11153.583,11153.583,11153.583
y2010,HUN,169156.589,169156.589,169156.589,169156.589,169156.589,169156.589,169156.589,169156.589,169156.589,169156.589
y2010,IDN,985099.277,985099.277,985099.277,985099.277,985099.277,985099.277,985099.277,985099.277,985099.277,985099.277
y2010,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2010,IND,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129,3961052.129
y2010,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2010,IRL,159025.464,159025.464,159025.464,159025.464,159025.464,159025.464,159025.464,159025.464,159025.464,159025.464
y2010,IRN,773875.051,773875.051,773875.051,773875.051,773875.051,773875.051,773875.051,773875.051,773875.051,773875.051
y2010,IRQ,115055.178,115055.178,115055.178,115055.178,115055.178,115055.178,115055.178,115055.178,115055.178,115055.178
y2010,ISL,10824.344,10824.344,10824.344,10824.344,10824.344,10824.344,10824.344,10824.344,10824.344,10824.344
y2010,ISR,199780.402,199780.402,199780.402,199780.402,199780.402,199780.402,199780.402,199780.402,199780.402,199780.402
y2010,ITA,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306,1604030.306
y2010,JAM,21722.379,21722.379,21722.379,21722.379,21722.379,21722.379,21722.379,21722.379,21722.379,21722.379
y2010,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2010,JOR,35825.28,35825.28,35825.28,35825.28,35825.28,35825.28,35825.28,35825.28,35825.28,35825.28
y2010,JPN,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188,4012301.188
y2010,KAZ,185264.836,185264.836,185264.836,185264.836,185264.836,185264.836,185264.836,185264.836,185264.836,185264.836
y2010,KEN,59375.552,59375.552,59375.552,59375.552,59375.552,59375.552,59375.552,59375.552,59375.552,59375.552
y2010,KGZ,11592.216,11592.216,11592.216,11592.216,11592.216,11592.216,11592.216,11592.216,11592.216,11592.216
y2010,KHM,26296.331,26296.331,26296.331,26296.331,26296.331,26296.331,26296.331,26296.331,26296.331,26296.331
y2010,KIR,335.726,335.726,335.726,335.726,335.726,335.726,335.726,335.726,335.726,335.726
y2010,KNA,634.634,634.634,634.634,634.634,634.634,634.634,634.634,634.634,634.634,634.634
y2010,KOR,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926,1322801.926
y2010,KWT,125636.167,125636.167,125636.167,125636.167,125636.167,125636.167,125636.167,125636.167,125636.167,125636.167
y2010,LAO,14829.591,14829.591,14829.591,14829.591,14829.591,14829.591,14829.591,14829.591,14829.591,14829.591
y2010,LBN,58018.586,58018.586,58018.586,58018.586,58018.586,58018.586,58018.586,58018.586,58018.586,58018.586
y2010,LBR,1486.867,1486.867,1486.867,1486.867,1486.867,1486.867,1486.867,1486.867,1486.867,1486.867
y2010,LBY,103294.6,103294.6,103294.6,103294.6,103294.6,103294.6,103294.6,103294.6,103294.6,103294.6
y2010,LCA,1796.106,1796.106,1796.106,1796.106,1796.106,1796.106,1796.106,1796.106,1796.106,1796.106
y2010,LIE,7074.031,7074.031,7074.031,7074.031,7074.031,7074.031,7074.031,7074.031,7074.031,7074.031
y2010,LKA,90514.94,90514.94,90514.94,90514.94,90514.94,90514.94,90514.94,90514.94,90514.94,90514.94
y2010,LSO,2639.791,2639.791,2639.791,2639.791,2639.791,2639.791,2639.791,2639.791,2639.791,2639.791
y2010,LTU,46698.898,46698.898,46698.898,46698.898,46698.898,46698.898,46698.898,46698.898,46698.898,46698.898
y2010,LUX,38622.584,38622.584,38622.584,38622.584,38622.584,38622.584,38622.584,38622.584,38622.584,38622.584
y2010,LVA,27446.591,27446.591,27446.591,27446.591,27446.591,27446.591,27446.591,27446.591,27446.591,27446.591
y2010,MAC,29960.201,29960.201,29960.201,29960.201,29960.201,29960.201,29960.201,29960.201,29960.201,29960.201
y2010,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2010,MAR,128665.359,128665.359,128665.359,128665.359,128665.359,128665.359,128665.359,128665.359,128665.359,128665.359
y2010,MCO,10166.13,10166.13,10166.13,10166.13,10166.13,10166.13,10166.13,10166.13,10166.13,10166.13
y2010,MDA,9291.039,9291.039,9291.039,9291.039,9291.039,9291.039,9291.039,9291.039,9291.039,9291.039
y2010,MDG,17135.762,17135.762,17135.762,17135.762,17135.762,17135.762,17135.762,17135.762,17135.762,17135.762
y2010,MDV,1768.902,1768.902,1768.902,1768.902,1768.902,1768.902,1768.902,1768.902,1768.902,1768.902
y2010,MEX,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061,1480030.061
y2010,MHL,306.215,306.215,306.215,306.215,306.215,306.215,306.215,306.215,306.215,306.215
y2010,MKD,17292.483,17292.483,17292.483,17292.483,17292.483,17292.483,17292.483,17292.483,17292.483,17292.483
y2010,MLI,16193.053,16193.053,16193.053,16193.053,16193.053,16193.053,16193.053,16193.053,16193.053,16193.053
y2010,MLT,9097.352,9097.352,9097.352,9097.352,9097.352,9097.352,9097.352,9097.352,9097.352,9097.352
y2010,MMR,55227.309,55227.309,55227.309,55227.309,55227.309,55227.309,55227.309,55227.309,55227.309,55227.309
y2010,MNE,5553.342,5553.342,5553.342,5553.342,5553.342,5553.342,5553.342,5553.342,5553.342,5553.342
y2010,MNG,9160.158,9160.158,9160.158,9160.158,9160.158,9160.158,9160.158,9160.158,9160.158,9160.158
y2010,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2010,MOZ,20297.094,20297.094,20297.094,20297.094,20297.094,20297.094,20297.094,20297.094,20297.094,20297.094
y2010,MRT,6374.568,6374.568,6374.568,6374.568,6374.568,6374.568,6374.568,6374.568,6374.568,6374.568
y2010,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2010,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2010,MUS,14029.576,14029.576,14029.576,14029.576,14029.576,14029.576,14029.576,14029.576,14029.576,14029.576
y2010,MWI,11356.434,11356.434,11356.434,11356.434,11356.434,11356.434,11356.434,11356.434,11356.434,11356.434
y2010,MYS,358960.758,358960.758,358960.758,358960.758,358960.758,358960.758,358960.758,358960.758,358960.758,358960.758
y2010,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2010,NAM,12449.05,12449.05,12449.05,12449.05,12449.05,12449.05,12449.05,12449.05,12449.05,12449.05
y2010,NCL,10929.904,10929.904,10929.904,10929.904,10929.904,10929.904,10929.904,10929.904,10929.904,10929.904
y2010,NER,9963.475,9963.475,9963.475,9963.475,9963.475,9963.475,9963.475,9963.475,9963.475,9963.475
y2010,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2010,NGA,336772.336,336772.336,336772.336,336772.336,336772.336,336772.336,336772.336,336772.336,336772.336,336772.336
y2010,NIC,14072.58,14072.58,14072.58,14072.58,14072.58,14072.58,14072.58,14072.58,14072.58,14072.58
y2010,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2010,NLD,636845.455,636845.455,636845.455,636845.455,636845.455,636845.455,636845.455,636845.455,636845.455,636845.455
y2010,NOR,236032.649,236032.649,236032.649,236032.649,236032.649,236032.649,236032.649,236032.649,236032.649,236032.649
y2010,NPL,30954.355,30954.355,30954.355,30954.355,30954.355,30954.355,30954.355,30954.355,30954.355,30954.355
y2010,NRU,51.367,51.367,51.367,51.367,51.367,51.367,51.367,51.367,51.367,51.367
y2010,NZL,113662.821,113662.821,113662.821,113662.821,113662.821,113662.821,113662.821,113662.821,113662.821,113662.821
y2010,OMN,68786.055,68786.055,68786.055,68786.055,68786.055,68786.055,68786.055,68786.055,68786.055,68786.055
y2010,PAK,419630.239,419630.239,419630.239,419630.239,419630.239,419630.239,419630.239,419630.239,419630.239,419630.239
y2010,PAN,41458.773,41458.773,41458.773,41458.773,41458.773,41458.773,41458.773,41458.773,41458.773,41458.773
y2010,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2010,PER,238894.512,238894.512,238894.512,238894.512,238894.512,238894.512,238894.512,238894.512,238894.512,238894.512
y2010,PHL,303012.646,303012.646,303012.646,303012.646,303012.646,303012.646,303012.646,303012.646,303012.646,303012.646
y2010,PLW,284.669,284.669,284.669,284.669,284.669,284.669,284.669,284.669,284.669,284.669
y2010,PNG,16923.047,16923.047,16923.047,16923.047,16923.047,16923.047,16923.047,16923.047,16923.047,16923.047
y2010,POL,648938.165,648938.165,648938.165,648938.165,648938.165,648938.165,648938.165,648938.165,648938.165,648938.165
y2010,PRI,89650.049,89650.049,89650.049,89650.049,89650.049,89650.049,89650.049,89650.049,89650.049,89650.049
y2010,PRK,29264.618,29264.618,29264.618,29264.618,29264.618,29264.618,29264.618,29264.618,29264.618,29264.618
y2010,PRT,220824.692,220824.692,220824.692,220824.692,220824.692,220824.692,220824.692,220824.692,220824.692,220824.692
y2010,PRY,26349.831,26349.831,26349.831,26349.831,26349.831,26349.831,26349.831,26349.831,26349.831,26349.831
y2010,PSE,8807.38,8807.38,8807.38,8807.38,8807.38,8807.38,8807.38,8807.38,8807.38,8807.38
y2010,PYF,7053.535,7053.535,7053.535,7053.535,7053.535,7053.535,7053.535,7053.535,7053.535,7053.535
y2010,QAT,163532.933,163532.933,163532.933,163532.933,163532.933,163532.933,163532.933,163532.933,163532.933,163532.933
y2010,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2010,ROU,208755.971,208755.971,208755.971,208755.971,208755.971,208755.971,208755.971,208755.971,208755.971,208755.971
y2010,RUS,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818,2053680.818
y2010,RWA,10977.247,10977.247,10977.247,10977.247,10977.247,10977.247,10977.247,10977.247,10977.247,10977.247
y2010,SAU,593411.546,593411.546,593411.546,593411.546,593411.546,593411.546,593411.546,593411.546,593411.546,593411.546
y2010,SDN,74981.825,74981.825,74981.825,74981.825,74981.825,74981.825,74981.825,74981.825,74981.825,74981.825
y2010,SEN,20812.204,20812.204,20812.204,20812.204,20812.204,20812.204,20812.204,20812.204,20812.204,20812.204
y2010,SGP,263286.784,263286.784,263286.784,263286.784,263286.784,263286.784,263286.784,263286.784,263286.784,263286.784
y2010,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2010,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2010,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2010,SLB,1241.265,1241.265,1241.265,1241.265,1241.265,1241.265,1241.265,1241.265,1241.265,1241.265
y2010,SLE,5087.938,5087.938,5087.938,5087.938,5087.938,5087.938,5087.938,5087.938,5087.938,5087.938
y2010,SLV,39365.656,39365.656,39365.656,39365.656,39365.656,39365.656,39365.656,39365.656,39365.656,39365.656
y2010,SMR,2491.464,2491.464,2491.464,2491.464,2491.464,2491.464,2491.464,2491.464,2491.464,2491.464
y2010,SOM,7683.496,7683.496,7683.496,7683.496,7683.496,7683.496,7683.496,7683.496,7683.496,7683.496
y2010,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2010,SRB,86262.828,86262.828,86262.828,86262.828,86262.828,86262.828,86262.828,86262.828,86262.828,86262.828
y2010,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2010,STP,298.454,298.454,298.454,298.454,298.454,298.454,298.454,298.454,298.454,298.454
y2010,SUR,4587.085,4587.085,4587.085,4587.085,4587.085,4587.085,4587.085,4587.085,4587.085,4587.085
y2010,SVK,109170.648,109170.648,109170.648,109170.648,109170.648,109170.648,109170.648,109170.648,109170.648,109170.648
y2010,SVN,51513.115,51513.115,51513.115,51513.115,51513.115,51513.115,51513.115,51513.115,51513.115,51513.115
y2010,SWE,325928.892,325928.892,325928.892,325928.892,325928.892,325928.892,325928.892,325928.892,325928.892,325928.892
y2010,SWZ,5387.569,5387.569,5387.569,5387.569,5387.569,5387.569,5387.569,5387.569,5387.569,5387.569
y2010,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2010,SYC,1959.026,1959.026,1959.026,1959.026,1959.026,1959.026,1959.026,1959.026,1959.026,1959.026
y2010,SYR,91901.447,91901.447,91901.447,91901.447,91901.447,91901.447,91901.447,91901.447,91901.447,91901.447
y2010,TCA,1649.83,1649.83,1649.83,1649.83,1649.83,1649.83,1649.83,1649.83,1649.83,1649.83
y2010,TCD,15838.722,15838.722,15838.722,15838.722,15838.722,15838.722,15838.722,15838.722,15838.722,15838.722
y2010,TGO,4956.907,4956.907,4956.907,4956.907,4956.907,4956.907,4956.907,4956.907,4956.907,4956.907
y2010,THA,531876.796,531876.796,531876.796,531876.796,531876.796,531876.796,531876.796,531876.796,531876.796,531876.796
y2010,TJK,13854.78,13854.78,13854.78,13854.78,13854.78,13854.78,13854.78,13854.78,13854.78,13854.78
y2010,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2010,TKM,33627.236,33627.236,33627.236,33627.236,33627.236,33627.236,33627.236,33627.236,33627.236,33627.236
y2010,TLS,1617.406,1617.406,1617.406,1617.406,1617.406,1617.406,1617.406,1617.406,1617.406,1617.406
y2010,TON,600.396,600.396,600.396,600.396,600.396,600.396,600.396,600.396,600.396,600.396
y2010,TTO,35948.267,35948.267,35948.267,35948.267,35948.267,35948.267,35948.267,35948.267,35948.267,35948.267
y2010,TUN,80698.365,80698.365,80698.365,80698.365,80698.365,80698.365,80698.365,80698.365,80698.365,80698.365
y2010,TUR,830422.186,830422.186,830422.186,830422.186,830422.186,830422.186,830422.186,830422.186,830422.186,830422.186
y2010,TUV,49.083,49.083,49.083,49.083,49.083,49.083,49.083,49.083,49.083,49.083
y2010,TWN,531869.287,531869.287,531869.287,531869.287,531869.287,531869.287,531869.287,531869.287,531869.287,531869.287
y2010,TZA,59576.298,59576.298,59576.298,59576.298,59576.298,59576.298,59576.298,59576.298,59576.298,59576.298
y2010,UGA,38791.519,38791.519,38791.519,38791.519,38791.519,38791.519,38791.519,38791.519,38791.519,38791.519
y2010,UKR,280803.453,280803.453,280803.453,280803.453,280803.453,280803.453,280803.453,280803.453,280803.453,280803.453
y2010,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2010,URY,42361.731,42361.731,42361.731,42361.731,42361.731,42361.731,42361.731,42361.731,42361.731,42361.731
y2010,USA,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604,13088009.604
y2010,UZB,74527.385,74527.385,74527.385,74527.385,74527.385,74527.385,74527.385,74527.385,74527.385,74527.385
y2010,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2010,VCT,913.388,913.388,913.388,913.388,913.388,913.388,913.388,913.388,913.388,913.388
y2010,VEN,295817.137,295817.137,295817.137,295817.137,295817.137,295817.137,295817.137,295817.137,295817.137,295817.137
y2010,VGB,2158.165,2158.165,2158.165,2158.165,2158.165,2158.165,2158.165,2158.165,2158.165,2158.165
y2010,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2010,VNM,254778.274,254778.274,254778.274,254778.274,254778.274,254778.274,254778.274,254778.274,254778.274,254778.274
y2010,VUT,1180.169,1180.169,1180.169,1180.169,1180.169,1180.169,1180.169,1180.169,1180.169,1180.169
y2010,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2010,WSM,969.418,969.418,969.418,969.418,969.418,969.418,969.418,969.418,969.418,969.418
y2010,YEM,55831.756,55831.756,55831.756,55831.756,55831.756,55831.756,55831.756,55831.756,55831.756,55831.756
y2010,ZAF,459592.059,459592.059,459592.059,459592.059,459592.059,459592.059,459592.059,459592.059,459592.059,459592.059
y2010,ZMB,18404.935,18404.935,18404.935,18404.935,18404.935,18404.935,18404.935,18404.935,18404.935,18404.935
y2010,ZWE,4914.424,4914.424,4914.424,4914.424,4914.424,4914.424,4914.424,4914.424,4914.424,4914.424
y2015,ABW,4222.391,4222.391,4222.391,4222.391,4222.391,4222.391,4222.391,4222.391,4222.391,4222.391
y2015,AFG,46234.01,46234.01,46234.01,46234.01,46234.01,46234.01,46234.01,46234.01,46234.01,46234.01
y2015,AGO,170573.192,170573.192,170573.192,170573.192,170573.192,170573.192,170573.192,170573.192,170573.192,170573.192
y2015,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2015,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2015,ALB,23982.578,23982.578,23982.578,23982.578,23982.578,23982.578,23982.578,23982.578,23982.578,23982.578
y2015,AND,5014.568,5014.568,5014.568,5014.568,5014.568,5014.568,5014.568,5014.568,5014.568,5014.568
y2015,ARE,456672.7,456672.7,456672.7,456672.7,456672.7,456672.7,456672.7,456672.7,456672.7,456672.7
y2015,ARG,659042.597,659042.597,659042.597,659042.597,659042.597,659042.597,659042.597,659042.597,659042.597,659042.597
y2015,ARM,17839.562,17839.562,17839.562,17839.562,17839.562,17839.562,17839.562,17839.562,17839.562,17839.562
y2015,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2015,ATA,10,10,10,10,10,10,10,10,10,10
y2015,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2015,ATG,1720.693,1720.693,1720.693,1720.693,1720.693,1720.693,1720.693,1720.693,1720.693,1720.693
y2015,AUS,995117.198,995117.198,995117.198,995117.198,995117.198,995117.198,995117.198,995117.198,995117.198,995117.198
y2015,AUT,340680.675,340680.675,340680.675,340680.675,340680.675,340680.675,340680.675,340680.675,340680.675,340680.675
y2015,AZE,110208.018,110208.018,110208.018,110208.018,110208.018,110208.018,110208.018,110208.018,110208.018,110208.018
y2015,BDI,4316.216,4316.216,4316.216,4316.216,4316.216,4316.216,4316.216,4316.216,4316.216,4316.216
y2015,BEL,407410.435,407410.435,407410.435,407410.435,407410.435,407410.435,407410.435,407410.435,407410.435,407410.435
y2015,BEN,15713.168,15713.168,15713.168,15713.168,15713.168,15713.168,15713.168,15713.168,15713.168,15713.168
y2015,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2015,BFA,23035.192,23035.192,23035.192,23035.192,23035.192,23035.192,23035.192,23035.192,23035.192,23035.192
y2015,BGD,287605.11,287605.11,287605.11,287605.11,287605.11,287605.11,287605.11,287605.11,287605.11,287605.11
y2015,BGR,98587.338,98587.338,98587.338,98587.338,98587.338,98587.338,98587.338,98587.338,98587.338,98587.338
y2015,BHR,39608.102,39608.102,39608.102,39608.102,39608.102,39608.102,39608.102,39608.102,39608.102,39608.102
y2015,BHS,11215.091,11215.091,11215.091,11215.091,11215.091,11215.091,11215.091,11215.091,11215.091,11215.091
y2015,BIH,31420.153,31420.153,31420.153,31420.153,31420.153,31420.153,31420.153,31420.153,31420.153,31420.153
y2015,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2015,BLR,148565.537,148565.537,148565.537,148565.537,148565.537,148565.537,148565.537,148565.537,148565.537,148565.537
y2015,BLZ,2647.543,2647.543,2647.543,2647.543,2647.543,2647.543,2647.543,2647.543,2647.543,2647.543
y2015,BMU,6134.186,6134.186,6134.186,6134.186,6134.186,6134.186,6134.186,6134.186,6134.186,6134.186
y2015,BOL,48932.582,48932.582,48932.582,48932.582,48932.582,48932.582,48932.582,48932.582,48932.582,48932.582
y2015,BRA,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902,2431942.902
y2015,BRB,6599.917,6599.917,6599.917,6599.917,6599.917,6599.917,6599.917,6599.917,6599.917,6599.917
y2015,BRN,17440.128,17440.128,17440.128,17440.128,17440.128,17440.128,17440.128,17440.128,17440.128,17440.128
y2015,BTN,4833.546,4833.546,4833.546,4833.546,4833.546,4833.546,4833.546,4833.546,4833.546,4833.546
y2015,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2015,BWA,33026.17,33026.17,33026.17,33026.17,33026.17,33026.17,33026.17,33026.17,33026.17,33026.17
y2015,CAF,3625.962,3625.962,3625.962,3625.962,3625.962,3625.962,3625.962,3625.962,3625.962,3625.962
y2015,CAN,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039,1369854.039
y2015,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2015,CHE,343586.336,343586.336,343586.336,343586.336,343586.336,343586.336,343586.336,343586.336,343586.336,343586.336
y2015,CHL,278192.182,278192.182,278192.182,278192.182,278192.182,278192.182,278192.182,278192.182,278192.182,278192.182
y2015,CHN,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223,14352203.223
y2015,CIV,37437.851,37437.851,37437.851,37437.851,37437.851,37437.851,37437.851,37437.851,37437.851,37437.851
y2015,CMR,47612.262,47612.262,47612.262,47612.262,47612.262,47612.262,47612.262,47612.262,47612.262,47612.262
y2015,COD,25669.018,25669.018,25669.018,25669.018,25669.018,25669.018,25669.018,25669.018,25669.018,25669.018
y2015,COG,18389.964,18389.964,18389.964,18389.964,18389.964,18389.964,18389.964,18389.964,18389.964,18389.964
y2015,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2015,COL,464825.192,464825.192,464825.192,464825.192,464825.192,464825.192,464825.192,464825.192,464825.192,464825.192
y2015,COM,855.355,855.355,855.355,855.355,855.355,855.355,855.355,855.355,855.355,855.355
y2015,CPV,2240.109,2240.109,2240.109,2240.109,2240.109,2240.109,2240.109,2240.109,2240.109,2240.109
y2015,CRI,57540.757,57540.757,57540.757,57540.757,57540.757,57540.757,57540.757,57540.757,57540.757,57540.757
y2015,CUB,118931.956,118931.956,118931.956,118931.956,118931.956,118931.956,118931.956,118931.956,118931.956,118931.956
y2015,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2015,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2015,CYM,6548.673,6548.673,6548.673,6548.673,6548.673,6548.673,6548.673,6548.673,6548.673,6548.673
y2015,CYP,28377.608,28377.608,28377.608,28377.608,28377.608,28377.608,28377.608,28377.608,28377.608,28377.608
y2015,CZE,280964.096,280964.096,280964.096,280964.096,280964.096,280964.096,280964.096,280964.096,280964.096,280964.096
y2015,DEU,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811,2986719.811
y2015,DJI,2386.09,2386.09,2386.09,2386.09,2386.09,2386.09,2386.09,2386.09,2386.09,2386.09
y2015,DMA,681.562,681.562,681.562,681.562,681.562,681.562,681.562,681.562,681.562,681.562
y2015,DNK,208800.537,208800.537,208800.537,208800.537,208800.537,208800.537,208800.537,208800.537,208800.537,208800.537
y2015,DOM,110053.092,110053.092,110053.092,110053.092,110053.092,110053.092,110053.092,110053.092,110053.092,110053.092
y2015,DZA,303998.352,303998.352,303998.352,303998.352,303998.352,303998.352,303998.352,303998.352,303998.352,303998.352
y2015,ECU,116831.593,116831.593,116831.593,116831.593,116831.593,116831.593,116831.593,116831.593,116831.593,116831.593
y2015,EGY,606864.434,606864.434,606864.434,606864.434,606864.434,606864.434,606864.434,606864.434,606864.434,606864.434
y2015,ERI,2568.548,2568.548,2568.548,2568.548,2568.548,2568.548,2568.548,2568.548,2568.548,2568.548
y2015,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2015,ESP,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277,1362627.277
y2015,EST,25785.476,25785.476,25785.476,25785.476,25785.476,25785.476,25785.476,25785.476,25785.476,25785.476
y2015,ETH,108622.51,108622.51,108622.51,108622.51,108622.51,108622.51,108622.51,108622.51,108622.51,108622.51
y2015,FIN,187395.741,187395.741,187395.741,187395.741,187395.741,187395.741,187395.741,187395.741,187395.741,187395.741
y2015,FJI,4171.532,4171.532,4171.532,4171.532,4171.532,4171.532,4171.532,4171.532,4171.532,4171.532
y2015,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2015,FRA,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253,2202267.253
y2015,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2015,FSM,384.921,384.921,384.921,384.921,384.921,384.921,384.921,384.921,384.921,384.921
y2015,GAB,26705.438,26705.438,26705.438,26705.438,26705.438,26705.438,26705.438,26705.438,26705.438,26705.438
y2015,GBR,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173,2319432.173
y2015,GEO,20819.291,20819.291,20819.291,20819.291,20819.291,20819.291,20819.291,20819.291,20819.291,20819.291
y2015,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2015,GHA,46873.529,46873.529,46873.529,46873.529,46873.529,46873.529,46873.529,46873.529,46873.529,46873.529
y2015,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2015,GIN,12759.844,12759.844,12759.844,12759.844,12759.844,12759.844,12759.844,12759.844,12759.844,12759.844
y2015,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2015,GMB,3458.332,3458.332,3458.332,3458.332,3458.332,3458.332,3458.332,3458.332,3458.332,3458.332
y2015,GNB,1781.9,1781.9,1781.9,1781.9,1781.9,1781.9,1781.9,1781.9,1781.9,1781.9
y2015,GNQ,25074.092,25074.092,25074.092,25074.092,25074.092,25074.092,25074.092,25074.092,25074.092,25074.092
y2015,GRC,297589.865,297589.865,297589.865,297589.865,297589.865,297589.865,297589.865,297589.865,297589.865,297589.865
y2015,GRD,1235.267,1235.267,1235.267,1235.267,1235.267,1235.267,1235.267,1235.267,1235.267,1235.267
y2015,GRL,3688.809,3688.809,3688.809,3688.809,3688.809,3688.809,3688.809,3688.809,3688.809,3688.809
y2015,GTM,84747.787,84747.787,84747.787,84747.787,84747.787,84747.787,84747.787,84747.787,84747.787,84747.787
y2015,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2015,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2015,GUY,3617.589,3617.589,3617.589,3617.589,3617.589,3617.589,3617.589,3617.589,3617.589,3617.589
y2015,HKG,344795.734,344795.734,344795.734,344795.734,344795.734,344795.734,344795.734,344795.734,344795.734,344795.734
y2015,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2015,HND,37326.593,37326.593,37326.593,37326.593,37326.593,37326.593,37326.593,37326.593,37326.593,37326.593
y2015,HRV,74902.632,74902.632,74902.632,74902.632,74902.632,74902.632,74902.632,74902.632,74902.632,74902.632
y2015,HTI,15514.683,15514.683,15514.683,15514.683,15514.683,15514.683,15514.683,15514.683,15514.683,15514.683
y2015,HUN,191966.213,191966.213,191966.213,191966.213,191966.213,191966.213,191966.213,191966.213,191966.213,191966.213
y2015,IDN,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413,1336826.413
y2015,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2015,IND,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663,5699047.663
y2015,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2015,IRL,182351.202,182351.202,182351.202,182351.202,182351.202,182351.202,182351.202,182351.202,182351.202,182351.202
y2015,IRN,883846.473,883846.473,883846.473,883846.473,883846.473,883846.473,883846.473,883846.473,883846.473,883846.473
y2015,IRQ,194583.424,194583.424,194583.424,194583.424,194583.424,194583.424,194583.424,194583.424,194583.424,194583.424
y2015,ISL,12465.754,12465.754,12465.754,12465.754,12465.754,12465.754,12465.754,12465.754,12465.754,12465.754
y2015,ISR,238401.694,238401.694,238401.694,238401.694,238401.694,238401.694,238401.694,238401.694,238401.694,238401.694
y2015,ITA,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682,1710945.682
y2015,JAM,23710.88,23710.88,23710.88,23710.88,23710.88,23710.88,23710.88,23710.88,23710.88,23710.88
y2015,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2015,JOR,52239.777,52239.777,52239.777,52239.777,52239.777,52239.777,52239.777,52239.777,52239.777,52239.777
y2015,JPN,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659,4396038.659
y2015,KAZ,245893.126,245893.126,245893.126,245893.126,245893.126,245893.126,245893.126,245893.126,245893.126,245893.126
y2015,KEN,83843.462,83843.462,83843.462,83843.462,83843.462,83843.462,83843.462,83843.462,83843.462,83843.462
y2015,KGZ,14570.965,14570.965,14570.965,14570.965,14570.965,14570.965,14570.965,14570.965,14570.965,14570.965
y2015,KHM,36790.963,36790.963,36790.963,36790.963,36790.963,36790.963,36790.963,36790.963,36790.963,36790.963
y2015,KIR,391.497,391.497,391.497,391.497,391.497,391.497,391.497,391.497,391.497,391.497
y2015,KNA,665.835,665.835,665.835,665.835,665.835,665.835,665.835,665.835,665.835,665.835
y2015,KOR,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298,1628909.298
y2015,KWT,190336.139,190336.139,190336.139,190336.139,190336.139,190336.139,190336.139,190336.139,190336.139,190336.139
y2015,LAO,20424.019,20424.019,20424.019,20424.019,20424.019,20424.019,20424.019,20424.019,20424.019,20424.019
y2015,LBN,89840.215,89840.215,89840.215,89840.215,89840.215,89840.215,89840.215,89840.215,89840.215,89840.215
y2015,LBR,2200.698,2200.698,2200.698,2200.698,2200.698,2200.698,2200.698,2200.698,2200.698,2200.698
y2015,LBY,131266.129,131266.129,131266.129,131266.129,131266.129,131266.129,131266.129,131266.129,131266.129,131266.129
y2015,LCA,2081.639,2081.639,2081.639,2081.639,2081.639,2081.639,2081.639,2081.639,2081.639,2081.639
y2015,LIE,8769.773,8769.773,8769.773,8769.773,8769.773,8769.773,8769.773,8769.773,8769.773,8769.773
y2015,LKA,123488.503,123488.503,123488.503,123488.503,123488.503,123488.503,123488.503,123488.503,123488.503,123488.503
y2015,LSO,2951.2,2951.2,2951.2,2951.2,2951.2,2951.2,2951.2,2951.2,2951.2,2951.2
y2015,LTU,51436.922,51436.922,51436.922,51436.922,51436.922,51436.922,51436.922,51436.922,51436.922,51436.922
y2015,LUX,46518.419,46518.419,46518.419,46518.419,46518.419,46518.419,46518.419,46518.419,46518.419,46518.419
y2015,LVA,30926.485,30926.485,30926.485,30926.485,30926.485,30926.485,30926.485,30926.485,30926.485,30926.485
y2015,MAC,45440.626,45440.626,45440.626,45440.626,45440.626,45440.626,45440.626,45440.626,45440.626,45440.626
y2015,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2015,MAR,166353.823,166353.823,166353.823,166353.823,166353.823,166353.823,166353.823,166353.823,166353.823,166353.823
y2015,MCO,12323.488,12323.488,12323.488,12323.488,12323.488,12323.488,12323.488,12323.488,12323.488,12323.488
y2015,MDA,10696.141,10696.141,10696.141,10696.141,10696.141,10696.141,10696.141,10696.141,10696.141,10696.141
y2015,MDG,21622.598,21622.598,21622.598,21622.598,21622.598,21622.598,21622.598,21622.598,21622.598,21622.598
y2015,MDV,2294.188,2294.188,2294.188,2294.188,2294.188,2294.188,2294.188,2294.188,2294.188,2294.188
y2015,MEX,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102,1857648.102
y2015,MHL,342.662,342.662,342.662,342.662,342.662,342.662,342.662,342.662,342.662,342.662
y2015,MKD,20390.644,20390.644,20390.644,20390.644,20390.644,20390.644,20390.644,20390.644,20390.644,20390.644
y2015,MLI,21434.133,21434.133,21434.133,21434.133,21434.133,21434.133,21434.133,21434.133,21434.133,21434.133
y2015,MLT,10530.671,10530.671,10530.671,10530.671,10530.671,10530.671,10530.671,10530.671,10530.671,10530.671
y2015,MMR,66496.326,66496.326,66496.326,66496.326,66496.326,66496.326,66496.326,66496.326,66496.326,66496.326
y2015,MNE,5923.738,5923.738,5923.738,5923.738,5923.738,5923.738,5923.738,5923.738,5923.738,5923.738
y2015,MNG,17212.196,17212.196,17212.196,17212.196,17212.196,17212.196,17212.196,17212.196,17212.196,17212.196
y2015,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2015,MOZ,30351.012,30351.012,30351.012,30351.012,30351.012,30351.012,30351.012,30351.012,30351.012,30351.012
y2015,MRT,8666.856,8666.856,8666.856,8666.856,8666.856,8666.856,8666.856,8666.856,8666.856,8666.856
y2015,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2015,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2015,MUS,16822.696,16822.696,16822.696,16822.696,16822.696,16822.696,16822.696,16822.696,16822.696,16822.696
y2015,MWI,16329.541,16329.541,16329.541,16329.541,16329.541,16329.541,16329.541,16329.541,16329.541,16329.541
y2015,MYS,460520.431,460520.431,460520.431,460520.431,460520.431,460520.431,460520.431,460520.431,460520.431,460520.431
y2015,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2015,NAM,16427.374,16427.374,16427.374,16427.374,16427.374,16427.374,16427.374,16427.374,16427.374,16427.374
y2015,NCL,12718.914,12718.914,12718.914,12718.914,12718.914,12718.914,12718.914,12718.914,12718.914,12718.914
y2015,NER,14138.131,14138.131,14138.131,14138.131,14138.131,14138.131,14138.131,14138.131,14138.131,14138.131
y2015,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2015,NGA,462254.962,462254.962,462254.962,462254.962,462254.962,462254.962,462254.962,462254.962,462254.962,462254.962
y2015,NIC,16605.792,16605.792,16605.792,16605.792,16605.792,16605.792,16605.792,16605.792,16605.792,16605.792
y2015,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2015,NLD,709036.231,709036.231,709036.231,709036.231,709036.231,709036.231,709036.231,709036.231,709036.231,709036.231
y2015,NOR,268045.326,268045.326,268045.326,268045.326,268045.326,268045.326,268045.326,268045.326,268045.326,268045.326
y2015,NPL,38197.391,38197.391,38197.391,38197.391,38197.391,38197.391,38197.391,38197.391,38197.391,38197.391
y2015,NRU,53.068,53.068,53.068,53.068,53.068,53.068,53.068,53.068,53.068,53.068
y2015,NZL,131674.342,131674.342,131674.342,131674.342,131674.342,131674.342,131674.342,131674.342,131674.342,131674.342
y2015,OMN,100636.015,100636.015,100636.015,100636.015,100636.015,100636.015,100636.015,100636.015,100636.015,100636.015
y2015,PAK,537323.269,537323.269,537323.269,537323.269,537323.269,537323.269,537323.269,537323.269,537323.269,537323.269
y2015,PAN,56238.9,56238.9,56238.9,56238.9,56238.9,56238.9,56238.9,56238.9,56238.9,56238.9
y2015,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2015,PER,309787.552,309787.552,309787.552,309787.552,309787.552,309787.552,309787.552,309787.552,309787.552,309787.552
y2015,PHL,370735.989,370735.989,370735.989,370735.989,370735.989,370735.989,370735.989,370735.989,370735.989,370735.989
y2015,PLW,316.076,316.076,316.076,316.076,316.076,316.076,316.076,316.076,316.076,316.076
y2015,PNG,22454.961,22454.961,22454.961,22454.961,22454.961,22454.961,22454.961,22454.961,22454.961,22454.961
y2015,POL,784113.237,784113.237,784113.237,784113.237,784113.237,784113.237,784113.237,784113.237,784113.237,784113.237
y2015,PRI,101969.49,101969.49,101969.49,101969.49,101969.49,101969.49,101969.49,101969.49,101969.49,101969.49
y2015,PRK,33017.428,33017.428,33017.428,33017.428,33017.428,33017.428,33017.428,33017.428,33017.428,33017.428
y2015,PRT,225427.573,225427.573,225427.573,225427.573,225427.573,225427.573,225427.573,225427.573,225427.573,225427.573
y2015,PRY,31481.381,31481.381,31481.381,31481.381,31481.381,31481.381,31481.381,31481.381,31481.381,31481.381
y2015,PSE,11726.431,11726.431,11726.431,11726.431,11726.431,11726.431,11726.431,11726.431,11726.431,11726.431
y2015,PYF,8362.201,8362.201,8362.201,8362.201,8362.201,8362.201,8362.201,8362.201,8362.201,8362.201
y2015,QAT,277211.977,277211.977,277211.977,277211.977,277211.977,277211.977,277211.977,277211.977,277211.977,277211.977
y2015,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2015,ROU,245795.189,245795.189,245795.189,245795.189,245795.189,245795.189,245795.189,245795.189,245795.189,245795.189
y2015,RUS,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136,2441534.136
y2015,RWA,15188.103,15188.103,15188.103,15188.103,15188.103,15188.103,15188.103,15188.103,15188.103,15188.103
y2015,SAU,765664.673,765664.673,765664.673,765664.673,765664.673,765664.673,765664.673,765664.673,765664.673,765664.673
y2015,SDN,96957.405,96957.405,96957.405,96957.405,96957.405,96957.405,96957.405,96957.405,96957.405,96957.405
y2015,SEN,26959.158,26959.158,26959.158,26959.158,26959.158,26959.158,26959.158,26959.158,26959.158,26959.158
y2015,SGP,323743.263,323743.263,323743.263,323743.263,323743.263,323743.263,323743.263,323743.263,323743.263,323743.263
y2015,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2015,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2015,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2015,SLB,1807.113,1807.113,1807.113,1807.113,1807.113,1807.113,1807.113,1807.113,1807.113,1807.113
y2015,SLE,6695.295,6695.295,6695.295,6695.295,6695.295,6695.295,6695.295,6695.295,6695.295,6695.295
y2015,SLV,46115.694,46115.694,46115.694,46115.694,46115.694,46115.694,46115.694,46115.694,46115.694,46115.694
y2015,SMR,3237.029,3237.029,3237.029,3237.029,3237.029,3237.029,3237.029,3237.029,3237.029,3237.029
y2015,SOM,9054.097,9054.097,9054.097,9054.097,9054.097,9054.097,9054.097,9054.097,9054.097,9054.097
y2015,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2015,SRB,104654.272,104654.272,104654.272,104654.272,104654.272,104654.272,104654.272,104654.272,104654.272,104654.272
y2015,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2015,STP,399.357,399.357,399.357,399.357,399.357,399.357,399.357,399.357,399.357,399.357
y2015,SUR,5996.869,5996.869,5996.869,5996.869,5996.869,5996.869,5996.869,5996.869,5996.869,5996.869
y2015,SVK,133453.817,133453.817,133453.817,133453.817,133453.817,133453.817,133453.817,133453.817,133453.817,133453.817
y2015,SVN,59104.79,59104.79,59104.79,59104.79,59104.79,59104.79,59104.79,59104.79,59104.79,59104.79
y2015,SWE,390868.461,390868.461,390868.461,390868.461,390868.461,390868.461,390868.461,390868.461,390868.461,390868.461
y2015,SWZ,6540.212,6540.212,6540.212,6540.212,6540.212,6540.212,6540.212,6540.212,6540.212,6540.212
y2015,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2015,SYC,2528.892,2528.892,2528.892,2528.892,2528.892,2528.892,2528.892,2528.892,2528.892,2528.892
y2015,SYR,94870.883,94870.883,94870.883,94870.883,94870.883,94870.883,94870.883,94870.883,94870.883,94870.883
y2015,TCA,2503.326,2503.326,2503.326,2503.326,2503.326,2503.326,2503.326,2503.326,2503.326,2503.326
y2015,TCD,19933.587,19933.587,19933.587,19933.587,19933.587,19933.587,19933.587,19933.587,19933.587,19933.587
y2015,TGO,6067.365,6067.365,6067.365,6067.365,6067.365,6067.365,6067.365,6067.365,6067.365,6067.365
y2015,THA,640077.64,640077.64,640077.64,640077.64,640077.64,640077.64,640077.64,640077.64,640077.64,640077.64
y2015,TJK,17379.271,17379.271,17379.271,17379.271,17379.271,17379.271,17379.271,17379.271,17379.271,17379.271
y2015,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2015,TKM,46012.7,46012.7,46012.7,46012.7,46012.7,46012.7,46012.7,46012.7,46012.7,46012.7
y2015,TLS,2179.769,2179.769,2179.769,2179.769,2179.769,2179.769,2179.769,2179.769,2179.769,2179.769
y2015,TON,669.28,669.28,669.28,669.28,669.28,669.28,669.28,669.28,669.28,669.28
y2015,TTO,44565.55,44565.55,44565.55,44565.55,44565.55,44565.55,44565.55,44565.55,44565.55,44565.55
y2015,TUN,104375.172,104375.172,104375.172,104375.172,104375.172,104375.172,104375.172,104375.172,104375.172,104375.172
y2015,TUR,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225,1015940.225
y2015,TUV,59.868,59.868,59.868,59.868,59.868,59.868,59.868,59.868,59.868,59.868
y2015,TWN,535659.063,535659.063,535659.063,535659.063,535659.063,535659.063,535659.063,535659.063,535659.063,535659.063
y2015,TZA,88182.416,88182.416,88182.416,88182.416,88182.416,88182.416,88182.416,88182.416,88182.416,88182.416
y2015,UGA,52856.783,52856.783,52856.783,52856.783,52856.783,52856.783,52856.783,52856.783,52856.783,52856.783
y2015,UKR,323442.193,323442.193,323442.193,323442.193,323442.193,323442.193,323442.193,323442.193,323442.193,323442.193
y2015,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2015,URY,51626.567,51626.567,51626.567,51626.567,51626.567,51626.567,51626.567,51626.567,51626.567,51626.567
y2015,USA,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543,14847039.543
y2015,UZB,97456.825,97456.825,97456.825,97456.825,97456.825,97456.825,97456.825,97456.825,97456.825,97456.825
y2015,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2015,VCT,1046.634,1046.634,1046.634,1046.634,1046.634,1046.634,1046.634,1046.634,1046.634,1046.634
y2015,VEN,309067.154,309067.154,309067.154,309067.154,309067.154,309067.154,309067.154,309067.154,309067.154,309067.154
y2015,VGB,3473.351,3473.351,3473.351,3473.351,3473.351,3473.351,3473.351,3473.351,3473.351,3473.351
y2015,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2015,VNM,352662.253,352662.253,352662.253,352662.253,352662.253,352662.253,352662.253,352662.253,352662.253,352662.253
y2015,VUT,1411.602,1411.602,1411.602,1411.602,1411.602,1411.602,1411.602,1411.602,1411.602,1411.602
y2015,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2015,WSM,1135.877,1135.877,1135.877,1135.877,1135.877,1135.877,1135.877,1135.877,1135.877,1135.877
y2015,YEM,68127.719,68127.719,68127.719,68127.719,68127.719,68127.719,68127.719,68127.719,68127.719,68127.719
y2015,ZAF,565342.27,565342.27,565342.27,565342.27,565342.27,565342.27,565342.27,565342.27,565342.27,565342.27
y2015,ZMB,26578.913,26578.913,26578.913,26578.913,26578.913,26578.913,26578.913,26578.913,26578.913,26578.913
y2015,ZWE,6769.741,6769.741,6769.741,6769.741,6769.741,6769.741,6769.741,6769.741,6769.741,6769.741
y2020,ABW,3709.478,3707.478,3700.05,3709.478,3717.907,3709.478,3707.478,3707.478,3707.478,3707.478
y2020,AFG,57945.294,58502.722,59788.151,59403.294,57735.437,57945.294,56828.684,47490.848,61091.386,49675.033
y2020,AGO,209079.593,208696.307,207231.593,207759.021,210647.021,209079.593,204349.468,189271.701,224405.792,181086.006
y2020,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2020,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2020,ALB,27935.067,27980.781,28269.067,27818.496,27854.496,27935.067,30596.554,25347.278,29304.681,26744.444
y2020,AND,4689.945,4689.945,4689.945,4689.945,4689.945,4689.945,4689.945,4689.945,4689.945,4689.945
y2020,ARE,550738.6,552303.028,537093.6,551844.885,569853.743,550738.6,545704.138,482569.305,512152.487,447134.825
y2020,ARG,812603.654,816018.226,821300.083,810248.369,812772.226,812603.654,1025929.172,761724.297,941541.351,773055.131
y2020,ARM,21253.767,21215.053,21444.481,21086.196,21156.053,21253.767,24610.065,19737.776,20905.271,19752.23
y2020,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2020,ATA,10,10,10,10,10,10,10,10,10,10
y2020,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2020,ATG,1589.067,1589.067,1589.067,1589.067,1589.067,1589.067,1589.067,1589.067,1589.067,1589.067
y2020,AUS,1159840.598,1156268.598,1129538.598,1152549.169,1185932.598,1159840.598,1002635.276,969727.083,1013794.178,977580
y2020,AUT,371575.436,369789.15,363653.15,368704.293,376046.436,371575.436,376544.665,362234.993,380257.509,363633.357
y2020,AZE,121343.73,121609.301,121976.159,120986.873,121503.301,121343.73,125820.685,109426.378,113354.771,109475.01
y2020,BDI,6777.614,6771.614,6659.328,6741.899,6941.899,6777.614,7956.273,6852.443,9424.577,6253.176
y2020,BEL,438046.373,436643.658,430449.515,434622.23,443631.515,438046.373,453854.488,436140.11,458450.729,437871.187
y2020,BEN,19972.144,19780.144,19670.001,19694.001,20075.287,19972.144,22337.799,20037.81,25397.226,18789.149
y2020,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2020,BFA,32527.594,33000.879,33340.165,33192.736,32544.308,32527.594,30055.567,27381.707,33612.315,25930.072
y2020,BGD,412133.523,413011.809,415562.809,405679.951,413054.237,412133.523,420476.022,326032.452,463589.298,348123.462
y2020,BGR,121348.004,120511.718,119940.861,120067.861,122230.289,121348.004,145307.197,113516.971,137483.464,121978.371
y2020,BHR,48509.516,48638.516,47282.087,48331.516,49732.373,48509.516,52166.037,44711.081,48204.26,40526.98
y2020,BHS,12675.221,12738.792,12707.364,12671.65,12779.221,12675.221,21538.679,14704.412,19355.794,14997.51
y2020,BIH,38310.846,38088.274,37991.989,37939.417,38510.417,38310.846,33893.504,30253.569,32997.698,31222.387
y2020,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2020,BLR,179612.175,178982.032,178603.175,177841.889,180098.175,179612.175,185202.607,154951.103,162199.949,155040.842
y2020,BLZ,2919.037,2918.323,2934.751,2892.037,2905.323,2919.037,4099.253,3050.578,3764.303,3095.552
y2020,BMU,5704.237,5704.237,5704.237,5704.237,5704.237,5704.237,5704.237,5704.237,5704.237,5704.237
y2020,BOL,63761.642,64569.213,65973.356,65730.07,63391.927,63761.642,80843.726,58550.499,73723.203,59506.579
y2020,BRA,2906611.773,2916357.344,2926734.344,2897738.344,2911322.202,2906611.773,4125165.815,2955737.659,3751646.995,3005890.393
y2020,BRB,6915.929,6917.929,6903.357,6895.929,6931.929,6915.929,15128.616,9700.773,13394.947,9933.555
y2020,BRN,21430.253,21738.538,21452.824,21374.824,21587.681,21430.253,44701.711,28548.428,40970.949,50070.453
y2020,BTN,9049.468,9077.611,8973.611,8973.754,9243.754,9049.468,6203.113,5084.674,6713.678,5346.285
y2020,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2020,BWA,40549.145,40525.145,39648.003,39771.717,40832.003,40549.145,43896.603,39854.232,49273.732,37659.635
y2020,CAF,4824.396,4859.11,4854.681,4846.824,4848.396,4824.396,7053.207,6030.134,8414.089,5474.71
y2020,CAN,1550083.034,1545520.605,1513821.176,1538419.748,1578606.319,1550083.034,1488035.775,1434903.048,1523055.233,1497158.233
y2020,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2020,CHE,376037.574,374455.859,368305.431,373958.145,381036.859,376037.574,389048.531,373043.809,393201.178,374607.816
y2020,CHL,351564.442,352536.299,352982.585,350294.299,352820.728,351564.442,397691.402,306435.444,368543.978,310349.096
y2020,CHN,20976917.191,20779733.762,20702073.762,20695658.191,21202051.905,20976917.191,18491089.813,14012423.999,15028738.024,19545430.487
y2020,CIV,56192.872,56709.872,57748.158,57144.301,56071.158,56192.872,68473.843,59038.742,81024.338,53916.44
y2020,CMR,62914.796,63371.367,63882.653,63752.082,63057.367,62914.796,80766.051,70404.851,94548.436,64779.772
y2020,COD,40956.73,41160.158,41485.587,41307.587,41288.158,40956.73,58015.902,48676.844,70438.64,43606.685
y2020,COG,26658.684,26620.255,26501.97,26590.97,26889.541,26658.684,28875.204,25474.926,33398.227,23628.92
y2020,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2020,COL,576806.45,580384.164,585480.45,576960.164,578186.593,576806.45,762339.279,553789.562,695727.881,562733.539
y2020,COM,1044.59,1053.732,1059.447,1052.161,1042.304,1044.59,1566.859,1350.666,1854.437,1233.295
y2020,CPV,2765.522,2782.808,2839.237,2760.379,2732.379,2765.522,2801.116,2572.651,3105.018,2448.617
y2020,CRI,72311.221,72627.506,72602.792,72253.792,72994.221,72311.221,88921.321,66227.428,81672.824,67200.691
y2020,CUB,123030.677,121772.391,119902.534,120033.819,123839.105,123030.677,255809.024,167632.513,227645.185,171414.099
y2020,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2020,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2020,CYM,6025.919,6025.919,6025.919,6025.919,6025.919,6025.919,6025.919,6025.919,6025.919,6025.919
y2020,CYP,29329.95,29362.807,29162.093,29293.093,29610.378,29329.95,29715.752,28802.98,44106.04,28892.177
y2020,CZE,334919.368,332711.94,325627.797,332156.368,340976.654,334919.368,391514.491,312729.739,372125.171,333699.369
y2020,DEU,3192458.409,3176764.267,3138901.552,3172844.409,3230918.267,3192458.409,3405378.895,3262281.032,3442507.625,3276264.778
y2020,DJI,3182.934,3175.363,3153.934,3149.077,3189.934,3182.934,5080.648,4293.506,6127.697,3866.168
y2020,DMA,633.644,633.644,633.644,633.644,633.644,633.644,633.644,633.644,633.644,633.644
y2020,DNK,225086.461,224037.603,220513.889,223295.889,228083.318,225086.461,234017.38,224699.29,236435.088,225609.868
y2020,DOM,132937.65,133774.793,135281.65,132694.222,132459.65,132937.65,149935.336,118070.377,139757.574,119436.955
y2020,DZA,370437.159,373090.016,376693.445,370377.016,370131.873,370437.159,537887.505,435772.166,578705.169,360698.653
y2020,ECU,141059.508,142202.079,144290.365,141541.365,140785.937,141059.508,201287.352,143323.786,182773.617,145809.643
y2020,EGY,775161.229,777427.8,780945.658,768652.372,775626.515,775161.229,868756.266,740397.775,920063.873,646030.73
y2020,ERI,3048.898,2992.47,2863.898,2864.898,3075.756,3048.898,2992.47,2992.47,2992.47,2992.47
y2020,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2020,ESP,1440282.38,1436729.38,1415754.523,1429656.38,1456871.095,1440282.38,1486459.492,1432545.016,1500448.352,1437813.622
y2020,EST,31179.98,30983.837,30521.694,30939.551,31580.98,31179.98,35868.174,28670.676,30395.336,28692.027
y2020,ETH,149555.58,150431.437,151159.009,150534.723,150006.009,149555.58,133163.293,122775.449,146981.118,117135.906
y2020,FIN,207000.064,205632.921,202632.349,204955.064,210031.492,207000.064,209233.201,201004.801,211368.174,201808.893
y2020,FJI,4567.027,4601.599,4617.456,4506.599,4513.599,4567.027,9289.065,6187.154,4549.286,10320.022
y2020,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2020,FRA,2374381.217,2367559.503,2335315.503,2358511.217,2396711.646,2374381.217,2492477.74,2390093.913,2519042.647,2400099.02
y2020,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2020,FSM,359.014,359.014,359.014,359.014,359.014,359.014,359.014,359.014,359.014,359.014
y2020,GAB,30163.233,29993.661,29679.09,29492.518,30231.518,30163.233,44382.212,38808.987,51795.67,35783.292
y2020,GBR,2595537.72,2583623.148,2540701.148,2572653.005,2631152.291,2595537.72,2553080.864,2457438.427,2577896.623,2466784.754
y2020,GEO,29265.821,28979.964,29334.964,28818.678,29239.25,29265.821,42558.489,29637.514,32733.628,29675.842
y2020,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2020,GHA,70446.31,71258.596,71738.882,71524.168,70599.596,70446.31,61919.687,56281.493,69419.568,53220.526
y2020,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2020,GIN,25506.724,24931.581,24599.724,24096.866,25537.866,25506.724,19286.76,17121.517,22166.948,15946.011
y2020,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2020,GMB,4742.142,4816.428,4868.856,4838.999,4733.142,4742.142,4718.015,4263.241,5322.952,4016.345
y2020,GNB,2301.771,2317.343,2324.771,2313.486,2309.486,2301.771,3136.3,2719.068,3691.299,2492.554
y2020,GNQ,27748.221,27736.65,27610.507,27925.65,28090.936,27748.221,22255.625,22057.624,22519.005,21950.129
y2020,GRC,325685.741,323661.312,320310.884,323664.598,328624.598,325685.741,329949.362,317274.988,333237.905,318513.547
y2020,GRD,1147.494,1147.494,1147.494,1147.494,1147.494,1147.494,1147.494,1147.494,1147.494,1147.494
y2020,GRL,3433.778,3433.778,3433.778,3433.778,3433.778,3433.778,3433.778,3433.778,3433.778,3433.778
y2020,GTM,96556.246,96896.246,97392.389,96456.389,96234.389,96556.246,140832.96,101754.282,128351.114,103430.231
y2020,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2020,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2020,GUY,4204.076,4199.505,4264.076,4146.219,4149.648,4204.076,6019.621,4346.931,5485.359,4418.667
y2020,HKG,414990.772,415066.629,408540.915,413680.2,422316.772,414990.772,592228.574,469382.156,572670.881,1031705.585
y2020,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2020,HND,42660.365,43085.08,43764.651,43488.08,42524.794,42660.365,59798.134,43864.592,54708.913,44547.926
y2020,HRV,82756.114,82645.399,82342.114,82326.256,83074.542,82756.114,118673.285,90194.023,111664.397,97774.165
y2020,HTI,19139.157,19114.299,19311.728,19068.299,19055.871,19139.157,34187.483,22216.552,30363.932,22729.944
y2020,HUN,205987.468,204985.04,201854.325,204611.611,208074.897,205987.468,278193.411,218772.926,263569.734,234588.494
y2020,IDN,1816525.211,1811557.068,1813408.068,1795769.211,1824391.068,1816525.211,2030259.162,1550103.3,1919362.364,2189844.85
y2020,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2020,IND,7531382.711,7556359.711,7584206.283,7501286.711,7564780.854,7531382.711,7380919.216,6025798.856,7999528.591,6342770.97
y2020,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2020,IRL,204897.173,204293.173,200724.173,203333.173,208328.602,204897.173,181966.738,177622.052,183094.028,178046.622
y2020,IRN,999985.834,1005692.834,1006700.977,993488.549,1006277.834,999985.834,1430535.684,1155131.098,1284177.831,1000560.032
y2020,IRQ,274725.221,277903.506,284405.364,284155.506,275647.506,274725.221,368174.815,285756.784,324375.522,239499.592
y2020,ISL,14446.218,14371.504,14061.504,14311.789,14749.789,14446.218,13492.548,13017.275,13615.864,13063.72
y2020,ISR,295927.595,295451.023,288019.595,293007.738,302913.309,295927.595,368377.348,301247.175,332702.459,263570.306
y2020,ITA,1818449.585,1811979.013,1787706.013,1808230.585,1835141.87,1818449.585,2033431.11,1937465.332,2058330.765,1946843.257
y2020,JAM,24716.325,24906.182,25305.325,24683.754,24469.325,24716.325,53394.478,34442.61,47341.195,35255.39
y2020,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2020,JOR,62547.38,62917.951,62603.094,63332.523,63176.951,62547.38,68391.788,58727.466,63255.891,53303.357
y2020,JPN,4579498.279,4554995.993,4511535.565,4549286.707,4614029.136,4579498.279,4947008.875,4687798.802,5134588.515,4749654.376
y2020,KAZ,323025.822,323411.108,324638.394,321129.251,324781.537,323025.822,312935.939,259517.862,272317.866,259676.323
y2020,KEN,108078.396,107856.825,109327.968,108593.682,108081.253,108078.396,124166.8,110604.203,142207.656,103241.092
y2020,KGZ,18143.113,18225.541,18451.398,17888.255,18051.684,18143.113,22357.382,17198.073,18434.343,17213.377
y2020,KHM,52989.254,53140.968,53664.682,51941.539,52931.111,52989.254,62378.139,38184.764,45123.988,67632.299
y2020,KIR,362.969,362.969,362.969,362.969,362.969,362.969,362.969,362.969,362.969,362.969
y2020,KNA,626.072,626.072,626.072,626.072,626.072,626.072,626.072,626.072,626.072,626.072
y2020,KOR,1958872.113,1946614.541,1924779.97,1945346.684,1977714.827,1958872.113,2473380.042,1888570.188,2338312.358,2667748.768
y2020,KWT,220771.976,221777.262,219622.548,221344.548,225342.262,220771.976,260863.156,220872.315,239610.883,198427.421
y2020,LAO,29752.017,29853.302,30155.302,29909.017,29805.017,29752.017,37564.76,23049.942,26343.694,40981.751
y2020,LBN,99267.755,99481.755,99681.184,98859.327,99215.898,99267.755,112119.442,97749.299,104482.738,89684.043
y2020,LBR,4023.169,3975.884,3815.455,3902.884,4140.455,4023.169,3566.306,3130.653,4145.808,2894.137
y2020,LBY,162046.825,163103.682,164132.539,161427.253,162064.967,162046.825,231093.409,187429.396,248546.84,155328.334
y2020,LCA,2196.976,2204.976,2216.119,2197.405,2197.69,2196.976,2204.976,2204.976,2204.976,2204.976
y2020,LIE,8125.264,8125.264,8125.264,8125.264,8125.264,8125.264,8125.264,8125.264,8125.264,8125.264
y2020,LKA,172409.717,172376.003,172442.717,170202.288,172235.145,172409.717,183816.517,141486.072,203140.269,151387.458
y2020,LSO,4032.457,4031.314,4002.743,3970.028,4034.6,4032.457,4859.198,4255.091,5662.777,3927.122
y2020,LTU,63333.362,63096.933,63177.79,62637.362,63299.647,63333.362,85288.37,63747.862,68909.385,63811.761
y2020,LUX,50942.217,50787.502,49451.217,50533.645,52152.36,50942.217,46741.362,45578.676,47043.038,45692.295
y2020,LVA,37806.702,37603.273,37563.988,37440.273,38043.13,37806.702,51404.489,38387.996,41507,38426.608
y2020,MAC,47988.108,47959.108,47106.822,47379.822,48724.537,47988.108,54898.58,48294.584,53847.195,57776.559
y2020,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2020,MAR,220923.563,221369.991,223348.849,219693.706,219738.849,220923.563,268812.171,222333.592,287390.643,188163.308
y2020,MCO,11428.523,11428.523,11428.523,11428.523,11428.523,11428.523,11428.523,11428.523,11428.523,11428.523
y2020,MDA,14299.121,14151.407,14335.264,14070.264,14167.121,14299.121,22512.272,15535.507,20795.255,15556.203
y2020,MDG,26834.227,27235.084,27464.084,27425.656,26956.084,26834.227,37298.348,32432.322,43771.098,29790.563
y2020,MDV,2922.161,2946.875,2963.447,2917.304,2929.161,2922.161,3034.113,2454.464,3298.722,2590.048
y2020,MEX,2111396.802,2127989.231,2150338.659,2111233.231,2104511.802,2111396.802,3175158.859,2268055.199,2885427.26,2306957.741
y2020,MHL,319.959,319.959,319.959,319.959,319.959,319.959,319.959,319.959,319.959,319.959
y2020,MKD,25521.981,25435.124,25267.267,25295.267,25758.41,25521.981,31419.305,24130.169,29625.412,26070.271
y2020,MLI,26535.685,26335.828,26605.971,26532.114,26538.828,26535.685,28208.272,25657.577,31601.186,24272.809
y2020,MLT,11827.003,11814.575,11746.146,11793.003,11937.146,11827.003,11037.311,10696.886,11125.64,10730.153
y2020,MMR,101452.851,101617.422,102329.136,100101.708,101634.993,101452.851,83523.836,69122.012,80197.591,88310.459
y2020,MNE,6994.204,7002.061,6992.061,6959.49,7015.49,6994.204,10346.752,7591.807,9668.747,8325.073
y2020,MNG,27857.882,27741.025,27791.882,27504.168,28198.311,27857.882,39547.928,21605.903,25677.368,43771.732
y2020,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2020,MOZ,41875.439,42194.439,42181.868,42101.868,42034.725,41875.439,34407.599,32231.285,37302.514,31049.767
y2020,MRT,11980.162,11936.591,11944.877,11954.02,12042.734,11980.162,12360.981,11081.96,14062.326,10387.581
y2020,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2020,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2020,MUS,21828.026,21814.883,21809.454,21673.168,21961.454,21828.026,24262.899,21710.314,27658.327,20324.52
y2020,MWI,21900.321,21895.321,22050.607,21979.75,21958.607,21900.321,22990.313,20658.118,26092.579,19391.973
y2020,MYS,584641.512,586639.798,588148.798,581104.226,587142.798,584641.512,654942.659,513671.009,622314.559,701896.024
y2020,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2020,NAM,20252.035,20280.178,20261.463,20308.749,20296.749,20252.035,23582.377,21118.394,26859.946,19780.702
y2020,NCL,12802.927,12759.07,12617.784,12659.07,12937.641,12802.927,30423.831,19825.151,14228.844,33946.433
y2020,NER,18910.683,19093.398,19302.255,19264.398,18947.826,18910.683,20525.716,18345.545,23425.761,17161.934
y2020,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2020,NGA,635747.111,639530.825,644191.111,642440.968,637888.254,635747.111,603406.316,549678.748,674874.292,520510.138
y2020,NIC,20263.251,20447.251,20933.536,20215.108,20001.679,20263.251,30685.271,21257.302,27673.95,21661.635
y2020,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2020,NLD,764686.627,762582.341,754080.627,759624.341,771023.913,764686.627,774954.053,746648.995,782298.194,749415.01
y2020,NOR,299850.851,298103.565,292307.993,296883.422,305642.279,299850.851,286464.775,276864.64,288955.664,277802.78
y2020,NPL,48948.05,48913.192,49153.764,49054.621,49045.478,48948.05,64584.431,47296.038,72476.543,51339.914
y2020,NRU,62.959,62.959,62.959,62.959,62.959,62.959,62.959,62.959,62.959,62.959
y2020,NZL,146224.15,145916.436,143827.722,145247.007,147965.007,146224.15,135447.658,130482.345,137131.355,131667.223
y2020,OMN,115324.584,116522.727,115194.442,114885.299,115687.442,115324.584,140222.956,118138.502,128486.647,105743.583
y2020,PAK,636206.659,642375.374,648185.945,645851.659,635309.088,636206.659,884343.513,654267.797,989372.557,708084.114
y2020,PAN,77958.628,78516.628,78826.628,77870.057,78365.2,77958.628,75108.009,59690.614,70183.647,60351.813
y2020,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2020,PER,411894.616,413769.187,420623.616,411205.616,409653.045,411894.616,445949.011,342557.835,412925.563,346991.926
y2020,PHL,485092.276,488723.419,493334.562,491330.133,486463.133,485092.276,634936.327,462744.871,595166.989,692166.269
y2020,PLW,295.323,295.323,295.323,295.323,295.323,295.323,295.323,295.323,295.323,295.323
y2020,PNG,28627.109,28731.824,28880.681,28843.681,28733.109,28627.109,35568.093,26707.232,22028.527,38513.108
y2020,POL,917660.061,912025.061,900997.203,912091.632,927445.489,917660.061,945254.162,802438.564,910106.532,840450.872
y2020,PRI,104928.563,104556.848,103852.991,103245.848,104871.991,104928.563,116772.823,112062.17,184785.339,113935.006
y2020,PRK,30799.758,30799.758,30799.758,30799.758,30799.758,30799.758,240674.032,86995.174,121868.501,276852.188
y2020,PRT,249871.777,248674.777,244616.062,248454.348,252975.634,249871.777,257624.466,246722.706,260453.079,247788.043
y2020,PRY,41572.184,41866.612,42219.612,42312.184,41720.041,41572.184,59180.899,40729.898,53287.595,41521.198
y2020,PSE,17914.084,17598.798,16725.798,16427.512,18356.941,17914.084,17598.798,17598.798,17598.798,17598.798
y2020,PYF,8283.03,8242.03,8156.458,8159.601,8349.601,8283.03,17726.479,11993.936,8967.042,19631.761
y2020,QAT,318680.123,327066.409,322313.266,329848.123,340882.123,318680.123,282458.633,264104.534,272704.741,253803.28
y2020,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2020,ROU,292381.305,291353.448,291765.02,290642.02,293040.877,292381.305,366900.204,285223.928,346799.266,306963.177
y2020,RUS,2939612.545,2924796.545,2907946.831,2910138.117,2965484.831,2939612.545,3812697.259,2913448.375,3128925.802,2916115.932
y2020,RWA,21377.231,21509.66,21638.374,21591.66,21496.231,21377.231,21851.706,19561.062,24898.702,18317.475
y2020,SAU,924272.149,930626.292,929962.577,943795.149,936705.434,924272.149,1258980.912,1012328.48,1127902.774,873894.586
y2020,SDN,139966.347,141968.633,143800.204,144102.633,140829.776,139966.347,125746.157,110045.096,132022.203,98501.936
y2020,SEN,34775.993,35008.707,35777.136,35578.993,34670.136,34775.993,39358.91,35144.713,44964.599,32856.833
y2020,SGP,384761.94,384981.94,380288.511,382777.226,389544.94,384761.94,439933.76,351743.356,419565.304,469244.922
y2020,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2020,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2020,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2020,SLB,2252.097,2246.954,2240.526,2225.526,2258.097,2252.097,3054.08,2236.929,1805.457,3325.67
y2020,SLE,8830.538,8867.538,8837.538,8857.538,8902.395,8830.538,12434.387,10698.106,14743.975,9755.481
y2020,SLV,50672.309,50764.167,52005.167,50247.738,49735.595,50672.309,79019.739,56388.122,71791.134,57358.714
y2020,SMR,2986.441,2986.441,2986.441,2986.441,2986.441,2986.441,2986.441,2986.441,2986.441,2986.441
y2020,SOM,7972.226,7938.226,7916.512,7906.083,7975.083,7972.226,18334.609,15592.59,21982.02,14103.952
y2020,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2020,SRB,110273.661,110114.233,109590.661,109279.519,110626.376,110273.661,180852.65,133196.934,169124.341,145881.149
y2020,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2020,STP,922.877,926.592,952.306,928.877,915.449,922.877,926.592,926.592,926.592,926.592
y2020,SUR,7047.888,7075.602,7110.03,7035.316,7065.888,7047.888,10406.728,7388.632,9442.739,7518.068
y2020,SVK,155368.414,154648.986,152473.557,154337.414,157503.414,155368.414,171154.378,141475.547,163850.27,149374.971
y2020,SVN,65050.963,64748.248,63678.248,64697.534,65940.677,65050.963,79217.045,64287.127,75542.718,68260.927
y2020,SWE,436267.681,434614.253,427017.681,432916.11,442748.967,436267.681,425033.339,409797.61,428986.46,411286.469
y2020,SWZ,6884.324,6797.896,6685.753,6617.896,6888.61,6884.324,10623.796,9322.563,12354.685,8616.125
y2020,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2020,SYC,2335.538,2335.538,2335.538,2335.538,2335.538,2335.538,2335.538,2335.538,2335.538,2335.538
y2020,SYR,149634.9,151014.471,151646.185,151033.471,150053.328,149634.9,152162.714,123169.624,136754.959,106897.227
y2020,TCA,2287.117,2287.117,2287.117,2287.117,2287.117,2287.117,2287.117,2287.117,2287.117,2287.117
y2020,TCD,23672.361,23362.932,23408.218,23326.646,23678.075,23672.361,25485.074,23307.023,28382.299,22124.563
y2020,TGO,8394.027,8381.598,8378.17,8363.027,8431.884,8394.027,11299.667,9718.067,13403.498,8859.419
y2020,THA,826602.406,824584.977,819028.406,818306.549,833995.263,826602.406,1071786.627,787762.845,1006188.495,1166185.414
y2020,TJK,22570.089,22537.232,23057.661,22469.375,22367.661,22570.089,28197.014,21243.073,22909.372,21263.701
y2020,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2020,TKM,75668.457,76386.6,76696.885,75145.457,75308.314,75668.457,54586.685,46667.212,48564.871,46690.704
y2020,TLS,3282.516,3312.087,3435.802,3336.659,3228.659,3282.516,3312.087,3312.087,3312.087,3312.087
y2020,TON,683.383,685.954,697.954,683.097,671.525,683.383,685.954,685.954,685.954,685.954
y2020,TTO,47910.328,47983.328,48202.614,47858.471,47838.043,47910.328,61875.657,48307.338,57541.895,48889.236
y2020,TUN,136668.862,136752.005,136985.719,135741.576,137389.576,136668.862,152814.094,129487.141,162138.371,112337.55
y2020,TUR,1294260.479,1302607.907,1313312.764,1298501.764,1297273.907,1294260.479,1039512.122,1010953.567,1489751.69,1013744.354
y2020,TUV,55.241,55.241,55.241,55.241,55.241,55.241,55.241,55.241,55.241,55.241
y2020,TWN,770748.054,769973.054,760962.054,777035.054,781359.054,770748.054,769973.054,769973.054,769973.054,769973.054
y2020,TZA,114815.214,116723.642,117621.785,117187.5,115026.5,114815.214,108937.55,100288.607,120442.304,95593.11
y2020,UGA,73033.386,74338.671,75129.528,74833.386,73202.671,73033.386,61308.375,57158.619,66828.347,54905.724
y2020,UKR,390231.88,387124.594,384401.88,385147.594,393795.451,390231.88,646243.109,453314.032,499543.571,453886.342
y2020,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2020,URY,61658.058,61642.486,61962.486,61299.201,61606.915,61658.058,85810.307,61994.179,78203.365,63015.571
y2020,USA,17220176.18,17111609.894,16809474.751,17080471.037,17501109.323,17220176.18,16488605.328,15885134.963,16558970.761,16125059.421
y2020,UZB,137116.707,137166.421,138272.85,135317.993,135443.135,137116.707,119787.451,100833.164,105374.978,100889.39
y2020,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2020,VCT,1237.257,1238.115,1262.972,1232.686,1224.972,1237.257,1238.115,1238.115,1238.115,1238.115
y2020,VEN,376847.989,380085.418,384336.418,378139.561,377720.275,376847.989,609001.965,411816.437,546020.323,420273.043
y2020,VGB,3141.663,3141.663,3141.663,3141.663,3141.663,3141.663,3141.663,3141.663,3141.663,3141.663
y2020,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2020,VNM,486984.646,486859.503,487503.217,483544.503,490043.36,486984.646,598531.167,384157.575,432803.957,648997.713
y2020,VUT,1618.802,1621.516,1627.231,1624.374,1622.802,1618.802,2517.612,1807.664,1432.797,2753.572
y2020,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2020,WSM,1178.038,1187.038,1214.895,1190.466,1158.752,1178.038,2256.827,1560.152,1192.295,2488.375
y2020,YEM,80742.331,81483.902,82183.474,82013.331,80512.045,80742.331,97554.665,81528.732,89038.027,72534.163
y2020,ZAF,706555.232,704070.517,693812.517,697160.232,711022.803,706555.232,920413.3,807393.542,1070751.264,746035.298
y2020,ZMB,36146.783,36612.212,37473.212,37283.497,36251.497,36146.783,39875.822,35443.063,45772.242,33036.525
y2020,ZWE,7669.921,7668.35,7758.35,7581.207,7573.207,7669.921,16295.555,13574.55,19915.015,12097.32
y2025,ABW,3226.565,3211.565,3187.708,3228.565,3262.422,3226.565,3211.565,3211.565,3211.565,3211.565
y2025,AFG,77499.578,76355.435,77821.293,76542.578,78131.864,77499.578,78738.012,49677.182,82055.15,57163.734
y2025,AGO,234275.994,229986.423,228958.994,230937.851,245593.851,234275.994,265307.823,219980.035,304074.332,207973.605
y2025,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2025,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2025,ALB,33028.556,32530.985,32626.556,32064.413,33422.413,33028.556,43005.771,28134.207,35491.221,31312.1
y2025,AND,4365.321,4365.321,4365.321,4365.321,4365.321,4365.321,4365.321,4365.321,4365.321,4365.321
y2025,ARE,664319.5,660556.357,622736.5,666166.071,722712.785,664319.5,723239.067,517654.959,586912.674,455610.964
y2025,ARG,994086.712,985132.855,976124.569,964415.141,1011610.855,994086.712,1690505.81,883592.914,1267220.21,942270.443
y2025,ARM,25658.973,24842.544,25009.401,24577.83,25984.544,25658.973,36759.613,22956.08,24982.166,23267.591
y2025,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2025,ATA,10,10,10,10,10,10,10,10,10,10
y2025,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2025,ATG,1457.441,1457.441,1457.441,1457.441,1457.441,1457.441,1457.441,1457.441,1457.441,1457.441
y2025,AUS,1332120.998,1313179.998,1242244.998,1317660.141,1413546.998,1332120.998,1020141.485,946570.424,1042203.094,947953.872
y2025,AUT,402496.196,396981.625,381231.625,397928.911,418604.196,402496.196,419942.592,384652.671,420240.026,378789.166
y2025,AZE,128988.442,128971.585,129758.299,128779.727,132322.585,128988.442,159532.794,113086.58,119903.968,114134.756
y2025,BDI,10814.011,10157.011,9328.44,9473.583,11736.583,10814.011,13586.304,10267.899,16424.364,9388.919
y2025,BEL,476182.311,472330.882,453867.596,469325.025,494279.596,476182.311,509625.029,465938.565,509993.232,458679.953
y2025,BEN,27218.12,25667.12,24696.834,24595.834,28154.406,27218.12,33108.831,26194.451,39022.343,24362.969
y2025,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2025,BFA,47634.995,46737.566,45769.137,45041.28,48817.423,47634.995,41896.356,33858.019,48771.13,31728.823
y2025,BGD,588323.936,566509.507,557865.507,531288.793,608632.364,588323.936,667784.167,373860.785,701333.95,449580.319
y2025,BGR,148511.67,143252.098,138663.384,141654.384,154584.241,148511.67,227123.712,137059.787,181614.723,156305.475
y2025,BHR,60384.93,60514.93,55781.073,59392.93,64388.644,60384.93,75174.456,50899.102,59077.047,43572.953
y2025,BHS,14172.351,14162.494,13889.637,14051.208,14601.351,14172.351,39562.703,18690.047,28613.449,20207.876
y2025,BIH,47473.538,46056.395,45130.824,45641.681,49000.681,47473.538,40385.371,30073.181,35174.657,32276.785
y2025,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2025,BLR,213533.812,208185.527,203776.812,205181.241,219306.812,213533.812,255237.569,169532.954,182112.702,171467.095
y2025,BLZ,3413.531,3333.102,3320.96,3177.531,3414.102,3413.531,6732.546,3529.769,5052.452,3762.67
y2025,BMU,5274.288,5274.288,5274.288,5274.288,5274.288,5274.288,5274.288,5274.288,5274.288,5274.288
y2025,BOL,85526.701,85450.844,85863.13,85978.559,86093.273,85526.701,137873.529,69787.381,102157.3,74738.506
y2025,BRA,3444385.644,3392844.787,3353642.787,3339571.787,3517441.501,3444385.644,7136029.602,3564457.878,5262475.606,3824177.366
y2025,BRB,7241.94,7199.94,7103.798,7209.94,7371.94,7241.94,29773.079,13195.807,21077.072,14401.282
y2025,BRN,25533.377,25958.949,24875.52,25178.52,26361.234,25533.377,91536.221,41264.64,68213.551,81478.527
y2025,BTN,14198.39,13893.676,13130.676,13466.962,15132.962,14198.39,8927.893,5447.133,9325.203,6343.834
y2025,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2025,BWA,48730.121,48003.121,45373.835,46275.264,50232.835,48730.121,62054.591,49902.145,72447.948,46683.204
y2025,CAF,6714.83,6535.258,6238.401,6156.687,6990.83,6714.83,12324.839,9249.21,14955.265,8434.537
y2025,CAN,1700015.028,1705626.171,1623244.314,1689317.457,1809155.599,1700015.028,1634191.499,1503157.765,1661268.465,1593209.009
y2025,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2025,CHE,410127.811,403291.383,387287.526,406433.954,428371.383,410127.811,442937.093,403466.912,443269.759,396908.846
y2025,CHL,431591.702,427192.416,419434.987,419595.416,442134.273,431591.702,620012.311,341305.837,473810.115,361572.965
y2025,CHN,29227313.159,27580935.302,26729359.302,27443279.159,30847055.588,29227313.159,28577267.079,13760162.304,16035396.544,24637179.489
y2025,CIV,91624.893,89395.893,88006.465,85055.75,93640.465,91624.893,116519.359,88154.93,140777.987,80641.756
y2025,CMR,86700.33,85311.473,83528.044,82280.901,89046.473,86700.33,132598.929,101450.399,159238.654,93199.772
y2025,COD,73883.441,70394.299,68420.156,66821.156,78030.299,73883.441,107199.163,79123.467,131210.852,71686.773
y2025,COG,38853.403,37593.546,36179.975,36067.975,40306.117,38853.403,45490.439,35268.295,54232.91,32560.652
y2025,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2025,COL,693699.708,686567.137,683939.708,675003.137,711478.994,693699.708,1294834.565,657899.096,960714.719,704216.114
y2025,COM,1442.825,1410.11,1360.539,1329.968,1470.253,1442.825,2668.114,2018.18,3223.968,1846.025
y2025,CPV,3468.935,3400.507,3489.364,3334.65,3447.65,3468.935,3773.997,3087.17,4361.404,2905.243
y2025,CRI,89963.684,88724.255,86589.827,87098.827,93475.684,89963.684,145871.989,76562.16,109513.848,81602.27
y2025,CUB,130442.397,125424.826,120532.111,121775.683,134455.254,130442.397,492038.049,222736.569,350769.47,242319.78
y2025,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2025,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2025,CYM,5503.165,5503.165,5503.165,5503.165,5503.165,5503.165,5503.165,5503.165,5503.165,5503.165
y2025,CYP,30756.291,30544.006,29708.577,30563.577,31873.149,30756.291,31534.463,29283.423,62993.983,28909.408
y2025,CZE,397261.64,388188.783,368901.497,391846.64,419061.212,397261.64,589043.858,365841.172,476260.315,413537.176
y2025,DEU,3392210.008,3339282.722,3228138.294,3356639.008,3520749.722,3392210.008,3899377.946,3546475.918,3902352.311,3487840.393
y2025,DJI,4391.778,4333.635,4215.778,4178.064,4496.778,4391.778,9194.259,6827.9,11218.082,6201.099
y2025,DMA,585.726,585.726,585.726,585.726,585.726,585.726,585.726,585.726,585.726,585.726
y2025,DNK,241266.384,237665.67,228567.241,238024.241,251500.098,241266.384,264140.127,241160.24,264333.809,237342.076
y2025,DOM,158985.209,158271.494,158314.209,154366.351,160026.209,158985.209,225721.089,128401.738,174669.879,135478.659
y2025,DZA,457849.966,457888.68,461170.537,452190.68,465071.394,457849.966,930871.122,616404.516,958518.121,449781.064
y2025,ECU,174091.423,173411.566,173467.138,169795.138,176625.281,174091.423,351052.95,174025.372,258188.868,186898.559
y2025,EGY,1005348.024,991856.167,978141.881,962417.31,1026436.596,1005348.024,1330629.074,935346.061,1365381.218,725901.184
y2025,ERI,4194.249,3908.392,3531.249,3496.249,4405.963,4194.249,3908.392,3908.392,3908.392,3908.392
y2025,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2025,ESP,1524289.484,1509944.484,1449423.769,1497542.484,1578905.912,1524289.484,1638677.279,1505715.63,1639797.92,1483623.731
y2025,EST,36739.483,36017.197,34559.912,36202.626,38226.483,36739.483,53896.966,33505.952,36498.951,33966.127
y2025,ETH,210592.65,204079.364,198405.507,194971.936,217796.507,210592.65,176431.197,145202.57,203139.424,136930.727
y2025,FIN,227359.386,223079.101,215117.958,224081.386,237139.244,227359.386,235402.854,215110.313,235573.885,211738.659
y2025,FJI,5263.523,5254.666,5224.38,4954.666,5224.666,5263.523,18165.181,8511.543,4985.956,16233.805
y2025,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2025,FRA,2579262.181,2550081.752,2469379.752,2547885.181,2661238.038,2579262.181,2836592.555,2584097.797,2838720.657,2542145.182
y2025,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2025,FSM,333.107,333.107,333.107,333.107,333.107,333.107,333.107,333.107,333.107,333.107
y2025,GAB,35559.027,34521.884,33000.741,32522.599,36179.599,35559.027,72106.35,55351.75,86435.692,50913.789
y2025,GBR,2880166.266,2828344.124,2718703.124,2837454.838,3000585.409,2880166.266,2837084.59,2601215.17,2839072.569,2562024.896
y2025,GEO,39083.351,36734.637,36594.637,36544.065,40314.208,39083.351,78562.545,41956.519,47329.562,42782.627
y2025,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2025,GHA,104444.092,102421.663,99948.235,98297.806,107616.663,104444.092,87130.338,70180.422,101626.724,65690.726
y2025,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2025,GIN,46380.603,41289.317,37749.603,35788.889,48279.889,46380.603,29717.158,23207.862,35284.222,21483.678
y2025,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2025,GMB,6754.952,6731.523,6655.38,6508.666,6866.952,6754.952,6797.561,5430.389,7966.833,5068.252
y2025,GNB,3283.643,3173.786,3052.643,2998.071,3404.071,3283.643,5242.883,3988.572,6315.63,3656.33
y2025,GNQ,33838.351,33218.208,32291.923,33263.208,35124.78,33838.351,19794.114,19198.869,20303.197,19041.2
y2025,GRC,354893.618,346426.76,334513.903,349495.332,367832.332,354893.618,368981.824,337724.806,369245.267,332531.377
y2025,GRD,1059.721,1059.721,1059.721,1059.721,1059.721,1059.721,1059.721,1059.721,1059.721,1059.721
y2025,GRL,3178.748,3178.748,3178.748,3178.748,3178.748,3178.748,3178.748,3178.748,3178.748,3178.748
y2025,GTM,119735.705,116976.705,114658.991,111387.991,120803.991,119735.705,240949.622,121598.723,178341.232,130277.746
y2025,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2025,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2025,GUY,5016.564,4882.421,4974.564,4727.849,4940.706,5016.564,10306.337,5197.747,7626.503,5569.236
y2025,HKG,476510.81,474857.524,451166.096,470706.667,503820.81,476510.81,1034837.474,602863.047,834096.74,1708302.128
y2025,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2025,HND,51927.138,51622.566,51961.709,50745.566,52449.995,51927.138,100222.625,51559.706,74695.318,55098.402
y2025,HRV,90677.595,89452.166,87609.595,89418.88,92926.452,90677.595,193885.261,113201.531,153116.052,130442.773
y2025,HTI,25561.63,24618.916,24359.773,23459.916,25916.059,25561.63,66348.403,29787.768,47169.641,32446.404
y2025,HUN,226895.723,223320.866,214656.438,223886.009,235076.581,226895.723,430021.283,261678.912,344958.467,297651.859
y2025,IDN,2518855.009,2414588.723,2360259.723,2370755.009,2607578.723,2518855.009,3305496.564,1811175.299,2612230.902,3006531.922
y2025,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2025,IND,10139350.759,9890942.759,9652661.902,9662429.759,10471867.045,10139350.759,10704789.526,6487439.851,11186177.442,7573899.027
y2025,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2025,IRL,228343.145,226414.145,216447.145,225367.145,238934.002,228343.145,183869.72,173155.035,183960.026,171374.764
y2025,IRN,1157596.195,1178856.195,1171060.481,1153482.624,1212769.195,1157596.195,2363291.766,1466499.87,1768613.481,1195853.697
y2025,IRQ,332357.017,337351.589,360461.303,361508.589,350430.589,332357.017,657301.215,388925.792,479336.81,307931.772
y2025,ISL,16759.682,16430.253,15553.253,16444.824,17746.824,16759.682,14769.569,13597.471,14779.448,13402.724
y2025,ISR,361986.496,357939.353,338471.496,354830.781,382665.924,361986.496,592457.231,373863.211,447503.739,307892.906
y2025,ITA,1945591.487,1920544.344,1853393.344,1920245.487,2009299.059,1945591.487,2406441.809,2169774.98,2408436.509,2130452.215
y2025,JAM,26613.771,26511.485,27153.771,26020.628,26371.771,26613.771,104431.894,46550.651,74068.893,50759.69
y2025,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2025,JOR,80225.983,80145.126,77584.412,80051.269,83484.126,80225.983,98091.41,66621.762,77223.34,57124.42
y2025,JPN,4846116.899,4746367.328,4622167.47,4787697.756,4994615.613,4846116.899,5576653.233,4997151.353,5804245.414,5008048.451
y2025,KAZ,434179.519,427394.09,428557.661,426622.376,450320.947,434179.519,438952.721,287615.589,309828.898,291030.893
y2025,KEN,145578.33,140607.187,139399.473,136374.902,148773.044,145578.33,188940.677,148167.897,223811.525,137367.997
y2025,KGZ,23726.26,23345.118,23485.832,22054.546,23979.403,23726.26,35839.717,21223.034,23368.475,21552.896
y2025,KHM,73914.545,71442.973,70848.402,66377.116,75727.259,73914.545,117602.814,40364.761,55102.139,97967.933
y2025,KIR,334.441,334.441,334.441,334.441,334.441,334.441,334.441,334.441,334.441,334.441
y2025,KNA,586.309,586.309,586.309,586.309,586.309,586.309,586.309,586.309,586.309,586.309
y2025,KOR,2312478.927,2266617.785,2194971.642,2285013.07,2388154.356,2312478.927,4026464.635,2206443.534,3182095.916,3662338.146
y2025,KWT,258290.814,259152.385,254941.957,261638.957,274503.385,258290.814,387450.02,257229.015,301098.209,217929.131
y2025,LAO,42195.014,40861.585,40733.585,39522.014,43485.014,42195.014,73979.954,25959.499,33333.26,61210.604
y2025,LBN,111767.296,111322.296,110137.153,109175.439,112911.582,111767.296,154542.982,107749.905,123513.68,93628.048
y2025,LBR,7410.641,6847.07,6058.213,6310.07,8062.213,7410.641,5717.305,4407.616,6837.414,4060.706
y2025,LBY,196922.521,198068.235,199712.949,195676.378,200108.806,196922.521,398948.694,264484.331,410770.414,193236.969
y2025,LCA,2415.313,2392.313,2380.599,2364.171,2455.742,2415.313,2392.313,2392.313,2392.313,2392.313
y2025,LIE,7480.756,7480.756,7480.756,7480.756,7480.756,7480.756,7480.756,7480.756,7480.756,7480.756
y2025,LKA,231505.931,228538.502,224054.931,222889.074,235687.788,231505.931,295436.313,163697.248,310473.623,197635.415
y2025,LSO,5671.714,5437.428,5189.286,5044.857,5842,5671.714,7856.276,6040.169,9409.499,5559.118
y2025,LTU,73429.801,72029.944,71034.658,70664.801,74589.373,73429.801,142920.705,81894.947,90852.325,83272.147
y2025,LUX,55271.014,54889.585,51514.014,54252.871,58350.3,55271.014,47576.451,44709.081,47600.618,44232.661
y2025,LVA,45169.918,43744.061,42843.49,43440.061,46810.775,45169.918,86252.802,49376.17,54788.933,50208.384
y2025,MAC,50045.59,49934.59,47656.019,48641.019,52153.447,50045.59,74848.838,51626.692,64057.388,69457.29
y2025,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2025,MAR,298108.302,291005.16,287454.874,283211.588,301458.874,298108.302,443683.581,300551.697,456267.324,224711.757
y2025,MCO,10533.558,10533.558,10533.558,10533.558,10533.558,10533.558,10533.558,10533.558,10533.558,10533.558
y2025,MDA,19420.101,18362.672,18454.387,18162.387,19597.101,19420.101,42030.805,22265.144,32043.285,22711.206
y2025,MDG,36944.856,36441.57,35917.57,35468.713,38387.57,36944.856,61746.533,47117.959,74257.595,43243.14
y2025,MDV,3738.134,3712.563,3685.706,3637.42,3829.134,3738.134,4476.399,2672.439,4682.312,3137.169
y2025,MEX,2427643.502,2434294.359,2455177.216,2387654.359,2443952.502,2427643.502,5514739.122,2744337.396,4061458.151,2945796.97
y2025,MHL,297.256,297.256,297.256,297.256,297.256,297.256,297.256,297.256,297.256,297.256
y2025,MKD,32098.317,31356.603,30334.889,30945.889,33479.175,32098.317,50495.227,29844.597,40060.536,34257.414
y2025,MLI,36065.238,33959.523,33642.809,33330.095,36776.523,36065.238,39580.785,31912.715,46138.888,29881.596
y2025,MLT,13466.336,13314.479,12992.622,13342.336,13960.622,13466.336,11723.184,10883.641,11730.26,10744.148
y2025,MMR,145275.375,137907.518,136271.947,129795.09,151141.661,145275.375,118002.03,73181.268,97208.178,109034.866
y2025,MNE,8378.67,8295.384,8111.384,8154.242,8595.242,8378.67,17811.247,10006.296,13867.432,11674.129
y2025,MNG,41692.568,39563.854,38352.568,38930.14,44136.425,41692.568,85709.157,26350.215,35465.052,69924.735
y2025,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2025,MOZ,59649.866,57726.866,55780.723,55161.723,61699.437,59649.866,42387.627,35845.047,47983.157,34112.047
y2025,MRT,16281.469,16013.326,15707.897,15663.183,16772.612,16281.469,18360.917,14515.837,21649.415,13497.351
y2025,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2025,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2025,MUS,27905.355,27177.069,26641.212,26637.64,28815.212,27905.355,36304.881,28631.131,42867.843,26598.507
y2025,MWI,31546.101,30211.101,29718.672,29250.958,32515.672,31546.101,33855.546,26844.347,39851.862,24987.219
y2025,MYS,741586.593,731847.165,721147.165,714942.022,758159.165,741586.593,1020543.686,580883.885,816570.785,932582.189
y2025,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2025,NAM,25677.696,25245.981,24706.553,24936.124,26199.124,25677.696,35179.427,27772.039,41514.582,25809.969
y2025,NCL,13094.939,12888.225,12485.653,12752.225,13597.367,13094.939,60971.164,27986.389,15940.08,54371.993
y2025,NER,27188.236,26300.665,25974.379,25735.665,27922.522,27188.236,30843.695,24289.52,36449.141,22553.449
y2025,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2025,NGA,896367.259,877319.687,865248.259,853291.973,924797.545,896367.259,841417.298,679897.905,979556.472,637114.626
y2025,NIC,26664.709,26396.709,26904.28,25035.423,26415.566,26664.709,55387.615,26593.484,40282.96,28687.351
y2025,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2025,NLD,821170.022,814263.451,787614.022,809525.451,845505.594,821170.022,855774.279,785969.516,856362.615,774371.286
y2025,NOR,326633.376,320169.804,307458.661,322969.518,345629.233,326633.376,309938.625,286263.169,310138.169,282329.435
y2025,NPL,66875.708,64355.994,62490.136,61734.851,68946.565,66875.708,111919.809,58115.586,118061.273,71976.446
y2025,NRU,72.85,72.85,72.85,72.85,72.85,72.85,72.85,72.85,72.85,72.85
y2025,NZL,161881.959,159937.53,154338.101,159829.673,167799.673,161881.959,140728.021,129627.34,144056.76,129836.08
y2025,OMN,135934.154,134270.439,129869.868,132955.582,136825.868,135934.154,210768.263,138855.302,163081.529,117152.421
y2025,PAK,799412.05,794075.478,786065.621,775871.05,811789.907,799412.05,1510146.404,794114.252,1591877.646,978576.002
y2025,PAN,103334.357,102977.357,101640.357,100755.214,106167.5,103334.357,111348.505,64261.961,86648.124,67686.026
y2025,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2025,PER,535263.68,526604.823,532347.68,517448.68,539235.537,535263.68,698605.391,382836.526,532961.225,405798.778
y2025,PHL,638055.563,628383.849,622544.135,610543.278,657525.278,638055.563,1107780.979,571893.834,859164.992,1000567.549
y2025,PLW,274.569,274.569,274.569,274.569,274.569,274.569,274.569,274.569,274.569,274.569
y2025,PNG,38024.258,37546.686,36985.401,36471.401,39235.258,38024.258,59417.926,31841.52,21770.392,53900.792
y2025,POL,1053090.884,1029715.884,996272.17,1041779.027,1091582.741,1053090.884,1264064.607,859458.075,1059618.329,945918.122
y2025,PRI,108680.636,107200.207,105878.493,104910.207,108856.493,108680.636,134475.827,122710.641,278765.479,123333.215
y2025,PRK,28582.088,28582.088,28582.088,28582.088,28582.088,28582.088,652403.205,143975.955,222047.286,517204.87
y2025,PRT,278096.981,272850.981,261152.552,274432.123,289877.695,278096.981,295561.055,268675.585,295787.654,264208.499
y2025,PRY,57134.987,56037.844,55371.844,56214.987,58945.701,57134.987,107669.889,51318.352,78109.332,55416.153
y2025,PSE,27140.736,25658.165,23552.165,22246.594,28991.451,27140.736,25658.165,25658.165,25658.165,25658.165
y2025,PYF,8273.858,8129.858,7921.715,8018.001,8513.001,8273.858,34036.879,16196.292,9680.764,30467.563
y2025,QAT,349631.269,367304.841,357202.555,382154.269,419055.269,349631.269,313434.379,253668.464,273802.562,235631.485
y2025,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2025,ROU,349817.421,339721.707,334214.85,337151.85,359107.564,349817.421,578176.456,346781.881,461253.579,396228.403
y2025,RUS,3534053.954,3441398.954,3352618.526,3421838.097,3721188.526,3534053.954,6176638.078,3629003.384,4002945.945,3686497.188
y2025,RWA,31349.359,30473.217,29443.645,29031.217,32606.359,31349.359,32644.863,25758.577,38534.347,23934.536
y2025,SAU,1114202.624,1119949.91,1117746.481,1161501.624,1166420.195,1114202.624,2098058.757,1294891.661,1565464.703,1052500.866
y2025,SDN,191667.289,189250.861,187801.004,186068.861,197886.147,191667.289,178996.97,130645.183,183247.92,105025.478
y2025,SEN,47381.827,46211.256,46244.113,45423.827,48051.113,47381.827,59355.98,46686.983,70191.117,43331.217
y2025,SGP,438891.617,438932.617,423294.759,432659.188,454218.617,438891.617,662984.531,388521.994,535652.172,608073.585
y2025,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2025,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2025,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2025,SLB,3026.081,2916.795,2826.938,2761.938,3109.081,3026.081,5291.187,2748.084,1819.322,4782.396
y2025,SLE,12537.782,12105.782,11587.782,11554.782,13075.496,12537.782,21303.635,16083.909,25767.796,14701.308
y2025,SLV,56834.925,56052.639,58219.639,53887.782,55200.496,56834.925,137423.72,68304.089,101165.352,73330.368
y2025,SMR,2735.853,2735.853,2735.853,2735.853,2735.853,2735.853,2735.853,2735.853,2735.853,2735.853
y2025,SOM,7046.355,6906.355,6831.927,6796.07,7096.07,7046.355,32558.41,24315.17,39608.426,22131.699
y2025,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2025,SRB,119600.051,118033.194,115148.051,115636.765,122344.48,119600.051,309663.305,174651.344,241442.229,203501.942
y2025,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2025,STP,1441.398,1382.826,1415.255,1322.398,1457.541,1441.398,1382.826,1382.826,1382.826,1382.826
y2025,SUR,8517.906,8388.335,8348.192,8260.763,8711.906,8517.906,18217.195,8999.573,13381.87,9669.865
y2025,SVK,177811.012,175099.155,168564.298,175909.012,184881.012,177811.012,241620.598,157538.403,199134.156,175505.86
y2025,SVN,71459.136,70322.707,67359.707,70727.278,74644.564,71459.136,115812.045,73514.547,94439.266,82553.066
y2025,SWE,483665.901,477776.044,457593.901,477437.758,505241.472,483665.901,467219.715,429645.99,467536.397,423403.025
y2025,SWZ,7975.437,7615.58,7166.294,6968.58,8122.008,7975.437,17053.231,13141.378,20398.837,12105.206
y2025,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2025,SYC,2142.184,2142.184,2142.184,2142.184,2142.184,2142.184,2142.184,2142.184,2142.184,2142.184
y2025,SYR,209369.916,207626.059,205073.488,201495.059,214639.773,209369.916,250097.556,155688.205,187493.075,127196.055
y2025,TCA,2070.909,2070.909,2070.909,2070.909,2070.909,2070.909,2070.909,2070.909,2070.909,2070.909
y2025,TCD,31822.134,29784.277,29066.848,28765.705,32463.562,31822.134,34963.132,28415.331,40563.126,26680.949
y2025,TGO,12007.689,11399.832,11056.975,10963.689,12466.403,12007.689,19383.265,14628.554,23449.723,13369.126
y2025,THA,1077777.172,1046593.315,1004433.172,1023333.457,1123923.886,1077777.172,1847647.109,963720.013,1437563.737,1670802.308
y2025,TJK,31445.908,29829.193,30548.051,28323.479,31798.051,31445.908,46691.961,26990.963,29882.681,27435.565
y2025,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2025,TKM,107975.214,112581.5,111182.071,108383.214,111616.928,107975.214,71903.831,49467.411,52760.635,49973.745
y2025,TLS,4928.263,4780.406,4976.835,4580.549,4891.549,4928.263,4780.406,4780.406,4780.406,4780.406
y2025,TON,743.486,731.628,754.628,709.914,720.771,743.486,731.628,731.628,731.628,731.628
y2025,TTO,51589.107,51081.107,50969.678,51100.393,52066.536,51589.107,94473.724,53034.476,72735.768,56047.878
y2025,TUN,179613.552,176691.837,174499.266,174079.98,185065.98,179613.552,237596.125,165760.221,243911.731,127697.209
y2025,TUR,1608774.732,1598998.589,1583848.304,1570687.304,1640455.589,1608774.732,1078119.887,1007689.961,2062417.081,995987.858
y2025,TUV,50.615,50.615,50.615,50.615,50.615,50.615,50.615,50.615,50.615,50.615
y2025,TWN,956035.045,951994.045,904324.045,967976.045,1009259.045,956035.045,951994.045,951994.045,951994.045,951994.045
y2025,TZA,161254.012,160472.869,156974.154,154010.583,165922.583,161254.012,145284.93,119283.901,167522.263,112396.745
y2025,UGA,106716.988,105783.559,103779.274,101653.988,109811.559,106716.988,77241.114,64765.841,87910.568,61461.39
y2025,UKR,487456.566,465543.995,447715.566,461083.995,512654.709,487456.566,1182039.212,635457.706,715685.098,647792.696
y2025,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2025,URY,73705.548,71928.405,71444.405,70811.834,74857.262,73705.548,146828.619,74091.351,108672.533,79380.699
y2025,USA,19589681.816,19152697.245,18363614.959,19339459.531,20513366.102,19589681.816,18501641.005,16994431.334,18106243.301,17074187.836
y2025,UZB,192189.589,188533.018,186782.875,184566.16,192178.446,192189.589,163043.757,109344.942,117226.869,110556.791
y2025,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2025,VCT,1448.881,1401.595,1430.31,1384.738,1453.31,1448.881,1401.595,1401.595,1401.595,1401.595
y2025,VEN,469289.824,468996.682,471550.682,463620.967,479910.396,469289.824,1131113.495,528885.601,815200.344,572678.736
y2025,VGB,2809.974,2809.974,2809.974,2809.974,2809.974,2809.974,2809.974,2809.974,2809.974,2809.974
y2025,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2025,VNM,656214.038,634795.752,622883.181,625374.752,681496.467,656214.038,1129070.14,419841.966,528747.198,940475.866
y2025,VUT,2004.002,1954.43,1922.859,1903.145,2055.002,2004.002,4483.865,2274.393,1467.476,4041.822
y2025,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2025,WSM,1280.198,1270.198,1320.912,1246.055,1249.627,1280.198,4221.936,2053.775,1261.945,3788.159
y2025,YEM,101340.942,102601.085,102939.228,101257.942,102052.371,101340.942,149447.039,97262.262,114842.407,81513.223
y2025,ZAF,879809.193,858559.764,820202.764,836981.193,903666.336,879809.193,1479235.44,1139467.919,1769821.007,1049470.252
y2025,ZMB,51875.652,50908.51,51166.51,49921.081,53592.081,51875.652,61164.072,47838.017,72561.157,44308.21
y2025,ZWE,9807.101,9442.958,9372.958,8798.672,9784.672,9807.101,30726.776,22546.708,37722.764,20379.971
y2030,ABW,2787.652,2737.652,2683.366,2790.652,2882.938,2787.652,2737.652,2737.652,2737.652,2737.652
y2030,AFG,108761.863,100781.148,100507.434,97401.863,113561.291,108761.863,100647.339,54626.014,111826.712,69094.654
y2030,AGO,257050.395,242385.538,241643.395,248771.681,288792.681,257050.395,326266.177,263201.577,421201.381,248822.151
y2030,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2030,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2030,ALB,39359.045,37350.188,36722.045,36731.331,41133.331,39359.045,55414.987,31266.14,42143.357,37091.527
y2030,AND,4040.697,4040.697,4040.697,4040.697,4040.697,4040.697,4040.697,4040.697,4040.697,4040.697
y2030,ARE,797360.4,779345.686,717165.4,805822.257,923529.828,797360.4,900773.996,588179.836,694117.805,475639.319
y2030,ARG,1202419.77,1163938.484,1117474.055,1124324.912,1268235.484,1202419.77,2355082.448,1067662.279,1646373.225,1158944.983
y2030,ARM,31416.178,28769.035,28408.321,28538.464,32862.035,31416.178,48909.162,26494.61,30228.481,27958.42
y2030,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2030,ATA,10,10,10,10,10,10,10,10,10,10
y2030,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2030,ATG,1325.815,1325.815,1325.815,1325.815,1325.815,1325.815,1325.815,1325.815,1325.815,1325.815
y2030,AUS,1521428.399,1466149.399,1333220.399,1498287.113,1698279.399,1521428.399,1037647.693,934319.005,1072020.737,918969.104
y2030,AUT,436522.957,424613.1,394875.1,429758.528,471722.957,436522.957,463340.519,410641.665,458058.88,394572.96
y2030,AZE,139667.153,136775.868,137380.439,138267.582,149419.868,139667.153,193244.903,117824.283,130388.037,122749.72
y2030,BDI,17713.409,14979.409,12540.552,12593.266,20905.266,17713.409,19216.336,14599.435,26166.454,13546.73
y2030,BEL,523884.248,515212.106,478171.677,512459.82,562494.677,523884.248,565395.57,500158.06,558857.27,480266.122
y2030,BEN,38679.096,33513.096,30560.667,30121.667,42378.524,38679.096,43879.864,34259.879,58361.447,32066.416
y2030,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2030,BFA,70883.396,64980.253,60034.11,58015.824,76364.539,70883.396,53737.145,42553.398,70572.761,40003.379
y2030,BGD,834137.349,742737.206,698569.206,646289.634,911394.491,834137.349,915092.312,449629.223,1028161.321,595966.114
y2030,BGR,180215.336,166433.479,154162.907,163688.907,195618.193,180215.336,308940.226,162691.988,228565.687,197971.212
y2030,BHR,74539.344,74003.344,63866.058,71741.344,82954.915,74539.344,98182.876,61271.784,73780.93,47983.009
y2030,BHS,15784.481,15492.195,14786.909,15480.766,16871.481,15784.481,57586.728,24284.647,39254.336,26645.884
y2030,BIH,58089.231,54279.516,51668.659,53713.945,62186.945,58089.231,46877.238,30132.025,37674.469,34171.445
y2030,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2030,BLR,251927.45,236282.021,223684.45,231879.593,268112.45,251927.45,325272.532,186103.058,209286.254,195191.693
y2030,BLZ,4121.025,3857.882,3761.168,3510.025,4209.882,4121.025,9365.839,4255.845,6552.849,4618.162
y2030,BMU,4844.338,4844.338,4844.338,4844.338,4844.338,4844.338,4844.338,4844.338,4844.338,4844.338
y2030,BOL,115693.761,110700.475,107062.904,110204.047,120390.618,115693.761,194903.332,86272.672,135103.468,93974.975
y2030,BRA,4069457.515,3843926.23,3678330.23,3765028.23,4312894.801,4069457.515,10146893.389,4448492.117,7009992.448,4852529.19
y2030,BRB,7705.952,7490.952,7206.238,7618.952,8091.952,7705.952,44417.543,17968.697,29857.773,19844.015
y2030,BRN,29904.502,30230.359,27818.216,28965.216,31806.787,29904.502,138370.73,58759.625,98936.926,117982.55
y2030,BTN,20659.312,19505.741,17348.741,18502.169,23101.169,20659.312,11652.672,6140.469,12991.681,7873.45
y2030,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2030,BWA,58088.097,55515.097,49961.668,52737.811,62191.668,58088.097,80212.579,63304.868,105664.845,59449.723
y2030,CAF,9754.264,8727.407,7693.121,7439.55,10865.264,9754.264,17596.471,13317.345,24038.114,12341.657
y2030,CAN,1853683.022,1870768.737,1732137.451,1856792.165,2115695.88,1853683.022,1780347.223,1584673.007,1793076.871,1693846.035
y2030,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2030,CHE,447341.049,431180.906,399885.621,441307.763,487745.906,447341.049,496825.655,437884.369,490918.381,419912.249
y2030,CHL,520327.961,500331.533,474284.39,487073.533,551272.819,520327.961,842333.221,397660.272,597546.144,429189.178
y2030,CHN,38578110.127,33850952.842,31376099.842,33870831.127,42938152.27,38578110.127,38663444.346,14185181.3,17697445.812,31171128.421
y2030,CIV,147653.915,135292.915,124844.772,117476.2,157239.772,147653.915,164564.876,125101.414,223971.765,116103.309
y2030,CMR,122619.864,114116.578,105941.435,102844.721,132080.578,122619.864,184431.807,141094.823,249669.76,131213.511
y2030,COD,133927.153,114472.439,103701.725,98537.725,152838.439,133927.153,156382.424,117320.678,215184.587,108414.168
y2030,COG,55232.123,50746.837,46632.98,46261.98,59982.694,55232.123,62105.674,47883.594,83515.087,44640.803
y2030,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2030,COL,856192.967,813269.109,782855.967,791498.109,912236.395,856192.967,1827329.852,811106.696,1267911.303,883160.56
y2030,COM,2115.06,1930.488,1737.631,1665.774,2264.203,2115.06,3769.369,2865.115,5130.6,2658.935
y2030,CPV,4392.348,4073.205,4125.491,3977.92,4462.92,4392.348,4746.878,3791.295,6185.378,3573.412
y2030,CRI,110784.147,105301.004,98721.861,102233.861,120418.147,110784.147,202822.657,92239.629,141948.038,100080.362
y2030,CUB,140803.118,128557.261,119192.689,123567.546,151135.403,140803.118,728267.074,298599.685,491740.376,329064.643
y2030,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2030,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2030,CYM,4980.411,4980.411,4980.411,4980.411,4980.411,4980.411,4980.411,4980.411,4980.411,4980.411
y2030,CYP,33053.633,32106.205,30204.062,32661.062,35796.919,33053.633,33353.173,29991.67,87198.731,28966.695
y2030,CZE,470120.912,449696.627,411296.198,460897.912,515768.769,470120.912,786573.225,424130.663,587383.449,511562.091
y2030,DEU,3606040.606,3488826.178,3269120.035,3550213.606,3881476.178,3606040.606,4393376.997,3866384.248,4340560.189,3705695.911
y2030,DJI,6175.623,5885.908,5478.623,5416.051,6559.623,6175.623,13307.87,10015.553,18264.006,9264.868
y2030,DMA,537.808,537.808,537.808,537.808,537.808,537.808,537.808,537.808,537.808,537.808
y2030,DNK,259457.307,251426.736,234587.593,254752.593,280535.878,259457.307,294262.875,259946.739,290823.608,249483.211
y2030,DOM,190489.767,184502.195,179520.767,177242.481,196322.767,190489.767,301506.841,146234.946,216031.542,157244.28
y2030,DZA,555575.773,540654.344,536181.63,533319.344,584083.915,555575.773,1323854.739,847943.274,1490720.305,559629.814
y2030,ECU,217840.339,209363.053,202440.91,202021.91,229178.624,217840.339,500818.547,218373.099,345335.746,238399.494
y2030,EGY,1324089.819,1255270.534,1189902.105,1200617.248,1401129.676,1324089.819,1792501.882,1194283.458,2002251.096,831874.825
y2030,ERI,6075.599,5113.313,4267.599,4157.599,6871.17,6075.599,5113.313,5113.313,5113.313,5113.313
y2030,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2030,ESP,1642231.587,1599719.587,1480696.015,1593239.587,1767281.73,1642231.587,1790895.067,1592341.872,1770995.465,1531799.896
y2030,EST,42845.986,41379.558,38463.129,41966.701,45988.986,42845.986,71925.757,38814.278,44330.07,40976.664
y2030,ETH,307698.72,276051.291,252340.006,242839.149,337674.006,307698.72,219699.1,176250.678,285104.809,166343.957
y2030,FIN,250892.709,241660.281,226296.566,246156.709,271293.995,250892.709,261572.506,231269.417,258535.438,222029.531
y2030,FJI,6349.018,6103.732,5910.304,5433.732,6462.732,6349.018,27041.297,11753.599,5431.155,23126.161
y2030,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2030,FRA,2838766.145,2757964.002,2600098.002,2786223.145,3031207.43,2838766.145,3180707.37,2803653.978,3142917.938,2688684.497
y2030,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2030,FSM,307.2,307.2,307.2,307.2,307.2,307.2,307.2,307.2,307.2,307.2
y2030,GAB,42456.822,39691.107,36253.393,35937.679,44484.679,42456.822,99830.489,76519.796,134921.577,71204.7
y2030,GBR,3191526.813,3065860.099,2856887.099,3117703.67,3454952.527,3191526.813,3121088.316,2768861.738,3085787.102,2661462.341
y2030,GEO,50687.881,44229.309,42732.309,44348.452,54460.166,50687.881,114566.6,55124.745,65026.717,59006.67
y2030,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2030,GHA,153988.874,141123.731,129978.588,125452.445,166873.731,153988.874,112340.989,88758.552,147841.151,83381.496
y2030,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2030,GIN,79166.482,62818.054,52148.482,47634.911,86568.911,79166.482,40147.556,31091.165,53780.725,29026.207
y2030,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2030,GMB,9811.761,9281.618,8738.904,8397.333,10417.761,9811.761,8877.108,6974.959,11740.535,6541.248
y2030,GNB,4985.514,4447.228,3967.514,3826.657,5483.657,4985.514,7349.466,5604.342,9976.513,5206.434
y2030,GNQ,40686.481,38991.767,36769.338,39134.767,43749.624,40686.481,17332.603,16504.437,18579.294,16315.607
y2030,GRC,394147.494,373706.208,348052.923,383737.065,424313.065,394147.494,408014.285,361337.814,403336.228,347105.427
y2030,GRD,971.949,971.949,971.949,971.949,971.949,971.949,971.949,971.949,971.949,971.949
y2030,GRL,2923.717,2923.717,2923.717,2923.717,2923.717,2923.717,2923.717,2923.717,2923.717,2923.717
y2030,GTM,154165.164,143554.164,135560.593,129201.593,160929.593,154165.164,341066.284,150643.308,236240.74,164144.98
y2030,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2030,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2030,GUY,5999.051,5533.337,5587.051,5321.479,6013.765,5999.051,14593.054,6442.357,10106.194,7020.271
y2030,HKG,536457.848,532181.419,481807.276,524803.134,594870.848,536457.848,1477446.373,805176.463,1162130.432,2531470.487
y2030,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2030,HND,66397.91,62949.053,61195.767,58635.053,69565.196,66397.91,140647.117,63005.993,97906.618,68511.027
y2030,HRV,100139.076,96356.933,91725.076,97727.504,106038.361,100139.076,269097.238,138080.813,197093.74,169685.691
y2030,HTI,36186.104,32242.533,30297.819,28293.533,38284.247,36186.104,98509.323,40177.253,66398.225,44313.206
y2030,HUN,253248.979,245249.693,227689.55,247498.407,271255.264,253248.979,581849.155,308490.257,431617.633,374432.178
y2030,IDN,3460104.807,3085012.379,2881427.379,3023283.807,3765538.379,3460104.807,4580733.965,2214296.202,3408565.298,3974695.916
y2030,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2030,IND,13699184.808,12597436.808,11661030.522,12109087.808,14810616.236,13699184.808,14028659.835,7349978.509,15651026.663,9449688.416
y2030,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2030,IRL,255112.116,251692.116,233229.116,250714.116,276189.401,255112.116,185772.701,169772.336,184169.096,164893.574
y2030,IRN,1359570.556,1363354.556,1340606.985,1336645.699,1489717.556,1359570.556,3296047.847,1932460.395,2394579.348,1441540.037
y2030,IRQ,416500.814,417937.671,469203.242,477499.671,476563.671,416500.814,946427.614,538358.183,676652.664,391444.547
y2030,ISL,19472.145,18766.002,17055.002,18901.86,21499.86,19472.145,16046.59,14296.283,15871.169,13762.586
y2030,ISR,439162.396,426349.682,388758.396,425008.825,482774.539,439162.396,816537.114,484161.158,596803.167,364498.776
y2030,ITA,2105682.39,2038569.675,1904059.675,2056524.39,2255653.247,2105682.39,2779452.509,2426035.15,2744031.952,2318272.666
y2030,JAM,29498.217,28287.788,28719.217,27702.503,29716.217,29498.217,155469.31,63120.457,104632.384,69668.322
y2030,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2030,JOR,107133.587,103979.301,96189.73,103165.015,116566.301,107133.587,127791.033,79940.894,96157.277,62713.831
y2030,JPN,5174535.519,4920534.662,4676294.376,5090277.805,5527641.091,5174535.519,6206297.591,5392401.904,6443037.02,5271494.359
y2030,KAZ,543413.215,518370.072,524296.929,532249.501,596415.358,543413.215,564969.504,319224.173,360161.04,335272.877
y2030,KEN,203358.264,183762.55,173326.978,166623.121,218189.836,203358.264,253714.555,196987.341,339109.683,184052.909
y2030,KGZ,31838.408,29941.694,29433.265,26849.837,33169.123,31838.408,49322.051,25587.086,29540.916,27137.128
y2030,KHM,101701.836,91817.979,87698.121,79385.693,108980.407,101701.836,172827.49,44881.359,68346.339,135490.571
y2030,KIR,305.914,305.914,305.914,305.914,305.914,305.914,305.914,305.914,305.914,305.914
y2030,KNA,546.546,546.546,546.546,546.546,546.546,546.546,546.546,546.546,546.546,546.546
y2030,KOR,2659167.742,2561645.028,2415927.313,2616606.456,2822516.885,2659167.742,5579549.229,2697326.534,4151896.582,4841420.11
y2030,KWT,306593.651,303886.508,300272.365,317539.365,346149.508,306593.651,514036.884,316033.612,383136.8,244748.242
y2030,LAO,58792.011,53130.868,51123.868,48361.011,63584.011,58792.011,110395.149,31064.041,42446.868,86113.454
y2030,LBN,126891.837,124033.837,119495.123,120137.551,131052.266,126891.837,196966.523,125816.847,149929.428,100201.457
y2030,LBR,12960.113,10799.256,8669.97,9079.256,15230.97,12960.113,7868.305,6046.133,10611.337,5630.658
y2030,LBY,236721.216,234883.788,236828.359,234065.502,249616.645,236721.216,566803.979,363306.594,638154.868,240025.187
y2030,LCA,2766.651,2635.651,2556.079,2594.937,2921.794,2766.651,2635.651,2635.651,2635.651,2635.651
y2030,LIE,6836.247,6836.247,6836.247,6836.247,6836.247,6836.247,6836.247,6836.247,6836.247,6836.247
y2030,LKA,305904.145,289380.002,271214.145,278287.859,322713.43,305904.145,407056.109,198431.428,457734.64,264020.919
y2030,LSO,8167.971,7237.543,6486.828,6183.686,8886.4,8167.971,10853.354,8326.602,14657.037,7750.474
y2030,LTU,83357.241,79745.955,76547.527,77543.241,86436.098,83357.241,200553.04,101457.762,117965.3,107929.303
y2030,LUX,59368.811,58705.668,52897.811,57601.097,64908.24,59368.811,48411.54,44129.663,47982.397,42824.051
y2030,LVA,53690.135,49883.849,47319.992,49617.849,57976.42,53690.135,121101.115,61219.842,71195.013,65130.463
y2030,MAC,52268.072,52013.072,47835.215,50024.215,56295.358,52268.072,94799.097,58659.109,77848.295,83869.766
y2030,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2030,MAR,401300.042,373786.328,353707.899,355490.471,418375.899,401300.042,618554.992,401940.244,694505.132,270712.165
y2030,MCO,9638.593,9638.593,9638.593,9638.593,9638.593,9638.593,9638.593,9638.593,9638.593,9638.593
y2030,MDA,26123.081,22990.938,22467.509,22750.509,27061.081,26123.081,61549.338,29453.323,43910.135,31549.393
y2030,MDG,54269.485,49822.056,46719.056,45336.771,60168.056,54269.485,86194.717,65841.966,116833.024,61201.314
y2030,MDV,4811.107,4599.25,4440.964,4501.536,5133.107,4811.107,5918.686,3061.897,6612.649,3960.043
y2030,MEX,2831694.201,2772727.487,2751027.773,2707378.487,2930571.201,2831694.201,7854319.385,3434175.555,5421083.698,3747579.594
y2030,MHL,274.552,274.552,274.552,274.552,274.552,274.552,274.552,274.552,274.552,274.552
y2030,MKD,40067.654,37957.083,35256.511,37228.511,43635.94,40067.654,69571.15,36038.098,51142.186,44127.222
y2030,MLI,51906.79,44952.219,42335.647,41402.076,55503.219,51906.79,50953.298,40284.704,67013.42,37852.146
y2030,MLT,15420.669,14986.383,14243.097,15211.669,16596.097,15420.669,12409.056,11155.356,12283.407,10773.084
y2030,MMR,200136.9,173217.615,164323.758,151343.472,221234.329,200136.9,152480.223,81501.147,117322.126,134302.682
y2030,MNE,10059.136,9697.708,9167.708,9452.993,10701.993,10059.136,25275.742,12601.85,18310.474,15659.153
y2030,MNG,59950.255,53058.683,48921.255,52108.112,66766.54,59950.255,131870.386,33807.788,47878.303,101855.349
y2030,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2030,MOZ,87446.293,77455.293,70188.578,68231.578,95935.15,87446.293,50367.655,41264.956,64070.535,39189.44
y2030,MRT,22211.775,21130.061,19836.918,19762.346,23818.489,22211.775,24360.852,19011.188,32414.047,17791.405
y2030,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2030,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2030,MUS,34896.684,32475.255,30820.969,31571.112,37481.969,34896.684,48346.864,37670.366,64418.883,35236.007
y2030,MWI,47698.881,41983.881,39368.738,38075.167,52211.738,47698.881,44720.779,34966.09,59405.141,32741.913
y2030,MYS,934067.675,894887.532,855344.532,868317.818,984196.532,934067.675,1386144.712,689890.446,1041268.777,1207835.955
y2030,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2030,NAM,32873.356,31173.785,29389.642,30363.499,34698.499,32873.356,46776.478,36470.571,62290.623,34120.71
y2030,NCL,13621.951,13081.38,12317.523,13092.38,14788.094,13621.951,91518.497,39283.132,17680.456,78141.167
y2030,NER,41079.789,36611.932,34390.503,33560.932,44548.218,41079.789,41161.674,32042.844,54888.836,29963.65
y2030,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2030,NGA,1290205.407,1190436.55,1126905.407,1095626.979,1400491.836,1290205.407,1079428.28,854706.173,1417716.942,803467.049
y2030,NIC,36404.167,34264.167,33902.024,30468.738,36958.453,36404.167,80089.96,34149.257,54800.159,37406.617
y2030,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2030,NLD,884780.418,868345.561,812998.418,863266.561,939986.275,884780.418,936594.505,832354.232,926147.229,800569.741
y2030,NOR,359222.9,344058.043,322309.329,355848.615,399061.186,359222.9,333412.475,298057.638,329869.106,287277.395
y2030,NPL,95070.366,84525.795,77568.509,75398.081,104206.652,95070.366,159255.186,74049.717,179953.064,100837.456
y2030,NRU,82.741,82.741,82.741,82.741,82.741,82.741,82.741,82.741,82.741,82.741
y2030,NZL,180484.767,174104.624,162768.481,177052.338,194961.338,180484.767,146008.384,130417.759,151194.719,128101.708
y2030,OMN,163043.723,154137.152,144072.294,155519.866,166427.294,163043.723,281313.569,171968.679,209025.596,132602.204
y2030,PAK,1045792.44,993681.582,939402.297,915656.44,1104007.725,1045792.44,2135949.295,1002026.113,2411398.783,1358520.101
y2030,PAN,131896.086,128242.086,122971.086,124241.371,140184.8,131896.086,147589.001,72462.966,106233.028,77789.671
y2030,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2030,PER,680888.744,641448.458,634577.744,627584.744,706366.03,680888.744,951261.771,447456.208,673922.905,483177.828
y2030,PHL,847219.851,792632.279,755404.708,727781.422,915827.422,847219.851,1580625.63,731983.772,1160267.482,1363290.839
y2030,PLW,253.816,253.816,253.816,253.816,253.816,253.816,253.816,253.816,253.816,253.816
y2030,PNG,52478.406,49292.549,46601.121,45314.121,57015.406,52478.406,83267.758,39597.198,21536.618,72083.851
y2030,POL,1192120.707,1138615.707,1070450.136,1172506.421,1275971.993,1192120.707,1582875.052,925864.015,1221797.477,1084353.716
y2030,PRI,112653.708,109370.566,107170.994,106972.566,113541.994,112653.708,152178.832,135683.613,386571.456,133108.161
y2030,PRK,26364.419,26364.419,26364.419,26364.419,26364.419,26364.419,1064132.379,224196.632,344714.845,807044.531
y2030,PRT,311694.184,298766.184,275092.042,304348.899,338372.756,311694.184,333497.645,293349.256,329473.852,281107.384
y2030,PRY,79202.789,73805.075,70120.075,73733.789,85500.361,79202.789,156158.878,66250.654,106665.489,72625.469
y2030,PSE,40211.389,35902.532,31887.532,28891.675,45165.961,40211.389,35902.532,35902.532,35902.532,35902.532
y2030,PYF,8377.686,8041.686,7662.972,7999.401,8916.401,8377.686,50347.278,22094.56,10410.247,43111.836
y2030,QAT,370681.416,396020.273,380176.844,433349.416,509883.416,370681.416,344410.125,253535.026,284332.542,220818.066
y2030,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2030,ROU,419029.537,387234.965,368186.68,383739.68,447735.251,419029.537,789452.708,413707.935,582952.355,504348.234
y2030,RUS,4263468.364,3982015.364,3773337.221,3994589.078,4739276.221,4263468.364,8540578.896,4403660.733,5092798.836,4673827.317
y2030,RWA,46636.488,42300.773,38273.916,37050.773,51340.488,46636.488,43438.02,33857.122,57860.763,31672.572
y2030,SAU,1348889.099,1340584.528,1349491.385,1450864.099,1494171.956,1348889.099,2937136.602,1715907.264,2129781.139,1276238.841
y2030,SDN,269889.232,250155.089,237415.803,229450.089,292765.517,269889.232,232247.784,159072.543,257904.716,114742.014
y2030,SEN,66187.662,60834.805,57989.09,55977.662,70037.09,66187.662,79353.05,61726.661,105887.188,57707.649
y2030,SGP,484122.293,483773.293,451205.008,472333.15,515118.293,484122.293,886035.302,451390.807,670742.651,774724.07
y2030,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2030,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2030,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2030,SLB,4156.065,3764.636,3487.351,3361.351,4473.065,4156.065,7528.295,3500.985,1835.433,6496.912
y2030,SLE,18644.025,16631.025,14833.025,14605.025,20656.597,18644.025,30172.882,22910.672,41105.154,21254.808
y2030,SLV,65414.54,62083.111,64123.111,57120.825,63797.397,65414.54,195827.701,85548.131,135120.132,93367.348
y2030,SMR,2485.265,2485.265,2485.265,2485.265,2485.265,2485.265,2485.265,2485.265,2485.265,2485.265
y2030,SOM,6406.484,5973.484,5784.341,5697.056,6636.056,6406.484,46782.211,35313.382,64046.977,32698.362
y2030,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2030,SRB,131692.441,126367.155,119372.441,122621.012,139653.584,131692.441,438473.961,219237.884,317987.049,272123.845
y2030,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2030,STP,2146.918,1915.061,1922.204,1717.918,2238.632,2146.918,1915.061,1915.061,1915.061,1915.061
y2030,SUR,10401.925,9856.068,9586.354,9650.211,10991.925,10401.925,26027.662,11321.054,17931.852,12363.805
y2030,SVK,202442.61,196452.324,183032.038,199102.61,217291.61,202442.61,312086.817,175551.874,237050.473,208487.976
y2030,SVN,78849.308,76475.166,70678.166,77561.023,85621.451,78849.308,152407.045,83723.224,114660.057,100291.71
y2030,SWE,535513.121,521496.835,482644.121,525761.406,582184.978,535513.121,509406.091,453296.806,503782.648,436188.207
y2030,SWZ,9726.55,8781.264,7782.835,7474.264,10306.407,9726.55,23482.667,18040.102,31675.711,16799.137
y2030,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2030,SYC,1948.83,1948.83,1948.83,1948.83,1948.83,1948.83,1948.83,1948.83,1948.83,1948.83
y2030,SYR,290798.933,277210.647,264845.79,256844.647,310545.219,290798.933,348032.399,204481.361,253130.72,152799.948
y2030,TCA,1854.7,1854.7,1854.7,1854.7,1854.7,1854.7,1854.7,1854.7,1854.7,1854.7
y2030,TCD,45647.907,39456.621,36668.479,35954.764,48623.05,45647.907,44441.19,35331.228,58155.002,33254.056
y2030,TGO,17574.351,15145.065,13888.78,13568.351,19380.923,17574.351,27466.863,20851.629,37425.201,19343.282
y2030,THA,1394118.937,1292563.652,1177174.937,1247401.366,1520495.509,1394118.937,2623507.591,1223702.536,1930141.532,2265021.457
y2030,TJK,45008.726,39152.155,39269.44,34407.583,47050.44,45008.726,65186.907,33195.894,38525.036,35285.107
y2030,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2030,TKM,144680.971,152745.4,147013.257,144314.971,153856.543,144680.971,89220.977,52788.11,58857.188,55167.404
y2030,TLS,7448.011,6634.725,6736.868,5833.439,7648.439,7448.011,6634.725,6634.725,6634.725,6634.725
y2030,TON,845.588,796.303,823.303,740.731,824.017,845.588,796.303,796.303,796.303,796.303
y2030,TTO,55530.886,53679.886,52715.743,54287.314,57202.028,55530.886,127071.791,60955.951,90675.821,65643.801
y2030,TUN,233413.241,222856.67,214335.813,219043.384,248814.384,233413.241,322378.157,213662.224,360496.477,147800.674
y2030,TUR,1965244.986,1902535.271,1823648.843,1842680.843,2063791.271,1965244.986,1116727.652,1011553.815,2801433.289,979484.665
y2030,TUV,45.988,45.988,45.988,45.988,45.988,45.988,45.988,45.988,45.988,45.988
y2030,TWN,1118995.036,1110544.036,1002668.036,1132114.036,1238794.036,1118995.036,1110544.036,1110544.036,1110544.036,1110544.036
y2030,TZA,234714.809,220422.095,204472.523,196786.666,254689.666,234714.809,181632.309,145457.05,236089.257,137208.691
y2030,UGA,160869.59,149559.448,138726.019,133254.59,174585.448,160869.59,93173.852,75816.992,119302.251,71859.436
y2030,UKR,617268.253,554477.396,506887.253,549412.396,685874.967,617268.253,1717835.315,830281.473,978132.397,888244.28
y2030,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2030,URY,87866.039,82229.324,79624.324,80374.467,91692.61,87866.039,207846.93,91795.463,143962.002,100023.928
y2030,USA,22022674.453,21018626.596,19588436.167,21631710.025,23981495.882,22022674.453,20514676.681,18401513.964,19583154.123,18071579.075
y2030,UZB,262887.471,246402.614,235343.9,243213.328,268724.757,262887.471,206300.063,119102.473,133628.064,124797.02
y2030,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2030,VCT,1702.505,1556.076,1557.648,1533.791,1750.648,1702.505,1556.076,1556.076,1556.076,1556.076
y2030,VEN,573484.66,565707.945,576973.945,553880.374,619877.517,573484.66,1653225.026,692377.404,1124290.038,760504.944
y2030,VGB,2478.286,2478.286,2478.286,2478.286,2478.286,2478.286,2478.286,2478.286,2478.286,2478.286
y2030,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2030,VNM,872811.43,797686.002,755262.145,785344.002,949811.573,872811.43,1659609.113,487944.739,656061.047,1300985.643
y2030,VUT,2610.201,2407.344,2278.487,2233.916,2807.201,2610.201,6450.118,2951.154,1504.107,5554.043
y2030,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2030,WSM,1430.359,1361.359,1424.93,1282.644,1408.501,1430.359,6187.046,2753.501,1333.51,5307.725
y2030,YEM,133778.554,133057.268,129454.982,125752.554,138216.697,133778.554,201339.413,121991.565,148882.502,93424.659
y2030,ZAF,1084056.154,1020874.012,931914.012,982956.154,1152863.869,1084056.154,2038057.58,1565338.659,2749671.817,1457553.521
y2030,ZMB,77136.522,70609.808,67758.808,64703.665,84045.665,77136.522,82452.323,63911.768,110362.614,59684.317
y2030,ZWE,13707.281,12240.566,11584.566,10438.138,14107.138,13707.281,45157.997,33777.06,62290.454,31182.08
y2035,ABW,2400.739,2283.739,2181.025,2406.739,2605.453,2400.739,2283.739,2283.739,2283.739,2283.739
y2035,AFG,156646.147,133279.861,128404.576,121501.147,171088.718,156646.147,134260.32,59574.846,150908.948,86123.201
y2035,AGO,280016.796,246098.654,241200.796,258199.511,342028.511,280016.796,631418.395,306423.118,577202.369,319150.643
y2035,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2035,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2035,ALB,46775.534,42264.391,40325.534,41536.248,50768.248,46775.534,73520.735,34398.072,49807.541,44436.022
y2035,AND,3716.074,3716.074,3716.074,3716.074,3716.074,3716.074,3716.074,3716.074,3716.074,3716.074
y2035,ARE,934369.3,894803.014,807398.3,957034.443,1161588.871,934369.3,1240241.575,658704.712,827062.709,526864.56
y2035,ARG,1435751.827,1350086.113,1243174.541,1283757.684,1575489.113,1435751.827,2984687.447,1251731.644,2056319.358,1417308.854
y2035,ARM,38307.384,32817.526,31393.241,32723.098,41416.526,38307.384,66346.134,30033.14,36683.189,34120.805
y2035,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2035,ATA,10,10,10,10,10,10,10,10,10,10
y2035,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2035,ATG,1194.189,1194.189,1194.189,1194.189,1194.189,1194.189,1194.189,1194.189,1194.189,1194.189
y2035,AUS,1733342.799,1620038.799,1407707.799,1699280.085,2045153.799,1733342.799,1061919.304,922067.586,1109465.373,882817.916
y2035,AUT,474196.718,454659.575,406125.575,464075.146,534883.718,474196.718,512414.613,436630.659,492449.828,405790.212
y2035,AZE,147553.865,138704.151,137331.579,142417.436,166339.151,147553.865,244748.17,122561.986,144938.111,136316.185
y2035,BDI,29145.807,21608.807,16090.664,15706.95,37512.95,29145.807,42723.573,18930.971,38754.468,19862.741
y2035,BEL,579747.186,565034.329,502166.758,561528.615,646725.758,579747.186,628192.811,534377.555,603477.798,496199.229
y2035,BEN,56309.072,43657.072,36933.5,35538.5,66202.643,56309.072,91900.659,42325.307,83630.451,44266.786
y2035,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2035,BFA,105687.797,88704.94,75765.082,71084.368,120630.654,105687.797,108882.777,51248.776,99268.218,53505.85
y2035,BGD,1167017.761,940463.904,827210.904,732982.476,1351590.619,1167017.761,1280772.081,525397.662,1449157.545,793909.691
y2035,BGR,213297.002,188572.859,165479.43,183976.43,240808.145,213297.002,425255.602,188324.189,281645.727,249115.184
y2035,BHR,90578.758,89062.758,71271.044,84882.758,105530.186,90578.758,140312.289,71644.466,91524.164,56076.792
y2035,BHS,17555.611,16800.896,15519.182,16974.325,19593.611,17555.611,74706.131,29879.247,50691.757,34162.282
y2035,BIH,69534.923,62433.637,57302.494,61660.209,77110.209,69534.923,57319.176,30190.869,40876.051,37151.351
y2035,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2035,BLR,293491.087,263593.516,239043.087,257044.945,323921.087,293491.087,428136.529,202673.161,243962.579,228053.02
y2035,BLZ,5024.519,4468.661,4229.376,3825.519,5286.661,5024.519,11860.323,4981.921,8175.469,5639.126
y2035,BMU,4414.389,4414.389,4414.389,4414.389,4414.389,4414.389,4414.389,4414.389,4414.389,4414.389
y2035,BOL,154728.821,140023.107,128547.678,138189.535,167312.964,154728.821,248982.279,102757.964,170647.916,116729.13
y2035,BRA,4801474.387,4276286.672,3904238.672,4171889.672,5318182.101,4801474.387,13002965.101,5332526.355,8893806.318,6065407.044
y2035,BRB,8266.964,7777.964,7212.679,8052.964,9028.964,8266.964,58343.547,22741.587,39271.091,26143.217
y2035,BRN,34391.626,34695.769,30577.912,32542.912,37743.341,34391.626,205451.089,76254.61,132234.282,150885.078
y2035,BTN,28444.234,25970.805,21570.805,23951.377,33284.377,28444.234,15779.257,6833.805,17773.346,10013.634
y2035,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2035,BWA,68438.073,62974.073,53541.501,58749.358,76424.501,68438.073,163839.296,76707.59,149303.901,80119.858
y2035,CAF,14521.698,11536.555,9168.841,8548.412,17524.698,14521.698,39437.402,17385.48,35758.679,18249.081
y2035,CAN,2037326.017,2053574.303,1863684.588,2057192.874,2527885.16,2037326.017,1947578.919,1666188.25,1919740.873,1807790.915
y2035,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2035,CHE,488941.287,461234.43,409366.715,479518.573,559315.43,488941.287,557062.753,472301.827,534733.044,437808.181
y2035,CHL,616942.221,572796.65,518550.792,551604.65,678209.364,616942.221,1052574.98,454014.708,731918.069,511204.822
y2035,CHN,47998441.095,39108322.381,34294945.381,39327477.095,55817282.953,47998441.095,50483452.598,14610200.296,19880511.126,36626598.229
y2035,CIV,227549.936,194052.936,165279.079,150316.65,252111.079,227549.936,365417.752,162047.899,331491.397,170012.306
y2035,CMR,174133.398,150041.684,129973.826,123235.541,198317.684,174133.398,404070.8,180739.247,366814.415,189485.398
y2035,COD,236352.865,175882.579,144893.293,131740.293,292448.579,236352.865,356817.558,155517.889,323236.553,163401.223
y2035,COG,76659.842,66164.128,57557.985,56453.985,87571.27,76659.842,133790.547,60498.893,121563.962,63369.154
y2035,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2035,COL,1061511.225,955202.082,874730.225,919083.082,1181057.796,1061511.225,2332220.328,964314.296,1599414.387,1095012.415
y2035,COM,3147.295,2620.866,2172.723,2015.581,3583.152,3147.295,8372.004,3712.05,7594.626,3894.544
y2035,CPV,5550.761,4803.904,4747.618,4667.19,5776.19,5550.761,9419.893,4495.42,8598.388,4688.273
y2035,CRI,135151.61,122831.753,109627.896,117641.896,154332.61,135151.61,256769.434,107917.098,177027.205,122139.362
y2035,CUB,154292.838,131606.695,116475.267,125644.41,173306.553,154292.838,952824.561,374462.801,642988.268,429723.025
y2035,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2035,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2035,CYM,4457.657,4457.657,4457.657,4457.657,4457.657,4457.657,4457.657,4457.657,4457.657,4457.657
y2035,CYP,36114.975,33948.403,30584.546,35394.546,41325.689,36114.975,35533.95,30699.917,115621.498,28732.696
y2035,CZE,548799.184,514937.47,449965.898,533968.184,626700.327,548799.184,1069600.072,482420.154,713696.084,633076.629
y2035,DEU,3867958.205,3669310.633,3304971.776,3782335.205,4338758.633,3867958.205,4944138.175,4186292.579,4744488.731,3877885.637
y2035,DJI,8612.467,7853.181,6906.467,6790.038,9526.467,8612.467,30169.734,13203.205,27339.361,13867.652
y2035,DMA,489.89,489.89,489.89,489.89,489.89,489.89,489.89,489.89,489.89,489.89
y2035,DNK,280755.23,267318.802,240020.945,274029.945,316343.659,280755.23,328081.797,278733.237,315081.243,258650.732
y2035,DOM,227035.325,212231.897,198581.325,200521.611,240973.325,227035.325,373074.769,164068.153,261107.071,184037.925
y2035,DZA,655008.579,608552.008,583668.722,598543.008,719147.437,655008.579,2007929.564,1079482.032,2181069.999,725558.296
y2035,ECU,272949.254,249218.54,229724.683,237041.683,299918.968,272949.254,642911.762,262720.827,439238.286,299046.597
y2035,EGY,1740300.614,1570824.9,1410720.329,1475893.186,1916251.757,1740300.614,2620274.94,1453220.855,2837911.634,1008340.42
y2035,ERI,9110.949,6652.235,5013.949,4716.949,11245.378,9110.949,6652.235,6652.235,6652.235,6652.235
y2035,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2035,ESP,1785652.69,1698215.69,1500993.262,1707988.69,2014067.547,1785652.69,1964498.92,1678968.115,1889277.705,1562770.722
y2035,EST,49353.49,47223.918,42269.347,47997.776,54607.49,49353.49,97765.298,44122.603,53946.264,50161.03
y2035,ETH,458258.79,369559.219,309895.504,287816.361,538690.504,458258.79,431204.624,207298.786,393852.436,216067.427
y2035,FIN,277811.032,262508.46,236968.175,270883.032,312483.746,277811.032,291006.089,247428.52,279525.865,229694.533
y2035,FJI,7822.514,7106.799,6608.228,5805.799,8218.799,7822.514,39805.218,14995.655,5922.526,29326.922
y2035,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2035,FRA,3152589.108,2990674.251,2722059.251,3068628.108,3509195.823,3152589.108,3565434.418,3023210.16,3422588.999,2802550.798
y2035,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2035,FSM,281.293,281.293,281.293,281.293,281.293,281.293,281.293,281.293,281.293,281.293
y2035,GAB,50800.616,45410.331,39328.045,39572.759,55206.759,50800.616,217816.49,97687.841,197776.513,102392.341
y2035,GBR,3537090.36,3312225.074,2965727.074,3415410.503,3998115.646,3537090.36,3443030.192,2936508.306,3309590.328,2730378.104
y2035,GEO,64063.411,51930.982,48226.982,52448.839,70767.125,64063.411,164592.544,68292.972,85928.444,79133.178
y2035,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2035,GHA,225094.655,188639.798,160246.941,150139.084,257956.798,225094.655,228865.73,107336.682,208592.137,112096.025
y2035,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2035,GIN,125832.362,89543.79,66842.362,58344.933,142456.933,125832.362,85645.412,38974.468,77859.72,40802.204
y2035,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2035,GMB,14169.571,12465.714,11016.428,10289,15854.571,14169.571,18322.008,8519.529,16686.749,8903.416
y2035,GNB,7735.386,6219.671,5039.386,4718.243,9086.243,7735.386,16213.381,7220.112,14713.115,7572.308
y2035,GNQ,48450.611,45209.325,41146.754,45432.325,54273.468,48450.611,18077.851,13810.006,17365.885,13977.144
y2035,GRC,439085.371,402692.656,357487.942,420982.799,493098.799,439085.371,452074.246,384950.821,434391.021,357634.795
y2035,GRD,884.176,884.176,884.176,884.176,884.176,884.176,884.176,884.176,884.176,884.176
y2035,GRL,2668.687,2668.687,2668.687,2668.687,2668.687,2668.687,2668.687,2668.687,2668.687,2668.687
y2035,GTM,201594.623,176039.623,158600.195,147242.195,220218.195,201594.623,436010.273,179687.894,298694.874,204178.503
y2035,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2035,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2035,GUY,7222.538,6177.252,6105.538,5933.11,7422.824,7222.538,18658.364,7686.967,12780.837,8735.242
y2035,HKG,597745.886,591555.314,508355.457,578156.6,697125.886,597745.886,2121941.549,1007489.878,1543115.359,3245032.237
y2035,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2035,HND,86795.683,76832.54,71100.826,66195.54,95280.397,86795.683,178962.556,74452.28,122974.974,84437.832
y2035,HRV,110781.557,103385.7,94807.557,106634.128,121826.271,110781.557,375215.006,162960.094,246562.157,217419.683
y2035,HTI,52433.578,42191.15,36761.864,32889.15,58139.435,52433.578,129085.704,50566.739,87022.022,58068.922
y2035,HUN,282274.234,269251.52,239351.663,272538.805,313321.948,282274.234,798160.339,355301.602,529732.919,468928.677
y2035,IDN,4669476.605,3813125.034,3343498.034,3733098.605,5346234.034,4669476.605,6457778.657,2617417.106,4281411.228,4835805.571
y2035,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2035,IND,18354546.856,15690672.856,13518811.141,14793091.856,20852237.427,18354546.856,19050981.368,8212517.167,21467054.475,12065252.895
y2035,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2035,IRL,283270.087,278431.087,248374.087,276771.087,318852.801,283270.087,189399.073,166389.637,183337.388,157025.896
y2035,IRN,1602040.917,1575340.917,1535298.489,1561909.774,1865749.917,1602040.917,4935180.944,2398420.919,3132826.36,1823312.36
y2035,IRQ,519980.61,506921.753,603360.182,629569.753,662584.753,519980.61,1446945.565,687790.575,907569.959,515682.638
y2035,ISL,22480.609,21374.752,18520.752,21510.895,25918.895,22480.609,17512.135,14995.094,16849.037,13970.778
y2035,ISR,528471.297,501931.012,439374.297,503638.869,605110.155,528471.297,1212797.179,594459.106,773471.248,454275.756
y2035,ITA,2294632.292,2164614.007,1938151.007,2211871.292,2568581.435,2294632.292,3190529.617,2682295.32,3056638.63,2475468.249
y2035,JAM,33383.663,30263.091,30074.663,29586.377,34372.663,33383.663,203998.15,79690.264,137404.718,91567.401
y2035,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2035,JOR,144264.19,134567.476,117438.047,132805.761,165395.476,144264.19,182278.386,93260.025,119031.311,73078.683
y2035,JPN,5517112.139,5040495.997,4627149.282,5395036.854,6151361.568,5517112.139,6889231.429,5787652.455,7137773.127,5478492.072
y2035,KAZ,651555.911,602176.054,620384.197,645643.625,767366.768,651555.911,748955.765,350832.756,423741.573,395648.487
y2035,KEN,288137.198,238067.912,209786.484,195899.341,328133.627,288137.198,538143.16,245806.785,489375.324,257255.316
y2035,KGZ,42807.556,38198.271,36202.699,31841.128,45963.842,42807.556,68403.286,29951.139,36992.934,34279.603
y2035,KHM,137585.127,113944.984,103263.841,89064.27,154184.555,137585.127,236692.473,49397.958,84186.951,167638.757
y2035,KIR,277.386,277.386,277.386,277.386,277.386,277.386,277.386,277.386,277.386,277.386
y2035,KNA,506.783,506.783,506.783,506.783,506.783,506.783,506.783,506.783,506.783,506.783
y2035,KOR,2982710.556,2824347.271,2575548.985,2917179.842,3256407.414,2982710.556,7865610.052,3188209.534,5214885.112,5890114.346
y2035,KWT,360881.488,351182.631,353810.774,387993.774,440598.631,360881.488,743195.065,374838.21,481479.467,291328.072
y2035,LAO,80142.008,66542.151,60859.151,55542.008,91048.008,80142.008,152429.481,36168.583,53249.027,107521.082
y2035,LBN,144431.378,137603.378,127297.092,131076.663,153483.949,144431.378,276247.615,143883.788,182203.816,113875.601
y2035,LBR,21971.585,16184.442,11611.728,12029.442,28016.728,21971.585,17074.975,7684.65,15508.472,8052.396
y2035,LBY,280090.912,272530.341,274408.769,274811.627,310418.484,280090.912,859128.423,462128.858,933162.415,310792.821
y2035,LCA,3246.988,2918.988,2721.56,2866.702,3604.845,3246.988,2918.988,2918.988,2918.988,2918.988
y2035,LIE,6191.738,6191.738,6191.738,6191.738,6191.738,6191.738,6191.738,6191.738,6191.738,6191.738
y2035,LKA,394528.358,353001.501,311311.358,333106.644,432434.073,394528.358,571731.115,233165.607,647202.972,353515.078
y2035,LSO,11797.229,9446.657,7817.371,7234.514,13638.8,11797.229,23634.327,10613.035,21462.103,11122.977
y2035,LTU,93833.681,87765.966,81480.395,84202.681,99071.824,93833.681,281561.207,121020.578,150420.605,139092.243
y2035,LUX,63388.608,62404.751,53888.608,60772.323,72180.18,63388.608,49707.828,43550.244,48085.653,41044.402
y2035,LVA,62295.351,55365.637,50538.494,55171.637,70064.065,62295.351,170074.97,73063.514,90829.356,83983.856
y2035,MAC,54417.554,54050.554,47718.411,51227.411,60842.268,54417.554,125602.388,65691.527,94485.762,96351.617
y2035,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2035,MAR,532671.781,469450.496,419294.924,433824.353,573037.924,532671.781,925918.795,503328.791,1004724.99,342237.692
y2035,MCO,8743.628,8743.628,8743.628,8743.628,8743.628,8743.628,8743.628,8743.628,8743.628,8743.628
y2035,MDA,34199.061,27868.203,26082.632,27598.632,36064.061,34199.061,88639.08,36641.502,57122.087,42494.742
y2035,MDG,82165.114,68159.542,59612.542,56066.828,98134.542,82165.114,189451.25,84565.973,171954.187,88673.51
y2035,MDV,6165.08,5602.938,5214.223,5471.652,6899.08,6165.08,8087.48,3451.355,9120.949,5099.353
y2035,MEX,3319395.901,3137853.615,3029760.33,3053335.615,3558909.901,3319395.901,10073830.317,4124013.714,6886432.312,4692495.627
y2035,MHL,251.849,251.849,251.849,251.849,251.849,251.849,251.849,251.849,251.849,251.849
y2035,MKD,49295.99,45282.562,40021.133,43998.133,56062.705,49295.99,96557.268,42231.599,63629.163,56170.28
y2035,MLI,77043.343,60045.914,52491.485,50080.057,87590.914,77043.343,103635.915,48656.692,94464.228,50809.799
y2035,MLT,17610.002,16815.287,15515.573,17266.002,19730.573,17610.002,13229.964,11427.072,12755.004,10693.382
y2035,MMR,266449.425,205428.711,183610.568,160250.854,313022.997,266449.425,205009.061,89821.026,139730.966,156359.503
y2035,MNE,11950.602,11143.031,10098.031,10763.745,13246.745,11950.602,35729.913,15197.405,23284.662,20465.561
y2035,MNG,82029.941,68185.512,59313.941,66609.084,94869.655,82029.941,184977.532,41265.36,62378.802,129465.458
y2035,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2035,MOZ,129975.72,102142.72,84644.434,79775.434,152797.862,129975.72,93594.451,46684.865,85768.949,48521.947
y2035,MRT,30152.081,27514.795,24409.938,24215.51,33803.367,30152.081,51075.345,23506.539,46476.29,24586.194
y2035,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2035,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2035,MUS,42580.013,37645.441,34325.727,36203.584,47702.727,42580.013,101729.552,46709.602,92551.071,48864.303
y2035,MWI,73958.661,58076.661,50817.803,47608.375,86997.803,73958.661,93357.366,43087.833,84971.354,45056.498
y2035,MYS,1158397.756,1074565.899,990538.899,1035352.613,1261590.899,1158397.756,1928809.721,798897.007,1288478.024,1451592.15
y2035,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2035,NAM,41520.017,37717.589,33922.732,36192.874,45635.874,41520.017,98279.263,45169.102,89419.375,47249.012
y2035,NCL,14321.963,13290.535,12077.392,13584.535,16433.82,14321.963,135349.773,50579.875,19578.596,99547.286
y2035,NER,63835.342,51043.199,44620.627,42290.199,74090.913,63835.342,86788.882,39796.167,78949.512,41636.505
y2035,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2035,NGA,1853155.555,1590751.412,1419365.555,1348001.984,2142105.127,1853155.555,2187590.819,1029514.44,1994399.398,1074867.24
y2035,NIC,49903.625,43981.625,41561.768,35667.054,52163.34,49903.625,103544.365,41705.03,70416.189,47613.538
y2035,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2035,NLD,954666.813,926212.671,831604.813,919214.671,1051856.956,954666.813,1028642.399,878738.947,989151.319,817735.406
y2035,NOR,394776.425,368444.282,335068.997,392537.711,463064.14,394776.425,360694.376,309852.107,347300.314,289161.732
y2035,NPL,137352.025,109635.596,93373.882,87935.31,162135.739,137352.025,228259.113,89983.849,259082.959,139136.389
y2035,NRU,92.632,92.632,92.632,92.632,92.632,92.632,92.632,92.632,92.632,92.632
y2035,NZL,203981.575,190267.718,170654.861,198669.004,231420.004,203981.575,152309.536,131208.178,159483.468,125286.039
y2035,OMN,194853.292,175891.864,157483.721,180743.149,202592.721,194853.292,408502.634,205082.057,263973.39,158964.603
y2035,PAK,1398419.83,1249666.687,1107875.973,1056643.83,1551016.544,1398419.83,3050119.472,1209937.974,3460326.394,1864065.06
y2035,PAN,162865.814,154177.814,142755.814,147540.529,179612.1,162865.814,181788.765,80663.971,127614.832,90326.053
y2035,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2035,PER,845851.808,756886.094,724226.808,736892.808,903415.522,845851.808,1190232.714,512075.89,826934.843,576871.146
y2035,PHL,1121404.138,980662.709,885908.281,829721.567,1277853.567,1121404.138,2269287.855,892073.71,1488808.213,1687622.757
y2035,PLW,233.062,233.062,233.062,233.062,233.062,233.062,233.062,233.062,233.062,233.062
y2035,PNG,73057.555,63759.412,56973.84,54092.84,84240.555,73057.555,118223.424,47352.876,21434.741,88291.315
y2035,POL,1333024.53,1243919.53,1128465.102,1300842.816,1473084.245,1333024.53,2056669.469,992269.955,1411511.111,1265369.689
y2035,PRI,116497.781,111226.924,108174.496,108965.924,118060.496,116497.781,172925.552,148656.585,502339.047,143976.278
y2035,PRK,24146.749,24146.749,24146.749,24146.749,24146.749,24146.749,1535355.424,304417.309,485260.306,1059877.76
y2035,PRT,348774.388,325811.388,285629.531,335853.674,395982.817,348774.388,375758.597,318022.927,360548.514,294527.268
y2035,PRY,108301.592,95000.306,85863.306,94682.592,122608.02,108301.592,202205.59,81182.957,137372.112,92746.2
y2035,PSE,57452.042,48235.899,41580.899,35695.756,67372.47,57452.042,48235.899,48235.899,48235.899,48235.899
y2035,PYF,8645.515,8050.515,7455.229,8127.8,9591.8,8645.515,73842.608,27992.827,11225.061,54477.996
y2035,QAT,389669.562,413414.705,392544.133,479243.562,600696.562,389669.562,422461.753,253401.589,302345.4,215073.979
y2035,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2035,ROU,494244.653,429266.224,389402.51,425116.51,551055.938,494244.653,1089364.331,480633.989,720398.108,636819.793
y2035,RUS,5040280.773,4498729.773,4149298.916,4591297.058,5926106.916,5040280.773,11880387.655,5178318.082,6405677.347,5932753.626
y2035,RWA,69277.616,57407.33,47667.187,44752.33,81043.616,69277.616,91329.589,41955.668,83092.984,43889.259
y2035,SAU,1581763.574,1544427.146,1584948.289,1776250.574,1889605.717,1581763.574,4408845.918,2136922.866,2794656.603,1621855.465
y2035,SDN,384829.174,327542.317,292282.602,270979.317,442641.888,384829.174,330256.227,187499.902,356877.971,133081.262
y2035,SEN,93579.496,79449.354,70480.068,66176.496,104321.068,93579.496,167601.659,76766.338,152448.423,80323.648
y2035,SGP,518782.97,519280.97,466236.256,499251.113,570039.97,518782.97,1219620.24,514259.62,819886.033,921711.846
y2035,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2035,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2035,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2035,SLB,5715.049,4795.477,4195.763,3962.763,6491.049,5715.049,10789.585,4253.885,1863.708,8029.238
y2035,SLE,28136.269,22632.269,18365.269,17623.269,33400.698,28136.269,67162.297,29737.435,60919.045,31203.075
y2035,SLV,76420.155,68829.583,69785.583,59089.869,75238.298,76420.155,251236.034,102792.173,171712.63,116975.408
y2035,SMR,2234.677,2234.677,2234.677,2234.677,2234.677,2234.677,2234.677,2234.677,2234.677,2234.677
y2035,SOM,6250.613,5156.613,4752.756,4570.042,6938.042,6250.613,105414.723,46311.594,95555.082,48626.201
y2035,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2035,SRB,145500.831,134138.116,121358.831,129110.259,161464.688,145500.831,619000.761,263824.424,403719.77,354954.27
y2035,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2035,STP,3014.439,2495.296,2437.153,2066.439,3199.724,3014.439,2495.296,2495.296,2495.296,2495.296
y2035,SUR,12650.944,11454.801,10789.515,11139.658,13854.944,12650.944,33438.637,13642.534,22833.594,15533.975
y2035,SVK,228041.207,218563.493,195398.779,222390.207,253085.207,228041.207,414760.605,193565.345,280688.793,250318.815
y2035,SVN,86983.481,83354.624,73747.624,84879.767,98510.339,86983.481,205204.043,93931.9,137759.299,122481.699
y2035,SWE,592580.341,567779.626,503638.341,577766.055,674024.483,592580.341,557635.97,476947.622,536379.155,444111.321
y2035,SWZ,12287.662,10308.948,8493.377,8009.948,13703.805,12287.662,50986.383,22938.826,46307.462,24037.229
y2035,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2035,SYC,1755.477,1755.477,1755.477,1755.477,1755.477,1755.477,1755.477,1755.477,1755.477,1755.477
y2035,SYR,396114.95,358707.236,328163.093,311697.236,443406.664,396114.95,520330.754,253274.518,330588.71,192730.23
y2035,TCA,1638.492,1638.492,1638.492,1638.492,1638.492,1638.492,1638.492,1638.492,1638.492,1638.492
y2035,TCD,67341.68,52922.966,45922.109,44259.823,75617.537,67341.68,89194.138,42247.124,81362.392,44085.672
y2035,TGO,26039.013,19731.299,16743.585,15901.013,30751.442,26039.013,61165.458,27074.703,55478.405,28409.772
y2035,THA,1760839.703,1550869.989,1321724.703,1472125.274,2007907.132,1760839.703,3755351.61,1483685.059,2467977.745,2795915.381
y2035,TJK,63385.545,50111.116,48465.83,39647.687,67629.83,63385.545,91228.294,39400.825,48892.061,45234.916
y2035,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2035,TKM,182955.728,194358.3,183385.443,182389.728,198519.157,182955.728,115132.363,56108.81,66917.875,62752.946
y2035,TLS,11203.758,8925.044,8639.901,6918.329,11886.329,11203.758,8925.044,8925.044,8925.044,8925.044
y2035,TON,981.691,865.977,891.977,755.548,964.263,981.691,865.977,865.977,865.977,865.977
y2035,TTO,59395.664,55937.664,53721.807,57091.236,62640.521,59395.664,157873.88,68877.427,110197.265,77380.693
y2035,TUN,295399.931,273325.502,254028.36,267584.788,325984.788,295399.931,473656.28,261564.228,513208.014,180714.843
y2035,TUR,2357292.239,2214366.954,2040498.382,2108712.382,2560461.954,2357292.239,1166663.639,1015417.669,3672421.739,953867.786
y2035,TUV,41.361,41.361,41.361,41.361,41.361,41.361,41.361,41.361,41.361,41.361
y2035,TWN,1273241.027,1263037.027,1082531.027,1284480.027,1475588.027,1273241.027,1263037.027,1263037.027,1263037.027,1263037.027
y2035,TZA,345420.607,298612.321,258798.893,241674.75,398404.75,345420.607,358054.729,171630.198,326955.208,178930.99
y2035,UGA,244647.193,208653.336,179910.764,167666.193,282399.336,244647.193,176314.481,86868.143,161392.956,90371.057
y2035,UKR,773644.94,650192.797,557670.94,644704.797,906210.226,773644.94,2462998.707,1025105.24,1288428.658,1186965.383
y2035,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2035,URY,103349.529,92329.243,86340.243,89302.1,110795.957,103349.529,265712.805,109499.575,182027.244,124425.144
y2035,USA,24460310.09,22728219.947,20568174.376,23875434.518,27787007.661,24460310.09,22917635.421,19808596.594,21003580.55,19209013.871
y2035,UZB,349197.353,310432.211,281551.925,310077.496,364999.068,349197.353,270125.626,128860.004,154730.173,144761.929
y2035,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2035,VCT,1993.129,1714.557,1669.986,1681.843,2089.986,1993.129,1714.557,1714.557,1714.557,1714.557
y2035,VEN,684033.495,671712.209,703066.209,654905.78,803502.638,684033.495,2149235.973,855869.206,1456361.734,979445.387
y2035,VGB,2146.598,2146.598,2146.598,2146.598,2146.598,2146.598,2146.598,2146.598,2146.598,2146.598
y2035,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2035,VNM,1136942.823,971805.251,878213.108,955858.251,1296138.68,1136942.823,2273138.779,556047.512,808313.591,1609873.474
y2035,VUT,3497.401,2982.258,2675.115,2572.687,3989.401,3497.401,9306.191,3627.914,1551.306,6907.976
y2035,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2035,WSM,1619.519,1452.519,1517.947,1284.233,1607.376,1619.519,9025.338,3453.227,1415.445,6671.962
y2035,YEM,180758.165,174096.451,161144.737,153887.165,193576.023,180758.165,294336.225,146720.867,189456.294,113255.007
y2035,ZAF,1318869.116,1190059.259,1030459.259,1129572.116,1461589.402,1318869.116,4427305.349,1991209.398,4020913.469,2086612.235
y2035,ZMB,115323.391,96394.106,86932.106,80439.249,133144.249,115323.391,175531.875,79985.519,159592.74,83727.323
y2035,ZWE,20208.461,16358.175,14430.175,12377.603,21456.603,20208.461,103657.602,45007.411,93873.52,47304.28
y2040,ABW,2073.826,1862.826,1689.683,2085.826,2437.969,2073.826,1862.826,1862.826,1862.826,1862.826
y2040,AFG,226602.431,177266.574,164049.717,151094.431,257156.146,226602.431,167873.301,64523.678,203116.757,110979.685
y2040,AGO,316467.198,256719.769,237218.198,268944.34,413614.34,316467.198,936570.613,349644.66,789138.365,423329.232
y2040,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2040,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2040,ALB,54769.022,47487.594,43843.022,46536.165,61354.165,54769.022,91626.483,37530.005,58575.635,53651.102
y2040,AND,3391.45,3391.45,3391.45,3391.45,3391.45,3391.45,3391.45,3391.45,3391.45,3391.45
y2040,ARE,1066079.2,1008340.343,886381.2,1103962.628,1415071.914,1066079.2,1579709.154,729229.588,994951.219,604691.618
y2040,ARG,1673348.885,1536853.742,1356794.028,1432487.456,1894318.742,1673348.885,3614292.445,1435801.01,2514646.781,1741954.229
y2040,ARM,45338.589,36820.018,34129.16,36818.732,50008.018,45338.589,83783.107,33571.67,44721.751,42183.025
y2040,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2040,ATA,10,10,10,10,10,10,10,10,10,10
y2040,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2040,ATG,1062.563,1062.563,1062.563,1062.563,1062.563,1062.563,1062.563,1062.563,1062.563,1062.563
y2040,AUS,1961669.199,1782709.199,1470504.199,1913135.056,2444940.199,1961669.199,1086190.916,909816.167,1146285.817,846951.093
y2040,AUT,514519.479,488988.05,416982.05,499813.764,606125.479,514519.479,561488.707,462619.653,524613.883,417323.993
y2040,AZE,158144.577,142120.434,135000.72,146004.291,186398.434,158144.577,296251.437,127299.689,164817.55,156275.228
y2040,BDI,46866.205,30909.205,20382.776,19233.633,64521.633,46866.205,66230.81,23262.507,55437.432,28656.886
y2040,BEL,639115.124,619339.553,523516.838,611706.41,742365.838,639115.124,690990.053,568597.05,645341.588,512524.177
y2040,BEN,82280.048,57392.048,44539.334,41568.334,102819.762,82280.048,139921.454,50390.736,117431.879,61630.71
y2040,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2040,BFA,155243.198,120780.626,94513.055,85816.912,185515.769,155243.198,164028.409,59944.155,137883.074,73011.227
y2040,BGD,1587058.174,1175113.603,961248.603,808119.317,1917654.746,1587058.174,1646451.85,601166.101,2002906.775,1071025.595
y2040,BGR,243589.668,209245.239,174292.954,201906.954,284026.096,243589.668,541570.977,213956.39,341411.179,311587.633
y2040,BHR,107406.172,104968.172,78192.029,98422.172,130809.458,107406.172,182441.702,82017.147,113393.535,67311.714
y2040,BHS,19347.74,18140.597,16188.455,18431.883,22520.74,19347.74,91825.534,35473.847,63380.672,43393.204
y2040,BIH,80478.615,70339.758,62253.33,69123.472,91809.472,80478.615,67761.113,30249.713,44843.103,41428.35
y2040,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2040,BLR,331838.725,288674.011,251125.725,279552.296,377482.725,331838.725,531000.525,219243.265,288472.887,272710.215
y2040,BLZ,6086.012,5182.441,4749.584,4158.012,6544.441,6086.012,14354.808,5707.997,9990.123,6923.173
y2040,BMU,3984.44,3984.44,3984.44,3984.44,3984.44,3984.44,3984.44,3984.44,3984.44,3984.44
y2040,BOL,202051.881,174800.738,152086.452,171637.023,224977.309,202051.881,303061.225,119243.255,210274.707,145076.023
y2040,BRA,5600744.258,4721809.115,4089666.115,4578557.115,6446755.401,5600744.258,15859036.814,6216560.594,10991766.283,7571661.231
y2040,BRB,8834.976,8071.976,7166.119,8423.976,10022.976,8834.976,72269.55,27514.478,49678.357,33804.11
y2040,BRN,38714.751,39304.179,33181.608,35742.608,43780.894,38714.751,272531.448,93749.595,170120.789,187651.871
y2040,BTN,37247.156,33441.87,25970.87,29746.585,45310.585,37247.156,19905.841,7527.142,24127.125,13091.409
y2040,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2040,BWA,79517.048,71020.048,56856.334,64652.906,92366.334,79517.048,247466.014,90110.313,207939.214,109865.254
y2040,CAF,21560.132,15290.703,10878.56,9718.275,27787.132,21560.132,61278.334,21453.615,51274.605,26453.338
y2040,CAN,2241999.011,2250110.868,2012746.725,2268716.583,3022156.44,2241999.011,2114810.615,1747703.492,2070313.669,1927790.652
y2040,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2040,CHE,535376.525,497929.953,420520.81,521316.382,642175.953,535376.525,617299.852,506719.285,576057.028,456058.136
y2040,CHL,717178.481,649197.766,560590.195,616457.766,813894.909,717178.481,1262816.739,510369.144,883000.816,616113.995
y2040,CHN,56398197.064,43747345.921,36377586.921,44007618.064,67480306.635,56398197.064,62303460.85,15035219.292,22470746.479,43094610.409
y2040,CIV,331429.957,267461.957,210847.386,185680.1,376217.386,331429.957,566270.629,198994.383,474013.058,245103.425
y2040,CMR,243164.932,195254.789,157284.218,145482.361,290143.789,243164.932,623709.794,220383.671,522396.712,271018.529
y2040,COD,397416.577,262774.719,195618.862,169420.862,521208.719,397416.577,557252.692,193715.099,465934.248,239354.778
y2040,COG,103216.561,84396.418,69551.99,67422.99,123190.847,103216.561,205475.42,73114.192,172227.08,89731.246
y2040,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2040,COL,1296777.483,1115333.055,969304.483,1057815.055,1496488.198,1296777.483,2837110.804,1117521.896,1969107.168,1359183.475
y2040,COM,4591.53,3535.244,2693.816,2405.387,5487.101,4591.53,12974.639,4558.986,10860.678,5615.514
y2040,CPV,6888.174,5625.603,5409.746,5403.46,7252.46,6888.174,14092.908,5199.545,11858.949,6316.047
y2040,CRI,161575.074,141826.502,120371.931,133358.931,192743.074,161575.074,310716.211,123594.567,216262.085,149891.615
y2040,CUB,169584.559,135942.13,114264.845,128784.273,197620.702,169584.559,1177382.047,450325.916,810383.073,552502.391
y2040,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2040,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2040,CYM,3934.903,3934.903,3934.903,3934.903,3934.903,3934.903,3934.903,3934.903,3934.903,3934.903
y2040,CYP,39604.317,36113.602,30994.031,38461.031,47891.459,39604.317,37714.727,31408.163,149770.529,28518.888
y2040,CZE,625599.456,580772.313,483130.599,603499.456,743037.885,625599.456,1352626.919,540709.645,856576.975,782666.187
y2040,DEU,4182652.803,3907807.089,3365088.517,4057026.803,4890425.089,4182652.803,5494899.353,4506200.909,5126148.16,4053240.68
y2040,DJI,11695.311,10267.454,8510.311,8340.026,13396.311,11695.311,47031.599,16390.858,39334.83,20237.595
y2040,DMA,441.972,441.972,441.972,441.972,441.972,441.972,441.972,441.972,441.972,441.972
y2040,DNK,304994.154,287093.868,246464.296,295247.296,358458.439,304994.154,361900.718,297519.736,337888.782,268024.368
y2040,DOM,266858.883,242486.598,218212.883,224933.741,290289.883,266858.883,444642.696,181901.361,312017.722,218825.585
y2040,DZA,755976.386,669576.672,608092.815,647288.672,863720.958,755976.386,2692004.39,1311020.791,3098975.278,939306.381
y2040,ECU,338428.169,295518.026,259229.455,276382.455,385742.312,338428.169,785004.977,307068.554,543755.135,374235.114
y2040,EGY,2233965.41,1939812.267,1646600.553,1783066.124,2541078.838,2233965.41,3448047.999,1712158.252,3959608.45,1244915.025
y2040,ERI,13802.299,8762.157,5911.299,5319.299,18350.585,13802.299,8762.157,8762.157,8762.157,8762.157
y2040,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2040,ESP,1935462.793,1798877.793,1506081.508,1823628.793,2291975.365,1935462.793,2138102.773,1765594.357,1999169.691,1594934.133
y2040,EST,55702.993,53293.279,45813.565,53785.85,63580.993,55702.993,123604.839,49430.929,65902.179,62151.893
y2040,ETH,680509.86,497825.146,379893.003,338828.574,845284.003,680509.86,642710.148,238346.894,541136.545,289111.958
y2040,FIN,306440.355,285911.64,247475.783,296341.355,358527.497,306440.355,320439.671,263587.624,299235.774,237541.546
y2040,FJI,9622.009,8305.866,7383.152,6140.866,10328.866,9622.009,52569.139,18237.711,6410.119,36269.738
y2040,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2040,FRA,3497798.072,3245844.501,2832529.501,3371104.072,4065215.215,3497798.072,3950161.467,3242766.341,3686326.93,2918681.823
y2040,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2040,FSM,255.386,255.386,255.386,255.386,255.386,255.386,255.386,255.386,255.386,255.386
y2040,GAB,60454.411,52017.554,42669.697,43852.839,68005.839,60454.411,335802.491,118855.887,281306.816,146092.061
y2040,GBR,3910992.907,3588299.049,3065549.049,3723212.335,4616067.764,3910992.907,3764972.068,3104154.873,3518509.529,2801409.471
y2040,GEO,77713.94,60066.655,53952.655,60771.226,86519.083,77713.94,214618.488,81461.198,111030.449,104297.921
y2040,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2040,GHA,319258.437,248421.865,194077.294,176246.723,382222.865,319258.437,345390.47,125914.812,290259.513,153468.492
y2040,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2040,GIN,186042.241,123461.527,83358.241,69597.955,212199.955,186042.241,131143.268,46857.771,109971.261,57439.243
y2040,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2040,GMB,20018.381,16503.809,13633.952,12339.666,23365.381,20018.381,27766.907,10064.099,23320.069,12286.567
y2040,GNB,11775.257,8651.114,6331.257,5737.829,14549.829,11775.257,25077.297,8835.881,20997.552,10874.881
y2040,GNQ,57008.74,52097.883,45654.169,52294.883,66450.312,57008.74,18823.098,11115.575,16887.015,12083.202
y2040,GRC,484430.247,433068.104,363471.961,455823.533,566822.533,484430.247,496134.208,408563.829,463473.408,368444.519
y2040,GRD,796.403,796.403,796.403,796.403,796.403,796.403,796.403,796.403,796.403,796.403
y2040,GRL,2413.656,2413.656,2413.656,2413.656,2413.656,2413.656,2413.656,2413.656,2413.656,2413.656
y2040,GTM,261880.082,216134.082,185203.796,166962.796,297048.796,261880.082,530954.263,208732.479,368305.109,254015.759
y2040,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2040,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2040,GUY,8651.025,6902.168,6640.025,6612.74,9010.883,8651.025,22723.674,8931.578,15761.783,10869.843
y2040,HKG,654469.924,649419.21,530524.638,626773.067,800808.924,654469.924,2766436.725,1209803.294,1965481.27,4061499.397
y2040,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2040,HND,113227.455,94177.027,82510.884,74439.027,129194.598,113227.455,217277.994,85898.567,150961.086,104361.91
y2040,HRV,121034.038,110247.466,97287.038,114910.752,137909.181,121034.038,481332.773,187839.376,302019.698,275302.286
y2040,HTI,75134.052,55282.766,44377.909,37948.766,85958.624,75134.052,159662.085,60956.224,109837.941,74827.804
y2040,HUN,309887.489,292948.347,247966.775,294942.204,356880.632,309887.489,1014471.523,402112.947,640344.199,584599.72
y2040,IDN,6073207.404,4619055.689,3787934.689,4502691.404,7236087.689,6073207.404,8334823.349,3020538.01,5290669.523,5811780.394
y2040,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2040,IND,23945389.904,19245928.904,15369436.761,17709685.904,28314726.618,23945389.904,24073302.901,9075055.825,29187884.288,15816818.815
y2040,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2040,IRL,311147.058,305627.058,260686.058,301818.058,365311.201,311147.058,193025.446,163006.938,181829.554,149254.322
y2040,IRN,1864116.278,1808183.278,1740497.992,1810240.85,2302546.278,1864116.278,6574314.04,2864381.444,4023503.169,2321126.209
y2040,IRQ,614386.407,583351.835,720683.121,777809.835,867312.835,614386.407,1947463.515,837222.966,1184103.646,674647.508
y2040,ISL,25700.073,24332.501,19984.501,24165.93,30922.93,25700.073,18977.681,15693.905,17752.943,14189.483
y2040,ISR,628501.198,587027.341,490260.198,588254.913,750584.77,628501.198,1609057.244,704757.054,987294.261,572337.987
y2040,ITA,2497149.195,2300057.338,1961266.338,2372976.195,2923284.623,2497149.195,3601606.724,2938555.49,3354310.964,2634786.589
y2040,JAM,38135.108,32814.394,31809.108,31971.251,39772.108,38135.108,252526.99,96260.071,173647.525,118220.966
y2040,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2040,JOR,191293.793,172527.65,142075.365,170305.508,230158.65,191293.793,236765.739,106579.157,147254.315,87515.591
y2040,JPN,5829873.76,5127403.331,4510898.188,5656320.902,6776539.045,5829873.76,7572165.267,6182903.007,7883544.008,5687729.661
y2040,KAZ,745950.607,673729.036,702936.465,747550.75,930206.179,745950.607,932942.026,382441.34,504686.942,476853.231
y2040,KEN,405254.132,308218.275,253087.989,228567.561,484769.418,405254.132,822571.766,294626.229,689955.041,360906.21
y2040,KGZ,55812.704,47914.847,43911.133,37034.418,61038.561,55812.704,87484.52,34315.191,46122.109,43433.83
y2040,KHM,181568.418,139852.989,119814.561,97768.846,209710.704,181568.418,300557.455,53914.556,102056.638,204832.808
y2040,KIR,248.858,248.858,248.858,248.858,248.858,248.858,248.858,248.858,248.858,248.858
y2040,KNA,467.02,467.02,467.02,467.02,467.02,467.02,467.02,467.02,467.02,467.02
y2040,KOR,3263420.371,3053292.514,2681416.657,3167479.228,3663702.942,3263420.371,10151670.876,3679092.533,6444018.224,7078709.575
y2040,KWT,416618.325,402782.754,412381.183,467869.183,550873.754,416618.325,972353.246,433642.808,601956.101,354758.015
y2040,LAO,105851.006,82043.434,71107.434,62531.006,124476.006,105851.006,194463.814,41273.125,65370.775,132210.239
y2040,LBN,162991.918,151971.918,134520.061,141990.776,178219.633,162991.918,355528.708,161950.73,222431.731,133604.595
y2040,LBR,35671.056,23628.628,15090.485,15359.628,48605.485,35671.056,26281.646,9323.167,22021.779,11452.189
y2040,LBY,322085.608,310205.894,307722.18,311810.751,373579.322,322085.608,1151452.867,560951.121,1325471.602,402007.881
y2040,LCA,3829.325,3257.325,2900.04,3181.468,4447.897,3829.325,3257.325,3257.325,3257.325,3257.325
y2040,LIE,5547.23,5547.23,5547.23,5547.23,5547.23,5547.23,5547.23,5547.23,5547.23,5547.23
y2040,LKA,491219.572,420502.001,348012.572,386444.429,554205.715,491219.572,736406.122,267899.787,896172.378,478494.975
y2040,LSO,16846.486,12317.771,9381.914,8423.343,20432.2,16846.486,36415.301,12899.468,30508.266,15851.721
y2040,LTU,103564.121,95725.978,86391.263,90478.121,110836.549,103564.121,362569.374,140583.393,189878.172,178654.402
y2040,LUX,67421.406,66108.834,54438.406,63752.548,80285.12,67421.406,51004.115,42970.826,48007.969,39290.472
y2040,LVA,70182.567,60410.424,53112.996,60093.424,81582.71,70182.567,219048.826,84907.186,114695.024,107912.727
y2040,MAC,56138.036,55818.036,47285.607,51995.607,65245.179,56138.036,156405.679,72723.944,113347.795,110904.954
y2040,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2040,MAR,684653.521,579171.664,487575.95,516405.235,752338.95,684653.521,1233282.599,604717.338,1418518.516,435528.677
y2040,MCO,7848.663,7848.663,7848.663,7848.663,7848.663,7848.663,7848.663,7848.663,7848.663,7848.663
y2040,MDA,42392.04,32661.469,29441.755,32322.755,44689.04,42392.04,115728.822,43829.681,71801.237,56160.517
y2040,MDG,123864.742,93727.028,75948.028,68934.885,156989.028,123864.742,292707.783,103289.981,245127.177,127070.101
y2040,MDV,7749.054,6744.625,6031.482,6539.768,9035.054,7749.054,10256.274,3840.813,12444.023,6724.585
y2040,MEX,3848214.601,3526559.744,3289524.886,3403859.744,4252665.601,3848214.601,12293341.248,4813851.873,8517890.068,5864978.222
y2040,MHL,229.146,229.146,229.146,229.146,229.146,229.146,229.146,229.146,229.146,229.146
y2040,MKD,58781.327,52988.041,44593.756,50814.756,69468.47,58781.327,123543.386,48425.1,77649.028,70810.83
y2040,MLI,114316.895,81014.609,64805.324,59976.038,136957.609,114316.895,156318.533,57028.681,131377.523,69493.848
y2040,MLT,19680.334,18609.192,16681.049,19165.334,22894.049,19680.334,14050.872,11698.788,13173.624,10621.21
y2040,MMR,340794.95,237832.807,199497.379,163157.236,417694.664,340794.95,257537.899,98140.905,166231.366,181861.597
y2040,MNE,13882.068,12592.354,10939.354,12045.497,15972.497,13882.068,46184.084,17792.96,28838.209,26253.697
y2040,MNG,105374.627,84767.342,70140.627,81957.056,124456.77,105374.627,238084.677,48722.933,78510.468,161131.922
y2040,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2040,MOZ,192150.146,134772.146,101146.289,91965.289,238986.575,192150.146,136821.248,52104.775,115540.982,62740.353
y2040,MRT,40132.387,35462.53,29640.959,29325.673,46778.245,40132.387,77789.837,28001.891,65283.406,34252.43
y2040,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2040,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2040,MUS,50508.342,42854.628,37485.485,40482.056,58677.485,50508.342,155112.241,55748.837,130152.755,68223.238
y2040,MWI,114257.44,80719.44,65413.869,59027.583,142509.869,114257.44,141993.953,51209.577,119189.467,62606.939
y2040,MYS,1394662.837,1269696.266,1129399.266,1210117.409,1568721.266,1394662.837,2471474.729,907903.568,1575822.571,1729144.02
y2040,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2040,NAM,51307.678,44996.393,38590.821,42645.25,58472.25,51307.678,149782.048,53867.634,125688.927,65909.038
y2040,NCL,15094.976,13549.69,11822.261,14142.69,18324.547,15094.976,179181.048,61876.617,21463.825,123488.872
y2040,NER,99436.894,71924.466,57880.752,52937.466,122282.609,99436.894,132416.09,47549.491,111098.114,58203.917
y2040,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2040,NGA,2634042.704,2116417.275,1755260.704,1624088.989,3191646.418,2634042.704,3295753.357,1204322.708,2770398.631,1466887.639
y2040,NIC,67004.084,55823.084,50158.512,40870.369,71237.226,67004.084,126998.77,49260.802,87758.671,60185.669
y2040,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2040,NLD,1031394.209,992787.78,848715.209,978401.78,1181991.638,1031394.209,1120690.293,925123.662,1047750.532,835527.177
y2040,NOR,428104.95,392606.522,341258.664,424709.807,528266.093,428104.95,387976.278,321646.575,363237.535,291258.425
y2040,NPL,197032.683,142338.397,111610.255,101132.54,247162.826,197032.683,297263.04,105917.98,362513.991,191928.234
y2040,NRU,102.523,102.523,102.523,102.523,102.523,102.523,102.523,102.523,102.523,102.523
y2040,NZL,231630.383,209789.812,179182.241,223850.669,275920.669,231630.383,158610.689,131998.597,167678.036,122513.276
y2040,OMN,224779.861,198563.576,167906.147,203070.433,239638.147,224779.861,535691.698,238195.435,331144.396,194632.271
y2040,PAK,1865914.22,1578129.791,1302276.648,1211958.22,2161326.363,1865914.22,3964289.65,1417849.834,4832656.041,2562483.178
y2040,PAN,194771.543,181202.543,162136.543,170602.686,221862.4,194771.543,215988.528,88864.976,151819.874,106730.222
y2040,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2040,PER,1019549.872,877356.729,812002.872,847316.872,1108933.015,1019549.872,1429203.657,576695.572,998879.808,696502.375
y2040,PHL,1465039.425,1209435.14,1033729.854,939208.711,1741167.711,1465039.425,2957950.081,1052163.647,1866268.567,2053147.134
y2040,PLW,212.309,212.309,212.309,212.309,212.309,212.309,212.309,212.309,212.309,212.309
y2040,PNG,100270.703,81902.275,68929.56,63762.56,121511.703,100270.703,153179.089,55108.553,21322.07,106618.516
y2040,POL,1457216.354,1339891.354,1168125.068,1409869.211,1660825.496,1457216.354,2530463.886,1058675.895,1631258.544,1497278.133
y2040,PRI,119032.854,112540.283,109035.997,109996.283,120673.997,119032.854,193672.272,161629.556,630615.705,155341.771
y2040,PRK,21929.079,21929.079,21929.079,21929.079,21929.079,21929.079,2006578.468,384637.986,639777.211,1347454.898
y2040,PRT,385820.592,353890.592,293391.021,365623.449,457716.878,385820.592,418019.549,342696.597,389926.627,308188.299
y2040,PRY,143725.395,120327.537,103218.537,119487.395,168815.68,143725.395,248252.301,96115.259,171457.49,117495.763
y2040,PSE,78071.695,62761.266,53062.266,43036.837,93831.98,78071.695,62761.266,62761.266,62761.266,62761.266
y2040,PYF,9032.343,8193.343,7347.486,8377.2,10450.2,9032.343,97337.938,33891.094,12032.891,67215.522
y2040,QAT,403844.708,425538.136,399235.422,511799.708,681241.708,403844.708,500513.381,253268.151,330516.81,217063.379
y2040,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2040,ROU,568167.768,468188.483,404946.34,462966.34,655117.626,568167.768,1389275.954,547560.042,875020.2,798396.77
y2040,RUS,5728153.182,4965840.182,4457727.61,5138561.039,7062530.61,5728153.182,15220196.414,5952975.43,8010878.428,7542321.07
y2040,RWA,100536.744,76932.887,58410.458,53035.887,123188.744,100536.744,139221.157,50054.214,116822.96,61248.519
y2040,SAU,1811148.05,1756536.764,1823577.192,2128270.05,2331050.478,1811148.05,5880555.234,2557938.468,3596048.239,2071398.914
y2040,SDN,542444.116,428734.544,357839.401,315707.544,655705.259,542444.116,428264.671,215927.261,490839.741,158773.161
y2040,SEN,131134.331,103889.902,85209.045,77579.331,152409.045,131134.331,255850.269,91806.016,214643.345,112400.659
y2040,SGP,547068.647,549555.647,476041.504,519716.075,622130.647,547068.647,1553205.178,577128.433,994084.324,1089796.949
y2040,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2040,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2040,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2040,SLB,7715.032,6063.318,4995.175,4616.175,9169.032,7715.032,14050.876,5006.785,1890.987,9757.048
y2040,SLE,41826.513,30695.513,22464.513,20913.513,52627.798,41826.513,104151.711,36564.198,87174.137,45049.352
y2040,SLV,89280.77,76777.056,76046.056,60619.913,87879.198,89280.77,306644.367,120036.215,212449.438,146261.099
y2040,SMR,1984.089,1984.089,1984.089,1984.089,1984.089,1984.089,1984.089,1984.089,1984.089,1984.089
y2040,SOM,6815.742,4539.742,3778.171,3454.028,8306.028,6815.742,164047.236,57309.806,137235.439,70709.966
y2040,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2040,SRB,159956.22,141927.078,122377.22,135522.506,185695.792,159956.22,799527.562,308410.964,499474.381,454766.853
y2040,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2040,STP,3979.959,3130.531,2987.102,2407.959,4208.816,3979.959,3130.531,3130.531,3130.531,3130.531
y2040,SUR,15109.963,13233.534,12051.677,12727.105,17051.963,15109.963,40849.612,15964.014,28288.011,19461.299
y2040,SVK,252021.805,240292.662,205153.519,243554.805,289502.805,252021.805,517434.392,211578.816,330568.505,302725.734
y2040,SVN,95130.654,90763.083,76411.083,92026.511,112554.226,95130.654,258001.041,104140.576,163998.268,149991.979
y2040,SWE,654792.56,620075.418,523885.56,632938.703,780064.989,654792.56,605865.849,500598.438,566604.653,452371.447
y2040,SWZ,15701.775,12291.632,9344.918,8637.632,18348.203,15701.775,78490.099,27837.549,65766.485,34196.633
y2040,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2040,SYC,1562.123,1562.123,1562.123,1562.123,1562.123,1562.123,1562.123,1562.123,1562.123,1562.123
y2040,SYR,522708.967,454074.824,397305.395,369245.824,608744.109,522708.967,692629.109,302067.674,424093.677,244876.731
y2040,TCA,1422.283,1422.283,1422.283,1422.283,1422.283,1422.283,1422.283,1422.283,1422.283,1422.283
y2040,TCD,99462.454,71889.311,57569.739,54395.882,116765.025,99462.454,133947.086,49163.021,112649.842,59807.085
y2040,TGO,38440.676,25790.533,20064.39,18438.676,47983.961,38440.676,94864.053,33297.778,79398.977,41027.006
y2040,THA,2148889.469,1822697.326,1451941.469,1693081.183,2541350.754,2148889.469,4887195.63,1743667.582,3086505.165,3394754.824
y2040,TJK,85666.363,63240.077,59121.22,45147.792,90644.22,85666.363,117269.681,45605.756,61519.632,57896.253
y2040,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2040,TKM,218125.486,230518.2,219064.628,216026.486,241250.771,218125.486,141043.749,59429.509,77552.978,73426.503
y2040,TLS,16459.505,11908.362,10920.934,8038.22,17524.22,16459.505,11908.362,11908.362,11908.362,11908.362
y2040,TON,1141.794,944.651,968.651,766.366,1110.508,1141.794,944.651,944.651,944.651,944.651
y2040,TTO,62400.443,57695.443,54137.871,58906.157,67225.014,62400.443,188675.968,76798.903,132203.343,92521.491
y2040,TUN,359630.621,326612.335,293872.906,317223.192,408151.192,359630.621,624934.403,309466.231,717901.737,224552.792
y2040,TUR,2768974.493,2547288.636,2255230.921,2376932.921,3100673.636,2768974.493,1216599.626,1019281.523,4722572.077,928882.621
y2040,TUV,36.734,36.734,36.734,36.734,36.734,36.734,36.734,36.734,36.734,36.734
y2040,TWN,1412004.018,1406517.018,1151253.018,1423024.018,1705335.018,1412004.018,1406517.018,1406517.018,1406517.018,1406517.018
y2040,TZA,500524.405,400835.547,323726.262,292611.833,605640.833,500524.405,534477.148,197803.347,449906.726,240070.459
y2040,UGA,367433.795,290557.224,231852.509,209205.795,445765.224,367433.795,259455.11,97919.294,218878.29,118199.02
y2040,UKR,937381.627,750539.198,605233.627,743536.198,1144869.484,937381.627,3208162.099,1219929.007,1661441.176,1560914.681
y2040,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2040,URY,118655.019,102398.162,92414.162,97501.734,129657.305,118655.019,323578.68,127203.687,224453.705,154801.15
y2040,USA,26799284.727,24346718.298,21380774.584,25934899.012,31734613.441,26799284.727,25320594.16,21215679.225,22686658.375,20410166.199
y2040,UZB,446015.236,380326.807,329258.95,384508.664,473458.378,446015.236,333951.188,138617.536,181993.831,172117.621
y2040,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2040,VCT,2299.752,1897.038,1797.324,1838.895,2427.324,2299.752,1897.038,1897.038,1897.038,1897.038
y2040,VEN,803544.33,784958.473,853355.473,753356.187,1015730.758,803544.33,2645246.92,1019361.008,1824542.113,1247854.083
y2040,VGB,1814.909,1814.909,1814.909,1814.909,1814.909,1814.909,1814.909,1814.909,1814.909,1814.909
y2040,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2040,VNM,1438710.215,1167277.501,1004497.072,1141168.501,1698642.787,1438710.215,2886668.445,624150.285,980055.534,1967227.156
y2040,VUT,4701.601,3725.172,3146.744,2959.458,5645.601,4701.601,12162.264,4304.674,1597.64,8431.746
y2040,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2040,WSM,1840.679,1560.679,1628.965,1286.822,1815.251,1840.679,11863.631,4152.953,1496.532,8202.862
y2040,YEM,242521.777,227265.634,199835.491,187933.777,268498.348,242521.777,387333.036,171450.17,238900.053,139837.871
y2040,ZAF,1571043.077,1368014.506,1122272.506,1275675.077,1811431.934,1571043.077,6816553.118,2417080.138,5711432.122,2969404.126
y2040,ZMB,169124.261,130949.404,110560.404,99054.832,204011.832,169124.261,268611.428,96059.27,225267.369,117722.022
y2040,ZWE,29999.64,22315.783,18308.783,14959.069,32231.069,29999.64,162157.207,56237.762,135550.883,69535.23
y2045,ABW,1810.913,1478.913,1211.342,1832.913,2396.484,1810.913,1478.913,1478.913,1478.913,1478.913
y2045,AFG,324639.716,236227.287,209071.859,187056.716,379930.573,324639.716,201486.282,69472.511,265208.797,138203.337
y2045,AGO,376179.599,281541.885,237759.599,290396.17,516522.17,376179.599,1241722.832,392866.202,1043834.529,560245.846
y2045,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2045,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2045,ALB,62869.511,52910.797,47280.511,51551.083,72418.083,62869.511,109732.232,40661.938,67244.44,62770.615
y2045,AND,3066.826,3066.826,3066.826,3066.826,3066.826,3066.826,3066.826,3066.826,3066.826,3066.826
y2045,ARE,1179234.1,1111235.671,940446.1,1228942.814,1659278.957,1179234.1,1919176.732,799754.465,1189918.242,704108.127
y2045,ARG,1899989.942,1721665.371,1459089.514,1566424.228,2209745.371,1899989.942,4243897.443,1619870.375,2986256.78,2064613.358
y2045,ARM,51737.795,40466.509,36431.08,40443.366,57767.509,51737.795,101220.08,37110.2,53793.553,50433.217
y2045,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2045,ATA,10,10,10,10,10,10,10,10,10,10
y2045,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2045,ATG,930.937,930.937,930.937,930.937,930.937,930.937,930.937,930.937,930.937,930.937
y2045,AUS,2204477.6,1957175.6,1524038.6,2139159.028,2902084.6,2204477.6,1110462.527,897564.748,1162125.646,808131.876
y2045,AUT,554993.239,525632.525,425450.525,534714.382,684755.239,554993.239,610562.801,488608.647,555907.026,426366.334
y2045,AZE,170633.288,147932.717,131814.86,150267.145,210029.717,170633.288,347754.704,132037.392,188173.64,176866.759
y2045,BDI,72553.602,43537.602,25410.888,23118.317,105212.317,72553.602,89738.047,27594.042,75250.829,39847.751
y2045,BEL,697666.062,675023.776,539495.919,659626.205,847428.919,697666.062,753787.294,602816.545,686127.25,525764.896
y2045,BEN,118912.024,75758.024,53624.167,48308.167,156265.881,118912.024,187942.248,58456.164,157756.018,83988.549
y2045,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2045,BFA,223110.599,163878.313,117072.027,102694.456,276196.885,223110.599,219174.041,68639.534,184080.932,98322.3
y2045,BGD,2082971.587,1446141.301,1097985.301,868441.159,2596474.873,2082971.587,2012131.619,676934.54,2656625.861,1372083.221
y2045,BGR,268833.334,228015.62,181004.477,217136.477,323394.048,268833.334,657886.353,239588.591,400575.325,373481.322
y2045,BHR,123143.586,120895.586,84234.015,111729.586,157056.729,123143.586,224571.116,92389.829,138460.335,81095.918
y2045,BHS,21122.87,19548.299,16854.727,19859.442,25597.87,21122.87,108944.937,41068.447,76413.171,52572.746
y2045,BIH,89701.308,77330.879,66176.165,75368.736,105023.736,89701.308,78203.051,30308.557,48741.307,45639.082
y2045,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2045,BLR,362954.362,310029.505,259303.362,297580.648,424991.362,362954.362,633864.522,235813.369,339398.463,318534.506
y2045,BLZ,7272.506,6000.22,5325.792,4506.506,7939.22,7272.506,16849.292,6434.074,11857.498,8199.336
y2045,BMU,3554.491,3554.491,3554.491,3554.491,3554.491,3554.491,3554.491,3554.491,3554.491,3554.491
y2045,BOL,256873.94,215655.369,177991.226,211511.512,292682.655,256873.94,357140.171,135728.546,251022.263,173255.319
y2045,BRA,6419539.129,5170716.557,4232530.557,4968553.557,7647336.7,6419539.129,18715108.526,7100594.832,13148517.814,9069123.866
y2045,BRB,9391.988,8385.988,7095.56,8735.988,11052.988,9391.988,86195.554,32287.368,60358.501,41424.197
y2045,BRN,42696.875,44039.59,35644.304,38570.304,49810.447,42696.875,339611.807,111244.58,208655.354,220255.186
y2045,BTN,46821.078,41871.935,30483.935,35724.792,58971.792,46821.078,24032.425,8220.478,31664.788,16452.712
y2045,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2045,BWA,90798.024,79560.024,59860.167,70249.453,109542.167,90798.024,331092.732,103513.035,278038.591,148387.761
y2045,CAF,31492.566,20251.852,12871.28,10969.137,42740.566,31492.566,83119.265,25521.75,69691.939,36878.97
y2045,CAN,2459351.006,2450309.434,2156920.863,2477258.291,3581584.72,2459351.006,2282042.312,1829218.734,2241569.056,2041055.311
y2045,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2045,CHE,584821.762,540214.477,432257.905,565343.191,736771.477,584821.762,677536.95,541136.742,616406.936,471521.529
y2045,CHL,815902.74,729517.883,601605.597,681102.883,953470.455,815902.74,1473058.498,566723.58,1038671.345,720337.123
y2045,CHN,63425307.032,47813066.46,37812318.46,47878064.032,77500563.318,63425307.032,74123469.103,15460238.288,25311500.882,49513062.116
y2045,CIV,458357.979,356944.979,261450.693,223657.55,528380.693,458357.979,767123.506,235940.868,643292.43,340680.771
y2045,CMR,331186.466,250789.895,187750.609,169446.18,410859.895,331186.466,843348.787,260028.095,707363.113,375048.708
y2045,COD,635757.288,383956.86,258016.431,212486.431,868635.86,635757.288,757687.826,231912.31,635117.275,335586.023
y2045,COG,134807.281,105644.709,82640.995,79225.995,167212.423,134807.281,277160.292,85729.49,232533.302,123476.288
y2045,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2045,COL,1550343.742,1291065.027,1064638.742,1202515.027,1847190.599,1550343.742,3342001.28,1270729.496,2349284.531,1621786.695
y2045,COM,6506.765,4721.622,3319.908,2845.194,8062.051,6506.765,17577.275,5405.921,14739.848,7805.898
y2045,CPV,8341.587,6523.301,6098.873,6149.73,8798.73,8341.587,18765.923,5903.67,15767.432,8439.881
y2045,CRI,188451.537,161794.251,130664.965,148602.965,233877.537,188451.537,364662.988,139272.036,256637.873,177473.259
y2045,CUB,186568.279,142084.565,113194.422,133540.137,224074.851,186568.279,1401939.534,526189.032,982210.845,674618.862
y2045,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2045,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2045,CYM,3412.149,3412.149,3412.149,3412.149,3412.149,3412.149,3412.149,3412.149,3412.149,3412.149
y2045,CYP,43199.658,38461.801,31362.515,41624.515,55136.23,43199.658,39895.504,32116.41,188356.961,28146.158
y2045,CZE,694140.728,642564.157,506890.299,664324.728,860428.442,694140.728,1635653.766,598999.135,997967.666,930821.421
y2045,DEU,4492403.402,4154348.544,3400429.259,4319521.402,5492386.544,4492403.402,6045660.531,4826109.24,5499098.404,4203681.13
y2045,DJI,15382.156,13129.727,10267.156,10054.013,18175.156,15382.156,63893.464,19578.51,53562.613,28316.642
y2045,DMA,394.053,394.053,394.053,394.053,394.053,394.053,394.053,394.053,394.053,394.053
y2045,DNK,332250.077,311216.934,254011.648,318580.648,408701.22,332250.077,395719.64,316306.235,360129.206,275775.643
y2045,DOM,307733.442,274879.299,238388.442,249876.87,342172.442,307733.442,516210.624,199734.568,364530.345,253373.689
y2045,DZA,872676.193,742378.336,631311.907,699398.336,1032264.479,872676.193,3376079.215,1542559.549,4190838.081,1191863.806
y2045,ECU,412301.085,348280.513,290742.228,319051.228,485031.656,412301.085,927098.191,351416.282,651186.031,448987.871
y2045,EGY,2772210.205,2351546.633,1888026.776,2106920.062,3243818.919,2772210.205,4275821.057,1971095.649,5299969.035,1530272.786
y2045,ERI,20803.65,11667.078,7007.65,5989.65,29384.793,20803.65,11667.078,11667.078,11667.078,11667.078
y2045,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2045,ESP,2082976.897,1899645.897,1496682.754,1935872.897,2595301.182,2082976.897,2311706.627,1852220.599,2105780.347,1617710.562
y2045,EST,61643.497,59294.639,48772.782,59168.925,72952.497,61643.497,149444.38,54739.254,79384.427,74420.433
y2045,ETH,992194.93,670319.073,464410.501,396549.787,1286156.501,992194.93,854215.672,269395.002,717880.317,384711.385
y2045,FIN,334337.677,310119.82,256020.392,320213.677,408138.249,334337.677,349873.254,279746.728,318444.889,243955.923
y2045,FJI,11697.505,9706.933,8236.076,6426.933,12715.933,11697.505,65333.06,21479.766,6770.698,42413.042
y2045,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2045,FRA,3858441.036,3516329.75,2923566.75,3680721.036,4695020.608,3858441.036,4334888.515,3462322.523,3943833.602,3016986.927
y2045,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2045,FSM,229.479,229.479,229.479,229.479,229.479,229.479,229.479,229.479,229.479,229.479
y2045,GAB,71169.205,59499.777,46276.348,48827.92,82719.92,71169.205,453788.492,140023.932,380642.646,201892.802
y2045,GBR,4303748.453,3891133.025,3151830.025,4034209.168,5316082.882,4303748.453,4086913.944,3271801.441,3721607.764,2855788.652
y2045,GEO,90406.47,68082.327,59597.327,68678.613,100502.042,90406.47,264644.432,94629.422,138872.532,129961.15
y2045,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2045,GHA,437452.218,322858.933,232102.647,204428.361,542374.933,437452.218,461915.211,144492.942,387916.668,207083.048
y2045,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2045,GIN,258695.121,165443.263,101904.121,81561.978,292877.978,258695.121,176641.125,54741.074,148223.376,78777.627
y2045,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2045,GMB,27527.19,21518.905,16611.476,14544.333,33192.19,27527.19,37211.807,11608.669,31243.118,16657.159
y2045,GNB,17405.129,11909.557,7885.129,6908.414,22336.414,17405.129,33941.213,10451.651,28465.247,15083.381
y2045,GNQ,66218.87,59639.442,50340.585,59813.442,80177.156,66218.87,19568.346,8421.144,16969.673,10619.177
y2045,GRC,527496.124,464058.552,365668.981,486835.266,644573.266,527496.124,540194.169,432176.836,491784.411,377047.524
y2045,GRD,708.63,708.63,708.63,708.63,708.63,708.63,708.63,708.63,708.63,708.63
y2045,GRL,2158.626,2158.626,2158.626,2158.626,2158.626,2158.626,2158.626,2158.626,2158.626,2158.626
y2045,GTM,335315.541,265228.541,215924.398,188638.398,391726.398,335315.541,625898.252,237777.065,439879.977,303559.227
y2045,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2045,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2045,GUY,10332.513,7795.084,7278.513,7433.37,10783.941,10332.513,26788.984,10176.188,18826.822,12991.869
y2045,HKG,702641.962,702753.105,547544.819,668609.533,900678.962,702641.962,3410931.901,1412116.709,2413307.613,4872929.69
y2045,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2045,HND,145829.228,115380.513,95488.942,83364.513,171544.799,145829.228,255593.433,97344.854,179748.237,124166.203
y2045,HRV,129724.519,116435.233,98948.519,121900.376,153096.09,129724.519,587450.541,212718.658,356938.56,332666.408
y2045,HTI,104711.526,71934.383,53060.955,43365.383,122125.812,104711.526,190238.465,71345.71,133255.683,91496.691
y2045,HUN,336327.745,317117.173,254430.888,315877.602,403623.316,336327.745,1230782.706,448924.292,749831.55,699188.978
y2045,IDN,7565081.202,5466459.345,4188736.345,5282817.202,9319969.345,7565081.202,10211868.042,3423658.914,6319191.324,6663995.975
y2045,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2045,IND,30230649.952,23210122.952,17164583.38,20747243.952,36975732.809,30230649.952,29095624.435,9937594.483,38343128.189,19911911.736
y2045,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2045,IRL,337825.029,332442.029,269431.029,325088.029,415486.6,337825.029,196651.818,159624.239,180057.295,140726.3
y2045,IRN,2120548.639,2034879.639,1921790.496,2042892.925,2750604.639,2120548.639,8213447.137,3330341.969,5032300.928,2913116.817
y2045,IRQ,725389.203,666407.918,830785.061,935617.918,1102855.918,725389.203,2447981.466,986655.357,1495986.403,861795.87
y2045,ISL,29028.536,27548.251,21325.251,26770.965,36554.965,29028.536,20443.227,16392.717,18627.924,14325.439
y2045,ISR,735475.099,680154.671,538794.099,675590.956,918575.385,735475.099,2005317.309,815055.001,1229909.388,713355.907
y2045,ITA,2708771.097,2448131.669,1976410.669,2539047.097,3322726.812,2708771.097,4012683.832,3194815.66,3646142.654,2777396.447
y2045,JAM,43588.554,35967.697,33979.554,34858.126,45702.554,43588.554,301055.831,112829.878,210843.113,144732.053
y2045,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2045,JOR,246669.397,217813.825,169897.682,216484.254,310384.825,246669.397,291253.092,119898.288,179622.344,105257.29
y2045,JPN,6145095.38,5225469.666,4375235.094,5908892.951,7451219.523,6145095.38,8255099.105,6578153.558,8496811.004,5873711.937
y2045,KAZ,815478.304,724914.018,753562.732,817448.875,1059992.589,815478.304,1116928.287,414049.923,596960.388,560118.831
y2045,KEN,559694.066,397651.637,304434.495,265358.78,696307.209,559694.066,1107000.371,343445.673,928997.941,494005.272
y2045,KGZ,70099.852,58859.424,52430.566,42203.709,77617.281,70099.852,106565.755,38679.243,56345.392,52787.102
y2045,KHM,233933.709,170365.995,138041.28,105963.423,275492.852,233933.709,364422.437,58431.154,121174.752,241779.882
y2045,KIR,220.331,220.331,220.331,220.331,220.331,220.331,220.331,220.331,220.331,220.331
y2045,KNA,427.257,427.257,427.257,427.257,427.257,427.257,427.257,427.257,427.257,427.257
y2045,KOR,3502379.185,3253768.757,2739308.328,3373264.614,4057790.471,3502379.185,12437731.699,4169975.533,7696613.485,8116571.198
y2045,KWT,463882.163,448041.877,459116.591,539048.591,656961.877,463882.163,1201511.426,492447.406,739584.795,431863.14
y2045,LAO,135214.003,99659.717,81889.717,69398.003,162965.003,135214.003,236498.146,46377.667,78304.425,156738.776
y2045,LBN,180614.459,166427.459,140737.031,152057.888,203532.316,180614.459,434809.8,180017.671,268822.997,158247.572
y2045,LBR,55584.528,33906.814,19279.243,19203.814,79883.243,55584.528,35488.317,10961.684,29770.586,15797.906
y2045,LBY,359869.304,344958.447,331491.59,339223.876,431720.161,359869.304,1443777.31,659773.384,1792164.165,509817.622
y2045,LCA,4495.663,3650.663,3090.52,3532.234,5435.948,4495.663,3650.663,3650.663,3650.663,3650.663
y2045,LIE,4902.721,4902.721,4902.721,4902.721,4902.721,4902.721,4902.721,4902.721,4902.721,4902.721
y2045,LKA,590000.786,490335.5,380643.786,435431.215,681054.358,590000.786,901081.129,302633.966,1189949.159,614205.765
y2045,LSO,23547.743,15971.886,11172.457,9732.171,29666.6,23547.743,49196.274,15185.901,41267.662,21892.15
y2045,LTU,111290.56,102860.989,90689.132,95691.56,120825.275,111290.56,443577.541,160146.208,233903.717,219047.588
y2045,LUX,71178.203,69628.917,54432.203,66347.774,89011.06,71178.203,52300.403,42391.407,47859.522,37334.107
y2045,LVA,77067.784,65074.212,55227.498,64361.212,92288.355,77067.784,268022.681,96750.858,141321.029,132343.77
y2045,MAC,57315.518,57275.518,46603.804,52324.804,69304.089,57315.518,187208.971,79756.361,133578.533,123226.408
y2045,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2045,MAR,846942.26,699365.832,556134.975,598164.118,944578.975,846942.26,1540646.403,706105.885,1911490.14,546484.031
y2045,MCO,6953.698,6953.698,6953.698,6953.698,6953.698,6953.698,6953.698,6953.698,6953.698,6953.698
y2045,MDA,49650.02,37003.734,32392.877,36505.877,51879.02,49650.02,142818.564,51017.859,86348.423,70095.454
y2045,MDG,183381.371,128987.514,96723.514,84540.943,243354.514,183381.371,395964.316,122013.988,332100.097,176032.189
y2045,MDV,9471.027,7982.313,6849.741,7640.884,11442.027,9471.027,12425.069,4230.271,16380.664,8496.759
y2045,MEX,4409667.3,3949939.872,3536321.443,3760213.872,4996654.3,4409667.3,14512852.18,5503690.032,10194951.348,7030641.373
y2045,MHL,206.443,206.443,206.443,206.443,206.443,206.443,206.443,206.443,206.443,206.443
y2045,MKD,67707.663,60652.521,48738.378,57237.378,83056.235,67707.663,150529.504,54618.6,91531.022,85318.676
y2045,MLI,166893.448,109672.305,79709.162,71274.019,208457.305,166893.448,209001.15,65400.669,175524.525,93716.166
y2045,MLT,21450.667,20258.096,17667.524,20772.667,25875.524,21450.667,14871.78,11970.504,13571.525,10489.766
y2045,MMR,420556.475,270984.904,213063.189,161693.618,531228.332,420556.475,310066.737,106460.785,193309.558,203651.649
y2045,MNE,15695.534,13997.677,11681.677,13246.248,18716.248,15695.534,56638.255,20388.515,34339.647,31991.677
y2045,MNG,127759.314,101952.171,80982.314,97158.028,153167.885,127759.314,291191.823,56180.505,95645.74,192599.841
y2045,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2045,MOZ,280419.573,178353.573,120733.145,105565.145,364555.287,280419.573,180048.044,57524.684,151484.988,81684.142
y2045,MRT,52418.694,45400.265,35751.979,35339.837,63278.122,52418.694,104504.33,32497.242,87717.796,46695.777
y2045,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2045,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2045,MUS,58409.671,48157.814,40429.242,44355.528,70119.242,58409.671,208494.93,64788.072,174993.506,93124.545
y2045,MWI,173686.22,112489.22,84246.934,72951.792,226665.934,173686.22,190630.539,59331.32,160021.625,85221.224
y2045,MYS,1625660.919,1472765.633,1265069.633,1381844.204,1892141.633,1625660.919,3014139.738,1016910.129,1868834.835,1970283.397
y2045,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2045,NAM,61977.339,53007.196,43423.911,49786.625,72965.625,61977.339,201284.833,62566.166,168946.272,89919.055
y2045,NCL,15860.988,13838.845,11554.131,14716.845,20361.273,15860.988,223012.324,73173.36,22915.068,144698.668
y2045,NER,153126.447,102194.733,75199.876,66061.733,197237.304,153126.447,178043.298,55302.814,149429.625,79505.086
y2045,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2045,NGA,3681384.852,2805271.137,2143417.852,1929086.995,4616371.709,3681384.852,4403915.896,1379130.976,3698767.899,1975565.528
y2045,NIC,87095.542,69750.542,59579.256,45816.685,93307.113,87095.542,150453.175,56816.575,105575.134,72686.923
y2045,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2045,NLD,1112687.604,1067849.89,863954.604,1040575.89,1332808.319,1112687.604,1212738.187,971508.378,1104627.049,848390.789
y2045,NOR,461243.475,418254.761,340969.332,451791.904,595948.047,461243.475,415258.18,333441.044,378590.474,291683.649
y2045,NPL,277383.342,184399.199,132641.627,115057.77,364860.913,277383.342,366266.967,121852.112,484245.031,249102.738
y2045,NRU,112.414,112.414,112.414,112.414,112.414,112.414,112.414,112.414,112.414,112.414
y2045,NZL,263100.192,233250.906,188726.62,252423.335,329051.335,263100.192,164911.841,132789.016,172706.969,119295.045
y2045,OMN,248253.431,219900.288,172975.574,219058.716,274598.574,248253.431,662880.762,271308.812,407787.419,237851.891
y2045,PAK,2448951.61,1986236.896,1520557.324,1378873.61,2943949.181,2448951.61,4878459.828,1625761.695,6448524.092,3319226.168
y2045,PAN,226806.271,209374.271,181470.271,193218.843,266089.7,226806.271,250188.292,97065.981,176800.007,123018.485
y2045,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2045,PER,1193446.936,1001581.365,898508.936,956145.936,1313309.507,1193446.936,1668174.6,641315.254,1176022.639,815356.328
y2045,PHL,1873754.713,1482480.57,1200858.427,1057911.856,2304956.856,1873754.713,3646612.306,1212253.585,2250637.118,2374289.497
y2045,PLW,191.555,191.555,191.555,191.555,191.555,191.555,191.555,191.555,191.555,191.555
y2045,PNG,134781.852,104515.137,82774.28,74558.28,170190.852,134781.852,188134.755,62864.231,20846.572,122661.847
y2045,POL,1554134.177,1419782.177,1184870.034,1492210.605,1832695.748,1554134.177,3004258.302,1125081.835,1848304.644,1726586.533
y2045,PRI,119794.927,112989.641,109537.499,109782.641,121065.499,119794.927,214418.992,174602.528,762326.596,166154.012
y2045,PRK,19711.409,19711.409,19711.409,19711.409,19711.409,19711.409,2477801.513,464858.662,802890.311,1633331.44
y2045,PRT,422967.796,384138.796,299534.51,394413.225,525272.939,422967.796,460280.501,367370.268,418641.24,319951.237
y2045,PRY,184439.197,149696.769,122023.769,148171.197,223139.34,184439.197,294299.012,111047.562,206470.469,142106.615
y2045,PSE,101072.347,79204.633,66500.633,50837.919,122666.49,101072.347,79204.633,79204.633,79204.633,79204.633
y2045,PYF,9486.172,8442.172,7321.743,8710.6,11442.6,9486.172,120833.268,39789.362,12605.99,78475.496
y2045,QAT,411396.854,436671.568,400193.711,532386.854,747408.854,411396.854,578565.008,253134.714,366560.287,225329.107
y2045,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2045,ROU,634621.884,502948.741,415374.17,495298.17,753004.313,634621.884,1689187.578,614486.096,1028097.398,958486.78
y2045,RUS,6253000.591,5346311.591,4640734.305,5559016.019,8031732.305,6253000.591,18560005.173,6727632.779,9806778.264,9186581.31
y2045,RWA,141607.872,101808.443,70670.729,62004.443,179806.872,141607.872,187112.725,58152.76,157049.146,83581.404
y2045,SAU,2030146.525,1962765.382,2032548.096,2477501.525,2779718.239,2030146.525,7352264.55,2978954.07,4503229.034,2605287.097
y2045,SDN,750735.058,559102.772,434899.201,363772.772,945522.629,750735.058,526273.115,244354.62,651548.888,190432.31
y2045,SEN,180213.165,135590.451,102520.023,90381.165,216329.023,180213.165,344098.879,106845.694,288789.621,153627.862
y2045,SGP,566913.323,574272.323,481064.752,534139.038,668993.323,566913.323,1886790.116,639997.246,1171820.75,1235151.147
y2045,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2045,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2045,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2045,SLB,10183.016,7614.159,5906.588,5341.588,12569.016,10183.016,17312.166,5759.686,1884.806,11274.238
y2045,SLE,60667.756,41366.756,27226.756,24523.756,80043.899,60667.756,141141.126,43390.962,118353.28,62665.58
y2045,SLV,103286.385,85742.528,82819.528,61590.956,100680.099,103286.385,362052.7,137280.257,254324.023,175376.65
y2045,SMR,1733.501,1733.501,1733.501,1733.501,1733.501,1733.501,1733.501,1733.501,1733.501,1733.501
y2045,SOM,8416.871,4211.871,2884.585,2353.014,11112.014,8416.871,222679.749,68308.018,186692.093,98747.417
y2045,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2045,SRB,173897.61,149755.039,122838.61,141736.753,211079.896,173897.61,980054.362,352997.505,594327.593,553711.835
y2045,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2045,STP,4986.48,3806.765,3565.051,2741.48,5188.908,4986.48,3806.765,3806.765,3806.765,3806.765
y2045,SUR,17696.981,15205.267,13408.838,14396.553,20501.981,17696.981,48260.587,18285.495,33894.159,23365.935
y2045,SVK,272889.402,260526.831,211414.26,261747.402,326043.402,272889.402,620108.18,229592.287,379886.847,354592.332
y2045,SVN,102830.827,98237.541,78236.541,98651.256,127634.113,102830.827,310798.039,114349.252,189954.841,177230.45
y2045,SWE,720446.78,677965.209,542547.78,689806.352,901457.494,720446.78,654095.728,524249.254,595902.878,457978.9
y2045,SWZ,19979.887,14759.316,10327.459,9343.316,24317.602,19979.887,105993.814,32736.273,88915.771,47181.375
y2045,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2045,SYC,1368.769,1368.769,1368.769,1368.769,1368.769,1368.769,1368.769,1368.769,1368.769,1368.769
y2045,SYR,668627.983,564707.412,473334.698,430428.412,805007.555,668627.983,864927.465,350860.83,530033.771,306937.646
y2045,TCA,1206.075,1206.075,1206.075,1206.075,1206.075,1206.075,1206.075,1206.075,1206.075,1206.075
y2045,TCD,144215.227,97707.655,71752.37,66372.941,175523.512,144215.227,178700.034,56078.918,150114.188,80257.652
y2045,TGO,55959.338,33810.766,23949.195,21234.338,73001.481,55959.338,128562.648,39520.852,107804.926,57078.333
y2045,THA,2534980.234,2103653.663,1569613.234,1903673.091,3099378.377,2534980.234,6019039.649,2003650.105,3716427.414,3920387.688
y2045,TJK,110259.182,78132.039,70948.61,50732.896,113595.61,110259.182,143311.068,51810.687,75621.887,70825.87
y2045,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2045,TKM,245835.243,262750.1,252583.814,245613.243,280143.386,245835.243,166955.135,62750.209,89867.52,84405.591
y2045,TLS,23439.253,15733.681,13640.967,9189.11,24578.11,23439.253,15733.681,15733.681,15733.681,15733.681
y2045,TON,1326.897,1040.326,1061.326,779.183,1260.754,1326.897,1040.326,1040.326,1040.326,1040.326
y2045,TTO,63936.221,58579.221,53723.936,59371.079,70343.507,63936.221,219478.057,84720.378,154891.552,107560.284
y2045,TUN,420704.31,379774.167,331757.453,364365.596,489689.596,420704.31,776212.527,357368.234,962333.846,277256.243
y2045,TUR,3175410.746,2891535.318,2462327.461,2632871.461,3659632.318,3175410.746,1266535.613,1023145.377,5911558.607,898925.161
y2045,TUV,32.108,32.108,32.108,32.108,32.108,32.108,32.108,32.108,32.108,32.108
y2045,TWN,1520165.009,1528787.009,1202507.009,1537333.009,1910072.009,1520165.009,1528787.009,1528787.009,1528787.009,1528787.009
y2045,TZA,708000.202,533147.774,401530.631,350990.917,888594.917,708000.202,710899.568,223976.495,597386.429,319989.188
y2045,UGA,540633.398,402996.112,297523.255,259764.398,681978.112,540633.398,342595.738,108970.445,288132.227,155037.256
y2045,UKR,1094668.313,851845.599,648130.313,840952.599,1388088.742,1094668.313,3953325.491,1414752.774,2075367.101,1942307.135
y2045,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2045,URY,132989.51,112481.081,98045.081,104907.367,147599.652,132989.51,381444.555,144907.799,268077.492,184998.11
y2045,USA,29001266.363,25874622.649,22036130.792,27797913.506,35905253.22,29001266.363,27723552.9,22622761.855,24596913.992,21540442.78
y2045,UZB,543737.118,453217.404,376850.975,462523.832,585863.689,543737.118,397776.751,148375.067,213277.019,200204.564
y2045,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2045,VCT,2609.376,2100.519,1939.662,1999.948,2754.662,2609.376,2100.519,2100.519,2100.519,2100.519
y2045,VEN,931420.165,908234.736,1025123.736,848707.593,1254767.879,931420.165,3141257.867,1182852.811,2202635.753,1514780.373
y2045,VGB,1483.221,1483.221,1483.221,1483.221,1483.221,1483.221,1483.221,1483.221,1483.221,1483.221
y2045,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2045,VNM,1764795.608,1381171.75,1133084.036,1334987.75,2144072.893,1764795.608,3500198.111,692253.058,1163788.698,2322208.6
y2045,VUT,6255.8,4665.086,3700.372,3395.229,7845.8,6255.8,15018.336,4981.435,1614.904,9772.528
y2045,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2045,WSM,2100.84,1702.84,1773.982,1303.411,2033.125,2100.84,14701.923,4852.679,1549.091,9554.195
y2045,YEM,317453.388,292861.817,245217.246,227785.388,362523.674,317453.388,480329.848,196179.472,295217.331,171900.928
y2045,ZAF,1826995.039,1550731.753,1207016.753,1416397.039,2188278.467,1826995.039,9205800.887,2842950.877,7722471.97,4097593.339
y2045,ZMB,241345.13,176715.702,139308.702,120946.416,300971.416,241345.13,361690.98,112133.02,303513.192,161341.474
y2045,ZWE,43777.82,30533.392,23400.392,18256.534,46881.534,43777.82,220656.811,67468.113,184944.949,97674.239
y2050,ABW,1617,1139,746,1657,2498,1617,1139,1139,1139,1139
y2050,AFG,456674,314371,264787,229826,547707,456674,235099.263,74421.343,337458.213,174609.658
y2050,AGO,464994,324819,247196,329090,663750,464994,1546875.05,436087.743,1343434.209,752763.802
y2050,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2050,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2050,ALB,70384,58205,50445,56281,83229,70384,127837.98,43793.87,76527.677,73724.74
y2050,AND,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203
y2050,ARE,1266675,1201108,965922,1324841,1875453,1266675,2258644.311,870279.341,1415759.717,840742.885
y2050,ARG,2112170,1911358,1561540,1696619,2519476,2112170,4873502.441,1803939.74,3481441.035,2452775.702
y2050,ARM,57013,43626,38275,43445,64172,57013,118657.053,40648.731,64155.116,60665.319
y2050,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2050,ATA,10,10,10,10,10,10,10,10,10,10
y2050,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2050,ATG,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311
y2050,AUS,2444276,2131336,1559260,2362085,3400799,2444276,1134734.138,885313.329,1182411.27,769493.429
y2050,AUT,592157,561294,428800,565477,768156,592157,659636.895,514597.641,589307.106,435602.859
y2050,AZE,182697,155347,128432,155376,236065,182697,399257.971,136775.095,215869.523,204127.034
y2050,BDI,107592,60196,31144,27285,162479,107592,113245.285,31925.578,98351.57,55109.138
y2050,BEL,754294,731121,549873,704421,962452,754294,816584.535,637036.04,729521.154,539246.001
y2050,BEN,168465,99895,64245,55653,230639,168465,235963.043,66521.592,204929.819,114827.915
y2050,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2050,BFA,312921,220999,143990,121900,398143,312921,274319.673,77334.913,238241.888,133493.601
y2050,BGD,2636728,1754129,1236326,914328,3366512,2636728,2377811.388,752702.979,3413077.395,1766015.031
y2050,BGR,289035,245587,186932,230805,358925,289035,774201.729,265220.792,463460.544,446485.633
y2050,BHR,137333,136863,89999,124992,183360,137333,266700.529,102762.511,167172.787,99274.849
y2050,BHS,22657,20907,17441,21134,28551,22657,126064.34,46663.047,90055.473,63446.68
y2050,BIH,96512,83032,68913,80020,115956,96512,88644.988,30367.4,53065.568,51121.965
y2050,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2050,BLR,385669,327584,264355,311289,465012,385669,736728.519,252383.473,398332.02,376664.257
y2050,BLZ,8521,6919,5950,4869,9398,8521,19343.777,7160.15,13818.443,9735.492
y2050,BMU,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541
y2050,BOL,317650,262786,206496,258825,368789,317650,411219.118,152213.837,293758.981,206961.681
y2050,BRA,7214073,5613100,4333190,5332213,8867724,7214073,21571180.239,7984629.071,15409614.126,10856517.953
y2050,BRB,9865,8681,6978,8947,12034,9865,100121.558,37060.258,71522.956,50389.987
y2050,BRN,46380,49007,38153,41213,55842,46380,406692.166,128739.565,250058.488,255663.85
y2050,BTN,56626,51041,34970,41576,73730,56626,28159.01,8913.815,40419.051,20913.868
y2050,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2050,BWA,101945,88597,62604,75501,127623,101945,414719.45,116915.758,360176.665,201817.07
y2050,CAF,44885,26702,15184,12312,63406,44885,104960.197,29589.885,91156.114,51077.323
y2050,CAN,2679576,2647380,2277354,2674918,4185781,2679576,2449274.008,1910733.976,2426048.523,2159647.572
y2050,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2050,CHE,634462,586001,442556,609259,841742,634462,737774.049,575554.2,659113.359,487202.106
y2050,CHL,904435,809537,639345,741522,1087211,904435,1683300.257,623078.015,1202484.386,847184.96
y2050,CHN,68441845,50967520,38452515,50574283,85164635,68441845,85943477.355,15885257.285,29042450.845,56928877.658
y2050,CIV,604593,462108,315968,263415,704742,604593,967976.383,272887.352,840670.736,471051.351
y2050,CMR,438814,318234,221564,195309,562779,438814,1062987.781,299672.519,923186.49,517287.239
y2050,COD,966031,547687,332910,260575,1359728,966031,958122.959,270109.521,832113.208,466256.329
y2050,COG,171163,130342,96924,91994,219783,171163,348845.165,98344.789,302965.988,169760.326
y2050,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2050,COL,1813793,1482473,1162190,1353001,2224531,1813793,3846891.756,1423937.096,2748070.198,1936094.778
y2050,COM,8944,6249,4083,3353,11379,8944,22179.91,6252.856,19262.868,10793.524
y2050,CPV,9821,7474,6795,6874,10311,9821,23438.939,6607.795,20356.313,11406.212
y2050,CRI,214092,182401,140562,163181,275660,214092,418609.765,154949.505,299038.573,210681.306
y2050,CUB,202077,148217,112041,138194,248927,202077,1626497.021,602052.148,1161906.358,818596.568
y2050,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2050,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2050,CYM,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394
y2050,CYP,46612,40891,31679,44748,62657,46612,42076.281,32824.657,232002.839,27785.814
y2050,CZE,761578,707387,527767,724362,988467,761578,1918680.613,657288.626,1148580.18,1106511.773
y2050,DEU,4775802,4391664,3398172,4550633,6130026,4775802,6596421.708,5146017.57,5893118.194,4356063.423
y2050,DJI,19589,16440,12142,11912,23818,19589,80755.328,22766.163,70134.605,39298.383
y2050,DMA,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135
y2050,DNK,361611,338981,261746,343054,467388,361611,429538.562,335092.734,383741.614,283653.365
y2050,DOM,347633,309048,259183,274972,394537,347633,587778.551,217567.776,419886.189,295821.94
y2050,DZA,1006329,833754,666814,767036,1226770,1006329,4060154.041,1774098.307,5465377.994,1511325.003
y2050,ECU,491853,407379,325044,365554,595026,491853,1069191.406,395764.01,763788.852,538111.293
y2050,EGY,3326028,2798536,2131884,2437859,3994165,3326028,5103594.116,2230033.046,6869953.871,1899728.265
y2050,ERI,30955,15686,8369,6753,45847,30955,15686,15686,15686,15686
y2050,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2050,ESP,2237528,2013412,1489234,2060946,2938509,2237528,2485310.48,1938846.842,2220329.302,1641218.611
y2050,EST,66857,64840,50816,63904,82510,66857,175283.921,60047.58,94771.95,89616.712
y2050,ETH,1406961,895670,563447,459627,1885189,1406961,1065721.196,300443.11,925560.414,518617.415
y2050,FIN,361822,335642,263060,342840,462590,361822,379306.837,295905.831,338865.543,250481.96
y2050,FJI,14015,11330,9171,6670,15321,14015,78096.981,24721.822,7158.19,49095.056
y2050,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2050,FRA,4215719,3789860,2985708,3980635,5388400,4215719,4719615.563,3681878.704,4216415.138,3116681.382
y2050,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2050,FSM,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573
y2050,GAB,82442,67734,50098,54526,98863,82442,571774.493,161191.977,496576.251,278245.577
y2050,GBR,4682301,4196667,3205972,4323922,6074991,4682301,4408855.819,3439448.009,3938788.269,2911465.704
y2050,GEO,101374,75648,65008,75863,112176,101374,314670.375,107797.648,170134.972,160880.269
y2050,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2050,GHA,579069,414345,274819,235078,739008,579069,578439.951,163071.072,502365.086,281489.224
y2050,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2050,GIN,341872,216266,122572,94309,381682,341872,222138.981,62624.377,192923.86,108100.64
y2050,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2050,GMB,36807,27680,19964,16894,45504,36807,46656.707,13153.24,40520.543,22704.795
y2050,GNB,24827,16160,9704,8216,32796,24827,42805.128,12067.421,37175.513,20830.481
y2050,GNQ,75737,67726,55058,67871,95113,75737,20313.594,5726.713,17642.004,9885.309
y2050,GRC,568636,496953,366269,516057,728258,568636,584254.13,455789.844,521961.572,385822.52
y2050,GRD,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857
y2050,GRL,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595
y2050,GTM,421044,324489,251027,212270,503323,421044,720842.241,266821.65,514941.726,362791.31
y2050,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2050,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2050,GUY,12217,8857,8032,8397,12657,12217,30854.294,11420.798,22041.11,15528.598
y2050,HKG,740420,750410,559982,703879,992708,740420,4055427.077,1614430.124,2951605.17,5785722.787
y2050,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2050,HND,183986,140747,110063,92975,221686,183986,293908.872,108791.141,209957.093,147920.833
y2050,HRV,136685,122113,100210,127904,167075,136685,693568.309,237597.94,415190.943,399983.976
y2050,HTI,141007,92460,62784,49097,166317,141007,220814.846,81735.196,157741.558,111133.481
y2050,HUN,362479,342692,259468,336538,455542,362479,1447093.89,495735.637,866274.12,834545.581
y2050,IDN,9086702,6334963,4534446,6044947,11506792,9086702,12088912.734,3826779.818,7432981.241,7599600.47
y2050,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2050,IND,36896745,27538481,18892213,23838428,46498273,36896745,34117945.968,10800133.141,48972425.129,25339606.712
y2050,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2050,IRL,364787,360369,276408,348456,471655,364787,200278.19,156241.54,178924.741,132257.236
y2050,IRN,2352015,2248258,2070015,2246094,3179406,2352015,9852580.234,3796302.493,6175778.157,3667459.585
y2050,IRQ,849484,753014,918488,1092018,1354257,849484,2948499.417,1136087.748,1848173.561,1097530.006
y2050,ISL,32334,30890,22425,29232,42765,32334,21908.772,17091.528,19572.882,14467.844
y2050,ISR,845769,779741,583467,763226,1107629,845769,2401577.374,925352.949,1505352.784,893947.347
y2050,ITA,2925123,2609633,1985508,2709571,3769403,2925123,4423760.939,3451075.83,3952104.221,2921308.563
y2050,JAM,49374,39550,36468,38082,51749,49374,349584.671,129399.685,249729.724,175941.799
y2050,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2050,JOR,307913,269745,200535,271935,403832,307913,345740.445,133217.419,216716.458,128696.147
y2050,JPN,6436957,5319228,4212844,6129464,8158483,6436957,8938032.943,6973404.109,9018367.384,6061118.092
y2050,KAZ,853897,751290,759944,841056,1138913,853897,1300914.548,445658.506,703374.317,665113.402
y2050,KEN,755228,509871,365337,307149,969428,755228,1391428.977,392265.117,1208431.985,677118.276
y2050,KGZ,84702,70619,61473,47038,94677,84702,125646.99,43043.296,67934.413,64239.036
y2050,KHM,291704,204173,156469,112485,348056,291704,428287.42,62947.752,144729.033,283697.18
y2050,KIR,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803
y2050,KNA,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494
y2050,KOR,3695944,3421854,2748359,3531279,4439520,3695944,14723792.523,4660858.533,9053061.763,9255997.048
y2050,KWT,503089,489160,493762,599154,753415,503089,1430669.607,551252.004,896769.973,532543.033
y2050,LAO,166953,119220,92973,75996,205053,166953,278532.479,51482.209,94123.092,184499.649
y2050,LBN,196021,180446,145902,160915,228001,196021,514090.893,198084.613,322241.609,191361.809
y2050,LBR,83026,47820,24275,23602,124548,83026,44694.987,12600.201,38816.823,21750.153
y2050,LBY,393463,377669,346023,356949,483439,393463,1736101.754,758595.647,2336968.555,646235.084
y2050,LCA,5210,4091,3288,3905,6529,5210,4091,4091,4091,4091
y2050,LIE,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212
y2050,LKA,688870,563922,411114,481149,810838,688870,1065756.135,337368.145,1529771.534,791543.587
y2050,LSO,32014,20499,13209,11169,41595,32014,61977.248,17472.334,53826.167,30160.308
y2050,LTU,115974,108251,93780,99135,127939,115974,524585.708,179709.024,283631.323,268202.847
y2050,LUX,74688,73065,54036,68628,98510,74688,53596.691,41811.989,47882.268,35393.52
y2050,LVA,82403,69072,56737,67712,101585,82403,316996.537,108594.529,171392.674,162069.557
y2050,MAC,57789,58350,45656,52221,72860,57789,218012.262,86788.779,158672.837,137051.704
y2050,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2050,MAR,1009167,826476,623929,677109,1138215,1009167,1848010.206,807494.431,2487608.65,687891.15
y2050,MCO,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733
y2050,MDA,55235,40618,34834,39880,57002,55235,169908.306,58206.038,101712.245,86868.343
y2050,MDG,264705,176683,122666,103140,364145,264705,499220.849,140737.995,433564.667,242938.422
y2050,MDV,11215,9262,7630,8717,13983,11215,14593.863,4619.729,20947.828,10838.951
y2050,MEX,4993562,4416916,3785058,4134695,5785354,4993562,16732363.111,6193528.191,11952950.933,8421198.956
y2050,MHL,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74
y2050,MKD,75675,68133,52505,63196,96297,75675,177515.622,60812.101,106266.214,102374.061
y2050,MLI,237928,148148,97499,83999,307055,237928,261683.768,73772.658,227267.823,127344.525
y2050,MLT,22878,21752,18499,22100,28596,22878,15692.687,12242.22,14019.55,10362.943
y2050,MMR,501736,304433,224201,156671,648253,501736,362595.575,114780.664,222945.286,227942.873
y2050,MNE,17340,15368,12376,14396,21400,17340,67092.426,22984.069,40163.553,38692.505
y2050,MNG,147597,118996,91580,111492,179463,147597,344298.969,63638.078,116347.234,228063.309
y2050,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2050,MOZ,400980,235934,143520,120416,539760,400980,223274.84,62944.593,193910.334,108653.39
y2050,MRT,67055,57619,42793,42335,83607,67055,131218.822,36992.593,113961.276,63855.694
y2050,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2050,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2050,MUS,66158,53749,43392,48058,81891,66158,261877.619,73827.307,227436.18,127438.86
y2050,MWI,258178,156572,108361,89818,348843,258178,239267.126,67453.063,207799.358,116435.798
y2050,MYS,1853727,1683414,1399763,1549599,2225768,1853727,3556804.746,1125916.691,2186934.718,2235957.494
y2050,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2050,NAM,73161,61692,48424,57667,88756,73161,252787.618,71264.697,219541.671,123015.345
y2050,NCL,16523,14113,11255,15247,22410,16523,266843.6,84470.103,24458.273,167749.143
y2050,NER,231559,146041,97681,82125,309343,231559,223670.507,63056.138,194253.964,108845.935
y2050,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2050,NGA,5039996,3701918,2601800,2275957,6494052,5039996,5512078.434,1553939.243,4787144.721,2682371.223
y2050,NIC,109539,85863,69850,50471,117508,109539,173907.58,64372.348,124232.827,87525.613
y2050,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2050,NLD,1192755,1146381,873567,1101360,1500598,1192755,1304786.081,1017893.093,1165671.167,861638.502
y2050,NOR,497539,449452,340923,479803,673205,497539,442540.081,345235.513,395356.925,292239.148
y2050,NPL,380174,237576,156731,129646,518696,380174,435270.893,137786.243,624781.787,323278.349
y2050,NRU,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305
y2050,NZL,296395,259567,198294,282631,389557,296395,171212.994,133579.436,178406.701,116104.089
y2050,OMN,268472,240522,173915,229447,307293,268472,790069.827,304422.19,495230.271,294090.39
y2050,PAK,3134429,2479514,1759885,1553989,3889689,3134429,5792630.005,1833673.556,8314660.546,4302221.661
y2050,PAN,257626,238213,200617,214857,310820,257626,284388.055,105266.986,203155.791,143129.119
y2050,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2050,PER,1361754,1129376,984796,1063384,1510799,1361754,1907145.544,705934.936,1362390.772,959843.625
y2050,PHL,2340077,1802913,1388717,1186831,2963721,2340077,4335274.532,1372343.522,2665584.158,2725336.438
y2050,PLW,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802
y2050,PNG,176856,132213,98560,86469,231206,176856,223090.42,70619.909,20447.957,140244.048
y2050,POL,1626932,1486294,1183215,1551965,1994008,1626932,3478052.719,1191487.775,2082067.432,2005808.709
y2050,PRI,118932,112692,109865,108627,119573,118932,235165.712,187575.5,900132.652,177403.887
y2050,PRK,17493.74,17493.74,17493.74,17493.74,17493.74,17493.74,2949024.557,545079.339,996549.167,1953431.062
y2050,PRT,460909,417937,305628,424033,600816,460909,502541.454,392043.939,448961.015,331862.113
y2050,PRY,228926,183047,142115,180845,284041,228926,340345.724,125979.864,243129.778,171291.947
y2050,PSE,125396,97455,82094,59081,152254,125396,97455,97455,97455,97455
y2050,PYF,9941,8760,7349,9084,12499,9941,144328.598,45687.629,13228.829,90731.045
y2050,QAT,412954,448093,398197,543489,801160,412954,656616.636,253001.276,411579.361,244414.653
y2050,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2050,ROU,693068,535898,424193,525386,844018,693068,1989099.201,681412.15,1190734.874,1147122.491
y2050,RUS,6607070,5655618,4720246,5857669,8809905,6607070,21899813.932,7502290.127,11840721.364,11196630.69
y2050,RWA,193498,133066,84640,71771,252803,193498,235004.294,66251.306,204097.162,114361.354
y2050,SAU,2233451,2157092,2190211,2804399,3206020,2233451,8823973.865,3399969.672,5531028.803,3284577.924
y2050,SDN,1016528,723949,523304,414476,1324997,1016528,624281.559,272781.98,840346.12,232378.456
y2050,SEN,241957,176219,122710,104688,297812,241957,432347.488,121885.372,375486.311,210395.493
y2050,SGP,577117,593143,482097,543116,708234,577117,2220375.054,702866.058,1365218.402,1395821.417
y2050,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2050,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2050,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2050,SLB,13115,9504,6940,6146,16725,13115,20573.457,6512.586,1885.716,12933.343
y2050,SLE,85432,55275,32722,28467,117173,85432,178130.54,50217.725,154703.291,86684.586
y2050,SLV,117618,95472,89977,61974,112677,117618,417461.033,154524.299,298217.963,210103.163
y2050,SMR,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913
y2050,SOM,11428,4296,2093,1271,15736,11428,281312.261,79306.23,244314.83,136896.44
y2050,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2050,SRB,186969,158024,123484,148188,236933,186969,1160581.163,397584.045,694758.946,669312.398
y2050,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2050,STP,5994,4522,4168,3074,6100,5994,4522,4522,4522,4522
y2050,SUR,20250,17311,14826,16068,24038,20250,55671.562,20606.975,39769.603,28018.834
y2050,SVK,291068,279480,214592,277516,363638,291068,722781.967,247605.757,432679.121,416831.624
y2050,SVN,110181,105793,79268,104869,144081,110181,363595.037,124557.928,217658.973,209686.899
y2050,SWE,785581,738141,556951,744706,1035498,785581,702325.607,547900.07,627444.393,463793.102
y2050,SWZ,25028,17711,11375,10067,31560,25028,133497.53,37634.996,115940.294,64964.593
y2050,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2050,SYC,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415
y2050,SYR,830194,690889,555956,494994,1028702,830194,1037225.82,399653.986,650152.185,386090.109
y2050,TCA,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866
y2050,TCD,204119,132359,88712,80285,255915,204119,223452.982,62994.814,194065.047,108740.08
y2050,TGO,79746,44356,28424,24266,107772,79746,162261.243,45743.927,140921.081,78962.027
y2050,THA,2899332,2389520,1678959,2102984,3660052,2899332,7150883.669,2263632.628,4396787.812,4495347.107
y2050,TJK,135018,94085,83513,56065,133993,135018,169352.455,58015.619,91564.944,86584.156
y2050,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2050,TKM,265259,289609,283146,269284,314190,265259,192866.521,66070.908,104278.454,98606.099
y2050,TLS,32140,20428,16756,10279,32649,32140,20428,20428,20428,20428
y2050,TON,1537,1158,1176,798,1410,1537,1158,1158,1158,1158
y2050,TTO,63845,58556,52578,58574,71801,63845,250280.145,92641.854,178790.424,125963.014
y2050,TUN,472575,428537,364705,404704,563753,472575,927490.65,405270.237,1248496.223,345243.012
y2050,TUR,3558193,3243898,2664256,2875347,4217485,3558193,1316471.6,1027009.231,7258843.769,869355.241
y2050,TUV,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481
y2050,TWN,1593012,1624946,1236283,1623768,2078269,1593012,1624946,1624946,1624946,1624946
y2050,TZA,975595,702113,494779,418349,1259912,975595,887321.987,250149.644,770623.789,431802.086
y2050,UGA,776072,555220,379797,320900,1009900,776072,425736.367,120021.595,369744.666,207178.289
y2050,UKR,1239716,954254,688468,936671,1629340,1239716,4698488.884,1609576.541,2540363.944,2402177.708
y2050,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2050,URY,146023,122826,103624,111918,164419,146023,439310.43,162611.911,313826.325,221099.704
y2050,USA,31007587,27281870,22472579,29446673,40312784,31007587,30126511.639,24029844.485,26652460.409,22726783.716
y2050,UZB,635314,526120,423003,540312,694927,635314,461602.314,158132.598,249577.663,236001.578
y2050,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2050,VCT,2909,2324,2095,2163,3063,2909,2324,2324,2324,2324
y2050,VEN,1064390,1041295,1207203,941623,1513803,1064390,3637268.814,1346344.613,2598323.702,1830594.049
y2050,VGB,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533
y2050,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2050,VNM,2091506,1602436,1255851,1524030,2606044,2091506,4113727.776,760355.831,1390131.519,2724929.366
y2050,VUT,8169,5830,4335,3878,10633,8169,17874.409,5658.195,1638.327,11236.607
y2050,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2050,WSM,2395,1883,1958,1334,2259,2395,17540.215,5552.405,1607.696,11026.519
y2050,YEM,404344,371680,297366,273593,475273,404344,573326.66,220908.775,359371.675,213411.341
y2050,ZAF,2074644,1736314,1287887,1549012,2577407,2074644,11595048.657,3268821.617,10070099.079,5642558.468
y2050,ZMB,334839,236271,174253,146806,428694,334839,454770.532,128206.771,394960.337,221307.335
y2050,ZWE,62078,41405,29848,22315,65637,62078,279156.416,78698.465,242442.516,135847.33
y2055,ABW,2067,1422,871,2136,3327,2067,1422,1422,1422,1422
y2055,AFG,627328,415985,331875,279199,767620,627328,310211.747,89247.54,409419.969,210934.547
y2055,AGO,591431,394374,272098,394028,869382,591431,2091148.546,535933.452,1658199.224,966062.576
y2055,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2055,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2055,ALB,76939,63076,53052,60448,93510,76939,147571.319,52735.468,85435.517,83248.025
y2055,AND,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203
y2055,ARE,1343919,1290481,979309,1404318,2073427,1343919,2621557.106,1052725.744,1672797.226,1004929.864
y2055,ARG,2302356,2098052,1657061,1815593,2818433,2302356,5494703.832,2158476.751,3904179.826,2815891.348
y2055,ARM,61218,46431,39851,45979,69381,61218,136973.205,48948.17,75599.102,69833.284
y2055,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2055,ATA,10,10,10,10,10,10,10,10,10,10
y2055,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2055,ATG,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311
y2055,AUS,2694125,2318113,1592706,2593891,3958784,2694125,1219744.113,943287.113,1248648.726,756484.238
y2055,AUT,629058,598484,430604,595381,859884,629058,728321.537,557637.564,621016.365,452547.978
y2055,AZE,198241,167574,129236,165322,268942,198241,460888.272,164701.099,254376.316,234975.457
y2055,BDI,153043,81673,37530,31593,239004,153043,153091.041,39235.19,121395.224,70724.543
y2055,BEL,814612,792525,560723,751732,1094566,814612,901611.337,690316.466,768775.009,560222.878
y2055,BEN,232796,131145,76620,63653,329592,232796,318987.48,81752.232,252944.628,147364.886
y2055,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2055,BFA,426941,295065,175427,143212,555393,426941,370840.027,95041.348,294061.676,171319.571
y2055,BGD,3232560,2101202,1377870,947845,4211385,3232560,3137504.616,902656.241,4140903.936,2133407.656
y2055,BGR,306646,263718,193854,244681,393433,306646,893709.137,319372.148,517407.466,504159.757
y2055,BHR,152168,154796,97870,140377,211932,152168,309553.241,124305.767,197523.755,118662.033
y2055,BHS,24061,22313,18048,22363,31468,24061,142133.142,55833.962,100990.583,72839.501
y2055,BIH,101533,87985,71128,83691,125297,101533,102328.415,36567.653,59242.413,57725.569
y2055,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2055,BLR,404928,345345,270416,324978,503192,404928,850451.483,303913.774,469386.462,433587.137
y2055,BLZ,9869,8000,6679,5307,10960,9869,21809.433,8567.369,15496.367,11176.761
y2055,BMU,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541
y2055,BOL,382615,315515,237111,313815,451784,382615,463635.196,182129.16,329429.071,237600.857
y2055,BRA,8003391,6082409,4433296,5711066,10129850,8003391,24320752.507,9553886.882,17280747.824,12463746.665
y2055,BRB,10438,9177,7052,9290,13141,10438,112883.561,44343.89,80207.73,57849.859
y2055,BRN,49243,53680,40270,43248,61304,49243,536627.318,154387.023,282604.327,276680.085
y2055,BTN,66240,60664,39281,47060,89102,66240,37155.606,10689.622,49038.269,25264.681
y2055,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2055,BWA,113060,98459,65312,80777,146680,113060,560639.965,143684.538,444565.623,259002.781
y2055,CAF,62134,34927,17807,13704,90602,62134,141890.815,36364.722,112513.882,65550.296
y2055,CAN,2907507,2848396,2376839,2870101,4837187,2907507,2704304.477,2070543.961,2612028.976,2257409.595
y2055,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2055,CHE,687146,637560,454163,655595,960931,687146,814594.715,623692.407,694578.732,506154.456
y2055,CHL,979184,885780,672183,795001,1211382,979184,1897862.264,745534.554,1348497.715,972604.546
y2055,CHN,71441844,53257441,38528727,52173518,90540278,71441844,98325420.975,19656096.912,33920724.196,63272099.718
y2055,CIV,767184,583435,374076,304474,903389,767184,1308562.321,335367.051,1037638.876,604525.723
y2055,CMR,566081,398882,258638,222784,747921,566081,1437003.817,368284.892,1139487.972,663862.743
y2055,COD,1399525,762241,420677,312775,2016433,1399525,1295241.935,331953.214,1027076.329,598372.011
y2055,COG,211247,158227,111845,105147,280253,211247,471587.579,120861.6,373950.554,217862.625
y2055,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2055,COL,2078494,1685712,1260489,1506162,2620950,2078494,4337236.131,1703790.348,3081758.42,2222719.562
y2055,COM,11971,8208,5005,3937,15536,11971,29983.99,7684.496,23776.135,13851.914
y2055,CPV,11282,8486,7510,7586,11745,11282,31686.013,8120.702,25125.772,14638.21
y2055,CRI,237897,203413,149903,176772,317313,237897,471967.893,185402.481,335349.745,241871.145
y2055,CUB,220308,159494,116521,147953,276009,220308,1833818.598,720376.372,1302992.444,939783.85
y2055,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2055,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2055,CYM,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394
y2055,CYP,51127,44708,33241,49168,71705,51127,46457.47,35570.046,274123.992,28866.693
y2055,CZE,826048,771963,543396,780957,1126306,826048,2214852.189,791490.286,1282275.197,1249443.802
y2055,DEU,5044270,4629785,3376829,4763636,6819945,5044270,7283273.614,5576420.233,6210213.32,4525515.971
y2055,DJI,24177,20172,14099,13887,30216,24177,109169.378,27978.654,86567.058,50433.744
y2055,DMA,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135
y2055,DNK,393679,370734,270379,369063,535815,393679,474264.231,363119.223,404389.867,294687.591
y2055,DOM,387056,345825,281864,301258,448192,387056,662699.793,260327.424,470871.45,339616.232
y2055,DZA,1152002,940422,713937,848826,1444551,1152002,4712528.496,2180292.028,6745909.468,1806468.61
y2055,ECU,575035,471880,360996,414486,714215,575035,1205475.977,473545.427,856532.97,617774.766
y2055,EGY,3908129,3301109,2407140,2801956,4812979,3908129,5923625.67,2740616.6,8479575.779,2270722.361
y2055,ERI,44987,21106,9968,7530,69179,44987,21106,21106,21106,21106
y2055,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2055,ESP,2420741,2158096,1499252,2213509,3352332,2420741,2744093.244,2101008.131,2339800.111,1705062.649
y2055,EST,71169,69581,51701,67693,92138,71169,202341.116,72307.772,111677.365,103159.918
y2055,ETH,1932361,1183638,677770,527548,2658951,1932361,1440698.994,369231.916,1142418.103,665569.829
y2055,FIN,389311,362522,269026,364718,523038,389311,418802.132,320654.806,357099.118,260225.805
y2055,FJI,16560,13227,10227,6918,18118,16560,103048.391,29646.896,7559.185,53130.798
y2055,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2055,FRA,4601073,4098249,3056488,4303586,6185345,4601073,5211045.173,3989823.707,4443290.731,3237921.49
y2055,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2055,FSM,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573
y2055,GAB,94307,77046,54365,61198,116498,94307,772955.384,198098.145,612923.468,357087.626
y2055,GBR,5073841,4528865,3258652,4618396,6929444,5073841,4867927.594,3727116.591,4150725.4,3024722.843
y2055,GEO,109499,81785,69267,81353,120796,109499,363243.558,129807.194,200483.639,185193.085
y2055,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2055,GHA,744039,525286,322918,268217,974364,744039,781966.108,200407.473,620068.62,361250.373
y2055,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2055,GIN,433323,276169,144919,107488,476177,433323,300299.372,76962.72,238125.688,138731.409
y2055,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2055,GMB,47819,35060,23624,19299,60321,47819,63073.036,16164.777,50014.457,29138.293
y2055,GNB,34151,21543,11760,9618,46183,34151,57866.265,14830.351,45885.691,26732.885
y2055,GNQ,85269,76231,59603,76263,110908,85269,27461.004,7037.889,21775.505,12686.353
y2055,GRC,616181,539131,372574,550727,827746,616181,645089.547,493911.199,550047.123,400831.165
y2055,GRD,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857
y2055,GRL,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595
y2055,GTM,519802,396543,292451,239595,632529,519802,812724.456,319261.401,577469.236,416499.931
y2055,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2055,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2055,GUY,14263,10109,8921,9526,14577,14263,34787.139,13665.383,24717.483,17827.495
y2055,HKG,769141,793405,569105,734766,1076737,769141,5351106.164,1997663.268,3447387.6,6430389.008
y2055,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2055,HND,227894,171423,126967,104000,279810,227894,331371.99,130172.391,235451.423,169819.439
y2055,HRV,142914,128090,101947,133912,180931,142914,800628.972,286109.41,463519.271,451651.316
y2055,HTI,184213,117693,74062,55591,218772,184213,248961.028,97799.009,176895.544,127585.986
y2055,HUN,390093,370866,264582,358327,515043,390093,1670470.348,596952.275,967108.643,942346.777
y2055,IDN,10617586,7237842,4849114,6799380,13770972,10617586,15951231.33,4589149.746,8400405.357,8224307.445
y2055,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2055,IND,43907009,32332831,20687399,27082146,56868030,43907009,45018378.461,12951732.429,59415619.536,30611127.329
y2055,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2055,IRL,394635,391631,283834,373893,537276,394635,221132.142,169309.271,188552.27,137402.093
y2055,IRN,2571383,2463854,2198485,2432374,3600256,2571383,11435665.898,4592163.896,7297018.304,4383670.359
y2055,IRQ,995057,851295,986802,1253438,1627170,995057,3422256.245,1374258.544,2183717.737,1311864.424
y2055,ISL,35787,34466,23434,31729,49797,35787,24190.022,18521.03,20626.054,15030.649
y2055,ISR,959150,885427,625140,851327,1318723,959150,2787456.263,1119345.05,1778656.315,1068524.518
y2055,ITA,3151854,2789121,1995024,2887266,4275590,3151854,4884384.709,3739716.94,4164757.853,3034948.593
y2055,JAM,55803,44000,39728,42105,58262,55803,394144.51,154831.232,280053.501,201988.706
y2055,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2055,JOR,375983,330371,236343,339955,511962,375983,401293.075,161145.279,256062.3,153828.957
y2055,JPN,6765862,5467873,4090030,6380293,8969401,6765862,9607636.446,7430049.923,9301116.628,5958647.771
y2055,KAZ,877050,768327,743597,838993,1188236,877050,1501726.455,536650.665,828842.187,765627.771
y2055,KEN,996337,650484,438126,355300,1311961,996337,1881008.218,482077.292,1491566.141,868982.573
y2055,KGZ,99316,83250,71223,51664,112009,99316,145042.123,51831.645,80052.549,73947.074
y2055,KHM,354218,242069,175583,117912,426983,354218,489991.121,75488.184,169039.232,315307.748
y2055,KIR,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803
y2055,KNA,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494
y2055,KOR,3867884,3577028,2735497,3667124,4835503,3867884,19427935.809,5589393.373,10231344.068,10016864.141
y2055,KWT,539322,529938,518225,649023,840763,539322,1660545.689,666817.134,1059582.572,636542.286
y2055,LAO,199335,140211,103784,81921,248795,199335,318660.869,63703.047,109932.989,205057.269
y2055,LBN,213735,198305,154929,173364,256330,213735,596693.613,239611.308,380746.014,228732.47
y2055,LBR,118893,66172,30055,28471,184792,118893,60421.078,15485.116,47911.558,27913.15
y2055,LBY,427089,412900,357651,371304,534572,427089,2015053.839,932282.07,2884517.469,772437.029
y2055,LCA,6037,4660,3572,4378,7793,6037,4660,4660,4660,4660
y2055,LIE,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212
y2055,LKA,784470,641692,440353,524361,940523,784470,1406257.372,404578.526,1855989.839,956212.217
y2055,LSO,42102,25866,15332,12570,56186,42102,83784.163,21472.762,66437.573,38706.358
y2055,LTU,117121,110927,94852,100144,131796,117121,605561.862,216401.046,334225.462,308734.641
y2055,LUX,79316,77734,54681,71928,110223,79316,59177.442,45309.061,50458.703,36770.342
y2055,LVA,85896,72029,57316,69832,109232,85896,365928.789,130766.777,201965.689,186562.101
y2055,MAC,58955,60411,45945,53150,77227,58955,287665.574,107390.684,185325.184,148317.711
y2055,MAF,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098,582.098
y2055,MAR,1166700,958781,689115,750737,1329168,1166700,2144943.436,992376.614,3070452.358,822228.023
y2055,MCO,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733,6058.733
y2055,MDA,58888,43316,36710,42299,60004,58888,196135.71,70090.234,113551.576,99996.205
y2055,MDG,370708,239783,154462,124938,524972,370708,674873.483,172961.063,535148.346,311776.041
y2055,MDV,12851,10501,8298,9690,16515,12851,19256.495,5540.07,25414.877,13093.83
y2055,MEX,5607086,4948701,4064938,4553559,6631348,5607086,18865155.155,7410772.274,13404354.524,9667896.36
y2055,MHL,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74,183.74
y2055,MKD,82746,75513,56094,68885,109236,82746,204917.307,73228.389,118635.628,115598.079
y2055,MLI,330607,199424,119006,98717,437710,330607,353758.133,90663.486,280516.4,163428.129
y2055,MLT,24037,23146,19252,23244,31109,24037,17326.687,13266.135,14773.909,10766.065
y2055,MMR,578374,334804,229768,145814,762331,578374,478442.191,137647.233,251962.263,246680.372
y2055,MNE,18756,16648,12975,15450,23967,18756,77448.954,27676.833,44838.601,43690.552
y2055,MNG,164694,135697,101973,124734,203435,164694,393902.389,78744.474,135890.131,253474.951
y2055,MNP,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338,716.338
y2055,MOZ,558977,311159,170187,136915,773784,558977,301834.888,77356.252,239343.292,139440.782
y2055,MRT,83667,72110,50548,50122,107600,83667,177388.632,45462.338,140662.265,81949.472
y2055,MSR,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101,42.101
y2055,MTQ,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07,11605.07
y2055,MUS,72951,59010,45788,50980,93135,72951,354020.192,90730.648,280724.202,163549.194
y2055,MWI,373542,217041,139175,110269,518560,373542,323454.116,82896.971,256486.497,149428.369
y2055,MYS,2083322,1906081,1541452,1721225,2576095,2083322,4693177.67,1350221.476,2471570.629,2419759.03
y2055,MYT,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591,2191.591
y2055,NAM,84541,70963,53498,66186,105525,84541,341731.842,87581.308,270980.02,157872.258
y2055,NCL,18134,15450,12011,16816,25504,18134,352098.165,101298.211,25828.401,181538.559
y2055,NER,341796,208906,126616,101608,470034,341796,302369.771,77493.335,239767.433,139687.886
y2055,NFK,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38,16.38
y2055,NGA,6755189,4860505,3152722,2679344,8914030,6755189,7451522.863,1909725.82,5908766.956,3442432.334
y2055,NIC,133736,104133,80954,54789,143171,133736,196074.724,77023.757,139317.97,100483.145
y2055,NIU,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402,9.402
y2055,NLD,1278617,1233867,884953,1166870,1694035,1278617,1440646.832,1103027.645,1228393.249,895156.572
y2055,NOR,539052,488012,345527,512709,765125,539052,488619.533,374110.324,416630.171,303607.364
y2055,NPL,505182,303124,183837,144626,709348,505182,574336.739,165235.977,758014.267,390531.504
y2055,NRU,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305,122.305
y2055,NZL,331281,288806,208266,314122,457984,331281,184039.622,142326.74,188400.859,114141.213
y2055,OMN,293810,268961,182254,245942,347106,293810,917016.087,368241.623,585141.542,351522.708
y2055,PAK,3921301,3073545,2029377,1745395,5002762,3921301,7643332.636,2198977.452,10087732.153,5197233.586
y2055,PAN,285333,266165,218271,234115,354061,285333,320637.602,125955.617,227824.264,164318.347
y2055,PCN,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455,0.455
y2055,PER,1518610,1256215,1067918,1165531,1696934,1518610,2150240.008,844675.747,1527820.955,1101941.509
y2055,PHL,2850495,2166583,1592518,1319697,3707159,2850495,5720362.82,1645741.388,3012517.685,2949366.2
y2055,PLW,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802,170.802
y2055,PNG,225945,165227,116019,99153,304547,225945,294366.167,84688.786,21593.431,151772.475
y2055,POL,1692167,1551647,1176856,1604711,2163290,1692167,4014932.255,1434759.346,2324420.598,2264906.094
y2055,PRI,120777,115829,114261,110954,120692,120777,263187.834,208418.713,1009432.504,185434.532
y2055,PRK,17493.74,17493.74,17493.74,17493.74,17493.74,17493.74,3373892.819,674470.178,1163939.972,2171089.437
y2055,PRT,500697,455499,311969,454970,686923,500697,554868.544,424833.713,473118.574,344771.677
y2055,PRY,275504,219732,162711,217066,349971,275504,383727.92,150739.297,272652.148,196650.477
y2055,PSE,149767,117007,99449,67381,181055,149767,117007,117007,117007,117007
y2055,PYF,10849,9621,7919,9971,14065,10849,190440.522,54789.505,13969.894,98189.373
y2055,QAT,423716,473762,410559,562742,860595,423716,762120.003,306040.767,486303.435,292145.896
y2055,REU,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573,22087.573
y2055,ROU,739904,564211,429437,549744,924393,739904,2296140.739,820539.221,1329336.708,1295300.349
y2055,RUS,6887941,5974901,4795705,6133355,9522804,6887941,25280315.29,9034067.41,13952868.548,12888706.458
y2055,RWA,257445,172205,100801,82603,344690,257445,317691.391,81420.062,251916.881,146766.123
y2055,SAU,2433626,2357088,2310447,3127004,3620062,2433626,10241785.87,4112743.387,6535211.821,3926016.512
y2055,SDN,1346446,930143,623845,467998,1808684,1346446,724589.414,335237.553,1037238.202,277759.176
y2055,SEN,317313,227712,146369,120802,398463,317313,584470.492,149791.983,463462.301,270011.937
y2055,SGP,583244,610322,484167,551990,744833,583244,2929768.533,842890.824,1542905.546,1510561.577
y2055,SGS,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88,2.88
y2055,SHN,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549,32.549
y2055,SJM,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583,181.583
y2055,SLB,16496,11783,8107,7040,21654,16496,27146.524,7810.022,1991.352,13996.497
y2055,SLE,116666,73085,38946,32681,165315,116666,240806.405,61715.466,190950.086,111247.026
y2055,SLV,132479,106592,98124,62632,124149,132479,470672.738,184893.707,334429.491,241207.412
y2055,SMR,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913,1482.913
y2055,SOM,17418,6171,2665,1448,23666,17418,380292.982,97464.014,301557.5,175686.619
y2055,SPM,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508,263.508
y2055,SRB,203924,171630,129227,159799,268041,203924,1339730.913,478760.618,775629.06,755769.84
y2055,SSD,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712,15084.712
y2055,STP,6969,5261,4779,3392,6920,6969,5261,5261,5261,5261
y2055,SUR,22935,19762,16508,17941,27833,22935,62767.742,24656.963,44598.682,32166.819
y2055,SVK,308543,298468,216487,292741,404576,308543,834352.113,298160.57,483043.078,470675.235
y2055,SVN,118096,114186,80369,111535,162992,118096,419720.331,149989.497,242994.532,236772.896
y2055,SWE,851502,801683,569871,799092,1184089,851502,775455.207,593725.341,661205.731,481834.833
y2055,SWZ,30860,21301,12657,10975,40109,30860,180469.112,46251.824,143104.966,83372.583
y2055,SXM,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25,2186.25
y2055,SYC,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415,1175.415
y2055,SYR,999356,828865,641125,559163,1271408,999356,1203884.43,483437.927,768190.222,461488.866
y2055,TCA,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866,989.866
y2055,TCD,281298,177992,108844,96392,361645,281298,302075.709,77417.971,239534.254,139552.036
y2055,TGO,110599,57974,33396,27395,153933,110599,219353.439,56217.358,173938.72,101336.248
y2055,THA,3237288,2678176,1783859,2291707,4219447,3237288,9435538.343,2714592.842,4969042.527,4864876.362
y2055,TJK,158402,110618,96481,61002,150715,158402,195494.056,69860.936,107898.293,99669.07
y2055,TKL,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135,1.135
y2055,TKM,277519,310490,306295,286630,340469,277519,222637.803,79560.911,122879.638,113507.813
y2055,TLS,42511,26022,20233,11244,41333,42511,26022,26022,26022,26022
y2055,TON,1800,1329,1343,851,1590,1800,1329,1329,1329,1329
y2055,TTO,64743,60003,53015,59082,74331,64743,282182.124,110849.206,200500.298,144610.925
y2055,TUN,516981,474317,394781,440279,632336,516981,1076517.312,498060.036,1541017.383,412664.822
y2055,TUR,3904368,3590591,2846911,3091504,4762887,3904368,1453549.105,1112906.238,8576719.322,903173.495
y2055,TUV,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481,27.481
y2055,TWN,1587286,1649451,1208742,1639038,2162757,1587286,1649451,1649451,1649451,1649451
y2055,TZA,1309401,916467,606078,496254,1730425,1309401,1199529.389,307423.367,951180.013,554155.014
y2055,UGA,1085092,758037,481498,393923,1448813,1085092,575533.224,147501.481,456375.396,265883.124
y2055,UKR,1379390,1064723,733607,1037940,1878092,1379390,5423757.514,1938211.23,2993513.916,2765203.586
y2055,UMI,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15,9.15
y2055,URY,157321,133008,108935,118274,179823,157321,495307.171,194570.817,351933.12,253831.911
y2055,USA,32987080,28710527,22818202,31068563,45165300,32987080,33716357.964,26700018.091,28695659.154,23755570.251
y2055,UZB,719167,597885,469183,617452,800404,719167,532856.218,190419.263,294097.312,271666.999
y2055,VAT,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362,30.362
y2055,VCT,3186,2555,2251,2318,3352,3186,2555,2555,2555,2555
y2055,VEN,1193114,1173554,1377925,1023539,1781053,1193114,4100893.583,1610948.238,2913828.749,2101600.216
y2055,VGB,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533,1151.533
y2055,VIR,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39,3840.39
y2055,VNM,2410096,1831777,1375659,1707687,3074820,2410096,4706395.736,940848.966,1623632.527,3028550.881
y2055,VUT,10484,7288,5094,4448,14079,10484,23585.151,6785.419,1730.105,12160.286
y2055,WLF,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729,177.729
y2055,WSM,2747,2136,2214,1416,2522,2747,23144.185,6658.554,1697.757,11932.928
y2055,YEM,504731,467186,359772,328319,609698,504731,665447.221,267220.355,424617.21,255088.01
y2055,ZAF,2311963,1928612,1369240,1678609,2975671,2311963,15674807.823,4017243.961,12429511.151,7241401.023
y2055,ZMB,452400,312769,216642,177345,592215,452400,614783.164,157560.717,487499.067,284015.695
y2055,ZWE,85277,55391,37879,27264,88577,85277,377378.596,96717.095,299246.505,174340.239
y2060,ABW,2586,1762,1016,2700,4318,2586,1762,1762,1762,1762
y2060,AFG,839381,546228,411876,335745,1044537,839381,385324.23,104073.738,480119.424,254816.279
y2060,AGO,750860,486447,306201,481667,1133130,750860,2635422.041,635779.161,2009348.847,1239800.449
y2060,AIA,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97,167.97
y2060,ALA,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01,1556.01
y2060,ALB,83030,68080,55728,64585,103790,83030,167304.659,61677.065,95268.48,94001.466
y2060,AND,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203,2742.203
y2060,ARE,1421730,1388918,993306,1482263,2269341,1421730,2984469.901,1235172.148,1948055.195,1201180.588
y2060,ARG,2478593,2288136,1758348,1929638,3115023,2478593,6115905.223,2513013.763,4296898.283,3232763.631
y2060,ARM,65011,49390,41691,48572,74150,65011,155289.357,57247.609,86671.095,80386.745
y2060,ASM,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268,723.268
y2060,ATA,10,10,10,10,10,10,10,10,10,10
y2060,ATF,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015,3.015
y2060,ATG,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311,799.311
y2060,AUS,2962466,2523602,1628336,2843170,4598989,2962466,1304754.087,1001260.898,1305620.162,743694.984
y2060,AUT,665734,636665,430299,624320,961394,665734,797006.178,600677.486,650051.097,470152.269
y2060,AZE,217841,183726,133254,179089,309727,217841,522518.572,192627.103,291631.425,270485.807
y2060,BDI,210398,109477,45023,36369,338241,210398,192936.798,46544.801,147102.561,90764.638
y2060,BEL,877634,857522,570205,799837,1245269,877634,986638.139,743596.892,804717.984,582015.764
y2060,BEN,312832,170893,90772,72182,455759,312832,402011.917,96982.872,306509.61,189121.343
y2060,BES,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898,397.898
y2060,BFA,566422,389477,212042,166938,750684,566422,467360.381,112747.782,356333.835,219863.688
y2060,BGD,3854015,2492444,1528623,972679,5113047,3854015,3897197.844,1052609.503,4855963.47,2577230.742
y2060,BGR,323521,283470,203021,259687,428929,323521,1013216.544,373523.504,576957.035,569283.851
y2060,BHR,167596,174582,107750,157541,243159,167596,352405.953,145849.023,230026.192,141835.302
y2060,BHS,25282,23738,18654,23515,34292,25282,158201.943,65004.876,111149.149,83622.86
y2060,BIH,105790,92872,73486,87161,134230,105790,116011.842,42767.906,66060.753,65182.185
y2060,BLM,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872,235.872
y2060,BLR,424762,366346,280249,341163,544293,424762,964174.447,355444.075,538131.241,499112.41
y2060,BLZ,11223,9200,7461,5781,12552,11223,24275.089,9974.588,17055.135,12831.4
y2060,BMU,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541,3124.541
y2060,BOL,450589,374464,271195,378283,540442,450589,516051.275,212044.482,362566.089,272775.94
y2060,BRA,8752903,6559794,4522291,6085488,11397887,8752903,27070324.776,11123144.693,19019005.006,14308913.926
y2060,BRB,10888,9651,7101,9543,14142,10888,125645.563,51627.522,88275.764,66414.111
y2060,BRN,51776,58544,42511,45169,66670,51776,666562.47,180034.481,315280.329,299423.91
y2060,BTN,75636,70894,43739,52486,105035,75636,46152.202,12465.43,57506.295,30520.615
y2060,BVT,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2060,BWA,123788,109026,68053,85854,166381,123788,706560.481,170453.317,538709.347,332392.303
y2060,CAF,83485,45283,20810,15185,124943,83485,178821.434,43139.558,136340.456,84124.247
y2060,CAN,3156571,3067688,2464637,3079408,5563307,3156571,2959334.946,2230353.946,2768870.769,2359597.068
y2060,CCK,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94,29.94
y2060,CHE,740681,691927,464101,702140,1094037,740681,891415.382,671830.614,727052.766,525844.06
y2060,CHL,1045724,963353,706611,847208,1332297,1045724,2112424.27,867991.094,1484142.067,1116591.592
y2060,CHN,73146034,55132455,38486901,53198144,94578547,73146034,110707364.594,23426936.539,39144813.692,70322106.59
y2060,CIV,942174,721027,436865,347458,1121086,942174,1649148.259,397846.751,1257375.138,775820.616
y2060,CMR,712204,494297,299635,252282,967329,712204,1811019.854,436897.265,1380792.373,851971.029
y2060,COD,1944800,1037645,523064,369483,2858430,1944800,1632360.911,393796.907,1244575.807,767923.224
y2060,COG,254827,190062,128040,119304,348710,254827,594329.993,143378.411,453140.433,279594.911
y2060,COK,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584,184.584
y2060,COL,2342193,1904211,1365877,1664593,3034723,2342193,4827580.506,1983643.6,3391750.138,2551777.066
y2060,COM,15551,10654,6096,4593,20499,15551,37788.071,9116.137,28811.103,17776.912
y2060,CPV,12672,9566,8259,8279,13044,12672,39933.087,9633.609,30446.547,18786.008
y2060,CRI,260789,226071,160037,190541,359883,260789,525326.021,215855.458,369082.318,277678.413
y2060,CUB,235693,170332,121012,156930,299858,235693,2041140.175,838700.595,1434059.455,1078912.031
y2060,CUW,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075,2214.075
y2060,CXR,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966,91.966
y2060,CYM,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394,2889.394
y2060,CYP,55785,48994,35096,53943,81393,55785,50838.66,38315.435,319230.962,29989.619
y2060,CZE,892753,839997,556848,838372,1282353,892753,2511023.766,925691.946,1429855.084,1410838.864
y2060,DEU,5331660,4896419,3363263,4990366,7610561,5331660,7970125.521,6006822.895,6500562.955,4701560.289
y2060,DJI,29058,24342,16134,15985,37309,29058,137583.428,33191.146,104898.987,64724.357
y2060,DMA,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135,346.135
y2060,DNK,427113,404615,278064,395136,613859,427113,518989.901,391145.712,423296.536,306151.052
y2060,DOM,424089,383842,306149,327352,501220,424089,737621.034,303087.073,518236.049,389893.951
y2060,DZA,1310090,1063992,773838,944583,1688647,1310090,5364902.951,2586485.748,8174461.315,2159250.216
y2060,ECU,660988,542918,400816,466700,841830,660988,1341760.548,551326.844,942690.965,709231.838
y2060,EGY,4502855,3849555,2709629,3187843,5688976,4502855,6743657.225,3251200.154,10275258.586,2714167.144
y2060,ERI,63763,28478,11958,8413,101021,63763,28478,28478,28478,28478
y2060,ESH,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162,1280.162
y2060,ESP,2626935,2326826,1516257,2383495,3843981,2626935,3002876.007,2263169.42,2449194.116,1771390.244
y2060,EST,76194,75024,52773,72045,103775,76194,229398.31,84567.964,128033.26,118749.822
y2060,ETH,2566970,1543859,809222,600687,3613039,2566970,1815676.792,438020.723,1384343.005,854161.826
y2060,FIN,418032,391387,274491,386777,591945,418032,458297.428,345403.78,373794.776,270348.689
y2060,FJI,19208,15356,11361,7120,20960,19208,127999.802,34571.97,7904.084,57498.288
y2060,FLK,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176,274.176
y2060,FRA,5008835,4432070,3126917,4642095,7094872,5008835,5702474.782,4297768.711,4651030.429,3363877.886
y2060,FRO,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68,1942.68
y2060,FSM,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573,203.573
y2060,GAB,106019,86997,58702,68500,134905,106019,974136.276,235004.312,742719.599,458269.899
y2060,GBR,5492781,4894744,3313966,4928134,7913841,5492781,5326999.37,4014785.174,4344786.625,3142385.729
y2060,GEO,116356,87923,73879,86536,128097,116356,411816.737,151816.737,229845.806,213180.14
y2060,GGY,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628,3277.628
y2060,GHA,933211,660201,379032,305507,1251813,933211,985492.265,237743.874,751377.85,463612.178
y2060,GIB,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164,1896.164
y2060,GIN,529737,345111,168745,121022,572823,529737,378459.764,91301.062,288552.527,178041.535
y2060,GLP,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597,12451.597
y2060,GMB,60511,43884,27694,21846,77606,60511,79489.364,19176.314,60605.8,37394.75
y2060,GNB,45391,28246,14071,11125,62629,45391,72927.402,17593.282,55602.704,34307.759
y2060,GNQ,94775,85282,64116,85225,127567,94775,34608.414,8349.064,26386.808,16281.084
y2060,GRC,665309,584913,379044,585701,939981,665309,705924.963,532032.553,575763.789,416423.652
y2060,GRD,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857,620.857
y2060,GRL,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595,1903.595
y2060,GTM,626124,479650,338475,268675,773330,626124,904606.672,371701.152,635556.424,478159.723
y2060,GUF,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859,4975.859
y2060,GUM,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92,4862.92
y2060,GUY,16111,11340,9773,10595,16165,16111,38719.984,15909.967,27203.795,20466.726
y2060,HKG,792529,835299,577141,765052,1157507,792529,6646785.251,2380896.412,3978315.573,7146886.277
y2060,HMD,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01
y2060,HND,275427,206745,145415,115630,343666,275427,368835.109,151553.641,259135.302,194959.974
y2060,HRV,148485,134353,104170,139882,194830,148485,907689.635,334620.881,516866.729,509992.71
y2060,HTI,233017,147379,86579,62416,278129,233017,277107.211,113862.823,194689.331,146474.165
y2060,HUN,418867,400618,268779,380573,582938,418867,1893846.806,698168.914,1078415.314,1064073.033
y2060,IDN,12099521,8153688,5127832,7521637,16050690,12099521,19813549.926,5351519.674,9371698.546,8900366.963
y2060,IMN,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064,7134.064
y2060,IND,50962114,37477357,22486988,30339685,67787118,50962114,55918810.955,15103331.716,69675626.983,36979307.807
y2060,IOT,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5,91.5
y2060,IRL,427575,426265,291359,401301,614139,427575,241986.093,182377.003,197367.761,142747.088
y2060,IRN,2798728,2681798,2324771,2595351,4041132,2798728,13018751.563,5388025.298,8497739.112,5239748.488
y2060,IRQ,1163694,965222,1043927,1430944,1927362,1163694,3896013.073,1612429.34,2543047.427,1568055.778
y2060,ISL,39385,38240,24298,34241,57790,39385,26471.271,19950.531,21590.396,15615.347
y2060,ISR,1079641,1000902,667473,943948,1558446,1079641,3173335.152,1313337.15,2071333.346,1277194.513
y2060,ITA,3387717,2983473,2002880,3069591,4849618,3387717,5345008.479,4028358.05,4359475.145,3153009.264
y2060,JAM,61798,48566,43150,46085,64093,61798,438704.349,180262.778,308223.868,231891.668
y2060,JEY,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45,4806.45
y2060,JOR,448477,398382,276303,420463,633217,448477,456845.705,189073.138,298197.227,183869.903
y2060,JPN,7085558,5630804,3967242,6619223,9845774,7085558,10277239.948,7886695.737,9514048.667,5857909.831
y2060,KAZ,902373,792358,730629,836814,1237468,902373,1702538.361,627642.824,950231.655,881332.239
y2060,KEN,1283652,823176,524291,409850,1727879,1283652,2370587.459,571889.467,1807428.603,1115212.422
y2060,KGZ,114004,97027,82103,56240,129712,114004,164437.257,60619.994,91776.779,85122.227
y2060,KHM,418362,283528,194882,121870,508744,418362,551694.823,88028.617,195072.759,350440.482
y2060,KIR,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803,191.803
y2060,KNA,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494,387.494
y2060,KOR,3991266,3689248,2682854,3752659,5212966,3991266,24132079.094,6517928.213,11414338.743,10840276.493
y2060,KWT,571390,568690,530970,687086,918415,571390,1890421.771,782382.264,1233936.368,760851.344
y2060,LAO,231079,162566,114565,87485,292720,231079,358789.26,75923.885,126863.635,227905.494
y2060,LBN,229354,215481,163817,184961,284187,229354,679296.332,281138.004,443397.586,273401.172
y2060,LBR,163989,90184,36840,33977,262714,163989,76147.168,18370.03,58057.58,35822.457
y2060,LBY,462495,452187,369745,384962,589221,462495,2294005.924,1105968.493,3495359.163,923284.696
y2060,LCA,6880,5283,3874,4871,9136,6880,5283,5283,5283,5283
y2060,LIE,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212,4258.212
y2060,LKA,878300,725822,471109,566941,1072269,878300,1746758.61,471788.907,2176485.859,1155137.657
y2060,LSO,53842,32336,17696,14081,73549,53842,105591.078,25473.19,80506.768,49673.966
y2060,LTU,118069,113779,96710,101475,135863,118069,686538.015,253093.069,383175.011,355391.749
y2060,LUX,83905,82438,55113,75090,123317,83905,64758.193,48806.132,52817.827,38200.722
y2060,LVA,89569,75643,58560,72437,117457,89569,414861.041,152939.024,231544.911,214756.048
y2060,MAC,59801,62435,46478