/*
 * File: app/controller/sosController.js
 *
 * This file was generated by Sencha Architect
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.2.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.2.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('requests.controller.sosController', {
    extend: 'Ext.app.Controller',

    requires: [
        'Ext.layout.container.Accordion',
        'Ext.layout.container.Card'
    ],

    stores: [
        'Requests'
    ],

    refs: [
        {
            ref: 'methodCmb',
            selector: '#sosmethod'
        },
        {
            ref: 'methodPanel',
            selector: '#sosmethodpanel'
        },
        {
            ref: 'GetForm',
            selector: '#sosGetForm'
        },
        {
            ref: 'GetResult',
            selector: '#sosgetresult'
        },
        {
            ref: 'PostBody',
            selector: '#sospostbody'
        },
        {
            ref: 'PostResult',
            selector: '#sosPostResult'
        }
    ],

    onMethodSelected: function(combo, records, eOpts) {
        if(combo.getValue()=='GET'){
            this.getMethodPanel().getLayout().setActiveItem(0);
        }else{
            this.getMethodPanel().getLayout().setActiveItem(1);
            //this.getPostResult().collapse();
        }
        var store = this.getRequestsStore();
        store.clearFilter();
        store.filter("method",combo.getValue());
    },

    onRequestSelected: function(combo, records, eOpts) {
        var method = this.getMethodCmb().getValue();
        var rec = records[0];
        var conf = rec.get("conf");
        if (method=="GET"){
            this.getGetForm().removeAll();
            for (var cnt in conf){
                this.addParameter(conf[cnt][0],conf[cnt][1]);
            }
            this.addParameter("","");
        }else if (method=="POST"){
            this.loadXML(conf);
            this.getPostResult().collapse();
        }
        return;
    },

    onGetSendClick: function(button, e, eOpts) {
        var params = {};
        var values = this.getGetForm().getValues();
        for (var cnt = 0; cnt < values.key.length; cnt++){
            params[values.key[cnt]] = values.value[cnt];
        }
        var url = Ext.getCmp('serviceurl').getValue();
        if(Ext.isEmpty(url)){
            Ext.Msg.alert('Hmmm Hmm', 'You have to choose an istSOS instance..');
            return;
        }
        Ext.Ajax.request({
            url: url,
            method: 'GET',
            params: params,
            scope: this,
            success: function(response){

                var text = "";

                var rh = response.getAllResponseHeaders();

                if (rh['content-type']=='application/json'){
                    text = _vkbeautify.json(response.responseText);
                }else if (rh['content-type'].indexOf('text/xml')>=0 || rh['content-type'].indexOf('application/xml')>=0){
                    text = _vkbeautify.xml(response.responseText);
                }else{
                    text = response.responseText;
                }

                var result = Ext.get('presosgetresult');
                result.removeCls('prettyprinted');
                result.dom.innerHTML = Ext.htmlEncode(text);
                prettyPrint();
            }
        });
    },

    onPostSendClick: function(button, e, eOpts) {
        var url = Ext.getCmp('serviceurl').getValue();
        if(Ext.isEmpty(url)){
            Ext.Msg.alert('Hmmm Hmm', 'You have to choose an istSOS instance..');
            return;
        }
        Ext.Ajax.request({
            url: url,
            method: 'POST',
            xmlData: this.getPostBody().getValue(),
            scope: this,
            success: function(response){

                var text = "";

                var rh = response.getAllResponseHeaders();

                if (rh['content-type']=='application/json'){
                    text = _vkbeautify.json(response.responseText);
                }else if (rh['content-type'].indexOf('text/xml')>=0 || rh['content-type'].indexOf('application/xml')>=0){
                    text = _vkbeautify.xml(response.responseText);
                }else{
                    text = response.responseText;
                }

                this.getPostResult().expand();

                var result = Ext.get('presospostresult');
                result.removeCls('prettyprinted');
                result.dom.innerHTML = Ext.htmlEncode(text);
                prettyPrint();
            }
        });
    },

    onFormRender: function(component, eOpts) {
        this.addParameter("","");
    },

    autoAddParameter: function() {

    },

    addParameter: function(key, value) {
        var field = this.getGetForm().add({
            xtype: 'fieldcontainer',
            fieldLabel: '',
            layout: {
                type: 'hbox',
                align: 'stretch',
                padding: '2px 8px 2px 8px'
            },
            items: [
                {
                    xtype: 'textfield',
                    flex: 1,
                    fieldLabel: '',
                    name: "key",
                    value: Ext.isEmpty(key)?'':key,
                    emptyText: 'Parameter key'
                },
                {
                    xtype: 'tbspacer',
                    width: 8
                },
                {
                    xtype: 'textfield',
                    flex: 1,
                    fieldLabel: '',
                    name: "value",
                    value: Ext.isEmpty(value)?'':value,
                    emptyText: 'Value'
                },
                {
                    xtype: 'tbspacer',
                    width: 8
                },
                {
                    xtype: 'button',
                    text: 'x',
                    handler: function(btn){
                        var fss = this.getGetForm().query('fieldcontainer(true)');
                        if (fss.length>1){
                            var fs = btn.ownerCt;
                            this.getGetForm().remove(fs);
                            fss = this.getGetForm().query('fieldcontainer(true)');
                            if (fss.length==1){
                                var tfs = fss[0].query('textfield(true)');
                                var tf = tfs[0];
                                tf.on("focus",function(field){
                                    this.addParameter("","");
                                },this,{single: true});
                            }
                        }
                    },
                    scope: this
                }
            ]
        });
        if(Ext.isEmpty(key) && Ext.isEmpty(value)){
            var tfs = field.query('textfield(true)');
            var tf = tfs[0];
            tf.on("focus",function(field){
                this.addParameter("","");
            },this,{single: true});
            /*for (var cnt in tfs){
                var tf = tfs[cnt];
                tf.on("focus",function(field){
                    this.addParameter("","");
                },this,{single: true});
            }*/
        }
    },

    loadXML: function(name) {
        Ext.Ajax.request({
            url: 'xml/'+name,
            method: 'GET',
            scope: this,
            success: function(response){
                this.getPostBody().setValue(response.responseText);
            }
        });
    },

    init: function(application) {
        this.control({
            "#sosmethod": {
                select: this.onMethodSelected
            },
            "#sosrequests": {
                select: this.onRequestSelected
            },
            "#sendsosget": {
                click: this.onGetSendClick
            },
            "#sendsospost": {
                click: this.onPostSendClick
            },
            "#sosGetForm": {
                render: this.onFormRender
            }
        });
    }

});
