/*
 * File: app/view/obsPropEditor.js
 * Date: Thu May 03 2012 15:10:30 GMT+0200 (CEST)
 *
 * This file was generated by Ext Designer version 1.2.2.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.qualityindexEditor', {
    extend: 'istsos.view.ui.qualityindexEditor',

    initComponent: function() {
        var me = this;
        
        var gs = Ext.getStore("qistore");
        if (Ext.isEmpty(gs)){
            gs = Ext.create('Ext.data.Store', {
                storeId: 'qistore',
                autoLoad: true,
                proxy: {
                    type: 'ajax',
                    url: Ext.String.format('{0}/istsos/services/{1}/dataqualities',wa.url, this.istService),
                    reader: {
                        type: 'json',
                        idProperty: 'code',
                        root: 'data'
                    }
                },
                fields: [
                {
                    name: 'code'
                },            
                {
                    name: 'name'
                },
                {
                    name: 'description'
                },
                {
                    name: 'display',
                    convert: function(v, record){
                        return record.get('code') + " - " + record.get('name') + " (" + record.get('description') + ")";
                    }
                }
                ]
            });
        }
        
        //var gs = Ext.create('istsos.store.cmbNameDescription');
        
        me.callParent(arguments);
        
        Ext.getCmp("btnNew").on("click",function(){
            this.resetForm();
            Ext.getCmp('frmQuality').show();
        },this);
                
        Ext.getCmp("btnForm").on("click",function(){
            var f = Ext.getCmp('frmQuality');
            var btn = Ext.getCmp("btnForm");
            if (f.getForm().isValid()) {
                var jsonData = f.getValues();
                if (btn.getText()=='New') {
                    Ext.Ajax.request({
                        url: Ext.String.format('{0}/istsos/services/{1}/dataqualities', 
                            wa.url,this.istService),
                        scope: this,
                        method: "POST",
                        jsonData: jsonData,
                        success: function(response){
                            this.resetForm();
                            Ext.getStore("qistore").load();
                            Ext.getCmp('frmQuality').hide();
                        }
                    });
                }else{
                    Ext.Ajax.request({
                        url: Ext.String.format('{0}/istsos/services/{1}/dataqualities/{2}', wa.url,this.istService,Ext.getCmp('opCode').originalValue),
                        scope: this,
                        method: "PUT",
                        jsonData: jsonData,
                        success: function(response){
                            this.resetForm();
                            Ext.getStore("qistore").load();
                            Ext.getCmp('frmQuality').hide();
                        }
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Validation error',
                    msg: "Filled data is invalid",
                    buttons: Ext.MessageBox.OK,
                    animateTarget: f
                });
                return;
            }
        },this);
        
        Ext.getCmp("gridop").on("select",function(rowmodel, record, index, eOpts ){
            Ext.getCmp('frmQuality').loadRecord(record);
            Ext.getCmp('btnForm').setText('Update');
            Ext.getCmp('btnRemove').enable();
            Ext.getCmp('frmQuality').show();
        });
        
        Ext.getCmp("btnRemove").on("click",function(){
            var sm = Ext.getCmp("gridop").getSelectionModel();
            var rec = sm.getSelection();
            if (rec.length>0) {
                Ext.Ajax.request({
                    url: Ext.String.format('{0}/istsos/services/{1}/dataqualities/{2}', wa.url,this.istService,Ext.getCmp('opCode').originalValue),
                    scope: this,
                    method: "DELETE",
                    jsonData: {
                        'code': rec[0].get('code'),
                        'name': rec[0].get('name'),
                        'description': rec[0].get('description')
                    },
                    success: function(response){
                        this.resetForm();
                        Ext.getStore("qistore").load();
                        Ext.getCmp('frmQuality').hide();
                    }
                });                
            }
        },this);
        
        //this.istService="sosmilan";
        //gs.getProxy().url=Ext.String.format('{0}/istsos/services/{1}/dataqualities', wa.url ,this.istService);
    },
    operationLoad: function(){
        Ext.getStore("qistore").load();
    },
    resetForm: function(){
        Ext.getCmp('frmQuality').loadRecord({
            'data': { 
                'code': '',
                'name': '',
                'description': ''
            }
        });
        Ext.getCmp('opName').clearInvalid();
        Ext.getCmp('opCode').clearInvalid();
        Ext.getCmp('btnForm').setText('New');
        Ext.getCmp('btnRemove').disable();
        Ext.getCmp("gridop").getSelectionModel().deselectAll();
    }
});
