/*
 * File: app/view/getobservation.js
 * Date: Wed Apr 18 2012 13:50:28 GMT+0200 (CEST)
 *
 * This file was generated by Ext Designer version 1.2.2.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */


Ext.define('istsos.view.getobservation', {
    extend: 'istsos.view.ui.getobservation',

    initComponent: function() {
        var me = this;
        this.addEvents({
            "ready2load" : true
        });
        this.remaining2load = 1;

        this.store = Ext.create('Ext.data.Store', {
            storeId: 'qistore',
            autoLoad: this.istService=='default'?false:true,
            proxy: {
                type: 'ajax',
                url: Ext.String.format('{0}/istsos/services/{1}/dataqualities',wa.url, this.istService),
                reader: {
                    type: 'json',
                    idProperty: 'code',
                    root: 'data'
                }
            },
            fields: [
            {
                name: 'code'
            },
            {
                name: 'name'
            },
            {
                name: 'description'
            },
            {
                name: 'display',
                convert: function(v, record){
                    return record.get('code') + " - " + record.get('name') + " (" + record.get('description') + ")";
                }
            }
            ],
            "listeners": {
              "load": {
                fn: function(){
                  console.log("qistore loaded");
                  this.remaining2load--;
                  this.checkRemaining();
                },
                scope: this
              }
            }
        });

        me.callParent(arguments);

        var items = [{
            xtype: 'checkboxfield',
            name: 'transactional_log',
            fieldLabel: 'Transactional request logger',
            boxLabel: 'Enabled if checked',
            inputValue: 'True',
            uncheckedValue: 'False',
            anchor: '100%'
        }];

        if (this.istService!='default') {
            items = items.concat([{
                xtype: 'combobox',
                name: 'defaultqi',
                fieldLabel: 'Default quality index',
                displayField: 'display',
                forceSelection: true,
                queryMode: 'local',
                store: 'qistore',
                typeAhead: true,
                valueField: 'code',
                anchor: '100%'
            },
            {
                xtype: 'combobox',
                name: 'correct_qi',
                fieldLabel: 'Correct quality index',
                displayField: 'display',
                forceSelection: true,
                queryMode: 'local',
                store: 'qistore',
                typeAhead: true,
                valueField: 'code',
                anchor: '100%'
            },
            {
                xtype: 'combobox',
                name: 'stat_qi',
                fieldLabel: 'Stat. quality index',
                displayField: 'display',
                forceSelection: true,
                queryMode: 'local',
                store: 'qistore',
                typeAhead: true,
                valueField: 'code',
                anchor: '100%'
            },
            {
                xtype: 'combobox',
                name: 'aggregatenodataqi',
                fieldLabel: 'Aggregation no-data quality index',
                displayField: 'display',
                forceSelection: true,
                queryMode: 'local',
                store: 'qistore',
                typeAhead: true,
                valueField: 'code',
                anchor: '100%'
            }]);
        }else{
            items = items.concat([{
                xtype: 'textfield',
                name: 'defaultqi',
                fieldLabel: 'Default quality index',
                anchor: '100%'
            },
            {
                xtype: 'textfield',
                name: 'correct_qi',
                fieldLabel: 'Correct quality index',
                anchor: '100%'
            },
            {
                xtype: 'textfield',
                name: 'stat_qi',
                fieldLabel: 'Stat. quality index',
                anchor: '100%'
            },
            {
                xtype: 'textfield',
                name: 'aggregatenodataqi',
                fieldLabel: 'Aggregation no-data quality index',
                anchor: '100%'
            }]);
        }
        items = items.concat([{
            xtype: 'textfield',
            name: 'aggregatenodata',
            fieldLabel: 'Aggregation no-data value',
            anchor: '100%'
        }]);
        Ext.getCmp('getobsconfig').add(items);
    },
    checkRemaining: function(){
      console.log("checkRemaining > " + this.remaining2load);
      if(this.remaining2load==0){
        this.fireEvent("ready2load");
      }
    },
    executeGet: function(){
      if(this.istForm.remaining2load>0){
        this.istForm.on("ready2load",this.istForm.executeGet,this);
      }else{
        if (Ext.isEmpty(this.mask)) {
          this.mask = new Ext.LoadMask(this.body, {
            msg:"Please wait..."
          });
        }
        this.mask.show();
        Ext.Ajax.request({
          url: Ext.String.format('{0}/istsos/services/{1}/configsections/getobservation', wa.url, this.istService),
          scope: this,
          method: "GET",
          success: function(response){
            try {
                var json = Ext.decode(response.responseText);
                this.istForm.loadRecord(json);
            } catch (exception) {
                console.error(exception);
            }
            this.fireEvent("operationGet",json);
            this.mask.hide();
          }
        });
      }
    },
    executePost: function(){
        if (Ext.isEmpty(this.mask)) {
          this.mask = new Ext.LoadMask(this.body, {
            msg:"Saving..."
          });
        }
        this.mask.show();

        var json = this.istForm.getValues();

        Ext.Ajax.request({
            url: Ext.String.format('{0}/istsos/services/{1}/configsections/getobservation', wa.url, this.istService),
            scope: this,
            method: 'PUT',
            jsonData: json,
            success: function(response){
                var json = Ext.decode(response.responseText);
                if (Ext.getCmp('messageField') != undefined) {
                    if (json.success && !Ext.isEmpty(json.message)) {
                        Ext.getCmp('messageField').setVisible(true);
                        json['data']['message']=json['message']
                    }else{
                        Ext.getCmp('messageField').setVisible(false);
                    }
                }
                this.istForm.loadRecord(json);
                this.fireEvent("operationPost",json);
                this.mask.hide();
            }
        });
    }
});
