/*
 * File: app/view/database.js
 * Date: Thu Apr 05 2012 15:35:37 GMT+0200 (CEST)
 *
 * This file was generated by Ext Designer version 1.2.2.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.database', {
    extend: 'istsos.view.ui.database',

    initComponent: function() {
        var me = this;
        me.callParent(arguments);
        
        Ext.getCmp('btnTestConnection').on("click",function(){
            if (Ext.isEmpty(this.mask)) {
                this.mask = new Ext.LoadMask(this.body, {
                    msg:"Please wait..."
                });
            }
            this.mask.show();
            Ext.Ajax.request({
                url: Ext.String.format('{0}/istsos/operations/validatedb', wa.url),
                scope: this,
                method: 'POST',
                jsonData: this.getForm().getValues(),
                success: function(response){
                    this.mask.hide();
                    var json = Ext.decode(response.responseText);
                    if (json['success']) {
                        Ext.MessageBox.show({
                            title: 'Test success',
                            msg: "Database: " + json['data']['database'] + "<br/><br/>" + 
                                "<small>"+json['message']+"</small>",
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.Msg.INFO,
                            animateTarget: 'btnTestConnection'
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Test failure',
                            msg: json['message'],
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.Msg.WARNING,
                            animateTarget: 'btnTestConnection'
                        });
                    }
                }
            });
        },this);
    }
});