/*
 * File: app/view/ViewerPanel.js
 *
 * This file was generated by Ext Designer version 1.2.3.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.ViewerPanel', {
    extend: 'istsos.view.ui.ViewerPanel',
    alias: 'widget.viewerpanel',

    initComponent: function() {
        var me = this;
        me.callParent(arguments);

        Ext.getCmp('pchoose').on("serviceSelected",function(service) {
            this.fit2service(service);
        },Ext.getCmp('proceduremap'));

        Ext.getCmp('pchoose').on("offeringSelected",function(offering) {
            this.fit2offering(offering);
        },Ext.getCmp('proceduremap'));

        Ext.getCmp('pchoose').on("procedureSelected",function(procedure) {
            this.fit2procedure(procedure);
        },Ext.getCmp('proceduremap'));

        Ext.getCmp('proceduremap').on("procedureSelected",function(service, offering, procedure) {
            this._addProcedure(service, offering, procedure);
        },Ext.getCmp('pchoose'));

        Ext.getCmp('pchoose').on("procedureAdded",function(procedure) {
            this['chart'].addProcedure(procedure);
            this['map'].add2highlight(procedure);
            this['map'].fit2offering();
        },{
          chart: Ext.getCmp('chartpanel'),
          map: Ext.getCmp('proceduremap')
        });

        Ext.getCmp('pchoose').on("procedureRemoved",function(procedure) {
        this['map'].removeHighlight(procedure);
        this['chart'].removeProcedure(procedure);
        this['grid'].removeProcedure(procedure);
        },{
          chart: Ext.getCmp('chartpanel'),
          map: Ext.getCmp('proceduremap'),
          grid: Ext.getCmp('gridpanel')
        });

        Ext.getCmp('chartpanel').on("queueLoaded",function(chartpanel) {
            this.initReadOnlyGrid(
                chartpanel.obsprop2!==null? Ext.apply({}, chartpanel.procedures, chartpanel.procedures2): chartpanel.procedures,
                chartpanel.obsprop2!==null?[chartpanel.obsprop, chartpanel.obsprop2]: chartpanel.obsprop
            );
        },Ext.getCmp("gridpanel"));

        Ext.getCmp('chartpanel').on("clickCallback",function(panel, e, x, pts) {
            this.updateGridSelection([x]);
            panel.highlightRegion(x);
        },Ext.getCmp('gridpanel'));

        /*Ext.getCmp('gridpanel').on("select",function(panel, grid, record, index, eOpts) {
            console.log("select:");
            console.dir(arguments);
        },Ext.getCmp('chartpanel'));*/

        Ext.getCmp('gridpanel').on("selectionchange",function(panel, grid, selected, eOpts) {

            if (selected.length==1) {
                //this.addAnnotation(selected[0].get('micro'));
                this.highlightRegion(selected[0].get('micro'));
            }else if (selected.length>1) {
                var rec, begin, end;
                rec = selected[0];
                begin = rec.get('micro');
                rec = selected[selected.length-1];
                end = rec.get('micro');
                this.highlightRegion(begin,end);
            }else if (selected.length==0) {
                this.highlightRegion();
                this.removeAnnotations();
            }
        },Ext.getCmp('chartpanel'));

        /*Ext.getCmp('chartpanel').on("underlayCallback",function(panel, e, x, pts) {
            console.log("underlayCallback:");
            console.dir(arguments);
        });*/
    }
});
