/*
 * File: app/view/TestCsv.js
 * Date: Fri Dec 07 2012 17:05:12 GMT+0100 (CET)
 *
 * This file was generated by Ext Designer version 1.2.3.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

function logger(msg) {
    var log = Ext.getCmp("logger");
    log.setValue(
        Ext.isEmpty(log.getValue()) ? 
        Ext.Date.format(new Date(), 'c') + ": " + msg: 
        log.getValue() + "\n" + Ext.Date.format(new Date(), 'c') + ": " + msg
        );
}


Ext.define('istsos.view.TestCsv', {
    extend: 'istsos.view.ui.TestCsv',
    id: 'mytest',
    initComponent: function() {
        var me = this;
        
        this.procedures = {};
        
        Ext.create('istsos.store.Offerings');
        Ext.create('istsos.store.gridProceduresList');
        Ext.create('istsos.store.ObservedProperties');
        
        var ssrv = Ext.create('istsos.store.Services');
        ssrv.getProxy().url = Ext.String.format('{0}/istsos/services',wa.url);
        
        me.callParent(arguments);
        
        Ext.getCmp("cmbServices").on("select",function(combo, records, eOpts){
            
            var o = Ext.getCmp('oeCbOffering');
            o.reset();
            o.disable();
            
            o.getStore().load({
                url: Ext.String.format('{0}/istsos/services/{1}/offerings/operations/getlist',
                    wa.url,combo.getValue()),
                callback: function(records, operation, success){
                    this.enable();
                },
                scope: o
            });
        });
        
        Ext.getCmp("oeCbOffering").on("select",function(combo, records, eOpts){
            
            var pr = Ext.getCmp('oeCbProcedure');
            pr.reset();
            pr.disable();
            pr.getStore().load({
                url: Ext.String.format('{0}/istsos/services/{1}/offerings/{2}/procedures/operations/memberslist',
                    wa.url,Ext.getCmp('cmbServices').getValue(),combo.getValue()),
                callback: function(records, operation, success){
                    this.enable();
                },
                scope: pr
            });
            
        });
        
        Ext.getCmp("oeCbProcedure").on("select",function(combo, records, eOpts){
            
            var service = Ext.getCmp("cmbServices").getValue();
            var offering = Ext.getCmp("oeCbOffering").getValue();
            var procedure = combo.getValue();
            
            this.procedures[procedure] = Ext.create('istsos.Sensor', 
                service, offering, procedure, {
                    listeners: {
                        metadataLoaded: function(){
                            logger("procedure "+ procedure+ " loaded.");
                        },
                        scope: this
                    }
                });
                
        },this);
        
        Ext.getCmp("btncsv").on("change",function(filefield, filename){
            
            var pname = Ext.getCmp("oeCbProcedure").getValue();
            
            // validate file name
            try {
                
                istsos.utils.validatefilename(this.procedures[pname], filename);
                
                logger("file name "+ filename + " is valid.");
                
                var fileList = filefield.fileInputEl.dom.files;
                
                //var parser = istsos.utils.getParser();
                /*parser.on("csvfileparsed",function(text){
                    console.log(text);
                });*/
                istsos.utils.parsecsvfile(this.procedures[pname], fileList, filename, 
                    function(text){
                        
                        console.log(text);
                        logger("Loaded: " + text.total);
                        logger("Begin: " + istsos.utils.micro2iso(text.begin));
                        logger("End: " + istsos.utils.micro2iso(text.end));
                        logger("Is " + text.isregular?"regular":"not regular");
                        
                    }
                );
                
            } catch(e){
                alert(e);
            }
            
        },this);
        
    }
});