/*
 * File: app/view/ProcedureGridEditor.js
 * Date: Wed Jan 30 2013 16:04:05 GMT+0100 (CET)
 *
 * This file was generated by Ext Designer version 1.2.3.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.ProcedureGridEditor', {
    extend: 'istsos.view.ui.ProcedureGridEditor',
    alias: 'widget.proceduregrideditor',

    initComponent: function() {
        
        Ext.create('Ext.data.Store', {
            storeId: 'editableProcedure',
            proxy: {
                type: 'ajax',
                reader: {
                    type: 'json',
                    idProperty: 'name',
                    root: 'data'
                }
            },
            fields: [
            {
                name: 'name',
                sortType: 'asText',
                type: 'string'
            },
            {
                name: 'offerings'
            },
            {
                name: 'observedproperties'
            }
            ]
        });
        
        var me = this;
        me.callParent(arguments);
        
        this.addEvents('select','selectionchange');
        
        this.gridpanel = Ext.getCmp("proceduregrid");
        this.gridpanel.on('select',function(gridpanel, grid, record, index, eOpts){
            this.fireEvent("select", gridpanel, grid, record, index, eOpts);
        },this);
        this.gridpanel.on('selectionchange',function(gridpanel, grid, selected, eOpts){
            this.fireEvent("selectionchange", gridpanel, grid, selected, eOpts);
        },this);
        this.procedures = {};
        
        Ext.getCmp('btnStartEditor').on("click",this.startEditing,this);
        
        this.gridpanel.on('gridremoved',function(){
            //this.getComponent('buttonspanel').setVisible(true);
            //this.getComponent('buttonspanel').enable();
        },this);
        
    },
    /*
    * Load the procedure name in the combo
    */
    addProcedure: function(procedure){
        this.procedures[procedure.getName()] = procedure;
        var ps = Ext.getStore("editableProcedure");
        var data = [];
        for (var key in this.procedures) {
            data.push({
                name: this.procedures[key].getName()
            });
        }
        // Append the procedure name in the store used by combos
        ps.loadData(data);
        if (ps.data.length>0) {
            Ext.getCmp('oeCbEditableProcedures').setValue(ps.getAt(0));
        }
    },
    /*
    * Remove the procedure from the combo
    */
    removeProcedure: function(procedure){
        delete this.procedures[procedure.getName()];
        var ps = Ext.getStore("editableProcedure");
        var data = [];
        for (var key in this.procedures) {
            data.push({
                name: this.procedures[key].getName()
            });
        }
        // Append the procedure name in the store used by combos
        ps.loadData(data);
        if (ps.data.length>0) {
            Ext.getCmp('oeCbEditableProcedures').setValue(ps.getAt(0));
        }
    },
    setObservedProperty: function(observedProperty){
        this.observedProperty = observedProperty;
    },
    startEditing: function(){
        var combo = Ext.getCmp('oeCbEditableProcedures');
        if (!combo.isValid()) {
            Ext.Msg.alert('Warning', 'Please choose a valid procedure from the combo box.');
            return;
        }
        if (Ext.isEmpty(this.observedProperty)) {
            Ext.Msg.alert('Warning', 'The observed property is not selected');
            return;
        }
        this.gridpanel.initEditorGrid(this.procedures, combo.getValue(), this.observedProperty);
        //this.getComponent('buttonspanel').setVisible(false);
        //this.getComponent('buttonspanel').disable();
    },
    updateGridSelection: function(x){
        this.gridpanel.updateGridSelection(x);
    }
});