/*
 * File: app/view/ObservationEditorColumn.js
 * Date: Wed Mar 21 2012 17:13:57 GMT+0100 (CET)
 *
 * This file was generated by Ext Designer version 1.2.2.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.ObservationEditorColumn', {
    extend: 'istsos.view.ui.ObservationEditorColumn',
    
    initComponent: function() {
        var me = this;
        
        var qi = Ext.create('istsos.store.cmbNameDescription',{
            storeId: 'storeQualityindex'
        });
        
        this.initStore(this.istConfig);
        
        qi.getProxy().url=Ext.String.format('{0}/istsos/services/{1}/dataqualities',wa.url, this.istConfig.service);
        
        me.callParent(arguments);
        
        Ext.getCmp("gridContainer").add(
            this.initGrid(this.istConfig));
        Ext.getCmp("chartContainer").add(
            this.initChart(this.istConfig));
            
        console.dir(this.istConfig);
        
        var url = wa.url + '/istsos/services/' + this.istConfig.service;
        url += '/operations/getobservation/offerings/' + this.istConfig.offering;
        url += '/procedures/' + this.istConfig.procedure.name;
        url += '/observedproperties/' + this.istConfig.observedProperties;
        url += '/eventtime/' + ISO8601FromDate(this.istConfig.begin) + '/' + ISO8601FromDate(this.istConfig.end);
        
        //console.log(url);
        
        Ext.Ajax.request({
            url: url,
            scope: this,
            method: "GET",
            success: function(response){
                var json = Ext.decode(response.responseText);
                if (json.success) {
                    console.dir(json.data[0].observedProperty.component);
                    this.goObject = Ext.apply({},json.data[0]);
                    var obs = json.data[0].result.DataArray.values;
                    var data = [];
                    for (var i = 0; i < obs.length; i++) {
                        var rec = [];
                        rec.push(obs[i][0])
                        for (var c = 1; c < obs[i].length; c++) {
                            rec.push(parseFloat(obs[i][c]))
                        }
                        data.push(rec);
                    }
                    console.dir(data);
                    Ext.getStore("observations").loadData(data);
                }
                console.dir(json);
            }
        });
        
        Ext.getCmp('oeapply').on("click",function(){
            var store = Ext.getStore("observations");
            var recs = store.getRange();           
            console.dir(this.goObject.observedProperty);
            var comps = this.goObject.observedProperty.component;
            comps = this.goObject.observedProperty["component"];
            var values = [];
            for (var i = 0; i < recs.length; i++) {
                for (var c = 0; c < comps.length; c++) {
                    values.push(recs[i].get(comps[c]));
                }
            }
            console.dir(values);
        },this);
        
    },
    initStore: function(istConfig){
        
        var fields = [{
            dateFormat: 'c',
            name: wa.isodef,
            type: 'date'
        }];
        
        for (var i = 0; i < this.istConfig.properties.length; i++) {
            fields.push({
                name: this.istConfig.properties[i].name,
                type: 'float'
            },{
                name: Ext.String.format('{0}:qualityIndex',this.istConfig.properties[i].name),
                type: 'float'
            });
        }
        
        var store = Ext.define('istsos.store.ObservationsChart', {
            extend: 'Ext.data.ArrayStore'
        });
        
        Ext.create('istsos.store.ObservationsChart',{
            storeId: 'observations',
            fields: fields
        });
        
    },
    initGrid: function(istConfig){
        var columns = [{
            xtype: 'datecolumn',
            //dataIndex: 'isodate',
            dataIndex: "urn:ogc:def:parameter:x-istsos:1.0:time:iso8601",
            flex: 0.7,
            text: 'Date',
            format: 'c'
        }];
        for (var i = 0; i < istConfig.properties.length; i++) {
            columns.push({
                xtype: 'numbercolumn',
                dataIndex: istConfig.properties[i].name,
                flex: 0.3,
                text: istConfig.properties[i].name,
                field: {
                    xtype: 'numberfield',
                    hideLabel: true
                }
            },{
                xtype: 'gridcolumn',
                dataIndex: Ext.String.format('{0}:qualityIndex',istConfig.properties[i].name),
                flex: 0.3,
                text: Ext.String.format('{0}:qualityIndex',istConfig.properties[i].name),
                field: {
                    xtype: 'combobox',
                    fieldLabel: 'System type',
                    allowBlank: false,
                    displayField: 'name',
                    store: 'storeQualityindex',
                    valueField: 'name',
                    anchor: '100%'
                }
            });
        }
        return {
            xtype: 'gridpanel',
            id: 'oegrid',
            title: '',
            store: 'observations',
            viewConfig: {},
            columns: columns,
            plugins: [Ext.create('Ext.grid.plugin.CellEditing')],
            selModel: Ext.create('Ext.selection.RowModel', {
                allowDeselect: true,
                mode: 'MULTI'
            }),
            dockedItems: [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                layout: {
                    pack: 'center',
                    type: 'hbox'
                },
                items: [
                {
                    xtype: 'button',
                    id: 'oeapply',
                    text: 'Apply'
                }
                ]
            }
            ],
            listeners: {
                selectionchange: function(grid, records, eOpts) {
                    if (records[0]) {
                        var rec = records[0];
                        var name = rec.get(wa.isodef);
                        var series = Ext.getCmp('oechart').series.get(0);
                        var i, items, l;                
                        series.highlight = true;
                        series.unHighlightItem();
                        series.cleanHighlights();                
                        for (i = 0, items = series.items, l = items.length; i < l; i++) {
                            if (name == items[i].storeItem.get(wa.isodef)) {
                                series.highlightItem(items[i]);
                                break;
                            }
                        }
                        series.highlight = false;
                    }
                }
            }
        };
    },
    initChart: function(istConfig){        
        var ret = {
            xtype: 'chart',
            height: 250,
            id: 'oechart',
            width: 400,
            animate: true,
            insetPadding: 20,
            store: 'observations',
            axes: [
            {
                type: 'Category',
                fields: wa.isodef,
                label: {
                    font: '11px Arial',
                    rotate: {
                        degrees: -90
                    },
                    renderer: function(v){
                        return ISO8601FromDate(v);
                    }
                },
                position: 'bottom',
                title: 'iso8601'
            },
            {
                type: 'Numeric',
                fields: istConfig.selectedProperty,
                grid: true,
                label: {
                    font: '12px Arial',
                    renderer: Ext.util.Format.numberRenderer('0.0')
                },
                adjustMinimumByMajorUnit: true,
                adjustMaximumByMajorUnit: true,
                //maximum: 1,
                //minimum: 0,
                position: 'left',
                title: istConfig.selectedProperty.replace(
                    "urn:ogc:def:parameter:x-istsos:1.0:","")
            },
            {
                type: 'Numeric',
                fields: istConfig.selectedProperty,
                grid: true,
                adjustMinimumByMajorUnit: true,
                adjustMaximumByMajorUnit: true,
                //maximum: 1,
                //minimum: 0,
                position: 'right'
            }
            ],
            series: [
            {
                //type: 'column',
                type: 'line',
                highlight: true,
                /*label: {
                    display: 'outside', // outside, over, insideStart
                    rotate: {
                        degrees: -90
                    },
                    'text-anchor': 'middle', // 
                    field: istConfig.selectedProperty,
                    renderer: Ext.util.Format.numberRenderer('0.0'),
                    color: '#333'
                },*/
                xField: wa.isodef,
                yField: istConfig.selectedProperty,
                listeners: {
                    itemmouseup: function(item, event) {
                        var series = Ext.getCmp('oechart').series.get(0);
                        var index = Ext.Array.indexOf(series.items, item);
                        var grid = Ext.getCmp('oegrid');
                        var selectionModel = grid.getSelectionModel();
                        if (event.shiftKey) { 
                            //console.log("shift!");
                            selectionModel.selectRange(this.lastPressed,index);
                            series.highlight = true;
                            series.unHighlightItem();
                            series.cleanHighlights();                
                            for (var i = this.lastPressed; i < index+1; i++) {
                                series.highlightItem(series.items[i]);
                            }
                            series.highlight = false;
                            Ext.create('Ext.window.Window', {
                                //title: 'Hello',
                                /*height: 200,
                                width: 400,*/
                                border: 0,
                                layout: 'fit',
                                items: Ext.create('istsos.view.ObservationEditorAdvancedOperations',{
                                    istGrid: grid,
                                    istConfig: istConfig
                                })
                            }).show();
                        }else{
                            this.lastPressed = index;
                            selectionModel.select(index);
                        }
                    }
                },
                tips: {
                    trackMouse: true,
                    width: 180,
                    //height: 40,
                    renderer: function(storeItem, item) {
                        this.setTitle(
                            ISO8601FromDate(storeItem.get(wa.isodef))
                            +"<br/>"+
                            storeItem.get(istConfig.selectedProperty));
                    }
                }
            }
            ]
        };
        return ret;
    }
});
