/*
 * File: app/view/MapViewer.js
 *
 * This file was generated by Ext Designer version 1.2.3.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.MapViewer', {
    extend: 'istsos.view.ui.MapViewer',

    initComponent: function() {
        var me = this;
        this.addEvents({
            "procedureAdded" : true,
            "procedureRemoved" : true
        });

        Ext.create('istsos.store.Offerings');
        Ext.create('istsos.store.gridProceduresList');
        Ext.create('istsos.store.ObservedProperties');

        var ssrv = Ext.create('istsos.store.Services');
        ssrv.getProxy().url = Ext.String.format('{0}/istsos/services',wa.url);

        this.procedures = {};
        this.configsections = {};

        me.callParent(arguments);

        Ext.getCmp("btnResetOffering").on("click", function(){
          this._serviceSelected();
        },this);

        Ext.getCmp("btnResetProcedures").on("click", function(){
          this._offeringSelected(Ext.getCmp('oeCbOffering'));
        },this);

        Ext.getCmp("btnResetObservedProperties").on("click", function(){
          this._offeringSelected(Ext.getCmp('oeCbOffering'));
        },this);

        Ext.getCmp("cmbServices").on("select",this._serviceSelected,this);

        Ext.getCmp("oeCbOffering").on("select",this._offeringSelected,this);

        Ext.getCmp("oeCbProcedure").on("select",this._procedureSelected,this);

        Ext.getCmp('oeCbObservedProperty').on("select",this._observedPropertySelected,this);

        this.mappanel = Ext.getCmp('mapCnt');

        this.on("afterrender",function(){

          /**
           * Elements that make up the popup.
           */
          var container = document.getElementById('popup');
          var content = document.getElementById('popup-content');
          var closer = document.getElementById('popup-closer');


          /**
           * Add a click handler to hide the popup.
           * @return {boolean} Don't follow the href.
           */
          closer.onclick = function() {
            overlay.setPosition(undefined);
            closer.blur();
            return false;
          };

          /**
           * Create an overlay to anchor the popup to the map.
           */
          var overlay = new ol.Overlay(/** @type {olx.OverlayOptions} */ ({
            element: container,
            autoPan: true,
            autoPanAnimation: {
              duration: 250
            }
          }));


          this.vector = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: new ol.Collection()
            }),
            style: [new ol.style.Style({
              image: new ol.style.Circle({
                radius: 5,
                fill: new ol.style.Fill({color: 'green'}),
                stroke: new ol.style.Stroke({color: 'red', width: 1})
              })
            })]
          });
          var attribution = new ol.control.Attribution({
            collapsible: false
          });
          this.selectSingleClick = new ol.interaction.Select({multi: true});
          this.map = new ol.Map({
              layers: [
                new ol.layer.Tile({
                  source: new ol.source.OSM()
                }),
                this.vector
              ],
              overlays: [overlay],
              interactions: ol.interaction.defaults().extend([this.selectSingleClick]),
              controls: ol.control.defaults({ attribution: false }).extend([attribution]),
              target: 'map',
              view: new ol.View({
                center: [0, 0],
                zoom: 2,
                maxZoom: 16
              })
          });

          this.selectSingleClick.on('select', function(e) {

            if(e.selected.length==0){
                overlay.setPosition(undefined);
                closer.blur();
            }else{
              var coordinate = e.selected[0].getGeometry().getCoordinates();
              var selected = e.selected,
                  html = '';
              for (var c = 0, l = selected.length;c<l;c++){
                var feature = selected[c];
                var name = feature.getProperties().name;
                var begin = feature.getProperties().samplingTime.beginposition;
                var end = feature.getProperties().samplingTime.endposition;
                html += name + "<br/><br/>" +
                  "Begin: " + begin + "<br/>" +
                  "End: " + end + "<br/><br/>" +
                  "Observed properties:<br/>" ;
                html += "<ol>";
                var from = new Date(end);
                begin = new Date(end);
                begin.setDate(from.getDate() - 5);
                var op = feature.getProperties().observedproperties;
                // Create link that will call the chart function
                for (var cnt = 0; cnt < op.length; cnt++){
                    html += "<li><a href='javascript:chart(\""+name+"\",\""+begin.toISOString()+"\",\""+end+"\",\""+op[cnt].def+"\");'>" + op[cnt].name + "</a></li>";
                }
                html += "</ol><hr/>";
              }
              content.innerHTML = html;
              overlay.setPosition(coordinate);
            }
          });
          this.mappanel.on('resize', function(container, width, height, oldWidth, oldHeight, eOpts ){
            this.map.updateSize();
          },this);

        }, this, {
          single: true
        });



    },
    _getProcedureDetails: function(proc){
      console.log(proc);
    },
    /*
      The combo service is selected, related offerings will be loaded
    */
    _serviceSelected: function(comboService, records, eOpts){

        var pr = Ext.getCmp('oeCbProcedure');
        pr.reset();
        pr.disable();

        var op = Ext.getCmp('oeCbObservedProperty');
        op.reset();
        op.disable();

        var o = Ext.getCmp('oeCbOffering');
        o.reset();
        o.getStore().removeAll();
        o.disable();

        Ext.Ajax.request({
            url: Ext.String.format('{0}/istsos/services/{1}/offerings/operations/getlist',
              wa.url, Ext.getCmp('cmbServices').getValue()),
            scope: this,
            method: "GET",
            success: function(response){
              var o = Ext.getCmp('oeCbOffering');
              var json = Ext.decode(response.responseText);
              if (json.data.length>0) {
                o.getStore().loadData(json.data);
                o.enable();

                // Loading geojson filtered on give service name and if only one offering the offering is already set
                var params = {};
                if(json.data.length==1){
                  params["offering"] = json.data[0]['name'];
                  o.select(o.getStore().getAt(0));
                  this._offeringSelected(Ext.getCmp('oeCbOffering'));
                }
                this._reloadMap(params);

              }else{
                o.disable();
                Ext.Msg.alert("Server message", "\"" + json['message'] + "\"<br/><br/>" +
                  "<small>Status response: " + response.statusText + "</small>");
              }
            }
        });
    },
    _reloadMap: function(params){
      this.vector.getSource().clear();
      var url = Ext.String.format('{0}/istsos/services/{1}/procedures/operations/geojson',
          wa.url, Ext.getCmp("cmbServices").getValue());
      Ext.Ajax.request({
        scope: this,
        method: 'GET',
        url: url,
        params: Ext.apply({
          epsg: "3857"
        },params),
        success: function(response){
          var json = Ext.decode(response.responseText);
          var reader = new ol.format.GeoJSON();
          var features = reader.readFeatures(json);
          var mp = new ol.geom.MultiPoint([],ol.geom.GeometryLayout.XYZ);
          for (idx in features){
            mp.appendPoint(features[idx].getGeometry());
          }
          this.vector.getSource().addFeatures(features);
          this.map.getView().fit(mp.getExtent(), this.map.getSize());
        }
      });
    },
    _offeringSelected: function(combo, records, eOpts){
        var pr = Ext.getCmp('oeCbProcedure');
        pr.reset();
        pr.getStore().removeAll();
        pr.disable();

        var opcb = Ext.getCmp('oeCbObservedProperty');
        opcb.reset();
        opcb.getStore().removeAll();
        opcb.disable();

        Ext.Ajax.request({
            url: Ext.String.format('{0}/istsos/services/{1}/offerings/{2}/procedures/operations/memberslist',
                wa.url,Ext.getCmp('cmbServices').getValue(),combo.getValue()),
            scope: this,
            method: "GET",
            success: function(response){

              var json = Ext.decode(response.responseText);
              if (json.data.length>0) {
                var pr = Ext.getCmp('oeCbProcedure');
                pr.getStore().loadData(json.data);
                pr.enable();

                // Configure observed properties combo
                var opcb = Ext.getCmp('oeCbObservedProperty');
                opcb.enable();
                opcb.getStore().removeAll();
                for (var i = 0; i < json.data.length; i++) {
                  var procedure = json.data[i];
                  for (var ii = 0; ii < procedure['observedproperties'].length; ii++) {
                    var op = procedure['observedproperties'][ii];
                    if (opcb.getStore().find('definition',op["def"])==-1) {
                      var data = [[
                        op["name"],
                        "",
                        op["uom"],
                        op["def"]
                      ]];
                      opcb.getStore().loadData(data,true);
                    }
                  }
                }
                var params = {
                  service: Ext.getCmp('cmbServices').getValue(),
                  offering: combo.getValue()
                };

                this._reloadMap(params);

              }else{
                this.disable();
                Ext.Msg.alert("Server message", "\"" + json['message'] + "\"<br/><br/>" +
                  "<small>Status response: " + response.statusText + "</small>");
              }
            }
        });
    },
    _procedureSelected: function(combo, records, eOpts){
      Ext.getCmp("oeCbObservedProperty").reset();
      this._reloadMap({
        offering: Ext.getCmp("oeCbOffering").getValue(),
        procedure: Ext.getCmp("oeCbProcedure").getValue()
      });
    },
    _observedPropertySelected: function(combo, records, eOpts){
      Ext.getCmp("oeCbProcedure").reset();
      this._reloadMap({
        offering: Ext.getCmp("oeCbOffering").getValue(),
        observedProperty: Ext.getCmp("oeCbObservedProperty").getValue()
      });
    }
});

function chart(name, begin, end, observedProperty){
  // Executing an Ajax request to the WALib REST

  Ext.Ajax.request({
    url: Ext.String.format('{0}/istsos/services/{1}/operations/getobservation/offerings/temporary/procedures/{2}/observedproperties/'+observedProperty+'/eventtime/'+begin+'/'+end,
        wa.url, Ext.getCmp('cmbServices').getValue(), name),
    scope: this,
    method: "GET",
    success: function(response){
      var json = Ext.decode(response.responseText);
      var sosData = json.data[0].result.DataArray.values;
      var field = json.data[0].result.DataArray.field[1];
      var data = [];
      // Preparing data as requested by Highcharts
      for(var c = 0, l = sosData.length; c<l; c++){
        var date = new Date(sosData[c][0]);
        data.push([+date,parseFloat(sosData[c][1])]);
      }

      // Clear existing Chart
      $('#chart').empty();

      // Configure and Create new Chart
      $('#chart').highcharts('StockChart',{
        rangeSelector : {
            selected : 1
        },
        title : {
            text : name
        },
        subtitle: {
            text: field.definition
        },
        yAxis: {
            title: {
                text: field.name
            }
        },
        tooltip: {
            valueDecimals: 2,
            formatter: function() {
              var date = new Date(this.x);
              return date.toLocaleString() + "<br/>" +
                     field.name + ": " +
                     this.y + ' ' + field.uom;
            }
        },
        series: [{
          name: field.name,
          data: data,
          labels: {
              formatter: function () {
                  return this.value + " - stic";
              }
          }
        }]
      });
    }
  });

}
