/*
 * File: app/view/Editor1.js
 * Date: Wed Jan 30 2013 15:31:11 GMT+0100 (CET)
 *
 * This file was generated by Ext Designer version 1.2.3.
 * http://www.sencha.com/products/designer/
 *
 * This file will be generated the first time you export.
 *
 * You should implement event handling and custom methods in this
 * class.
 */

Ext.define('istsos.view.Editor1', {
    extend: 'istsos.view.ui.Editor1',
    alias: 'widget.editor1',

    initComponent: function() {
        
        var me = this;
        me.callParent(arguments);
        
        this.pchoose = Ext.getCmp('pchoose');
        this.chartpanel = Ext.getCmp('chartpanel');
        this.grideditor = Ext.getCmp('proceduregrideditor');
        
        this.pchoose.on("procedureAdded",function(procedure) {
            this.chartpanel.addProcedure(procedure);
            this.grideditor.addProcedure(procedure);
        },this);
        
        this.pchoose.on("procedureRemoved",function(procedure) {
            this.chartpanel.removeProcedure(procedure);
            this.grideditor.removeProcedure(procedure);
        },this);
        
        this.chartpanel.on('observedPropertyIsSet',function(chartpanel, observedProperty){
            this.grideditor.setObservedProperty(observedProperty)
        },this)
        
        
        this.grideditor.on("selectionchange",function(panel, grid, selected, eOpts) {
            if (selected.length==1) {
                this.highlightRegion(selected[0].get('micro'));
            }else if (selected.length>1) {
                var rec, begin, end;
                rec = selected[0];
                begin = rec.get('micro');
                rec = selected[selected.length-1];
                end = rec.get('micro');
                this.highlightRegion(begin,end);
            }else if (selected.length==0) {
                this.highlightRegion();
                this.removeAnnotations();
            }
        },this.chartpanel);
        
        
        this.chartpanel.on("clickCallback",function(panel, e, x, pts) {
            this.updateGridSelection([x]);
            panel.highlightRegion(x);
        },this.grideditor);
        
        
        this.chartpanel.on("seriesSelected",function(panel, e, x, y, pts) {
            this.updateGridSelection([x,y]);
            panel.highlightRegion(x,y);
        },this.grideditor);
        
    }
});