from abc import abstractmethod
from logging import Logger
from time import sleep

from mysql.connector import MySQLConnection, DatabaseError


class Runner:
    @abstractmethod
    def run_once(self):
        pass

    def __init__(self, connection: MySQLConnection, logger: Logger):
        self._connection = connection
        self._logger = logger
        self._delay = 5

    def run_continuously(self):
        self._logger.info('starting')
        while True:
            self._logger.info('working')
            try:
                self.run_once()
                sleep(self._delay)
            except DatabaseError as e:
                self._logger.error(e)
                sleep(self._delay)
