from dataclasses import dataclass
from datetime import timedelta, datetime
from enum import Enum

from pydriller import Commit


class Status(Enum):
    NEW = 'new'
    CHANGED = 'changed'
    IN_PROGRESS = 'in_progress'
    DONE = 'done'
    UNAVAILABLE = 'unavailable'

    def __str__(self):
        return str(self.value)


@dataclass
class Update:
    package: str
    delay: timedelta
    commit: Commit
    is_fix_update: bool
    old_version: str
    old_release_date: datetime
    new_version: str
    new_release_date: datetime
