from datetime import datetime
import re
from requests import Request

import pandas as pd
from sqlalchemy import create_engine
import mysql

from config import get_db_connection
from utils.libraries_api import execute_http_request
from utils.parse_dependencies import determine_list_of_versions


def get_disclosure_date(cve):
    try:
        # print(f'working on {cve}')
        cve_detail = execute_http_request(
            Request(method='GET', url='https://services.nvd.nist.gov/rest/json/cve/1.0/{}'.format(cve)), timeout=5)
        cve_detail = cve_detail.json()
        disclosure_date = cve_detail['result']['CVE_Items'][0]['publishedDate']
        disclosure_date = datetime.strptime(disclosure_date, '%Y-%m-%dT%H:%M%z')
        return disclosure_date
    except ValueError:
        print('invalid json')
        return 'UNKNOWN'
    except KeyError as e:
        print('could not decipher things')
        print(e)
        return 'UNKNOWN'


if __name__ == '__main__':
    query = """SELECT cve FROM vulnerabilities WHERE disclosure_date IS NULL"""
    vulnerabilities = pd.read_sql(query, con=get_db_connection())

    for i, row in vulnerabilities.iterrows():
        dd = get_disclosure_date(row['cve'])
        print("UPDATE vulnerabilities SET disclosure_date = '{}' WHERE cve = '{}'".format(dd.strftime('%Y-%m-%d'), row['cve']))


    # cves = pd.read_csv(open('cves.csv'))
    # cves['libraries_io_find_prefix'] = ''
    # cves['first_fix_release_date'] = ''
    # cves['samples'] = 30
    #
    # for i, row in cves.iterrows():
    #     first_fix_version, first_fix_date = get_first_fix_data(row['package_coords'], row['cve'])
    #     cves.at[i, 'libraries_io_find_prefix'] = first_fix_version
    #     cves.at[i, 'first_fix_release_date'] = first_fix_date
    #
    # for i, row in cves.iterrows():
    #     if row['first_fix_release_date'] != 'UNKNOWN':
    #         print('INSERT INTO vulnerabilities (cve, package_coords, libraries_io_find_prefix, first_fix_release_date) VALUES ({}, {}, {}, {})'.format(
    #             row['cve'],
    #             row['package_coords'],
    #             row['libraries_io_find_prefix'],
    #             row['first_fix_release_date'].isoformat()
    #         ))
