from requests import Request

from utils.libraries_api import execute_http_request


def get_cvss_for(cve):
    try:
        cve_detail = execute_http_request(
            Request(method='GET', url='https://services.nvd.nist.gov/rest/json/cve/1.0/{}'.format(cve)), timeout=5)
        cve_detail = cve_detail.json()
    except ValueError:
        print('invalid json')
        return 'UNKNOWN', 'UNKNOWN'

    try:
        return cve_detail['result']['CVE_Items'][0]['impact']['baseMetricV3']['cvssV3']['baseScore']
    except KeyError as e:
        print('could not decipher things')
        print(e)
        return 'UNKNOWN'
    except IndexError:
        print('could not find cpe information in {}'.format(cve_detail))
        return 'UNKNOWN'


if __name__ == '__main__':
    cves = ['CVE-2020-8908', 'CVE-2020-10683', 'CVE-2019-12402', 'CVE-2019-3802', 'CVE-2020-8840', 'CVE-2020-13933',
            'CVE-2020-11612', 'CVE-2020-9489', 'CVE-2018-10936', 'CVE-2020-13920', 'CVE-2020-5421', 'CVE-2020-5398',
            'CVE-2021-22112', 'CVE-2020-5408', 'CVE-2019-13990', 'CVE-2020-26945', 'CVE-2020-25633', 'CVE-2021-28168',
            'CVE-2021-22134', 'CVE-2021-28165', 'CVE-2020-7226', 'CVE-2020-13935', 'CVE-2020-13949', 'CVE-2020-17530',
            'CVE-2020-17523', 'CVE-2019-12400', 'CVE-2019-12415', 'CVE-2021-27807', 'CVE-2019-12401', 'CVE-2021-26117',
            'CVE-2020-1745', 'CVE-2021-31403', 'CVE-2020-26883', 'CVE-2021-29505', 'CVE-2019-10086', 'CVE-2019-5427',
            'CVE-2020-26168', 'CVE-2020-7692', 'CVE-2019-9212', 'CVE-2021-29442', ]

    for cve in cves:
        cvss = get_cvss_for(cve)
        print(f"UPDATE `vulnerabilities` SET cvss_score = {cvss} WHERE cve = '{cve}'")
