import pickle

import pandas as pd
import requests
from requests.auth import HTTPBasicAuth

from config import BASE_DIR

if __name__ == '__main__':
    # IF CSV
    # df = pd.read_csv(BASE_DIR + '/selection.csv', delimiter=';')
    # df['commit_author_name'] = ''

    # IF PICKLE
    df = pickle.load(open('dataframe_old.p', 'rb'))
    df = df.query('is_fix_update == True and uses_vulnerable_code == True and log_update_delay_Z <= 0')
    df = df[['cve', 'package', 'commit_hash', 'commit_date', 'commit_author', 'new_version', 'full_name']]
    df.columns = ['CVE', 'package', 'commit_hash', 'commit_date', 'commit_author_username', 'new_dependency_version', 'repository']

    for i, row in df.iterrows():
        maintainer = row['repository'].split('/')[0]
        commit_data = requests.get('https://api.github.com/repos/{}/git/commits/{}'.format(row['repository'], row['commit_hash']),
                                   auth=HTTPBasicAuth('Rheddes', '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')).json()
        pr_data = requests.get('https://api.github.com/repos/{}/commits/{}/pulls'.format(row['repository'], row['commit_hash']),
                               auth=HTTPBasicAuth('Rheddes', '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'),
                               headers={'Accept': 'application/vnd.github.groot-preview+json'}
                               ).json()
        user_data = requests.get('https://api.github.com/users/{}'.format(maintainer), auth=HTTPBasicAuth('Rheddes', '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')).json()
        email = commit_data['committer']['email']
        commit_author_name = commit_data['committer']['name']
        if email.endswith('github.com'):
            email = commit_data['author']['email']
            commit_author_name = commit_data['author']['name']
        if email.endswith('github.com') and pr_data and pr_data[0] and pr_data[0]['merge_commit_sha']:
            pr_commit_data = requests.get('https://api.github.com/repos/{}/git/commits/{}'.format(row['repository'], pr_data[0]['merge_commit_sha']),
                                          auth=HTTPBasicAuth('Rheddes', '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')).json()
            email = pr_commit_data['author']['email']
            commit_author_name = pr_commit_data['author']['name']
        if email.endswith('github.com') and user_data and user_data['email']:
            email = user_data['email']
            commit_author_name = user_data['name'] or user_data['login']
        df.at[i, 'commit_author_name'] = commit_author_name
        df.at[i, 'email'] = email
        df.at[i, 'commit_link'] = f'https://github.com/{row["repository"]}/commit/{row["commit_hash"]}'
        df.to_csv('selection_19-7-2021.csv')