import json
from datetime import datetime
from time import sleep

import mysql
import requests
import numpy as np
import pandas as pd
from mysql.connector import connect
from requests import Request
from requests.auth import HTTPBasicAuth
from requests_throttler import BaseThrottler, ThrottledRequest
from sqlalchemy import create_engine
from tqdm import tqdm

from config import http_params
from utils.libraries_api import execute_http_request


if __name__ == '__main__':
    db_connection_str = 'mysql+mysqlconnector://vulnerability-history:secret@localhost:33062/vulnerability-history'
    db_connection = create_engine(db_connection_str)

    df = pd.read_sql("SELECT * FROM repos", con=db_connection)

    with connect(host='localhost', port=33062, user='vulnerability-history', database='vulnerability-history',
                 password='secret') as connection:
        for index, row in df.iterrows():
            print('repo: {} - {}'.format(row['id'], row['full_name']))
            short_name = row['full_name'].split('/')[-1]

            r = execute_http_request(
                Request(method='GET', url='https://libraries.io/api/github/{}/dependencies'.format(row['full_name']),
                        params=http_params)
            )

            if r.json()['fork'] and df[:index]['full_name'].str.contains(short_name).any():
                with connection.cursor() as cursor:
                    cursor.execute(
                        "UPDATE repos SET is_fork=%s WHERE id=%s",
                        [True, row['id']]
                    )
                connection.commit()
            sleep(1)
