import json
from datetime import datetime
import mysql

import numpy as np
import pandas as pd
from mysql.connector import connect
from requests import Request
from requests.auth import HTTPBasicAuth
from requests_throttler import BaseThrottler, ThrottledRequest
from sqlalchemy import create_engine
from tqdm import tqdm

from config import BASE_DIR


def find_commit_info(thing: ThrottledRequest):
    try:
        info = thing.response.json()
    except json.decoder.JSONDecodeError:
        print('error')
        return None, 'Unknown', 'Unknown'
    print(info)
    sha = info.get('sha', 'Unknown')
    author = info.get('author', info.get('committer', {})).get('name', 'Unknown')
    date = info.get('author', info.get('committer', {})).get('date', '1970-01-01T00:00:00Z')
    date = datetime.strptime(date, '%Y-%m-%dT%H:%M:%S%z')
    return sha, author, date


if __name__ == '__main__':
    db_connection_str = 'mysql+mysqlconnector://vulnerability-history:secret@localhost:33062/vulnerability-history'
    db_connection = create_engine(db_connection_str)

    query = """
        SELECT repo_id, full_name as repo_name, commit_hash
FROM updates
INNER JOIN repos r on updates.repo_id = r.id
WHERE ISNULL(commit_date)
GROUP BY commit_hash, full_name
    """
    df = pd.read_sql(query, con=db_connection)

    with connect(host='localhost', port=33062, user='vulnerability-history', database='vulnerability-history',
                 password='secret') as connection:
        for (repo_id, repo_name), commit_df in tqdm(df.groupby(['repo_id', 'repo_name'])):
            commits = commit_df['commit_hash'].to_list()
            print(repo_id)
            print(repo_name)

            with BaseThrottler(name='base-throttler', delay=0.8) as bt:
                dependency_requests = [
                    Request(method='GET', url='https://api.github.com/repos/{}/git/commits/{}'.format(repo_name, commit_hash),
                            auth=HTTPBasicAuth('Rheddes', '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')) for commit_hash in commits]
                throttled_requests = bt.multi_submit(dependency_requests)

            for response in throttled_requests:
                commit_hash, commit_author, commit_date = find_commit_info(response)
                if commit_hash is None:
                    print('skipping')
                    continue
                with connection.cursor() as cursor:
                    cursor.execute(
                        "UPDATE updates SET commit_author=%s, commit_date=%s WHERE repo_id=%s AND commit_hash=%s",
                        [commit_author, commit_date.strftime('%Y-%m-%d'), int(repo_id), commit_hash]
                    )
                connection.commit()
