import logging
from time import sleep

from mysql.connector import connect, DatabaseError
from vulnerability_finder.vulnerability_finder import VulnerabilityFinder


def main(logger):
    with connect(host='vulnerabilitydb', user='dc', database='dependencycheck', password='dc') as vuln_db:
        with connect(host='mysql', user='vulnerability-history', database='vulnerability-history', password='secret') as updates_db:
            vulnerability_finder = VulnerabilityFinder(vuln_db, updates_db, logger, 1000)
            vulnerability_finder.run_continuously()


if __name__ == '__main__':
    logging.getLogger().setLevel(logging.INFO)
    while True:
        try:
            main(logging.getLogger())
        except DatabaseError:
            logging.getLogger().warning('MySql Not ready yet')
            sleep(5)
