import logging
from time import sleep

from mysql.connector import connect, DatabaseError
from repo_scanner.repo_scanner import RepoScanner


def main(logger):
    with connect(host='mysql', user='vulnerability-history', database='vulnerability-history', password='secret') as connection:
        repo_scanner = RepoScanner(connection, logger, 2)
        repo_scanner.run_continuously()


if __name__ == '__main__':
    logging.getLogger().setLevel(logging.INFO)
    while True:
        try:
            main(logging.getLogger())
        except DatabaseError:
            logging.getLogger().warning('MySql Not ready yet')
            sleep(5)
