import logging
from time import sleep

from mysql.connector import connect, DatabaseError

from repo_finder.repo_finder import RepoFinder


def main(logger):
    with connect(host='mysql', user='vulnerability-history', database='vulnerability-history', password='secret') as connection:
        repo_finder = RepoFinder(connection, logger)
        repo_finder.run_continuously()


if __name__ == '__main__':
    logging.getLogger().setLevel(logging.INFO)
    while True:
        try:
            main(logging.getLogger())
        except DatabaseError:
            logging.getLogger().warning('MySql Not ready yet')
            sleep(5)
