USE vulnerability-history;
SET @@time_zone = '+00:00';

CREATE TABLE vulnerabilities
(
    cve                      VARCHAR(255) NOT NULL,
    package_coords           VARCHAR(255) NOT NULL,
    libraries_io_find_prefix VARCHAR(255) NOT NULL,
    first_fix_release_date   DATE         NOT NULL,
    disclosure_date          DATE         NOT NULL,
    samples                  INTEGER      DEFAULT 100,
    status                   VARCHAR(255) DEFAULT 'new'
);

CREATE TABLE repos
(
    id        INTEGER AUTO_INCREMENT,
    cve       VARCHAR(255) NOT NULL,
    full_name VARCHAR(255) NOT NULL,
    pom_path  VARCHAR(255) NOT NULL,
    status    VARCHAR(255) DEFAULT 'new',
    is_fork   TINYINT(1)   NOT NULL,
    is_vulnerable TINYINT(1) NOT NULL DEFAULT 0,
    risk_score DECIMAL(3, 1) NULL,
    PRIMARY KEY (id)
);

CREATE TABLE updates
(
    id               INTEGER AUTO_INCREMENT,
    repo_id          INTEGER,
    cve              VARCHAR(255)  NOT NULL,
    package          VARCHAR(255)  NOT NULL,
    update_delay     INTEGER       NOT NULL,
    commit_hash      VARCHAR(255)  NOT NULL,
    commit_date      DATE          NOT NULL,
    commit_author    VARCHAR(255)  NOT NULL,
    is_fix_update    TINYINT(1)    NOT NULL,
    old_version      VARCHAR(255)  NOT NULL,
    old_release_date DATE          NOT NULL,
    new_version      VARCHAR(255)  NOT NULL,
    new_release_date DATE          NOT NULL,
    cvss_v2          DECIMAL(3, 1) NULL,
    cvss_v3          DECIMAL(3, 1) NULL,
    fixes_cve_id     INTEGER       NULL,
    status           VARCHAR(255) DEFAULT 'new',
    PRIMARY KEY (id)
);

CREATE TABLE cves
(
    id                        int auto_increment PRIMARY KEY,
    cve                       VARCHAR(20) UNIQUE,
    description               VARCHAR(8000),
    v2Severity                VARCHAR(20),
    v2ExploitabilityScore     DECIMAL(3, 1),
    v2ImpactScore             DECIMAL(3, 1),
    v2AcInsufInfo             BOOLEAN,
    v2ObtainAllPrivilege      BOOLEAN,
    v2ObtainUserPrivilege     BOOLEAN,
    v2ObtainOtherPrivilege    BOOLEAN,
    v2UserInteractionRequired BOOLEAN,
    v2Score                   DECIMAL(3, 1),
    v2AccessVector            VARCHAR(20),
    v2AccessComplexity        VARCHAR(20),
    v2Authentication          VARCHAR(20),
    v2ConfidentialityImpact   VARCHAR(20),
    v2IntegrityImpact         VARCHAR(20),
    v2AvailabilityImpact      VARCHAR(20),
    v2Version                 VARCHAR(5),
    v3ExploitabilityScore     DECIMAL(3, 1),
    v3ImpactScore             DECIMAL(3, 1),
    v3AttackVector            VARCHAR(20),
    v3AttackComplexity        VARCHAR(20),
    v3PrivilegesRequired      VARCHAR(20),
    v3UserInteraction         VARCHAR(20),
    v3Scope                   VARCHAR(20),
    v3ConfidentialityImpact   VARCHAR(20),
    v3IntegrityImpact         VARCHAR(20),
    v3AvailabilityImpact      VARCHAR(20),
    v3BaseScore               DECIMAL(3, 1),
    v3BaseSeverity            VARCHAR(20),
    v3Version                 VARCHAR(5)
);

INSERT INTO vulnerabilities (cve, package_coords, libraries_io_find_prefix, first_fix_release_date, samples)
VALUES ('CVE-2020-8908', 'com.google.guava:guava', '30', '2020-08-27', 10);
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (1, 'CVE-2020-8908', 'google/truth', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (2, 'CVE-2020-8908', 'flapdoodle-oss/de.flapdoodle.embed.mongo', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (3, 'CVE-2020-8908', 'google/compile-testing', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (4, 'CVE-2020-8908', 'jqno/equalsverifier', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (5, 'CVE-2020-8908', 'apache/maven-resolver', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (6, 'CVE-2020-8908', 'google/jimfs', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (7, 'CVE-2020-8908', 'bonigarcia/webdrivermanager', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (8, 'CVE-2020-8908', 'code4craft/webmagic', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (9, 'CVE-2020-8908', 'google/google-java-format', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (10, 'CVE-2020-8908', 'snazy/ohc', 'pom.xml', 'new');
INSERT INTO `vulnerability-history`.repos (id, cve, full_name, pom_path, status)
VALUES (11, 'CVE-2020-8908', 'asterisk-java/asterisk-java', 'pom.xml', 'new');
