# Visualisation tools

Combination of scripts used to visualise survey results, risk correlation with update delay, update delays etc.


## Pre-requisites

In order to generate all figures, a connection to the database with dependency update statistics is required.
This Database can be generated using `vulnerability-history` project.

In `.env.example` default values are configured for a DB connection.

```bash
cp .env.example .env
```

Then edit the values in `.env` to correspond with your connection.


### Input files

This project requires several data files, which will be visualised. These can be find in the `data` folder

| file                                | source (from root of repo) | purpose                                                                                                         |
|-------------------------------------| -------------------------- |-----------------------------------------------------------------------------------------------------------------|
| call_graph_stats.csv                | `risk-analyser/src/2_callgraph_stats.py` | Stores basic properties of the reduced callgraphs (no. reachable nodes, edges, vulnerable nodes etc.)           |
| correlation.csv                     | `risk-analyser/src/3_centrality_correlation.py` | The correlation of betweenness & coreachability with an exhaustive search approcah for subgraphs with 100 nodes |
| runtimes_for_projects.csv           | `risk_analyser/src/4_analyse_callgraphs.py` | Contains runtimes and RBO scores for all subgraphs of all call-graphs, with properties of those subgraphs       |
| runtimes_for_projects_100_nodes.csv | `risk_analyser/src/4_analyse_callgraphs.py` | Contains RBO scores for all projects with sub-graphs with 100 nodes |                                            |
| update_data.p                       | `vulnerability-history` | A dump of the update history DB as generated by the `vulnerability-history` scanners                            |
