# Listing of GeoBlacklight .json test documents

If you add a new document, please add it to the table below, and indicate its purpose.

| document | purpose |
| -------- | ------- |
| actual-papermap1 |Nondigitized paper map with a link to a library catalog|
| actual-point1 |Point dataset with WMS and WFS|
| actual-polygon1 |Polygon dataset (no direct download) with WFS, WMS, and FGDC metadata as XML|
| actual-raster1 |Restricted raster layer with WMS and metadata in MODS and ISO 19139|
| baruch_ancestor1 |SQLite Database with documentation download. Referenced as parent|
| baruch_ancestor2 |Geodatabase with documentation download. Referenced as parent|
| baruch_documentation_download |Point dataset with WMS and WFS, documentation download, and two parent records|
| bbox-spans-180 |Scanned map with IIIF and direct TIFF download that spans across the 180th meridian|
| cornell_html_metadata |Point dataset with WMS, WFS, direct download, and FGDC metadata XML and HTML|
| esri-dynamic-layer-single-layer |ArcGIS Dynamic Map Layer with single layer indicated|
| esri-feature-layer |ArcGIS Feature Layer - point dataset|
| esri-image-map-layer |ArcGIS Image Map Layer with GeoTIFF direct download|
| esri-tiled_map_layer |ArcGIS tiled map layer|
| esri-wms-layer |Dataset with ArcGIS Dynamic Map Layer, ArcGIS WMS, and direct download|
| harvard_raster |Raster with WMS and Harvard style download function|
| iiif-eastern-hemisphere |Eastern hemisphere scanned map with IIIF and direct TIFF download|
| index_map_point | GeoJSON index map of points |
| index_map_polygon | GeoJSON index map of polygons, with a downloadUrl for the index itself |
| index_map_polygon-no-downloadurl | GeoJSON index map of polygons, but lacking a downloadUrl for the index itself |
| index-map-stanford | old-style (pre-GeoJSON) index map of rectangular polygons |
| no_spatial |File without geometry type or solr_geometry (will cause error)|
| princeton-child1.json | Child record for testing the `suppressed_b` property |
| princeton-child2.json | Child record for testing the `suppressed_b` property |
| princeton-child3.json | Child record for testing the `suppressed_b` property |
| princeton-child4.json | Child record for testing the `suppressed_b` property |
| princeton-parent.json | Parent record for testing the `suppressed_b` property |
| public_direct_download | includes a tentative `dcat_distribution_sm` property |
| public_iiif_princeton |Scanned map with IIIF|
| public_polygon_mit |Polygon shapefile with WMS and WFS|
| restricted-line |Restricted line layer with WFS, WMS and metadata in MODS and ISO 19139|
| umn_metro_result1.json |Bounding box of metropolitan area and ArcGIS Dynamic Map Layer|
| umn_state_result1.json |Bounding box of state area and static image in references|
| umn_state_result2.json |Bounding box of state area and raster download|
| uva_slug_colon.json | Multipoint dataset with WMS and WFS and a colon in the slug and layer ID |
