# To run CirFix locally on your machine:
        1. Make sure you have access to the Synopsys VCS simulator. An easy way to do so is to type "vcs" in the command line and ensure that the command exists.
                1.1. If you do not have a Synopsys VCS license, you may use a different Verilog simulator. Note, however, that you'd need to update the scripts to match the API of the simulator (by default, we have designed CirFix to work with the API of VCS).
        2. Clone CirFix from GitHub.
        3. Install PyVerilog version 1.2.1 using the following command: "pip3 install —user pyverilog==1.2.1".
        4. Replace PyVerilog files to work with CirFix (see readme in ../pyverilog_changes).
        5. Install iVerilog -> sudo yum install iverilog (for RHEL, command may vary for different operating systems).
        6. Edit repair.conf to provide the parameters for CirFix, including the the source file, TB, etc.
                6.1. Important: Make sure that you replace all instances of user "hammada" or "cirfix" from the file paths to your username, otherwise you will likely get file I/O exceptions. Additionally, make sure that the path leading to "/verilog_repair" is correct.
                6.2. Make sure that the line "seed=..." (line 6 in repair.conf) is commented out if you want to run a fresh trial.
        7. Run "python3 repair.py".
                7.1. Optional: If you want CirFix to keep a log, use the parameter log=true when running repair.py.

# To reproduce the repairs generated by CirFix for a given bug (either on our servers or your local machine):
        1. Look at the experiments_results.xlsx file to get the minimized patch list for the bug.
        2. Edit repair.conf to configure CirFix (see 2.1 and 2.2 below on reproducing trials for more information).
        3. Run "python3 repair.py code_from_patchlist=true".
        4. When prompted, paste the minimized patchlist into the terminal. CirFix will print out the generated Verilog code. You can also verify at this step that the generated code reports "FITNESS = 1.000000", indicating a plausible repair.

# To reproduce an entire trial of CirFix for a repair (either on our servers or your local machine):
        1. Look at the experiments_results.xlsx file to get the seed that produced the repair.
        2. Edit repair.conf to configure CirFix.
                2.1. You need to force the random seed for the relevant CirFix run. You can do so by uncommenting the line "seed=..." (line 6 in repair.conf) and copy-pasting the seed (e.g., repair_2020-09-22-16:01:26) in that line.
                2.2. Important: You also need to set the correct paths for the source file, testbench, etc. We have already included all combinations of configurations you might need. Simply search for the bug name (e.g., first_counter_overflow_wadden_buggy1.v), and uncomment the 6 lines following the bug description. We leave one bug uncommented out (with the proper seed) to help you get started.
        3. Run "python3 repair.py". When CirFix terminates, you will be presented with a minimized patchlist (e.g., "['template(sens_to_posedge,32)']"). This step alone should be sufficient to verify our results in experiments_results.xlsx and Table 3 of the paper.
                3.1. See the steps above to produce the Verilog code corresponding to the repair patchlist, if you are interested.
        
        Note: Try not to concurrently run trials for different bugs associated with the same project. VCS writes temporary files tied to a project during compilation and simulation, and running two concurrent trials on the same circuit (even if with different bugs) can overwrite the temporary files prematurely and contimante results. You may run trials associated with _different_ projects at the same time -- we have modified the underlying source code of PyVerilog to support this. During our experiments, we ran at most two different trials at the same time on one machine (given our limited number of CPU cores). 
        
# Troubleshooting:
        1. If you get a file not found exception immediately after the first simulation, but don't see any other visible errors
                (e.g., FileNotFoundError: [Errno 2] No such file or directory: 'output_lshift_reg_tb_t1.txt'),
        it is likely that the command to run the simulation timed out (due to long compilation times). This is often easily resolved by re-running the repair.py script. 

        2. If the machine seems super slow and unresponsive, run the top command to see if there are any zombie "simv" processes. This may happen due to a bug in VCS. If you see several zombie simv processes (that often use 100% CPU each on one thread), please run the following command:
                nohup bash ~/clean_simv.sh & 
        This command will kill these zombie processes, and the machine should be responsive again.

        If you run into any other issues, feel free to reach out to Hammad Ahmad (hammad@umich.edu).
