/**
* synflood API generated from synflood.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


// TODO: Modify these methods with your own implementation


#include "Stats.h"
#include "Synflood.h"

#include <fstream>

Stats::Stats(Synflood &parent, const StatsJsonObject &conf)
    : StatsBase(parent) {
}

Stats::~Stats() {}

StatsJsonObject Stats::toJsonObject() {
  StatsJsonObject conf;

  updateAllValues();

  std::istringstream ipOutRequestsStream(IpOutRequests);
  std::istringstream ipInDeliversStream(IpInDelivers);
  std::istringstream ipInReceivesStream(IpInReceives);
  uint64_t ipOutRequests_;
  uint64_t ipInDelivers_;
  uint64_t ipInReceives_;
  ipInDeliversStream >> ipInDelivers_;
  ipInReceivesStream >> ipInReceives_;
  ipOutRequestsStream >> ipOutRequests_;
  float deliverRatio = ((float) ipInDelivers_ / ((float) ipInReceives_ + 1.0));
  float responseRatio = ((float)ipOutRequests_ / ((float)ipInReceives_ + 1.0));

  conf.setTcpattemptfails(TcpAttemptFails);
  conf.setTcpoutrsts(TcpOutRsts);
  conf.setDeliverratio(std::to_string(deliverRatio));
  conf.setResponseratio(std::to_string(responseRatio));
  conf.setLastupdate(getLastupdate());

  return conf;
}

std::string Stats::getTcpattemptfails() {
  try {
    getValue(STATISTICS::TCP_ATTEMPT_FAILS);
    return TcpAttemptFails;
  } catch (...) {
    return "-";
  }
}

std::string Stats::getTcpoutrsts() {
  try {
    getValue(STATISTICS::TCP_OUT_RSTS);
    return TcpOutRsts;
  } catch (...) {
    return "-";
  }
}

std::string Stats::getDeliverratio() {
  try {
    getValue(STATISTICS::DELIVER_RATIO);
    std::istringstream ipInDeliversStream(IpInDelivers);
    std::istringstream ipInReceivesStream(IpInReceives);

    uint64_t ipInDelivers_;
    uint64_t ipInReceives_;

    ipInDeliversStream >> ipInDelivers_;
    ipInReceivesStream >> ipInReceives_;

    float ratio = ((float) ipInDelivers_ / ((float) ipInReceives_ + 1.0));
    return std::to_string(ratio);
  } catch (...) {
    return "-";
  }
}

std::string Stats::getResponseratio() {
  try {
    getValue(STATISTICS::RESPONSE_RATIO);
    std::istringstream ipOutRequestsStream(IpOutRequests);
    std::istringstream ipInReceivesStream(IpInReceives);

    uint64_t ipOutRequests_;
    uint64_t ipInReceives_;

    ipOutRequestsStream >> ipOutRequests_;
    ipInReceivesStream >> ipInReceives_;

    float ratio = ((float)ipOutRequests_ / ((float)ipInReceives_ + 1.0));
    return std::to_string(ratio);
  } catch (...) {
    return "-";
  }
}

uint64_t Stats::getLastupdate() {
  return std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::system_clock::now().time_since_epoch()).count();
}

void Stats::updateAllValues() {
  getValue(STATISTICS::ALL_SYNFLOOD_STATS);
}

void Stats::getValue(STATISTICS statistic_type) {
  /*
  (line 0) IP: [1]Forwarding [2]DefaultTTL [3]InReceives [4]InHdrErrors [5]InAddrErrors
          [6]ForwDatagrams [7]InUnknownProtos [8]InDiscards [9]InDelivers [10]OutRequests
          [11]OutDiscards [12]OutNoRoutes [13]ReasmTimeout [14]ReasmReqds [15]ReasmOKs
          [16]ReasmFails [17]FragOKs [18]FragFails [19]FragCreates
  (line 1) IP: [values] x1 ... x19

  (line 2) ICMP: [1]InMsgs [2]InErrors [3]InCsumErrors [4]InDestUnreachs [5]InTimeExcds [6]InParmProbs
          [7]InSrcQuenchs [8]InRedirects [9]InEchos [10]InEchoReps [11]InTimestamps [12]InTimestampReps
          [13]InAddrMasks [14]InAddrMaskReps [15]OutMsgs [16]OutErrors [17]OutDestUnreachs [18]OutTimeExcds
          [19]OutParmProbs [20]OutSrcQuenchs [21]OutRedirects [22]OutEchos [23]OutEchoReps [24]OutTimestamps
          [25]OutTimestampReps [26]OutAddrMasks [27]OutAddrMaskReps
  (line 3) ICMP: [values] x1 ... x27

  (line 4) IcmpMsg: [1]InType3 [2]InType8 [3]InType11 [4]OutType0 [5]OutType3
  (line 5) IcmpMsg: [values] x1 ... x5

  (line 6) Tcp: [1]RtoAlgorithm [2]RtoMin [3]RtoMax [4]MaxConn [5]ActiveOpens [6]PassiveOpens [7]AttemptFails
          [8]EstabResets [9]CurrEstab [10]InSegs [11]OutSegs [12]RetransSegs [13]InErrs [14]OutRsts [15]InCsumErrors
  (line 7) Tcp: [values] x1 ... x15

  (line 8) Udp: [1]InDatagrams [2]NoPorts [3]InErrors [4]OutDatagrams
          [5]RcvbufErrors [6]SndbufErrors [7]InCsumErrors [8]IgnoredMulti
  (line 9) Udp: [values] x1 ... x8

  (line 10) UdpLite: [1]InDatagrams [2]NoPorts [3]InErrors [4]OutDatagrams
          [5]RcvbufErrors [6]SndbufErrors [7]InCsumErrors [8]IgnoredMulti
  (line 11) UdpLite: [values] x1 ... x8
  */

  bool linesOfInterest [11] = {false};

  bool IpValues [19] = {false};
  bool IcmpValues [27] = {false};
  bool IcmpMsgValues [5] = {false};
  bool TcpValues [15] = {false};
  bool UdpValues [8] = {false};
  bool UdpLiteValues [8] = {false};


  switch (statistic_type) {
    case STATISTICS::IP_IN_RECEIVES:
      linesOfInterest[1] = true;
      IpValues[3] = true;
      break;
    case STATISTICS::IP_IN_DELIVERS:
      linesOfInterest[1] = true;
      IpValues[9] = true;
      break;
    case STATISTICS::IP_OUT_REQUESTS:
      linesOfInterest[1] = true;
      IpValues[10] = true;
      break;
    case STATISTICS::TCP_ATTEMPT_FAILS:
      // Tcp line is 3
      linesOfInterest[7] = true;
      TcpValues[7] = true;
      break;
    case STATISTICS::TCP_OUT_RSTS:
      linesOfInterest[7] = true;
      TcpValues[14] = true;
      break;
    case STATISTICS::DELIVER_RATIO:
      linesOfInterest[1] = true;
      IpValues[3] = true;
      IpValues[9] = true;
      break;
    case STATISTICS::RESPONSE_RATIO:
      linesOfInterest[1] = true;
      IpValues[3] = true;
      IpValues[10] = true;
      break;
    case STATISTICS::ALL_SYNFLOOD_STATS:
      // line IP
      linesOfInterest[1] = true;
      IpValues[3] = true;
      IpValues[9] = true;
      IpValues[10] = true;

      // Tcp line is 3
      linesOfInterest[7] = true;
      TcpValues[7] = true;
      TcpValues[14] = true;

      break;
    default:
      throw std::runtime_error("Not valid statistic received");
  }

  std::ifstream infile("/proc/net/snmp");

  int n_line = 0;
  std::string line;
  while (std::getline(infile, line)) {
    if (linesOfInterest[n_line]) {
      std::istringstream line_(line);
      std::vector<std::string> results((std::istream_iterator<std::string>(line_)), std::istream_iterator<std::string>());

      switch (n_line) {
        case 1: // Ip values
          for (int i=0; i < 19; i++) {
            if (IpValues[i] && results.size() >= i) {
              if (i == 3) {
                IpInReceives = results.at(i);
              } else if (i == 9) {
                IpInDelivers = results.at(i);
              } else if (i == 10) {
                IpOutRequests = results.at(i);
              }
            }
          }
          break;
        case 7: // Tcp values
          for (int i=0; i < 15; i++) {
            if (TcpValues[i] && results.size() >= i) {
              if (i == 7) {
                TcpAttemptFails = results.at(i);
              } else if (i == 14) {
                TcpOutRsts = results.at(i);
              }
            }
          }
          break;
      }
    }

    n_line ++;
  }
}
