/**
* simpleforwarder API generated from simpleforwarder.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "SimpleforwarderBase.h"

SimpleforwarderBase::SimpleforwarderBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Simpleforwarder] [%n] [%l] %v");
}



SimpleforwarderBase::~SimpleforwarderBase() {}

void SimpleforwarderBase::update(const SimpleforwarderJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.simpleRedirectIsSet()) {
    setSimpleRedirect(conf.getSimpleRedirect());
  }
  if (conf.actionsIsSet()) {
    for (auto &i : conf.getActions()) {
      auto inport = i.getInport();
      auto m = getActions(inport);
      m->update(i);
    }
  }
}

SimpleforwarderJsonObject SimpleforwarderBase::toJsonObject() {
  SimpleforwarderJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  conf.setDynOpt(getDynOpt());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setSimpleRedirect(getSimpleRedirect());
  for(auto &i : getActionsList()) {
    conf.addActions(i->toJsonObject());
  }

  return conf;
}
void SimpleforwarderBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void SimpleforwarderBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void SimpleforwarderBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void SimpleforwarderBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void SimpleforwarderBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> SimpleforwarderBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> SimpleforwarderBase::getPortsList() {
  return get_ports();
}
void SimpleforwarderBase::addActionsList(const std::vector<ActionsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string inport_ = i.getInport();
    addActions(inport_, i);
  }
}

void SimpleforwarderBase::replaceActions(const std::string &inport, const ActionsJsonObject &conf) {
  delActions(inport);
  std::string inport_ = conf.getInport();
  addActions(inport_, conf);
}

void SimpleforwarderBase::delActionsList() {
  auto elements = getActionsList();
  for (auto &i : elements) {
    std::string inport_ = i->getInport();
    delActions(inport_);
  }
}


