/**
* simplebridge API generated from simplebridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "SimplebridgeBase.h"

SimplebridgeBase::SimplebridgeBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Simplebridge] [%n] [%l] %v");
}



SimplebridgeBase::~SimplebridgeBase() {}

void SimplebridgeBase::update(const SimplebridgeJsonObject &conf) {
  Cube::set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.fdbIsSet()) {
    auto m = getFdb();
    m->update(conf.getFdb());
  }
}

SimplebridgeJsonObject SimplebridgeBase::toJsonObject() {
  SimplebridgeJsonObject conf;
  conf.setBase(Cube::to_json());

  conf.setName(getName());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setFdb(getFdb()->toJsonObject());

  return conf;
}
void SimplebridgeBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void SimplebridgeBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void SimplebridgeBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void SimplebridgeBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void SimplebridgeBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> SimplebridgeBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> SimplebridgeBase::getPortsList() {
  return get_ports();
}

void SimplebridgeBase::replaceFdb(const FdbJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delFdb();
  addFdb(conf);
}


