/**
* simplebridge API generated from simplebridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "FdbBase.h"
#include "../Simplebridge.h"


FdbBase::FdbBase(Simplebridge &parent)
    : parent_(parent) {}

FdbBase::~FdbBase() {}

void FdbBase::update(const FdbJsonObject &conf) {

  if (conf.agingTimeIsSet()) {
    setAgingTime(conf.getAgingTime());
  }
  if (conf.entryIsSet()) {
    for (auto &i : conf.getEntry()) {
      auto address = i.getAddress();
      auto m = getEntry(address);
      m->update(i);
    }
  }
}

FdbJsonObject FdbBase::toJsonObject() {
  FdbJsonObject conf;

  conf.setAgingTime(getAgingTime());
  for(auto &i : getEntryList()) {
    conf.addFdbEntry(i->toJsonObject());
  }

  return conf;
}
void FdbBase::addEntryList(const std::vector<FdbEntryJsonObject> &conf) {
  for (auto &i : conf) {
    std::string address_ = i.getAddress();
    addEntry(address_, i);
  }
}

void FdbBase::replaceEntry(const std::string &address, const FdbEntryJsonObject &conf) {
  delEntry(address);
  std::string address_ = conf.getAddress();
  addEntry(address_, conf);
}

void FdbBase::delEntryList() {
  auto elements = getEntryList();
  for (auto &i : elements) {
    std::string address_ = i->getAddress();
    delEntry(address_);
  }
}

std::shared_ptr<spdlog::logger> FdbBase::logger() {
  return parent_.logger();
}

