/**
* simplebridge API generated from simplebridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "SimplebridgeApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace SimplebridgeApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Simplebridge>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Simplebridge> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_simplebridge_by_id(const std::string &name, const SimplebridgeJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Simplebridge>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Simplebridge>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_simplebridge_by_id(const std::string &name, const SimplebridgeJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_simplebridge_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<SimplebridgeJsonObject> read_simplebridge_list_by_id() {
  std::vector<SimplebridgeJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_simplebridge_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create fdb by ID
*
* Create operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
create_simplebridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto simplebridge = get_cube(name);

  simplebridge->addFdb(value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_simplebridge_fdb_entry_by_id(const std::string &name, const std::string &address, const FdbEntryJsonObject &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();

  fdb->addEntry(address, value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_simplebridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  fdb->addEntryList(value);
}

/**
* @brief   Create flush by ID
*
* Create operation of resource: flush*
*
* @param[in] name ID of name
*
* Responses:
* FdbFlushOutputJsonObject
*/
FdbFlushOutputJsonObject
create_simplebridge_fdb_flush_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
return fdb->flush();

}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_simplebridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto simplebridge = get_cube(name);

  simplebridge->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_simplebridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto simplebridge = get_cube(name);
  simplebridge->addPortsList(value);
}

/**
* @brief   Delete fdb by ID
*
* Delete operation of resource: fdb*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_simplebridge_fdb_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);

  simplebridge->delFdb();
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
*
*/
void
delete_simplebridge_fdb_entry_by_id(const std::string &name, const std::string &address) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();

  fdb->delEntry(address);
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_simplebridge_fdb_entry_list_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  fdb->delEntryList();
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_simplebridge_ports_by_id(const std::string &name, const std::string &portsName) {
  auto simplebridge = get_cube(name);

  simplebridge->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_simplebridge_ports_list_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  simplebridge->delPortsList();
}

/**
* @brief   Read simplebridge by ID
*
* Read operation of resource: simplebridge*
*
* @param[in] name ID of name
*
* Responses:
* SimplebridgeJsonObject
*/
SimplebridgeJsonObject
read_simplebridge_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read aging-time by ID
*
* Read operation of resource: aging-time*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_simplebridge_fdb_aging_time_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  return fdb->getAgingTime();

}

/**
* @brief   Read fdb by ID
*
* Read operation of resource: fdb*
*
* @param[in] name ID of name
*
* Responses:
* FdbJsonObject
*/
FdbJsonObject
read_simplebridge_fdb_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  return simplebridge->getFdb()->toJsonObject();

}

/**
* @brief   Read age by ID
*
* Read operation of resource: age*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* uint32_t
*/
uint32_t
read_simplebridge_fdb_entry_age_by_id(const std::string &name, const std::string &address) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  auto entry = fdb->getEntry(address);
  return entry->getAge();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* FdbEntryJsonObject
*/
FdbEntryJsonObject
read_simplebridge_fdb_entry_by_id(const std::string &name, const std::string &address) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  return fdb->getEntry(address)->toJsonObject();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<FdbEntryJsonObject>
*/
std::vector<FdbEntryJsonObject>
read_simplebridge_fdb_entry_list_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  auto &&entry = fdb->getEntryList();
  std::vector<FdbEntryJsonObject> m;
  for(auto &i : entry)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read port by ID
*
* Read operation of resource: port*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* std::string
*/
std::string
read_simplebridge_fdb_entry_port_by_id(const std::string &name, const std::string &address) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  auto entry = fdb->getEntry(address);
  return entry->getPort();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_simplebridge_ports_by_id(const std::string &name, const std::string &portsName) {
  auto simplebridge = get_cube(name);
  return simplebridge->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_simplebridge_ports_list_by_id(const std::string &name) {
  auto simplebridge = get_cube(name);
  auto &&ports = simplebridge->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}


/**
* @brief   Replace fdb by ID
*
* Replace operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
replace_simplebridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto simplebridge = get_cube(name);

  simplebridge->replaceFdb(value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_simplebridge_fdb_entry_by_id(const std::string &name, const std::string &address, const FdbEntryJsonObject &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();

  fdb->replaceEntry(address, value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_simplebridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_simplebridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto simplebridge = get_cube(name);

  simplebridge->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_simplebridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update simplebridge by ID
*
* Update operation of resource: simplebridge*
*
* @param[in] name ID of name
* @param[in] value simplebridgebody object
*
* Responses:
*
*/
void
update_simplebridge_by_id(const std::string &name, const SimplebridgeJsonObject &value) {
  auto simplebridge = get_cube(name);

  simplebridge->update(value);
}

/**
* @brief   Update aging-time by ID
*
* Update operation of resource: aging-time*
*
* @param[in] name ID of name
* @param[in] value Aging time of the filtering database (in seconds)
*
* Responses:
*
*/
void
update_simplebridge_fdb_aging_time_by_id(const std::string &name, const uint32_t &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();

  fdb->setAgingTime(value);
}

/**
* @brief   Update fdb by ID
*
* Update operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
update_simplebridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();

  fdb->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_simplebridge_fdb_entry_by_id(const std::string &name, const std::string &address, const FdbEntryJsonObject &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  auto entry = fdb->getEntry(address);

  entry->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_simplebridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update port by ID
*
* Update operation of resource: port*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value Output port name
*
* Responses:
*
*/
void
update_simplebridge_fdb_entry_port_by_id(const std::string &name, const std::string &address, const std::string &value) {
  auto simplebridge = get_cube(name);
  auto fdb = simplebridge->getFdb();
  auto entry = fdb->getEntry(address);

  entry->setPort(value);
}

/**
* @brief   Update simplebridge by ID
*
* Update operation of resource: simplebridge*
*
* @param[in] value simplebridgebody object
*
* Responses:
*
*/
void
update_simplebridge_list_by_id(const std::vector<SimplebridgeJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_simplebridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto simplebridge = get_cube(name);
  auto ports = simplebridge->getPorts(portsName);

  ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_simplebridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_simplebridge_fdb_entry_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&simplebridge = get_cube(name);
  auto &&fdb = simplebridge->getFdb();

  auto &&entry = fdb->getEntryList();
  for(auto &i : entry) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["address"] = i->getAddress();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_simplebridge_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&simplebridge = get_cube(name);

  auto &&ports = simplebridge->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

