/**
* router API generated from router.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* RouterBase.h
*
*
*/

#pragma once

#include "../serializer/RouterJsonObject.h"

#include "../ArpTable.h"
#include "../Ports.h"
#include "../Route.h"

#include "polycube/services/cube.h"
#include "polycube/services/port.h"



#include "polycube/services/utils.h"
#include "polycube/services/fifo_map.hpp"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;


class RouterBase: public virtual polycube::service::Cube<Ports> {
 public:
  RouterBase(const std::string name);
  
  virtual ~RouterBase();
  virtual void update(const RouterJsonObject &conf);
  virtual RouterJsonObject toJsonObject();

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name);
  virtual std::vector<std::shared_ptr<Ports>> getPortsList();
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf);
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf);
  virtual void replacePorts(const std::string &name, const PortsJsonObject &conf);
  virtual void delPorts(const std::string &name);
  virtual void delPortsList();

  /// <summary>
  /// Entry associated with the routing table
  /// </summary>
  virtual std::shared_ptr<Route> getRoute(const std::string &network, const std::string &nexthop) = 0;
  virtual std::vector<std::shared_ptr<Route>> getRouteList() = 0;
  virtual void addRoute(const std::string &network, const std::string &nexthop, const RouteJsonObject &conf) = 0;
  virtual void addRouteList(const std::vector<RouteJsonObject> &conf);
  virtual void replaceRoute(const std::string &network, const std::string &nexthop, const RouteJsonObject &conf);
  virtual void delRoute(const std::string &network,const std::string &nexthop) = 0;
  virtual void delRouteList();

  /// <summary>
  /// Entry associated with the ARP table
  /// </summary>
  virtual std::shared_ptr<ArpTable> getArpTable(const std::string &address) = 0;
  virtual std::vector<std::shared_ptr<ArpTable>> getArpTableList() = 0;
  virtual void addArpTable(const std::string &address, const ArpTableJsonObject &conf) = 0;
  virtual void addArpTableList(const std::vector<ArpTableJsonObject> &conf);
  virtual void replaceArpTable(const std::string &address, const ArpTableJsonObject &conf);
  virtual void delArpTable(const std::string &address) = 0;
  virtual void delArpTableList();
};
