/**
* router API generated from router.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "RouterBase.h"

RouterBase::RouterBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Router] [%n] [%l] %v");
}



RouterBase::~RouterBase() {}

void RouterBase::update(const RouterJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.routeIsSet()) {
    for (auto &i : conf.getRoute()) {
      auto network = i.getNetwork();
      auto nexthop = i.getNexthop();
      auto m = getRoute(network, nexthop);
      m->update(i);
    }
  }
  if (conf.arpTableIsSet()) {
    for (auto &i : conf.getArpTable()) {
      auto address = i.getAddress();
      auto m = getArpTable(address);
      m->update(i);
    }
  }
}

RouterJsonObject RouterBase::toJsonObject() {
  RouterJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  for(auto &i : getRouteList()) {
    conf.addRoute(i->toJsonObject());
  }
  for(auto &i : getArpTableList()) {
    conf.addArpTable(i->toJsonObject());
  }

  return conf;
}
void RouterBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void RouterBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void RouterBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void RouterBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void RouterBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> RouterBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> RouterBase::getPortsList() {
  return get_ports();
}
void RouterBase::addRouteList(const std::vector<RouteJsonObject> &conf) {
  for (auto &i : conf) {
    std::string network_ = i.getNetwork();
    std::string nexthop_ = i.getNexthop();
    addRoute(network_, nexthop_, i);
  }
}

void RouterBase::replaceRoute(const std::string &network, const std::string &nexthop, const RouteJsonObject &conf) {
  delRoute(network, nexthop);
  std::string network_ = conf.getNetwork();
  std::string nexthop_ = conf.getNexthop();
  addRoute(network_, nexthop_, conf);
}

void RouterBase::delRouteList() {
  auto elements = getRouteList();
  for (auto &i : elements) {
    std::string network_ = i->getNetwork();
    std::string nexthop_ = i->getNexthop();
    delRoute(network_, nexthop_);
  }
}
void RouterBase::addArpTableList(const std::vector<ArpTableJsonObject> &conf) {
  for (auto &i : conf) {
    std::string address_ = i.getAddress();
    addArpTable(address_, i);
  }
}

void RouterBase::replaceArpTable(const std::string &address, const ArpTableJsonObject &conf) {
  delArpTable(address);
  std::string address_ = conf.getAddress();
  addArpTable(address_, conf);
}

void RouterBase::delArpTableList() {
  auto elements = getArpTableList();
  for (auto &i : elements) {
    std::string address_ = i->getAddress();
    delArpTable(address_);
  }
}


