/**
* router API generated from router.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "PortsBase.h"
#include "../Router.h"

PortsBase::PortsBase(polycube::service::Cube<Ports> &parent,
    std::shared_ptr<polycube::service::PortIface> port)
    : Port(port), parent_(dynamic_cast<Router &>(parent)) {}


PortsBase::~PortsBase() {}

void PortsBase::update(const PortsJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.ipIsSet()) {
    setIp(conf.getIp());
  }
  if (conf.secondaryipIsSet()) {
    for (auto &i : conf.getSecondaryip()) {
      auto ip = i.getIp();
      auto m = getSecondaryip(ip);
      m->update(i);
    }
  }
  if (conf.macIsSet()) {
    setMac(conf.getMac());
  }
}

PortsJsonObject PortsBase::toJsonObject() {
  PortsJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  conf.setIp(getIp());
  for(auto &i : getSecondaryipList()) {
    conf.addPortsSecondaryip(i->toJsonObject());
  }
  conf.setMac(getMac());

  return conf;
}
void PortsBase::addSecondaryipList(const std::vector<PortsSecondaryipJsonObject> &conf) {
  for (auto &i : conf) {
    std::string ip_ = i.getIp();
    addSecondaryip(ip_, i);
  }
}

void PortsBase::replaceSecondaryip(const std::string &ip, const PortsSecondaryipJsonObject &conf) {
  delSecondaryip(ip);
  std::string ip_ = conf.getIp();
  addSecondaryip(ip_, conf);
}

void PortsBase::delSecondaryipList() {
  auto elements = getSecondaryipList();
  for (auto &i : elements) {
    std::string ip_ = i->getIp();
    delSecondaryip(ip_);
  }
}

std::shared_ptr<spdlog::logger> PortsBase::logger() {
  return parent_.logger();
}

