/**
* router API generated from router.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "RouterApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace RouterApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Router>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Router> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_router_by_id(const std::string &name, const RouterJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Router>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Router>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_router_by_id(const std::string &name, const RouterJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_router_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<RouterJsonObject> read_router_list_by_id() {
  std::vector<RouterJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_router_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create arp-table by ID
*
* Create operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
create_router_arp_table_by_id(const std::string &name, const std::string &address, const ArpTableJsonObject &value) {
  auto router = get_cube(name);

  return router->addArpTable(address, value);
}

/**
* @brief   Create arp-table by ID
*
* Create operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
create_router_arp_table_list_by_id(const std::string &name, const std::vector<ArpTableJsonObject> &value) {
  auto router = get_cube(name);
  router->addArpTableList(value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_router_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto router = get_cube(name);

  return router->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_router_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto router = get_cube(name);
  router->addPortsList(value);
}

/**
* @brief   Create secondaryip by ID
*
* Create operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] ip ID of ip
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
create_router_ports_secondaryip_by_id(const std::string &name, const std::string &portsName, const std::string &ip, const PortsSecondaryipJsonObject &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->addSecondaryip(ip, value);
}

/**
* @brief   Create secondaryip by ID
*
* Create operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
create_router_ports_secondaryip_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsSecondaryipJsonObject> &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  ports->addSecondaryipList(value);
}

/**
* @brief   Create route by ID
*
* Create operation of resource: route*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
* @param[in] value routebody object
*
* Responses:
*
*/
void
create_router_route_by_id(const std::string &name, const std::string &network, const std::string &nexthop, const RouteJsonObject &value) {
  auto router = get_cube(name);

  return router->addRoute(network, nexthop, value);
}

/**
* @brief   Create route by ID
*
* Create operation of resource: route*
*
* @param[in] name ID of name
* @param[in] value routebody object
*
* Responses:
*
*/
void
create_router_route_list_by_id(const std::string &name, const std::vector<RouteJsonObject> &value) {
  auto router = get_cube(name);
  router->addRouteList(value);
}

/**
* @brief   Delete arp-table by ID
*
* Delete operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
*
*/
void
delete_router_arp_table_by_id(const std::string &name, const std::string &address) {
  auto router = get_cube(name);

  return router->delArpTable(address);
}

/**
* @brief   Delete arp-table by ID
*
* Delete operation of resource: arp-table*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_router_arp_table_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  router->delArpTableList();
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_router_ports_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);

  return router->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_router_ports_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  router->delPortsList();
}

/**
* @brief   Delete secondaryip by ID
*
* Delete operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] ip ID of ip
*
* Responses:
*
*/
void
delete_router_ports_secondaryip_by_id(const std::string &name, const std::string &portsName, const std::string &ip) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->delSecondaryip(ip);
}

/**
* @brief   Delete secondaryip by ID
*
* Delete operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_router_ports_secondaryip_list_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  ports->delSecondaryipList();
}

/**
* @brief   Delete route by ID
*
* Delete operation of resource: route*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
*
* Responses:
*
*/
void
delete_router_route_by_id(const std::string &name, const std::string &network, const std::string &nexthop) {
  auto router = get_cube(name);

  return router->delRoute(network, nexthop);
}

/**
* @brief   Delete route by ID
*
* Delete operation of resource: route*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_router_route_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  router->delRouteList();
}

/**
* @brief   Read arp-table by ID
*
* Read operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* ArpTableJsonObject
*/
ArpTableJsonObject
read_router_arp_table_by_id(const std::string &name, const std::string &address) {
  auto router = get_cube(name);
  return router->getArpTable(address)->toJsonObject();

}

/**
* @brief   Read interface by ID
*
* Read operation of resource: interface*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* std::string
*/
std::string
read_router_arp_table_interface_by_id(const std::string &name, const std::string &address) {
  auto router = get_cube(name);
  auto arpTable = router->getArpTable(address);
  return arpTable->getInterface();

}

/**
* @brief   Read arp-table by ID
*
* Read operation of resource: arp-table*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<ArpTableJsonObject>
*/
std::vector<ArpTableJsonObject>
read_router_arp_table_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  auto &&arpTable = router->getArpTableList();
  std::vector<ArpTableJsonObject> m;
  for(auto &i : arpTable)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read mac by ID
*
* Read operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* std::string
*/
std::string
read_router_arp_table_mac_by_id(const std::string &name, const std::string &address) {
  auto router = get_cube(name);
  auto arpTable = router->getArpTable(address);
  return arpTable->getMac();

}

/**
* @brief   Read router by ID
*
* Read operation of resource: router*
*
* @param[in] name ID of name
*
* Responses:
* RouterJsonObject
*/
RouterJsonObject
read_router_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_router_ports_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);
  return router->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ip by ID
*
* Read operation of resource: ip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::string
*/
std::string
read_router_ports_ip_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  return ports->getIp();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_router_ports_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  auto &&ports = router->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read mac by ID
*
* Read operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::string
*/
std::string
read_router_ports_mac_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  return ports->getMac();

}

/**
* @brief   Read secondaryip by ID
*
* Read operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] ip ID of ip
*
* Responses:
* PortsSecondaryipJsonObject
*/
PortsSecondaryipJsonObject
read_router_ports_secondaryip_by_id(const std::string &name, const std::string &portsName, const std::string &ip) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  return ports->getSecondaryip(ip)->toJsonObject();

}

/**
* @brief   Read secondaryip by ID
*
* Read operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::vector<PortsSecondaryipJsonObject>
*/
std::vector<PortsSecondaryipJsonObject>
read_router_ports_secondaryip_list_by_id(const std::string &name, const std::string &portsName) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  auto &&secondaryip = ports->getSecondaryipList();
  std::vector<PortsSecondaryipJsonObject> m;
  for(auto &i : secondaryip)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read route by ID
*
* Read operation of resource: route*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
*
* Responses:
* RouteJsonObject
*/
RouteJsonObject
read_router_route_by_id(const std::string &name, const std::string &network, const std::string &nexthop) {
  auto router = get_cube(name);
  return router->getRoute(network, nexthop)->toJsonObject();

}

/**
* @brief   Read interface by ID
*
* Read operation of resource: interface*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
*
* Responses:
* std::string
*/
std::string
read_router_route_interface_by_id(const std::string &name, const std::string &network, const std::string &nexthop) {
  auto router = get_cube(name);
  auto route = router->getRoute(network, nexthop);
  return route->getInterface();

}

/**
* @brief   Read route by ID
*
* Read operation of resource: route*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<RouteJsonObject>
*/
std::vector<RouteJsonObject>
read_router_route_list_by_id(const std::string &name) {
  auto router = get_cube(name);
  auto &&route = router->getRouteList();
  std::vector<RouteJsonObject> m;
  for(auto &i : route)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read pathcost by ID
*
* Read operation of resource: pathcost*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
*
* Responses:
* uint32_t
*/
uint32_t
read_router_route_pathcost_by_id(const std::string &name, const std::string &network, const std::string &nexthop) {
  auto router = get_cube(name);
  auto route = router->getRoute(network, nexthop);
  return route->getPathcost();

}

/**
* @brief   Replace arp-table by ID
*
* Replace operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
replace_router_arp_table_by_id(const std::string &name, const std::string &address, const ArpTableJsonObject &value) {
  auto router = get_cube(name);

  return router->replaceArpTable(address, value);
}

/**
* @brief   Replace arp-table by ID
*
* Replace operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
replace_router_arp_table_list_by_id(const std::string &name, const std::vector<ArpTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_router_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto router = get_cube(name);

  return router->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_router_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace secondaryip by ID
*
* Replace operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] ip ID of ip
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
replace_router_ports_secondaryip_by_id(const std::string &name, const std::string &portsName, const std::string &ip, const PortsSecondaryipJsonObject &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->replaceSecondaryip(ip, value);
}

/**
* @brief   Replace secondaryip by ID
*
* Replace operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
replace_router_ports_secondaryip_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsSecondaryipJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace route by ID
*
* Replace operation of resource: route*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
* @param[in] value routebody object
*
* Responses:
*
*/
void
replace_router_route_by_id(const std::string &name, const std::string &network, const std::string &nexthop, const RouteJsonObject &value) {
  auto router = get_cube(name);

  return router->replaceRoute(network, nexthop, value);
}

/**
* @brief   Replace route by ID
*
* Replace operation of resource: route*
*
* @param[in] name ID of name
* @param[in] value routebody object
*
* Responses:
*
*/
void
replace_router_route_list_by_id(const std::string &name, const std::vector<RouteJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update arp-table by ID
*
* Update operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
update_router_arp_table_by_id(const std::string &name, const std::string &address, const ArpTableJsonObject &value) {
  auto router = get_cube(name);
  auto arpTable = router->getArpTable(address);

  return arpTable->update(value);
}

/**
* @brief   Update interface by ID
*
* Update operation of resource: interface*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value Outgoing interface
*
* Responses:
*
*/
void
update_router_arp_table_interface_by_id(const std::string &name, const std::string &address, const std::string &value) {
  auto router = get_cube(name);
  auto arpTable = router->getArpTable(address);

  return arpTable->setInterface(value);
}

/**
* @brief   Update arp-table by ID
*
* Update operation of resource: arp-table*
*
* @param[in] name ID of name
* @param[in] value arp-tablebody object
*
* Responses:
*
*/
void
update_router_arp_table_list_by_id(const std::string &name, const std::vector<ArpTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update mac by ID
*
* Update operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value Destination MAC address
*
* Responses:
*
*/
void
update_router_arp_table_mac_by_id(const std::string &name, const std::string &address, const std::string &value) {
  auto router = get_cube(name);
  auto arpTable = router->getArpTable(address);

  return arpTable->setMac(value);
}

/**
* @brief   Update router by ID
*
* Update operation of resource: router*
*
* @param[in] name ID of name
* @param[in] value routerbody object
*
* Responses:
*
*/
void
update_router_by_id(const std::string &name, const RouterJsonObject &value) {
  auto router = get_cube(name);

  return router->update(value);
}

/**
* @brief   Update router by ID
*
* Update operation of resource: router*
*
* @param[in] value routerbody object
*
* Responses:
*
*/
void
update_router_list_by_id(const std::vector<RouterJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_router_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->update(value);
}

/**
* @brief   Update ip by ID
*
* Update operation of resource: ip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value IP address and prefix of the port
*
* Responses:
*
*/
void
update_router_ports_ip_by_id(const std::string &name, const std::string &portsName, const std::string &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->setIp(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_router_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update mac by ID
*
* Update operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value MAC address of the port
*
* Responses:
*
*/
void
update_router_ports_mac_by_id(const std::string &name, const std::string &portsName, const std::string &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);

  return ports->setMac(value);
}

/**
* @brief   Update secondaryip by ID
*
* Update operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] ip ID of ip
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
update_router_ports_secondaryip_by_id(const std::string &name, const std::string &portsName, const std::string &ip, const PortsSecondaryipJsonObject &value) {
  auto router = get_cube(name);
  auto ports = router->getPorts(portsName);
  auto secondaryip = ports->getSecondaryip(ip);

  return secondaryip->update(value);
}

/**
* @brief   Update secondaryip by ID
*
* Update operation of resource: secondaryip*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value secondaryipbody object
*
* Responses:
*
*/
void
update_router_ports_secondaryip_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsSecondaryipJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update route by ID
*
* Update operation of resource: route*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
* @param[in] value routebody object
*
* Responses:
*
*/
void
update_router_route_by_id(const std::string &name, const std::string &network, const std::string &nexthop, const RouteJsonObject &value) {
  auto router = get_cube(name);
  auto route = router->getRoute(network, nexthop);

  return route->update(value);
}

/**
* @brief   Update route by ID
*
* Update operation of resource: route*
*
* @param[in] name ID of name
* @param[in] value routebody object
*
* Responses:
*
*/
void
update_router_route_list_by_id(const std::string &name, const std::vector<RouteJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update pathcost by ID
*
* Update operation of resource: pathcost*
*
* @param[in] name ID of name
* @param[in] network ID of network
* @param[in] nexthop ID of nexthop
* @param[in] value Cost of this route
*
* Responses:
*
*/
void
update_router_route_pathcost_by_id(const std::string &name, const std::string &network, const std::string &nexthop, const uint32_t &value) {
  auto router = get_cube(name);
  auto route = router->getRoute(network, nexthop);

  return route->setPathcost(value);
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_router_arp_table_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&router = get_cube(name);

  auto &&arpTable = router->getArpTableList();
  for(auto &i : arpTable) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["address"] = i->getAddress();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_router_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&router = get_cube(name);

  auto &&ports = router->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_router_ports_secondaryip_list_by_id_get_list(const std::string &name, const std::string &portsName) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&router = get_cube(name);
  auto &&ports = router->getPorts(portsName);

  auto &&secondaryip = ports->getSecondaryipList();
  for(auto &i : secondaryip) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_router_route_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&router = get_cube(name);

  auto &&route = router->getRouteList();
  for(auto &i : route) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["network"] = i->getNetwork();
    keys["nexthop"] = i->getNexthop();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

