/*
 * Copyright 2018 The Polycube Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "../base/PortsSecondaryipBase.h"

class Ports;

using namespace polycube::service::model;

class PortsSecondaryip : public PortsSecondaryipBase {
 public:
  PortsSecondaryip(Ports &parent, const PortsSecondaryipJsonObject &conf);
  virtual ~PortsSecondaryip();

  /// <summary>
  /// Secondary IP address and prefix of the port
  /// </summary>
  std::string getIp() override;

  // The following methods have been added manually

  static void createInControlPlane(Ports &parent, const std::string &ip,
                                   const PortsSecondaryipJsonObject &conf);

  bool operator<(const PortsSecondaryip &p) const {
    return std::tie(ip_) < std::tie(p.ip_);
  }

 private:
  // The following variables have been added manually
  std::string ip_;
};
