/**
* pbforwarder API
* pbforwarder API generated from pbforwarder.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "PbforwarderApi.h"
#include "PbforwarderApiImpl.h"

using namespace io::swagger::server::model;
using namespace io::swagger::server::api::PbforwarderApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_pbforwarder_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PbforwarderJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_pbforwarder_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_pbforwarder_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    create_pbforwarder_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_pbforwarder_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    create_pbforwarder_ports_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_pbforwarder_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulesJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_pbforwarder_rules_by_id(unique_name, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_pbforwarder_rules_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulesJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulesJsonObject> unique_value;
    for (auto &j : request_body) {
      RulesJsonObject a { j };
      unique_value.push_back(a);
    }
    create_pbforwarder_rules_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_pbforwarder_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_pbforwarder_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_pbforwarder_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_pbforwarder_ports_by_id(unique_name, unique_portsName);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_pbforwarder_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_pbforwarder_ports_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_pbforwarder_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_pbforwarder_rules_by_id(unique_name, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_pbforwarder_rules_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_pbforwarder_rules_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_pbforwarder_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_pbforwarder_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_pbforwarder_ports_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_pbforwarder_ports_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_action_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = RulesJsonObject::RulesActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_dst_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_dst_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_dst_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_dst_mac_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_dst_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_dst_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_in_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_in_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_l4_proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_l4_proto_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = RulesJsonObject::RulesL4ProtoEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_pbforwarder_rules_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_out_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_out_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_src_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_src_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_src_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_src_mac_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_src_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_src_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_pbforwarder_rules_vlan_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_pbforwarder_rules_vlan_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_pbforwarder_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PbforwarderJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_pbforwarder_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_pbforwarder_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    replace_pbforwarder_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_pbforwarder_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_pbforwarder_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_pbforwarder_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulesJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_pbforwarder_rules_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_pbforwarder_rules_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulesJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulesJsonObject> unique_value;
    for (auto &j : request_body) {
      RulesJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_pbforwarder_rules_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PbforwarderJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_pbforwarder_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<PbforwarderJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PbforwarderJsonObject> unique_value;
    for (auto &j : request_body) {
      PbforwarderJsonObject a { j };
      unique_value.push_back(a);
    }
    update_pbforwarder_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    update_pbforwarder_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    update_pbforwarder_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    RulesActionEnum unique_value_ = RulesJsonObject::string_to_RulesActionEnum(request_body);
    update_pbforwarder_rules_action_by_id(unique_name, unique_id, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulesJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_pbforwarder_rules_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_dst_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_dst_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_dst_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_dst_mac_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_dst_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_pbforwarder_rules_dst_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_in_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_in_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_l4_proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    RulesL4ProtoEnum unique_value_ = RulesJsonObject::string_to_RulesL4ProtoEnum(request_body);
    update_pbforwarder_rules_l4_proto_by_id(unique_name, unique_id, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulesJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulesJsonObject> unique_value;
    for (auto &j : request_body) {
      RulesJsonObject a { j };
      unique_value.push_back(a);
    }
    update_pbforwarder_rules_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_out_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_out_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_src_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_src_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_src_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_pbforwarder_rules_src_mac_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_src_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_pbforwarder_rules_src_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_pbforwarder_rules_vlan_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_pbforwarder_rules_vlan_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response pbforwarder_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_pbforwarder_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response pbforwarder_ports_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_pbforwarder_ports_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response pbforwarder_rules_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_pbforwarder_rules_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

