/**
* packetcapture API generated from packetcapture.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "PacketcaptureApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace PacketcaptureApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Packetcapture>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Packetcapture> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_packetcapture_by_id(const std::string &name, const PacketcaptureJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Packetcapture>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Packetcapture>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_packetcapture_by_id(const std::string &name, const PacketcaptureJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_packetcapture_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<PacketcaptureJsonObject> read_packetcapture_list_by_id() {
  std::vector<PacketcaptureJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_packetcapture_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create globalheader by ID
*
* Create operation of resource: globalheader*
*
* @param[in] name ID of name
* @param[in] value globalheaderbody object
*
* Responses:
*
*/
void
create_packetcapture_globalheader_by_id(const std::string &name, const GlobalheaderJsonObject &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->addGlobalheader(value);
}

/**
* @brief   Create packet by ID
*
* Create operation of resource: packet*
*
* @param[in] name ID of name
* @param[in] value packetbody object
*
* Responses:
*
*/
void
create_packetcapture_packet_by_id(const std::string &name, const PacketJsonObject &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->addPacket(value);
}

/**
* @brief   Delete globalheader by ID
*
* Delete operation of resource: globalheader*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_packetcapture_globalheader_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);

  return packetcapture->delGlobalheader();
}

/**
* @brief   Delete packet by ID
*
* Delete operation of resource: packet*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_packetcapture_packet_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);

  return packetcapture->delPacket();
}

/**
* @brief   Read anonimize by ID
*
* Read operation of resource: anonimize*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_packetcapture_anonimize_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getAnonimize();

}

/**
* @brief   Read packetcapture by ID
*
* Read operation of resource: packetcapture*
*
* @param[in] name ID of name
*
* Responses:
* PacketcaptureJsonObject
*/
PacketcaptureJsonObject
read_packetcapture_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read capture by ID
*
* Read operation of resource: capture*
*
* @param[in] name ID of name
*
* Responses:
* PacketcaptureCaptureEnum
*/
PacketcaptureCaptureEnum
read_packetcapture_capture_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getCapture();

}

/**
* @brief   Read dump by ID
*
* Read operation of resource: dump*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_packetcapture_dump_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getDump();

}

/**
* @brief   Read filter by ID
*
* Read operation of resource: filter*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_packetcapture_filter_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getFilter();

}

/**
* @brief   Read globalheader by ID
*
* Read operation of resource: globalheader*
*
* @param[in] name ID of name
*
* Responses:
* GlobalheaderJsonObject
*/
GlobalheaderJsonObject
read_packetcapture_globalheader_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getGlobalheader()->toJsonObject();

}

/**
* @brief   Read linktype by ID
*
* Read operation of resource: linktype*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_globalheader_linktype_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getLinktype();

}

/**
* @brief   Read magic by ID
*
* Read operation of resource: magic*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_globalheader_magic_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getMagic();

}

/**
* @brief   Read sigfigs by ID
*
* Read operation of resource: sigfigs*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_globalheader_sigfigs_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getSigfigs();

}

/**
* @brief   Read snaplen by ID
*
* Read operation of resource: snaplen*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_globalheader_snaplen_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getSnaplen();

}

/**
* @brief   Read thiszone by ID
*
* Read operation of resource: thiszone*
*
* @param[in] name ID of name
*
* Responses:
* int32_t
*/
int32_t
read_packetcapture_globalheader_thiszone_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getThiszone();

}

/**
* @brief   Read version_major by ID
*
* Read operation of resource: version_major*
*
* @param[in] name ID of name
*
* Responses:
* uint16_t
*/
uint16_t
read_packetcapture_globalheader_version_major_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getVersionMajor();

}

/**
* @brief   Read version_minor by ID
*
* Read operation of resource: version_minor*
*
* @param[in] name ID of name
*
* Responses:
* uint16_t
*/
uint16_t
read_packetcapture_globalheader_version_minor_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();
  return globalheader->getVersionMinor();

}

/**
* @brief   Read networkmode by ID
*
* Read operation of resource: networkmode*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_packetcapture_networkmode_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getNetworkmode();

}

/**
* @brief   Read packet by ID
*
* Read operation of resource: packet*
*
* @param[in] name ID of name
*
* Responses:
* PacketJsonObject
*/
PacketJsonObject
read_packetcapture_packet_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getPacket()->toJsonObject();

}

/**
* @brief   Read capturelen by ID
*
* Read operation of resource: capturelen*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_packet_capturelen_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();
  return packet->getCapturelen();

}

/**
* @brief   Read packetlen by ID
*
* Read operation of resource: packetlen*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_packet_packetlen_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();
  return packet->getPacketlen();

}

/**
* @brief   Read rawdata by ID
*
* Read operation of resource: rawdata*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_packetcapture_packet_rawdata_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();
  return packet->getRawdata();

}

/**
* @brief   Read timestamp-microseconds by ID
*
* Read operation of resource: timestamp-microseconds*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_packet_timestamp_microseconds_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();
  return packet->getTimestampMicroseconds();

}

/**
* @brief   Read timestamp-seconds by ID
*
* Read operation of resource: timestamp-seconds*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_packet_timestamp_seconds_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();
  return packet->getTimestampSeconds();

}

/**
* @brief   Read snaplen by ID
*
* Read operation of resource: snaplen*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_packetcapture_snaplen_by_id(const std::string &name) {
  auto packetcapture = get_cube(name);
  return packetcapture->getSnaplen();

}

/**
* @brief   Replace globalheader by ID
*
* Replace operation of resource: globalheader*
*
* @param[in] name ID of name
* @param[in] value globalheaderbody object
*
* Responses:
*
*/
void
replace_packetcapture_globalheader_by_id(const std::string &name, const GlobalheaderJsonObject &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->replaceGlobalheader(value);
}

/**
* @brief   Replace packet by ID
*
* Replace operation of resource: packet*
*
* @param[in] name ID of name
* @param[in] value packetbody object
*
* Responses:
*
*/
void
replace_packetcapture_packet_by_id(const std::string &name, const PacketJsonObject &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->replacePacket(value);
}

/**
* @brief   Update anonimize by ID
*
* Update operation of resource: anonimize*
*
* @param[in] name ID of name
* @param[in] value anonimizebody object
*
* Responses:
*
*/
void
update_packetcapture_anonimize_by_id(const std::string &name, const bool &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setAnonimize(value);
}

/**
* @brief   Update packetcapture by ID
*
* Update operation of resource: packetcapture*
*
* @param[in] name ID of name
* @param[in] value packetcapturebody object
*
* Responses:
*
*/
void
update_packetcapture_by_id(const std::string &name, const PacketcaptureJsonObject &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->update(value);
}

/**
* @brief   Update capture by ID
*
* Update operation of resource: capture*
*
* @param[in] name ID of name
* @param[in] value Packet capture status
*
* Responses:
*
*/
void
update_packetcapture_capture_by_id(const std::string &name, const PacketcaptureCaptureEnum &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setCapture(value);
}

/**
* @brief   Update dump by ID
*
* Update operation of resource: dump*
*
* @param[in] name ID of name
* @param[in] value dump capture
*
* Responses:
*
*/
void
update_packetcapture_dump_by_id(const std::string &name, const std::string &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setDump(value);
}

/**
* @brief   Update filter by ID
*
* Update operation of resource: filter*
*
* @param[in] name ID of name
* @param[in] value filtering string (e.g., 'host 1.2.3.4 and src port 80')
*
* Responses:
*
*/
void
update_packetcapture_filter_by_id(const std::string &name, const std::string &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setFilter(value);
}

/**
* @brief   Update globalheader by ID
*
* Update operation of resource: globalheader*
*
* @param[in] name ID of name
* @param[in] value globalheaderbody object
*
* Responses:
*
*/
void
update_packetcapture_globalheader_by_id(const std::string &name, const GlobalheaderJsonObject &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->update(value);
}

/**
* @brief   Update linktype by ID
*
* Update operation of resource: linktype*
*
* @param[in] name ID of name
* @param[in] value Capture linktype (eg. ethernet, wifi..)
*
* Responses:
*
*/
void
update_packetcapture_globalheader_linktype_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setLinktype(value);
}

/**
* @brief   Update magic by ID
*
* Update operation of resource: magic*
*
* @param[in] name ID of name
* @param[in] value magic number
*
* Responses:
*
*/
void
update_packetcapture_globalheader_magic_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setMagic(value);
}

/**
* @brief   Update sigfigs by ID
*
* Update operation of resource: sigfigs*
*
* @param[in] name ID of name
* @param[in] value accuracy of timestamps
*
* Responses:
*
*/
void
update_packetcapture_globalheader_sigfigs_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setSigfigs(value);
}

/**
* @brief   Update snaplen by ID
*
* Update operation of resource: snaplen*
*
* @param[in] name ID of name
* @param[in] value max length of captured packets, in octets
*
* Responses:
*
*/
void
update_packetcapture_globalheader_snaplen_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setSnaplen(value);
}

/**
* @brief   Update thiszone by ID
*
* Update operation of resource: thiszone*
*
* @param[in] name ID of name
* @param[in] value GMT to local correction
*
* Responses:
*
*/
void
update_packetcapture_globalheader_thiszone_by_id(const std::string &name, const int32_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setThiszone(value);
}

/**
* @brief   Update version_major by ID
*
* Update operation of resource: version_major*
*
* @param[in] name ID of name
* @param[in] value major version number
*
* Responses:
*
*/
void
update_packetcapture_globalheader_version_major_by_id(const std::string &name, const uint16_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setVersionMajor(value);
}

/**
* @brief   Update version_minor by ID
*
* Update operation of resource: version_minor*
*
* @param[in] name ID of name
* @param[in] value minor version number
*
* Responses:
*
*/
void
update_packetcapture_globalheader_version_minor_by_id(const std::string &name, const uint16_t &value) {
  auto packetcapture = get_cube(name);
  auto globalheader = packetcapture->getGlobalheader();

  return globalheader->setVersionMinor(value);
}

/**
* @brief   Update packetcapture by ID
*
* Update operation of resource: packetcapture*
*
* @param[in] value packetcapturebody object
*
* Responses:
*
*/
void
update_packetcapture_list_by_id(const std::vector<PacketcaptureJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update networkmode by ID
*
* Update operation of resource: networkmode*
*
* @param[in] name ID of name
* @param[in] value Operating mode
*
* Responses:
*
*/
void
update_packetcapture_networkmode_by_id(const std::string &name, const bool &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setNetworkmode(value);
}

/**
* @brief   Update packet by ID
*
* Update operation of resource: packet*
*
* @param[in] name ID of name
* @param[in] value packetbody object
*
* Responses:
*
*/
void
update_packetcapture_packet_by_id(const std::string &name, const PacketJsonObject &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->update(value);
}

/**
* @brief   Update capturelen by ID
*
* Update operation of resource: capturelen*
*
* @param[in] name ID of name
* @param[in] value Capture length
*
* Responses:
*
*/
void
update_packetcapture_packet_capturelen_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->setCapturelen(value);
}

/**
* @brief   Update packetlen by ID
*
* Update operation of resource: packetlen*
*
* @param[in] name ID of name
* @param[in] value Packet length
*
* Responses:
*
*/
void
update_packetcapture_packet_packetlen_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->setPacketlen(value);
}

/**
* @brief   Update rawdata by ID
*
* Update operation of resource: rawdata*
*
* @param[in] name ID of name
* @param[in] value packet raw data
*
* Responses:
*
*/
void
update_packetcapture_packet_rawdata_by_id(const std::string &name, const std::string &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->setRawdata(value);
}

/**
* @brief   Update timestamp-microseconds by ID
*
* Update operation of resource: timestamp-microseconds*
*
* @param[in] name ID of name
* @param[in] value timestamp - microseconds
*
* Responses:
*
*/
void
update_packetcapture_packet_timestamp_microseconds_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->setTimestampMicroseconds(value);
}

/**
* @brief   Update timestamp-seconds by ID
*
* Update operation of resource: timestamp-seconds*
*
* @param[in] name ID of name
* @param[in] value timestamp - seconds
*
* Responses:
*
*/
void
update_packetcapture_packet_timestamp_seconds_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);
  auto packet = packetcapture->getPacket();

  return packet->setTimestampSeconds(value);
}

/**
* @brief   Update snaplen by ID
*
* Update operation of resource: snaplen*
*
* @param[in] name ID of name
* @param[in] value Snapshot length
*
* Responses:
*
*/
void
update_packetcapture_snaplen_by_id(const std::string &name, const uint32_t &value) {
  auto packetcapture = get_cube(name);

  return packetcapture->setSnaplen(value);
}



/*
 * help related
 */


}

}
}
}

