/**
* nat API
* nat API generated from nat.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */



#include "NattingTableJsonObject.h"
#include <regex>

namespace io {
namespace swagger {
namespace server {
namespace model {

NattingTableJsonObject::NattingTableJsonObject() {
  m_internalSrcIsSet = false;
  m_internalDstIsSet = false;
  m_internalSportIsSet = false;
  m_internalDportIsSet = false;
  m_protoIsSet = false;
  m_originatingRuleIsSet = false;
  m_externalIpIsSet = false;
  m_externalPortIsSet = false;
}

NattingTableJsonObject::NattingTableJsonObject(const nlohmann::json &val) :
  JsonObjectBase(val) {
  m_internalSrcIsSet = false;
  m_internalDstIsSet = false;
  m_internalSportIsSet = false;
  m_internalDportIsSet = false;
  m_protoIsSet = false;
  m_originatingRuleIsSet = false;
  m_externalIpIsSet = false;
  m_externalPortIsSet = false;


  if (val.count("internal-src")) {
    setInternalSrc(val.at("internal-src").get<std::string>());
  }

  if (val.count("internal-dst")) {
    setInternalDst(val.at("internal-dst").get<std::string>());
  }

  if (val.count("internal-sport")) {
    setInternalSport(val.at("internal-sport").get<uint16_t>());
  }

  if (val.count("internal-dport")) {
    setInternalDport(val.at("internal-dport").get<uint16_t>());
  }

  if (val.count("proto")) {
    setProto(val.at("proto").get<std::string>());
  }

  if (val.count("originating-rule")) {
    setOriginatingRule(string_to_NattingTableOriginatingRuleEnum(val.at("originating-rule").get<std::string>()));
  }

  if (val.count("external-ip")) {
    setExternalIp(val.at("external-ip").get<std::string>());
  }

  if (val.count("external-port")) {
    setExternalPort(val.at("external-port").get<uint16_t>());
  }
}

nlohmann::json NattingTableJsonObject::toJson() const {
  nlohmann::json val = nlohmann::json::object();
  if (!getBase().is_null()) {
    val.update(getBase());
  }

  if (m_internalSrcIsSet) {
    val["internal-src"] = m_internalSrc;
  }

  if (m_internalDstIsSet) {
    val["internal-dst"] = m_internalDst;
  }

  if (m_internalSportIsSet) {
    val["internal-sport"] = m_internalSport;
  }

  if (m_internalDportIsSet) {
    val["internal-dport"] = m_internalDport;
  }

  if (m_protoIsSet) {
    val["proto"] = m_proto;
  }

  if (m_originatingRuleIsSet) {
    val["originating-rule"] = NattingTableOriginatingRuleEnum_to_string(m_originatingRule);
  }

  if (m_externalIpIsSet) {
    val["external-ip"] = m_externalIp;
  }

  if (m_externalPortIsSet) {
    val["external-port"] = m_externalPort;
  }

  return val;
}

std::string NattingTableJsonObject::getInternalSrc() const {
  return m_internalSrc;
}

void NattingTableJsonObject::setInternalSrc(std::string value) {
  m_internalSrc = value;
  m_internalSrcIsSet = true;
}

bool NattingTableJsonObject::internalSrcIsSet() const {
  return m_internalSrcIsSet;
}



std::string NattingTableJsonObject::getInternalDst() const {
  return m_internalDst;
}

void NattingTableJsonObject::setInternalDst(std::string value) {
  m_internalDst = value;
  m_internalDstIsSet = true;
}

bool NattingTableJsonObject::internalDstIsSet() const {
  return m_internalDstIsSet;
}



uint16_t NattingTableJsonObject::getInternalSport() const {
  return m_internalSport;
}

void NattingTableJsonObject::setInternalSport(uint16_t value) {
  m_internalSport = value;
  m_internalSportIsSet = true;
}

bool NattingTableJsonObject::internalSportIsSet() const {
  return m_internalSportIsSet;
}



uint16_t NattingTableJsonObject::getInternalDport() const {
  return m_internalDport;
}

void NattingTableJsonObject::setInternalDport(uint16_t value) {
  m_internalDport = value;
  m_internalDportIsSet = true;
}

bool NattingTableJsonObject::internalDportIsSet() const {
  return m_internalDportIsSet;
}



std::string NattingTableJsonObject::getProto() const {
  return m_proto;
}

void NattingTableJsonObject::setProto(std::string value) {
  m_proto = value;
  m_protoIsSet = true;
}

bool NattingTableJsonObject::protoIsSet() const {
  return m_protoIsSet;
}



NattingTableOriginatingRuleEnum NattingTableJsonObject::getOriginatingRule() const {
  return m_originatingRule;
}

void NattingTableJsonObject::setOriginatingRule(NattingTableOriginatingRuleEnum value) {
  m_originatingRule = value;
  m_originatingRuleIsSet = true;
}

bool NattingTableJsonObject::originatingRuleIsSet() const {
  return m_originatingRuleIsSet;
}

void NattingTableJsonObject::unsetOriginatingRule() {
  m_originatingRuleIsSet = false;
}

std::string NattingTableJsonObject::NattingTableOriginatingRuleEnum_to_string(const NattingTableOriginatingRuleEnum &value){
  switch(value) {
    case NattingTableOriginatingRuleEnum::SNAT:
      return std::string("snat");
    case NattingTableOriginatingRuleEnum::DNAT:
      return std::string("dnat");
    case NattingTableOriginatingRuleEnum::MASQUERADE:
      return std::string("masquerade");
    case NattingTableOriginatingRuleEnum::PORTFORWARDING:
      return std::string("portforwarding");
    default:
      throw std::runtime_error("Bad NattingTable originatingRule");
  }
}

NattingTableOriginatingRuleEnum NattingTableJsonObject::string_to_NattingTableOriginatingRuleEnum(const std::string &str){
  if (JsonObjectBase::iequals("snat", str))
    return NattingTableOriginatingRuleEnum::SNAT;
  if (JsonObjectBase::iequals("dnat", str))
    return NattingTableOriginatingRuleEnum::DNAT;
  if (JsonObjectBase::iequals("masquerade", str))
    return NattingTableOriginatingRuleEnum::MASQUERADE;
  if (JsonObjectBase::iequals("portforwarding", str))
    return NattingTableOriginatingRuleEnum::PORTFORWARDING;
  throw std::runtime_error("NattingTable originatingRule is invalid");
}
std::string NattingTableJsonObject::getExternalIp() const {
  return m_externalIp;
}

void NattingTableJsonObject::setExternalIp(std::string value) {
  m_externalIp = value;
  m_externalIpIsSet = true;
}

bool NattingTableJsonObject::externalIpIsSet() const {
  return m_externalIpIsSet;
}

void NattingTableJsonObject::unsetExternalIp() {
  m_externalIpIsSet = false;
}

uint16_t NattingTableJsonObject::getExternalPort() const {
  return m_externalPort;
}

void NattingTableJsonObject::setExternalPort(uint16_t value) {
  m_externalPort = value;
  m_externalPortIsSet = true;
}

bool NattingTableJsonObject::externalPortIsSet() const {
  return m_externalPortIsSet;
}

void NattingTableJsonObject::unsetExternalPort() {
  m_externalPortIsSet = false;
}


}
}
}
}

