/**
* nat API
* nat API generated from nat.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "NatApiImpl.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

namespace NatApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Nat>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Nat> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_nat_by_id(const std::string &name, const NatJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Nat>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Nat>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_nat_by_id(const std::string &name, const NatJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_nat_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<NatJsonObject> read_nat_list_by_id() {
  std::vector<NatJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_nat_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create natting-table by ID
*
* Create operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
create_nat_natting_table_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const NattingTableJsonObject &value) {
  auto nat = get_cube(name);

  nat->addNattingTable(internalSrc, internalDst, internalSport, internalDport, proto, value);
}

/**
* @brief   Create natting-table by ID
*
* Create operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
create_nat_natting_table_list_by_id(const std::string &name, const std::vector<NattingTableJsonObject> &value) {
  auto nat = get_cube(name);
  nat->addNattingTableList(value);
}

/**
* @brief   Create rule by ID
*
* Create operation of resource: rule*
*
* @param[in] name ID of name
* @param[in] value rulebody object
*
* Responses:
*
*/
void
create_nat_rule_by_id(const std::string &name, const RuleJsonObject &value) {
  auto nat = get_cube(name);

  nat->addRule(value);
}

/**
* @brief   Create append by ID
*
* Create operation of resource: append*
*
* @param[in] name ID of name
* @param[in] value appendbody object
*
* Responses:
* RuleDnatAppendOutputJsonObject
*/
RuleDnatAppendOutputJsonObject
create_nat_rule_dnat_append_by_id(const std::string &name, const RuleDnatAppendInputJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
return dnat->append(value);

}

/**
* @brief   Create dnat by ID
*
* Create operation of resource: dnat*
*
* @param[in] name ID of name
* @param[in] value dnatbody object
*
* Responses:
*
*/
void
create_nat_rule_dnat_by_id(const std::string &name, const RuleDnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->addDnat(value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_dnat_entry_by_id(const std::string &name, const uint32_t &id, const RuleDnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();

  dnat->addEntry(id, value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_dnat_entry_list_by_id(const std::string &name, const std::vector<RuleDnatEntryJsonObject> &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  dnat->addEntryList(value);
}

/**
* @brief   Create masquerade by ID
*
* Create operation of resource: masquerade*
*
* @param[in] name ID of name
* @param[in] value masqueradebody object
*
* Responses:
*
*/
void
create_nat_rule_masquerade_by_id(const std::string &name, const RuleMasqueradeJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->addMasquerade(value);
}

/**
* @brief   Create disable by ID
*
* Create operation of resource: disable*
*
* @param[in] name ID of name
*
* Responses:
* RuleMasqueradeDisableOutputJsonObject
*/
RuleMasqueradeDisableOutputJsonObject
create_nat_rule_masquerade_disable_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto masquerade = rule->getMasquerade();
return masquerade->disable();

}

/**
* @brief   Create enable by ID
*
* Create operation of resource: enable*
*
* @param[in] name ID of name
*
* Responses:
* RuleMasqueradeEnableOutputJsonObject
*/
RuleMasqueradeEnableOutputJsonObject
create_nat_rule_masquerade_enable_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto masquerade = rule->getMasquerade();
return masquerade->enable();

}

/**
* @brief   Create append by ID
*
* Create operation of resource: append*
*
* @param[in] name ID of name
* @param[in] value appendbody object
*
* Responses:
* RulePortForwardingAppendOutputJsonObject
*/
RulePortForwardingAppendOutputJsonObject
create_nat_rule_port_forwarding_append_by_id(const std::string &name, const RulePortForwardingAppendInputJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
return portForwarding->append(value);

}

/**
* @brief   Create port-forwarding by ID
*
* Create operation of resource: port-forwarding*
*
* @param[in] name ID of name
* @param[in] value port-forwardingbody object
*
* Responses:
*
*/
void
create_nat_rule_port_forwarding_by_id(const std::string &name, const RulePortForwardingJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->addPortForwarding(value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_port_forwarding_entry_by_id(const std::string &name, const uint32_t &id, const RulePortForwardingEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();

  portForwarding->addEntry(id, value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_port_forwarding_entry_list_by_id(const std::string &name, const std::vector<RulePortForwardingEntryJsonObject> &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  portForwarding->addEntryList(value);
}

/**
* @brief   Create append by ID
*
* Create operation of resource: append*
*
* @param[in] name ID of name
* @param[in] value appendbody object
*
* Responses:
* RuleSnatAppendOutputJsonObject
*/
RuleSnatAppendOutputJsonObject
create_nat_rule_snat_append_by_id(const std::string &name, const RuleSnatAppendInputJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
return snat->append(value);

}

/**
* @brief   Create snat by ID
*
* Create operation of resource: snat*
*
* @param[in] name ID of name
* @param[in] value snatbody object
*
* Responses:
*
*/
void
create_nat_rule_snat_by_id(const std::string &name, const RuleSnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->addSnat(value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_snat_entry_by_id(const std::string &name, const uint32_t &id, const RuleSnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();

  snat->addEntry(id, value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_nat_rule_snat_entry_list_by_id(const std::string &name, const std::vector<RuleSnatEntryJsonObject> &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  snat->addEntryList(value);
}

/**
* @brief   Delete natting-table by ID
*
* Delete operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_nat_natting_table_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto) {
  auto nat = get_cube(name);

  nat->delNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);
}

/**
* @brief   Delete natting-table by ID
*
* Delete operation of resource: natting-table*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_natting_table_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  nat->delNattingTableList();
}

/**
* @brief   Delete rule by ID
*
* Delete operation of resource: rule*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_by_id(const std::string &name) {
  auto nat = get_cube(name);

  nat->delRule();
}

/**
* @brief   Delete dnat by ID
*
* Delete operation of resource: dnat*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_dnat_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->delDnat();
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
*
*/
void
delete_nat_rule_dnat_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();

  dnat->delEntry(id);
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_dnat_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  dnat->delEntryList();
}

/**
* @brief   Delete masquerade by ID
*
* Delete operation of resource: masquerade*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_masquerade_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->delMasquerade();
}

/**
* @brief   Delete port-forwarding by ID
*
* Delete operation of resource: port-forwarding*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_port_forwarding_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->delPortForwarding();
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
*
*/
void
delete_nat_rule_port_forwarding_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();

  portForwarding->delEntry(id);
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_port_forwarding_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  portForwarding->delEntryList();
}

/**
* @brief   Delete snat by ID
*
* Delete operation of resource: snat*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_snat_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->delSnat();
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
*
*/
void
delete_nat_rule_snat_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();

  snat->delEntry(id);
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_nat_rule_snat_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  snat->delEntryList();
}

/**
* @brief   Read nat by ID
*
* Read operation of resource: nat*
*
* @param[in] name ID of name
*
* Responses:
* NatJsonObject
*/
NatJsonObject
read_nat_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read natting-table by ID
*
* Read operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
*
* Responses:
* NattingTableJsonObject
*/
NattingTableJsonObject
read_nat_natting_table_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto) {
  auto nat = get_cube(name);
  return nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto)->toJsonObject();

}

/**
* @brief   Read external-ip by ID
*
* Read operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
*
* Responses:
* std::string
*/
std::string
read_nat_natting_table_external_ip_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);
  return nattingTable->getExternalIp();

}

/**
* @brief   Read external-port by ID
*
* Read operation of resource: external-port*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
*
* Responses:
* uint16_t
*/
uint16_t
read_nat_natting_table_external_port_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);
  return nattingTable->getExternalPort();

}

/**
* @brief   Read natting-table by ID
*
* Read operation of resource: natting-table*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<NattingTableJsonObject>
*/
std::vector<NattingTableJsonObject>
read_nat_natting_table_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto &&nattingTable = nat->getNattingTableList();
  std::vector<NattingTableJsonObject> m;
  for(auto &i : nattingTable)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read originating-rule by ID
*
* Read operation of resource: originating-rule*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
*
* Responses:
* NattingTableOriginatingRuleEnum
*/
NattingTableOriginatingRuleEnum
read_nat_natting_table_originating_rule_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);
  return nattingTable->getOriginatingRule();

}

/**
* @brief   Read rule by ID
*
* Read operation of resource: rule*
*
* @param[in] name ID of name
*
* Responses:
* RuleJsonObject
*/
RuleJsonObject
read_nat_rule_by_id(const std::string &name) {
  auto nat = get_cube(name);
  return nat->getRule()->toJsonObject();

}

/**
* @brief   Read dnat by ID
*
* Read operation of resource: dnat*
*
* @param[in] name ID of name
*
* Responses:
* RuleDnatJsonObject
*/
RuleDnatJsonObject
read_nat_rule_dnat_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  return rule->getDnat()->toJsonObject();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* RuleDnatEntryJsonObject
*/
RuleDnatEntryJsonObject
read_nat_rule_dnat_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  return dnat->getEntry(id)->toJsonObject();

}

/**
* @brief   Read external-ip by ID
*
* Read operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_dnat_entry_external_ip_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto entry = dnat->getEntry(id);
  return entry->getExternalIp();

}

/**
* @brief   Read internal-ip by ID
*
* Read operation of resource: internal-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_dnat_entry_internal_ip_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto entry = dnat->getEntry(id);
  return entry->getInternalIp();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<RuleDnatEntryJsonObject>
*/
std::vector<RuleDnatEntryJsonObject>
read_nat_rule_dnat_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto &&entry = dnat->getEntryList();
  std::vector<RuleDnatEntryJsonObject> m;
  for(auto &i : entry)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read masquerade by ID
*
* Read operation of resource: masquerade*
*
* @param[in] name ID of name
*
* Responses:
* RuleMasqueradeJsonObject
*/
RuleMasqueradeJsonObject
read_nat_rule_masquerade_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  return rule->getMasquerade()->toJsonObject();

}

/**
* @brief   Read enabled by ID
*
* Read operation of resource: enabled*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_nat_rule_masquerade_enabled_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto masquerade = rule->getMasquerade();
  return masquerade->getEnabled();

}

/**
* @brief   Read port-forwarding by ID
*
* Read operation of resource: port-forwarding*
*
* @param[in] name ID of name
*
* Responses:
* RulePortForwardingJsonObject
*/
RulePortForwardingJsonObject
read_nat_rule_port_forwarding_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  return rule->getPortForwarding()->toJsonObject();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* RulePortForwardingEntryJsonObject
*/
RulePortForwardingEntryJsonObject
read_nat_rule_port_forwarding_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  return portForwarding->getEntry(id)->toJsonObject();

}

/**
* @brief   Read external-ip by ID
*
* Read operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_port_forwarding_entry_external_ip_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);
  return entry->getExternalIp();

}

/**
* @brief   Read external-port by ID
*
* Read operation of resource: external-port*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* uint16_t
*/
uint16_t
read_nat_rule_port_forwarding_entry_external_port_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);
  return entry->getExternalPort();

}

/**
* @brief   Read internal-ip by ID
*
* Read operation of resource: internal-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_port_forwarding_entry_internal_ip_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);
  return entry->getInternalIp();

}

/**
* @brief   Read internal-port by ID
*
* Read operation of resource: internal-port*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* uint16_t
*/
uint16_t
read_nat_rule_port_forwarding_entry_internal_port_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);
  return entry->getInternalPort();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<RulePortForwardingEntryJsonObject>
*/
std::vector<RulePortForwardingEntryJsonObject>
read_nat_rule_port_forwarding_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto &&entry = portForwarding->getEntryList();
  std::vector<RulePortForwardingEntryJsonObject> m;
  for(auto &i : entry)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read proto by ID
*
* Read operation of resource: proto*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_port_forwarding_entry_proto_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);
  return entry->getProto();

}

/**
* @brief   Read snat by ID
*
* Read operation of resource: snat*
*
* @param[in] name ID of name
*
* Responses:
* RuleSnatJsonObject
*/
RuleSnatJsonObject
read_nat_rule_snat_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  return rule->getSnat()->toJsonObject();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* RuleSnatEntryJsonObject
*/
RuleSnatEntryJsonObject
read_nat_rule_snat_entry_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  return snat->getEntry(id)->toJsonObject();

}

/**
* @brief   Read external-ip by ID
*
* Read operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_snat_entry_external_ip_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto entry = snat->getEntry(id);
  return entry->getExternalIp();

}

/**
* @brief   Read internal-net by ID
*
* Read operation of resource: internal-net*
*
* @param[in] name ID of name
* @param[in] id ID of id
*
* Responses:
* std::string
*/
std::string
read_nat_rule_snat_entry_internal_net_by_id(const std::string &name, const uint32_t &id) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto entry = snat->getEntry(id);
  return entry->getInternalNet();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<RuleSnatEntryJsonObject>
*/
std::vector<RuleSnatEntryJsonObject>
read_nat_rule_snat_entry_list_by_id(const std::string &name) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto &&entry = snat->getEntryList();
  std::vector<RuleSnatEntryJsonObject> m;
  for(auto &i : entry)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Replace natting-table by ID
*
* Replace operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
replace_nat_natting_table_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const NattingTableJsonObject &value) {
  auto nat = get_cube(name);

  nat->replaceNattingTable(internalSrc, internalDst, internalSport, internalDport, proto, value);
}

/**
* @brief   Replace natting-table by ID
*
* Replace operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
replace_nat_natting_table_list_by_id(const std::string &name, const std::vector<NattingTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace rule by ID
*
* Replace operation of resource: rule*
*
* @param[in] name ID of name
* @param[in] value rulebody object
*
* Responses:
*
*/
void
replace_nat_rule_by_id(const std::string &name, const RuleJsonObject &value) {
  auto nat = get_cube(name);

  nat->replaceRule(value);
}

/**
* @brief   Replace dnat by ID
*
* Replace operation of resource: dnat*
*
* @param[in] name ID of name
* @param[in] value dnatbody object
*
* Responses:
*
*/
void
replace_nat_rule_dnat_by_id(const std::string &name, const RuleDnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->replaceDnat(value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_dnat_entry_by_id(const std::string &name, const uint32_t &id, const RuleDnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();

  dnat->replaceEntry(id, value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_dnat_entry_list_by_id(const std::string &name, const std::vector<RuleDnatEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace masquerade by ID
*
* Replace operation of resource: masquerade*
*
* @param[in] name ID of name
* @param[in] value masqueradebody object
*
* Responses:
*
*/
void
replace_nat_rule_masquerade_by_id(const std::string &name, const RuleMasqueradeJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->replaceMasquerade(value);
}

/**
* @brief   Replace port-forwarding by ID
*
* Replace operation of resource: port-forwarding*
*
* @param[in] name ID of name
* @param[in] value port-forwardingbody object
*
* Responses:
*
*/
void
replace_nat_rule_port_forwarding_by_id(const std::string &name, const RulePortForwardingJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->replacePortForwarding(value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_port_forwarding_entry_by_id(const std::string &name, const uint32_t &id, const RulePortForwardingEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();

  portForwarding->replaceEntry(id, value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_port_forwarding_entry_list_by_id(const std::string &name, const std::vector<RulePortForwardingEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace snat by ID
*
* Replace operation of resource: snat*
*
* @param[in] name ID of name
* @param[in] value snatbody object
*
* Responses:
*
*/
void
replace_nat_rule_snat_by_id(const std::string &name, const RuleSnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->replaceSnat(value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_snat_entry_by_id(const std::string &name, const uint32_t &id, const RuleSnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();

  snat->replaceEntry(id, value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_nat_rule_snat_entry_list_by_id(const std::string &name, const std::vector<RuleSnatEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update nat by ID
*
* Update operation of resource: nat*
*
* @param[in] name ID of name
* @param[in] value natbody object
*
* Responses:
*
*/
void
update_nat_by_id(const std::string &name, const NatJsonObject &value) {
  auto nat = get_cube(name);

  nat->update(value);
}

/**
* @brief   Update nat by ID
*
* Update operation of resource: nat*
*
* @param[in] value natbody object
*
* Responses:
*
*/
void
update_nat_list_by_id(const std::vector<NatJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update natting-table by ID
*
* Update operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
update_nat_natting_table_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const NattingTableJsonObject &value) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);

  nattingTable->update(value);
}

/**
* @brief   Update external-ip by ID
*
* Update operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value Translated IP address
*
* Responses:
*
*/
void
update_nat_natting_table_external_ip_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const std::string &value) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);

  nattingTable->setExternalIp(value);
}

/**
* @brief   Update external-port by ID
*
* Update operation of resource: external-port*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value Translated L4 port number
*
* Responses:
*
*/
void
update_nat_natting_table_external_port_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const uint16_t &value) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);

  nattingTable->setExternalPort(value);
}

/**
* @brief   Update natting-table by ID
*
* Update operation of resource: natting-table*
*
* @param[in] name ID of name
* @param[in] value natting-tablebody object
*
* Responses:
*
*/
void
update_nat_natting_table_list_by_id(const std::string &name, const std::vector<NattingTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update originating-rule by ID
*
* Update operation of resource: originating-rule*
*
* @param[in] name ID of name
* @param[in] internalSrc ID of internal-src
* @param[in] internalDst ID of internal-dst
* @param[in] internalSport ID of internal-sport
* @param[in] internalDport ID of internal-dport
* @param[in] proto ID of proto
* @param[in] value The set of rules that created this mapping
*
* Responses:
*
*/
void
update_nat_natting_table_originating_rule_by_id(const std::string &name, const std::string &internalSrc, const std::string &internalDst, const uint16_t &internalSport, const uint16_t &internalDport, const std::string &proto, const NattingTableOriginatingRuleEnum &value) {
  auto nat = get_cube(name);
  auto nattingTable = nat->getNattingTable(internalSrc, internalDst, internalSport, internalDport, proto);

  nattingTable->setOriginatingRule(value);
}

/**
* @brief   Update rule by ID
*
* Update operation of resource: rule*
*
* @param[in] name ID of name
* @param[in] value rulebody object
*
* Responses:
*
*/
void
update_nat_rule_by_id(const std::string &name, const RuleJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();

  rule->update(value);
}

/**
* @brief   Update dnat by ID
*
* Update operation of resource: dnat*
*
* @param[in] name ID of name
* @param[in] value dnatbody object
*
* Responses:
*
*/
void
update_nat_rule_dnat_by_id(const std::string &name, const RuleDnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();

  dnat->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_dnat_entry_by_id(const std::string &name, const uint32_t &id, const RuleDnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto entry = dnat->getEntry(id);

  entry->update(value);
}

/**
* @brief   Update external-ip by ID
*
* Update operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value External destination IP address
*
* Responses:
*
*/
void
update_nat_rule_dnat_entry_external_ip_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto entry = dnat->getEntry(id);

  entry->setExternalIp(value);
}

/**
* @brief   Update internal-ip by ID
*
* Update operation of resource: internal-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value Internal destination IP address
*
* Responses:
*
*/
void
update_nat_rule_dnat_entry_internal_ip_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto dnat = rule->getDnat();
  auto entry = dnat->getEntry(id);

  entry->setInternalIp(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_dnat_entry_list_by_id(const std::string &name, const std::vector<RuleDnatEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update masquerade by ID
*
* Update operation of resource: masquerade*
*
* @param[in] name ID of name
* @param[in] value masqueradebody object
*
* Responses:
*
*/
void
update_nat_rule_masquerade_by_id(const std::string &name, const RuleMasqueradeJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto masquerade = rule->getMasquerade();

  masquerade->update(value);
}

/**
* @brief   Update enabled by ID
*
* Update operation of resource: enabled*
*
* @param[in] name ID of name
* @param[in] value enabledbody object
*
* Responses:
*
*/
void
update_nat_rule_masquerade_enabled_by_id(const std::string &name, const bool &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto masquerade = rule->getMasquerade();

  masquerade->setEnabled(value);
}

/**
* @brief   Update port-forwarding by ID
*
* Update operation of resource: port-forwarding*
*
* @param[in] name ID of name
* @param[in] value port-forwardingbody object
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_by_id(const std::string &name, const RulePortForwardingJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();

  portForwarding->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_by_id(const std::string &name, const uint32_t &id, const RulePortForwardingEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->update(value);
}

/**
* @brief   Update external-ip by ID
*
* Update operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value External destination IP address
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_external_ip_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->setExternalIp(value);
}

/**
* @brief   Update external-port by ID
*
* Update operation of resource: external-port*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value External destination L4 port
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_external_port_by_id(const std::string &name, const uint32_t &id, const uint16_t &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->setExternalPort(value);
}

/**
* @brief   Update internal-ip by ID
*
* Update operation of resource: internal-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value Internal destination IP address
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_internal_ip_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->setInternalIp(value);
}

/**
* @brief   Update internal-port by ID
*
* Update operation of resource: internal-port*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value Internal destination L4 port
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_internal_port_by_id(const std::string &name, const uint32_t &id, const uint16_t &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->setInternalPort(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_list_by_id(const std::string &name, const std::vector<RulePortForwardingEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update proto by ID
*
* Update operation of resource: proto*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value L4 protocol (TCP, UDP, ALL)
*
* Responses:
*
*/
void
update_nat_rule_port_forwarding_entry_proto_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto portForwarding = rule->getPortForwarding();
  auto entry = portForwarding->getEntry(id);

  entry->setProto(value);
}

/**
* @brief   Update snat by ID
*
* Update operation of resource: snat*
*
* @param[in] name ID of name
* @param[in] value snatbody object
*
* Responses:
*
*/
void
update_nat_rule_snat_by_id(const std::string &name, const RuleSnatJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();

  snat->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_snat_entry_by_id(const std::string &name, const uint32_t &id, const RuleSnatEntryJsonObject &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto entry = snat->getEntry(id);

  entry->update(value);
}

/**
* @brief   Update external-ip by ID
*
* Update operation of resource: external-ip*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value Natted source IP address
*
* Responses:
*
*/
void
update_nat_rule_snat_entry_external_ip_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto entry = snat->getEntry(id);

  entry->setExternalIp(value);
}

/**
* @brief   Update internal-net by ID
*
* Update operation of resource: internal-net*
*
* @param[in] name ID of name
* @param[in] id ID of id
* @param[in] value Internal IP address (or subnet)
*
* Responses:
*
*/
void
update_nat_rule_snat_entry_internal_net_by_id(const std::string &name, const uint32_t &id, const std::string &value) {
  auto nat = get_cube(name);
  auto rule = nat->getRule();
  auto snat = rule->getSnat();
  auto entry = snat->getEntry(id);

  entry->setInternalNet(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_nat_rule_snat_entry_list_by_id(const std::string &name, const std::vector<RuleSnatEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_nat_natting_table_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&nat = get_cube(name);

  auto &&nattingTable = nat->getNattingTableList();
  for(auto &i : nattingTable) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["internalSrc"] = i->getInternalSrc();
    keys["internalDst"] = i->getInternalDst();
    keys["internalSport"] = std::to_string(i->getInternalSport());
    keys["internalDport"] = std::to_string(i->getInternalDport());
    keys["proto"] = i->getProto();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_nat_rule_dnat_entry_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&nat = get_cube(name);
  auto &&rule = nat->getRule();
  auto &&dnat = rule->getDnat();

  auto &&entry = dnat->getEntryList();
  for(auto &i : entry) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["id"] = std::to_string(i->getId());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_nat_rule_port_forwarding_entry_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&nat = get_cube(name);
  auto &&rule = nat->getRule();
  auto &&portForwarding = rule->getPortForwarding();

  auto &&entry = portForwarding->getEntryList();
  for(auto &i : entry) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["id"] = std::to_string(i->getId());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_nat_rule_snat_entry_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&nat = get_cube(name);
  auto &&rule = nat->getRule();
  auto &&snat = rule->getSnat();

  auto &&entry = snat->getEntryList();
  for(auto &i : entry) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["id"] = std::to_string(i->getId());

    r.push_back(keys);
  }
  return r;
}


}

}
}
}
}

