/**
* nat API
* nat API generated from nat.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "NatApi.h"
#include "NatApiImpl.h"

using namespace io::swagger::server::model;
using namespace io::swagger::server::api::NatApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_nat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NatJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_nat_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_natting_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NattingTableJsonObject unique_value { request_body };

    unique_value.setInternalSrc(unique_internalSrc);
    unique_value.setInternalDst(unique_internalDst);
    unique_value.setInternalSport(unique_internalSport);
    unique_value.setInternalDport(unique_internalDport);
    unique_value.setProto(unique_proto);
    create_nat_natting_table_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_natting_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<NattingTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<NattingTableJsonObject> unique_value;
    for (auto &j : request_body) {
      NattingTableJsonObject a { j };
      unique_value.push_back(a);
    }
    create_nat_natting_table_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleJsonObject unique_value { request_body };

    create_nat_rule_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_dnat_append_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatAppendInputJsonObject unique_value { request_body };


    auto x = create_nat_rule_dnat_append_by_id(unique_name, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_dnat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatJsonObject unique_value { request_body };

    create_nat_rule_dnat_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_dnat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_nat_rule_dnat_entry_by_id(unique_name, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_dnat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleDnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleDnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleDnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    create_nat_rule_dnat_entry_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_masquerade_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleMasqueradeJsonObject unique_value { request_body };

    create_nat_rule_masquerade_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_masquerade_disable_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_nat_rule_masquerade_disable_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_masquerade_enable_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_nat_rule_masquerade_enable_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_port_forwarding_append_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingAppendInputJsonObject unique_value { request_body };


    auto x = create_nat_rule_port_forwarding_append_by_id(unique_name, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_port_forwarding_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingJsonObject unique_value { request_body };

    create_nat_rule_port_forwarding_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_port_forwarding_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_nat_rule_port_forwarding_entry_by_id(unique_name, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_port_forwarding_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulePortForwardingEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulePortForwardingEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RulePortForwardingEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    create_nat_rule_port_forwarding_entry_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_snat_append_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatAppendInputJsonObject unique_value { request_body };


    auto x = create_nat_rule_snat_append_by_id(unique_name, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_snat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatJsonObject unique_value { request_body };

    create_nat_rule_snat_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_snat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_nat_rule_snat_entry_by_id(unique_name, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_nat_rule_snat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleSnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleSnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleSnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    create_nat_rule_snat_entry_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_natting_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_nat_natting_table_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_natting_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_natting_table_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_dnat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_dnat_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_dnat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_nat_rule_dnat_entry_by_id(unique_name, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_dnat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_dnat_entry_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_masquerade_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_masquerade_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_port_forwarding_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_port_forwarding_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_port_forwarding_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_nat_rule_port_forwarding_entry_by_id(unique_name, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_port_forwarding_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_port_forwarding_entry_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_snat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_snat_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_snat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_nat_rule_snat_entry_by_id(unique_name, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_nat_rule_snat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_nat_rule_snat_entry_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_nat_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_natting_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_nat_natting_table_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_natting_table_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_nat_natting_table_external_ip_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_natting_table_external_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_nat_natting_table_external_port_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_natting_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_natting_table_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_natting_table_originating_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_nat_natting_table_originating_rule_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto);
    nlohmann::json response_body;
    response_body = NattingTableJsonObject::NattingTableOriginatingRuleEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_dnat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_dnat_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_dnat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_dnat_entry_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_dnat_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_dnat_entry_external_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_dnat_entry_internal_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_dnat_entry_internal_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_dnat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_dnat_entry_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_masquerade_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_masquerade_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_masquerade_enabled_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_masquerade_enabled_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_port_forwarding_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_external_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_external_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_external_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_internal_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_internal_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_internal_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_internal_port_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_port_forwarding_entry_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_port_forwarding_entry_proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_port_forwarding_entry_proto_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_snat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_snat_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_snat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_snat_entry_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_snat_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_snat_entry_external_ip_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_snat_entry_internal_net_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_nat_rule_snat_entry_internal_net_by_id(unique_name, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_nat_rule_snat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_nat_rule_snat_entry_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NatJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_nat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_natting_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NattingTableJsonObject unique_value { request_body };

    unique_value.setInternalSrc(unique_internalSrc);
    unique_value.setInternalDst(unique_internalDst);
    unique_value.setInternalSport(unique_internalSport);
    unique_value.setInternalDport(unique_internalDport);
    unique_value.setProto(unique_proto);
    replace_nat_natting_table_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_natting_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<NattingTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<NattingTableJsonObject> unique_value;
    for (auto &j : request_body) {
      NattingTableJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_nat_natting_table_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleJsonObject unique_value { request_body };

    replace_nat_rule_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_dnat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatJsonObject unique_value { request_body };

    replace_nat_rule_dnat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_dnat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_nat_rule_dnat_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_dnat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleDnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleDnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleDnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_nat_rule_dnat_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_masquerade_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleMasqueradeJsonObject unique_value { request_body };

    replace_nat_rule_masquerade_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_port_forwarding_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingJsonObject unique_value { request_body };

    replace_nat_rule_port_forwarding_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_port_forwarding_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_nat_rule_port_forwarding_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_port_forwarding_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulePortForwardingEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulePortForwardingEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RulePortForwardingEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_nat_rule_port_forwarding_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_snat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatJsonObject unique_value { request_body };

    replace_nat_rule_snat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_snat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_nat_rule_snat_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_nat_rule_snat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleSnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleSnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleSnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_nat_rule_snat_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NatJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_nat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<NatJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<NatJsonObject> unique_value;
    for (auto &j : request_body) {
      NatJsonObject a { j };
      unique_value.push_back(a);
    }
    update_nat_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_natting_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    NattingTableJsonObject unique_value { request_body };

    unique_value.setInternalSrc(unique_internalSrc);
    unique_value.setInternalDst(unique_internalDst);
    unique_value.setInternalSport(unique_internalSport);
    unique_value.setInternalDport(unique_internalDport);
    unique_value.setProto(unique_proto);
    update_nat_natting_table_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_natting_table_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_natting_table_external_ip_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_natting_table_external_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_nat_natting_table_external_port_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_natting_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<NattingTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<NattingTableJsonObject> unique_value;
    for (auto &j : request_body) {
      NattingTableJsonObject a { j };
      unique_value.push_back(a);
    }
    update_nat_natting_table_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_natting_table_originating_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_internalSrc;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-src")) {
      unique_internalSrc = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_internalDst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dst")) {
      unique_internalDst = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_internalSport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-sport")) {
      unique_internalSport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_internalDport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "internal-dport")) {
      unique_internalDport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    NattingTableOriginatingRuleEnum unique_value_ = NattingTableJsonObject::string_to_NattingTableOriginatingRuleEnum(request_body);
    update_nat_natting_table_originating_rule_by_id(unique_name, unique_internalSrc, unique_internalDst, unique_internalSport, unique_internalDport, unique_proto, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleJsonObject unique_value { request_body };

    update_nat_rule_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_dnat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatJsonObject unique_value { request_body };

    update_nat_rule_dnat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_dnat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleDnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_nat_rule_dnat_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_dnat_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_dnat_entry_external_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_dnat_entry_internal_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_dnat_entry_internal_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_dnat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleDnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleDnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleDnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    update_nat_rule_dnat_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_masquerade_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleMasqueradeJsonObject unique_value { request_body };

    update_nat_rule_masquerade_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_masquerade_enabled_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    bool unique_value = request_body;
    update_nat_rule_masquerade_enabled_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingJsonObject unique_value { request_body };

    update_nat_rule_port_forwarding_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RulePortForwardingEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_nat_rule_port_forwarding_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_port_forwarding_entry_external_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_external_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_nat_rule_port_forwarding_entry_external_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_internal_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_port_forwarding_entry_internal_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_internal_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_nat_rule_port_forwarding_entry_internal_port_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RulePortForwardingEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RulePortForwardingEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RulePortForwardingEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    update_nat_rule_port_forwarding_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_port_forwarding_entry_proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_port_forwarding_entry_proto_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_snat_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatJsonObject unique_value { request_body };

    update_nat_rule_snat_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_snat_entry_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    RuleSnatEntryJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_nat_rule_snat_entry_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_snat_entry_external_ip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_snat_entry_external_ip_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_snat_entry_internal_net_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_nat_rule_snat_entry_internal_net_by_id(unique_name, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_nat_rule_snat_entry_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<RuleSnatEntryJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<RuleSnatEntryJsonObject> unique_value;
    for (auto &j : request_body) {
      RuleSnatEntryJsonObject a { j };
      unique_value.push_back(a);
    }
    update_nat_rule_snat_entry_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response nat_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_nat_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response nat_natting_table_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_nat_natting_table_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response nat_rule_dnat_entry_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_nat_rule_dnat_entry_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response nat_rule_port_forwarding_entry_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_nat_rule_port_forwarding_entry_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response nat_rule_snat_entry_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_nat_rule_snat_entry_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

