/**
* lbrp API
* lbrp API generated from lbrp.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "LbrpApiImpl.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

namespace LbrpApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Lbrp>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Lbrp> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_lbrp_by_id(const std::string &name, const LbrpJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Lbrp>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Lbrp>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_lbrp_by_id(const std::string &name, const LbrpJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_lbrp_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<LbrpJsonObject> read_lbrp_list_by_id() {
  std::vector<LbrpJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_lbrp_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_lbrp_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_lbrp_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto lbrp = get_cube(name);
  lbrp->addPortsList(value);
}

/**
* @brief   Create backend by ID
*
* Create operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value backendbody object
*
* Responses:
*
*/
void
create_lbrp_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const ServiceBackendJsonObject &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);

  service->addBackend(ip, value);
}

/**
* @brief   Create backend by ID
*
* Create operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
create_lbrp_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  service->addBackendList(value);
}

/**
* @brief   Create service by ID
*
* Create operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
create_lbrp_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->addService(vip, vport, proto, value);
}

/**
* @brief   Create service by ID
*
* Create operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
create_lbrp_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  auto lbrp = get_cube(name);
  lbrp->addServiceList(value);
}

/**
* @brief   Create src-ip-rewrite by ID
*
* Create operation of resource: src-ip-rewrite*
*
* @param[in] name ID of name
* @param[in] value src-ip-rewritebody object
*
* Responses:
*
*/
void
create_lbrp_src_ip_rewrite_by_id(const std::string &name, const SrcIpRewriteJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->addSrcIpRewrite(value);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_lbrp_ports_by_id(const std::string &name, const std::string &portsName) {
  auto lbrp = get_cube(name);

  lbrp->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_lbrp_ports_list_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  lbrp->delPortsList();
}

/**
* @brief   Delete backend by ID
*
* Delete operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
*
*/
void
delete_lbrp_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);

  service->delBackend(ip);
}

/**
* @brief   Delete backend by ID
*
* Delete operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_lbrp_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  service->delBackendList();
}

/**
* @brief   Delete service by ID
*
* Delete operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_lbrp_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto lbrp = get_cube(name);

  lbrp->delService(vip, vport, proto);
}

/**
* @brief   Delete service by ID
*
* Delete operation of resource: service*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_lbrp_service_list_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  lbrp->delServiceList();
}

/**
* @brief   Delete src-ip-rewrite by ID
*
* Delete operation of resource: src-ip-rewrite*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_lbrp_src_ip_rewrite_by_id(const std::string &name) {
  auto lbrp = get_cube(name);

  lbrp->delSrcIpRewrite();
}

/**
* @brief   Read lbrp by ID
*
* Read operation of resource: lbrp*
*
* @param[in] name ID of name
*
* Responses:
* LbrpJsonObject
*/
LbrpJsonObject
read_lbrp_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_lbrp_ports_by_id(const std::string &name, const std::string &portsName) {
  auto lbrp = get_cube(name);
  return lbrp->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_lbrp_ports_list_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  auto &&ports = lbrp->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read type by ID
*
* Read operation of resource: type*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsTypeEnum
*/
PortsTypeEnum
read_lbrp_ports_type_by_id(const std::string &name, const std::string &portsName) {
  auto lbrp = get_cube(name);
  auto ports = lbrp->getPorts(portsName);
  return ports->getType();

}

/**
* @brief   Read backend by ID
*
* Read operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* ServiceBackendJsonObject
*/
ServiceBackendJsonObject
read_lbrp_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  return service->getBackend(ip)->toJsonObject();

}

/**
* @brief   Read backend by ID
*
* Read operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* std::vector<ServiceBackendJsonObject>
*/
std::vector<ServiceBackendJsonObject>
read_lbrp_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto &&backend = service->getBackendList();
  std::vector<ServiceBackendJsonObject> m;
  for(auto &i : backend)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read name by ID
*
* Read operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* std::string
*/
std::string
read_lbrp_service_backend_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);
  return backend->getName();

}

/**
* @brief   Read port by ID
*
* Read operation of resource: port*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* uint16_t
*/
uint16_t
read_lbrp_service_backend_port_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);
  return backend->getPort();

}

/**
* @brief   Read weight by ID
*
* Read operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* uint16_t
*/
uint16_t
read_lbrp_service_backend_weight_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);
  return backend->getWeight();

}

/**
* @brief   Read service by ID
*
* Read operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* ServiceJsonObject
*/
ServiceJsonObject
read_lbrp_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto lbrp = get_cube(name);
  return lbrp->getService(vip, vport, proto)->toJsonObject();

}

/**
* @brief   Read service by ID
*
* Read operation of resource: service*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<ServiceJsonObject>
*/
std::vector<ServiceJsonObject>
read_lbrp_service_list_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  auto &&service = lbrp->getServiceList();
  std::vector<ServiceJsonObject> m;
  for(auto &i : service)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read name by ID
*
* Read operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* std::string
*/
std::string
read_lbrp_service_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  return service->getName();

}

/**
* @brief   Read src-ip-rewrite by ID
*
* Read operation of resource: src-ip-rewrite*
*
* @param[in] name ID of name
*
* Responses:
* SrcIpRewriteJsonObject
*/
SrcIpRewriteJsonObject
read_lbrp_src_ip_rewrite_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  return lbrp->getSrcIpRewrite()->toJsonObject();

}

/**
* @brief   Read ip-range by ID
*
* Read operation of resource: ip-range*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_lbrp_src_ip_rewrite_ip_range_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  auto srcIpRewrite = lbrp->getSrcIpRewrite();
  return srcIpRewrite->getIpRange();

}

/**
* @brief   Read new_ip_range by ID
*
* Read operation of resource: new_ip_range*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_lbrp_src_ip_rewrite_new_ip_range_by_id(const std::string &name) {
  auto lbrp = get_cube(name);
  auto srcIpRewrite = lbrp->getSrcIpRewrite();
  return srcIpRewrite->getNewIpRange();

}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_lbrp_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_lbrp_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace backend by ID
*
* Replace operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value backendbody object
*
* Responses:
*
*/
void
replace_lbrp_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const ServiceBackendJsonObject &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);

  service->replaceBackend(ip, value);
}

/**
* @brief   Replace backend by ID
*
* Replace operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
replace_lbrp_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace service by ID
*
* Replace operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
replace_lbrp_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->replaceService(vip, vport, proto, value);
}

/**
* @brief   Replace service by ID
*
* Replace operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
replace_lbrp_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace src-ip-rewrite by ID
*
* Replace operation of resource: src-ip-rewrite*
*
* @param[in] name ID of name
* @param[in] value src-ip-rewritebody object
*
* Responses:
*
*/
void
replace_lbrp_src_ip_rewrite_by_id(const std::string &name, const SrcIpRewriteJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->replaceSrcIpRewrite(value);
}

/**
* @brief   Update lbrp by ID
*
* Update operation of resource: lbrp*
*
* @param[in] name ID of name
* @param[in] value lbrpbody object
*
* Responses:
*
*/
void
update_lbrp_by_id(const std::string &name, const LbrpJsonObject &value) {
  auto lbrp = get_cube(name);

  lbrp->update(value);
}

/**
* @brief   Update lbrp by ID
*
* Update operation of resource: lbrp*
*
* @param[in] value lbrpbody object
*
* Responses:
*
*/
void
update_lbrp_list_by_id(const std::vector<LbrpJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_lbrp_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto lbrp = get_cube(name);
  auto ports = lbrp->getPorts(portsName);

  ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_lbrp_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update type by ID
*
* Update operation of resource: type*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value Type of the LB port (e.g. FRONTEND or BACKEND)
*
* Responses:
*
*/
void
update_lbrp_ports_type_by_id(const std::string &name, const std::string &portsName, const PortsTypeEnum &value) {
  auto lbrp = get_cube(name);
  auto ports = lbrp->getPorts(portsName);

  ports->setType(value);
}

/**
* @brief   Update backend by ID
*
* Update operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value backendbody object
*
* Responses:
*
*/
void
update_lbrp_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const ServiceBackendJsonObject &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);

  backend->update(value);
}

/**
* @brief   Update backend by ID
*
* Update operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
update_lbrp_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update name by ID
*
* Update operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value name
*
* Responses:
*
*/
void
update_lbrp_service_backend_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const std::string &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);

  backend->setName(value);
}

/**
* @brief   Update port by ID
*
* Update operation of resource: port*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value Port where the server listen to (this value is ignored in case of ICMP)
*
* Responses:
*
*/
void
update_lbrp_service_backend_port_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);

  backend->setPort(value);
}

/**
* @brief   Update weight by ID
*
* Update operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value Weight of the backend in the pool
*
* Responses:
*
*/
void
update_lbrp_service_backend_weight_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);
  auto backend = service->getBackend(ip);

  backend->setWeight(value);
}

/**
* @brief   Update service by ID
*
* Update operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
update_lbrp_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);

  service->update(value);
}

/**
* @brief   Update service by ID
*
* Update operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
update_lbrp_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update name by ID
*
* Update operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value Service name related to the backend server of the pool is connected to
*
* Responses:
*
*/
void
update_lbrp_service_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &value) {
  auto lbrp = get_cube(name);
  auto service = lbrp->getService(vip, vport, proto);

  service->setName(value);
}

/**
* @brief   Update src-ip-rewrite by ID
*
* Update operation of resource: src-ip-rewrite*
*
* @param[in] name ID of name
* @param[in] value src-ip-rewritebody object
*
* Responses:
*
*/
void
update_lbrp_src_ip_rewrite_by_id(const std::string &name, const SrcIpRewriteJsonObject &value) {
  auto lbrp = get_cube(name);
  auto srcIpRewrite = lbrp->getSrcIpRewrite();

  srcIpRewrite->update(value);
}

/**
* @brief   Update ip-range by ID
*
* Update operation of resource: ip-range*
*
* @param[in] name ID of name
* @param[in] value Range of IP addresses of the clients that must be replaced
*
* Responses:
*
*/
void
update_lbrp_src_ip_rewrite_ip_range_by_id(const std::string &name, const std::string &value) {
  auto lbrp = get_cube(name);
  auto srcIpRewrite = lbrp->getSrcIpRewrite();

  srcIpRewrite->setIpRange(value);
}

/**
* @brief   Update new_ip_range by ID
*
* Update operation of resource: new_ip_range*
*
* @param[in] name ID of name
* @param[in] value Range of IP addresses of the that must be used to replace client addresses
*
* Responses:
*
*/
void
update_lbrp_src_ip_rewrite_new_ip_range_by_id(const std::string &name, const std::string &value) {
  auto lbrp = get_cube(name);
  auto srcIpRewrite = lbrp->getSrcIpRewrite();

  srcIpRewrite->setNewIpRange(value);
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_lbrp_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&lbrp = get_cube(name);

  auto &&ports = lbrp->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_lbrp_service_backend_list_by_id_get_list(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&lbrp = get_cube(name);
  auto &&service = lbrp->getService(vip, vport, proto);

  auto &&backend = service->getBackendList();
  for(auto &i : backend) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_lbrp_service_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&lbrp = get_cube(name);

  auto &&service = lbrp->getServiceList();
  for(auto &i : service) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vip"] = i->getVip();
    keys["vport"] = std::to_string(i->getVport());
    keys["proto"] = ServiceJsonObject::ServiceProtoEnum_to_string(i->getProto());

    r.push_back(keys);
  }
  return r;
}


}

}
}
}
}

