/**
* lbrp API
* lbrp API generated from lbrp.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "LbrpApi.h"
#include "LbrpApiImpl.h"

using namespace io::swagger::server::model;
using namespace io::swagger::server::api::LbrpApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_lbrp_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    LbrpJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_lbrp_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    create_lbrp_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    create_lbrp_ports_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    create_lbrp_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    create_lbrp_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    create_lbrp_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    create_lbrp_service_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_lbrp_src_ip_rewrite_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    SrcIpRewriteJsonObject unique_value { request_body };

    create_lbrp_src_ip_rewrite_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_lbrp_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_lbrp_ports_by_id(unique_name, unique_portsName);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_lbrp_ports_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_lbrp_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    delete_lbrp_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    delete_lbrp_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_lbrp_service_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_lbrp_src_ip_rewrite_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_lbrp_src_ip_rewrite_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_lbrp_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_ports_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_ports_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_ports_type_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_ports_type_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = PortsJsonObject::PortsTypeEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_lbrp_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_backend_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_service_backend_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_backend_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_service_backend_port_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_backend_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_lbrp_service_backend_weight_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_lbrp_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_service_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_service_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_lbrp_service_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_src_ip_rewrite_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_src_ip_rewrite_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_src_ip_rewrite_ip_range_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_src_ip_rewrite_ip_range_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_lbrp_src_ip_rewrite_new_ip_range_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_lbrp_src_ip_rewrite_new_ip_range_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    LbrpJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_lbrp_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    replace_lbrp_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_lbrp_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    replace_lbrp_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_lbrp_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    replace_lbrp_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_lbrp_service_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_lbrp_src_ip_rewrite_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    SrcIpRewriteJsonObject unique_value { request_body };

    replace_lbrp_src_ip_rewrite_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    LbrpJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_lbrp_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<LbrpJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<LbrpJsonObject> unique_value;
    for (auto &j : request_body) {
      LbrpJsonObject a { j };
      unique_value.push_back(a);
    }
    update_lbrp_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    update_lbrp_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    update_lbrp_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_ports_type_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    PortsTypeEnum unique_value_ = PortsJsonObject::string_to_PortsTypeEnum(request_body);
    update_lbrp_ports_type_by_id(unique_name, unique_portsName, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    update_lbrp_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    update_lbrp_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_backend_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_lbrp_service_backend_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_backend_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_lbrp_service_backend_port_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_backend_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_lbrp_service_backend_weight_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    update_lbrp_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    update_lbrp_service_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_service_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_lbrp_service_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_src_ip_rewrite_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    SrcIpRewriteJsonObject unique_value { request_body };

    update_lbrp_src_ip_rewrite_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_src_ip_rewrite_ip_range_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_lbrp_src_ip_rewrite_ip_range_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_lbrp_src_ip_rewrite_new_ip_range_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_lbrp_src_ip_rewrite_new_ip_range_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response lbrp_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_lbrp_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response lbrp_ports_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_lbrp_ports_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response lbrp_service_backend_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  nlohmann::json val = read_lbrp_service_backend_list_by_id_get_list(unique_name, unique_vip, unique_vport, unique_proto_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response lbrp_service_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_lbrp_service_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

