/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* VipBase.h
*
*
*/

#pragma once

#include "../serializer/VipJsonObject.h"

#include "../VipReal.h"





#include <spdlog/spdlog.h>

using namespace polycube::service::model;

class Katran;

class VipBase {
 public:
  
  VipBase(Katran &parent);
  
  virtual ~VipBase();
  virtual void update(const VipJsonObject &conf);
  virtual VipJsonObject toJsonObject();

  /// <summary>
  /// Virtual IP (vip) of the service where clients connect to
  /// </summary>
  virtual std::string getAddress() = 0;

  /// <summary>
  /// Port of the virtual server where clients connect to (this value is ignored in case of ICMP)
  /// </summary>
  virtual uint16_t getPort() = 0;

  /// <summary>
  /// Upper-layer protocol associated with a loadbalancing service instance. &#39;ALL&#39; creates an entry for all the supported protocols
  /// </summary>
  virtual VipProtoEnum getProto() = 0;

  /// <summary>
  /// Flags used in the VIP
  /// </summary>
  virtual uint32_t getFlags() = 0;
  virtual void setFlags(const uint32_t &value) = 0;

  /// <summary>
  /// Pool of backend servers that actually serve requests
  /// </summary>
  virtual std::shared_ptr<VipReal> getReal(const std::string &ip) = 0;
  virtual std::vector<std::shared_ptr<VipReal>> getRealList() = 0;
  virtual void addReal(const std::string &ip, const VipRealJsonObject &conf) = 0;
  virtual void addRealList(const std::vector<VipRealJsonObject> &conf);
  virtual void replaceReal(const std::string &ip, const VipRealJsonObject &conf);
  virtual void delReal(const std::string &ip) = 0;
  virtual void delRealList();

  std::shared_ptr<spdlog::logger> logger();
 protected:
  Katran &parent_;
};
