/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* KatranBase.h
*
*
*/

#pragma once

#include "../serializer/KatranJsonObject.h"

#include "../GeneralStats.h"
#include "../Ports.h"
#include "../Vip.h"

#include "polycube/services/cube.h"
#include "polycube/services/port.h"



#include "polycube/services/utils.h"
#include "polycube/services/fifo_map.hpp"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;


class KatranBase: public virtual polycube::service::Cube<Ports> {
 public:
  KatranBase(const std::string name);
  
  virtual ~KatranBase();
  virtual void update(const KatranJsonObject &conf);
  virtual KatranJsonObject toJsonObject();

  /// <summary>
  /// Defines if the service should be automatically optimized by Morpheus
  /// </summary>
  virtual bool getDynOpt() = 0;

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name);
  virtual std::vector<std::shared_ptr<Ports>> getPortsList();
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf);
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf);
  virtual void replacePorts(const std::string &name, const PortsJsonObject &conf);
  virtual void delPorts(const std::string &name);
  virtual void delPortsList();

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<GeneralStats> getGeneralStats() = 0;
  virtual void addGeneralStats(const GeneralStatsJsonObject &value) = 0;
  virtual void replaceGeneralStats(const GeneralStatsJsonObject &conf);
  virtual void delGeneralStats() = 0;

  /// <summary>
  /// mac address of default router. katran &#39;offloads&#39; forwarding to the top of the rack switch (by simply sending everything to it by default).
  /// </summary>
  virtual std::string getDefaultMac() = 0;
  virtual void setDefaultMac(const std::string &value) = 0;

  /// <summary>
  /// Flag to indicate if healthchecking forwarding plane should be enabled or not.
  /// </summary>
  virtual bool getEnableHc() = 0;
  virtual void setEnableHc(const bool &value) = 0;

  /// <summary>
  /// Maximum number of VIPs supported by katran. It must be in sync with configuration of forwarding plane
  /// </summary>
  virtual uint32_t getMaxVips() = 0;
  virtual void setMaxVips(const uint32_t &value) = 0;

  /// <summary>
  /// Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
  /// </summary>
  virtual uint32_t getMaxReals() = 0;
  virtual void setMaxReals(const uint32_t &value) = 0;

  /// <summary>
  /// Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
  /// </summary>
  virtual uint32_t getChRingSize() = 0;
  virtual void setChRingSize(const uint32_t &value) = 0;

  /// <summary>
  /// ID of cpu cores which are responsible for the packet forwarding
  /// </summary>
  virtual std::string getForwardingCores() = 0;
  virtual void setForwardingCores(const std::string &value) = 0;

  /// <summary>
  /// ID of the numa node associated to the forwarding cores
  /// </summary>
  virtual std::string getNumaNodes() = 0;
  virtual void setNumaNodes(const std::string &value) = 0;

  /// <summary>
  /// The size of connection table (number of flows which we are going to track)
  /// </summary>
  virtual uint64_t getLruSize() = 0;
  virtual void setLruSize(const uint64_t &value) = 0;

  /// <summary>
  /// Services (i.e., virtual ip:protocol:port) exported to the client
  /// </summary>
  virtual std::shared_ptr<Vip> getVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto) = 0;
  virtual std::vector<std::shared_ptr<Vip>> getVipList() = 0;
  virtual void addVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) = 0;
  virtual void addVipList(const std::vector<VipJsonObject> &conf);
  virtual void replaceVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf);
  virtual void delVip(const std::string &address,const uint16_t &port,const VipProtoEnum &proto) = 0;
  virtual void delVipList();
};
