/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "KatranBase.h"

KatranBase::KatranBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Katran] [%n] [%l] %v");
}



KatranBase::~KatranBase() {}

void KatranBase::update(const KatranJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.generalStatsIsSet()) {
    auto m = getGeneralStats();
    m->update(conf.getGeneralStats());
  }
  if (conf.defaultMacIsSet()) {
    setDefaultMac(conf.getDefaultMac());
  }
  if (conf.enableHcIsSet()) {
    setEnableHc(conf.getEnableHc());
  }
  if (conf.maxVipsIsSet()) {
    setMaxVips(conf.getMaxVips());
  }
  if (conf.maxRealsIsSet()) {
    setMaxReals(conf.getMaxReals());
  }
  if (conf.chRingSizeIsSet()) {
    setChRingSize(conf.getChRingSize());
  }
  if (conf.forwardingCoresIsSet()) {
    setForwardingCores(conf.getForwardingCores());
  }
  if (conf.numaNodesIsSet()) {
    setNumaNodes(conf.getNumaNodes());
  }
  if (conf.lruSizeIsSet()) {
    setLruSize(conf.getLruSize());
  }
  if (conf.vipIsSet()) {
    for (auto &i : conf.getVip()) {
      auto address = i.getAddress();
      auto port = i.getPort();
      auto proto = i.getProto();
      auto m = getVip(address, port, proto);
      m->update(i);
    }
  }
}

KatranJsonObject KatranBase::toJsonObject() {
  KatranJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  conf.setDynOpt(getDynOpt());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setGeneralStats(getGeneralStats()->toJsonObject());
  conf.setDefaultMac(getDefaultMac());
  conf.setEnableHc(getEnableHc());
  conf.setMaxVips(getMaxVips());
  conf.setMaxReals(getMaxReals());
  conf.setChRingSize(getChRingSize());
  conf.setForwardingCores(getForwardingCores());
  conf.setNumaNodes(getNumaNodes());
  conf.setLruSize(getLruSize());
  for(auto &i : getVipList()) {
    conf.addVip(i->toJsonObject());
  }

  return conf;
}
void KatranBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void KatranBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void KatranBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void KatranBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void KatranBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> KatranBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> KatranBase::getPortsList() {
  return get_ports();
}

void KatranBase::replaceGeneralStats(const GeneralStatsJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delGeneralStats();
  addGeneralStats(conf);
}
void KatranBase::addVipList(const std::vector<VipJsonObject> &conf) {
  for (auto &i : conf) {
    std::string address_ = i.getAddress();
    uint16_t port_ = i.getPort();
    VipProtoEnum proto_ = i.getProto();
    addVip(address_, port_, proto_, i);
  }
}

void KatranBase::replaceVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) {
  delVip(address, port, proto);
  std::string address_ = conf.getAddress();
  uint16_t port_ = conf.getPort();
  VipProtoEnum proto_ = conf.getProto();
  addVip(address_, port_, proto_, conf);
}

void KatranBase::delVipList() {
  auto elements = getVipList();
  for (auto &i : elements) {
    std::string address_ = i->getAddress();
    uint16_t port_ = i->getPort();
    VipProtoEnum proto_ = i->getProto();
    delVip(address_, port_, proto_);
  }
}


