/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "KatranApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace KatranApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Katran>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Katran> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_katran_by_id(const std::string &name, const KatranJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Katran>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Katran>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_katran_by_id(const std::string &name, const KatranJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_katran_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<KatranJsonObject> read_katran_list_by_id() {
  std::vector<KatranJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_katran_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create getIcmpTooBigStats by ID
*
* Create operation of resource: getIcmpTooBigStats*
*
* @param[in] name ID of name
*
* Responses:
* GeneralStatsGetIcmpTooBigStatsOutputJsonObject
*/
GeneralStatsGetIcmpTooBigStatsOutputJsonObject
create_katran_general_stats_get_icmp_too_big_stats_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getIcmpTooBigStats();

}

/**
* @brief   Create getLruFallbackStats by ID
*
* Create operation of resource: getLruFallbackStats*
*
* @param[in] name ID of name
*
* Responses:
* GeneralStatsGetLruFallbackStatsOutputJsonObject
*/
GeneralStatsGetLruFallbackStatsOutputJsonObject
create_katran_general_stats_get_lru_fallback_stats_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getLruFallbackStats();

}

/**
* @brief   Create getLruMissStats by ID
*
* Create operation of resource: getLruMissStats*
*
* @param[in] name ID of name
*
* Responses:
* GeneralStatsGetLruMissStatsOutputJsonObject
*/
GeneralStatsGetLruMissStatsOutputJsonObject
create_katran_general_stats_get_lru_miss_stats_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getLruMissStats();

}

/**
* @brief   Create getLruStats by ID
*
* Create operation of resource: getLruStats*
*
* @param[in] name ID of name
*
* Responses:
* GeneralStatsGetLruStatsOutputJsonObject
*/
GeneralStatsGetLruStatsOutputJsonObject
create_katran_general_stats_get_lru_stats_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getLruStats();

}

/**
* @brief   Create getVipStats by ID
*
* Create operation of resource: getVipStats*
*
* @param[in] name ID of name
* @param[in] value getVipStatsbody object
*
* Responses:
* GeneralStatsGetVipStatsOutputJsonObject
*/
GeneralStatsGetVipStatsOutputJsonObject
create_katran_general_stats_get_vip_stats_by_id(const std::string &name, const GeneralStatsGetVipStatsInputJsonObject &value) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getVipStats(value);

}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_katran_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto katran = get_cube(name);

  return katran->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_katran_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto katran = get_cube(name);
  katran->addPortsList(value);
}

/**
* @brief   Create vip by ID
*
* Create operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value vipbody object
*
* Responses:
*
*/
void
create_katran_vip_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &value) {
  auto katran = get_cube(name);

  return katran->addVip(address, port, proto, value);
}

/**
* @brief   Create vip by ID
*
* Create operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] value vipbody object
*
* Responses:
*
*/
void
create_katran_vip_list_by_id(const std::string &name, const std::vector<VipJsonObject> &value) {
  auto katran = get_cube(name);
  katran->addVipList(value);
}

/**
* @brief   Create real by ID
*
* Create operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value realbody object
*
* Responses:
*
*/
void
create_katran_vip_real_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip, const VipRealJsonObject &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);

  return vip->addReal(ip, value);
}

/**
* @brief   Create real by ID
*
* Create operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value realbody object
*
* Responses:
*
*/
void
create_katran_vip_real_list_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::vector<VipRealJsonObject> &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  vip->addRealList(value);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_katran_ports_by_id(const std::string &name, const std::string &portsName) {
  auto katran = get_cube(name);

  return katran->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_katran_ports_list_by_id(const std::string &name) {
  auto katran = get_cube(name);
  katran->delPortsList();
}

/**
* @brief   Delete vip by ID
*
* Delete operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_katran_vip_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  auto katran = get_cube(name);

  return katran->delVip(address, port, proto);
}

/**
* @brief   Delete vip by ID
*
* Delete operation of resource: vip*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_katran_vip_list_by_id(const std::string &name) {
  auto katran = get_cube(name);
  katran->delVipList();
}

/**
* @brief   Delete real by ID
*
* Delete operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
*
*/
void
delete_katran_vip_real_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);

  return vip->delReal(ip);
}

/**
* @brief   Delete real by ID
*
* Delete operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_katran_vip_real_list_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  vip->delRealList();
}

/**
* @brief   Read katran by ID
*
* Read operation of resource: katran*
*
* @param[in] name ID of name
*
* Responses:
* KatranJsonObject
*/
KatranJsonObject
read_katran_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read chRingSize by ID
*
* Read operation of resource: chRingSize*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_katran_ch_ring_size_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getChRingSize();

}

/**
* @brief   Read defaultMac by ID
*
* Read operation of resource: defaultMac*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_katran_default_mac_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getDefaultMac();

}

/**
* @brief   Read dyn-opt by ID
*
* Read operation of resource: dyn-opt*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_katran_dyn_opt_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getDynOpt();

}

/**
* @brief   Read enableHc by ID
*
* Read operation of resource: enableHc*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_katran_enable_hc_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getEnableHc();

}

/**
* @brief   Read forwardingCores by ID
*
* Read operation of resource: forwardingCores*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_katran_forwarding_cores_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getForwardingCores();

}

/**
* @brief   Read generalStats by ID
*
* Read operation of resource: generalStats*
*
* @param[in] name ID of name
*
* Responses:
* GeneralStatsJsonObject
*/
GeneralStatsJsonObject
read_katran_general_stats_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getGeneralStats()->toJsonObject();

}

/**
* @brief   Read v1 by ID
*
* Read operation of resource: v1*
*
* @param[in] name ID of name
*
* Responses:
* uint64_t
*/
uint64_t
read_katran_general_stats_v1_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getV1();

}

/**
* @brief   Read v2 by ID
*
* Read operation of resource: v2*
*
* @param[in] name ID of name
*
* Responses:
* uint64_t
*/
uint64_t
read_katran_general_stats_v2_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto generalStats = katran->getGeneralStats();
  return generalStats->getV2();

}

/**
* @brief   Read lruSize by ID
*
* Read operation of resource: lruSize*
*
* @param[in] name ID of name
*
* Responses:
* uint64_t
*/
uint64_t
read_katran_lru_size_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getLruSize();

}

/**
* @brief   Read maxReals by ID
*
* Read operation of resource: maxReals*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_katran_max_reals_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getMaxReals();

}

/**
* @brief   Read maxVips by ID
*
* Read operation of resource: maxVips*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_katran_max_vips_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getMaxVips();

}

/**
* @brief   Read numaNodes by ID
*
* Read operation of resource: numaNodes*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_katran_numa_nodes_by_id(const std::string &name) {
  auto katran = get_cube(name);
  return katran->getNumaNodes();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_katran_ports_by_id(const std::string &name, const std::string &portsName) {
  auto katran = get_cube(name);
  return katran->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_katran_ports_list_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto &&ports = katran->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read vip by ID
*
* Read operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
*
* Responses:
* VipJsonObject
*/
VipJsonObject
read_katran_vip_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  auto katran = get_cube(name);
  return katran->getVip(address, port, proto)->toJsonObject();

}

/**
* @brief   Read flags by ID
*
* Read operation of resource: flags*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
*
* Responses:
* uint32_t
*/
uint32_t
read_katran_vip_flags_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  return vip->getFlags();

}

/**
* @brief   Read vip by ID
*
* Read operation of resource: vip*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<VipJsonObject>
*/
std::vector<VipJsonObject>
read_katran_vip_list_by_id(const std::string &name) {
  auto katran = get_cube(name);
  auto &&vip = katran->getVipList();
  std::vector<VipJsonObject> m;
  for(auto &i : vip)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read real by ID
*
* Read operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* VipRealJsonObject
*/
VipRealJsonObject
read_katran_vip_real_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  return vip->getReal(ip)->toJsonObject();

}

/**
* @brief   Read flags by ID
*
* Read operation of resource: flags*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* uint32_t
*/
uint32_t
read_katran_vip_real_flags_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto real = vip->getReal(ip);
  return real->getFlags();

}

/**
* @brief   Read real by ID
*
* Read operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
*
* Responses:
* std::vector<VipRealJsonObject>
*/
std::vector<VipRealJsonObject>
read_katran_vip_real_list_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto &&real = vip->getRealList();
  std::vector<VipRealJsonObject> m;
  for(auto &i : real)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read weight by ID
*
* Read operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
*
* Responses:
* uint16_t
*/
uint16_t
read_katran_vip_real_weight_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto real = vip->getReal(ip);
  return real->getWeight();

}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_katran_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto katran = get_cube(name);

  return katran->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_katran_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace vip by ID
*
* Replace operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value vipbody object
*
* Responses:
*
*/
void
replace_katran_vip_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &value) {
  auto katran = get_cube(name);

  return katran->replaceVip(address, port, proto, value);
}

/**
* @brief   Replace vip by ID
*
* Replace operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] value vipbody object
*
* Responses:
*
*/
void
replace_katran_vip_list_by_id(const std::string &name, const std::vector<VipJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace real by ID
*
* Replace operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value realbody object
*
* Responses:
*
*/
void
replace_katran_vip_real_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip, const VipRealJsonObject &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);

  return vip->replaceReal(ip, value);
}

/**
* @brief   Replace real by ID
*
* Replace operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value realbody object
*
* Responses:
*
*/
void
replace_katran_vip_real_list_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::vector<VipRealJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update katran by ID
*
* Update operation of resource: katran*
*
* @param[in] name ID of name
* @param[in] value katranbody object
*
* Responses:
*
*/
void
update_katran_by_id(const std::string &name, const KatranJsonObject &value) {
  auto katran = get_cube(name);

  return katran->update(value);
}

/**
* @brief   Update chRingSize by ID
*
* Update operation of resource: chRingSize*
*
* @param[in] name ID of name
* @param[in] value Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
*
* Responses:
*
*/
void
update_katran_ch_ring_size_by_id(const std::string &name, const uint32_t &value) {
  auto katran = get_cube(name);

  return katran->setChRingSize(value);
}

/**
* @brief   Update defaultMac by ID
*
* Update operation of resource: defaultMac*
*
* @param[in] name ID of name
* @param[in] value mac address of default router. katran &#39;offloads&#39; forwarding to the top of the rack switch (by simply sending everything to it by default).
*
* Responses:
*
*/
void
update_katran_default_mac_by_id(const std::string &name, const std::string &value) {
  auto katran = get_cube(name);

  return katran->setDefaultMac(value);
}

/**
* @brief   Update enableHc by ID
*
* Update operation of resource: enableHc*
*
* @param[in] name ID of name
* @param[in] value Flag to indicate if healthchecking forwarding plane should be enabled or not.
*
* Responses:
*
*/
void
update_katran_enable_hc_by_id(const std::string &name, const bool &value) {
  auto katran = get_cube(name);

  return katran->setEnableHc(value);
}

/**
* @brief   Update forwardingCores by ID
*
* Update operation of resource: forwardingCores*
*
* @param[in] name ID of name
* @param[in] value ID of cpu cores which are responsible for the packet forwarding
*
* Responses:
*
*/
void
update_katran_forwarding_cores_by_id(const std::string &name, const std::string &value) {
  auto katran = get_cube(name);

  return katran->setForwardingCores(value);
}

/**
* @brief   Update katran by ID
*
* Update operation of resource: katran*
*
* @param[in] value katranbody object
*
* Responses:
*
*/
void
update_katran_list_by_id(const std::vector<KatranJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update lruSize by ID
*
* Update operation of resource: lruSize*
*
* @param[in] name ID of name
* @param[in] value The size of connection table (number of flows which we are going to track)
*
* Responses:
*
*/
void
update_katran_lru_size_by_id(const std::string &name, const uint64_t &value) {
  auto katran = get_cube(name);

  return katran->setLruSize(value);
}

/**
* @brief   Update maxReals by ID
*
* Update operation of resource: maxReals*
*
* @param[in] name ID of name
* @param[in] value Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
*
* Responses:
*
*/
void
update_katran_max_reals_by_id(const std::string &name, const uint32_t &value) {
  auto katran = get_cube(name);

  return katran->setMaxReals(value);
}

/**
* @brief   Update maxVips by ID
*
* Update operation of resource: maxVips*
*
* @param[in] name ID of name
* @param[in] value Maximum number of VIPs supported by katran. It must be in sync with configuration of forwarding plane
*
* Responses:
*
*/
void
update_katran_max_vips_by_id(const std::string &name, const uint32_t &value) {
  auto katran = get_cube(name);

  return katran->setMaxVips(value);
}

/**
* @brief   Update numaNodes by ID
*
* Update operation of resource: numaNodes*
*
* @param[in] name ID of name
* @param[in] value ID of the numa node associated to the forwarding cores
*
* Responses:
*
*/
void
update_katran_numa_nodes_by_id(const std::string &name, const std::string &value) {
  auto katran = get_cube(name);

  return katran->setNumaNodes(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_katran_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto katran = get_cube(name);
  auto ports = katran->getPorts(portsName);

  return ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_katran_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update vip by ID
*
* Update operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value vipbody object
*
* Responses:
*
*/
void
update_katran_vip_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);

  return vip->update(value);
}

/**
* @brief   Update flags by ID
*
* Update operation of resource: flags*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value Flags used in the VIP
*
* Responses:
*
*/
void
update_katran_vip_flags_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const uint32_t &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);

  return vip->setFlags(value);
}

/**
* @brief   Update vip by ID
*
* Update operation of resource: vip*
*
* @param[in] name ID of name
* @param[in] value vipbody object
*
* Responses:
*
*/
void
update_katran_vip_list_by_id(const std::string &name, const std::vector<VipJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update real by ID
*
* Update operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value realbody object
*
* Responses:
*
*/
void
update_katran_vip_real_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip, const VipRealJsonObject &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto real = vip->getReal(ip);

  return real->update(value);
}

/**
* @brief   Update flags by ID
*
* Update operation of resource: flags*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value Flags used in the Reals
*
* Responses:
*
*/
void
update_katran_vip_real_flags_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip, const uint32_t &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto real = vip->getReal(ip);

  return real->setFlags(value);
}

/**
* @brief   Update real by ID
*
* Update operation of resource: real*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] value realbody object
*
* Responses:
*
*/
void
update_katran_vip_real_list_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::vector<VipRealJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update weight by ID
*
* Update operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] port ID of port
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] value Weight of the backend in the pool
*
* Responses:
*
*/
void
update_katran_vip_real_weight_by_id(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const std::string &ip, const uint16_t &value) {
  auto katran = get_cube(name);
  auto vip = katran->getVip(address, port, proto);
  auto real = vip->getReal(ip);

  return real->setWeight(value);
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_katran_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&katran = get_cube(name);

  auto &&ports = katran->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_katran_vip_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&katran = get_cube(name);

  auto &&vip = katran->getVipList();
  for(auto &i : vip) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["address"] = i->getAddress();
    keys["port"] = std::to_string(i->getPort());
    keys["proto"] = VipJsonObject::VipProtoEnum_to_string(i->getProto());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_katran_vip_real_list_by_id_get_list(const std::string &name, const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&katran = get_cube(name);
  auto &&vip = katran->getVip(address, port, proto);

  auto &&real = vip->getRealList();
  for(auto &i : real) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

