/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "KatranApi.h"
#include "KatranApiImpl.h"

using namespace polycube::service::model;
using namespace polycube::service::api::KatranApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_katran_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    KatranJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_katran_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_general_stats_get_icmp_too_big_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_katran_general_stats_get_icmp_too_big_stats_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_general_stats_get_lru_fallback_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_katran_general_stats_get_lru_fallback_stats_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_general_stats_get_lru_miss_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_katran_general_stats_get_lru_miss_stats_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_general_stats_get_lru_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = create_katran_general_stats_get_lru_stats_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_general_stats_get_vip_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    GeneralStatsGetVipStatsInputJsonObject unique_value { request_body };


    auto x = create_katran_general_stats_get_vip_stats_by_id(unique_name, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    create_katran_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    create_katran_ports_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_vip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    unique_value.setPort(unique_port);
    unique_value.setProto(unique_proto_);
    create_katran_vip_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_vip_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<VipJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipJsonObject> unique_value;
    for (auto &j : request_body) {
      VipJsonObject a { j };
      unique_value.push_back(a);
    }
    create_katran_vip_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_vip_real_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipRealJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    create_katran_vip_real_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_katran_vip_real_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  // Getting the body param
  std::vector<VipRealJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipRealJsonObject> unique_value;
    for (auto &j : request_body) {
      VipRealJsonObject a { j };
      unique_value.push_back(a);
    }
    create_katran_vip_real_list_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_katran_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_katran_ports_by_id(unique_name, unique_portsName);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_katran_ports_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_vip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    delete_katran_vip_by_id(unique_name, unique_address, unique_port, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_vip_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_katran_vip_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_vip_real_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_katran_vip_real_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_katran_vip_real_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    delete_katran_vip_real_list_by_id(unique_name, unique_address, unique_port, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_ch_ring_size_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_ch_ring_size_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_default_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_default_mac_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_dyn_opt_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_dyn_opt_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_enable_hc_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_enable_hc_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_forwarding_cores_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_forwarding_cores_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_general_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_general_stats_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_general_stats_v1_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_general_stats_v1_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_general_stats_v2_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_general_stats_v2_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_katran_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_lru_size_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_lru_size_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_max_reals_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_max_reals_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_max_vips_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_max_vips_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_numa_nodes_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_numa_nodes_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_katran_ports_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_ports_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {

    auto x = read_katran_vip_by_id(unique_name, unique_address, unique_port, unique_proto_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_flags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {

    auto x = read_katran_vip_flags_by_id(unique_name, unique_address, unique_port, unique_proto_);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_katran_vip_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_real_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_katran_vip_real_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_real_flags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_katran_vip_real_flags_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_real_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {

    auto x = read_katran_vip_real_list_by_id(unique_name, unique_address, unique_port, unique_proto_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_katran_vip_real_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_katran_vip_real_weight_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    KatranJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_katran_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    replace_katran_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_katran_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_vip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    unique_value.setPort(unique_port);
    unique_value.setProto(unique_proto_);
    replace_katran_vip_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_vip_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<VipJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipJsonObject> unique_value;
    for (auto &j : request_body) {
      VipJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_katran_vip_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_vip_real_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipRealJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    replace_katran_vip_real_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_katran_vip_real_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  // Getting the body param
  std::vector<VipRealJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipRealJsonObject> unique_value;
    for (auto &j : request_body) {
      VipRealJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_katran_vip_real_list_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    KatranJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_katran_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_ch_ring_size_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_katran_ch_ring_size_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_default_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_katran_default_mac_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_enable_hc_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    bool unique_value = request_body;
    update_katran_enable_hc_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_forwarding_cores_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_katran_forwarding_cores_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<KatranJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<KatranJsonObject> unique_value;
    for (auto &j : request_body) {
      KatranJsonObject a { j };
      unique_value.push_back(a);
    }
    update_katran_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_lru_size_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint64_t unique_value = request_body;
    update_katran_lru_size_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_max_reals_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_katran_max_reals_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_max_vips_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_katran_max_vips_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_numa_nodes_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_katran_numa_nodes_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    update_katran_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    update_katran_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    unique_value.setPort(unique_port);
    unique_value.setProto(unique_proto_);
    update_katran_vip_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_flags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_katran_vip_flags_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<VipJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipJsonObject> unique_value;
    for (auto &j : request_body) {
      VipJsonObject a { j };
      unique_value.push_back(a);
    }
    update_katran_vip_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_real_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    VipRealJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    update_katran_vip_real_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_real_flags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint32_t unique_value = request_body;
    update_katran_vip_real_flags_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_real_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  // Getting the body param
  std::vector<VipRealJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<VipRealJsonObject> unique_value;
    for (auto &j : request_body) {
      VipRealJsonObject a { j };
      unique_value.push_back(a);
    }
    update_katran_vip_real_list_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_katran_vip_real_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_katran_vip_real_weight_by_id(unique_name, unique_address, unique_port, unique_proto_, unique_ip, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response katran_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_katran_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response katran_ports_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_katran_ports_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response katran_vip_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_katran_vip_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response katran_vip_real_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = VipJsonObject::string_to_VipProtoEnum(unique_proto);

  nlohmann::json val = read_katran_vip_real_list_by_id_get_list(unique_name, unique_address, unique_port, unique_proto_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

