/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


#pragma once


#include "../base/VipBase.h"

#include "VipReal.h"
#include "CHHelpers.h"
#include "KatranLbStructs.h"
#include "IpHelpers.h"

class Katran;

using namespace polycube::service::model;

enum class ModifyAction {
    ADD,
    DEL,
};

struct RealPos {
  uint32_t real;
  uint32_t pos;
};

/**
 * struct which is used by Vip class to store real's related metadata
 * such as real's weight and hash
 */
struct VipRealMeta {
  uint32_t weight;
  uint64_t hash;
};

struct UpdateReal {
  ModifyAction action;
  katran::Endpoint updatedReal;
};

class Vip : public VipBase {
  friend class Katran;
 public:
  Vip() = delete;
  explicit Vip(Katran &parent, uint32_t vipNum, const VipJsonObject &conf, const katran::KatranConfig &katranConfig);
  virtual ~Vip();

  /// <summary>
  /// Virtual IP (vip) of the service where clients connect to
  /// </summary>
  std::string getAddress() override;

  /// <summary>
  /// Port of the virtual server where clients connect to (this value is ignored in case of ICMP)
  /// </summary>
  uint16_t getPort() override;

  /// <summary>
  /// Upper-layer protocol associated with a loadbalancing service instance. &#39;ALL&#39; creates an entry for all the supported protocols
  /// </summary>
  VipProtoEnum getProto() override;

  /// <summary>
  /// Flags used in the VIP
  /// </summary>
  uint32_t getFlags() override;
  void setFlags(const uint32_t &value) override;

  /// <summary>
  /// Pool of backend servers that actually serve requests
  /// </summary>
  std::shared_ptr<VipReal> getReal(const std::string &address) override;
  std::vector<std::shared_ptr<VipReal>> getRealList() override;
  void addReal(const std::string &address, const VipRealJsonObject &conf) override;
  void addRealList(const std::vector<VipRealJsonObject> &conf) override;
  void replaceReal(const std::string &address, const VipRealJsonObject &conf) override;
  void delReal(const std::string &address) override;
  void delRealList() override;
  void updateVipMap(const ModifyAction &action);

  bool modifyRealsForVip(const ModifyAction &action, const std::vector<katran::NewReal>& reals);
  uint32_t getVipNum();

  private:
  std::vector<uint32_t> getReals();
  std::vector<RealPos> batchRealsUpdate(std::vector<UpdateReal>& ureals);
  std::vector<katran::Endpoint> getEndpoints(std::vector<UpdateReal>& ureals);
  std::vector<RealPos> calculateHashRing(std::vector<katran::Endpoint> endpoints);
  void programHashRing(const std::vector<RealPos>& chPositions, const uint32_t vipNum);
  std::vector<katran::Endpoint> getRealsAndWeight();

  private:
  std::string address_;
  std::uint16_t port_;
  VipProtoEnum proto_;

  /**
   * number which uniquely identifies this vip
   * (also used as an index inside forwarding table)
   */
  uint32_t vipNum_;

  /**
   * vip related flags (such as "dont use src port for hashing" etc)
   */
  uint32_t vipFlags_;
  bool flagsAreSet_;

  /**
   * size of ch ring
   */
  uint32_t chRingSize_;

  /**
   * ch ring which is used for this vip. we are going to use it
   * for delta computation (between old and new ch rings)
   */
  std::vector<int> chRing_;

  /**
   * hash function to generate hash ring
   */
  std::unique_ptr<katran::ConsistentHash> chash_;

  /**
   * map of reals (theirs opaque id). the value is a real's related
   * metadata (weight and per real hash value).
   */
  std::unordered_map<uint32_t, VipRealMeta> reals_;
};
